/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Component;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.UserFunctionCall;
import net.sf.saxon.expr.instruct.UserFunction;
import net.sf.saxon.functions.FunctionLibrary;
import net.sf.saxon.style.StylesheetFunctionLibrary;
import net.sf.saxon.style.StylesheetPackage;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.Visibility;
import net.sf.saxon.trans.XPathException;

public class PublicStylesheetFunctionLibrary
implements FunctionLibrary {
    private FunctionLibrary base;

    public PublicStylesheetFunctionLibrary(FunctionLibrary base) {
        this.base = base;
    }

    public Expression bind(SymbolicName.F functionName, Expression[] staticArgs, StaticContext env) throws XPathException {
        Component target;
        Visibility v;
        Expression baseCall = this.base.bind(functionName, staticArgs, env);
        if (baseCall instanceof UserFunctionCall && ((v = (target = ((UserFunctionCall)baseCall).getTarget()).getVisibility()) == Visibility.PUBLIC || v == Visibility.FINAL)) {
            return baseCall;
        }
        return null;
    }

    public boolean isAvailable(SymbolicName.F functionName) {
        if (this.base instanceof StylesheetFunctionLibrary) {
            StylesheetPackage pack = ((StylesheetFunctionLibrary)this.base).getStylesheetPackage();
            UserFunction fn = pack.getFunction(functionName);
            if (fn != null) {
                Visibility v = fn.getDeclaredVisibility();
                return v == Visibility.PUBLIC || v == Visibility.FINAL;
            }
            return false;
        }
        return this.base.isAvailable(functionName);
    }

    public FunctionLibrary copy() {
        return this;
    }
}

