# Generated by default/object.tt
package Paws::LookoutMetrics::Alert;
  use Moose;
  has Action => (is => 'ro', isa => 'Paws::LookoutMetrics::Action');
  has AlertArn => (is => 'ro', isa => 'Str');
  has AlertDescription => (is => 'ro', isa => 'Str');
  has AlertName => (is => 'ro', isa => 'Str');
  has AlertSensitivityThreshold => (is => 'ro', isa => 'Int');
  has AlertStatus => (is => 'ro', isa => 'Str');
  has AlertType => (is => 'ro', isa => 'Str');
  has AnomalyDetectorArn => (is => 'ro', isa => 'Str');
  has CreationTime => (is => 'ro', isa => 'Str');
  has LastModificationTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutMetrics::Alert

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutMetrics::Alert object:

  $service_obj->Method(Att1 => { Action => $value, ..., LastModificationTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutMetrics::Alert object:

  $result = $service_obj->Method(...);
  $result->Att1->Action

=head1 DESCRIPTION

A configuration for Amazon SNS-integrated notifications.

=head1 ATTRIBUTES


=head2 Action => L<Paws::LookoutMetrics::Action>

Action that will be triggered when there is an alert.


=head2 AlertArn => Str

The ARN of the alert.


=head2 AlertDescription => Str

A description of the alert.


=head2 AlertName => Str

The name of the alert.


=head2 AlertSensitivityThreshold => Int

The minimum severity for an anomaly to trigger the alert.


=head2 AlertStatus => Str

The status of the alert.


=head2 AlertType => Str

The type of the alert.


=head2 AnomalyDetectorArn => Str

The ARN of the detector to which the alert is attached.


=head2 CreationTime => Str

The time at which the alert was created.


=head2 LastModificationTime => Str

The time at which the alert was last modified.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutMetrics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

