# Generated by default/object.tt
package Paws::Macie2::FindingActor;
  use Moose;
  has DomainDetails => (is => 'ro', isa => 'Paws::Macie2::DomainDetails', request_name => 'domainDetails', traits => ['NameInRequest']);
  has IpAddressDetails => (is => 'ro', isa => 'Paws::Macie2::IpAddressDetails', request_name => 'ipAddressDetails', traits => ['NameInRequest']);
  has UserIdentity => (is => 'ro', isa => 'Paws::Macie2::UserIdentity', request_name => 'userIdentity', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::FindingActor

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::FindingActor object:

  $service_obj->Method(Att1 => { DomainDetails => $value, ..., UserIdentity => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::FindingActor object:

  $result = $service_obj->Method(...);
  $result->Att1->DomainDetails

=head1 DESCRIPTION

Provides information about an entity that performed an action that
produced a policy finding for a resource.

=head1 ATTRIBUTES


=head2 DomainDetails => L<Paws::Macie2::DomainDetails>

The domain name of the device that the entity used to perform the
action on the affected resource.


=head2 IpAddressDetails => L<Paws::Macie2::IpAddressDetails>

The IP address of the device that the entity used to perform the action
on the affected resource. This object also provides information such as
the owner and geographic location for the IP address.


=head2 UserIdentity => L<Paws::Macie2::UserIdentity>

The type and other characteristics of the entity that performed the
action on the affected resource.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

