# Generated by default/object.tt
package Paws::Macie2::JobSummary;
  use Moose;
  has BucketCriteria => (is => 'ro', isa => 'Paws::Macie2::S3BucketCriteriaForJob', request_name => 'bucketCriteria', traits => ['NameInRequest']);
  has BucketDefinitions => (is => 'ro', isa => 'ArrayRef[Paws::Macie2::S3BucketDefinitionForJob]', request_name => 'bucketDefinitions', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has JobId => (is => 'ro', isa => 'Str', request_name => 'jobId', traits => ['NameInRequest']);
  has JobStatus => (is => 'ro', isa => 'Str', request_name => 'jobStatus', traits => ['NameInRequest']);
  has JobType => (is => 'ro', isa => 'Str', request_name => 'jobType', traits => ['NameInRequest']);
  has LastRunErrorStatus => (is => 'ro', isa => 'Paws::Macie2::LastRunErrorStatus', request_name => 'lastRunErrorStatus', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has UserPausedDetails => (is => 'ro', isa => 'Paws::Macie2::UserPausedDetails', request_name => 'userPausedDetails', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::JobSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::JobSummary object:

  $service_obj->Method(Att1 => { BucketCriteria => $value, ..., UserPausedDetails => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::JobSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->BucketCriteria

=head1 DESCRIPTION

Provides information about a classification job, including the current
status of the job.

=head1 ATTRIBUTES


=head2 BucketCriteria => L<Paws::Macie2::S3BucketCriteriaForJob>

The property- and tag-based conditions that determine which S3 buckets
are included or excluded from the job's analysis. Each time the job
runs, the job uses these criteria to determine which buckets to
analyze. A job's definition can contain a bucketCriteria object or a
bucketDefinitions array, not both.


=head2 BucketDefinitions => ArrayRef[L<Paws::Macie2::S3BucketDefinitionForJob>]

An array of objects, one for each Amazon Web Services account that owns
specific S3 buckets for the job to analyze. Each object specifies the
account ID for an account and one or more buckets to analyze for that
account. A job's definition can contain a bucketDefinitions array or a
bucketCriteria object, not both.


=head2 CreatedAt => Str

The date and time, in UTC and extended ISO 8601 format, when the job
was created.


=head2 JobId => Str

The unique identifier for the job.


=head2 JobStatus => Str

The current status of the job. Possible values are:

=over

=item *

CANCELLED - You cancelled the job or, if it's a one-time job, you
paused the job and didn't resume it within 30 days.

=item *

COMPLETE - For a one-time job, Amazon Macie finished processing the
data specified for the job. This value doesn't apply to recurring jobs.

=item *

IDLE - For a recurring job, the previous scheduled run is complete and
the next scheduled run is pending. This value doesn't apply to one-time
jobs.

=item *

PAUSED - Amazon Macie started running the job but additional processing
would exceed the monthly sensitive data discovery quota for your
account or one or more member accounts that the job analyzes data for.

=item *

RUNNING - For a one-time job, the job is in progress. For a recurring
job, a scheduled run is in progress.

=item *

USER_PAUSED - You paused the job. If you paused the job while it had a
status of RUNNING and you don't resume it within 30 days of pausing it,
the job or job run will expire and be cancelled, depending on the job's
type. To check the expiration date, refer to the
UserPausedDetails.jobExpiresAt property.

=back



=head2 JobType => Str

The schedule for running the job. Possible values are:

=over

=item *

ONE_TIME - The job runs only once.

=item *

SCHEDULED - The job runs on a daily, weekly, or monthly basis.

=back



=head2 LastRunErrorStatus => L<Paws::Macie2::LastRunErrorStatus>

Specifies whether any account- or bucket-level access errors occurred
when the job ran. For a recurring job, this value indicates the error
status of the job's most recent run.


=head2 Name => Str

The custom name of the job.


=head2 UserPausedDetails => L<Paws::Macie2::UserPausedDetails>

If the current status of the job is USER_PAUSED, specifies when the job
was paused and when the job or job run will expire and be cancelled if
it isn't resumed. This value is present only if the value for jobStatus
is USER_PAUSED.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

