# Generated by default/object.tt
package Paws::Robomaker::WorldGenerationJobSummary;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has FailedWorldCount => (is => 'ro', isa => 'Int', request_name => 'failedWorldCount', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has SucceededWorldCount => (is => 'ro', isa => 'Int', request_name => 'succeededWorldCount', traits => ['NameInRequest']);
  has Template => (is => 'ro', isa => 'Str', request_name => 'template', traits => ['NameInRequest']);
  has WorldCount => (is => 'ro', isa => 'Paws::Robomaker::WorldCount', request_name => 'worldCount', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Robomaker::WorldGenerationJobSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Robomaker::WorldGenerationJobSummary object:

  $service_obj->Method(Att1 => { Arn => $value, ..., WorldCount => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Robomaker::WorldGenerationJobSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Information about a world generator job.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the world generator job.


=head2 CreatedAt => Str

The time, in milliseconds since the epoch, when the world generator job
was created.


=head2 FailedWorldCount => Int

The number of worlds that failed.


=head2 Status => Str

The status of the world generator job:

=over

=item Pending

The world generator job request is pending.

=item Running

The world generator job is running.

=item Completed

The world generator job completed.

=item Failed

The world generator job failed. See C<failureCode> for more
information.

=item PartialFailed

Some worlds did not generate.

=item Canceled

The world generator job was cancelled.

=item Canceling

The world generator job is being cancelled.

=back



=head2 SucceededWorldCount => Int

The number of worlds that were generated.


=head2 Template => Str

The Amazon Resource Name (arn) of the world template.


=head2 WorldCount => L<Paws::Robomaker::WorldCount>

Information about the world count.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Robomaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

