# Generated by default/object.tt
package Paws::S3::IntelligentTieringConfiguration;
  use Moose;
  has Filter => (is => 'ro', isa => 'Paws::S3::IntelligentTieringFilter');
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has Status => (is => 'ro', isa => 'Str', required => 1);
  has Tierings => (is => 'ro', isa => 'ArrayRef[Paws::S3::Tiering]', request_name => 'Tiering', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3::IntelligentTieringConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3::IntelligentTieringConfiguration object:

  $service_obj->Method(Att1 => { Filter => $value, ..., Tierings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3::IntelligentTieringConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->Filter

=head1 DESCRIPTION

Specifies the S3 Intelligent-Tiering configuration for an Amazon S3
bucket.

For information about the S3 Intelligent-Tiering storage class, see
Storage class for automatically optimizing frequently and infrequently
accessed objects
(https://docs.aws.amazon.com/AmazonS3/latest/dev/storage-class-intro.html#sc-dynamic-data-access).

=head1 ATTRIBUTES


=head2 Filter => L<Paws::S3::IntelligentTieringFilter>

Specifies a bucket filter. The configuration only includes objects that
meet the filter's criteria.


=head2 B<REQUIRED> Id => Str

The ID used to identify the S3 Intelligent-Tiering configuration.


=head2 B<REQUIRED> Status => Str

Specifies the status of the configuration.


=head2 B<REQUIRED> Tierings => ArrayRef[L<Paws::S3::Tiering>]

Specifies the S3 Intelligent-Tiering storage class tier of the
configuration.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

