# Generated by default/object.tt
package Paws::SageMaker::OfflineStoreConfig;
  use Moose;
  has DataCatalogConfig => (is => 'ro', isa => 'Paws::SageMaker::DataCatalogConfig');
  has DisableGlueTableCreation => (is => 'ro', isa => 'Bool');
  has S3StorageConfig => (is => 'ro', isa => 'Paws::SageMaker::S3StorageConfig', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::OfflineStoreConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::OfflineStoreConfig object:

  $service_obj->Method(Att1 => { DataCatalogConfig => $value, ..., S3StorageConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::OfflineStoreConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->DataCatalogConfig

=head1 DESCRIPTION

The configuration of an C<OfflineStore>.

Provide an C<OfflineStoreConfig> in a request to C<CreateFeatureGroup>
to create an C<OfflineStore>.

To encrypt an C<OfflineStore> using at rest data encryption, specify
Amazon Web Services Key Management Service (KMS) key ID, or
C<KMSKeyId>, in C<S3StorageConfig>.

=head1 ATTRIBUTES


=head2 DataCatalogConfig => L<Paws::SageMaker::DataCatalogConfig>

The meta data of the Glue table that is autogenerated when an
C<OfflineStore> is created.


=head2 DisableGlueTableCreation => Bool

Set to C<True> to disable the automatic creation of an Amazon Web
Services Glue table when configuring an C<OfflineStore>.


=head2 B<REQUIRED> S3StorageConfig => L<Paws::SageMaker::S3StorageConfig>

The Amazon Simple Storage (Amazon S3) location of C<OfflineStore>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

