# Generated by default/object.tt
package Paws::FIS::CreateExperimentTemplateTargetInput;
  use Moose;
  has Filters => (is => 'ro', isa => 'ArrayRef[Paws::FIS::ExperimentTemplateTargetInputFilter]', request_name => 'filters', traits => ['NameInRequest']);
  has ResourceArns => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'resourceArns', traits => ['NameInRequest']);
  has ResourceTags => (is => 'ro', isa => 'Paws::FIS::TagMap', request_name => 'resourceTags', traits => ['NameInRequest']);
  has ResourceType => (is => 'ro', isa => 'Str', request_name => 'resourceType', traits => ['NameInRequest'], required => 1);
  has SelectionMode => (is => 'ro', isa => 'Str', request_name => 'selectionMode', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FIS::CreateExperimentTemplateTargetInput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FIS::CreateExperimentTemplateTargetInput object:

  $service_obj->Method(Att1 => { Filters => $value, ..., SelectionMode => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FIS::CreateExperimentTemplateTargetInput object:

  $result = $service_obj->Method(...);
  $result->Att1->Filters

=head1 DESCRIPTION

Specifies a target for an experiment. You must specify at least one
Amazon Resource Name (ARN) or at least one resource tag. You cannot
specify both ARNs and tags.

=head1 ATTRIBUTES


=head2 Filters => ArrayRef[L<Paws::FIS::ExperimentTemplateTargetInputFilter>]

The filters to apply to identify target resources using specific
attributes.


=head2 ResourceArns => ArrayRef[Str|Undef]

The Amazon Resource Names (ARNs) of the resources.


=head2 ResourceTags => L<Paws::FIS::TagMap>

The tags for the target resources.


=head2 B<REQUIRED> ResourceType => Str

The AWS resource type. The resource type must be supported for the
specified action.


=head2 B<REQUIRED> SelectionMode => Str

Scopes the identified resources to a specific count of the resources at
random, or a percentage of the resources. All identified resources are
included in the target.

=over

=item *

ALL - Run the action on all identified targets. This is the default.

=item *

COUNT(n) - Run the action on the specified number of targets, chosen
from the identified targets at random. For example, COUNT(1) selects
one of the targets.

=item *

PERCENT(n) - Run the action on the specified percentage of targets,
chosen from the identified targets at random. For example, PERCENT(25)
selects 25% of the targets.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FIS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

