use strict;
use warnings;
use Test::More;

use Mail::Sendmail::Enhanced;

my $mail = Mail::Sendmail::Enhanced-> new (
	smtp		=> 'mail.webswing.co.uk',
	from		=> 'wb@wenswing.co.uk',
	user		=> '',
	pass		=> '',
	method		=> 'LOGIN',
	charset		=> 'utf-8',
	required	=> 1,
);

plan tests => 2;

ok ( $mail->{smtp} eq 'mail.webswing.co.uk' );

ok ( $mail->encode_qp('ąćęłńóśźż1234567890ĄĆĘŁŃÓŚŹŻ0987654321ąćęłńóśźż1234567890ĄĆĘŁŃÓŚŹŻ0987654321ąćęłńóśźż1234567890ĄĆĘŁŃÓŚŹŻ0987654321')
eq '=C4=85=C4=87=C4=99=C5=82=C5=84=C3=B3=C5=9B=C5=BA=C5=BC1234567890=C4=
 =84=C4=86=C4=98=C5=81=C5=83=C3=93=C5=9A=C5=B9=C5=BB0987654321=C4=85=
 =C4=87=C4=99=C5=82=C5=84=C3=B3=C5=9B=C5=BA=C5=BC1234567890=C4=84=C4=
 =86=C4=98=C5=81=C5=83=C3=93=C5=9A=C5=B9=C5=BB0987654321=C4=85=C4=87=
 =C4=99=C5=82=C5=84=C3=B3=C5=9B=C5=BA=C5=BC1234567890=C4=84=C4=86=C4=
 =98=C5=81=C5=83=C3=93=C5=9A=C5=B9=C5=BB0987654321
' );
