# Generated by default/object.tt
package Paws::CostExplorer::Subscriber;
  use Moose;
  has Address => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has Type => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::Subscriber

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::Subscriber object:

  $service_obj->Method(Att1 => { Address => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::Subscriber object:

  $result = $service_obj->Method(...);
  $result->Att1->Address

=head1 DESCRIPTION

The recipient of C<AnomalySubscription> notifications.

=head1 ATTRIBUTES


=head2 Address => Str

The email address or SNS Amazon Resource Name (ARN), depending on the
C<Type>.


=head2 Status => Str

Indicates if the subscriber accepts the notifications.


=head2 Type => Str

The notification delivery channel.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

