# ----------------------------------------------------------------
    use strict;
    use Test::More tests => 21;
    BEGIN { use_ok('XML::FeedPP') };
# ----------------------------------------------------------------
=rfc733

date        =  1*2DIGIT ["-"] month         ; day month year
               ["-"] (2DIGIT /4DIGIT)       ;  e.g. 20 Aug [19]77

see also:
http://bugs.debian.org/cgi-bin/bugreport.cgi?bug=503260

=cut
# ----------------------------------------------------------------
{
    my $rfc2822_2dy = {
        '300032400'     =>  'Thu, 05 Jul 79 14:20:00 GMT',
        '500032400'     =>  'Tue, 05 Nov 85 09:53:20 GMT',
        '700032400'     =>  'Sun, 08 Mar 92 05:26:40 GMT',
        '900032400'     =>  'Fri, 10 Jul 98 01:00:00 GMT',
        '1100032400'    =>  'Tue, 09 Nov 04 20:33:20 GMT',
        '1300032400'    =>  'Sun, 13 Mar 11 16:06:40 GMT',
        '1500032400'    =>  'Fri, 14 Jul 17 11:40:00 GMT',
        '1700032400'    =>  'Wed, 15 Nov 23 07:13:20 GMT',
        '1900032400'    =>  'Mon, 18 Mar 30 02:46:40 GMT',
        '2100032400'    =>  'Fri, 18 Jul 36 22:20:00 GMT',
    };
    my $w3cdtf = {
        '300032400'     =>  '1979-07-05T14:20:00Z',
        '500032400'     =>  '1985-11-05T09:53:20Z',
        '700032400'     =>  '1992-03-08T05:26:40Z',
        '900032400'     =>  '1998-07-10T01:00:00Z',
        '1100032400'    =>  '2004-11-09T20:33:20Z',
        '1300032400'    =>  '2011-03-13T16:06:40Z',
        '1500032400'    =>  '2017-07-14T11:40:00Z',
        '1700032400'    =>  '2023-11-15T07:13:20Z',
        '1900032400'    =>  '2030-03-18T02:46:40Z',
        '2100032400'    =>  '2036-07-18T22:20:00Z',
    };
    foreach my $key ( sort {$a<=>$b} keys %$rfc2822_2dy ) {
        my $try1 = $rfc2822_2dy->{$key};
        my $chk1 = $w3cdtf->{$key};
        my $out1 = XML::FeedPP::Util::rfc1123_to_w3cdtf( $try1 );
        $out1 =~ s/[\+\-]00:00$/Z/;
        my $name = ( $try1 =~ /, (.*) \d+:/ )[0];
        is( $out1, $chk1, 'rfc1123/w3cdtf '.$try1 );
    }
    foreach my $key ( sort {$a<=>$b} keys %$rfc2822_2dy ) {
        my $try1 = $rfc2822_2dy->{$key};
        my $out1 = XML::FeedPP::Util::rfc1123_to_epoch( $try1 );
        my $name = ( $try1 =~ /, (.*) \d+:/ )[0];
        is( $out1, $key, 'rfc1123/epoch '.$try1 );
    }
}
# ----------------------------------------------------------------
;1;
# ----------------------------------------------------------------
