# Generated by default/object.tt
package Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsDetails;
  use Moose;
  has Command => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Cpu => (is => 'ro', isa => 'Int');
  has DependsOn => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails]');
  has DisableNetworking => (is => 'ro', isa => 'Bool');
  has DnsSearchDomains => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has DnsServers => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has DockerLabels => (is => 'ro', isa => 'Paws::SecurityHub::FieldMap');
  has DockerSecurityOptions => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has EntryPoint => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Environment => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails]');
  has EnvironmentFiles => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails]');
  has Essential => (is => 'ro', isa => 'Bool');
  has ExtraHosts => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails]');
  has FirelensConfiguration => (is => 'ro', isa => 'Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails');
  has HealthCheck => (is => 'ro', isa => 'Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails');
  has Hostname => (is => 'ro', isa => 'Str');
  has Image => (is => 'ro', isa => 'Str');
  has Interactive => (is => 'ro', isa => 'Bool');
  has Links => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has LinuxParameters => (is => 'ro', isa => 'Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails');
  has LogConfiguration => (is => 'ro', isa => 'Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails');
  has Memory => (is => 'ro', isa => 'Int');
  has MemoryReservation => (is => 'ro', isa => 'Int');
  has MountPoints => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails]');
  has Name => (is => 'ro', isa => 'Str');
  has PortMappings => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails]');
  has Privileged => (is => 'ro', isa => 'Bool');
  has PseudoTerminal => (is => 'ro', isa => 'Bool');
  has ReadonlyRootFilesystem => (is => 'ro', isa => 'Bool');
  has RepositoryCredentials => (is => 'ro', isa => 'Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails');
  has ResourceRequirements => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails]');
  has Secrets => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails]');
  has StartTimeout => (is => 'ro', isa => 'Int');
  has StopTimeout => (is => 'ro', isa => 'Int');
  has SystemControls => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails]');
  has Ulimits => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails]');
  has User => (is => 'ro', isa => 'Str');
  has VolumesFrom => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails]');
  has WorkingDirectory => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsDetails object:

  $service_obj->Method(Att1 => { Command => $value, ..., WorkingDirectory => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->Command

=head1 DESCRIPTION

A container definition that describes a container in the task.

=head1 ATTRIBUTES


=head2 Command => ArrayRef[Str|Undef]

The command that is passed to the container.


=head2 Cpu => Int

The number of CPU units reserved for the container.


=head2 DependsOn => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsDependsOnDetails>]

The dependencies that are defined for container startup and shutdown.


=head2 DisableNetworking => Bool

Whether to disable networking within the container.


=head2 DnsSearchDomains => ArrayRef[Str|Undef]

A list of DNS search domains that are presented to the container.


=head2 DnsServers => ArrayRef[Str|Undef]

A list of DNS servers that are presented to the container.


=head2 DockerLabels => L<Paws::SecurityHub::FieldMap>

A key-value map of labels to add to the container.


=head2 DockerSecurityOptions => ArrayRef[Str|Undef]

A list of strings to provide custom labels for SELinux and AppArmor
multi-level security systems.


=head2 EntryPoint => ArrayRef[Str|Undef]

The entry point that is passed to the container.


=head2 Environment => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsEnvironmentDetails>]

The environment variables to pass to a container.


=head2 EnvironmentFiles => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsEnvironmentFilesDetails>]

A list of files containing the environment variables to pass to a
container.


=head2 Essential => Bool

Whether the container is essential. All tasks must have at least one
essential container.


=head2 ExtraHosts => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsExtraHostsDetails>]

A list of hostnames and IP address mappings to append to the
B</etc/hosts> file on the container.


=head2 FirelensConfiguration => L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsFirelensConfigurationDetails>

The FireLens configuration for the container. Specifies and configures
a log router for container logs.


=head2 HealthCheck => L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsHealthCheckDetails>

The container health check command and associated configuration
parameters for the container.


=head2 Hostname => Str

The hostname to use for the container.


=head2 Image => Str

The image used to start the container.


=head2 Interactive => Bool

If set to true, then containerized applications can be deployed that
require C<stdin> or a C<tty> to be allocated.


=head2 Links => ArrayRef[Str|Undef]

A list of links for the container in the form C<
I<container_name>:I<alias> >. Allows containers to communicate with
each other without the need for port mappings.


=head2 LinuxParameters => L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLinuxParametersDetails>

Linux-specific modifications that are applied to the container, such as
Linux kernel capabilities.


=head2 LogConfiguration => L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsLogConfigurationDetails>

The log configuration specification for the container.


=head2 Memory => Int

The amount (in MiB) of memory to present to the container. If the
container attempts to exceed the memory specified here, the container
is shut down. The total amount of memory reserved for all containers
within a task must be lower than the task memory value, if one is
specified.


=head2 MemoryReservation => Int

The soft limit (in MiB) of memory to reserve for the container.


=head2 MountPoints => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsMountPointsDetails>]

The mount points for the data volumes in the container.


=head2 Name => Str

The name of the container.


=head2 PortMappings => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsPortMappingsDetails>]

The list of port mappings for the container.


=head2 Privileged => Bool

Whether the container is given elevated privileges on the host
container instance. The elevated privileges are similar to the root
user.


=head2 PseudoTerminal => Bool

Whether to allocate a TTY to the container.


=head2 ReadonlyRootFilesystem => Bool

Whether the container is given read-only access to its root file
system.


=head2 RepositoryCredentials => L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsRepositoryCredentialsDetails>

The private repository authentication credentials to use.


=head2 ResourceRequirements => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsResourceRequirementsDetails>]

The type and amount of a resource to assign to a container. The only
supported resource is a GPU.


=head2 Secrets => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsSecretsDetails>]

The secrets to pass to the container.


=head2 StartTimeout => Int

The number of seconds to wait before giving up on resolving
dependencies for a container.


=head2 StopTimeout => Int

The number of seconds to wait before the container is stopped if it
doesn't shut down normally on its own.


=head2 SystemControls => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsSystemControlsDetails>]

A list of namespaced kernel parameters to set in the container.


=head2 Ulimits => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsUlimitsDetails>]

A list of ulimits to set in the container.


=head2 User => Str

The user to use inside the container.

The value can use one of the following formats.

=over

=item *

C<I<user>>

=item *

C<I<user> >:C< I<group>>

=item *

C<I<uid>>

=item *

C<I<uid> >:C< I<gid>>

=item *

C<I<user> >:C< I<gid>>

=item *

C<I<uid> >:C< I<group>>

=back



=head2 VolumesFrom => ArrayRef[L<Paws::SecurityHub::AwsEcsTaskDefinitionContainerDefinitionsVolumesFromDetails>]

Data volumes to mount from another container.


=head2 WorkingDirectory => Str

The working directory in which to run commands inside the container.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

