package PDF::Builder::Resource::Font::CoreFont::timesbold;

use strict;
use warnings;

our $VERSION = '3.025'; # VERSION
our $LAST_UPDATE = '3.019'; # manually update whenever code is changed

=head1 NAME

PDF::Builder::Resource::Font::CoreFont::timesbold - font-specific information for bold weight Times font

=cut

sub data { return {
    'fontname' => 'Times-Bold',
    'type' => 'Type1',
    'apiname' => 'TiBo',
    'ascender' => '683',
    'capheight' => '676',
    'descender' => '-217',
    'iscore' => '1',
    'isfixedpitch' => '0',
    'italicangle' => '0',
    'missingwidth' => '250',
    'stdhw' => '44',
    'stdvw' => '139',
    'underlineposition' => '-100',
    'underlinethickness' => '50',
    'xheight' => '461',
    'firstchar' => '32',
    'lastchar' => '255',
    'char' => [ # DEF. ENCODING GLYPH TABLE
        '.notdef',                               # C+0x00 # U+0x0000
        '.notdef',                               # C+0x01 # U+0x0000
        '.notdef',                               # C+0x02 # U+0x0000
        '.notdef',                               # C+0x03 # U+0x0000
        '.notdef',                               # C+0x04 # U+0x0000
        '.notdef',                               # C+0x05 # U+0x0000
        '.notdef',                               # C+0x06 # U+0x0000
        '.notdef',                               # C+0x07 # U+0x0000
        '.notdef',                               # C+0x08 # U+0x0000
        '.notdef',                               # C+0x09 # U+0x0000
        '.notdef',                               # C+0x0A # U+0x0000
        '.notdef',                               # C+0x0B # U+0x0000
        '.notdef',                               # C+0x0C # U+0x0000
        '.notdef',                               # C+0x0D # U+0x0000
        '.notdef',                               # C+0x0E # U+0x0000
        '.notdef',                               # C+0x0F # U+0x0000
        '.notdef',                               # C+0x10 # U+0x0000
        '.notdef',                               # C+0x11 # U+0x0000
        '.notdef',                               # C+0x12 # U+0x0000
        '.notdef',                               # C+0x13 # U+0x0000
        '.notdef',                               # C+0x14 # U+0x0000
        '.notdef',                               # C+0x15 # U+0x0000
        '.notdef',                               # C+0x16 # U+0x0000
        '.notdef',                               # C+0x17 # U+0x0000
        '.notdef',                               # C+0x18 # U+0x0000
        '.notdef',                               # C+0x19 # U+0x0000
        '.notdef',                               # C+0x1A # U+0x0000
        '.notdef',                               # C+0x1B # U+0x0000
        '.notdef',                               # C+0x1C # U+0x0000
        '.notdef',                               # C+0x1D # U+0x0000
        '.notdef',                               # C+0x1E # U+0x0000
        '.notdef',                               # C+0x1F # U+0x0000
        'space',                                 # C+0x20 # U+0x0020
        'exclam',                                # C+0x21 # U+0x0021
        'quotedbl',                              # C+0x22 # U+0x0022
        'numbersign',                            # C+0x23 # U+0x0023
        'dollar',                                # C+0x24 # U+0x0024
        'percent',                               # C+0x25 # U+0x0025
        'ampersand',                             # C+0x26 # U+0x0026
        'quotesingle',                           # C+0x27 # U+0x0027
        'parenleft',                             # C+0x28 # U+0x0028
        'parenright',                            # C+0x29 # U+0x0029
        'asterisk',                              # C+0x2A # U+0x002A
        'plus',                                  # C+0x2B # U+0x002B
        'comma',                                 # C+0x2C # U+0x002C
        'hyphen',                                # C+0x2D # U+0x002D
        'period',                                # C+0x2E # U+0x002E
        'slash',                                 # C+0x2F # U+0x002F
        'zero',                                  # C+0x30 # U+0x0030
        'one',                                   # C+0x31 # U+0x0031
        'two',                                   # C+0x32 # U+0x0032
        'three',                                 # C+0x33 # U+0x0033
        'four',                                  # C+0x34 # U+0x0034
        'five',                                  # C+0x35 # U+0x0035
        'six',                                   # C+0x36 # U+0x0036
        'seven',                                 # C+0x37 # U+0x0037
        'eight',                                 # C+0x38 # U+0x0038
        'nine',                                  # C+0x39 # U+0x0039
        'colon',                                 # C+0x3A # U+0x003A
        'semicolon',                             # C+0x3B # U+0x003B
        'less',                                  # C+0x3C # U+0x003C
        'equal',                                 # C+0x3D # U+0x003D
        'greater',                               # C+0x3E # U+0x003E
        'question',                              # C+0x3F # U+0x003F
        'at',                                    # C+0x40 # U+0x0040
        'A',                                     # C+0x41 # U+0x0041
        'B',                                     # C+0x42 # U+0x0042
        'C',                                     # C+0x43 # U+0x0043
        'D',                                     # C+0x44 # U+0x0044
        'E',                                     # C+0x45 # U+0x0045
        'F',                                     # C+0x46 # U+0x0046
        'G',                                     # C+0x47 # U+0x0047
        'H',                                     # C+0x48 # U+0x0048
        'I',                                     # C+0x49 # U+0x0049
        'J',                                     # C+0x4A # U+0x004A
        'K',                                     # C+0x4B # U+0x004B
        'L',                                     # C+0x4C # U+0x004C
        'M',                                     # C+0x4D # U+0x004D
        'N',                                     # C+0x4E # U+0x004E
        'O',                                     # C+0x4F # U+0x004F
        'P',                                     # C+0x50 # U+0x0050
        'Q',                                     # C+0x51 # U+0x0051
        'R',                                     # C+0x52 # U+0x0052
        'S',                                     # C+0x53 # U+0x0053
        'T',                                     # C+0x54 # U+0x0054
        'U',                                     # C+0x55 # U+0x0055
        'V',                                     # C+0x56 # U+0x0056
        'W',                                     # C+0x57 # U+0x0057
        'X',                                     # C+0x58 # U+0x0058
        'Y',                                     # C+0x59 # U+0x0059
        'Z',                                     # C+0x5A # U+0x005A
        'bracketleft',                           # C+0x5B # U+0x005B
        'backslash',                             # C+0x5C # U+0x005C
        'bracketright',                          # C+0x5D # U+0x005D
        'asciicircum',                           # C+0x5E # U+0x005E
        'underscore',                            # C+0x5F # U+0x005F
        'grave',                                 # C+0x60 # U+0x0060
        'a',                                     # C+0x61 # U+0x0061
        'b',                                     # C+0x62 # U+0x0062
        'c',                                     # C+0x63 # U+0x0063
        'd',                                     # C+0x64 # U+0x0064
        'e',                                     # C+0x65 # U+0x0065
        'f',                                     # C+0x66 # U+0x0066
        'g',                                     # C+0x67 # U+0x0067
        'h',                                     # C+0x68 # U+0x0068
        'i',                                     # C+0x69 # U+0x0069
        'j',                                     # C+0x6A # U+0x006A
        'k',                                     # C+0x6B # U+0x006B
        'l',                                     # C+0x6C # U+0x006C
        'm',                                     # C+0x6D # U+0x006D
        'n',                                     # C+0x6E # U+0x006E
        'o',                                     # C+0x6F # U+0x006F
        'p',                                     # C+0x70 # U+0x0070
        'q',                                     # C+0x71 # U+0x0071
        'r',                                     # C+0x72 # U+0x0072
        's',                                     # C+0x73 # U+0x0073
        't',                                     # C+0x74 # U+0x0074
        'u',                                     # C+0x75 # U+0x0075
        'v',                                     # C+0x76 # U+0x0076
        'w',                                     # C+0x77 # U+0x0077
        'x',                                     # C+0x78 # U+0x0078
        'y',                                     # C+0x79 # U+0x0079
        'z',                                     # C+0x7A # U+0x007A
        'braceleft',                             # C+0x7B # U+0x007B
        'bar',                                   # C+0x7C # U+0x007C
        'braceright',                            # C+0x7D # U+0x007D
        'asciitilde',                            # C+0x7E # U+0x007E
        'bullet',                                # C+0x7F # U+0x2022
        'Euro',                                  # C+0x80 # U+0x20AC
        'bullet',                                # C+0x81 # U+0x2022
        'quotesinglbase',                        # C+0x82 # U+0x201A
        'florin',                                # C+0x83 # U+0x0192
        'quotedblbase',                          # C+0x84 # U+0x201E
        'ellipsis',                              # C+0x85 # U+0x2026
        'dagger',                                # C+0x86 # U+0x2020
        'daggerdbl',                             # C+0x87 # U+0x2021
        'circumflex',                            # C+0x88 # U+0x02C6
        'perthousand',                           # C+0x89 # U+0x2030
        'Scaron',                                # C+0x8A # U+0x0160
        'guilsinglleft',                         # C+0x8B # U+0x2039
        'OE',                                    # C+0x8C # U+0x0152
        'bullet',                                # C+0x8D # U+0x2022
        'Zcaron',                                # C+0x8E # U+0x017D
        'bullet',                                # C+0x8F # U+0x2022
        'bullet',                                # C+0x90 # U+0x2022
        'quoteleft',                             # C+0x91 # U+0x2018
        'quoteright',                            # C+0x92 # U+0x2019
        'quotedblleft',                          # C+0x93 # U+0x201C
        'quotedblright',                         # C+0x94 # U+0x201D
        'bullet',                                # C+0x95 # U+0x2022
        'endash',                                # C+0x96 # U+0x2013
        'emdash',                                # C+0x97 # U+0x2014
        'tilde',                                 # C+0x98 # U+0x02DC
        'trademark',                             # C+0x99 # U+0x2122
        'scaron',                                # C+0x9A # U+0x0161
        'guilsinglright',                        # C+0x9B # U+0x203A
        'oe',                                    # C+0x9C # U+0x0153
        'bullet',                                # C+0x9D # U+0x2022
        'zcaron',                                # C+0x9E # U+0x017E
        'Ydieresis',                             # C+0x9F # U+0x0178
        'space',                                 # C+0xA0 # U+0x0020
        'exclamdown',                            # C+0xA1 # U+0x00A1
        'cent',                                  # C+0xA2 # U+0x00A2
        'sterling',                              # C+0xA3 # U+0x00A3
        'currency',                              # C+0xA4 # U+0x00A4
        'yen',                                   # C+0xA5 # U+0x00A5
        'brokenbar',                             # C+0xA6 # U+0x00A6
        'section',                               # C+0xA7 # U+0x00A7
        'dieresis',                              # C+0xA8 # U+0x00A8
        'copyright',                             # C+0xA9 # U+0x00A9
        'ordfeminine',                           # C+0xAA # U+0x00AA
        'guillemotleft',                         # C+0xAB # U+0x00AB
        'logicalnot',                            # C+0xAC # U+0x00AC
        'hyphen',                                # C+0xAD # U+0x002D
        'registered',                            # C+0xAE # U+0x00AE
        'macron',                                # C+0xAF # U+0x00AF
        'degree',                                # C+0xB0 # U+0x00B0
        'plusminus',                             # C+0xB1 # U+0x00B1
        'twosuperior',                           # C+0xB2 # U+0x00B2
        'threesuperior',                         # C+0xB3 # U+0x00B3
        'acute',                                 # C+0xB4 # U+0x00B4
        'mu',                                    # C+0xB5 # U+0x00B5
        'paragraph',                             # C+0xB6 # U+0x00B6
        'periodcentered',                        # C+0xB7 # U+0x00B7
        'cedilla',                               # C+0xB8 # U+0x00B8
        'onesuperior',                           # C+0xB9 # U+0x00B9
        'ordmasculine',                          # C+0xBA # U+0x00BA
        'guillemotright',                        # C+0xBB # U+0x00BB
        'onequarter',                            # C+0xBC # U+0x00BC
        'onehalf',                               # C+0xBD # U+0x00BD
        'threequarters',                         # C+0xBE # U+0x00BE
        'questiondown',                          # C+0xBF # U+0x00BF
        'Agrave',                                # C+0xC0 # U+0x00C0
        'Aacute',                                # C+0xC1 # U+0x00C1
        'Acircumflex',                           # C+0xC2 # U+0x00C2
        'Atilde',                                # C+0xC3 # U+0x00C3
        'Adieresis',                             # C+0xC4 # U+0x00C4
        'Aring',                                 # C+0xC5 # U+0x00C5
        'AE',                                    # C+0xC6 # U+0x00C6
        'Ccedilla',                              # C+0xC7 # U+0x00C7
        'Egrave',                                # C+0xC8 # U+0x00C8
        'Eacute',                                # C+0xC9 # U+0x00C9
        'Ecircumflex',                           # C+0xCA # U+0x00CA
        'Edieresis',                             # C+0xCB # U+0x00CB
        'Igrave',                                # C+0xCC # U+0x00CC
        'Iacute',                                # C+0xCD # U+0x00CD
        'Icircumflex',                           # C+0xCE # U+0x00CE
        'Idieresis',                             # C+0xCF # U+0x00CF
        'Eth',                                   # C+0xD0 # U+0x00D0
        'Ntilde',                                # C+0xD1 # U+0x00D1
        'Ograve',                                # C+0xD2 # U+0x00D2
        'Oacute',                                # C+0xD3 # U+0x00D3
        'Ocircumflex',                           # C+0xD4 # U+0x00D4
        'Otilde',                                # C+0xD5 # U+0x00D5
        'Odieresis',                             # C+0xD6 # U+0x00D6
        'multiply',                              # C+0xD7 # U+0x00D7
        'Oslash',                                # C+0xD8 # U+0x00D8
        'Ugrave',                                # C+0xD9 # U+0x00D9
        'Uacute',                                # C+0xDA # U+0x00DA
        'Ucircumflex',                           # C+0xDB # U+0x00DB
        'Udieresis',                             # C+0xDC # U+0x00DC
        'Yacute',                                # C+0xDD # U+0x00DD
        'Thorn',                                 # C+0xDE # U+0x00DE
        'germandbls',                            # C+0xDF # U+0x00DF
        'agrave',                                # C+0xE0 # U+0x00E0
        'aacute',                                # C+0xE1 # U+0x00E1
        'acircumflex',                           # C+0xE2 # U+0x00E2
        'atilde',                                # C+0xE3 # U+0x00E3
        'adieresis',                             # C+0xE4 # U+0x00E4
        'aring',                                 # C+0xE5 # U+0x00E5
        'ae',                                    # C+0xE6 # U+0x00E6
        'ccedilla',                              # C+0xE7 # U+0x00E7
        'egrave',                                # C+0xE8 # U+0x00E8
        'eacute',                                # C+0xE9 # U+0x00E9
        'ecircumflex',                           # C+0xEA # U+0x00EA
        'edieresis',                             # C+0xEB # U+0x00EB
        'igrave',                                # C+0xEC # U+0x00EC
        'iacute',                                # C+0xED # U+0x00ED
        'icircumflex',                           # C+0xEE # U+0x00EE
        'idieresis',                             # C+0xEF # U+0x00EF
        'eth',                                   # C+0xF0 # U+0x00F0
        'ntilde',                                # C+0xF1 # U+0x00F1
        'ograve',                                # C+0xF2 # U+0x00F2
        'oacute',                                # C+0xF3 # U+0x00F3
        'ocircumflex',                           # C+0xF4 # U+0x00F4
        'otilde',                                # C+0xF5 # U+0x00F5
        'odieresis',                             # C+0xF6 # U+0x00F6
        'divide',                                # C+0xF7 # U+0x00F7
        'oslash',                                # C+0xF8 # U+0x00F8
        'ugrave',                                # C+0xF9 # U+0x00F9
        'uacute',                                # C+0xFA # U+0x00FA
        'ucircumflex',                           # C+0xFB # U+0x00FB
        'udieresis',                             # C+0xFC # U+0x00FC
        'yacute',                                # C+0xFD # U+0x00FD
        'thorn',                                 # C+0xFE # U+0x00FE
        'ydieresis',                             # C+0xFF # U+0x00FF
    ], # DEF. ENCODING GLYPH TABLE
    'fontbbox' => [ -168, -218, 1000, 935 ],
# source: \Windows\Fonts\timesbd.ttf
# font underline position = -223
# CIDs 0 .. 4684 to be output
# fontbbox = (-558 -327 2000 1055)
    'wx' => { # HORIZ. WIDTH TABLE
	# +1  official .afm spec one larger than what TTF reports
	# (+1)  not in .afm spec, but increased (by 1) per base letter
	# -1  official .afm spec one smaller than what TTF reports
	# others as noted (.afm spec or original .pm plus some %)
        'A'       => 722,
        'AE'       => 1000,
        'AEacute'       => 1000,
        'AEmacron'       => 1000,
        'Aacute'       => 722,
        'Abreve'       => 722,
        'Abreveacute'       => 722,
        'Abrevecyrillic'       => 722,
        'Abrevedotbelow'       => 722,
        'Abrevegrave'       => 722,
        'Abrevehookabove'       => 722,
        'Abrevetilde'       => 722,
        'Acaron'       => 722,
        'Acircumflex'       => 722,
        'Acircumflexacute'       => 722,
        'Acircumflexdotbelow'       => 722,
        'Acircumflexgrave'       => 722,
        'Acircumflexhookabove'       => 722,
        'Acircumflextilde'       => 722,
        'Adblgrave'       => 722,
        'Adieresis'       => 722,
        'Adieresiscyrillic'       => 722,
        'Adieresismacron'       => 722,
        'Adotbelow'       => 722,
        'Adotmacron'       => 722,
        'Agrave'       => 722,
        'Ahookabove'       => 722,
        'Aiecyrillic'       => 1000,
        'Ainvertedbreve'       => 722,
        'Alpha'       => 722,
        'Alphatonos'       => 722,
        'Amacron'       => 722,
        'Aogonek'       => 722,
        'Aring'       => 722,
        'Aringacute'       => 722,
        'Aringbelow'       => 722,
        'Atilde'       => 722,
        'Aybarmenian'       => 772,
        'B'       => 667,                                         # +1
        'Bdotaccent'       => 667,                                # (+1)
        'Bdotbelow'       => 667,                                 # (+1)
        'Benarmenian'       => 722,
        'Beta'       => 667,                                      # (+1)
        'Bhook'       => 754,
        'Blinebelow'       => 667,                                # (+1)
        'Btopbar'       => 661,
        'C'       => 722,
        'Caarmenian'       => 737,
        'Cacute'       => 722,
        'Ccaron'       => 722,
        'Ccedilla'       => 722,
        'Ccedillaacute'       => 722,
        'Ccircumflex'       => 722,
        'Cdotaccent'       => 722,
        'Chaarmenian'       => 696,
        'Cheabkhasiancyrillic'       => 880,
        'Chedescenderabkhasiancyrillic'       => 880,
        'Chedescendercyrillic'       => 733,
        'Chedieresiscyrillic'       => 733,
        'Cheharmenian'       => 719,
        'Chekhakassiancyrillic'       => 733,
        'Cheverticalstrokecyrillic'       => 733,
        'Chi'       => 722,
        'Chook'       => 722,
        'Coarmenian'       => 690,
        'D'       => 722,
        'DZ'       => 1389,
        'DZcaron'       => 1389,
        'Daarmenian'       => 809,
        'Dafrican'       => 722,
        'Dcaron'       => 722,
        'Dcedilla'       => 722,
        'Dcircumflexbelow'       => 722,
        'Dcroat'       => 722,
        'Ddotaccent'       => 722,
        'Ddotbelow'       => 722,
        'Deicoptic'       => 540,
        'Delta'       => 626,                         # afm 612, use TTF
        'Dhook'       => 816,
        'Digammagreek'       => 610,
        'Dlinebelow'       => 722,
        'Dtopbar'       => 661,
        'Dz'       => 1166,
        'Dzcaron'       => 1166,
        'Dzeabkhasiancyrillic'       => 527,
        'E'       => 667,                                         # +1
        'Eacute'       => 667,                                    # +1
        'Ebreve'       => 667,                                    # (+1)
        'Ecaron'       => 667,                                    # (+1)
        'Ecedillabreve'       => 667,                             # (+1)
        'Echarmenian'       => 718,
        'Ecircumflex'       => 667,                               # +1
        'Ecircumflexacute'       => 667,                          # (+1)
        'Ecircumflexbelow'       => 667,                          # (+1)
        'Ecircumflexdotbelow'       => 667,                       # (+1)
        'Ecircumflexgrave'       => 667,                          # (+1)
        'Ecircumflexhookabove'       => 667,                      # (+1)
        'Ecircumflextilde'       => 667,                          # (+1)
        'Edblgrave'       => 667,                                 # (+1)
        'Edieresis'       => 667,                                 # +1
        'Edotaccent'       => 667,                                # +1
        'Edotbelow'       => 667,                                 # (+1)
        'Egrave'       => 667,                                    # +1
        'Eharmenian'       => 636,
        'Ehookabove'       => 667,                                # (+1)
        'Eightroman'       => 1859,
        'Einvertedbreve'       => 667,                            # (+1)
        'Eiotifiedcyrillic'       => 1007,
        'Elevenroman'       => 1112,
        'Emacron'       => 667,                                   # +1
        'Emacronacute'       => 667,                              # (+1)
        'Emacrongrave'       => 667,                              # (+1)
        'Endescendercyrillic'       => 777,
        'Eng'       => 769,
        'Enghecyrillic'       => 921,
        'Enhookcyrillic'       => 777,
        'Eogonek'       => 667,                                   # +1
        'Eopen'       => 527,
        'Epsilon'       => 667,                                   # (+1)
        'Epsilontonos'       => 798,
        'Ereversed'       => 667,                                 # (+1)
        'Esdescendercyrillic'       => 722,
        'Esh'       => 653,
        'Eta'       => 777,
        'Etarmenian'       => 722,
        'Etatonos'       => 909,
        'Eth'       => 722,
        'Etilde'       => 667,                                    # (+1)
        'Etildebelow'       => 667,                               # (+1)
        'Euro'       => 500,
        'Ezh'       => 581,
        'Ezhcaron'       => 581,
        'Ezhreversed'       => 581,
        'F'       => 611,                                         # +1
        'Fdotaccent'       => 611,                                # (+1)
        'Feharmenian'       => 903,
        'Feicoptic'       => 725,
        'Fhook'       => 611,                                     # (+1)
        'Fiveroman'       => 722,
        'Fourroman'       => 1111,
        'G'       => 778,                                         # +1
        'Gacute'       => 778,                                    # (+1)
        'Gamma'       => 636,
        'Gammaafrican'       => 722,
        'Gangiacoptic'       => 681,
        'Gbreve'       => 778,                                    # +1
        'Gcaron'       => 778,                                    # (+1)
        'Gcircumflex'       => 778,                               # (+1)
        'Gcommaaccent'       => 778,                              # +1
        'Gdotaccent'       => 778,                                # (+1)
        'Ghadarmenian'       => 769,
        'Ghemiddlehookcyrillic'       => 721,
        'Ghestrokecyrillic'       => 636,
        'Ghook'       => 778,                                     # (+1)
        'Gimarmenian'       => 793,
        'Gmacron'       => 778,                                   # (+1)
        'Gsmallhook'       => 591,
        'Gstroke'       => 778,                                   # (+1)
        'H'       => 778,                                         # +1
        'H18533'       => 604,
        'H18543'       => 354,
        'H18551'       => 354,
        'H22073'       => 604,
        'Haabkhasiancyrillic'       => 729,
        'Hadescendercyrillic'       => 722,
        'Hbar'       => 778,                                      # (+1)
        'Hbrevebelow'       => 778,                               # (+1)
        'Hcedilla'       => 778,                                  # (+1)
        'Hcircumflex'       => 778,                               # (+1)
        'Hdieresis'       => 778,                                 # (+1)
        'Hdotaccent'       => 778,                                # (+1)
        'Hdotbelow'       => 778,                                 # (+1)
        'Hoarmenian'       => 623,
        'Horicoptic'       => 625,
        'I'       => 389,
        'IJ'       => 822,
        'Iacute'       => 389,
        'Ibreve'       => 389,
        'Icaron'       => 389,
        'Icircumflex'       => 389,
        'Idblgrave'       => 389,
        'Idieresis'       => 389,
        'Idieresisacute'       => 389,
        'Idieresiscyrillic'       => 777,
        'Idotaccent'       => 389,
        'Idotbelow'       => 389,
        'Iebrevecyrillic'       => 666,
        'Ifraktur'       => 553,
        'Igrave'       => 389,
        'Ihookabove'       => 389,
        'Iinvertedbreve'       => 389,
        'Imacron'       => 389,
        'Imacroncyrillic'       => 777,
        'Iniarmenian'       => 692,
        'Iogonek'       => 389,
        'Iota'       => 389,
        'Iotaafrican'       => 306,
        'Iotadieresis'       => 389,
        'Iotatonos'       => 521,
        'Istroke'       => 389,
        'Itilde'       => 389,
        'Itildebelow'       => 389,
        'Izhitsadblgravecyrillic'       => 815,
        'J'       => 500,
        'Jaarmenian'       => 726,
        'Jcircumflex'       => 500,
        'Jheharmenian'       => 723,
        'K'       => 778,                                         # +1
        'Kabashkircyrillic'       => 828,
        'Kacute'       => 778,                                    # (+1)
        'Kadescendercyrillic'       => 725,
        'Kahookcyrillic'       => 737,
        'Kappa'       => 777,
        'Kastrokecyrillic'       => 725,
        'Kaverticalstrokecyrillic'       => 725,
        'Kcaron'       => 778,                                    # (+1)
        'Kcommaaccent'       => 778,                              # +1
        'Kdotbelow'       => 778,                                 # (+1)
        'Keharmenian'       => 804,
        'Kenarmenian'       => 722,
        'Kheicoptic'       => 739,
        'Khook'       => 778,                                     # (+1)
        'Klinebelow'       => 778,                                # (+1)
        'Koppacyrillic'       => 722,
        'Koppagreek'       => 595,
        'Ksicyrillic'       => 527,
        'L'       => 667,                                         # +1
        'LJ'       => 1166,
        'Lacute'       => 667,                                    # +1
        'Lambda'       => 716,
        'Lcaron'       => 667,                                    # +1
        'Lcircumflexbelow'       => 667,                          # (+1)
        'Lcommaaccent'       => 667,                              # +1
        'Ldot'       => 667,                                      # (+1)
        'Ldotbelow'       => 667,                                 # (+1)
        'Ldotbelowmacron'       => 667,                           # (+1)
        'Liwnarmenian'       => 566,
        'Lj'       => 1000,
        'Llinebelow'       => 667,                                # (+1)
        'Lslash'       => 667,                                    # +1
        'M'       => 944,                                         # +1
        'Macute'       => 944,                                    # (+1)
        'Mdotaccent'       => 944,                                # (+1)
        'Mdotbelow'       => 944,                                 # (+1)
        'Menarmenian'       => 848,
        'Mturned'       => 940,
        'Mu'       => 944,                                        # (+1)
        'N'       => 722,
        'NJ'       => 1222,
        'Nacute'       => 722,
        'Ncaron'       => 722,
        'Ncircumflexbelow'       => 722,
        'Ncommaaccent'       => 722,
        'Ndotaccent'       => 722,
        'Ndotbelow'       => 722,
        'Nhookleft'       => 722,
        'Nineroman'       => 1112,
        'Nj'       => 1055,
        'Nlinebelow'       => 722,
        'Nowarmenian'       => 761,
        'Ntilde'       => 722,
        'Nu'       => 722,
        'O'       => 778,                                         # +1
        'OE'       => 1000,
        'Oacute'       => 778,                                    # +1
        'Obarredcyrillic'       => 777,
        'Obarreddieresiscyrillic'       => 777,
        'Obreve'       => 778,                                    # (+1)
        'Ocaron'       => 778,                                    # (+1)
        'Ocenteredtilde'       => 778,                            # (+1)
        'Ocircumflex'       => 778,                               # +1
        'Ocircumflexacute'       => 778,                          # (+1)
        'Ocircumflexdotbelow'       => 778,                       # (+1)
        'Ocircumflexgrave'       => 778,                          # (+1)
        'Ocircumflexhookabove'       => 778,                      # (+1)
        'Ocircumflextilde'       => 778,                          # (+1)
        'Odblgrave'       => 778,                                 # (+1)
        'Odieresis'       => 778,                                 # +1
        'Odieresiscyrillic'       => 777,
        'Odotbelow'       => 778,                                 # (+1)
        'Ograve'       => 778,                                    # +1
        'Oharmenian'       => 761,
        'Ohookabove'       => 778,                                # (+1)
        'Ohorn'       => 778,                                     # (+1)
        'Ohornacute'       => 778,                                # (+1)
        'Ohorndotbelow'       => 778,                             # (+1)
        'Ohorngrave'       => 778,                                # (+1)
        'Ohornhookabove'       => 778,                            # (+1)
        'Ohorntilde'       => 778,                                # (+1)
        'Ohungarumlaut'       => 778,                             # +1
        'Oi'       => 1056,
        'Oinvertedbreve'       => 778,                            # (+1)
        'Omacron'       => 778,                                   # +1
        'Omacronacute'       => 778,                              # (+1)
        'Omacrongrave'       => 778,                              # (+1)
        'Omega'       => 800,
        'Omegacyrillic'       => 1250,
        'Omegaroundcyrillic'       => 823,
        'Omegatitlocyrillic'       => 1236,
        'Omegatonos'       => 800,
        'Omicron'       => 778,                                   # (+1)
        'Omicrontonos'       => 778,                              # (+1)
        'Oneroman'       => 389,
        'Oogonek'       => 778,                                   # (+1)
        'Oogonekmacron'       => 778,                             # (+1)
        'Oopen'       => 722,
        'Oslash'       => 778,                                    # +1
        'Oslashacute'       => 778,                               # (+1)
        'Otcyrillic'       => 1250,
        'Otilde'       => 778,                                    # +1
        'Otildeacute'       => 778,                               # (+1)
        'Otildedieresis'       => 778,                            # (+1)
        'P'       => 611,                                         # +1
        'Pacute'       => 611,                                    # (+1)
        'Pdotaccent'       => 611,                                # (+1)
        'Peharmenian'       => 850,
        'Pemiddlehookcyrillic'       => 1114,
        'Phi'       => 829,
        'Phook'       => 694,
        'Pi'       => 777,
        'Piwrarmenian'       => 908,
        'Psi'       => 779,
        'Psicyrillic'       => 779,
        'Q'       => 778,                                         # +1
        'R'       => 722,
        'Raarmenian'       => 833,
        'Racute'       => 722,
        'Rcaron'       => 722,
        'Rcommaaccent'       => 722,
        'Rdblgrave'       => 722,
        'Rdotaccent'       => 722,
        'Rdotbelow'       => 722,
        'Rdotbelowmacron'       => 722,
        'Reharmenian'       => 683,
        'Rfraktur'       => 794,
        'Rho'       => 610,
        'Rinvertedbreve'       => 722,
        'Rlinebelow'       => 722,
        'Rsmallinverted'       => 574,
        'Rsmallinvertedsuperior'       => 348,
        'S'       => 556,
        'SF010000'       => 708,
        'SF020000'       => 708,
        'SF030000'       => 708,
        'SF040000'       => 708,
        'SF050000'       => 708,
        'SF060000'       => 708,
        'SF070000'       => 708,
        'SF080000'       => 708,
        'SF090000'       => 708,
        'SF100000'       => 708,
        'SF110000'       => 708,
        'SF190000'       => 708,
        'SF200000'       => 708,
        'SF210000'       => 708,
        'SF220000'       => 708,
        'SF230000'       => 708,
        'SF240000'       => 708,
        'SF250000'       => 708,
        'SF260000'       => 708,
        'SF270000'       => 708,
        'SF280000'       => 708,
        'SF360000'       => 708,
        'SF370000'       => 708,
        'SF380000'       => 708,
        'SF390000'       => 708,
        'SF400000'       => 708,
        'SF410000'       => 708,
        'SF420000'       => 708,
        'SF430000'       => 708,
        'SF440000'       => 708,
        'SF450000'       => 708,
        'SF460000'       => 708,
        'SF470000'       => 708,
        'SF480000'       => 708,
        'SF490000'       => 708,
        'SF500000'       => 708,
        'SF510000'       => 708,
        'SF520000'       => 708,
        'SF530000'       => 708,
        'SF540000'       => 708,
        'Sacute'       => 556,
        'Sacutedotaccent'       => 556,
        'Sampigreek'       => 751,
        'Scaron'       => 556,
        'Scarondotaccent'       => 556,
        'Scedilla'       => 556,
        'Schwacyrillic'       => 738,
        'Schwadieresiscyrillic'       => 738,
        'Scircumflex'       => 556,
        'Scommaaccent'       => 556,
        'Sdotaccent'       => 556,
        'Sdotbelow'       => 556,
        'Sdotbelowdotaccent'       => 556,
        'Seharmenian'       => 727,
        'Sevenroman'       => 1484,
        'Shaarmenian'       => 703,
        'Sheicoptic'       => 870,
        'Shhacyrillic'       => 733,
        'Shimacoptic'       => 724,
        'Sigma'       => 653,
        'Sixroman'       => 1108,
        'Stigmagreek'       => 722,
        'T'       => 667,                                         # +1
        'Tau'       => 667,                                       # (+1)
        'Tbar'       => 667,                                      # (+1)
        'Tcaron'       => 667,                                    # +1
        'Tcedilla'       => 667,                                  # (+1)
        'Tcircumflexbelow'       => 667,                          # (+1)
        'Tcommaaccent'       => 667,                              # +1
        'Tdotaccent'       => 667,                                # (+1)
        'Tdotbelow'       => 667,                                 # (+1)
        'Tedescendercyrillic'       => 666,
        'Tenroman'       => 722,
        'Tetsecyrillic'       => 867,
        'Theta'       => 777,
        'Thook'       => 667,                                     # (+1)
        'Thorn'       => 611,                                     # +1
        'Threeroman'       => 1140,
        'Tiwnarmenian'       => 674,
        'Tlinebelow'       => 667,                                # (+1)
        'Toarmenian'       => 939,
        'Tonefive'       => 504,
        'Tonesix'       => 661,
        'Tonetwo'       => 556,
        'Tretroflexhook'       => 667,                            # (+1)
        'Twelveroman'       => 1487,
        'Tworoman'       => 764,
        'U'       => 722,
        'Uacute'       => 722,
        'Ubreve'       => 722,
        'Ucaron'       => 722,
        'Ucircumflex'       => 722,
        'Ucircumflexbelow'       => 722,
        'Udblgrave'       => 722,
        'Udieresis'       => 722,
        'Udieresisacute'       => 722,
        'Udieresisbelow'       => 722,
        'Udieresiscaron'       => 722,
        'Udieresiscyrillic'       => 733,
        'Udieresisgrave'       => 722,
        'Udieresismacron'       => 722,
        'Udotbelow'       => 722,
        'Ugrave'       => 722,
        'Uhookabove'       => 722,
        'Uhorn'       => 795,
        'Uhornacute'       => 795,
        'Uhorndotbelow'       => 795,
        'Uhorngrave'       => 795,
        'Uhornhookabove'       => 795,
        'Uhorntilde'       => 795,
        'Uhungarumlaut'       => 722,
        'Uhungarumlautcyrillic'       => 733,
        'Uinvertedbreve'       => 722,
        'Ukcyrillic'       => 1139,
        'Umacron'       => 722,
        'Umacroncyrillic'       => 733,
        'Umacrondieresis'       => 722,
        'Uogonek'       => 722,
        'Upsilon'       => 722,
        'Upsilon1'       => 722,
        'Upsilonacutehooksymbolgreek'       => 923,
        'Upsilonafrican'       => 800,
        'Upsilondieresis'       => 722,
        'Upsilondieresishooksymbolgreek'       => 722,
        'Upsilontonos'       => 864,
        'Uring'       => 722,
        'Ustraightcyrillic'       => 722,
        'Ustraightstrokecyrillic'       => 722,
        'Utilde'       => 722,
        'Utildeacute'       => 722,
        'Utildebelow'       => 722,
        'V'       => 722,
        'Vdotbelow'       => 722,
        'Vewarmenian'       => 769,
        'Vhook'       => 651,
        'Voarmenian'       => 727,
        'Vtilde'       => 722,
        'W'       => 1000,
        'Wacute'       => 1000,
        'Wcircumflex'       => 1000,
        'Wdieresis'       => 1000,
        'Wdotaccent'       => 1000,
        'Wdotbelow'       => 1000,
        'Wgrave'       => 1000,
        'X'       => 722,
        'Xdieresis'       => 722,
        'Xdotaccent'       => 722,
        'Xeharmenian'       => 982,
        'Xi'       => 677,
        'Y'       => 722,
        'Yacute'       => 722,
        'Ycircumflex'       => 722,
        'Ydieresis'       => 722,
        'Ydotaccent'       => 722,
        'Ydotbelow'       => 722,
        'Yerudieresiscyrillic'       => 981,
        'Ygrave'       => 722,
        'Yhook'       => 790,
        'Yhookabove'       => 722,
        'Yiarmenian'       => 703,
        'Yiwnarmenian'       => 592,
        'Ytilde'       => 722,
        'Yusbigcyrillic'       => 988,
        'Yusbigiotifiedcyrillic'       => 1359,
        'Yuslittlecyrillic'       => 722,
        'Yuslittleiotifiedcyrillic'       => 1098,
        'Z'       => 667,                                         # +1
        'Zaarmenian'       => 713,
        'Zacute'       => 667,                                    # +1
        'Zcaron'       => 667,                                    # +1
        'Zcircumflex'       => 667,                               # (+1)
        'Zdotaccent'       => 667,                                # +1
        'Zdotbelow'       => 667,                                 # (+1)
        'Zedescendercyrillic'       => 527,
        'Zedieresiscyrillic'       => 527,
        'Zeta'       => 666,
        'Zhearmenian'       => 788,
        'Zhebrevecyrillic'       => 988,
        'Zhedescendercyrillic'       => 988,
        'Zhedieresiscyrillic'       => 988,
        'Zlinebelow'       => 667,                                # (+1)
        'Zstroke'       => 667,                                   # (+1)
        'a'       => 500,
        'aacute'       => 500,
        'abbreviationmarkarmenian'       => 557,
        'abreve'       => 500,
        'abreveacute'       => 500,
        'abrevecyrillic'       => 500,
        'abrevedotbelow'       => 500,
        'abrevegrave'       => 500,
        'abrevehookabove'       => 500,
        'abrevetilde'       => 500,
        'acaron'       => 500,
        'acircumflex'       => 500,
        'acircumflexacute'       => 500,
        'acircumflexdotbelow'       => 500,
        'acircumflexgrave'       => 500,
        'acircumflexhookabove'       => 500,
        'acircumflextilde'       => 500,
        'acute'       => 333,
        'acutebelowcmb'       => 0,
        'acutecomb'       => 0,
        'acutelowmod'       => 333,
        'acutetonecmb'       => 0,
        'adblgrave'       => 500,
        'adieresis'       => 500,
        'adieresiscyrillic'       => 500,
        'adieresismacron'       => 500,
        'adotbelow'       => 500,
        'adotmacron'       => 500,
        'ae'       => 722,
        'aeacute'       => 722,
        'aemacron'       => 722,
        'afii00208'       => 1000,
        'afii10017'       => 722,
        'afii10018'       => 661,
        'afii10019'       => 666,
        'afii10020'       => 636,
        'afii10021'       => 687,
        'afii10022'       => 666,
        'afii10023'       => 666,
        'afii10024'       => 988,
        'afii10025'       => 527,
        'afii10026'       => 777,
        'afii10027'       => 777,
        'afii10028'       => 725,
        'afii10029'       => 745,
        'afii10030'       => 943,
        'afii10031'       => 777,
        'afii10032'       => 777,
        'afii10033'       => 777,
        'afii10034'       => 610,
        'afii10035'       => 722,
        'afii10036'       => 666,
        'afii10037'       => 733,
        'afii10038'       => 858,
        'afii10039'       => 722,
        'afii10040'       => 777,
        'afii10041'       => 733,
        'afii10042'       => 1098,
        'afii10043'       => 1098,
        'afii10044'       => 765,
        'afii10045'       => 981,
        'afii10046'       => 661,
        'afii10047'       => 678,
        'afii10048'       => 1125,
        'afii10049'       => 722,
        'afii10050'       => 520,
        'afii10051'       => 799,
        'afii10052'       => 636,
        'afii10053'       => 678,
        'afii10054'       => 556,
        'afii10055'       => 389,
        'afii10056'       => 389,
        'afii10057'       => 500,
        'afii10058'       => 1002,
        'afii10059'       => 1001,
        'afii10060'       => 799,
        'afii10061'       => 725,
        'afii10062'       => 733,
        'afii10065'       => 500,
        'afii10066'       => 500,
        'afii10067'       => 540,
        'afii10068'       => 454,
        'afii10069'       => 505,
        'afii10070'       => 443,
        'afii10071'       => 443,
        'afii10072'       => 725,
        'afii10073'       => 401,
        'afii10074'       => 576,
        'afii10075'       => 576,
        'afii10076'       => 576,
        'afii10077'       => 561,
        'afii10078'       => 681,
        'afii10079'       => 576,
        'afii10080'       => 500,
        'afii10081'       => 576,
        'afii10082'       => 556,
        'afii10083'       => 443,
        'afii10084'       => 491,
        'afii10085'       => 500,
        'afii10086'       => 691,
        'afii10087'       => 500,
        'afii10088'       => 576,
        'afii10089'       => 563,
        'afii10090'       => 844,
        'afii10091'       => 844,
        'afii10092'       => 583,
        'afii10093'       => 780,
        'afii10094'       => 528,
        'afii10095'       => 432,
        'afii10096'       => 764,
        'afii10097'       => 541,
        'afii10098'       => 389,
        'afii10099'       => 537,
        'afii10100'       => 454,
        'afii10101'       => 432,
        'afii10102'       => 389,
        'afii10103'       => 277,
        'afii10104'       => 277,
        'afii10105'       => 333,
        'afii10106'       => 779,
        'afii10107'       => 796,
        'afii10108'       => 556,
        'afii10109'       => 576,
        'afii10110'       => 500,
        'afii10145'       => 777,
        'afii10146'       => 763,
        'afii10147'       => 777,
        'afii10148'       => 815,
        'afii10193'       => 576,
        'afii10194'       => 600,
        'afii10195'       => 500,
        'afii10196'       => 604,
        'afii10846'       => 443,
        'afii299'       => 0,
        'afii300'       => 0,
        'afii301'       => 0,
        'afii57381'       => 525,
        'afii57388'       => 318,
        'afii57396'       => 561,
        'afii57397'       => 561,
        'afii57398'       => 561,
        'afii57403'       => 318,
        'afii57407'       => 356,
        'afii57409'       => 468,
        'afii57440'       => 198,
        'afii57451'       => 0,
        'afii57452'       => 0,
        'afii57453'       => 0,
        'afii57454'       => 0,
        'afii57455'       => 0,
        'afii57456'       => 0,
        'afii57457'       => 0,
        'afii57458'       => 0,
        'afii57534'       => 342,
        'afii57636'       => 757,
        'afii57645'       => 363,
        'afii57658'       => 333,
        'afii57664'       => 526,
        'afii57665'       => 458,
        'afii57666'       => 366,
        'afii57667'       => 464,
        'afii57668'       => 512,
        'afii57669'       => 298,
        'afii57670'       => 317,
        'afii57671'       => 504,
        'afii57672'       => 529,
        'afii57673'       => 310,
        'afii57674'       => 457,
        'afii57675'       => 446,
        'afii57676'       => 435,
        'afii57677'       => 511,
        'afii57678'       => 533,
        'afii57679'       => 325,
        'afii57680'       => 315,
        'afii57681'       => 478,
        'afii57682'       => 507,
        'afii57683'       => 492,
        'afii57684'       => 457,
        'afii57685'       => 564,
        'afii57686'       => 514,
        'afii57687'       => 482,
        'afii57688'       => 463,
        'afii57689'       => 688,
        'afii57690'       => 518,
        'afii57694'       => 688,
        'afii57695'       => 688,
        'afii57700'       => 298,
        'afii57705'       => 621,
        'afii57716'       => 596,
        'afii57717'       => 608,
        'afii57718'       => 621,
        'afii57723'       => 298,
        'afii57793'       => 0,
        'afii57794'       => 0,
        'afii57795'       => 0,
        'afii57796'       => 0,
        'afii57797'       => 0,
        'afii57798'       => 0,
        'afii57799'       => 0,
        'afii57800'       => 0,
        'afii57801'       => 0,
        'afii57802'       => 0,
        'afii57803'       => 0,
        'afii57804'       => 0,
        'afii57806'       => 0,
        'afii57807'       => 0,
        'afii57839'       => 0,
        'afii57841'       => 0,
        'afii57842'       => 333,
        'afii57929'       => 333,
        'afii61248'       => 833,
        'afii61289'       => 375,
        'afii61352'       => 1004,
        'afii61573'       => 750,
        'afii61574'       => 750,
        'afii61575'       => 750,
        'afii61664'       => 0,
        'afii63167'       => 525,
        'afii64937'       => 333,
        'agrave'       => 500,
        'ahookabove'       => 500,
        'aiecyrillic'       => 722,
        'ainfinalarabic'       => 468,
        'aininitialarabic'       => 541,
        'ainmedialarabic'       => 360,
        'ainvertedbreve'       => 500,
        'alefdageshhebrew'       => 526,
        'aleffinalarabic'       => 234,
        'alefhamzaabovefinalarabic'       => 234,
        'alefhamzabelowfinalarabic'       => 234,
        'aleflamedhebrew'       => 526,
        'alefmaddaabovefinalarabic'       => 253,
        'alefmaksurafinalarabic'       => 554,
        'alefmaksurainitialarabic'       => 271,
        'alefmaksuramedialarabic'       => 271,
        'alefpatahhebrew'       => 526,
        'alefqamatshebrew'       => 526,
        'aleph'       => 647,
        'alpha'       => 558,
        'alphatonos'       => 558,
        'amacron'       => 500,
        'ampersand'       => 833,
        'angstrom'       => 722,
        'anoteleia'       => 333,
        'aogonek'       => 500,
        'apostrophearmenian'       => 249,
        'approxequal'       => 548,
        'arighthalfring'       => 500,
        'aring'       => 500,
        'aringacute'       => 500,
        'aringbelow'       => 500,
        'arrowboth'       => 1000,
        'arrowdown'       => 500,
        'arrowheaddownmod'       => 569,
        'arrowheadleftmod'       => 569,
        'arrowheadrightmod'       => 569,
        'arrowheadupmod'       => 569,
        'arrowleft'       => 1000,
        'arrowright'       => 1000,
        'arrowup'       => 500,
        'arrowupdn'       => 500,
        'arrowupdnbse'       => 500,
        'asciicircum'       => 581,
        'asciitilde'       => 520,
        'ascript'       => 574,
        'ascriptturned'       => 574,
        'asterisk'       => 500,
        'asterism'       => 938,
        'at'       => 930,
        'atilde'       => 500,
        'aturned'       => 500,
        'aybarmenian'       => 819,
        'ayinaltonehebrew'       => 507,
        'b'       => 556,
        'backslash'       => 278,                                 # +1
        'bar'       => 220,
        'bdotaccent'       => 556,
        'bdotbelow'       => 556,
        'behfinalarabic'       => 649,
        'behinitialarabic'       => 271,
        'behmedialarabic'       => 271,
        'benarmenian'       => 550,
        'bernou'       => 926,
        'beta'       => 526,
        'betasymbolgreek'       => 526,
        'betdagesh'       => 458,
        'beth'       => 564,
        'betrafehebrew'       => 458,
        'bhook'       => 556,
        'bilabialclick'       => 777,
        'blinebelow'       => 556,
        'block'       => 708,
        'braceleft'       => 394,
        'braceright'       => 394,
        'bracketleft'       => 333,
        'bracketright'       => 333,
        'breve'       => 333,
        'brevebelowcmb'       => 0,
        'brevecmb'       => 0,
        'breveinvertedbelowcmb'       => 0,
        'breveinvertedcmb'       => 0,
        'breveinverteddoublecmb'       => 0,
        'bridgebelowcmb'       => 0,
        'bridgeinvertedbelowcmb'       => 0,
        'brokenbar'       => 220,
        'bstroke'       => 556,
        'btopbar'       => 556,
        'bullet'       => 350,
        'c'       => 444,                                         # +1
        'caarmenian'       => 549,
        'cacute'       => 444,                                    # +1
        'candrabinducmb'       => 0,
        'caret'       => 350,
        'caron'       => 333,
        'caronbelowcmb'       => 0,
        'caroncmb'       => 0,
        'ccaron'       => 444,                                    # +1
        'ccedilla'       => 444,                                  # +1
        'ccedillaacute'       => 444,                             # (+1)
        'ccircumflex'       => 444,                               # (+1)
        'ccurl'       => 444,                                     # (+1)
        'cdotaccent'       => 444,                                # (+1)
        'cedilla'       => 333,
        'cedillacmb'       => 0,
        'cent'       => 500,
        'centigrade'       => 1081,
        'chaarmenian'       => 303,
        'cheabkhasiancyrillic'       => 563,
        'chedescenderabkhasiancyrillic'       => 563,
        'chedescendercyrillic'       => 563,
        'chedieresiscyrillic'       => 563,
        'cheharmenian'       => 553,
        'chekhakassiancyrillic'       => 563,
        'cheverticalstrokecyrillic'       => 563,
        'chi'       => 461,
        'chook'       => 444,                                     # (+1)
        'circle'       => 604,
        'circumflex'       => 333,
        'circumflexbelowcmb'       => 0,
        'circumflexcmb'       => 0,
        'clickalveolar'       => 279,
        'clickdental'       => 220,
        'clickretroflex'       => 333,
        'club'       => 656,
        'coarmenian'       => 561,
        'colon'       => 333,
        'colonmonetary'       => 722,
        'colontriangularhalfmod'       => 277,
        'colontriangularmod'       => 277,
        'comma'       => 250,
        'commaabovecmb'       => 0,
        'commaaboverightcmb'       => 0,
        'commaaccent'       => 250,
        'commaarmenian'       => 207,
        'commareversedabovecmb'       => 0,
        'commaturnedabovecmb'       => 0,
        'commaturnedmod'       => 333,
        'copyright'       => 747,
        'copysr'       => 747,
        'cruzeiro'       => 722,
        'cstretched'       => 497,
        'currency'       => 500,
        'd'       => 556,
        'daarmenian'       => 579,
        'dadfinalarabic'       => 1062,
        'dadinitialarabic'       => 771,
        'dadmedialarabic'       => 771,
        'dagger'       => 500,
        'daggerdbl'       => 500,
        'daletdagesh'       => 464,
        'daleth'       => 571,
        'dalfinalarabic'       => 342,
        'dargahebrew'       => 0,
        'dasiapneumatacyrilliccmb'       => 0,
        'dblarchinvertedbelowcmb'       => 0,
        'dblgravecmb'       => 0,
        'dbllowlinecmb'       => 0,
        'dbloverlinecmb'       => 0,
        'dblprimemod'       => 496,
        'dblverticalbar'       => 324,
        'dblverticallineabovecmb'       => 0,
        'dcaron'       => 743,                        # afm 672, use TTF+10
        'dcedilla'       => 556,
        'dcircumflexbelow'       => 556,
        'dcroat'       => 556,
        'ddalfinalarabic'       => 342,
        'ddotaccent'       => 556,
        'ddotbelow'       => 556,
        'decimalseparatorarabic'       => 318,
        'degree'       => 400,                                    # +1
        'dehihebrew'       => 0,
        'deicoptic'       => 450,
        'delta'       => 519,
        'deltaturned'       => 519,
        'dezh'       => 872,
        'dhook'       => 556,
        'dialytikatonoscmb'       => 0,
        'diamond'       => 510,
        'dieresis'       => 333,
        'dieresisbelowcmb'       => 0,
        'dieresiscmb'       => 0,
        'dieresistonos'       => 333,
        'divide'       => 548,                        # afm 570, use TTF
        'dkshade'       => 729,
        'dlinebelow'       => 556,
        'dnblock'       => 708,
        'dollar'       => 500,
        'dong'       => 512,
        'dotaccent'       => 333,
        'dotaccentcmb'       => 0,
        'dotbelowcomb'       => 0,
        'dotlessi'       => 278,                                  # +1
        'dotlessj'       => 333,
        'dotlessjstrokehook'       => 333,
        'dottedcircle'       => 594,
        'downtackbelowcmb'       => 0,
        'downtackmod'       => 333,
        'dtail'       => 556,
        'dtopbar'       => 556,
        'dz'       => 1000,
        'dzaltone'       => 860,
        'dzcaron'       => 1000,
        'dzcurl'       => 930,
        'dzeabkhasiancyrillic'       => 458,
        'e'       => 444,                                         # +1
        'eacute'       => 444,                                    # +1
        'ebreve'       => 444,                                    # (+1)
        'ecaron'       => 444,                                    # +1
        'ecedillabreve'       => 444,                             # (+1)
        'echarmenian'       => 554,
        'echyiwnarmenian'       => 650,
        'ecircumflex'       => 444,                               # +1
        'ecircumflexacute'       => 444,                          # (+1)
        'ecircumflexbelow'       => 444,                          # (+1)
        'ecircumflexdotbelow'       => 444,                       # (+1)
        'ecircumflexgrave'       => 444,                          # (+1)
        'ecircumflexhookabove'       => 444,                      # (+1)
        'ecircumflextilde'       => 444,                          # (+1)
        'edblgrave'       => 444,                                 # (+1)
        'edieresis'       => 444,                                 # +1
        'edotaccent'       => 444,                                # +1
        'edotbelow'       => 444,                                 # (+1)
        'egrave'       => 444,                                    # +1
        'eharmenian'       => 488,
        'ehookabove'       => 444,                                # (+1)
        'eight'       => 500,
        'eightinferior'       => 299,
        'eightpersian'       => 561,
        'eightroman'       => 1329,
        'eightsuperior'       => 299,
        'einvertedbreve'       => 444,                            # (+1)
        'eiotifiedcyrillic'       => 663,
        'elevenroman'       => 770,
        'ellipsis'       => 1000,
        'emacron'       => 444,                                   # +1
        'emacronacute'       => 444,                              # (+1)
        'emacrongrave'       => 444,                              # (+1)
        'emdash'       => 1000,
        'emphasismarkarmenian'       => 166,
        'emsp'       => 1000,
        'emsp13'       => 333,
        'emsp14'       => 250,
        'endash'       => 500,
        'endescendercyrillic'       => 576,
        'eng'       => 556,
        'enghecyrillic'       => 666,
        'enhookcyrillic'       => 576,
        'enspace'       => 500,
        'eogonek'       => 444,                                   # +1
        'eopen'       => 427,
        'eopenclosed'       => 457,
        'eopenreversed'       => 427,
        'eopenreversedclosed'       => 457,
        'eopenreversedhook'       => 592,
        'epsilon'       => 427,
        'epsilontonos'       => 427,
        'equal'       => 570,                                     # +1
        'equalsuperior'       => 299,
        'equivalence'       => 569,
        'ereversed'       => 444,                                 # (+1)
        'esdescendercyrillic'       => 443,
        'esh'       => 302,
        'eshcurl'       => 319,
        'eshreversedloop'       => 512,
        'eshsquatreversed'       => 351,
        'estimated'       => 600,
        'eta'       => 567,
        'etarmenian'       => 554,
        'etatonos'       => 567,
        'eth'       => 500,
        'etilde'       => 444,                                    # (+1)
        'etildebelow'       => 444,                               # (+1)
        'etnahtafoukhhebrew'       => 0,
        'eturned'       => 444,                                   # (+1)
        'exclam'       => 333,
        'exclamarmenian'       => 120,
        'exclamdbl'       => 604,
        'exclamdown'       => 333,
        'ezh'       => 458,
        'ezhcaron'       => 458,
        'ezhcurl'       => 458,
        'ezhreversed'       => 458,
        'ezhtail'       => 453,
        'f'       => 333,
        'fahrenheit'       => 977,
        'fdotaccent'       => 333,
        'feharmenian'       => 750,
        'fehfinalarabic'       => 757,
        'fehinitialarabic'       => 304,
        'fehmedialarabic'       => 324,
        'feicoptic'       => 585,
        'female'       => 750,
        'ff'       => 585,
        'ffi'       => 798,
        'ffl'       => 808,
        'fi'       => 556,
        'figuredash'       => 500,
        'filledbox'       => 604,
        'filledrect'       => 1000,
        'finalkafdagesh'       => 457,
        'five'       => 500,
        'fiveeighths'       => 750,
        'fiveinferior'       => 299,
        'fivepersian'       => 561,
        'fiveroman'       => 500,
        'fivesuperior'       => 299,
        'fl'       => 556,
        'florin'       => 500,
        'four'       => 500,
        'fourinferior'       => 299,
        'fourpersian'       => 561,
        'fourroman'       => 758,
        'foursuperior'       => 299,
        'fourthtonechinese'       => 333,
        'frac15'       => 750,
        'frac16'       => 750,
        'frac25'       => 750,
        'frac35'       => 750,
        'frac45'       => 750,
        'frac56'       => 750,
        'fraction'       => 167,                                  # +1
        'franc'       => 500,
        'g'       => 500,
        'gacute'       => 500,
        'gaffinalarabic'       => 878,
        'gafinitialarabic'       => 360,
        'gafmedialarabic'       => 541,
        'gamma'       => 467,
        'gammad'       => 546,
        'gammalatinsmall'       => 500,
        'gammasuperior'       => 299,
        'gangiacoptic'       => 605,
        'gbreve'       => 500,
        'gcaron'       => 500,
        'gcircumflex'       => 500,
        'gcommaaccent'       => 500,
        'gdotaccent'       => 500,
        'gereshaccenthebrew'       => 0,
        'gereshhebrew'       => 255,
        'gereshmuqdamhebrew'       => 0,
        'germandbls'       => 556,
        'gershayimaccenthebrew'       => 0,
        'gershayimhebrew'       => 459,
        'ghadarmenian'       => 579,
        'ghainfinalarabic'       => 468,
        'ghaininitialarabic'       => 541,
        'ghainmedialarabic'       => 360,
        'ghemiddlehookcyrillic'       => 576,
        'ghestrokecyrillic'       => 454,
        'ghook'       => 551,
        'gimarmenian'       => 575,
        'gimel'       => 451,
        'gimeldagesh'       => 366,
        'glottalinvertedstroke'       => 333,
        'glottalstop'       => 443,
        'glottalstopinverted'       => 443,
        'glottalstopmod'       => 251,
        'glottalstopreversed'       => 443,
        'glottalstopreversedmod'       => 251,
        'glottalstopreversedsuperior'       => 251,
        'glottalstopstroke'       => 443,
        'glottalstopstrokereversed'       => 443,
        'gmacron'       => 500,
        'grave'       => 333,
        'gravebelowcmb'       => 0,
        'gravecomb'       => 0,
        'gravelowmod'       => 333,
        'gravetonecmb'       => 0,
        'greater'       => 570,                                   # +1
        'greaterequal'       => 549,                              # +1
        'gscript'       => 551,
        'gstroke'       => 500,
        'guillemotleft'       => 500,
        'guillemotright'       => 500,
        'guilsinglleft'       => 333,
        'guilsinglright'       => 333,
        'h'       => 556,
        'haabkhasiancyrillic'       => 533,
        'hadescendercyrillic'       => 500,
        'hahfinalarabic'       => 558,
        'hahinitialarabic'       => 523,
        'hahmedialarabic'       => 523,
        'hairsp'       => 83,
        'hamilt'       => 905,
        'hbar'       => 556,
        'hbrevebelow'       => 556,
        'hcedilla'       => 556,
        'hcircumflex'       => 556,
        'hdieresis'       => 556,
        'hdotaccent'       => 556,
        'hdotbelow'       => 556,
        'heart'       => 593,
        'hedagesh'       => 512,
        'hehfinalaltonearabic'       => 387,
        'hehfinalalttwoarabic'       => 415,
        'hehhamzaabovefinalarabic'       => 415,
        'hehhamzaaboveisolatedarabic'       => 342,
        'hehinitialaltonearabic'       => 271,
        'hehinitialarabic'       => 468,
        'hehmedialaltonearabic'       => 320,
        'hehmedialarabic'       => 451,
        'henghook'       => 556,
        'hhook'       => 556,
        'hhooksuperior'       => 325,
        'hlinebelow'       => 556,
        'hoarmenian'       => 565,
        'hookabovecomb'       => 0,
        'hookpalatalizedbelowcmb'       => 0,
        'hookretroflexbelowcmb'       => 0,
        'horicoptic'       => 586,
        'horncmb'       => 0,
        'house'       => 600,
        'hsuperior'       => 325,
        'hturned'       => 556,
        'hungarumlaut'       => 333,
        'hungarumlautcmb'       => 0,
        'hv'       => 781,
        'hybull'       => 333,
        'hyphen'       => 333,
        'hyphentwo'       => 333,
        'i'       => 278,                                         # +1
        'iacute'       => 278,                                    # +1
        'ibreve'       => 278,                                    # (+1)
        'icaron'       => 278,                                    # (+1)
        'icircumflex'       => 278,                               # +1
        'idblgrave'       => 278,                                 # (+1)
        'idieresis'       => 278,                                 # +1
        'idieresisacute'       => 278,                            # (+1)
        'idieresiscyrillic'       => 576,
        'idotbelow'       => 278,                                 # (+1)
        'iebrevecyrillic'       => 443,
        'igrave'       => 278,                                    # +1
        'ihookabove'       => 278,                                # (+1)
        'iinvertedbreve'       => 278,                            # (+1)
        'ij'       => 552,
        'iluyhebrew'       => 0,
        'imacron'       => 278,                                   # +1
        'imacroncyrillic'       => 576,
        'infinity'       => 712,
        'iniarmenian'       => 554,
        'integral'       => 273,
        'integralbt'       => 604,
        'integraltp'       => 604,
        'intersection'       => 718,
        'invbullet'       => 604,
        'invcircle'       => 604,
        'invsmileface'       => 1052,
        'iogonek'       => 278,                                   # +1
        'iota'       => 310,
        'iotadieresis'       => 310,
        'iotadieresistonos'       => 310,
        'iotalatin'       => 310,
        'iotatonos'       => 310,
        'istroke'       => 278,                                   # (+1)
        'itilde'       => 278,                                    # (+1)
        'itildebelow'       => 278,                               # (+1)
        'izhitsadblgravecyrillic'       => 604,
        'j'       => 333,
        'jaarmenian'       => 530,
        'jcaron'       => 333,
        'jcircumflex'       => 333,
        'jcrossedtail'       => 333,
        'jdotlessstroke'       => 333,
        'jeemfinalarabic'       => 558,
        'jeeminitialarabic'       => 523,
        'jeemmedialarabic'       => 523,
        'jehfinalarabic'       => 432,
        'jheharmenian'       => 506,
        'jsuperior'       => 180,
        'k'       => 556,
        'kabashkircyrillic'       => 630,
        'kacute'       => 556,
        'kadescendercyrillic'       => 576,
        'kafdagesh'       => 446,
        'kaffinalarabic'       => 541,
        'kafinitialarabic'       => 360,
        'kafmedialarabic'       => 360,
        'kafrafehebrew'       => 446,
        'kahookcyrillic'       => 593,
        'kappa'       => 555,
        'kappasymbolgreek'       => 579,
        'kastrokecyrillic'       => 576,
        'kaverticalstrokecyrillic'       => 576,
        'kcaron'       => 556,
        'kcommaaccent'       => 556,
        'kdotbelow'       => 556,
        'keharmenian'       => 578,
        'kenarmenian'       => 565,
        'kgreenlandic'       => 556,
        'khahfinalarabic'       => 558,
        'khahinitialarabic'       => 523,
        'khahmedialarabic'       => 523,
        'kheicoptic'       => 443,
        'khook'       => 556,
        'klinebelow'       => 556,
        'koppacyrillic'       => 443,
        'koroniscmb'       => 0,
        'ksicyrillic'       => 401,
        'kturned'       => 556,
        'l'       => 278,                                         # +1
        'lacute'       => 278,                                    # +1
        'lagran'       => 708,
        'lamaleffinalarabic'       => 541,
        'lamalefhamzaabovefinalarabic'       => 541,
        'lamalefhamzaaboveisolatedarabic'       => 486,
        'lamalefhamzabelowfinalarabic'       => 541,
        'lamalefhamzabelowisolatedarabic'       => 486,
        'lamalefisolatedarabic'       => 486,
        'lamalefmaddaabovefinalarabic'       => 595,
        'lamalefmaddaaboveisolatedarabic'       => 541,
        'lambda'       => 491,
        'lambdastroke'       => 491,
        'lameddagesh'       => 435,
        'lamfinalarabic'       => 451,
        'laminitialarabic'       => 234,
        'lamlamhehisolatedarabic'       => 851,
        'lammedialarabic'       => 234,
        'lbar'       => 278,                                      # (+1)
        'lbelt'       => 278,                                     # (+1)
        'lcaron'       => 473,                        # afm 394, use TTF+5
        'lcircumflexbelow'       => 278,                          # (+1)
        'lcommaaccent'       => 278,                              # +1
        'ldot'       => 395,
        'ldotbelow'       => 278,                                 # (+1)
        'ldotbelowmacron'       => 278,                           # (+1)
        'leftangleabovecmb'       => 0,
        'lefttackbelowcmb'       => 0,
        'less'       => 570,                                      # +1
        'lessequal'       => 549,                                 # +1
        'lezh'       => 606,
        'lfblock'       => 708,
        'lhookretroflex'       => 278,                            # (+1)
        'lira'       => 500,
        'liwnarmenian'       => 306,
        'lj'       => 610,
        'llinebelow'       => 278,                                # (+1)
        'lmiddletilde'       => 278,                              # (+1)
        'logicalnot'       => 570,                                # +1
        'longs'       => 277,
        'lowlinecmb'       => 0,
        'lozenge'       => 494,
        'lslash'       => 278,                                    # +1
        'ltshade'       => 708,
        'm'       => 833,
        'macron'       => 500,                        # afm 333, use TTF
        'macronbelowcmb'       => 0,
        'macroncmb'       => 0,
        'macronlowmod'       => 333,
        'macute'       => 833,
        'mahapakhhebrew'       => 0,
        'male'       => 750,
        'masoracirclehebrew'       => 0,
        'mdotaccent'       => 833,
        'mdotbelow'       => 833,
        'meemfinalarabic'       => 360,
        'meeminitialarabic'       => 415,
        'meemmedialarabic'       => 415,
        'memdagesh'       => 533,
        'menarmenian'       => 565,
        'merkhahebrew'       => 0,
        'merkhakefulahebrew'       => 0,
        'mhook'       => 833,
        'minus'       => 570,                                     # +1
        'minusbelowcmb'       => 0,
        'minusmod'       => 333,
        'minute'       => 281,
        'mlonglegturned'       => 833,
        'mturned'       => 833,
        'mu'       => 566,                            # afm 556, use TTF
        'multiply'       => 570,                                  # +1
        'munahhebrew'       => 0,
        'musicalnote'       => 500,
        'musicalnotedbl'       => 750,
        'musicsharpsign'       => 500,
        'n'       => 556,
        'nacute'       => 556,
        'napostrophe'       => 729,
        'ncaron'       => 556,
        'ncircumflexbelow'       => 556,
        'ncommaaccent'       => 556,
        'ndotaccent'       => 556,
        'ndotbelow'       => 556,
        'nhookleft'       => 556,
        'nhookretroflex'       => 556,
        'nine'       => 500,
        'nineinferior'       => 299,
        'ninepersian'       => 561,
        'nineroman'       => 773,
        'ninesuperior'       => 299,
        'nj'       => 889,
        'nlegrightlong'       => 556,
        'nlinebelow'       => 556,
        'noonfinalarabic'       => 541,
        'noonghunnafinalarabic'       => 541,
        'noonhehinitialarabic'       => 271,
        'noonmedialarabic'       => 271,
        'notequal'       => 549,                                  # +1
        'nowarmenian'       => 565,
        'nsuperior'       => 347,
        'ntilde'       => 556,
        'nu'       => 446,
        'numbersign'       => 500,
        'numeralsigngreek'       => 333,
        'numeralsignlowergreek'       => 333,
        'numsp'       => 500,
        'nundagesh'       => 315,
        'o'       => 500,
        'oacute'       => 500,
        'obarred'       => 500,
        'obarredcyrillic'       => 500,
        'obarreddieresiscyrillic'       => 500,
        'obreve'       => 500,
        'ocaron'       => 500,
        'ocircumflex'       => 500,
        'ocircumflexacute'       => 500,
        'ocircumflexdotbelow'       => 500,
        'ocircumflexgrave'       => 500,
        'ocircumflexhookabove'       => 500,
        'ocircumflextilde'       => 500,
        'odblgrave'       => 500,
        'odieresis'       => 500,
        'odieresiscyrillic'       => 500,
        'odotbelow'       => 500,
        'oe'       => 722,
        'ogonek'       => 333,
        'ogonekcmb'       => 0,
        'ograve'       => 500,
        'oharmenian'       => 528,
        'ohookabove'       => 500,
        'ohorn'       => 553,
        'ohornacute'       => 553,
        'ohorndotbelow'       => 553,
        'ohorngrave'       => 553,
        'ohornhookabove'       => 553,
        'ohorntilde'       => 553,
        'ohungarumlaut'       => 500,
        'oi'       => 770,
        'oinvertedbreve'       => 500,
        'olehebrew'       => 0,
        'omacron'       => 500,
        'omacronacute'       => 500,
        'omacrongrave'       => 500,
        'omega'       => 730,
        'omega1'       => 730,
        'omegacyrillic'       => 618,
        'omegalatinclosed'       => 730,
        'omegaroundcyrillic'       => 585,
        'omegatitlocyrillic'       => 807,
        'omegatonos'       => 730,
        'omicron'       => 500,
        'omicrontonos'       => 500,
        'one'       => 500,
        'onedotenleader'       => 333,
        'oneeighth'       => 750,
        'onehalf'       => 750,
        'oneinferior'       => 299,
        'onepersian'       => 561,
        'onequarter'       => 750,
        'oneroman'       => 277,
        'onesuperior'       => 300,                               # +1
        'onethird'       => 750,
        'oogonek'       => 500,
        'oogonekmacron'       => 500,
        'oopen'       => 443,
        'openbullet'       => 354,
        'order'       => 405,
        'ordfeminine'       => 300,                               # +1
        'ordmasculine'       => 330,
        'orthogonal'       => 979,
        'oslash'       => 500,
        'oslashacute'       => 500,
        'otcyrillic'       => 618,
        'otilde'       => 500,
        'otildeacute'       => 500,
        'otildedieresis'       => 500,
        'overline'       => 333,
        'overlinecmb'       => 0,
        'p'       => 556,
        'pacute'       => 556,
        'palatalizationcyrilliccmb'       => 0,
        'palochkacyrillic'       => 389,
        'paragraph'       => 540,
        'parenleft'       => 333,
        'parenleftaltonearabic'       => 318,
        'parenleftinferior'       => 199,
        'parenleftsuperior'       => 199,
        'parenright'       => 333,
        'parenrightaltonearabic'       => 318,
        'parenrightinferior'       => 199,
        'parenrightsuperior'       => 199,
        'partialdiff'       => 494,
        'pashtahebrew'       => 0,
        'pazerhebrew'       => 0,
        'pdotaccent'       => 556,
        'pedagesh'       => 457,
        'pefinaldageshhebrew'       => 492,
        'peharmenian'       => 823,
        'pehfinalarabic'       => 649,
        'pehinitialarabic'       => 271,
        'pehmedialarabic'       => 271,
        'pemiddlehookcyrillic'       => 843,
        'perafehebrew'       => 457,
        'percent'       => 1000,
        'period'       => 250,
        'periodarmenian'       => 277,
        'periodcentered'       => 250,
        'perispomenigreekcmb'       => 0,
        'perthousand'       => 1000,
        'peseta'       => 968,
        'phi'       => 624,
        'phi1'       => 624,
        'philatin'       => 722,
        'phmmat'       => 1115,
        'phook'       => 556,
        'pi'       => 547,
        'piwrarmenian'       => 812,
        'planck'       => 556,
        'plus'       => 570,                                      # +1
        'plusbelowcmb'       => 0,
        'plusminus'       => 548,                     # afm 570, use TTF
        'plusmod'       => 333,
        'plussuperior'       => 299,
        'prescription'       => 722,
        'primemod'       => 281,
        'primereversed'       => 281,
        'product'       => 823,
        'psi'       => 687,
        'psicyrillic'       => 687,
        'psilipneumatacyrilliccmb'       => 0,
        'puncsp'       => 250,
        'q'       => 556,
        'qadmahebrew'       => 0,
        'qaffinalarabic'       => 612,
        'qafinitialarabic'       => 304,
        'qafmedialarabic'       => 324,
        'qarneyparahebrew'       => 0,
        'qhook'       => 556,
        'qofdagesh'       => 482,
        'question'       => 500,
        'questionarmenian'       => 231,
        'questiondown'       => 500,
        'questiongreek'       => 333,
        'quotedbl'       => 555,
        'quotedblbase'       => 500,
        'quotedblleft'       => 500,
        'quotedblright'       => 500,
        'quoteleft'       => 333,
        'quotereversed'       => 333,
        'quoteright'       => 333,
        'quotesinglbase'       => 333,
        'quotesingle'       => 278,                               # +1
        'r'       => 444,                                         # +1
        'raarmenian'       => 598,
        'racute'       => 444,                                    # +1
        'radical'       => 549,                                   # +1
        'ramshorn'       => 517,
        'rcaron'       => 444,                                    # +1
        'rcommaaccent'       => 444,                              # +1
        'rdblgrave'       => 444,                                 # (+1)
        'rdotaccent'       => 444,                                # (+1)
        'rdotbelow'       => 444,                                 # (+1)
        'rdotbelowmacron'       => 444,                           # (+1)
        'referencemark'       => 1000,
        'registered'       => 747,
        'reharmenian'       => 562,
        'rehfinalarabic'       => 432,
        'reshdageshhebrew'       => 463,
        'reviahebrew'       => 0,
        'revlogicalnot'       => 569,
        'rfishhook'       => 400,
        'rfishhookreversed'       => 400,
        'rho'       => 535,
        'rhook'       => 444,                                     # (+1)
        'rhookturned'       => 444,                               # (+1)
        'rhookturnedsuperior'       => 266,
        'rhosymbolgreek'       => 500,
        'rhotichookmod'       => 333,
        'righttackbelowcmb'       => 0,
        'ring'       => 333,
        'ringbelowcmb'       => 0,
        'ringcmb'       => 0,
        'ringhalfleft'       => 333,
        'ringhalfleftarmenian'       => 199,
        'ringhalfleftbelowcmb'       => 0,
        'ringhalfleftcentered'       => 333,
        'ringhalfright'       => 333,
        'ringhalfrightbelowcmb'       => 0,
        'ringhalfrightcentered'       => 333,
        'rinvertedbreve'       => 444,                            # (+1)
        'rlinebelow'       => 444,                                # (+1)
        'rlongleg'       => 444,                                  # (+1)
        'rlonglegturned'       => 444,                            # (+1)
        'rrehfinalarabic'       => 432,
        'rtblock'       => 708,
        'rturned'       => 444,                                   # (+1)
        'rturnedsuperior'       => 254,
        's'       => 389,
        'sacute'       => 389,
        'sacutedotaccent'       => 389,
        'sadfinalarabic'       => 1062,
        'sadinitialarabic'       => 771,
        'sadmedialarabic'       => 771,
        'sallallahoualayhewasallamarabic'       => 741,
        'samekhdagesh'       => 478,
        'scaron'       => 389,
        'scarondotaccent'       => 389,
        'scedilla'       => 389,
        'schwadieresiscyrillic'       => 443,
        'schwahook'       => 626,
        'scircumflex'       => 389,
        'scommaaccent'       => 389,
        'sdotaccent'       => 389,
        'sdotbelow'       => 389,
        'sdotbelowdotaccent'       => 389,
        'seagullbelowcmb'       => 0,
        'second'       => 552,
        'secondtonechinese'       => 333,
        'section'       => 500,
        'seenfinalarabic'       => 899,
        'seeninitialarabic'       => 608,
        'seenmedialarabic'       => 608,
        'segoltahebrew'       => 0,
        'seharmenian'       => 565,
        'semicolon'       => 333,
        'seven'       => 500,
        'seveneighths'       => 750,
        'seveninferior'       => 299,
        'sevenpersian'       => 561,
        'sevenroman'       => 1053,
        'sevensuperior'       => 299,
        'shaarmenian'       => 418,
        'shaddadammaarabic'       => 0,
        'shaddadammatanarabic'       => 0,
        'shaddafathaarabic'       => 0,
        'shaddakasraarabic'       => 0,
        'shaddakasratanarabic'       => 0,
        'shade'       => 708,
        'shalshelethebrew'       => 0,
        'sheenfinalarabic'       => 899,
        'sheeninitialarabic'       => 608,
        'sheenmedialarabic'       => 608,
        'sheicoptic'       => 833,
        'shhacyrillic'       => 556,
        'shimacoptic'       => 515,
        'shindagesh'       => 688,
        'shindageshshindot'       => 688,
        'shindageshsindot'       => 688,
        'shook'       => 389,
        'sigma'       => 543,
        'sigma1'       => 421,
        'sigmalunatesymbolgreek'       => 443,
        'six'       => 500,
        'sixinferior'       => 299,
        'sixpersian'       => 561,
        'sixroman'       => 777,
        'sixsuperior'       => 299,
        'slash'       => 278,                                     # +1
        'slongdotaccent'       => 277,
        'smileface'       => 1020,
        'soliduslongoverlaycmb'       => 0,
        'solidusshortoverlaycmb'       => 0,
        'space'       => 250,
        'spade'       => 531,
        'squarebelowcmb'       => 0,
        'sterling'       => 500,
        'strokelongoverlaycmb'       => 0,
        'strokeshortoverlaycmb'       => 0,
        'summation'       => 712,                     # afm 600, use TTF
        'sun'       => 916,
        't'       => 333,
        'tahfinalarabic'       => 523,
        'tahinitialarabic'       => 523,
        'tahmedialarabic'       => 523,
        'tau'       => 460,
        'tavdages'       => 518,
        'tbar'       => 333,
        'tcaron'       => 525,                        # afm 416, use TTF+5
        'tccurl'       => 707,
        'tcedilla'       => 333,
        'tchehfinalarabic'       => 558,
        'tchehinitialarabic'       => 523,
        'tchehmedialarabic'       => 523,
        'tcircumflexbelow'       => 333,
        'tcommaaccent'       => 333,
        'tdieresis'       => 333,
        'tdotaccent'       => 333,
        'tdotbelow'       => 333,
        'tedescendercyrillic'       => 491,
        'tehfinalarabic'       => 649,
        'tehinitialarabic'       => 271,
        'tehmarbutafinalarabic'       => 415,
        'tehmedialarabic'       => 271,
        'telephone'       => 1202,
        'telishagedolahebrew'       => 0,
        'telishaqetanahebrew'       => 0,
        'tenroman'       => 500,
        'tesh'       => 536,
        'tetdagesh'       => 529,
        'tetsecyrillic'       => 608,
        'tevirhebrew'       => 0,
        'thalfinalarabic'       => 342,
        'thehfinalarabic'       => 649,
        'thehinitialarabic'       => 271,
        'thehmedialarabic'       => 271,
        'theta'       => 521,
        'theta1'       => 599,
        'thook'       => 333,
        'thorn'       => 556,
        'thousandcyrillic'       => 337,
        'thousandsseparatorarabic'       => 318,
        'three'       => 500,
        'threeeighths'       => 750,
        'threeinferior'       => 299,
        'threepersian'       => 561,
        'threequarters'       => 750,
        'threeroman'       => 829,
        'threesuperior'       => 300,                             # +1
        'tilde'       => 333,
        'tildebelowcmb'       => 0,
        'tildecomb'       => 0,
        'tildedoublecmb'       => 0,
        'tildeoverlaycmb'       => 0,
        'tildeverticalcmb'       => 0,
        'tipehahebrew'       => 0,
        'titlocyrilliccmb'       => 0,
        'tiwnarmenian'       => 812,
        'tlinebelow'       => 333,
        'toarmenian'       => 733,
        'tonebarextrahighmod'       => 382,
        'tonebarextralowmod'       => 382,
        'tonebarhighmod'       => 382,
        'tonebarlowmod'       => 382,
        'tonebarmidmod'       => 382,
        'tonefive'       => 384,
        'tonesix'       => 556,
        'tonetwo'       => 389,
        'tonos'       => 333,
        'tpalatalhook'       => 333,
        'tprime'       => 552,
        'trademark'       => 1000,
        'tretroflexhook'       => 333,
        'triagdn'       => 989,
        'triaglf'       => 989,
        'triagrt'       => 989,
        'triagup'       => 989,
        'ts'       => 647,
        'tsadidagesh'       => 514,
        'ttehfinalarabic'       => 649,
        'tturned'       => 333,
        'twelveroman'       => 1046,
        'two'       => 500,
        'twodotenleader'       => 666,
        'twoinferior'       => 299,
        'twopersian'       => 561,
        'tworoman'       => 553,
        'twostroke'       => 500,
        'twosuperior'       => 300,                               # +1
        'twothirds'       => 750,
        'u'       => 556,
        'uacute'       => 556,
        'ubar'       => 556,
        'ubreve'       => 556,
        'ucaron'       => 556,
        'ucircumflex'       => 556,
        'ucircumflexbelow'       => 556,
        'udblgrave'       => 556,
        'udieresis'       => 556,
        'udieresisacute'       => 556,
        'udieresisbelow'       => 556,
        'udieresiscaron'       => 556,
        'udieresiscyrillic'       => 500,
        'udieresisgrave'       => 556,
        'udieresismacron'       => 556,
        'udotbelow'       => 556,
        'ugrave'       => 556,
        'uhookabove'       => 556,
        'uhorn'       => 600,
        'uhornacute'       => 600,
        'uhorndotbelow'       => 600,
        'uhorngrave'       => 600,
        'uhornhookabove'       => 600,
        'uhorntilde'       => 600,
        'uhungarumlaut'       => 556,
        'uhungarumlautcyrillic'       => 500,
        'uinvertedbreve'       => 556,
        'ukcyrillic'       => 919,
        'umacron'       => 556,
        'umacroncyrillic'       => 500,
        'umacrondieresis'       => 556,
        'underscore'       => 500,
        'underscoredbl'       => 500,
        'uni01F6'       => 970,
        'uni01F7'       => 645,
        'uni01F8'       => 722,
        'uni01F9'       => 556,
        'uni021C'       => 553,
        'uni021D'       => 374,
        'uni021E'       => 777,
        'uni021F'       => 556,
        'uni0220'       => 733,
        'uni0221'       => 556,
        'uni0222'       => 676,
        'uni0223'       => 501,
        'uni0224'       => 666,
        'uni0225'       => 443,
        'uni0226'       => 722,
        'uni0227'       => 500,
        'uni0228'       => 666,
        'uni0229'       => 443,
        'uni022A'       => 777,
        'uni022B'       => 500,
        'uni022C'       => 777,
        'uni022D'       => 500,
        'uni022E'       => 777,
        'uni022F'       => 500,
        'uni0230'       => 777,
        'uni0231'       => 500,
        'uni0232'       => 722,
        'uni0233'       => 500,
        'uni0234'       => 277,
        'uni0235'       => 556,
        'uni0236'       => 360,
        'uni0238'       => 822,
        'uni0239'       => 822,
        'uni023A'       => 722,
        'uni023B'       => 722,
        'uni023C'       => 500,
        'uni023D'       => 666,
        'uni023E'       => 666,
        'uni023F'       => 389,
        'uni0240'       => 443,
        'uni0241'       => 532,
        'uni0242'       => 465,
        'uni0243'       => 666,
        'uni0244'       => 722,
        'uni0245'       => 716,
        'uni0246'       => 666,
        'uni0247'       => 443,
        'uni0248'       => 500,
        'uni0249'       => 333,
        'uni024A'       => 824,
        'uni024B'       => 556,
        'uni024C'       => 722,
        'uni024D'       => 443,
        'uni024E'       => 722,
        'uni024F'       => 500,
        'uni0262'       => 591,
        'uni026A'       => 287,
        'uni0274'       => 523,
        'uni0276'       => 759,
        'uni0280'       => 574,
        'uni028F'       => 533,
        'uni0299'       => 540,
        'uni029C'       => 576,
        'uni029F'       => 506,
        'uni02A9'       => 849,
        'uni02AA'       => 621,
        'uni02AB'       => 595,
        'uni02AC'       => 512,
        'uni02AD'       => 480,
        'uni02AE'       => 666,
        'uni02AF'       => 666,
        'uni02B3'       => 254,
        'uni02DF'       => 381,
        'uni02E1'       => 177,
        'uni02E2'       => 217,
        'uni02EA'       => 333,
        'uni02EB'       => 333,
        'uni02EC'       => 333,
        'uni02ED'       => 333,
        'uni02EE'       => 500,
        'uni02EF'       => 333,
        'uni02F0'       => 333,
        'uni02F1'       => 333,
        'uni02F2'       => 333,
        'uni02F3'       => 333,
        'uni02F4'       => 333,
        'uni02F5'       => 333,
        'uni02F6'       => 333,
        'uni02F7'       => 333,
        'uni02F8'       => 333,
        'uni02F9'       => 333,
        'uni02FA'       => 333,
        'uni02FB'       => 333,
        'uni02FC'       => 333,
        'uni02FD'       => 397,
        'uni02FE'       => 397,
        'uni02FF'       => 333,
        'uni0326'       => 0,
        'uni0346'       => 0,
        'uni0347'       => 0,
        'uni0348'       => 0,
        'uni0349'       => 0,
        'uni034A'       => 0,
        'uni034B'       => 0,
        'uni034C'       => 0,
        'uni034D'       => 0,
        'uni034E'       => 0,
        'uni034F'       => 0,
        'uni0350'       => 0,
        'uni0351'       => 0,
        'uni0352'       => 0,
        'uni0353'       => 0,
        'uni0354'       => 0,
        'uni0355'       => 0,
        'uni0356'       => 0,
        'uni0357'       => 0,
        'uni0358'       => 0,
        'uni0359'       => 0,
        'uni035A'       => 0,
        'uni035B'       => 0,
        'uni035C'       => 0,
        'uni035D'       => 0,
        'uni035E'       => 0,
        'uni035F'       => 0,
        'uni0362'       => 0,
        'uni0363'       => 291,
        'uni0364'       => 258,
        'uni0365'       => 177,
        'uni0366'       => 286,
        'uni0367'       => 325,
        'uni0368'       => 259,
        'uni0369'       => 326,
        'uni036A'       => 325,
        'uni036B'       => 491,
        'uni036C'       => 254,
        'uni036D'       => 211,
        'uni036E'       => 299,
        'uni036F'       => 286,
        'uni0370'       => 607,
        'uni0371'       => 479,
        'uni0372'       => 696,
        'uni0373'       => 521,
        'uni0376'       => 777,
        'uni0377'       => 580,
        'uni037B'       => 443,
        'uni037C'       => 443,
        'uni037D'       => 443,
        'uni037F'       => 500,
        'uni03CF'       => 777,
        'uni03D7'       => 579,
        'uni03D8'       => 777,
        'uni03D9'       => 500,
        'uni03DB'       => 421,
        'uni03DF'       => 460,
        'uni03E1'       => 554,
        'uni03F4'       => 777,
        'uni03F5'       => 420,
        'uni03F6'       => 420,
        'uni03F7'       => 610,
        'uni03F8'       => 556,
        'uni03F9'       => 722,
        'uni03FA'       => 943,
        'uni03FB'       => 681,
        'uni03FC'       => 535,
        'uni03FD'       => 722,
        'uni03FE'       => 722,
        'uni03FF'       => 722,
        'uni0400'       => 666,
        'uni040D'       => 777,
        'uni0450'       => 443,
        'uni045D'       => 576,
        'uni0487'       => 0,
        'uni0488'       => 0,
        'uni0489'       => 0,
        'uni048A'       => 777,
        'uni048B'       => 576,
        'uni048C'       => 661,
        'uni048D'       => 528,
        'uni048E'       => 610,
        'uni048F'       => 556,
        'uni04C5'       => 745,
        'uni04C6'       => 561,
        'uni04C9'       => 777,
        'uni04CA'       => 576,
        'uni04CD'       => 943,
        'uni04CE'       => 681,
        'uni04CF'       => 277,
        'uni04EC'       => 678,
        'uni04ED'       => 432,
        'uni04F6'       => 636,
        'uni04F7'       => 454,
        'uni04FA'       => 636,
        'uni04FB'       => 454,
        'uni04FC'       => 722,
        'uni04FD'       => 500,
        'uni04FE'       => 722,
        'uni04FF'       => 500,
        'uni0500'       => 661,
        'uni0501'       => 556,
        'uni0502'       => 852,
        'uni0503'       => 781,
        'uni0504'       => 796,
        'uni0505'       => 678,
        'uni0506'       => 594,
        'uni0507'       => 460,
        'uni0508'       => 935,
        'uni0509'       => 779,
        'uni050A'       => 970,
        'uni050B'       => 793,
        'uni050C'       => 777,
        'uni050D'       => 591,
        'uni050E'       => 715,
        'uni050F'       => 617,
        'uni0510'       => 527,
        'uni0511'       => 401,
        'uni0512'       => 745,
        'uni0513'       => 561,
        'uni0514'       => 1089,
        'uni0515'       => 748,
        'uni0516'       => 925,
        'uni0517'       => 796,
        'uni0518'       => 1010,
        'uni0519'       => 728,
        'uni051A'       => 777,
        'uni051B'       => 556,
        'uni051C'       => 1000,
        'uni051D'       => 722,
        'uni051E'       => 777,
        'uni051F'       => 613,
        'uni0520'       => 1042,
        'uni0521'       => 829,
        'uni0522'       => 1076,
        'uni0523'       => 843,
        'uni0524'       => 777,
        'uni0525'       => 576,
        'uni0526'       => 733,
        'uni0527'       => 556,
        'uni0528'       => 777,
        'uni0529'       => 576,
        'uni052A'       => 1465,
        'uni052B'       => 1072,
        'uni052C'       => 733,
        'uni052D'       => 555,
        'uni052E'       => 745,
        'uni052F'       => 561,
        'uni058A'       => 369,
        'uni058D'       => 934,
        'uni058E'       => 934,
        'uni058F'       => 760,
        'uni05A2'       => 0,
        'uni05BA'       => 0,
        'uni05C5'       => 0,
        'uni05C6'       => 315,
        'uni05C7'       => 0,
        'uni0600'       => 936,
        'uni0601'       => 1324,
        'uni0602'       => 331,
        'uni0603'       => 1308,
        'uni0604'       => 1299,
        'uni0605'       => 0,
        'uni0606'       => 615,
        'uni0607'       => 615,
        'uni0608'       => 825,
        'uni0609'       => 604,
        'uni060A'       => 735,
        'uni060B'       => 324,
        'uni060D'       => 238,
        'uni060E'       => 656,
        'uni060F'       => 541,
        'uni0610'       => 0,
        'uni0611'       => 0,
        'uni0612'       => 0,
        'uni0613'       => 0,
        'uni0614'       => 0,
        'uni0615'       => 0,
        'uni0616'       => 0,
        'uni0617'       => 0,
        'uni0618'       => 0,
        'uni0619'       => 0,
        'uni061A'       => 0,
        'uni061C'       => 1000,
        'uni061E'       => 404,
        'uni0620'       => 644,
        'uni063B'       => 756,
        'uni063C'       => 756,
        'uni063D'       => 644,
        'uni063E'       => 644,
        'uni063F'       => 644,
        'uni0653'       => 0,
        'uni0655'       => 0,
        'uni0656'       => 0,
        'uni0657'       => 0,
        'uni0658'       => 0,
        'uni0659'       => 0,
        'uni065A'       => 0,
        'uni065B'       => 0,
        'uni065C'       => 0,
        'uni065D'       => 0,
        'uni065E'       => 0,
        'uni065F'       => 207,
        'uni066E'       => 649,
        'uni066F'       => 612,
        'uni0670'       => 0,
        'uni0672'       => 216,
        'uni0673'       => 216,
        'uni0674'       => 216,
        'uni0675'       => 216,
        'uni0676'       => 451,
        'uni0678'       => 644,
        'uni067C'       => 649,
        'uni067D'       => 649,
        'uni0681'       => 577,
        'uni0682'       => 577,
        'uni0685'       => 577,
        'uni0689'       => 342,
        'uni068A'       => 342,
        'uni068B'       => 342,
        'uni068F'       => 342,
        'uni0690'       => 342,
        'uni0692'       => 432,
        'uni0693'       => 432,
        'uni0694'       => 432,
        'uni0695'       => 432,
        'uni0696'       => 432,
        'uni0697'       => 432,
        'uni0699'       => 432,
        'uni069A'       => 899,
        'uni069B'       => 899,
        'uni069C'       => 899,
        'uni069D'       => 1062,
        'uni069E'       => 1062,
        'uni069F'       => 523,
        'uni06A0'       => 541,
        'uni06A1'       => 757,
        'uni06A2'       => 757,
        'uni06A3'       => 757,
        'uni06A5'       => 757,
        'uni06A7'       => 612,
        'uni06A8'       => 612,
        'uni06AA'       => 1155,
        'uni06AB'       => 756,
        'uni06AC'       => 541,
        'uni06AE'       => 541,
        'uni06B0'       => 756,
        'uni06B2'       => 756,
        'uni06B4'       => 756,
        'uni06B5'       => 451,
        'uni06B6'       => 451,
        'uni06B7'       => 451,
        'uni06B8'       => 451,
        'uni06B9'       => 541,
        'uni06BC'       => 541,
        'uni06BD'       => 541,
        'uni06BF'       => 577,
        'uni06C2'       => 387,
        'uni06C3'       => 387,
        'uni06C4'       => 451,
        'uni06CA'       => 451,
        'uni06CD'       => 644,
        'uni06CE'       => 644,
        'uni06CF'       => 451,
        'uni06D4'       => 207,
        'uni06D6'       => 0,
        'uni06D7'       => 0,
        'uni06D8'       => 0,
        'uni06D9'       => 0,
        'uni06DA'       => 0,
        'uni06DB'       => 0,
        'uni06DC'       => 0,
        'uni06DD'       => 1123,
        'uni06DE'       => 1084,
        'uni06DF'       => 0,
        'uni06E0'       => 0,
        'uni06E1'       => 0,
        'uni06E2'       => 0,
        'uni06E3'       => 0,
        'uni06E4'       => 0,
        'uni06E5'       => 212,
        'uni06E6'       => 370,
        'uni06E7'       => 0,
        'uni06E8'       => 0,
        'uni06E9'       => 600,
        'uni06EA'       => 0,
        'uni06EB'       => 0,
        'uni06EC'       => 0,
        'uni06ED'       => 0,
        'uni06EE'       => 342,
        'uni06EF'       => 432,
        'uni06FA'       => 899,
        'uni06FB'       => 1062,
        'uni06FC'       => 541,
        'uni06FD'       => 468,
        'uni06FE'       => 360,
        'uni06FF'       => 468,
        'uni0750'       => 649,
        'uni0751'       => 649,
        'uni0752'       => 649,
        'uni0753'       => 649,
        'uni0754'       => 649,
        'uni0755'       => 649,
        'uni0756'       => 649,
        'uni0757'       => 577,
        'uni0758'       => 577,
        'uni0759'       => 342,
        'uni075A'       => 342,
        'uni075B'       => 432,
        'uni075C'       => 899,
        'uni075D'       => 541,
        'uni075E'       => 541,
        'uni075F'       => 541,
        'uni0760'       => 757,
        'uni0761'       => 757,
        'uni0762'       => 756,
        'uni0763'       => 756,
        'uni0764'       => 756,
        'uni0765'       => 360,
        'uni0766'       => 360,
        'uni0767'       => 541,
        'uni0768'       => 541,
        'uni0769'       => 541,
        'uni076A'       => 451,
        'uni076B'       => 432,
        'uni076C'       => 432,
        'uni076D'       => 899,
        'uni076E'       => 577,
        'uni076F'       => 577,
        'uni0770'       => 899,
        'uni0771'       => 432,
        'uni0772'       => 577,
        'uni0773'       => 216,
        'uni0774'       => 216,
        'uni0775'       => 644,
        'uni0776'       => 644,
        'uni0777'       => 644,
        'uni0778'       => 451,
        'uni0779'       => 451,
        'uni077A'       => 812,
        'uni077B'       => 812,
        'uni077C'       => 577,
        'uni077D'       => 899,
        'uni077E'       => 899,
        'uni077F'       => 541,
        'uni08A0'       => 649,
        'uni08A1'       => 649,
        'uni08A2'       => 577,
        'uni08A3'       => 523,
        'uni08A4'       => 757,
        'uni08A5'       => 612,
        'uni08A6'       => 451,
        'uni08A7'       => 360,
        'uni08A8'       => 644,
        'uni08A9'       => 644,
        'uni08AA'       => 402,
        'uni08AB'       => 451,
        'uni08AC'       => 427,
        'uni08AD'       => 166,
        'uni08AE'       => 342,
        'uni08AF'       => 1062,
        'uni08B0'       => 756,
        'uni08B1'       => 334,
        'uni08B2'       => 432,
        'uni08B3'       => 541,
        'uni08B4'       => 541,
        'uni08B6'       => 649,
        'uni08B7'       => 649,
        'uni08B8'       => 649,
        'uni08B9'       => 432,
        'uni08BA'       => 644,
        'uni08BB'       => 757,
        'uni08BC'       => 612,
        'uni08BD'       => 541,
        'uni08D4'       => 0,
        'uni08D5'       => 0,
        'uni08D6'       => 0,
        'uni08D7'       => 0,
        'uni08D8'       => 0,
        'uni08D9'       => 0,
        'uni08DA'       => 0,
        'uni08DB'       => 0,
        'uni08DC'       => 0,
        'uni08DD'       => 0,
        'uni08DE'       => 0,
        'uni08DF'       => 0,
        'uni08E0'       => 0,
        'uni08E1'       => 0,
        'uni08E2'       => 498,
        'uni08E3'       => 0,
        'uni08E4'       => 0,
        'uni08E5'       => 0,
        'uni08E6'       => 0,
        'uni08E7'       => 0,
        'uni08E8'       => 0,
        'uni08E9'       => 0,
        'uni08EA'       => 0,
        'uni08EB'       => 0,
        'uni08EC'       => 0,
        'uni08ED'       => 0,
        'uni08EE'       => 0,
        'uni08EF'       => 0,
        'uni08F0'       => 0,
        'uni08F1'       => 0,
        'uni08F2'       => 0,
        'uni08F3'       => 0,
        'uni08F4'       => 0,
        'uni08F5'       => 0,
        'uni08F6'       => 0,
        'uni08F7'       => 0,
        'uni08F8'       => 0,
        'uni08F9'       => 0,
        'uni08FA'       => 0,
        'uni08FB'       => 0,
        'uni08FC'       => 0,
        'uni08FD'       => 0,
        'uni08FE'       => 0,
        'uni08FF'       => 0,
        'uni1D00'       => 518,
        'uni1D01'       => 703,
        'uni1D02'       => 722,
        'uni1D03'       => 540,
        'uni1D04'       => 523,
        'uni1D05'       => 577,
        'uni1D06'       => 577,
        'uni1D07'       => 479,
        'uni1D08'       => 401,
        'uni1D09'       => 277,
        'uni1D0A'       => 397,
        'uni1D0B'       => 613,
        'uni1D0C'       => 483,
        'uni1D0D'       => 681,
        'uni1D0E'       => 576,
        'uni1D0F'       => 500,
        'uni1D10'       => 523,
        'uni1D11'       => 556,
        'uni1D12'       => 556,
        'uni1D13'       => 556,
        'uni1D14'       => 722,
        'uni1D15'       => 501,
        'uni1D16'       => 500,
        'uni1D17'       => 500,
        'uni1D18'       => 528,
        'uni1D19'       => 541,
        'uni1D1A'       => 541,
        'uni1D1B'       => 491,
        'uni1D1C'       => 546,
        'uni1D1D'       => 538,
        'uni1D1E'       => 713,
        'uni1D1F'       => 538,
        'uni1D20'       => 500,
        'uni1D21'       => 722,
        'uni1D22'       => 443,
        'uni1D23'       => 420,
        'uni1D24'       => 463,
        'uni1D25'       => 543,
        'uni1D26'       => 454,
        'uni1D27'       => 486,
        'uni1D28'       => 576,
        'uni1D29'       => 528,
        'uni1D2A'       => 599,
        'uni1D2B'       => 561,
        'uni1D2C'       => 426,
        'uni1D2D'       => 596,
        'uni1D2E'       => 395,
        'uni1D2F'       => 395,
        'uni1D30'       => 429,
        'uni1D31'       => 390,
        'uni1D32'       => 390,
        'uni1D33'       => 465,
        'uni1D34'       => 472,
        'uni1D35'       => 236,
        'uni1D36'       => 319,
        'uni1D37'       => 477,
        'uni1D38'       => 396,
        'uni1D39'       => 572,
        'uni1D3A'       => 440,
        'uni1D3B'       => 478,
        'uni1D3C'       => 451,
        'uni1D3D'       => 392,
        'uni1D3E'       => 362,
        'uni1D3F'       => 444,
        'uni1D40'       => 385,
        'uni1D41'       => 438,
        'uni1D42'       => 594,
        'uni1D43'       => 291,
        'uni1D44'       => 291,
        'uni1D45'       => 337,
        'uni1D46'       => 418,
        'uni1D47'       => 324,
        'uni1D48'       => 326,
        'uni1D49'       => 258,
        'uni1D4A'       => 258,
        'uni1D4B'       => 252,
        'uni1D4C'       => 252,
        'uni1D4D'       => 295,
        'uni1D4E'       => 177,
        'uni1D4F'       => 336,
        'uni1D50'       => 491,
        'uni1D51'       => 306,
        'uni1D52'       => 286,
        'uni1D53'       => 259,
        'uni1D54'       => 286,
        'uni1D55'       => 286,
        'uni1D56'       => 325,
        'uni1D57'       => 211,
        'uni1D58'       => 325,
        'uni1D59'       => 311,
        'uni1D5A'       => 491,
        'uni1D5B'       => 299,
        'uni1D5C'       => 322,
        'uni1D5D'       => 291,
        'uni1D5E'       => 281,
        'uni1D5F'       => 294,
        'uni1D60'       => 356,
        'uni1D61'       => 284,
        'uni1D62'       => 177,
        'uni1D63'       => 254,
        'uni1D64'       => 325,
        'uni1D65'       => 299,
        'uni1D66'       => 291,
        'uni1D67'       => 281,
        'uni1D68'       => 286,
        'uni1D69'       => 356,
        'uni1D6A'       => 284,
        'uni1D6B'       => 750,
        'uni1D6C'       => 556,
        'uni1D6D'       => 556,
        'uni1D6E'       => 333,
        'uni1D6F'       => 833,
        'uni1D70'       => 556,
        'uni1D71'       => 556,
        'uni1D72'       => 443,
        'uni1D73'       => 400,
        'uni1D74'       => 389,
        'uni1D75'       => 333,
        'uni1D76'       => 443,
        'uni1D77'       => 500,
        'uni1D78'       => 333,
        'uni1D79'       => 519,
        'uni1D7A'       => 845,
        'uni1D7B'       => 287,
        'uni1D7C'       => 310,
        'uni1D7D'       => 556,
        'uni1D7E'       => 546,
        'uni1D7F'       => 617,
        'uni1D80'       => 556,
        'uni1D81'       => 556,
        'uni1D82'       => 333,
        'uni1D83'       => 608,
        'uni1D84'       => 556,
        'uni1D85'       => 277,
        'uni1D86'       => 833,
        'uni1D87'       => 556,
        'uni1D88'       => 556,
        'uni1D89'       => 443,
        'uni1D8A'       => 389,
        'uni1D8B'       => 457,
        'uni1D8C'       => 500,
        'uni1D8D'       => 500,
        'uni1D8E'       => 443,
        'uni1D8F'       => 500,
        'uni1D90'       => 574,
        'uni1D91'       => 556,
        'uni1D92'       => 443,
        'uni1D93'       => 427,
        'uni1D94'       => 427,
        'uni1D95'       => 443,
        'uni1D96'       => 277,
        'uni1D97'       => 443,
        'uni1D98'       => 362,
        'uni1D99'       => 556,
        'uni1D9A'       => 458,
        'uni1D9B'       => 337,
        'uni1D9C'       => 259,
        'uni1D9D'       => 259,
        'uni1D9E'       => 286,
        'uni1D9F'       => 252,
        'uni1DA0'       => 195,
        'uni1DA1'       => 195,
        'uni1DA2'       => 282,
        'uni1DA3'       => 325,
        'uni1DA4'       => 177,
        'uni1DA5'       => 200,
        'uni1DA6'       => 177,
        'uni1DA7'       => 177,
        'uni1DA8'       => 229,
        'uni1DA9'       => 177,
        'uni1DAA'       => 177,
        'uni1DAB'       => 300,
        'uni1DAC'       => 491,
        'uni1DAD'       => 491,
        'uni1DAE'       => 325,
        'uni1DAF'       => 325,
        'uni1DB0'       => 323,
        'uni1DB1'       => 286,
        'uni1DB2'       => 419,
        'uni1DB3'       => 217,
        'uni1DB4'       => 177,
        'uni1DB5'       => 211,
        'uni1DB6'       => 325,
        'uni1DB7'       => 356,
        'uni1DB8'       => 325,
        'uni1DB9'       => 309,
        'uni1DBA'       => 299,
        'uni1DBB'       => 279,
        'uni1DBC'       => 279,
        'uni1DBD'       => 318,
        'uni1DBE'       => 280,
        'uni1DBF'       => 293,
        'uni1DC0'       => 0,
        'uni1DC1'       => 0,
        'uni1DC2'       => 0,
        'uni1DC3'       => 0,
        'uni1DC4'       => 0,
        'uni1DC5'       => 0,
        'uni1DC6'       => 0,
        'uni1DC7'       => 0,
        'uni1DC8'       => 0,
        'uni1DC9'       => 0,
        'uni1DCA'       => 0,
        'uni1DFE'       => 0,
        'uni1DFF'       => 0,
        'uni1E9C'       => 333,
        'uni1E9D'       => 333,
        'uni1E9E'       => 757,
        'uni1E9F'       => 519,
        'uni1EFA'       => 979,
        'uni1EFB'       => 551,
        'uni1EFC'       => 559,
        'uni1EFD'       => 496,
        'uni1EFE'       => 650,
        'uni1EFF'       => 539,
        'uni1F00'       => 558,
        'uni1F01'       => 558,
        'uni1F02'       => 558,
        'uni1F03'       => 558,
        'uni1F04'       => 558,
        'uni1F05'       => 558,
        'uni1F06'       => 558,
        'uni1F07'       => 558,
        'uni1F08'       => 722,
        'uni1F09'       => 722,
        'uni1F0A'       => 800,
        'uni1F0B'       => 800,
        'uni1F0C'       => 746,
        'uni1F0D'       => 746,
        'uni1F0E'       => 722,
        'uni1F0F'       => 722,
        'uni1F10'       => 427,
        'uni1F11'       => 427,
        'uni1F12'       => 427,
        'uni1F13'       => 427,
        'uni1F14'       => 427,
        'uni1F15'       => 427,
        'uni1F18'       => 801,
        'uni1F19'       => 801,
        'uni1F1A'       => 989,
        'uni1F1B'       => 989,
        'uni1F1C'       => 989,
        'uni1F1D'       => 989,
        'uni1F20'       => 567,
        'uni1F21'       => 567,
        'uni1F22'       => 567,
        'uni1F23'       => 567,
        'uni1F24'       => 567,
        'uni1F25'       => 567,
        'uni1F26'       => 567,
        'uni1F27'       => 567,
        'uni1F28'       => 912,
        'uni1F29'       => 912,
        'uni1F2A'       => 1100,
        'uni1F2B'       => 1100,
        'uni1F2C'       => 1100,
        'uni1F2D'       => 1100,
        'uni1F2E'       => 1100,
        'uni1F2F'       => 1100,
        'uni1F30'       => 310,
        'uni1F31'       => 310,
        'uni1F32'       => 310,
        'uni1F33'       => 310,
        'uni1F34'       => 310,
        'uni1F35'       => 310,
        'uni1F36'       => 310,
        'uni1F37'       => 310,
        'uni1F38'       => 523,
        'uni1F39'       => 523,
        'uni1F3A'       => 711,
        'uni1F3B'       => 711,
        'uni1F3C'       => 711,
        'uni1F3D'       => 711,
        'uni1F3E'       => 711,
        'uni1F3F'       => 711,
        'uni1F40'       => 500,
        'uni1F41'       => 500,
        'uni1F42'       => 500,
        'uni1F43'       => 500,
        'uni1F44'       => 500,
        'uni1F45'       => 500,
        'uni1F48'       => 875,
        'uni1F49'       => 875,
        'uni1F4A'       => 1061,
        'uni1F4B'       => 1061,
        'uni1F4C'       => 987,
        'uni1F4D'       => 987,
        'uni1F50'       => 519,
        'uni1F51'       => 519,
        'uni1F52'       => 519,
        'uni1F53'       => 519,
        'uni1F54'       => 519,
        'uni1F55'       => 519,
        'uni1F56'       => 519,
        'uni1F57'       => 519,
        'uni1F59'       => 866,
        'uni1F5B'       => 1044,
        'uni1F5D'       => 1044,
        'uni1F5F'       => 1044,
        'uni1F60'       => 730,
        'uni1F61'       => 730,
        'uni1F62'       => 730,
        'uni1F63'       => 730,
        'uni1F64'       => 730,
        'uni1F65'       => 730,
        'uni1F66'       => 730,
        'uni1F67'       => 730,
        'uni1F68'       => 886,
        'uni1F69'       => 886,
        'uni1F6A'       => 1074,
        'uni1F6B'       => 1074,
        'uni1F6C'       => 1010,
        'uni1F6D'       => 1010,
        'uni1F6E'       => 1010,
        'uni1F6F'       => 1010,
        'uni1F70'       => 558,
        'uni1F71'       => 558,
        'uni1F72'       => 427,
        'uni1F73'       => 427,
        'uni1F74'       => 567,
        'uni1F75'       => 567,
        'uni1F76'       => 310,
        'uni1F77'       => 310,
        'uni1F78'       => 500,
        'uni1F79'       => 500,
        'uni1F7A'       => 519,
        'uni1F7B'       => 519,
        'uni1F7C'       => 730,
        'uni1F7D'       => 730,
        'uni1F80'       => 558,
        'uni1F81'       => 558,
        'uni1F82'       => 558,
        'uni1F83'       => 558,
        'uni1F84'       => 558,
        'uni1F85'       => 558,
        'uni1F86'       => 558,
        'uni1F87'       => 558,
        'uni1F88'       => 722,
        'uni1F89'       => 722,
        'uni1F8A'       => 800,
        'uni1F8B'       => 800,
        'uni1F8C'       => 746,
        'uni1F8D'       => 746,
        'uni1F8E'       => 722,
        'uni1F8F'       => 722,
        'uni1F90'       => 567,
        'uni1F91'       => 567,
        'uni1F92'       => 567,
        'uni1F93'       => 567,
        'uni1F94'       => 567,
        'uni1F95'       => 567,
        'uni1F96'       => 567,
        'uni1F97'       => 567,
        'uni1F98'       => 912,
        'uni1F99'       => 912,
        'uni1F9A'       => 1100,
        'uni1F9B'       => 1100,
        'uni1F9C'       => 1100,
        'uni1F9D'       => 1100,
        'uni1F9E'       => 1100,
        'uni1F9F'       => 1100,
        'uni1FA0'       => 730,
        'uni1FA1'       => 730,
        'uni1FA2'       => 730,
        'uni1FA3'       => 730,
        'uni1FA4'       => 730,
        'uni1FA5'       => 730,
        'uni1FA6'       => 730,
        'uni1FA7'       => 730,
        'uni1FA8'       => 886,
        'uni1FA9'       => 886,
        'uni1FAA'       => 1074,
        'uni1FAB'       => 1074,
        'uni1FAC'       => 1010,
        'uni1FAD'       => 1010,
        'uni1FAE'       => 1010,
        'uni1FAF'       => 1010,
        'uni1FB0'       => 558,
        'uni1FB1'       => 558,
        'uni1FB2'       => 558,
        'uni1FB3'       => 558,
        'uni1FB4'       => 558,
        'uni1FB6'       => 558,
        'uni1FB7'       => 558,
        'uni1FB8'       => 722,
        'uni1FB9'       => 722,
        'uni1FBA'       => 722,
        'uni1FBB'       => 722,
        'uni1FBC'       => 722,
        'uni1FBD'       => 333,
        'uni1FBE'       => 333,
        'uni1FBF'       => 333,
        'uni1FC0'       => 333,
        'uni1FC1'       => 333,
        'uni1FC2'       => 567,
        'uni1FC3'       => 567,
        'uni1FC4'       => 567,
        'uni1FC6'       => 567,
        'uni1FC7'       => 567,
        'uni1FC8'       => 843,
        'uni1FC9'       => 853,
        'uni1FCA'       => 954,
        'uni1FCB'       => 969,
        'uni1FCC'       => 777,
        'uni1FCD'       => 333,
        'uni1FCE'       => 333,
        'uni1FCF'       => 333,
        'uni1FD0'       => 310,
        'uni1FD1'       => 310,
        'uni1FD2'       => 310,
        'uni1FD3'       => 310,
        'uni1FD6'       => 310,
        'uni1FD7'       => 310,
        'uni1FD8'       => 389,
        'uni1FD9'       => 389,
        'uni1FDA'       => 565,
        'uni1FDB'       => 580,
        'uni1FDD'       => 333,
        'uni1FDE'       => 333,
        'uni1FDF'       => 333,
        'uni1FE0'       => 519,
        'uni1FE1'       => 519,
        'uni1FE2'       => 519,
        'uni1FE3'       => 519,
        'uni1FE4'       => 535,
        'uni1FE5'       => 535,
        'uni1FE6'       => 519,
        'uni1FE7'       => 519,
        'uni1FE8'       => 722,
        'uni1FE9'       => 722,
        'uni1FEA'       => 928,
        'uni1FEB'       => 933,
        'uni1FEC'       => 745,
        'uni1FED'       => 333,
        'uni1FEE'       => 333,
        'uni1FEF'       => 333,
        'uni1FF2'       => 730,
        'uni1FF3'       => 730,
        'uni1FF4'       => 730,
        'uni1FF6'       => 730,
        'uni1FF7'       => 730,
        'uni1FF8'       => 925,
        'uni1FF9'       => 812,
        'uni1FFA'       => 948,
        'uni1FFB'       => 826,
        'uni1FFC'       => 800,
        'uni1FFD'       => 333,
        'uni1FFE'       => 333,
        'uni2000'       => 500,
        'uni2001'       => 1000,
        'uni2006'       => 166,
        'uni2011'       => 333,
        'uni201F'       => 500,
        'uni2023'       => 350,
        'uni2027'       => 250,
        'uni2028'       => 1000,
        'uni2029'       => 1000,
        'uni202A'       => 750,
        'uni202B'       => 750,
        'uni202F'       => 200,
        'uni2031'       => 1331,
        'uni2036'       => 496,
        'uni2037'       => 552,
        'uni2038'       => 312,
        'uni203D'       => 500,
        'uni203F'       => 956,
        'uni2040'       => 956,
        'uni2045'       => 333,
        'uni2046'       => 333,
        'uni2047'       => 931,
        'uni2048'       => 755,
        'uni2049'       => 750,
        'uni204A'       => 487,
        'uni204B'       => 540,
        'uni204C'       => 493,
        'uni204D'       => 493,
        'uni204E'       => 500,
        'uni204F'       => 333,
        'uni2050'       => 956,
        'uni2051'       => 500,
        'uni2052'       => 569,
        'uni2053'       => 543,
        'uni2054'       => 956,
        'uni2055'       => 500,
        'uni2056'       => 573,
        'uni2057'       => 736,
        'uni2058'       => 652,
        'uni2059'       => 652,
        'uni205A'       => 333,
        'uni205B'       => 1043,
        'uni205C'       => 652,
        'uni205D'       => 333,
        'uni205E'       => 333,
        'uni205F'       => 222,
        'uni2060'       => 0,
        'uni2061'       => 1000,
        'uni2062'       => 1000,
        'uni2063'       => 1000,
        'uni2064'       => 1000,
        'uni2066'       => 1000,
        'uni2067'       => 1000,
        'uni2068'       => 1000,
        'uni2069'       => 1000,
        'uni206A'       => 750,
        'uni206B'       => 750,
        'uni206C'       => 750,
        'uni206D'       => 750,
        'uni206E'       => 750,
        'uni206F'       => 750,
        'uni2071'       => 166,
        'uni207B'       => 299,
        'uni208A'       => 299,
        'uni208B'       => 299,
        'uni208C'       => 299,
        'uni2090'       => 291,
        'uni2091'       => 258,
        'uni2092'       => 286,
        'uni2093'       => 286,
        'uni2094'       => 258,
        'uni2095'       => 325,
        'uni2096'       => 336,
        'uni2097'       => 177,
        'uni2098'       => 491,
        'uni2099'       => 333,
        'uni209A'       => 325,
        'uni209B'       => 217,
        'uni209C'       => 211,
        'uni20A0'       => 636,
        'uni20A5'       => 833,
        'uni20A6'       => 722,
        'uni20A8'       => 1213,
        'uni20AD'       => 777,
        'uni20AE'       => 666,
        'uni20AF'       => 1117,
        'uni20B0'       => 500,
        'uni20B1'       => 610,
        'uni20B2'       => 777,
        'uni20B3'       => 722,
        'uni20B4'       => 556,
        'uni20B5'       => 722,
        'uni20B6'       => 555,
        'uni20B7'       => 556,
        'uni20B8'       => 666,
        'uni20B9'       => 500,
        'uni20BA'       => 500,
        'uni20BB'       => 702,
        'uni20BC'       => 790,
        'uni20BD'       => 500,
        'uni20BE'       => 744,
        'uni20BF'       => 666,
        'uni20F0'       => 0,
        'uni2100'       => 833,
        'uni2101'       => 833,
        'uni2102'       => 722,
        'uni2104'       => 714,
        'uni2106'       => 887,
        'uni2107'       => 549,
        'uni2108'       => 677,
        'uni210A'       => 509,
        'uni210C'       => 987,
        'uni210D'       => 777,
        'uni210E'       => 556,
        'uni2110'       => 687,
        'uni2114'       => 860,
        'uni2115'       => 722,
        'uni2119'       => 610,
        'uni211A'       => 777,
        'uni211B'       => 926,
        'uni211D'       => 722,
        'uni211F'       => 722,
        'uni2120'       => 949,
        'uni2123'       => 722,
        'uni2124'       => 666,
        'uni2125'       => 458,
        'uni2127'       => 800,
        'uni2128'       => 713,
        'uni2129'       => 310,
        'uni212A'       => 777,
        'uni212D'       => 645,
        'uni212F'       => 384,
        'uni2130'       => 615,
        'uni2131'       => 687,
        'uni2132'       => 610,
        'uni2139'       => 326,
        'uni213A'       => 901,
        'uni213B'       => 1238,
        'uni213C'       => 547,
        'uni213D'       => 467,
        'uni213E'       => 636,
        'uni213F'       => 777,
        'uni2140'       => 729,
        'uni2141'       => 777,
        'uni2142'       => 610,
        'uni2143'       => 610,
        'uni2144'       => 666,
        'uni2145'       => 722,
        'uni2146'       => 500,
        'uni2147'       => 443,
        'uni2148'       => 277,
        'uni2149'       => 277,
        'uni214A'       => 701,
        'uni214B'       => 833,
        'uni214C'       => 883,
        'uni214D'       => 917,
        'uni214E'       => 479,
        'uni214F'       => 1370,
        'uni2150'       => 750,
        'uni2151'       => 750,
        'uni2152'       => 1014,
        'uni215F'       => 458,
        'uni216C'       => 666,
        'uni216D'       => 722,
        'uni216E'       => 722,
        'uni216F'       => 943,
        'uni217C'       => 277,
        'uni217D'       => 443,
        'uni217E'       => 556,
        'uni217F'       => 833,
        'uni2180'       => 1072,
        'uni2181'       => 722,
        'uni2182'       => 1072,
        'uni2183'       => 722,
        'uni2184'       => 443,
        'uni2185'       => 750,
        'uni2186'       => 688,
        'uni2187'       => 722,
        'uni2188'       => 1072,
        'uni2189'       => 750,
        'uni218A'       => 500,
        'uni218B'       => 500,
        'uni2C60'       => 666,
        'uni2C61'       => 277,
        'uni2C62'       => 666,
        'uni2C63'       => 610,
        'uni2C64'       => 722,
        'uni2C65'       => 500,
        'uni2C66'       => 333,
        'uni2C67'       => 777,
        'uni2C68'       => 556,
        'uni2C69'       => 777,
        'uni2C6A'       => 556,
        'uni2C6B'       => 666,
        'uni2C6C'       => 443,
        'uni2C6D'       => 823,
        'uni2C6E'       => 943,
        'uni2C6F'       => 722,
        'uni2C70'       => 823,
        'uni2C71'       => 611,
        'uni2C72'       => 1089,
        'uni2C73'       => 836,
        'uni2C74'       => 491,
        'uni2C75'       => 646,
        'uni2C76'       => 483,
        'uni2C77'       => 624,
        'uni2C78'       => 566,
        'uni2C79'       => 443,
        'uni2C7A'       => 519,
        'uni2C7B'       => 479,
        'uni2C7C'       => 180,
        'uni2C7D'       => 500,
        'uni2C7E'       => 556,
        'uni2C7F'       => 666,
        'uni2E00'       => 333,
        'uni2E01'       => 333,
        'uni2E02'       => 333,
        'uni2E03'       => 333,
        'uni2E04'       => 333,
        'uni2E05'       => 333,
        'uni2E06'       => 432,
        'uni2E07'       => 432,
        'uni2E08'       => 419,
        'uni2E09'       => 419,
        'uni2E0A'       => 419,
        'uni2E0B'       => 421,
        'uni2E0C'       => 421,
        'uni2E0D'       => 421,
        'uni2E0E'       => 838,
        'uni2E0F'       => 0,
        'uni2E10'       => 0,
        'uni2E11'       => 0,
        'uni2E12'       => 250,
        'uni2E13'       => 548,
        'uni2E14'       => 666,
        'uni2E15'       => 666,
        'uni2E16'       => 569,
        'uni2E17'       => 333,
        'uni2E18'       => 500,
        'uni2E19'       => 500,
        'uni2E1A'       => 333,
        'uni2E1B'       => 548,
        'uni2E1C'       => 421,
        'uni2E1D'       => 421,
        'uni2E1E'       => 548,
        'uni2E1F'       => 548,
        'uni2E20'       => 333,
        'uni2E21'       => 333,
        'uni2E22'       => 333,
        'uni2E23'       => 333,
        'uni2E24'       => 333,
        'uni2E25'       => 333,
        'uni2E26'       => 744,
        'uni2E27'       => 744,
        'uni2E28'       => 547,
        'uni2E29'       => 547,
        'uni2E2A'       => 652,
        'uni2E2B'       => 652,
        'uni2E2C'       => 652,
        'uni2E2D'       => 652,
        'uni2E2E'       => 500,
        'uni2E2F'       => 333,
        'uni2E30'       => 354,
        'uni2E31'       => 333,
        'uni2E32'       => 250,
        'uni2E33'       => 250,
        'uni2E34'       => 250,
        'uni2E35'       => 333,
        'uni2E36'       => 500,
        'uni2E37'       => 500,
        'uni2E38'       => 500,
        'uni2E39'       => 500,
        'uni2E3A'       => 1000,
        'uni2E3B'       => 1000,
        'uni2E3C'       => 250,
        'uni2E3D'       => 277,
        'uni2E3E'       => 277,
        'uni2E3F'       => 722,
        'uni2E40'       => 333,
        'uni2E41'       => 250,
        'uni2E42'       => 500,
        'uniA717'       => 0,
        'uniA718'       => 0,
        'uniA719'       => 0,
        'uniA71A'       => 0,
        'uniA71B'       => 500,
        'uniA71C'       => 500,
        'uniA71D'       => 333,
        'uniA71E'       => 333,
        'uniA71F'       => 333,
        'uniA720'       => 0,
        'uniA721'       => 0,
        'uniA722'       => 268,
        'uniA723'       => 220,
        'uniA724'       => 268,
        'uniA725'       => 220,
        'uniA726'       => 777,
        'uniA727'       => 556,
        'uniA728'       => 811,
        'uniA729'       => 630,
        'uniA72A'       => 527,
        'uniA72B'       => 527,
        'uniA72C'       => 486,
        'uniA72D'       => 486,
        'uniA72E'       => 567,
        'uniA72F'       => 567,
        'uniA730'       => 443,
        'uniA731'       => 446,
        'uniA732'       => 1161,
        'uniA733'       => 744,
        'uniA734'       => 1133,
        'uniA735'       => 744,
        'uniA736'       => 1056,
        'uniA737'       => 761,
        'uniA738'       => 883,
        'uniA739'       => 695,
        'uniA73A'       => 883,
        'uniA73B'       => 695,
        'uniA73C'       => 883,
        'uniA73D'       => 695,
        'uniA73E'       => 722,
        'uniA73F'       => 443,
        'uniA740'       => 777,
        'uniA741'       => 556,
        'uniA742'       => 777,
        'uniA743'       => 556,
        'uniA744'       => 777,
        'uniA745'       => 556,
        'uniA746'       => 826,
        'uniA747'       => 414,
        'uniA748'       => 666,
        'uniA749'       => 277,
        'uniA74A'       => 870,
        'uniA74B'       => 568,
        'uniA74C'       => 833,
        'uniA74D'       => 563,
        'uniA74E'       => 1304,
        'uniA74F'       => 785,
        'uniA750'       => 610,
        'uniA751'       => 556,
        'uniA752'       => 689,
        'uniA753'       => 663,
        'uniA754'       => 855,
        'uniA755'       => 810,
        'uniA756'       => 777,
        'uniA757'       => 556,
        'uniA758'       => 909,
        'uniA759'       => 645,
        'uniA75A'       => 674,
        'uniA75B'       => 529,
        'uniA75C'       => 636,
        'uniA75D'       => 557,
        'uniA75E'       => 722,
        'uniA75F'       => 500,
        'uniA760'       => 1000,
        'uniA761'       => 722,
        'uniA762'       => 545,
        'uniA763'       => 501,
        'uniA764'       => 610,
        'uniA765'       => 556,
        'uniA766'       => 610,
        'uniA767'       => 556,
        'uniA768'       => 573,
        'uniA769'       => 431,
        'uniA76A'       => 451,
        'uniA76B'       => 451,
        'uniA76C'       => 575,
        'uniA76D'       => 575,
        'uniA76E'       => 500,
        'uniA76F'       => 500,
        'uniA770'       => 311,
        'uniA771'       => 722,
        'uniA772'       => 458,
        'uniA773'       => 1001,
        'uniA774'       => 722,
        'uniA775'       => 463,
        'uniA776'       => 707,
        'uniA777'       => 734,
        'uniA778'       => 480,
        'uniA779'       => 777,
        'uniA77A'       => 500,
        'uniA77B'       => 525,
        'uniA77C'       => 443,
        'uniA77D'       => 539,
        'uniA77E'       => 539,
        'uniA77F'       => 539,
        'uniA780'       => 666,
        'uniA781'       => 277,
        'uniA782'       => 769,
        'uniA783'       => 590,
        'uniA784'       => 525,
        'uniA785'       => 443,
        'uniA786'       => 666,
        'uniA787'       => 430,
        'uniA788'       => 333,
        'uniA789'       => 333,
        'uniA78A'       => 374,
        'uniA78B'       => 277,
        'uniA78C'       => 277,
        'uniA78D'       => 777,
        'uniA78E'       => 489,
        'uniA78F'       => 333,
        'uniA790'       => 722,
        'uniA791'       => 556,
        'uniA792'       => 722,
        'uniA793'       => 443,
        'uniA794'       => 443,
        'uniA795'       => 556,
        'uniA796'       => 750,
        'uniA797'       => 695,
        'uniA798'       => 610,
        'uniA799'       => 333,
        'uniA79A'       => 780,
        'uniA79B'       => 545,
        'uniA79C'       => 768,
        'uniA79D'       => 521,
        'uniA79E'       => 830,
        'uniA79F'       => 552,
        'uniA7A0'       => 777,
        'uniA7A1'       => 500,
        'uniA7A2'       => 777,
        'uniA7A3'       => 556,
        'uniA7A4'       => 722,
        'uniA7A5'       => 556,
        'uniA7A6'       => 722,
        'uniA7A7'       => 443,
        'uniA7A8'       => 556,
        'uniA7A9'       => 389,
        'uniA7AA'       => 864,
        'uniA7AB'       => 527,
        'uniA7AC'       => 823,
        'uniA7AD'       => 739,
        'uniA7AE'       => 666,
        'uniA7B0'       => 777,
        'uniA7B1'       => 666,
        'uniA7B2'       => 500,
        'uniA7B3'       => 697,
        'uniA7B4'       => 666,
        'uniA7B5'       => 526,
        'uniA7B6'       => 962,
        'uniA7B7'       => 730,
        'uniA7F7'       => 681,
        'uniA7F8'       => 472,
        'uniA7F9'       => 473,
        'uniA7FA'       => 833,
        'uniA7FB'       => 610,
        'uniA7FC'       => 610,
        'uniA7FD'       => 943,
        'uniA7FE'       => 389,
        'uniA7FF'       => 1163,
        'uniAB30'       => 558,
        'uniAB31'       => 699,
        'uniAB32'       => 451,
        'uniAB33'       => 443,
        'uniAB34'       => 573,
        'uniAB35'       => 333,
        'uniAB36'       => 556,
        'uniAB37'       => 391,
        'uniAB38'       => 327,
        'uniAB39'       => 309,
        'uniAB3A'       => 833,
        'uniAB3B'       => 562,
        'uniAB3C'       => 541,
        'uniAB3D'       => 517,
        'uniAB3E'       => 517,
        'uniAB3F'       => 500,
        'uniAB40'       => 740,
        'uniAB41'       => 722,
        'uniAB42'       => 722,
        'uniAB43'       => 785,
        'uniAB44'       => 785,
        'uniAB45'       => 531,
        'uniAB46'       => 566,
        'uniAB47'       => 394,
        'uniAB48'       => 600,
        'uniAB49'       => 484,
        'uniAB4A'       => 640,
        'uniAB4B'       => 496,
        'uniAB4C'       => 705,
        'uniAB4D'       => 302,
        'uniAB4E'       => 556,
        'uniAB4F'       => 556,
        'uniAB50'       => 833,
        'uniAB51'       => 833,
        'uniAB52'       => 582,
        'uniAB53'       => 461,
        'uniAB54'       => 461,
        'uniAB55'       => 461,
        'uniAB56'       => 500,
        'uniAB57'       => 500,
        'uniAB58'       => 500,
        'uniAB59'       => 500,
        'uniAB5A'       => 500,
        'uniAB5B'       => 333,
        'uniAB5C'       => 321,
        'uniAB5D'       => 242,
        'uniAB5E'       => 242,
        'uniAB5F'       => 327,
        'uniAB60'       => 801,
        'uniAB61'       => 687,
        'uniAB62'       => 696,
        'uniAB63'       => 806,
        'uniAB64'       => 558,
        'uniAB65'       => 596,
        'uniF301'       => 0,
        'uniFB05'       => 602,
        'uniFB06'       => 680,
        'uniFB13'       => 1130,
        'uniFB14'       => 1119,
        'uniFB15'       => 1108,
        'uniFB16'       => 1133,
        'uniFB17'       => 1388,
        'uniFB1D'       => 310,
        'uniFB1E'       => 0,
        'uniFB21'       => 673,
        'uniFB22'       => 610,
        'uniFB23'       => 658,
        'uniFB24'       => 592,
        'uniFB25'       => 581,
        'uniFB26'       => 657,
        'uniFB27'       => 610,
        'uniFB28'       => 664,
        'uniFB29'       => 569,
        'uniFB50'       => 216,
        'uniFB51'       => 234,
        'uniFB52'       => 649,
        'uniFB53'       => 649,
        'uniFB54'       => 271,
        'uniFB55'       => 271,
        'uniFB56'       => 649,
        'uniFB5A'       => 649,
        'uniFB5B'       => 649,
        'uniFB5C'       => 271,
        'uniFB5D'       => 271,
        'uniFB5E'       => 649,
        'uniFB5F'       => 649,
        'uniFB60'       => 271,
        'uniFB61'       => 271,
        'uniFB62'       => 649,
        'uniFB63'       => 649,
        'uniFB64'       => 271,
        'uniFB65'       => 271,
        'uniFB66'       => 649,
        'uniFB6A'       => 757,
        'uniFB6E'       => 757,
        'uniFB6F'       => 757,
        'uniFB70'       => 304,
        'uniFB71'       => 324,
        'uniFB72'       => 577,
        'uniFB73'       => 558,
        'uniFB74'       => 523,
        'uniFB75'       => 523,
        'uniFB76'       => 577,
        'uniFB77'       => 558,
        'uniFB78'       => 523,
        'uniFB79'       => 523,
        'uniFB7A'       => 577,
        'uniFB7E'       => 577,
        'uniFB7F'       => 558,
        'uniFB80'       => 523,
        'uniFB81'       => 523,
        'uniFB82'       => 342,
        'uniFB83'       => 342,
        'uniFB84'       => 342,
        'uniFB85'       => 342,
        'uniFB86'       => 342,
        'uniFB87'       => 342,
        'uniFB88'       => 342,
        'uniFB8A'       => 432,
        'uniFB8C'       => 432,
        'uniFB8E'       => 756,
        'uniFB8F'       => 878,
        'uniFB90'       => 360,
        'uniFB91'       => 541,
        'uniFB92'       => 756,
        'uniFB96'       => 756,
        'uniFB97'       => 878,
        'uniFB98'       => 360,
        'uniFB99'       => 541,
        'uniFB9A'       => 756,
        'uniFB9B'       => 878,
        'uniFB9C'       => 360,
        'uniFB9D'       => 541,
        'uniFB9E'       => 541,
        'uniFBA0'       => 541,
        'uniFBA1'       => 541,
        'uniFBA2'       => 271,
        'uniFBA3'       => 271,
        'uniFBA6'       => 342,
        'uniFBAE'       => 812,
        'uniFBB0'       => 812,
        'uniFBB1'       => 812,
        'uniFBB2'       => 244,
        'uniFBB3'       => 271,
        'uniFBB4'       => 244,
        'uniFBB5'       => 271,
        'uniFBB6'       => 244,
        'uniFBB7'       => 271,
        'uniFBB8'       => 244,
        'uniFBB9'       => 271,
        'uniFBBA'       => 244,
        'uniFBBB'       => 271,
        'uniFBBC'       => 272,
        'uniFBBD'       => 244,
        'uniFBBE'       => 271,
        'uniFBBF'       => 199,
        'uniFBC0'       => 343,
        'uniFBC1'       => 343,
        'uniFBD3'       => 541,
        'uniFBD4'       => 541,
        'uniFBD5'       => 360,
        'uniFBD6'       => 360,
        'uniFBD7'       => 451,
        'uniFBD8'       => 451,
        'uniFBD9'       => 451,
        'uniFBDA'       => 451,
        'uniFBDB'       => 451,
        'uniFBDC'       => 451,
        'uniFBDD'       => 451,
        'uniFBDE'       => 451,
        'uniFBDF'       => 451,
        'uniFBE0'       => 451,
        'uniFBE1'       => 451,
        'uniFBE2'       => 451,
        'uniFBE3'       => 451,
        'uniFBE4'       => 644,
        'uniFBE5'       => 554,
        'uniFBE6'       => 271,
        'uniFBE7'       => 271,
        'uniFBE9'       => 271,
        'uniFBEA'       => 371,
        'uniFBEB'       => 371,
        'uniFBEC'       => 548,
        'uniFBED'       => 548,
        'uniFBEE'       => 672,
        'uniFBEF'       => 672,
        'uniFBF0'       => 672,
        'uniFBF1'       => 672,
        'uniFBF2'       => 672,
        'uniFBF3'       => 672,
        'uniFBF4'       => 672,
        'uniFBF5'       => 672,
        'uniFBF6'       => 552,
        'uniFBF7'       => 552,
        'uniFBF8'       => 528,
        'uniFBF9'       => 552,
        'uniFBFA'       => 552,
        'uniFBFB'       => 528,
        'uniFBFC'       => 644,
        'uniFBFD'       => 554,
        'uniFC63'       => 0,
        'uniFCF2'       => 198,
        'uniFCF3'       => 198,
        'uniFCF4'       => 198,
        'uniFD3C'       => 234,
        'uniFD3D'       => 207,
        'uniFDF4'       => 965,
        'uniFDFB'       => 636,
        'uniFDFC'       => 1189,
        'uniFDFD'       => 1432,
        'uniFE20'       => 0,
        'uniFE21'       => 0,
        'uniFE22'       => 0,
        'uniFE23'       => 0,
        'uniFE70'       => 207,
        'uniFE71'       => 198,
        'uniFE72'       => 207,
        'uniFE73'       => 289,
        'uniFE74'       => 207,
        'uniFE76'       => 207,
        'uniFE77'       => 198,
        'uniFE78'       => 207,
        'uniFE79'       => 198,
        'uniFE7A'       => 207,
        'uniFE7B'       => 198,
        'uniFE7C'       => 207,
        'uniFE7D'       => 198,
        'uniFE7E'       => 207,
        'uniFE7F'       => 198,
        'uniFE80'       => 468,
        'uniFE81'       => 238,
        'uniFE83'       => 216,
        'uniFE85'       => 451,
        'uniFE87'       => 216,
        'uniFE89'       => 644,
        'uniFE8D'       => 216,
        'uniFE8F'       => 649,
        'uniFE93'       => 342,
        'uniFE95'       => 649,
        'uniFE99'       => 649,
        'uniFE9D'       => 577,
        'uniFEA1'       => 577,
        'uniFEA5'       => 577,
        'uniFEA9'       => 342,
        'uniFEAB'       => 342,
        'uniFEAD'       => 432,
        'uniFEAF'       => 432,
        'uniFEB1'       => 899,
        'uniFEB5'       => 899,
        'uniFEB9'       => 1062,
        'uniFEBD'       => 1062,
        'uniFEC1'       => 523,
        'uniFEC5'       => 523,
        'uniFEC9'       => 541,
        'uniFECD'       => 541,
        'uniFED1'       => 757,
        'uniFED5'       => 612,
        'uniFED9'       => 541,
        'uniFEDD'       => 451,
        'uniFEE1'       => 360,
        'uniFEE5'       => 541,
        'uniFEE9'       => 342,
        'uniFEED'       => 451,
        'uniFEEF'       => 644,
        'uniFEF1'       => 644,
        'uniFFFC'       => 1000,
        'uogonek'       => 556,
        'upblock'       => 708,
        'upperdothebrew'       => 0,
        'upsilon'       => 519,
        'upsilondieresis'       => 519,
        'upsilondieresistonos'       => 519,
        'upsilonlatin'       => 617,
        'upsilontonos'       => 519,
        'uptackbelowcmb'       => 0,
        'uptackmod'       => 333,
        'uring'       => 556,
        'ustraightcyrillic'       => 500,
        'ustraightstrokecyrillic'       => 500,
        'utilde'       => 556,
        'utildeacute'       => 556,
        'utildebelow'       => 556,
        'v'       => 500,
        'vdotbelow'       => 500,
        'vehfinalarabic'       => 757,
        'vehinitialarabic'       => 304,
        'vehmedialarabic'       => 324,
        'verticallineabovecmb'       => 0,
        'verticallinebelowcmb'       => 0,
        'verticallinelowmod'       => 333,
        'verticallinemod'       => 333,
        'vewarmenian'       => 567,
        'vhook'       => 523,
        'voarmenian'       => 565,
        'vtilde'       => 500,
        'vturned'       => 500,
        'w'       => 722,
        'wacute'       => 722,
        'wawfinalarabic'       => 451,
        'wawhamzaabovefinalarabic'       => 451,
        'wcircumflex'       => 722,
        'wdieresis'       => 722,
        'wdotaccent'       => 722,
        'wdotbelow'       => 722,
        'weierstrass'       => 740,
        'wgrave'       => 722,
        'won'       => 1000,
        'wring'       => 722,
        'wsuperior'       => 432,
        'wturned'       => 722,
        'wynn'       => 596,
        'x'       => 500,
        'xabovecmb'       => 0,
        'xdieresis'       => 500,
        'xdotaccent'       => 500,
        'xeharmenian'       => 823,
        'xi'       => 445,
        'xsuperior'       => 286,
        'y'       => 500,
        'yacute'       => 500,
        'ycircumflex'       => 500,
        'ydieresis'       => 500,
        'ydotaccent'       => 500,
        'ydotbelow'       => 500,
        'yehbarreefinalarabic'       => 812,
        'yehfinalarabic'       => 577,
        'yehhamzaabovefinalarabic'       => 577,
        'yehhamzaaboveinitialarabic'       => 271,
        'yehhamzaabovemedialarabic'       => 271,
        'yehthreedotsbelowarabic'       => 644,
        'yen'       => 500,
        'yerahbenyomohebrew'       => 0,
        'yerudieresiscyrillic'       => 780,
        'yetivhebrew'       => 0,
        'ygrave'       => 500,
        'yhook'       => 500,
        'yhookabove'       => 500,
        'yiarmenian'       => 298,
        'yiwnarmenian'       => 391,
        'yoddagesh'       => 310,
        'yotgreek'       => 333,
        'ypogegrammeni'       => 333,
        'ypogegrammenigreekcmb'       => 0,
        'yr'       => 610,
        'yring'       => 500,
        'ysuperior'       => 298,
        'ytilde'       => 500,
        'yturned'       => 500,
        'yusbigcyrillic'       => 725,
        'yusbigiotifiedcyrillic'       => 998,
        'yuslittlecyrillic'       => 500,
        'yuslittleiotifiedcyrillic'       => 773,
        'z'       => 444,                                         # +1
        'zaarmenian'       => 575,
        'zacute'       => 444,                                    # +1
        'zahfinalarabic'       => 523,
        'zahinitialarabic'       => 523,
        'zahmedialarabic'       => 523,
        'zainfinalarabic'       => 432,
        'zaqefgadolhebrew'       => 0,
        'zaqefqatanhebrew'       => 0,
        'zarqahebrew'       => 0,
        'zayindagesh'       => 331,
        'zcaron'       => 444,                                    # +1
        'zcircumflex'       => 444,                               # (+1)
        'zcurl'       => 513,
        'zdotaccent'       => 444,                                # +1
        'zdotbelow'       => 444,                                 # (+1)
        'zedescendercyrillic'       => 401,
        'zedieresiscyrillic'       => 401,
        'zero'       => 500,
        'zeroinferior'       => 299,
        'zeropersian'       => 561,
        'zerosuperior'       => 299,
        'zerowidthspace'       => 0,
        'zeta'       => 413,
        'zhearmenian'       => 582,
        'zhebrevecyrillic'       => 725,
        'zhedescendercyrillic'       => 725,
        'zhedieresiscyrillic'       => 725,
        'zinorhebrew'       => 0,
        'zlinebelow'       => 444,                                # (+1)
        'zretroflexhook'       => 444,                            # (+1)
        'zstroke'       => 444,                                   # (+1)
    },
    'wxold' => { # HORIZ. WIDTH TABLE
        'space' => '250',                        # C+0x20 # U+0x0020
        'exclam' => '333',                       # C+0x21 # U+0x0021
        'quotedbl' => '555',                     # C+0x22 # U+0x0022
        'numbersign' => '500',                   # C+0x23 # U+0x0023
        'dollar' => '500',                       # C+0x24 # U+0x0024
        'percent' => '1000',                     # C+0x25 # U+0x0025
        'ampersand' => '833',                    # C+0x26 # U+0x0026
        'quotesingle' => '278',                  # C+0x27 # U+0x0027
        'parenleft' => '333',                    # C+0x28 # U+0x0028
        'parenright' => '333',                   # C+0x29 # U+0x0029
        'asterisk' => '500',                     # C+0x2A # U+0x002A
        'plus' => '570',                         # C+0x2B # U+0x002B
        'comma' => '250',                        # C+0x2C # U+0x002C
        'hyphen' => '333',                       # C+0x2D # U+0x002D
        'period' => '250',                       # C+0x2E # U+0x002E
        'slash' => '278',                        # C+0x2F # U+0x002F
        'zero' => '500',                         # C+0x30 # U+0x0030
        'one' => '500',                          # C+0x31 # U+0x0031
        'two' => '500',                          # C+0x32 # U+0x0032
        'three' => '500',                        # C+0x33 # U+0x0033
        'four' => '500',                         # C+0x34 # U+0x0034
        'five' => '500',                         # C+0x35 # U+0x0035
        'six' => '500',                          # C+0x36 # U+0x0036
        'seven' => '500',                        # C+0x37 # U+0x0037
        'eight' => '500',                        # C+0x38 # U+0x0038
        'nine' => '500',                         # C+0x39 # U+0x0039
        'colon' => '333',                        # C+0x3A # U+0x003A
        'semicolon' => '333',                    # C+0x3B # U+0x003B
        'less' => '570',                         # C+0x3C # U+0x003C
        'equal' => '570',                        # C+0x3D # U+0x003D
        'greater' => '570',                      # C+0x3E # U+0x003E
        'question' => '500',                     # C+0x3F # U+0x003F
        'at' => '930',                           # C+0x40 # U+0x0040
        'A' => '722',                            # C+0x41 # U+0x0041
        'B' => '667',                            # C+0x42 # U+0x0042
        'C' => '722',                            # C+0x43 # U+0x0043
        'D' => '722',                            # C+0x44 # U+0x0044
        'E' => '667',                            # C+0x45 # U+0x0045
        'F' => '611',                            # C+0x46 # U+0x0046
        'G' => '778',                            # C+0x47 # U+0x0047
        'H' => '778',                            # C+0x48 # U+0x0048
        'I' => '389',                            # C+0x49 # U+0x0049
        'J' => '500',                            # C+0x4A # U+0x004A
        'K' => '778',                            # C+0x4B # U+0x004B
        'L' => '667',                            # C+0x4C # U+0x004C
        'M' => '944',                            # C+0x4D # U+0x004D
        'N' => '722',                            # C+0x4E # U+0x004E
        'O' => '778',                            # C+0x4F # U+0x004F
        'P' => '611',                            # C+0x50 # U+0x0050
        'Q' => '778',                            # C+0x51 # U+0x0051
        'R' => '722',                            # C+0x52 # U+0x0052
        'S' => '556',                            # C+0x53 # U+0x0053
        'T' => '667',                            # C+0x54 # U+0x0054
        'U' => '722',                            # C+0x55 # U+0x0055
        'V' => '722',                            # C+0x56 # U+0x0056
        'W' => '1000',                           # C+0x57 # U+0x0057
        'X' => '722',                            # C+0x58 # U+0x0058
        'Y' => '722',                            # C+0x59 # U+0x0059
        'Z' => '667',                            # C+0x5A # U+0x005A
        'bracketleft' => '333',                  # C+0x5B # U+0x005B
        'backslash' => '278',                    # C+0x5C # U+0x005C
        'bracketright' => '333',                 # C+0x5D # U+0x005D
        'asciicircum' => '581',                  # C+0x5E # U+0x005E
        'underscore' => '500',                   # C+0x5F # U+0x005F
        'grave' => '333',                        # C+0x60 # U+0x0060
        'a' => '500',                            # C+0x61 # U+0x0061
        'b' => '556',                            # C+0x62 # U+0x0062
        'c' => '444',                            # C+0x63 # U+0x0063
        'd' => '556',                            # C+0x64 # U+0x0064
        'e' => '444',                            # C+0x65 # U+0x0065
        'f' => '333',                            # C+0x66 # U+0x0066
        'g' => '500',                            # C+0x67 # U+0x0067
        'h' => '556',                            # C+0x68 # U+0x0068
        'i' => '278',                            # C+0x69 # U+0x0069
        'j' => '333',                            # C+0x6A # U+0x006A
        'k' => '556',                            # C+0x6B # U+0x006B
        'l' => '278',                            # C+0x6C # U+0x006C
        'm' => '833',                            # C+0x6D # U+0x006D
        'n' => '556',                            # C+0x6E # U+0x006E
        'o' => '500',                            # C+0x6F # U+0x006F
        'p' => '556',                            # C+0x70 # U+0x0070
        'q' => '556',                            # C+0x71 # U+0x0071
        'r' => '444',                            # C+0x72 # U+0x0072
        's' => '389',                            # C+0x73 # U+0x0073
        't' => '333',                            # C+0x74 # U+0x0074
        'u' => '556',                            # C+0x75 # U+0x0075
        'v' => '500',                            # C+0x76 # U+0x0076
        'w' => '722',                            # C+0x77 # U+0x0077
        'x' => '500',                            # C+0x78 # U+0x0078
        'y' => '500',                            # C+0x79 # U+0x0079
        'z' => '444',                            # C+0x7A # U+0x007A
        'braceleft' => '394',                    # C+0x7B # U+0x007B
        'bar' => '220',                          # C+0x7C # U+0x007C
        'braceright' => '394',                   # C+0x7D # U+0x007D
        'asciitilde' => '520',                   # C+0x7E # U+0x007E
        'bullet' => '350',                       # C+0x7F # U+0x2022
        'Euro' => '500',                         # C+0x80 # U+0x20AC
        'quotesinglbase' => '333',               # C+0x82 # U+0x201A
        'florin' => '500',                       # C+0x83 # U+0x0192
        'quotedblbase' => '500',                 # C+0x84 # U+0x201E
        'ellipsis' => '1000',                    # C+0x85 # U+0x2026
        'dagger' => '500',                       # C+0x86 # U+0x2020
        'daggerdbl' => '500',                    # C+0x87 # U+0x2021
        'circumflex' => '333',                   # C+0x88 # U+0x02C6
        'perthousand' => '1000',                 # C+0x89 # U+0x2030
        'Scaron' => '556',                       # C+0x8A # U+0x0160
        'guilsinglleft' => '333',                # C+0x8B # U+0x2039
        'OE' => '1000',                          # C+0x8C # U+0x0152
        'Zcaron' => '667',                       # C+0x8E # U+0x017D
        'quoteleft' => '333',                    # C+0x91 # U+0x2018
        'quoteright' => '333',                   # C+0x92 # U+0x2019
        'quotedblleft' => '500',                 # C+0x93 # U+0x201C
        'quotedblright' => '500',                # C+0x94 # U+0x201D
        'endash' => '500',                       # C+0x96 # U+0x2013
        'emdash' => '1000',                      # C+0x97 # U+0x2014
        'tilde' => '333',                        # C+0x98 # U+0x02DC
        'trademark' => '1000',                   # C+0x99 # U+0x2122
        'scaron' => '389',                       # C+0x9A # U+0x0161
        'guilsinglright' => '333',               # C+0x9B # U+0x203A
        'oe' => '722',                           # C+0x9C # U+0x0153
        'zcaron' => '444',                       # C+0x9E # U+0x017E
        'Ydieresis' => '722',                    # C+0x9F # U+0x0178
        'exclamdown' => '333',                   # C+0xA1 # U+0x00A1
        'cent' => '500',                         # C+0xA2 # U+0x00A2
        'sterling' => '500',                     # C+0xA3 # U+0x00A3
        'currency' => '500',                     # C+0xA4 # U+0x00A4
        'yen' => '500',                          # C+0xA5 # U+0x00A5
        'brokenbar' => '220',                    # C+0xA6 # U+0x00A6
        'section' => '500',                      # C+0xA7 # U+0x00A7
        'dieresis' => '333',                     # C+0xA8 # U+0x00A8
        'copyright' => '747',                    # C+0xA9 # U+0x00A9
        'ordfeminine' => '300',                  # C+0xAA # U+0x00AA
        'guillemotleft' => '500',                # C+0xAB # U+0x00AB
        'logicalnot' => '570',                   # C+0xAC # U+0x00AC
        'registered' => '747',                   # C+0xAE # U+0x00AE
        'macron' => '520',                       # C+0xAF # U+0x00AF
        'degree' => '400',                       # C+0xB0 # U+0x00B0
        'plusminus' => '570',                    # C+0xB1 # U+0x00B1
        'twosuperior' => '300',                  # C+0xB2 # U+0x00B2
        'threesuperior' => '300',                # C+0xB3 # U+0x00B3
        'acute' => '333',                        # C+0xB4 # U+0x00B4
        'mu' => '556',                           # C+0xB5 # U+0x00B5
        'paragraph' => '540',                    # C+0xB6 # U+0x00B6
        'periodcentered' => '250',               # C+0xB7 # U+0x00B7
        'cedilla' => '333',                      # C+0xB8 # U+0x00B8
        'onesuperior' => '300',                  # C+0xB9 # U+0x00B9
        'ordmasculine' => '330',                 # C+0xBA # U+0x00BA
        'guillemotright' => '500',               # C+0xBB # U+0x00BB
        'onequarter' => '750',                   # C+0xBC # U+0x00BC
        'onehalf' => '750',                      # C+0xBD # U+0x00BD
        'threequarters' => '750',                # C+0xBE # U+0x00BE
        'questiondown' => '500',                 # C+0xBF # U+0x00BF
        'Agrave' => '722',                       # C+0xC0 # U+0x00C0
        'Aacute' => '722',                       # C+0xC1 # U+0x00C1
        'Acircumflex' => '722',                  # C+0xC2 # U+0x00C2
        'Atilde' => '722',                       # C+0xC3 # U+0x00C3
        'Adieresis' => '722',                    # C+0xC4 # U+0x00C4
        'Aring' => '722',                        # C+0xC5 # U+0x00C5
        'AE' => '1000',                          # C+0xC6 # U+0x00C6
        'Ccedilla' => '722',                     # C+0xC7 # U+0x00C7
        'Egrave' => '667',                       # C+0xC8 # U+0x00C8
        'Eacute' => '667',                       # C+0xC9 # U+0x00C9
        'Ecircumflex' => '667',                  # C+0xCA # U+0x00CA
        'Edieresis' => '667',                    # C+0xCB # U+0x00CB
        'Igrave' => '389',                       # C+0xCC # U+0x00CC
        'Iacute' => '389',                       # C+0xCD # U+0x00CD
        'Icircumflex' => '389',                  # C+0xCE # U+0x00CE
        'Idieresis' => '389',                    # C+0xCF # U+0x00CF
        'Eth' => '722',                          # C+0xD0 # U+0x00D0
        'Ntilde' => '722',                       # C+0xD1 # U+0x00D1
        'Ograve' => '778',                       # C+0xD2 # U+0x00D2
        'Oacute' => '778',                       # C+0xD3 # U+0x00D3
        'Ocircumflex' => '778',                  # C+0xD4 # U+0x00D4
        'Otilde' => '778',                       # C+0xD5 # U+0x00D5
        'Odieresis' => '778',                    # C+0xD6 # U+0x00D6
        'multiply' => '570',                     # C+0xD7 # U+0x00D7
        'Oslash' => '778',                       # C+0xD8 # U+0x00D8
        'Ugrave' => '722',                       # C+0xD9 # U+0x00D9
        'Uacute' => '722',                       # C+0xDA # U+0x00DA
        'Ucircumflex' => '722',                  # C+0xDB # U+0x00DB
        'Udieresis' => '722',                    # C+0xDC # U+0x00DC
        'Yacute' => '722',                       # C+0xDD # U+0x00DD
        'Thorn' => '611',                        # C+0xDE # U+0x00DE
        'germandbls' => '556',                   # C+0xDF # U+0x00DF
        'agrave' => '500',                       # C+0xE0 # U+0x00E0
        'aacute' => '500',                       # C+0xE1 # U+0x00E1
        'acircumflex' => '500',                  # C+0xE2 # U+0x00E2
        'atilde' => '500',                       # C+0xE3 # U+0x00E3
        'adieresis' => '500',                    # C+0xE4 # U+0x00E4
        'aring' => '500',                        # C+0xE5 # U+0x00E5
        'ae' => '722',                           # C+0xE6 # U+0x00E6
        'ccedilla' => '444',                     # C+0xE7 # U+0x00E7
        'egrave' => '444',                       # C+0xE8 # U+0x00E8
        'eacute' => '444',                       # C+0xE9 # U+0x00E9
        'ecircumflex' => '444',                  # C+0xEA # U+0x00EA
        'edieresis' => '444',                    # C+0xEB # U+0x00EB
        'igrave' => '278',                       # C+0xEC # U+0x00EC
        'iacute' => '278',                       # C+0xED # U+0x00ED
        'icircumflex' => '278',                  # C+0xEE # U+0x00EE
        'idieresis' => '278',                    # C+0xEF # U+0x00EF
        'eth' => '500',                          # C+0xF0 # U+0x00F0
        'ntilde' => '556',                       # C+0xF1 # U+0x00F1
        'ograve' => '500',                       # C+0xF2 # U+0x00F2
        'oacute' => '500',                       # C+0xF3 # U+0x00F3
        'ocircumflex' => '500',                  # C+0xF4 # U+0x00F4
        'otilde' => '500',                       # C+0xF5 # U+0x00F5
        'odieresis' => '500',                    # C+0xF6 # U+0x00F6
        'divide' => '570',                       # C+0xF7 # U+0x00F7
        'oslash' => '500',                       # C+0xF8 # U+0x00F8
        'ugrave' => '556',                       # C+0xF9 # U+0x00F9
        'uacute' => '556',                       # C+0xFA # U+0x00FA
        'ucircumflex' => '556',                  # C+0xFB # U+0x00FB
        'udieresis' => '556',                    # C+0xFC # U+0x00FC
        'yacute' => '500',                       # C+0xFD # U+0x00FD
        'thorn' => '556',                        # C+0xFE # U+0x00FE
        'ydieresis' => '500',                    # C+0xFF # U+0x00FF
        'dotlessi' => '278',                     # U+0x0131
        'Lslash' => '667',                       # U+0x0141
        'lslash' => '278',                       # U+0x0142
        'caron' => '333',                        # U+0x02C7
        'breve' => '333',                        # U+0x02D8
        'dotaccent' => '333',                    # U+0x02D9
        'ring' => '333',                         # U+0x02DA
        'ogonek' => '333',                       # U+0x02DB
        'hungarumlaut' => '333',                 # U+0x02DD
	    'dblgravecmb' => '333',                  # U+0x030F
        'fraction' => '167',                     # U+0x2044
        'minus' => '570',                        # U+0x2212
        'fi' => '556',                           # U+0xFB01
        'fl' => '556',                           # U+0xFB02
    }, # HORIZ. WIDTH TABLE
} };

1;
