package Class;
BEGIN
{
    use strict;
    use warnings;
    use parent qw( Module::Generic );
    our $VERSION = 'v0.1.0';
};

package Class::Array;
BEGIN
{
    use strict;
    use warnings;
    use parent qw( Module::Generic::Array );
    our $VERSION = 'v0.1.0';
};

package Class::Boolean;
BEGIN
{
    use strict;
    use warnings;
    use parent qw( Module::Generic::Boolean );
    our $VERSION = 'v0.1.0';
};

package Class::DateTime;
BEGIN
{
    use strict;
    use warnings;
    use parent qw( Module::Generic::DateTime );
    our $VERSION = 'v0.1.0';
};

package Class::Exception;
BEGIN
{
    use strict;
    use warnings;
    use parent qw( Module::Generic::Exception );
    our $VERSION = 'v0.1.0';
};

package Class::File;
BEGIN
{
    use strict;
    use warnings;
    use parent qw( Module::Generic::File );
    our $VERSION = 'v0.1.0';
};

package Class::Finfo;
BEGIN
{
    use strict;
    use warnings;
    use parent qw( Module::Generic::Finfo );
    our $VERSION = 'v0.1.0';
};

package Class::Hash;
BEGIN
{
    use strict;
    use warnings;
    use parent qw( Module::Generic::Hash );
    our $VERSION = 'v0.1.0';
};

package Class::Number;
BEGIN
{
    use strict;
    use warnings;
    use parent qw( Module::Generic::Number );
    our $VERSION = 'v0.1.0';
};

package Class::Scalar;
BEGIN
{
    use strict;
    use warnings;
    use parent qw( Module::Generic::Scalar );
    our $VERSION = 'v0.1.0';
};

1;

__END__

=encoding utf8

=head1 NAME

Class - A Generic Object Class to Inherit From

=head1 SYNOPSIS

    use parent qw( Class );
    
    sub init
    {
        my $self = shift( @_ );
        return( $self->SUPER::init( @_ ) );
    }

=head1 VERSION

    v0.1.0

=head1 DESCRIPTION

This package inherits all its features from L<Module::Generic> and provides a generic framework of methods to inherit from and speed up development.

=head1 SEE ALSO

L<Class::Array>, L<Class::Scalar>, L<Class::Number>, L<Class::Boolean>, L<Class::Hash>, L<Class::File>, L<Class::DateTime>, L<Class::Exception>, L<Class::Finfo>

=head1 AUTHOR

Jacques Deguest E<lt>F<jack@deguest.jp>E<gt>

=head1 COPYRIGHT & LICENSE

Copyright (c) 2021 DEGUEST Pte. Ltd.

You can use, copy, modify and redistribute this package and associated
files under the same terms as Perl itself.

=cut

