package WebService::Beeminder::Types;
use 5.010;
use strict;
use warnings;

# ABSTRACT: Types for WebService::Beeminder
our $VERSION = '0.003'; # VERSION: Generated by DZP::OurPkg:Version

use MooseX::Types -declare => [
    qw(
        BeeBool
        Goal
        User
    )
];

use MooseX::Types::Moose qw(Str Bool);

subtype BeeBool,
    as Str,
    where { /^(?:true|false)$/ }
;

coerce BeeBool,
    from Bool,
    via { $_ ? "true" : "false" }
;

coerce Bool,
    from BeeBool,
    via { $_ eq "true" }
;

# Goal and User types are just strings, but we can tweak them later
# if there are restrictions as to what's a valid user or goal name.

subtype Goal,
    as Str
;

subtype User,
    as Str
;

1;

__END__

=pod

=head1 NAME

WebService::Beeminder::Types - Types for WebService::Beeminder

=head1 VERSION

version 0.003

=head1 AUTHOR

Paul Fenwick <pjf@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2012 by Paul Fenwick.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
