package Data::Password::zxcvbn::AdjacencyGraph::Common;
use strict;
use warnings;
# VERSION
# ABSTRACT: adjacency graphs for common keyboards

=head1 DESCRIPTION

This is a data file used by L<<
C<Data::Password::zxcvbn::Match::Spatial> >>, and is generated by the
L<<
C<build-keyboard-adjacency-graphs>|https://bitbucket.org/broadbean/p5-data-password-zxcvbn/src/master/maint/build-keyboard-adjacency-graphs
>> program when building the distribution.


=cut

our %graphs = (
  keypad     => {
                  average_degree     => 5.06666666666667,
                  keys               => {
                                          "*" => [
                                                   '/', ( undef ) x 3, '-', '+', 9, 8
                                                 ],
                                          "+" => [
                                                   9, '*', '-', ( undef ) x 4, 6
                                                 ],
                                          "-" => [
                                                   '*', ( undef ) x 5, '+', 9
                                                 ],
                                          "." => [
                                                   0, 2, 3, ( undef ) x 5
                                                 ],
                                          "/" => [
                                                   ( undef ) x 4, '*', 9, 8, 7
                                                 ],
                                          0   => [
                                                   undef, 1, 2, 3, '.', ( undef ) x 3
                                                 ],
                                          1   => [
                                                   ( undef ) x 2, 4, 5, 2, 0, ( undef ) x 2
                                                 ],
                                          2   => [
                                                   1, 4, 5, 6, 3, '.', 0, undef
                                                 ],
                                          3   => [
                                                   2, 5, 6, ( undef ) x 3, '.', 0
                                                 ],
                                          4   => [
                                                   ( undef ) x 2, 7, 8, 5, 2, 1, undef
                                                 ],
                                          5   => [
                                                   4, 7, 8, 9, 6, 3, 2, 1
                                                 ],
                                          6   => [
                                                   5, 8, 9, '+', ( undef ) x 2, 3, 2
                                                 ],
                                          7   => [
                                                   ( undef ) x 3, '/', 8, 5, 4, undef
                                                 ],
                                          8   => [
                                                   7, undef, '/', '*', 9, 6, 5, 4
                                                 ],
                                          9   => [
                                                   8, '/', '*', '-', '+', undef, 6, 5
                                                 ]
                                        },
                  starting_positions => 15
                },
  mac_keypad => {
                  average_degree     => 5.25,
                  keys               => {
                                          "*" => [
                                                   '/', ( undef ) x 5, '-', 9
                                                 ],
                                          "+" => [
                                                   6, 9, '-', ( undef ) x 4, 3
                                                 ],
                                          "-" => [
                                                   9, '/', '*', ( undef ) x 3, '+', 6
                                                 ],
                                          "." => [
                                                   0, 2, 3, ( undef ) x 5
                                                 ],
                                          "/" => [
                                                   '=', ( undef ) x 3, '*', '-', 9, 8
                                                 ],
                                          0   => [
                                                   undef, 1, 2, 3, '.', ( undef ) x 3
                                                 ],
                                          1   => [
                                                   ( undef ) x 2, 4, 5, 2, 0, ( undef ) x 2
                                                 ],
                                          2   => [
                                                   1, 4, 5, 6, 3, '.', 0, undef
                                                 ],
                                          3   => [
                                                   2, 5, 6, '+', ( undef ) x 2, '.', 0
                                                 ],
                                          4   => [
                                                   ( undef ) x 2, 7, 8, 5, 2, 1, undef
                                                 ],
                                          5   => [
                                                   4, 7, 8, 9, 6, 3, 2, 1
                                                 ],
                                          6   => [
                                                   5, 8, 9, '-', '+', undef, 3, 2
                                                 ],
                                          7   => [
                                                   ( undef ) x 3, '=', 8, 5, 4, undef
                                                 ],
                                          8   => [
                                                   7, undef, '=', '/', 9, 6, 5, 4
                                                 ],
                                          9   => [
                                                   8, '=', '/', '*', '-', '+', 6, 5
                                                 ],
                                          "=" => [
                                                   ( undef ) x 4, '/', 9, 8, 7
                                                 ]
                                        },
                  starting_positions => 16
                }
)
;

1;
