/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.json.JSONObject;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.BucketConfiguration;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.memcached.MemcachedServer;

public class MemcachedBucket
extends Bucket {
    public MemcachedBucket(CouchbaseMock cluster, BucketConfiguration config) throws IOException {
        super(cluster, config);
    }

    @Override
    public String getJSON() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", this.name);
        map.put("authType", "sasl");
        map.put("bucketType", "memcached");
        map.put("flushCacheUri", "/pools/default/buckets/" + this.name + "/controller/doFlush");
        map.put("nodeLocator", "ketama");
        map.put("proxyPort", 0);
        map.put("replicaNumber", 0);
        map.put("saslPassword", this.getPassword());
        map.put("streamingUri", "/pools/default/bucketsStreaming/" + this.name);
        map.put("uri", "/pools/default/buckets/" + this.name);
        ArrayList<String> nodes = new ArrayList<String>();
        for (MemcachedServer server : this.activeServers()) {
            nodes.add(server.toString());
        }
        map.put("nodes", nodes);
        return JSONObject.fromObject(map).toString();
    }

    @Override
    public Bucket.BucketType getType() {
        return Bucket.BucketType.MEMCACHED;
    }
}

