#!perl -w
# This is #!PERL.PL. a test and demonstration file for #!PERL.EXE
# To try it out, run #!PERL.EXE, which will run this script with the
# -w flag from the #! line above.  To prove that works, uncomment the 
# line below this one:
# $w_detector = 1 ;
# To-Do: let the more feature run off SPACE.

print <<ENDHELP_INTRO ;
Introduction:

  #!PERL.EXE is a front-end for MS-DOS versions of Perl, intended to provide
  a substitute for the #!perl technique used for running Perl scripts under
  UNIX. I've seen several tricks based on MS-DOS batch files, but haven't
  been happy with them: if a program is run by an MS-DOS batch file,
  redirecting its i/o from the batch file's command line is impossible.

  To use #!PERL.EXE, develop your Perl script until you're happy with it. If
  it's called FOO.PL, copy #!PERL.EXE to the file FOO.EXE. When you run
  FOO.EXE, it looks arround and finds that its current name is FOO.EXE. It
  then searches for FOO.PL and PERL.EXE and runs Perl. The overall effect is
  this; the command line:

    foo fred jim harry sally

  will cause FOO.EXE to run the following command as a "child process":

    perl foo.pl fred jim harry sally

-- Press ENTER for more --
ENDHELP_INTRO

getc ;

print <<ENDHELP_HASH_BANG ;  

  #!PERL.EXE handles an initial #! line in a Perl script as much like UNIX
  csh as possible. For this example line:

    #!/usr/bin/perl -w          # arguments for perl, not the script

  #!PERL will attempt to run /USR/BIN/PERL - if it can't find that, it will
  search for PERL.EXE. If you put the real MS-DOS pathname of your Perl
  interpreter there, like this:

    #!c:\\bin\\perl.exe -w

  then #!PERL will try to run C:\\BIN\\PERL.EXE. '/', from the #! line, or
  from an environment variable, is converted to '\\' before it is passed to
  MS-DOS. The -w argument is processed as in csh. The parser used to extract
  these arguments is very simplistic; it assumes that the interpreter name
  starts after the #! and is terminated by whitespace or end-of-line, and
  that the argument starts at the first '-' after the interpreter name and is
  terminated by whitespace or end-of-line. Like csh, it only grabs one
  argument, so Perl's argument-concatenation feature is very useful.

-- Press ENTER for more --
ENDHELP_HASH_BANG

getc ;

print <<ENDHELP_SEARCH ;

Operation:

  #!PERL.EXE looks for the script in the directory that it was loaded from,
  in the directories nominated by the environment variables PERLSCRIPTS,
  PERLLIB and PERL, if they exist, and along the PATH, in that order. It
  looks for the Perl interpreter with the name from the #! line, if any, and
  then in the same places it it looked for the script.

  As #!PERL.EXE is an EXE file, MS-DOS treats it as a "real" program, in the
  same way as UNIX does with a script. It has its own stdin and stdout
  channels, and these are inherited by its child processes - in this case,
  PERL.EXE. This is working now: PERL.EXE is printing to the stdout that it
  inherited from #!PERL.EXE, and your keypress to get to this page was read
  from the inherited stdin.


-- Press ENTER for more --
ENDHELP_SEARCH

getc ;

print <<ENDHELP_DETAILS;

Environment variables:

  MS-DOS implementations of Perl tend to make heavy use of environment
  variables, as there isn't a "standard" way to set up an MS-DOS machine.
  #!PERL uses three:

  - PERLSCRIPTS: Holds a list of directories, in the same format as PATH,
    which are searched by #!PERL for the script to be run.

  - PERLLIB: Holds a list of directories which are searched for the script,
    and are added to the \@INC array by PERL.EXE and thus searched for
    library files.

  - PERL: Holds the pathname of the directory where the Perl executable is
    installed. Not used by PERL.EXE, but useful for MS-DOS setup.

Files:
    #!PERL.PL    Demonstration/help - you're reading it now
    #!PERL.EXE   Executable
    #!PERL.PAS   Source code - Turbo Pascal version 5.5 or later

-- Press ENTER for more --
ENDHELP_DETAILS

getc ;

print <<ENDHELP_LAST ;
Comments:
  This is version 2.0 of #!PERL, produced on 17/APR/1994. Copying and
  distribution are permitted under the same conditions as Perl itself. No
  liability of any sort is accepted if this program does any damage to
  anything.

Bugs:
* Time & memory overhead: about 2 seconds and 19Kb.
* Needs MS-DOS 3.0 or later - not a serious problem.

Author:
  John Dallman, 27 Terront Road, London N15 3AA, United Kingdom.
  Email: jgd@cix.compulink.co.uk
  Valuable assistance and bugfixes for version 2.0 (see #!perl.pas)
  Niclas Borlin, Computer Science departmentt, Uni. of Umea, SWEDEN,
  Email: niclas@cs.umu.se
  This script is running under Perl version:
$]
ENDHELP_LAST

