/**
 * @file detect_keys.h
 * @brief sub-interface to select keyboards
 */
#ifndef _DETECT_KEYS_H_
#define _DETECT_KEYS_H_

#include <stdbool.h>

#undef _
#define _(x) (x)

#define DCF_CAPB_BACKUP		(1UL << 0)

struct frontend;

struct detect_keys_frontend {
    int (*press_key)(struct frontend *, char *syms, int *codes, int *result);
    int (*is_key_there)(struct frontend *, char *sym, bool plain, bool *result);
};

int detect_keys(struct frontend *obj, struct detect_keys_frontend *methods, char *filename, char **result);

#endif /* DETECT_KEYS_H */
