# Copyright (c) 2014 Rackspace Hosting
# All Rights Reserved.
#
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.
from designate.objects import base


class PoolNsRecord(base.DictObjectMixin, base.PersistentObjectMixin,
                   base.DesignateObject):
    FIELDS = {
        'pool_id': {
            'schema': {
                'type': 'string',
                'description': 'Pool identifier',
                'format': 'uuid',
            },
        },
        'priority': {
            'schema': {
                'type': 'integer',
                'description': 'NS Record Priority Order',
                'minimum': 1,
                'maximum': 10000
            },
            'required': True
        },
        'hostname': {
            'schema': {
                'type': 'string',
                'description': 'NS Record Hostname',
                'format': 'domainname',
                'maxLength': 255,
            },
            'immutable': True,
            'required': True
        }
    }

    STRING_KEYS = [
        'id', 'hostname', 'priority', 'pool_id'
    ]


class PoolNsRecordList(base.ListObjectMixin, base.DesignateObject):
    LIST_ITEM_TYPE = PoolNsRecord
