/* AccessibleValue.java -- aids in accessibly controlling values
   Copyright (C) 2002, 2005  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
02110-1301 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


package javax.accessibility;

/**
 * If an object implements this interface then it must be able to control
 * a numerical value. For example, a scroll bar has a position represented
 * by a number. Accessibility software can use the implementations of this
 * interface to change the associated value.
 *
 * <p>The <code>AccessibleContext.getAccessibleValue()</code> method should
 * return <code>null</code> if an object does not implement this interface.
 *
 * @author Eric Blake (ebb9@email.byu.edu)
 * @see Accessible
 * @see AccessibleContext
 * @see AccessibleContext#getAccessibleValue()
 * @since 1.2
 * @status updated to 1.4
 */
public interface AccessibleValue
{
  /**
   * Gets the current value of this object, or null if it has not been set.
   *
   * @return the current value, or null
   * @see #setCurrentAccessibleValue(Number)
   */
  Number getCurrentAccessibleValue();

  /**
   * Sets the current value of this object. Returns true if the number
   * successfully changed.
   *
   * @param number the new value
   * @return true on success
   */
  // XXX What happens if number is null?
  boolean setCurrentAccessibleValue(Number number);

  /**
   * Gets the minimum value in the range of this object, or null if there is
   * no minimum.
   *
   * @return the minimum
   * @see #getMaximumAccessibleValue()
   */
  Number getMinimumAccessibleValue();

  /**
   * Gets the maximum value in the range of this object, or null if there is
   * no maximum.
   *
   * @return the maximum
   * @see #getMinimumAccessibleValue()
   */
  Number getMaximumAccessibleValue();
} // interface AccessibleValue
