/* test-utils.c generated by valac 0.16.0, the Vala compiler
 * generated from test-utils.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken@vandine.org>
 */

#include <glib.h>
#include <glib-object.h>
#include <gwibber.h>
#include <time.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gobject/gvaluecollector.h>


#define GWIBBER_TEST_TYPE_UTILS_SUITE (gwibber_test_utils_suite_get_type ())
#define GWIBBER_TEST_UTILS_SUITE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GWIBBER_TEST_TYPE_UTILS_SUITE, GwibberTestUtilsSuite))
#define GWIBBER_TEST_UTILS_SUITE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GWIBBER_TEST_TYPE_UTILS_SUITE, GwibberTestUtilsSuiteClass))
#define GWIBBER_TEST_IS_UTILS_SUITE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GWIBBER_TEST_TYPE_UTILS_SUITE))
#define GWIBBER_TEST_IS_UTILS_SUITE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GWIBBER_TEST_TYPE_UTILS_SUITE))
#define GWIBBER_TEST_UTILS_SUITE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GWIBBER_TEST_TYPE_UTILS_SUITE, GwibberTestUtilsSuiteClass))

typedef struct _GwibberTestUtilsSuite GwibberTestUtilsSuite;
typedef struct _GwibberTestUtilsSuiteClass GwibberTestUtilsSuiteClass;
typedef struct _GwibberTestUtilsSuitePrivate GwibberTestUtilsSuitePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GwibberTestParamSpecUtilsSuite GwibberTestParamSpecUtilsSuite;

struct _GwibberTestUtilsSuite {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GwibberTestUtilsSuitePrivate * priv;
};

struct _GwibberTestUtilsSuiteClass {
	GTypeClass parent_class;
	void (*finalize) (GwibberTestUtilsSuite *self);
};

struct _GwibberTestParamSpecUtilsSuite {
	GParamSpec parent_instance;
};


static gpointer gwibber_test_utils_suite_parent_class = NULL;

gpointer gwibber_test_utils_suite_ref (gpointer instance);
void gwibber_test_utils_suite_unref (gpointer instance);
GParamSpec* gwibber_test_param_spec_utils_suite (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gwibber_test_value_set_utils_suite (GValue* value, gpointer v_object);
void gwibber_test_value_take_utils_suite (GValue* value, gpointer v_object);
gpointer gwibber_test_value_get_utils_suite (const GValue* value);
GType gwibber_test_utils_suite_get_type (void) G_GNUC_CONST;
enum  {
	GWIBBER_TEST_UTILS_SUITE_DUMMY_PROPERTY
};
GwibberTestUtilsSuite* gwibber_test_utils_suite_new (void);
GwibberTestUtilsSuite* gwibber_test_utils_suite_construct (GType object_type);
void gwibber_test_utils_suite_test_time_string_seconds (void);
static void _gwibber_test_utils_suite_test_time_string_seconds_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_time_string_minute (void);
static void _gwibber_test_utils_suite_test_time_string_minute_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_time_string_minutes (void);
static void _gwibber_test_utils_suite_test_time_string_minutes_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_time_string_hour (void);
static void _gwibber_test_utils_suite_test_time_string_hour_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_time_string_hours (void);
static void _gwibber_test_utils_suite_test_time_string_hours_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_time_string_day (void);
static void _gwibber_test_utils_suite_test_time_string_day_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_time_string_days (void);
static void _gwibber_test_utils_suite_test_time_string_days_gtest_data_func (gpointer self);
void gwibber_test_utils_suite_test_avatar_path (void);
static void _gwibber_test_utils_suite_test_avatar_path_gtest_data_func (gpointer self);
static void gwibber_test_utils_suite_finalize (GwibberTestUtilsSuite* obj);


static void _gwibber_test_utils_suite_test_time_string_seconds_gtest_data_func (gpointer self) {
	gwibber_test_utils_suite_test_time_string_seconds ();
}


static void _gwibber_test_utils_suite_test_time_string_minute_gtest_data_func (gpointer self) {
	gwibber_test_utils_suite_test_time_string_minute ();
}


static void _gwibber_test_utils_suite_test_time_string_minutes_gtest_data_func (gpointer self) {
	gwibber_test_utils_suite_test_time_string_minutes ();
}


static void _gwibber_test_utils_suite_test_time_string_hour_gtest_data_func (gpointer self) {
	gwibber_test_utils_suite_test_time_string_hour ();
}


static void _gwibber_test_utils_suite_test_time_string_hours_gtest_data_func (gpointer self) {
	gwibber_test_utils_suite_test_time_string_hours ();
}


static void _gwibber_test_utils_suite_test_time_string_day_gtest_data_func (gpointer self) {
	gwibber_test_utils_suite_test_time_string_day ();
}


static void _gwibber_test_utils_suite_test_time_string_days_gtest_data_func (gpointer self) {
	gwibber_test_utils_suite_test_time_string_days ();
}


static void _gwibber_test_utils_suite_test_avatar_path_gtest_data_func (gpointer self) {
	gwibber_test_utils_suite_test_avatar_path ();
}


GwibberTestUtilsSuite* gwibber_test_utils_suite_construct (GType object_type) {
	GwibberTestUtilsSuite* self = NULL;
	self = (GwibberTestUtilsSuite*) g_type_create_instance (object_type);
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_seconds", NULL, _gwibber_test_utils_suite_test_time_string_seconds_gtest_data_func);
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_minute", NULL, _gwibber_test_utils_suite_test_time_string_minute_gtest_data_func);
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_minutes", NULL, _gwibber_test_utils_suite_test_time_string_minutes_gtest_data_func);
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_hour", NULL, _gwibber_test_utils_suite_test_time_string_hour_gtest_data_func);
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_hours", NULL, _gwibber_test_utils_suite_test_time_string_hours_gtest_data_func);
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_day", NULL, _gwibber_test_utils_suite_test_time_string_day_gtest_data_func);
	g_test_add_data_func ("/Unit/Gwibber/Utils/time_string_days", NULL, _gwibber_test_utils_suite_test_time_string_days_gtest_data_func);
	g_test_add_data_func ("/Unit/Gwibber/Utils/avatar_path", NULL, _gwibber_test_utils_suite_test_avatar_path_gtest_data_func);
	return self;
}


GwibberTestUtilsSuite* gwibber_test_utils_suite_new (void) {
	return gwibber_test_utils_suite_construct (GWIBBER_TEST_TYPE_UTILS_SUITE);
}


static void g_time_gm (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	gmtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


static void g_time_local (time_t time, struct tm* result) {
	struct tm _result_ = {0};
	struct tm _tmp0_ = {0};
	localtime_r (&time, &_tmp0_);
	_result_ = _tmp0_;
	*result = _result_;
	return;
}


void gwibber_test_utils_suite_test_time_string_seconds (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
	_tmp0_ = gwibber_utils_new ();
	utils = _tmp0_;
	_tmp1_ = time (NULL);
	_t = _tmp1_;
	g_time_gm (_t, &_tmp2_);
	n = _tmp2_;
	g_time_local (_t, &_tmp3_);
	lt = _tmp3_;
	_tmp4_ = lt;
	_tmp5_ = _tmp4_.tm_isdst;
	n.tm_isdst = _tmp5_;
	_tmp6_ = mktime (&n);
	t = ((gint) _tmp6_) - 59;
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
	ts = _tmp7_;
	g_assert (g_strcmp0 (ts, "a few seconds ago") == 0);
	_g_free0 (ts);
	_g_object_unref0 (utils);
}


void gwibber_test_utils_suite_test_time_string_minute (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
	_tmp0_ = gwibber_utils_new ();
	utils = _tmp0_;
	_tmp1_ = time (NULL);
	_t = _tmp1_;
	g_time_gm (_t, &_tmp2_);
	n = _tmp2_;
	g_time_local (_t, &_tmp3_);
	lt = _tmp3_;
	_tmp4_ = lt;
	_tmp5_ = _tmp4_.tm_isdst;
	n.tm_isdst = _tmp5_;
	_tmp6_ = mktime (&n);
	t = ((gint) _tmp6_) - 60;
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
	ts = _tmp7_;
	g_assert (g_strcmp0 (ts, "1 minute ago") == 0);
	_g_free0 (ts);
	_g_object_unref0 (utils);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


void gwibber_test_utils_suite_test_time_string_minutes (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
	gboolean _tmp8_ = FALSE;
	_tmp0_ = gwibber_utils_new ();
	utils = _tmp0_;
	_tmp1_ = time (NULL);
	_t = _tmp1_;
	g_time_gm (_t, &_tmp2_);
	n = _tmp2_;
	g_time_local (_t, &_tmp3_);
	lt = _tmp3_;
	_tmp4_ = lt;
	_tmp5_ = _tmp4_.tm_isdst;
	n.tm_isdst = _tmp5_;
	_tmp6_ = mktime (&n);
	t = ((gint) _tmp6_) - 3559;
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
	ts = _tmp7_;
	_tmp8_ = string_contains (ts, "minutes ago");
	g_assert (_tmp8_);
	_g_free0 (ts);
	_g_object_unref0 (utils);
}


void gwibber_test_utils_suite_test_time_string_hour (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
	_tmp0_ = gwibber_utils_new ();
	utils = _tmp0_;
	_tmp1_ = time (NULL);
	_t = _tmp1_;
	g_time_gm (_t, &_tmp2_);
	n = _tmp2_;
	g_time_local (_t, &_tmp3_);
	lt = _tmp3_;
	_tmp4_ = lt;
	_tmp5_ = _tmp4_.tm_isdst;
	n.tm_isdst = _tmp5_;
	_tmp6_ = mktime (&n);
	t = ((gint) _tmp6_) - 3601;
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
	ts = _tmp7_;
	g_assert (g_strcmp0 (ts, "1 hour ago") == 0);
	_g_free0 (ts);
	_g_object_unref0 (utils);
}


void gwibber_test_utils_suite_test_time_string_hours (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
	gboolean _tmp8_ = FALSE;
	_tmp0_ = gwibber_utils_new ();
	utils = _tmp0_;
	_tmp1_ = time (NULL);
	_t = _tmp1_;
	g_time_gm (_t, &_tmp2_);
	n = _tmp2_;
	g_time_local (_t, &_tmp3_);
	lt = _tmp3_;
	_tmp4_ = lt;
	_tmp5_ = _tmp4_.tm_isdst;
	n.tm_isdst = _tmp5_;
	_tmp6_ = mktime (&n);
	t = ((gint) _tmp6_) - 7201;
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
	ts = _tmp7_;
	_tmp8_ = string_contains (ts, "hours ago");
	g_assert (_tmp8_);
	_g_free0 (ts);
	_g_object_unref0 (utils);
}


void gwibber_test_utils_suite_test_time_string_day (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
	_tmp0_ = gwibber_utils_new ();
	utils = _tmp0_;
	_tmp1_ = time (NULL);
	_t = _tmp1_;
	g_time_gm (_t, &_tmp2_);
	n = _tmp2_;
	g_time_local (_t, &_tmp3_);
	lt = _tmp3_;
	_tmp4_ = lt;
	_tmp5_ = _tmp4_.tm_isdst;
	n.tm_isdst = _tmp5_;
	_tmp6_ = mktime (&n);
	t = ((gint) _tmp6_) - 86400;
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
	ts = _tmp7_;
	g_assert (g_strcmp0 (ts, "1 day ago") == 0);
	_g_free0 (ts);
	_g_object_unref0 (utils);
}


void gwibber_test_utils_suite_test_time_string_days (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	time_t _tmp1_;
	time_t _t;
	struct tm _tmp2_ = {0};
	struct tm n;
	struct tm _tmp3_ = {0};
	struct tm lt;
	struct tm _tmp4_;
	gint _tmp5_;
	time_t _tmp6_ = 0;
	gint t;
	gchar* _tmp7_ = NULL;
	gchar* ts;
	gboolean _tmp8_ = FALSE;
	_tmp0_ = gwibber_utils_new ();
	utils = _tmp0_;
	_tmp1_ = time (NULL);
	_t = _tmp1_;
	g_time_gm (_t, &_tmp2_);
	n = _tmp2_;
	g_time_local (_t, &_tmp3_);
	lt = _tmp3_;
	_tmp4_ = lt;
	_tmp5_ = _tmp4_.tm_isdst;
	n.tm_isdst = _tmp5_;
	_tmp6_ = mktime (&n);
	t = ((gint) _tmp6_) - 172800;
	_tmp7_ = gwibber_utils_generate_time_string (utils, (guint) t);
	ts = _tmp7_;
	_tmp8_ = string_contains (ts, "days ago");
	g_assert (_tmp8_);
	_g_free0 (ts);
	_g_object_unref0 (utils);
}


void gwibber_test_utils_suite_test_avatar_path (void) {
	GwibberUtils* _tmp0_;
	GwibberUtils* utils;
	gchar* _tmp1_;
	gchar* url;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* avatar_path;
	const gchar* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* _tmp10_;
	gchar* _tmp11_;
	FILE* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_ = NULL;
	const gchar* _tmp21_;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	_tmp0_ = gwibber_utils_new ();
	utils = _tmp0_;
	_tmp1_ = g_strdup ("http://test.com/avatar");
	url = _tmp1_;
	_tmp2_ = url;
	_tmp3_ = gwibber_utils_avatar_path (utils, _tmp2_);
	avatar_path = _tmp3_;
	_tmp4_ = avatar_path;
	_tmp5_ = g_get_user_cache_dir ();
	_tmp6_ = url;
	_tmp7_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, _tmp6_, (gsize) (-1));
	_tmp8_ = _tmp7_;
	_tmp9_ = g_build_path (G_DIR_SEPARATOR_S, _tmp5_, "gwibber/avatars", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	g_assert (g_strcmp0 (_tmp4_, _tmp10_) == 0);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp11_ = g_strdup ("http://test.com/this_is_a_very_long_avatar_url_that_should_cause_test_" \
"failures_as_per_bug_845374_which_is_scheduled_to_be_fixed_in_a_later_r" \
"elease_but_hopefully_will_be_patched_before_then");
	_g_free0 (url);
	url = _tmp11_;
	_tmp12_ = stdout;
	_tmp13_ = url;
	_tmp14_ = url;
	_tmp15_ = strlen (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, _tmp13_, (gsize) _tmp16_);
	_tmp18_ = _tmp17_;
	fprintf (_tmp12_, "%s", _tmp18_);
	_g_free0 (_tmp18_);
	_tmp19_ = url;
	_tmp20_ = gwibber_utils_avatar_path (utils, _tmp19_);
	_g_free0 (avatar_path);
	avatar_path = _tmp20_;
	_tmp21_ = avatar_path;
	_tmp22_ = g_get_user_cache_dir ();
	_tmp23_ = url;
	_tmp24_ = g_compute_checksum_for_string (G_CHECKSUM_SHA1, _tmp23_, (gsize) (-1));
	_tmp25_ = _tmp24_;
	_tmp26_ = g_build_path (G_DIR_SEPARATOR_S, _tmp22_, "gwibber/avatars", _tmp25_, NULL);
	_tmp27_ = _tmp26_;
	g_assert (g_strcmp0 (_tmp21_, _tmp27_) == 0);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp25_);
	_g_free0 (avatar_path);
	_g_free0 (url);
	_g_object_unref0 (utils);
}


static void gwibber_test_value_utils_suite_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void gwibber_test_value_utils_suite_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		gwibber_test_utils_suite_unref (value->data[0].v_pointer);
	}
}


static void gwibber_test_value_utils_suite_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = gwibber_test_utils_suite_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer gwibber_test_value_utils_suite_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* gwibber_test_value_utils_suite_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		GwibberTestUtilsSuite* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = gwibber_test_utils_suite_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* gwibber_test_value_utils_suite_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	GwibberTestUtilsSuite** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = gwibber_test_utils_suite_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* gwibber_test_param_spec_utils_suite (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	GwibberTestParamSpecUtilsSuite* spec;
	g_return_val_if_fail (g_type_is_a (object_type, GWIBBER_TEST_TYPE_UTILS_SUITE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer gwibber_test_value_get_utils_suite (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GWIBBER_TEST_TYPE_UTILS_SUITE), NULL);
	return value->data[0].v_pointer;
}


void gwibber_test_value_set_utils_suite (GValue* value, gpointer v_object) {
	GwibberTestUtilsSuite* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GWIBBER_TEST_TYPE_UTILS_SUITE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GWIBBER_TEST_TYPE_UTILS_SUITE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		gwibber_test_utils_suite_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gwibber_test_utils_suite_unref (old);
	}
}


void gwibber_test_value_take_utils_suite (GValue* value, gpointer v_object) {
	GwibberTestUtilsSuite* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, GWIBBER_TEST_TYPE_UTILS_SUITE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, GWIBBER_TEST_TYPE_UTILS_SUITE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		gwibber_test_utils_suite_unref (old);
	}
}


static void gwibber_test_utils_suite_class_init (GwibberTestUtilsSuiteClass * klass) {
	gwibber_test_utils_suite_parent_class = g_type_class_peek_parent (klass);
	GWIBBER_TEST_UTILS_SUITE_CLASS (klass)->finalize = gwibber_test_utils_suite_finalize;
}


static void gwibber_test_utils_suite_instance_init (GwibberTestUtilsSuite * self) {
	self->ref_count = 1;
}


static void gwibber_test_utils_suite_finalize (GwibberTestUtilsSuite* obj) {
	GwibberTestUtilsSuite * self;
	self = GWIBBER_TEST_UTILS_SUITE (obj);
}


GType gwibber_test_utils_suite_get_type (void) {
	static volatile gsize gwibber_test_utils_suite_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_test_utils_suite_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { gwibber_test_value_utils_suite_init, gwibber_test_value_utils_suite_free_value, gwibber_test_value_utils_suite_copy_value, gwibber_test_value_utils_suite_peek_pointer, "p", gwibber_test_value_utils_suite_collect_value, "p", gwibber_test_value_utils_suite_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (GwibberTestUtilsSuiteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_test_utils_suite_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberTestUtilsSuite), 0, (GInstanceInitFunc) gwibber_test_utils_suite_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType gwibber_test_utils_suite_type_id;
		gwibber_test_utils_suite_type_id = g_type_register_fundamental (g_type_fundamental_next (), "GwibberTestUtilsSuite", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&gwibber_test_utils_suite_type_id__volatile, gwibber_test_utils_suite_type_id);
	}
	return gwibber_test_utils_suite_type_id__volatile;
}


gpointer gwibber_test_utils_suite_ref (gpointer instance) {
	GwibberTestUtilsSuite* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void gwibber_test_utils_suite_unref (gpointer instance) {
	GwibberTestUtilsSuite* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		GWIBBER_TEST_UTILS_SUITE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



