# 개발 정보

## 개요

한글과 한국어의 특성 때문에 ko.aff 및 ko.dic 파일은 직접 편집하지 않고
소스 코드에서 소프트웨어를 통해 생성해 냅니다. aff 또는 dic 파일을
직접 편집하지 마십시오. 인코딩부터 내부 인코딩을 사용하기 때문에 aff
또는 dic 파일을 직접 편집하면 의도한 대로 동작하지 않습니다.

## 빌드

맨 위 디렉터리에서 'make'를 실행하면 소스 코드에서 소프트웨어를 통해 두 파일을
빌드해 냅니다.

빌드에 필요한 소프트웨어:

  - GNU make
  - Python 3.5 이상

## 내부 인코딩

모아쓰기된 한글 음절은 hunspell과 같은 형태론 기반 맞춤법 검사에
적합하지 않습니다. 맞춤법 검사 시스템은 단어 사이의 편집 거리가 얼마나
되느냐를 이용해서 추천할 단어를 고르게 되는데, 한글 음절에 대한 코드를
기준으로 음절 사이의 편집 거리, 더 나아가서 여러 음절과 여러 음절
사이의 편집 거리를 계산하기는 힘듭니다.

그러므로 한글 음절 코드를 자모 단위로 분해한 내부 코드로 한번 변환한
다음, hunspell을 이용해 추천 단어를 찾고, 내부 코드로 된 추천 단어를
다시 일반적인 한글 음절로 변환하는 게 가장 자연스러운 접근 방법입니다.

이것 때문에 생성하는 ko.aff 또는 ko.dic 파일의 인코딩은 내부
인코딩으로 되어 있습니다. hunspell 버전 1.2.8부터 이 인코딩 변환을 할
수 있는 기능인 ICONV 및 OCONV가 생겼습니다. 지금까지 이 내부
인코딩으로 유니코드 NFD(Normalization Form Canonical Decomposition)
형식을 사용해 왔으나 적합하지 않은 부분이 있어 개선할 예정입니다.

 * 'NFD'
   * 현재 사용 중인 유니코드 NFD
   * 장점: 구현이 쉽다.
   * 단점: 불필요한 편집거리가 많이 발생한다.
 * '2+RST'
   * 앞으로 사용할 내부 코드
   * 장점: 불필요한 편집거리가 발생하지 않는다.
   * 단점: hunspell 코드의 수정 없이 데이터만으로는 구현할 수 없다. (hunspell 1.6.0 기준)

## 사전 데이터

사전 데이터는 "갈퀴" 온라인 시스템에서 만들어져서, 리뷰를 거친 단어
모음을 JSON 형식으로 이 소스 파일로 가져옵니다. Python 코드가 이
데이터를 읽어 사전 파일을 만듭니다.

갈퀴 데이터베이스에서는 과거에 입력한 사전이 모두 기록으로 남아
있지만, 이 소스 코드에는 갈퀴 현재 유효한 단어 항목만 들어 있습니다.

### 데이터 라이선스에 주의

맞춤법 검사의 성능은 단어 데이터의 완성도에 크게 좌우됩니다. 그래서
외부에 공개되어 있는 다른 단어 데이터를 잘 찾아서 입력하면 간단히
맞춤법 검사의 품질을 높일 수 있지 않을까 생각하기 쉽습니다. 하지만
외부 데이터는 라이선스 논란의 여지가 있으므로 신중히 검토해야 합니다.

사전 데이터에는 다음 데이터가 들어갑니다.

 * '갈퀴' 사이트에서 직접 수동으로 입력한 데이터
  * https://galkwiki.pyok.org/
 * 국립국어원 우리말샘 및 한국어기초사전 데이터
  * https://krdict.korean.go.kr/
  * https://opendict.korean.go.kr/

현재까지 조사해 봤지만 위의 데이터 외에 인터넷에서 다운로드할 수 있는
여러가지 자료 중에서는 자유로운 라이선스로 배포했을 때 저작권 문제나
라이선스 충돌을 일으키지 않는다고 확신할 수 있는 단어 데이터는 찾을 수
없었습니다.

단어 정보와 같은 종류의 보편적인 데이터는 독창적인 저작물이 아니라
일반적인 사실을 모은 데이터이기 때문에 저작권을 주장할 수도 없다는
해석도 있지만, 이러한 데이터를 독점적인 라이선스에 제공하는 기업이나
연구 기관도 있습니다. 조금의 논란이라도 발생할 가능성이 있다면 피할
것입니다.

만약 독점적인 라이선스가 있거나 출처가 명확하지 않은 외부의 데이터를
변환해 사용한다면 매번 이러한 논란에 시달릴 것이고 실질적으로 리눅스
배포판 등 다른 소프트웨어 패키지에 포함되지 못합니다.

개발 커뮤니티의 힘으로 공개된 사전 데이터를 만들어 가는 작업은 쉽지
않지만 충분히 가능한 일입니다. 이 프로젝트를 처음 시작할 때도
일상생활에 보이는 단어를 입력하거나, 웹 문서에서 누락된 단어를 하나씩
입력하는 방법으로 단기간에 꽤 쓸 만한 단어 모음을 만들 수 있었고,
지속적으로 관리하면 충분히 완성도 높은 데이터가 만들어질 것입니다.
핀란드어, 덴마크어, 노르웨이어 등, 언어 사용자가 한국어보다 훨씬 적은
다른 언어의 맞춤법 사전도 참여하는 사람들의 힘으로 품질 높은 데이터를
축적하고 있습니다.

### 단어 품사

품사 분류는 KAIST 품사 태그를 기반으로 합니다.

http://semanticweb.kaist.ac.kr/org/bora/data/kaisttagset.pdf

* "체언" (n)
  * "명사:보통:서술성" (ncp)
  * "명사:보통:비서술성" (ncn)
  * "명사:고유" (nq)
    * "명사:고유:인물"
    * "명사:고유:지역"
    * "명사:고유:기관"
    * "명사:고유:국가"
  * "명사:의존:비단위성" (nbu)
  * "명사:의존:단위성" (nbn)
  * "대명사" (np)
  * "수사" (nn)
* "용언" (p)
  * "동사" (pv)
  * "형용사" (pa)
* "부사" (ma)
  * "부사:상태"
  * "부사:성상"
  * "부사:지시"
  * "부사:정도"
  * "부사:부정"
  * "부사:양태"
  * "부사:접속"
    상태부사, 성상부사, 정도부사, 양태부사의 경우만 보조사를 붙일 수 있음.
* "관형사" (mm)
* "감탄사" (ii)

우리말 문법에서 품사 중에서 조사는 현재 따로 처리하므로 단어 데이터에
따로 쓰지 않습니다.

다음은 실제 품사가 아닌 분류입니다.

* "특수:금지어"

    특별히 틀린 단어로 취급할 단어.

    사전에 기재되어 있지 않으면 틀린 단어로 취급하기 때문에 일상적으로
    틀리는 단어를 여기에 기입할 필요는 없고, 사전에 있는 다른 단어의
    활용을 통해 파생될 수 있지만 예외적으로 틀린 단어이거나, 거의 쓰지
    않는 단어이고 잘못 썼을 가능성이 훨씬 높은 단어의 경우 이렇게 씁니다.
    (예를 들어, "화일"은 "화"+"이다"+"-ㄹ"이라고 생각할 수도 있지만,
    "파일"을 잘못 쓰는 경우가 대부분이므로 금지어로 취급합니다.)

* "특수:파생형"

    파생된 형태만 주로 쓰이는 제한적인 단어는 파생된 형태를 기록합니다.
    ("가라사대", "단칼에" 등)

* "특수:복수접미사" "특수:숫자" "특수:알파벳"

    내부적으로 접미어, 합성어를 위해 사용. 새로 추가할 일 없음.


### 단어 속성

* "비속어"

    (아직 구현되지 않음)

    비속어 명사, 이 속성이 들어 있는 단어는 틀린 단어로 취급하지는 않지만
    추천 단어에서 제외.

* "ㄷ불규칙" "ㅂ불규칙" "ㅅ불규칙" "ㅎ불규칙" "러불규칙" "르불규칙" "우불규칙"

    불규칙활용 용언

    여 불규칙 활용 (~하다 형태의 용언), 리을 불규칙 (리을 탈락), 으불규칙
    (르/러 불규칙 외에 ㅡ로 끝나는 용언) 활용은 따로 쓰지 않음. (별도로 쓰지
    않아도 알 수 있으므로.)

    거라불규칙 (~가다 형태의 용언) 및 너라불규칙 (~오다 형태의 용언)
    역시 따로 쓰지 않아도 됩니다. 현 교육 과정의 학교 문법 및 2008년 개정된
    표준국어대사전에 따라 "-거라" 및 "-너라" 어미는 "-어라"/"-아라"의
    불규칙 활용 형태가 아니라 별개의 어미로 취급.

    우 불규칙 활용은 "푸다" 외에는 없으므로 새로 추가할 일 없음.

* "보조용언:-어"

    다른 용언의 -어 형태 뒤에 붙여 쓸 수 있는 보조용언

* "보조용언:-을"

    다른 용언의 -을 형태 뒤에 붙여 쓸 수 있는 보조용언. 수가 한정되어
    있으므로 새로 추가할 일 없음. "만하다", "법하다", "듯싶다",
    "듯하다", "뻔하다", "성싶다"

* "보조용언:-은"

    다른 용언의 -은 형태 뒤에 붙여 쓸 수 있는 보조용언. 수가 한정되어
    있으므로 새로 추가할 일 없음. "양하다", "체하다", "듯싶다",
    "듯하다",

* "용언합성"

    용언+용언 형태의 합성 용언. 이러한 형태는 뒤에 보조 용언을 붙여 쓸 수
    없음.

* "준말용언"

    다른 용언에서 음절이 받침으로 줄여진 형태의 용언. 뒤에 모음으로
    시작하는 어미가 올 수 없습니다. "갖다"(가지다), "머물다"(머무르다),
    "서툴다"(서투르다), "딛다"(디디다) 따위.

* "수:<자리수>"

    내부적으로 접미어, 합성어를 위해 사용. 새로 추가할 일 없음.

## 기타

### 옛말, 방언, 북한어

현대 표준어만 지원합니다. 옛말/방언/북한어는 표준어와 철자가 약간씩 다른
경우가 많아 표준어와 같이 포함하면 제대로 맞춤법 검사를 하지 못합니다.
(이쪽까지 기능을 확장한다면 별개의 사전으로 만들어야 할 것입니다.)
