/* candidatearea.c generated by valac 0.32.0, the Vala compiler
 * generated from candidatearea.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011-2015 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2016 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ibus.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <gdk/gdk.h>


#define TYPE_CANDIDATE_AREA (candidate_area_get_type ())
#define CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANDIDATE_AREA, CandidateArea))
#define CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANDIDATE_AREA, CandidateAreaClass))
#define IS_CANDIDATE_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANDIDATE_AREA))
#define IS_CANDIDATE_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANDIDATE_AREA))
#define CANDIDATE_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANDIDATE_AREA, CandidateAreaClass))

typedef struct _CandidateArea CandidateArea;
typedef struct _CandidateAreaClass CandidateAreaClass;
typedef struct _CandidateAreaPrivate CandidateAreaPrivate;
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TYPE_VSEPARATOR (vseparator_get_type ())
#define VSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VSEPARATOR, VSeparator))
#define VSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VSEPARATOR, VSeparatorClass))
#define IS_VSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VSEPARATOR))
#define IS_VSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VSEPARATOR))
#define VSEPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VSEPARATOR, VSeparatorClass))

typedef struct _VSeparator VSeparator;
typedef struct _VSeparatorClass VSeparatorClass;

#define TYPE_HSEPARATOR (hseparator_get_type ())
#define HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HSEPARATOR, HSeparator))
#define HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HSEPARATOR, HSeparatorClass))
#define IS_HSEPARATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HSEPARATOR))
#define IS_HSEPARATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HSEPARATOR))
#define HSEPARATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HSEPARATOR, HSeparatorClass))

typedef struct _HSeparator HSeparator;
typedef struct _HSeparatorClass HSeparatorClass;
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _CandidateArea {
	GtkBox parent_instance;
	CandidateAreaPrivate * priv;
};

struct _CandidateAreaClass {
	GtkBoxClass parent_class;
};

struct _CandidateAreaPrivate {
	gboolean m_vertical;
	GtkLabel** m_labels;
	gint m_labels_length1;
	gint _m_labels_size_;
	GtkLabel** m_candidates;
	gint m_candidates_length1;
	gint _m_candidates_size_;
	GtkWidget** m_widgets;
	gint m_widgets_length1;
	gint _m_widgets_size_;
	IBusText** m_ibus_candidates;
	gint m_ibus_candidates_length1;
	gint _m_ibus_candidates_size_;
	guint m_focus_candidate;
	gboolean m_show_cursor;
	gboolean m_use_latest_css_format;
};

struct _Block1Data {
	int _ref_count_;
	CandidateArea* self;
	gint i;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	gint index;
};

struct _Block3Data {
	int _ref_count_;
	CandidateArea* self;
	gint index;
};


static gpointer candidate_area_parent_class = NULL;

GType candidate_area_get_type (void) G_GNUC_CONST;
#define CANDIDATE_AREA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CANDIDATE_AREA, CandidateAreaPrivate))
enum  {
	CANDIDATE_AREA_DUMMY_PROPERTY
};
CandidateArea* candidate_area_new (gboolean vertical);
CandidateArea* candidate_area_construct (GType object_type, gboolean vertical);
void candidate_area_set_vertical (CandidateArea* self, gboolean vertical, gboolean force);
gboolean candidate_area_get_vertical (CandidateArea* self);
static void candidate_area_recreate_ui (CandidateArea* self);
void candidate_area_set_candidates (CandidateArea* self, IBusText** candidates, int candidates_length1, guint focus_candidate, gboolean show_cursor);
void candidate_area_set_labels (CandidateArea* self, IBusText** labels, int labels_length1);
static IBusText** _vala_array_dup1 (IBusText** self, int length);
PangoAttrList* get_pango_attr_list_from_ibus_text (IBusText* text);
static void __lambda7_ (CandidateArea* self, GtkButton* b);
static void ___lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void __lambda8_ (CandidateArea* self, GtkButton* b);
static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self);
VSeparator* vseparator_new (void);
VSeparator* vseparator_construct (GType object_type);
GType vseparator_get_type (void) G_GNUC_CONST;
HSeparator* hseparator_new (void);
HSeparator* hseparator_construct (GType object_type);
GType hseparator_get_type (void) G_GNUC_CONST;
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void _vala_array_add1 (GtkLabel*** array, int* length, int* size, GtkLabel* value);
static void _vala_array_add2 (GtkLabel*** array, int* length, int* size, GtkLabel* value);
static gboolean ______lambda9_ (Block2Data* _data2_, GtkWidget* w, GdkEventButton* e);
static gboolean _______lambda9__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _vala_array_add3 (GtkWidget*** array, int* length, int* size, GtkWidget* value);
static gboolean ______lambda10_ (Block2Data* _data2_, GtkWidget* w, GdkEventButton* e);
static gboolean _______lambda10__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _vala_array_add4 (GtkWidget*** array, int* length, int* size, GtkWidget* value);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _vala_array_add5 (GtkLabel*** array, int* length, int* size, GtkLabel* value);
static void _vala_array_add6 (GtkLabel*** array, int* length, int* size, GtkLabel* value);
static gboolean ______lambda11_ (Block3Data* _data3_, GtkWidget* w, GdkEventButton* e);
static gboolean _______lambda11__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _vala_array_add7 (GtkWidget*** array, int* length, int* size, GtkWidget* value);
static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void candidate_area_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* CANDIDATE_AREA_LABELS[16] = {"1.", "2.", "3.", "4.", "5.", "6.", "7.", "8.", "9.", "0.", "a.", "b.", "c.", "d.", "e.", "f."};
static const gchar* CANDIDATE_AREA_PREV_PAGE_ICONS[2] = {"go-previous", "go-up"};
static const gchar* CANDIDATE_AREA_NEXT_PAGE_ICONS[2] = {"go-next", "go-down"};

CandidateArea* candidate_area_construct (GType object_type, gboolean vertical) {
	CandidateArea * self = NULL;
	gboolean _tmp0_ = FALSE;
	self = (CandidateArea*) g_object_new (object_type, NULL);
	_tmp0_ = vertical;
	candidate_area_set_vertical (self, _tmp0_, TRUE);
	return self;
}


CandidateArea* candidate_area_new (gboolean vertical) {
	return candidate_area_construct (TYPE_CANDIDATE_AREA, vertical);
}


gboolean candidate_area_get_vertical (CandidateArea* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->m_vertical;
	result = _tmp0_;
	return result;
}


void candidate_area_set_vertical (CandidateArea* self, gboolean vertical, gboolean force) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkOrientation _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	IBusText** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = force;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->m_vertical;
		_tmp3_ = vertical;
		_tmp0_ = _tmp2_ == _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = vertical;
	self->priv->m_vertical = _tmp4_;
	_tmp6_ = vertical;
	if (_tmp6_) {
		_tmp5_ = GTK_ORIENTATION_VERTICAL;
	} else {
		_tmp5_ = GTK_ORIENTATION_HORIZONTAL;
	}
	gtk_orientable_set_orientation ((GtkOrientable*) self, _tmp5_);
	candidate_area_recreate_ui (self);
	_tmp7_ = self->priv->m_ibus_candidates;
	_tmp7__length1 = self->priv->m_ibus_candidates_length1;
	if (_tmp7__length1 > 0) {
		IBusText** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		IBusText** _tmp9_ = NULL;
		gint _tmp9__length1 = 0;
		guint _tmp10_ = 0U;
		gboolean _tmp11_ = FALSE;
		_tmp8_ = self->priv->m_ibus_candidates;
		_tmp8__length1 = self->priv->m_ibus_candidates_length1;
		self->priv->m_ibus_candidates = NULL;
		self->priv->m_ibus_candidates_length1 = 0;
		_tmp9_ = _tmp8_;
		_tmp9__length1 = _tmp8__length1;
		_tmp10_ = self->priv->m_focus_candidate;
		_tmp11_ = self->priv->m_show_cursor;
		candidate_area_set_candidates (self, _tmp9_, _tmp8__length1, _tmp10_, _tmp11_);
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_object_unref), NULL);
		gtk_widget_show_all ((GtkWidget*) self);
	}
}


void candidate_area_set_labels (CandidateArea* self, IBusText** labels, int labels_length1) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	{
		gboolean _tmp0_ = FALSE;
		i = 0;
		_tmp0_ = TRUE;
		while (TRUE) {
			gint _tmp2_ = 0;
			IBusText** _tmp3_ = NULL;
			gint _tmp3__length1 = 0;
			gint _tmp4_ = 0;
			GtkLabel** _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			gint _tmp6_ = 0;
			GtkLabel* _tmp7_ = NULL;
			IBusText** _tmp8_ = NULL;
			gint _tmp8__length1 = 0;
			gint _tmp9_ = 0;
			IBusText* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			if (!_tmp0_) {
				gint _tmp1_ = 0;
				_tmp1_ = i;
				i = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			_tmp2_ = i;
			_tmp3_ = labels;
			_tmp3__length1 = labels_length1;
			_tmp4_ = MIN (16, _tmp3__length1);
			if (!(_tmp2_ < _tmp4_)) {
				break;
			}
			_tmp5_ = self->priv->m_labels;
			_tmp5__length1 = self->priv->m_labels_length1;
			_tmp6_ = i;
			_tmp7_ = _tmp5_[_tmp6_];
			_tmp8_ = labels;
			_tmp8__length1 = labels_length1;
			_tmp9_ = i;
			_tmp10_ = _tmp8_[_tmp9_];
			_tmp11_ = ibus_text_get_text (_tmp10_);
			gtk_label_set_text (_tmp7_, _tmp11_);
		}
	}
	{
		gboolean _tmp12_ = FALSE;
		_tmp12_ = TRUE;
		while (TRUE) {
			gint _tmp14_ = 0;
			GtkLabel** _tmp15_ = NULL;
			gint _tmp15__length1 = 0;
			gint _tmp16_ = 0;
			GtkLabel* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			const gchar* _tmp19_ = NULL;
			if (!_tmp12_) {
				gint _tmp13_ = 0;
				_tmp13_ = i;
				i = _tmp13_ + 1;
			}
			_tmp12_ = FALSE;
			_tmp14_ = i;
			if (!(_tmp14_ < 16)) {
				break;
			}
			_tmp15_ = self->priv->m_labels;
			_tmp15__length1 = self->priv->m_labels_length1;
			_tmp16_ = i;
			_tmp17_ = _tmp15_[_tmp16_];
			_tmp18_ = i;
			_tmp19_ = CANDIDATE_AREA_LABELS[_tmp18_];
			gtk_label_set_text (_tmp17_, _tmp19_);
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static IBusText** _vala_array_dup1 (IBusText** self, int length) {
	IBusText** result;
	int i;
	result = g_new0 (IBusText*, length + 1);
	for (i = 0; i < length; i++) {
		IBusText* _tmp0_ = NULL;
		_tmp0_ = _g_object_ref0 (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


void candidate_area_set_candidates (CandidateArea* self, IBusText** candidates, int candidates_length1, guint focus_candidate, gboolean show_cursor) {
	IBusText** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	IBusText** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
	IBusText** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = candidates;
	_tmp0__length1 = candidates_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	self->priv->m_ibus_candidates = (_vala_array_free (self->priv->m_ibus_candidates, self->priv->m_ibus_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_ibus_candidates = _tmp1_;
	self->priv->m_ibus_candidates_length1 = _tmp1__length1;
	self->priv->_m_ibus_candidates_size_ = self->priv->m_ibus_candidates_length1;
	_tmp2_ = focus_candidate;
	self->priv->m_focus_candidate = _tmp2_;
	_tmp3_ = show_cursor;
	self->priv->m_show_cursor = _tmp3_;
	_tmp4_ = candidates;
	_tmp4__length1 = candidates_length1;
	_vala_assert (_tmp4__length1 < 16, "candidates.length < 16");
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				GtkLabel* label = NULL;
				GtkLabel** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gint _tmp9_ = 0;
				GtkLabel* _tmp10_ = NULL;
				GtkLabel* _tmp11_ = NULL;
				gboolean visible = FALSE;
				gint _tmp12_ = 0;
				IBusText** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gboolean _tmp78_ = FALSE;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				if (!(_tmp7_ < 16)) {
					break;
				}
				_tmp8_ = self->priv->m_candidates;
				_tmp8__length1 = self->priv->m_candidates_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				_tmp11_ = _g_object_ref0 (_tmp10_);
				label = _tmp11_;
				visible = FALSE;
				_tmp12_ = i;
				_tmp13_ = candidates;
				_tmp13__length1 = candidates_length1;
				if (_tmp12_ < _tmp13__length1) {
					PangoAttrList* attrs = NULL;
					IBusText** _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					IBusText* _tmp16_ = NULL;
					PangoAttrList* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					gint _tmp19_ = 0;
					guint _tmp20_ = 0U;
					GtkLabel* _tmp67_ = NULL;
					IBusText** _tmp68_ = NULL;
					gint _tmp68__length1 = 0;
					gint _tmp69_ = 0;
					IBusText* _tmp70_ = NULL;
					const gchar* _tmp71_ = NULL;
					GtkLabel* _tmp72_ = NULL;
					PangoAttrList* _tmp73_ = NULL;
					_tmp14_ = candidates;
					_tmp14__length1 = candidates_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					_tmp17_ = get_pango_attr_list_from_ibus_text (_tmp16_);
					attrs = _tmp17_;
					_tmp19_ = i;
					_tmp20_ = focus_candidate;
					if (((guint) _tmp19_) == _tmp20_) {
						gboolean _tmp21_ = FALSE;
						_tmp21_ = show_cursor;
						_tmp18_ = _tmp21_;
					} else {
						_tmp18_ = FALSE;
					}
					if (_tmp18_) {
						GtkStyleContext* context = NULL;
						GtkLabel** _tmp22_ = NULL;
						gint _tmp22__length1 = 0;
						gint _tmp23_ = 0;
						GtkLabel* _tmp24_ = NULL;
						GtkStyleContext* _tmp25_ = NULL;
						GtkStyleContext* _tmp26_ = NULL;
						GdkRGBA* color = NULL;
						GtkStyleContext* _tmp27_ = NULL;
						PangoAttribute* pango_attr = NULL;
						GdkRGBA* _tmp28_ = NULL;
						gdouble _tmp29_ = 0.0;
						GdkRGBA* _tmp30_ = NULL;
						gdouble _tmp31_ = 0.0;
						GdkRGBA* _tmp32_ = NULL;
						gdouble _tmp33_ = 0.0;
						PangoAttribute* _tmp34_ = NULL;
						PangoAttribute* _tmp35_ = NULL;
						PangoAttribute* _tmp36_ = NULL;
						IBusText** _tmp37_ = NULL;
						gint _tmp37__length1 = 0;
						gint _tmp38_ = 0;
						IBusText* _tmp39_ = NULL;
						const gchar* _tmp40_ = NULL;
						gint _tmp41_ = 0;
						gint _tmp42_ = 0;
						PangoAttrList* _tmp43_ = NULL;
						PangoAttribute* _tmp44_ = NULL;
						const gchar* _tmp45_ = NULL;
						gboolean _tmp46_ = FALSE;
						gchar* bg_prop = NULL;
						gchar* _tmp47_ = NULL;
						GtkStyleContext* _tmp48_ = NULL;
						const gchar* _tmp49_ = NULL;
						GdkRGBA* _tmp50_ = NULL;
						gdouble _tmp51_ = 0.0;
						GdkRGBA* _tmp52_ = NULL;
						gdouble _tmp53_ = 0.0;
						GdkRGBA* _tmp54_ = NULL;
						gdouble _tmp55_ = 0.0;
						PangoAttribute* _tmp56_ = NULL;
						PangoAttribute* _tmp57_ = NULL;
						PangoAttribute* _tmp58_ = NULL;
						IBusText** _tmp59_ = NULL;
						gint _tmp59__length1 = 0;
						gint _tmp60_ = 0;
						IBusText* _tmp61_ = NULL;
						const gchar* _tmp62_ = NULL;
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
						PangoAttrList* _tmp65_ = NULL;
						PangoAttribute* _tmp66_ = NULL;
						_tmp22_ = self->priv->m_candidates;
						_tmp22__length1 = self->priv->m_candidates_length1;
						_tmp23_ = i;
						_tmp24_ = _tmp22_[_tmp23_];
						_tmp25_ = gtk_widget_get_style_context ((GtkWidget*) _tmp24_);
						_tmp26_ = _g_object_ref0 (_tmp25_);
						context = _tmp26_;
						color = NULL;
						_tmp27_ = context;
						gtk_style_context_get (_tmp27_, GTK_STATE_FLAG_SELECTED, "color", &color, NULL);
						_tmp28_ = color;
						_tmp29_ = (*_tmp28_).red;
						_tmp30_ = color;
						_tmp31_ = (*_tmp30_).green;
						_tmp32_ = color;
						_tmp33_ = (*_tmp32_).blue;
						_tmp34_ = pango_attr_foreground_new ((guint16) (_tmp29_ * G_MAXUINT16), (guint16) (_tmp31_ * G_MAXUINT16), (guint16) (_tmp33_ * G_MAXUINT16));
						pango_attr = _tmp34_;
						_tmp35_ = pango_attr;
						_tmp35_->start_index = (guint) 0;
						_tmp36_ = pango_attr;
						_tmp37_ = candidates;
						_tmp37__length1 = candidates_length1;
						_tmp38_ = i;
						_tmp39_ = _tmp37_[_tmp38_];
						_tmp40_ = ibus_text_get_text (_tmp39_);
						_tmp41_ = strlen (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp36_->end_index = (guint) _tmp42_;
						_tmp43_ = attrs;
						_tmp44_ = pango_attr;
						pango_attr = NULL;
						pango_attr_list_insert (_tmp43_, _tmp44_);
						color = NULL;
						_tmp46_ = self->priv->m_use_latest_css_format;
						if (_tmp46_) {
							_tmp45_ = "-gtk-secondary-caret-color";
						} else {
							_tmp45_ = "background-color";
						}
						_tmp47_ = g_strdup (_tmp45_);
						bg_prop = _tmp47_;
						_tmp48_ = context;
						_tmp49_ = bg_prop;
						gtk_style_context_get (_tmp48_, GTK_STATE_FLAG_SELECTED, _tmp49_, &color, NULL);
						_tmp50_ = color;
						_tmp51_ = (*_tmp50_).red;
						_tmp52_ = color;
						_tmp53_ = (*_tmp52_).green;
						_tmp54_ = color;
						_tmp55_ = (*_tmp54_).blue;
						_tmp56_ = pango_attr_background_new ((guint16) (_tmp51_ * G_MAXUINT16), (guint16) (_tmp53_ * G_MAXUINT16), (guint16) (_tmp55_ * G_MAXUINT16));
						_pango_attribute_destroy0 (pango_attr);
						pango_attr = _tmp56_;
						_tmp57_ = pango_attr;
						_tmp57_->start_index = (guint) 0;
						_tmp58_ = pango_attr;
						_tmp59_ = candidates;
						_tmp59__length1 = candidates_length1;
						_tmp60_ = i;
						_tmp61_ = _tmp59_[_tmp60_];
						_tmp62_ = ibus_text_get_text (_tmp61_);
						_tmp63_ = strlen (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp58_->end_index = (guint) _tmp64_;
						_tmp65_ = attrs;
						_tmp66_ = pango_attr;
						pango_attr = NULL;
						pango_attr_list_insert (_tmp65_, _tmp66_);
						_g_free0 (bg_prop);
						_pango_attribute_destroy0 (pango_attr);
						_g_object_unref0 (context);
					}
					_tmp67_ = label;
					_tmp68_ = candidates;
					_tmp68__length1 = candidates_length1;
					_tmp69_ = i;
					_tmp70_ = _tmp68_[_tmp69_];
					_tmp71_ = ibus_text_get_text (_tmp70_);
					gtk_label_set_text (_tmp67_, _tmp71_);
					_tmp72_ = label;
					_tmp73_ = attrs;
					gtk_label_set_attributes (_tmp72_, _tmp73_);
					visible = TRUE;
					_pango_attr_list_unref0 (attrs);
				} else {
					GtkLabel* _tmp74_ = NULL;
					GtkLabel* _tmp75_ = NULL;
					PangoAttrList* _tmp76_ = NULL;
					PangoAttrList* _tmp77_ = NULL;
					_tmp74_ = label;
					gtk_label_set_text (_tmp74_, "");
					_tmp75_ = label;
					_tmp76_ = pango_attr_list_new ();
					_tmp77_ = _tmp76_;
					gtk_label_set_attributes (_tmp75_, _tmp77_);
					_pango_attr_list_unref0 (_tmp77_);
				}
				_tmp78_ = self->priv->m_vertical;
				if (_tmp78_) {
					GtkWidget** _tmp79_ = NULL;
					gint _tmp79__length1 = 0;
					gint _tmp80_ = 0;
					GtkWidget* _tmp81_ = NULL;
					gboolean _tmp82_ = FALSE;
					GtkWidget** _tmp83_ = NULL;
					gint _tmp83__length1 = 0;
					gint _tmp84_ = 0;
					GtkWidget* _tmp85_ = NULL;
					gboolean _tmp86_ = FALSE;
					_tmp79_ = self->priv->m_widgets;
					_tmp79__length1 = self->priv->m_widgets_length1;
					_tmp80_ = i;
					_tmp81_ = _tmp79_[_tmp80_ * 2];
					_tmp82_ = visible;
					gtk_widget_set_visible (_tmp81_, _tmp82_);
					_tmp83_ = self->priv->m_widgets;
					_tmp83__length1 = self->priv->m_widgets_length1;
					_tmp84_ = i;
					_tmp85_ = _tmp83_[(_tmp84_ * 2) + 1];
					_tmp86_ = visible;
					gtk_widget_set_visible (_tmp85_, _tmp86_);
				} else {
					GtkWidget** _tmp87_ = NULL;
					gint _tmp87__length1 = 0;
					gint _tmp88_ = 0;
					GtkWidget* _tmp89_ = NULL;
					gboolean _tmp90_ = FALSE;
					_tmp87_ = self->priv->m_widgets;
					_tmp87__length1 = self->priv->m_widgets_length1;
					_tmp88_ = i;
					_tmp89_ = _tmp87_[_tmp88_];
					_tmp90_ = visible;
					gtk_widget_set_visible (_tmp89_, _tmp90_);
				}
				_g_object_unref0 (label);
			}
		}
	}
}


static void __lambda7_ (CandidateArea* self, GtkButton* b) {
	g_return_if_fail (b != NULL);
	g_signal_emit_by_name (self, "page-up");
}


static void ___lambda7__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda7_ ((CandidateArea*) self, _sender);
}


static void __lambda8_ (CandidateArea* self, GtkButton* b) {
	g_return_if_fail (b != NULL);
	g_signal_emit_by_name (self, "page-down");
}


static void ___lambda8__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	__lambda8_ ((CandidateArea*) self, _sender);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		CandidateArea* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		CandidateArea* self;
		self = _data2_->_data1_->self;
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}


static void _vala_array_add1 (GtkLabel*** array, int* length, int* size, GtkLabel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (GtkLabel*** array, int* length, int* size, GtkLabel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean ______lambda9_ (Block2Data* _data2_, GtkWidget* w, GdkEventButton* e) {
	Block1Data* _data1_;
	CandidateArea* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GdkEventButton* _tmp3_ = NULL;
	GdkModifierType _tmp4_ = 0;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data1_->i;
	_tmp1_ = e;
	_tmp2_ = _tmp1_->button;
	_tmp3_ = e;
	_tmp4_ = _tmp3_->state;
	g_signal_emit_by_name (self, "candidate-clicked", (guint) _tmp0_, _tmp2_, (guint) _tmp4_);
	result = TRUE;
	return result;
}


static gboolean _______lambda9__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = ______lambda9_ (self, _sender, event);
	return result;
}


static void _vala_array_add3 (GtkWidget*** array, int* length, int* size, GtkWidget* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkWidget*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean ______lambda10_ (Block2Data* _data2_, GtkWidget* w, GdkEventButton* e) {
	Block1Data* _data1_;
	CandidateArea* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GdkEventButton* _tmp3_ = NULL;
	GdkModifierType _tmp4_ = 0;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data2_->index;
	_tmp1_ = e;
	_tmp2_ = _tmp1_->button;
	_tmp3_ = e;
	_tmp4_ = _tmp3_->state;
	g_signal_emit_by_name (self, "candidate-clicked", (guint) _tmp0_, _tmp2_, (guint) _tmp4_);
	result = TRUE;
	return result;
}


static gboolean _______lambda10__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = ______lambda10_ (self, _sender, event);
	return result;
}


static void _vala_array_add4 (GtkWidget*** array, int* length, int* size, GtkWidget* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkWidget*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		CandidateArea* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _vala_array_add5 (GtkLabel*** array, int* length, int* size, GtkLabel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add6 (GtkLabel*** array, int* length, int* size, GtkLabel* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkLabel*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean ______lambda11_ (Block3Data* _data3_, GtkWidget* w, GdkEventButton* e) {
	CandidateArea* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GdkEventButton* _tmp3_ = NULL;
	GdkModifierType _tmp4_ = 0;
	self = _data3_->self;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = _data3_->index;
	_tmp1_ = e;
	_tmp2_ = _tmp1_->button;
	_tmp3_ = e;
	_tmp4_ = _tmp3_->state;
	g_signal_emit_by_name (self, "candidate-clicked", (guint) _tmp0_, _tmp2_, (guint) _tmp4_);
	result = TRUE;
	return result;
}


static gboolean _______lambda11__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = ______lambda11_ (self, _sender, event);
	return result;
}


static void _vala_array_add7 (GtkWidget*** array, int* length, int* size, GtkWidget* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GtkWidget*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void candidate_area_recreate_ui (CandidateArea* self) {
	GList* _tmp0_ = NULL;
	GtkButton* prev_button = NULL;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_ = NULL;
	GtkButton* _tmp5_ = NULL;
	GtkOrientation _tmp6_ = 0;
	GtkOrientation _tmp7_ = 0;
	const gchar* _tmp8_ = NULL;
	GtkImage* _tmp9_ = NULL;
	GtkImage* _tmp10_ = NULL;
	GtkButton* _tmp11_ = NULL;
	GtkButton* next_button = NULL;
	GtkButton* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	GtkButton* _tmp14_ = NULL;
	GtkOrientation _tmp15_ = 0;
	GtkOrientation _tmp16_ = 0;
	const gchar* _tmp17_ = NULL;
	GtkImage* _tmp18_ = NULL;
	GtkImage* _tmp19_ = NULL;
	GtkButton* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self);
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp0_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp1_ = NULL;
			GtkWidget* w = NULL;
			_tmp1_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp1_;
			{
				GtkWidget* _tmp2_ = NULL;
				_tmp2_ = w;
				gtk_widget_destroy (_tmp2_);
				_g_object_unref0 (w);
			}
		}
		_g_list_free0 (w_collection);
	}
	_tmp3_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp3_);
	prev_button = _tmp3_;
	_tmp4_ = prev_button;
	g_signal_connect_object (_tmp4_, "clicked", (GCallback) ___lambda7__gtk_button_clicked, self, 0);
	_tmp5_ = prev_button;
	_tmp6_ = gtk_orientable_get_orientation ((GtkOrientable*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = CANDIDATE_AREA_PREV_PAGE_ICONS[_tmp7_];
	_tmp9_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp8_, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp9_);
	_tmp10_ = _tmp9_;
	gtk_button_set_image (_tmp5_, (GtkWidget*) _tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = prev_button;
	gtk_button_set_relief (_tmp11_, GTK_RELIEF_NONE);
	_tmp12_ = (GtkButton*) gtk_button_new ();
	g_object_ref_sink (_tmp12_);
	next_button = _tmp12_;
	_tmp13_ = next_button;
	g_signal_connect_object (_tmp13_, "clicked", (GCallback) ___lambda8__gtk_button_clicked, self, 0);
	_tmp14_ = next_button;
	_tmp15_ = gtk_orientable_get_orientation ((GtkOrientable*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = CANDIDATE_AREA_NEXT_PAGE_ICONS[_tmp16_];
	_tmp18_ = (GtkImage*) gtk_image_new_from_icon_name (_tmp17_, GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp18_);
	_tmp19_ = _tmp18_;
	gtk_button_set_image (_tmp14_, (GtkWidget*) _tmp19_);
	_g_object_unref0 (_tmp19_);
	_tmp20_ = next_button;
	gtk_button_set_relief (_tmp20_, GTK_RELIEF_NONE);
	_tmp21_ = self->priv->m_vertical;
	if (_tmp21_) {
		GtkBox* candidates_hbox = NULL;
		GtkBox* _tmp22_ = NULL;
		GtkBox* _tmp23_ = NULL;
		GtkBox* labels_vbox = NULL;
		GtkBox* _tmp24_ = NULL;
		GtkBox* _tmp25_ = NULL;
		GtkBox* candidates_vbox = NULL;
		GtkBox* _tmp26_ = NULL;
		GtkBox* _tmp27_ = NULL;
		GtkBox* _tmp28_ = NULL;
		GtkBox* _tmp29_ = NULL;
		GtkBox* _tmp30_ = NULL;
		VSeparator* _tmp31_ = NULL;
		VSeparator* _tmp32_ = NULL;
		GtkBox* _tmp33_ = NULL;
		GtkBox* _tmp34_ = NULL;
		HSeparator* _tmp35_ = NULL;
		HSeparator* _tmp36_ = NULL;
		GtkBox* buttons_hbox = NULL;
		GtkBox* _tmp37_ = NULL;
		GtkLabel* state_label = NULL;
		GtkLabel* _tmp38_ = NULL;
		GtkLabel* _tmp39_ = NULL;
		GtkBox* _tmp40_ = NULL;
		GtkLabel* _tmp41_ = NULL;
		GtkBox* _tmp42_ = NULL;
		GtkButton* _tmp43_ = NULL;
		GtkBox* _tmp44_ = NULL;
		GtkButton* _tmp45_ = NULL;
		GtkBox* _tmp46_ = NULL;
		GtkLabel** _tmp47_ = NULL;
		GtkLabel** _tmp48_ = NULL;
		GtkWidget** _tmp49_ = NULL;
		_tmp22_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp22_);
		candidates_hbox = _tmp22_;
		_tmp23_ = candidates_hbox;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp23_, FALSE, FALSE, (guint) 0);
		_tmp24_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp24_);
		labels_vbox = _tmp24_;
		_tmp25_ = labels_vbox;
		gtk_box_set_homogeneous (_tmp25_, TRUE);
		_tmp26_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp26_);
		candidates_vbox = _tmp26_;
		_tmp27_ = candidates_vbox;
		gtk_box_set_homogeneous (_tmp27_, TRUE);
		_tmp28_ = candidates_hbox;
		_tmp29_ = labels_vbox;
		gtk_box_pack_start (_tmp28_, (GtkWidget*) _tmp29_, FALSE, FALSE, (guint) 4);
		_tmp30_ = candidates_hbox;
		_tmp31_ = vseparator_new ();
		g_object_ref_sink (_tmp31_);
		_tmp32_ = _tmp31_;
		gtk_box_pack_start (_tmp30_, (GtkWidget*) _tmp32_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp32_);
		_tmp33_ = candidates_hbox;
		_tmp34_ = candidates_vbox;
		gtk_box_pack_start (_tmp33_, (GtkWidget*) _tmp34_, TRUE, TRUE, (guint) 4);
		_tmp35_ = hseparator_new ();
		g_object_ref_sink (_tmp35_);
		_tmp36_ = _tmp35_;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp36_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp36_);
		_tmp37_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp37_);
		buttons_hbox = _tmp37_;
		_tmp38_ = (GtkLabel*) gtk_label_new (NULL);
		g_object_ref_sink (_tmp38_);
		state_label = _tmp38_;
		_tmp39_ = state_label;
		gtk_widget_set_size_request ((GtkWidget*) _tmp39_, 20, -1);
		_tmp40_ = buttons_hbox;
		_tmp41_ = state_label;
		gtk_box_pack_start (_tmp40_, (GtkWidget*) _tmp41_, TRUE, TRUE, (guint) 0);
		_tmp42_ = buttons_hbox;
		_tmp43_ = prev_button;
		gtk_box_pack_start (_tmp42_, (GtkWidget*) _tmp43_, FALSE, FALSE, (guint) 0);
		_tmp44_ = buttons_hbox;
		_tmp45_ = next_button;
		gtk_box_pack_start (_tmp44_, (GtkWidget*) _tmp45_, FALSE, FALSE, (guint) 0);
		_tmp46_ = buttons_hbox;
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp46_, FALSE, FALSE, (guint) 0);
		_tmp47_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_labels = (_vala_array_free (self->priv->m_labels, self->priv->m_labels_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_labels = _tmp47_;
		self->priv->m_labels_length1 = 0;
		self->priv->_m_labels_size_ = self->priv->m_labels_length1;
		_tmp48_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_candidates = _tmp48_;
		self->priv->m_candidates_length1 = 0;
		self->priv->_m_candidates_size_ = self->priv->m_candidates_length1;
		_tmp49_ = g_new0 (GtkWidget*, 0 + 1);
		self->priv->m_widgets = (_vala_array_free (self->priv->m_widgets, self->priv->m_widgets_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_widgets = _tmp49_;
		self->priv->m_widgets_length1 = 0;
		self->priv->_m_widgets_size_ = self->priv->m_widgets_length1;
		{
			Block1Data* _data1_;
			_data1_ = g_slice_new0 (Block1Data);
			_data1_->_ref_count_ = 1;
			_data1_->self = g_object_ref (self);
			_data1_->i = 0;
			{
				gboolean _tmp50_ = FALSE;
				_tmp50_ = TRUE;
				while (TRUE) {
					Block2Data* _data2_;
					gint _tmp52_ = 0;
					GtkLabel* label = NULL;
					gint _tmp53_ = 0;
					const gchar* _tmp54_ = NULL;
					GtkLabel* _tmp55_ = NULL;
					GtkLabel* _tmp56_ = NULL;
					GtkLabel* _tmp57_ = NULL;
					GtkLabel* _tmp58_ = NULL;
					GtkLabel** _tmp59_ = NULL;
					gint _tmp59__length1 = 0;
					GtkLabel* _tmp60_ = NULL;
					GtkLabel* _tmp61_ = NULL;
					GtkLabel* candidate = NULL;
					GtkLabel* _tmp62_ = NULL;
					GtkLabel* _tmp63_ = NULL;
					GtkLabel* _tmp64_ = NULL;
					GtkLabel* _tmp65_ = NULL;
					GtkLabel** _tmp66_ = NULL;
					gint _tmp66__length1 = 0;
					GtkLabel* _tmp67_ = NULL;
					GtkLabel* _tmp68_ = NULL;
					GtkLabel* _tmp69_ = NULL;
					GtkLabel* _tmp70_ = NULL;
					gint _tmp71_ = 0;
					GtkEventBox* label_ebox = NULL;
					GtkEventBox* _tmp72_ = NULL;
					GtkEventBox* _tmp73_ = NULL;
					GtkEventBox* _tmp74_ = NULL;
					GtkEventBox* _tmp75_ = NULL;
					GtkLabel* _tmp76_ = NULL;
					GtkBox* _tmp77_ = NULL;
					GtkEventBox* _tmp78_ = NULL;
					GtkWidget** _tmp79_ = NULL;
					gint _tmp79__length1 = 0;
					GtkEventBox* _tmp80_ = NULL;
					GtkWidget* _tmp81_ = NULL;
					GtkEventBox* candidate_ebox = NULL;
					GtkEventBox* _tmp82_ = NULL;
					GtkEventBox* _tmp83_ = NULL;
					GtkEventBox* _tmp84_ = NULL;
					GtkEventBox* _tmp85_ = NULL;
					GtkLabel* _tmp86_ = NULL;
					GtkBox* _tmp87_ = NULL;
					GtkEventBox* _tmp88_ = NULL;
					GtkWidget** _tmp89_ = NULL;
					gint _tmp89__length1 = 0;
					GtkEventBox* _tmp90_ = NULL;
					GtkWidget* _tmp91_ = NULL;
					_data2_ = g_slice_new0 (Block2Data);
					_data2_->_ref_count_ = 1;
					_data2_->_data1_ = block1_data_ref (_data1_);
					if (!_tmp50_) {
						gint _tmp51_ = 0;
						_tmp51_ = _data1_->i;
						_data1_->i = _tmp51_ + 1;
					}
					_tmp50_ = FALSE;
					_tmp52_ = _data1_->i;
					if (!(_tmp52_ < 16)) {
						block2_data_unref (_data2_);
						_data2_ = NULL;
						break;
					}
					_tmp53_ = _data1_->i;
					_tmp54_ = CANDIDATE_AREA_LABELS[_tmp53_];
					_tmp55_ = (GtkLabel*) gtk_label_new (_tmp54_);
					g_object_ref_sink (_tmp55_);
					label = _tmp55_;
					_tmp56_ = label;
					gtk_widget_set_halign ((GtkWidget*) _tmp56_, GTK_ALIGN_START);
					_tmp57_ = label;
					gtk_widget_set_valign ((GtkWidget*) _tmp57_, GTK_ALIGN_CENTER);
					_tmp58_ = label;
					gtk_widget_show ((GtkWidget*) _tmp58_);
					_tmp59_ = self->priv->m_labels;
					_tmp59__length1 = self->priv->m_labels_length1;
					_tmp60_ = label;
					_tmp61_ = _g_object_ref0 (_tmp60_);
					_vala_array_add1 (&self->priv->m_labels, &self->priv->m_labels_length1, &self->priv->_m_labels_size_, _tmp61_);
					_tmp62_ = (GtkLabel*) gtk_label_new ("test");
					g_object_ref_sink (_tmp62_);
					candidate = _tmp62_;
					_tmp63_ = candidate;
					gtk_widget_set_halign ((GtkWidget*) _tmp63_, GTK_ALIGN_START);
					_tmp64_ = candidate;
					gtk_widget_set_valign ((GtkWidget*) _tmp64_, GTK_ALIGN_CENTER);
					_tmp65_ = candidate;
					gtk_widget_show ((GtkWidget*) _tmp65_);
					_tmp66_ = self->priv->m_candidates;
					_tmp66__length1 = self->priv->m_candidates_length1;
					_tmp67_ = candidate;
					_tmp68_ = _g_object_ref0 (_tmp67_);
					_vala_array_add2 (&self->priv->m_candidates, &self->priv->m_candidates_length1, &self->priv->_m_candidates_size_, _tmp68_);
					_tmp69_ = label;
					gtk_misc_set_padding ((GtkMisc*) _tmp69_, 8, 0);
					_tmp70_ = candidate;
					gtk_misc_set_padding ((GtkMisc*) _tmp70_, 8, 0);
					_tmp71_ = _data1_->i;
					_data2_->index = _tmp71_;
					_tmp72_ = (GtkEventBox*) gtk_event_box_new ();
					g_object_ref_sink (_tmp72_);
					label_ebox = _tmp72_;
					_tmp73_ = label_ebox;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp73_, TRUE);
					_tmp74_ = label_ebox;
					g_signal_connect_data ((GtkWidget*) _tmp74_, "button-press-event", (GCallback) _______lambda9__gtk_widget_button_press_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_tmp75_ = label_ebox;
					_tmp76_ = label;
					gtk_container_add ((GtkContainer*) _tmp75_, (GtkWidget*) _tmp76_);
					_tmp77_ = labels_vbox;
					_tmp78_ = label_ebox;
					gtk_box_pack_start (_tmp77_, (GtkWidget*) _tmp78_, FALSE, FALSE, (guint) 2);
					_tmp79_ = self->priv->m_widgets;
					_tmp79__length1 = self->priv->m_widgets_length1;
					_tmp80_ = label_ebox;
					_tmp81_ = _g_object_ref0 ((GtkWidget*) _tmp80_);
					_vala_array_add3 (&self->priv->m_widgets, &self->priv->m_widgets_length1, &self->priv->_m_widgets_size_, _tmp81_);
					_tmp82_ = (GtkEventBox*) gtk_event_box_new ();
					g_object_ref_sink (_tmp82_);
					candidate_ebox = _tmp82_;
					_tmp83_ = candidate_ebox;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp83_, TRUE);
					_tmp84_ = candidate_ebox;
					g_signal_connect_data ((GtkWidget*) _tmp84_, "button-press-event", (GCallback) _______lambda10__gtk_widget_button_press_event, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
					_tmp85_ = candidate_ebox;
					_tmp86_ = candidate;
					gtk_container_add ((GtkContainer*) _tmp85_, (GtkWidget*) _tmp86_);
					_tmp87_ = candidates_vbox;
					_tmp88_ = candidate_ebox;
					gtk_box_pack_start (_tmp87_, (GtkWidget*) _tmp88_, FALSE, FALSE, (guint) 2);
					_tmp89_ = self->priv->m_widgets;
					_tmp89__length1 = self->priv->m_widgets_length1;
					_tmp90_ = candidate_ebox;
					_tmp91_ = _g_object_ref0 ((GtkWidget*) _tmp90_);
					_vala_array_add4 (&self->priv->m_widgets, &self->priv->m_widgets_length1, &self->priv->_m_widgets_size_, _tmp91_);
					_g_object_unref0 (candidate_ebox);
					_g_object_unref0 (label_ebox);
					_g_object_unref0 (candidate);
					_g_object_unref0 (label);
					block2_data_unref (_data2_);
					_data2_ = NULL;
				}
			}
			block1_data_unref (_data1_);
			_data1_ = NULL;
		}
		_g_object_unref0 (state_label);
		_g_object_unref0 (buttons_hbox);
		_g_object_unref0 (candidates_vbox);
		_g_object_unref0 (labels_vbox);
		_g_object_unref0 (candidates_hbox);
	} else {
		GtkBox* hbox = NULL;
		GtkBox* _tmp92_ = NULL;
		GtkBox* _tmp93_ = NULL;
		GtkLabel** _tmp94_ = NULL;
		GtkLabel** _tmp95_ = NULL;
		GtkWidget** _tmp96_ = NULL;
		GtkBox* _tmp133_ = NULL;
		VSeparator* _tmp134_ = NULL;
		VSeparator* _tmp135_ = NULL;
		GtkBox* _tmp136_ = NULL;
		GtkButton* _tmp137_ = NULL;
		GtkBox* _tmp138_ = NULL;
		GtkButton* _tmp139_ = NULL;
		_tmp92_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		g_object_ref_sink (_tmp92_);
		hbox = _tmp92_;
		_tmp93_ = hbox;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp93_);
		_tmp94_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_labels = (_vala_array_free (self->priv->m_labels, self->priv->m_labels_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_labels = _tmp94_;
		self->priv->m_labels_length1 = 0;
		self->priv->_m_labels_size_ = self->priv->m_labels_length1;
		_tmp95_ = g_new0 (GtkLabel*, 0 + 1);
		self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_candidates = _tmp95_;
		self->priv->m_candidates_length1 = 0;
		self->priv->_m_candidates_size_ = self->priv->m_candidates_length1;
		_tmp96_ = g_new0 (GtkWidget*, 0 + 1);
		self->priv->m_widgets = (_vala_array_free (self->priv->m_widgets, self->priv->m_widgets_length1, (GDestroyNotify) g_object_unref), NULL);
		self->priv->m_widgets = _tmp96_;
		self->priv->m_widgets_length1 = 0;
		self->priv->_m_widgets_size_ = self->priv->m_widgets_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp97_ = FALSE;
				_tmp97_ = TRUE;
				while (TRUE) {
					Block3Data* _data3_;
					gint _tmp99_ = 0;
					GtkLabel* label = NULL;
					gint _tmp100_ = 0;
					const gchar* _tmp101_ = NULL;
					GtkLabel* _tmp102_ = NULL;
					GtkLabel* _tmp103_ = NULL;
					GtkLabel* _tmp104_ = NULL;
					GtkLabel* _tmp105_ = NULL;
					GtkLabel** _tmp106_ = NULL;
					gint _tmp106__length1 = 0;
					GtkLabel* _tmp107_ = NULL;
					GtkLabel* _tmp108_ = NULL;
					GtkLabel* candidate = NULL;
					GtkLabel* _tmp109_ = NULL;
					GtkLabel* _tmp110_ = NULL;
					GtkLabel* _tmp111_ = NULL;
					GtkLabel* _tmp112_ = NULL;
					GtkLabel** _tmp113_ = NULL;
					gint _tmp113__length1 = 0;
					GtkLabel* _tmp114_ = NULL;
					GtkLabel* _tmp115_ = NULL;
					GtkBox* candidate_hbox = NULL;
					GtkBox* _tmp116_ = NULL;
					GtkBox* _tmp117_ = NULL;
					GtkBox* _tmp118_ = NULL;
					GtkLabel* _tmp119_ = NULL;
					GtkBox* _tmp120_ = NULL;
					GtkLabel* _tmp121_ = NULL;
					gint _tmp122_ = 0;
					GtkEventBox* ebox = NULL;
					GtkEventBox* _tmp123_ = NULL;
					GtkEventBox* _tmp124_ = NULL;
					GtkEventBox* _tmp125_ = NULL;
					GtkEventBox* _tmp126_ = NULL;
					GtkBox* _tmp127_ = NULL;
					GtkBox* _tmp128_ = NULL;
					GtkEventBox* _tmp129_ = NULL;
					GtkWidget** _tmp130_ = NULL;
					gint _tmp130__length1 = 0;
					GtkEventBox* _tmp131_ = NULL;
					GtkWidget* _tmp132_ = NULL;
					_data3_ = g_slice_new0 (Block3Data);
					_data3_->_ref_count_ = 1;
					_data3_->self = g_object_ref (self);
					if (!_tmp97_) {
						gint _tmp98_ = 0;
						_tmp98_ = i;
						i = _tmp98_ + 1;
					}
					_tmp97_ = FALSE;
					_tmp99_ = i;
					if (!(_tmp99_ < 16)) {
						block3_data_unref (_data3_);
						_data3_ = NULL;
						break;
					}
					_tmp100_ = i;
					_tmp101_ = CANDIDATE_AREA_LABELS[_tmp100_];
					_tmp102_ = (GtkLabel*) gtk_label_new (_tmp101_);
					g_object_ref_sink (_tmp102_);
					label = _tmp102_;
					_tmp103_ = label;
					gtk_widget_set_halign ((GtkWidget*) _tmp103_, GTK_ALIGN_START);
					_tmp104_ = label;
					gtk_widget_set_valign ((GtkWidget*) _tmp104_, GTK_ALIGN_CENTER);
					_tmp105_ = label;
					gtk_widget_show ((GtkWidget*) _tmp105_);
					_tmp106_ = self->priv->m_labels;
					_tmp106__length1 = self->priv->m_labels_length1;
					_tmp107_ = label;
					_tmp108_ = _g_object_ref0 (_tmp107_);
					_vala_array_add5 (&self->priv->m_labels, &self->priv->m_labels_length1, &self->priv->_m_labels_size_, _tmp108_);
					_tmp109_ = (GtkLabel*) gtk_label_new ("test");
					g_object_ref_sink (_tmp109_);
					candidate = _tmp109_;
					_tmp110_ = candidate;
					gtk_widget_set_halign ((GtkWidget*) _tmp110_, GTK_ALIGN_START);
					_tmp111_ = candidate;
					gtk_widget_set_valign ((GtkWidget*) _tmp111_, GTK_ALIGN_CENTER);
					_tmp112_ = candidate;
					gtk_widget_show ((GtkWidget*) _tmp112_);
					_tmp113_ = self->priv->m_candidates;
					_tmp113__length1 = self->priv->m_candidates_length1;
					_tmp114_ = candidate;
					_tmp115_ = _g_object_ref0 (_tmp114_);
					_vala_array_add6 (&self->priv->m_candidates, &self->priv->m_candidates_length1, &self->priv->_m_candidates_size_, _tmp115_);
					_tmp116_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
					g_object_ref_sink (_tmp116_);
					candidate_hbox = _tmp116_;
					_tmp117_ = candidate_hbox;
					gtk_widget_show ((GtkWidget*) _tmp117_);
					_tmp118_ = candidate_hbox;
					_tmp119_ = label;
					gtk_box_pack_start (_tmp118_, (GtkWidget*) _tmp119_, FALSE, FALSE, (guint) 2);
					_tmp120_ = candidate_hbox;
					_tmp121_ = candidate;
					gtk_box_pack_start (_tmp120_, (GtkWidget*) _tmp121_, FALSE, FALSE, (guint) 2);
					_tmp122_ = i;
					_data3_->index = _tmp122_;
					_tmp123_ = (GtkEventBox*) gtk_event_box_new ();
					g_object_ref_sink (_tmp123_);
					ebox = _tmp123_;
					_tmp124_ = ebox;
					gtk_widget_set_no_show_all ((GtkWidget*) _tmp124_, TRUE);
					_tmp125_ = ebox;
					g_signal_connect_data ((GtkWidget*) _tmp125_, "button-press-event", (GCallback) _______lambda11__gtk_widget_button_press_event, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
					_tmp126_ = ebox;
					_tmp127_ = candidate_hbox;
					gtk_container_add ((GtkContainer*) _tmp126_, (GtkWidget*) _tmp127_);
					_tmp128_ = hbox;
					_tmp129_ = ebox;
					gtk_box_pack_start (_tmp128_, (GtkWidget*) _tmp129_, FALSE, FALSE, (guint) 4);
					_tmp130_ = self->priv->m_widgets;
					_tmp130__length1 = self->priv->m_widgets_length1;
					_tmp131_ = ebox;
					_tmp132_ = _g_object_ref0 ((GtkWidget*) _tmp131_);
					_vala_array_add7 (&self->priv->m_widgets, &self->priv->m_widgets_length1, &self->priv->_m_widgets_size_, _tmp132_);
					_g_object_unref0 (ebox);
					_g_object_unref0 (candidate_hbox);
					_g_object_unref0 (candidate);
					_g_object_unref0 (label);
					block3_data_unref (_data3_);
					_data3_ = NULL;
				}
			}
		}
		_tmp133_ = hbox;
		_tmp134_ = vseparator_new ();
		g_object_ref_sink (_tmp134_);
		_tmp135_ = _tmp134_;
		gtk_box_pack_start (_tmp133_, (GtkWidget*) _tmp135_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp135_);
		_tmp136_ = hbox;
		_tmp137_ = prev_button;
		gtk_box_pack_start (_tmp136_, (GtkWidget*) _tmp137_, FALSE, FALSE, (guint) 0);
		_tmp138_ = hbox;
		_tmp139_ = next_button;
		gtk_box_pack_start (_tmp138_, (GtkWidget*) _tmp139_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (hbox);
	}
	_g_object_unref0 (next_button);
	_g_object_unref0 (prev_button);
}


static void g_cclosure_user_marshal_VOID__UINT_UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), data2);
}


static void candidate_area_class_init (CandidateAreaClass * klass) {
	candidate_area_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CandidateAreaPrivate));
	G_OBJECT_CLASS (klass)->finalize = candidate_area_finalize;
	g_signal_new ("candidate_clicked", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_UINT, G_TYPE_NONE, 3, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("page_up", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("page_down", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("cursor_up", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("cursor_down", TYPE_CANDIDATE_AREA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void candidate_area_instance_init (CandidateArea * self) {
	self->priv = CANDIDATE_AREA_GET_PRIVATE (self);
	self->priv->m_use_latest_css_format = (GTK_MAJOR_VERSION > 3) || ((GTK_MAJOR_VERSION == 3) && (GTK_MINOR_VERSION >= 20));
}


static void candidate_area_finalize (GObject* obj) {
	CandidateArea * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CANDIDATE_AREA, CandidateArea);
	self->priv->m_labels = (_vala_array_free (self->priv->m_labels, self->priv->m_labels_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_candidates = (_vala_array_free (self->priv->m_candidates, self->priv->m_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_widgets = (_vala_array_free (self->priv->m_widgets, self->priv->m_widgets_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_ibus_candidates = (_vala_array_free (self->priv->m_ibus_candidates, self->priv->m_ibus_candidates_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (candidate_area_parent_class)->finalize (obj);
}


GType candidate_area_get_type (void) {
	static volatile gsize candidate_area_type_id__volatile = 0;
	if (g_once_init_enter (&candidate_area_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CandidateAreaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) candidate_area_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CandidateArea), 0, (GInstanceInitFunc) candidate_area_instance_init, NULL };
		GType candidate_area_type_id;
		candidate_area_type_id = g_type_register_static (gtk_box_get_type (), "CandidateArea", &g_define_type_info, 0);
		g_once_init_leave (&candidate_area_type_id__volatile, candidate_area_type_id);
	}
	return candidate_area_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



