/* main.c generated by valac 0.48.11, the Vala compiler
 * generated from main.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2013 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2015-2020 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <ibus.h>
#include <gobject/gvaluecollector.h>
#include <glib/gi18n-lib.h>
#include <config.h>
#include <stdio.h>
#include <gio/gio.h>
#include <locale.h>

#define TYPE_ENGINE_LIST (engine_list_get_type ())
#define ENGINE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ENGINE_LIST, EngineList))
#define ENGINE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ENGINE_LIST, EngineListClass))
#define IS_ENGINE_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ENGINE_LIST))
#define IS_ENGINE_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ENGINE_LIST))
#define ENGINE_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ENGINE_LIST, EngineListClass))

typedef struct _EngineList EngineList;
typedef struct _EngineListClass EngineListClass;
typedef struct _EngineListPrivate EngineListPrivate;
typedef struct _ParamSpecEngineList ParamSpecEngineList;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _engine_list_unref0(var) ((var == NULL) ? NULL : (var = (engine_list_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_settings_schema_source_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_source_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))
typedef gint (*EntryFunc) (gchar** argv, gint argv_length1, gpointer user_data);

#define TYPE_COMMAND_ENTRY (command_entry_get_type ())
typedef struct _CommandEntry CommandEntry;

struct _EngineList {
	GTypeInstance parent_instance;
	volatile int ref_count;
	EngineListPrivate * priv;
	IBusEngineDesc** data;
	gint data_length1;
	gint _data_size_;
};

struct _EngineListClass {
	GTypeClass parent_class;
	void (*finalize) (EngineList *self);
};

struct _ParamSpecEngineList {
	GParamSpec parent_instance;
};

struct _CommandEntry {
	const gchar* name;
	const gchar* description;
	EntryFunc entry;
	gpointer entry_target;
};

extern gboolean name_only;
gboolean name_only = FALSE;
extern gboolean is_system;
gboolean is_system = FALSE;
extern gchar* cache_file;
gchar* cache_file = NULL;
extern gchar* engine_id;
gchar* engine_id = NULL;
static gpointer engine_list_parent_class = NULL;
extern gchar* program_name;
gchar* program_name = NULL;

#define IBUS_SCHEMAS_GENERAL "org.freedesktop.ibus.general"
#define IBUS_SCHEMAS_GENERAL_HOTKEY "org.freedesktop.ibus.general.hotkey"
#define IBUS_SCHEMAS_PANEL "org.freedesktop.ibus.panel"
#define IBUS_SCHEMAS_PANEL_EMOJI "org.freedesktop.ibus.panel.emoji"
gpointer engine_list_ref (gpointer instance);
void engine_list_unref (gpointer instance);
GParamSpec* param_spec_engine_list (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
void value_set_engine_list (GValue* value,
                            gpointer v_object);
void value_take_engine_list (GValue* value,
                             gpointer v_object);
gpointer value_get_engine_list (const GValue* value);
GType engine_list_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EngineList, engine_list_unref)
EngineList* engine_list_new (void);
EngineList* engine_list_construct (GType object_type);
static void engine_list_finalize (EngineList * obj);
static GType engine_list_get_type_once (void);
IBusBus* get_bus (void);
gint list_engine (gchar** argv,
                  gint argv_length1);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void _g_free0_ (gpointer var);
static void _engine_list_unref0_ (gpointer var);
static void _vala_array_add1 (IBusEngineDesc** * array,
                       gint* length,
                       gint* size,
                       IBusEngineDesc* value);
gint exec_setxkbmap (IBusEngineDesc* engine);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
gint get_set_engine (gchar** argv,
                     gint argv_length1);
gint message_watch (gchar** argv,
                    gint argv_length1);
gint restart_daemon (gchar** argv,
                     gint argv_length1);
gint exit_daemon (gchar** argv,
                  gint argv_length1);
gint print_version (gchar** argv,
                    gint argv_length1);
gint read_cache (gchar** argv,
                 gint argv_length1);
gint write_cache (gchar** argv,
                  gint argv_length1);
gint print_address (gchar** argv,
                    gint argv_length1);
gint read_config_options (gchar** argv,
                          gint argv_length1);
GSList* get_ibus_schemas (void);
gint read_config (gchar** argv,
                  gint argv_length1);
static inline void _g_slist_free__g_free0_ (GSList* self);
gint reset_config (gchar** argv,
                   gint argv_length1);
gint emoji_dialog (gchar** argv,
                   gint argv_length1);
gint print_help (gchar** argv,
                 gint argv_length1);
void print_usage (FILE* stream);
GType command_entry_get_type (void) G_GNUC_CONST;
CommandEntry* command_entry_dup (const CommandEntry* self);
void command_entry_free (CommandEntry* self);
static gint _get_set_engine_entry_func (gchar** argv,
                                 gint argv_length1,
                                 gpointer self);
static gint _exit_daemon_entry_func (gchar** argv,
                              gint argv_length1,
                              gpointer self);
static gint _list_engine_entry_func (gchar** argv,
                              gint argv_length1,
                              gpointer self);
static gint _message_watch_entry_func (gchar** argv,
                                gint argv_length1,
                                gpointer self);
static gint _restart_daemon_entry_func (gchar** argv,
                                 gint argv_length1,
                                 gpointer self);
static gint _print_version_entry_func (gchar** argv,
                                gint argv_length1,
                                gpointer self);
static gint _read_cache_entry_func (gchar** argv,
                             gint argv_length1,
                             gpointer self);
static gint _write_cache_entry_func (gchar** argv,
                              gint argv_length1,
                              gpointer self);
static gint _print_address_entry_func (gchar** argv,
                                gint argv_length1,
                                gpointer self);
static gint _read_config_entry_func (gchar** argv,
                              gint argv_length1,
                              gpointer self);
static gint _reset_config_entry_func (gchar** argv,
                               gint argv_length1,
                               gpointer self);
static gint _emoji_dialog_entry_func (gchar** argv,
                               gint argv_length1,
                               gpointer self);
static gint _print_help_entry_func (gchar** argv,
                             gint argv_length1,
                             gpointer self);
gint _vala_main (gchar** argv,
                 gint argv_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gint length);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const CommandEntry commands[13] = {{"engine", N_ ("Set or get engine"), _get_set_engine_entry_func}, {"exit", N_ ("Exit ibus-daemon"), _exit_daemon_entry_func}, {"list-engine", N_ ("Show available engines"), _list_engine_entry_func}, {"watch", N_ ("(Not implemented)"), _message_watch_entry_func}, {"restart", N_ ("Restart ibus-daemon"), _restart_daemon_entry_func}, {"version", N_ ("Show version"), _print_version_entry_func}, {"read-cache", N_ ("Show the content of registry cache"), _read_cache_entry_func}, {"write-cache", N_ ("Create registry cache"), _write_cache_entry_func}, {"address", N_ ("Print the D-Bus address of ibus-daemon"), _print_address_entry_func}, {"read-config", N_ ("Show the configuration values"), _read_config_entry_func}, {"reset-config", N_ ("Reset the configuration values"), _reset_config_entry_func}, {"emoji", N_ ("Save emoji on dialog to clipboard"), _emoji_dialog_entry_func}, {"help", N_ ("Show this information"), _print_help_entry_func}};

EngineList*
engine_list_construct (GType object_type)
{
	EngineList* self = NULL;
	self = (EngineList*) g_type_create_instance (object_type);
	return self;
}

EngineList*
engine_list_new (void)
{
	return engine_list_construct (TYPE_ENGINE_LIST);
}

static void
value_engine_list_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_engine_list_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		engine_list_unref (value->data[0].v_pointer);
	}
}

static void
value_engine_list_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = engine_list_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_engine_list_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_engine_list_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		EngineList * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = engine_list_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_engine_list_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	EngineList ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = engine_list_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_engine_list (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecEngineList* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_ENGINE_LIST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_engine_list (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST), NULL);
	return value->data[0].v_pointer;
}

void
value_set_engine_list (GValue* value,
                       gpointer v_object)
{
	EngineList * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENGINE_LIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		engine_list_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		engine_list_unref (old);
	}
}

void
value_take_engine_list (GValue* value,
                        gpointer v_object)
{
	EngineList * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_ENGINE_LIST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_ENGINE_LIST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		engine_list_unref (old);
	}
}

static void
engine_list_class_init (EngineListClass * klass,
                        gpointer klass_data)
{
	engine_list_parent_class = g_type_class_peek_parent (klass);
	((EngineListClass *) klass)->finalize = engine_list_finalize;
}

static void
engine_list_instance_init (EngineList * self,
                           gpointer klass)
{
	IBusEngineDesc** _tmp0_;
	_tmp0_ = g_new0 (IBusEngineDesc*, 0 + 1);
	self->data = _tmp0_;
	self->data_length1 = 0;
	self->_data_size_ = self->data_length1;
	self->ref_count = 1;
}

static void
engine_list_finalize (EngineList * obj)
{
	EngineList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ENGINE_LIST, EngineList);
	g_signal_handlers_destroy (self);
	self->data = (_vala_array_free (self->data, self->data_length1, (GDestroyNotify) g_object_unref), NULL);
}

static GType
engine_list_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_engine_list_init, value_engine_list_free_value, value_engine_list_copy_value, value_engine_list_peek_pointer, "p", value_engine_list_collect_value, "p", value_engine_list_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (EngineListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) engine_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EngineList), 0, (GInstanceInitFunc) engine_list_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType engine_list_type_id;
	engine_list_type_id = g_type_register_fundamental (g_type_fundamental_next (), "EngineList", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return engine_list_type_id;
}

GType
engine_list_get_type (void)
{
	static volatile gsize engine_list_type_id__volatile = 0;
	if (g_once_init_enter (&engine_list_type_id__volatile)) {
		GType engine_list_type_id;
		engine_list_type_id = engine_list_get_type_once ();
		g_once_init_leave (&engine_list_type_id__volatile, engine_list_type_id);
	}
	return engine_list_type_id__volatile;
}

gpointer
engine_list_ref (gpointer instance)
{
	EngineList * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
engine_list_unref (gpointer instance)
{
	EngineList * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		ENGINE_LIST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

IBusBus*
get_bus (void)
{
	IBusBus* bus = NULL;
	IBusBus* _tmp0_;
	IBusBus* _tmp1_;
	IBusBus* result = NULL;
	_tmp0_ = ibus_bus_new ();
	g_object_ref_sink (_tmp0_);
	bus = _tmp0_;
	_tmp1_ = bus;
	if (!ibus_bus_is_connected (_tmp1_)) {
		result = NULL;
		_g_object_unref0 (bus);
		return result;
	}
	result = bus;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_engine_list_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (engine_list_unref (var), NULL));
}

static gpointer
_engine_list_ref0 (gpointer self)
{
	return self ? engine_list_ref (self) : NULL;
}

static void
_vala_array_add1 (IBusEngineDesc** * array,
                  gint* length,
                  gint* size,
                  IBusEngineDesc* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IBusEngineDesc*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gint
list_engine (gchar** argv,
             gint argv_length1)
{
	static const GOptionEntry options[2] = {{"name-only", (gchar) 0, 0, G_OPTION_ARG_NONE, &name_only, N_ ("List engine name only"), NULL}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	IBusBus* bus = NULL;
	IBusBus* _tmp8_;
	IBusBus* _tmp9_;
	GList* engines = NULL;
	IBusBus* _tmp11_;
	GList* _tmp12_;
	GHashTable* map = NULL;
	GHashFunc _tmp17_;
	GEqualFunc _tmp18_;
	GHashTable* _tmp19_;
	GList* _tmp20_;
	GHashTable* _tmp39_;
	GList* _tmp40_;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, (gint*) (&argv_length1), &argv, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = get_bus ();
	bus = _tmp8_;
	_tmp9_ = bus;
	if (_tmp9_ == NULL) {
		FILE* _tmp10_;
		_tmp10_ = stderr;
		fprintf (_tmp10_, "%s", _ ("Can't connect to IBus.\n"));
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp11_ = bus;
	_tmp12_ = ibus_bus_list_engines (_tmp11_);
	engines = _tmp12_;
	if (name_only) {
		GList* _tmp13_;
		_tmp13_ = engines;
		{
			GList* engine_collection = NULL;
			GList* engine_it = NULL;
			engine_collection = _tmp13_;
			for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
				IBusEngineDesc* _tmp14_;
				IBusEngineDesc* engine = NULL;
				_tmp14_ = _g_object_ref0 ((IBusEngineDesc*) engine_it->data);
				engine = _tmp14_;
				{
					IBusEngineDesc* _tmp15_;
					const gchar* _tmp16_;
					_tmp15_ = engine;
					_tmp16_ = ibus_engine_desc_get_name (_tmp15_);
					g_print ("%s\n", _tmp16_);
					_g_object_unref0 (engine);
				}
			}
		}
		result = EXIT_SUCCESS;
		(engines == NULL) ? NULL : (engines = (_g_list_free__g_object_unref0_ (engines), NULL));
		_g_object_unref0 (bus);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp17_ = g_str_hash;
	_tmp18_ = g_str_equal;
	_tmp19_ = g_hash_table_new_full (_tmp17_, _tmp18_, _g_free0_, _engine_list_unref0_);
	map = _tmp19_;
	_tmp20_ = engines;
	{
		GList* engine_collection = NULL;
		GList* engine_it = NULL;
		engine_collection = _tmp20_;
		for (engine_it = engine_collection; engine_it != NULL; engine_it = engine_it->next) {
			IBusEngineDesc* _tmp21_;
			IBusEngineDesc* engine = NULL;
			_tmp21_ = _g_object_ref0 ((IBusEngineDesc*) engine_it->data);
			engine = _tmp21_;
			{
				EngineList* list = NULL;
				GHashTable* _tmp22_;
				IBusEngineDesc* _tmp23_;
				const gchar* _tmp24_;
				gconstpointer _tmp25_;
				EngineList* _tmp26_;
				EngineList* _tmp27_;
				EngineList* _tmp35_;
				EngineList* _tmp36_;
				IBusEngineDesc* _tmp37_;
				IBusEngineDesc* _tmp38_;
				_tmp22_ = map;
				_tmp23_ = engine;
				_tmp24_ = ibus_engine_desc_get_language (_tmp23_);
				_tmp25_ = g_hash_table_lookup (_tmp22_, _tmp24_);
				_tmp26_ = _engine_list_ref0 ((EngineList*) _tmp25_);
				list = _tmp26_;
				_tmp27_ = list;
				if (_tmp27_ == NULL) {
					EngineList* _tmp28_;
					GHashTable* _tmp29_;
					IBusEngineDesc* _tmp30_;
					const gchar* _tmp31_;
					gchar* _tmp32_;
					EngineList* _tmp33_;
					EngineList* _tmp34_;
					_tmp28_ = engine_list_new ();
					_engine_list_unref0 (list);
					list = _tmp28_;
					_tmp29_ = map;
					_tmp30_ = engine;
					_tmp31_ = ibus_engine_desc_get_language (_tmp30_);
					_tmp32_ = g_strdup (_tmp31_);
					_tmp33_ = list;
					_tmp34_ = _engine_list_ref0 (_tmp33_);
					g_hash_table_insert (_tmp29_, _tmp32_, _tmp34_);
				}
				_tmp35_ = list;
				_tmp36_ = list;
				_tmp37_ = engine;
				_tmp38_ = _g_object_ref0 (_tmp37_);
				_vala_array_add1 (&_tmp35_->data, &_tmp35_->data_length1, &_tmp35_->_data_size_, _tmp38_);
				_engine_list_unref0 (list);
				_g_object_unref0 (engine);
			}
		}
	}
	_tmp39_ = map;
	_tmp40_ = g_hash_table_get_keys (_tmp39_);
	{
		GList* language_collection = NULL;
		GList* language_it = NULL;
		language_collection = _tmp40_;
		for (language_it = language_collection; language_it != NULL; language_it = language_it->next) {
			const gchar* language = NULL;
			language = (const gchar*) language_it->data;
			{
				EngineList* list = NULL;
				GHashTable* _tmp41_;
				const gchar* _tmp42_;
				gconstpointer _tmp43_;
				EngineList* _tmp44_;
				const gchar* _tmp45_;
				gchar* _tmp46_;
				gchar* _tmp47_;
				EngineList* _tmp48_;
				IBusEngineDesc** _tmp49_;
				gint _tmp49__length1;
				_tmp41_ = map;
				_tmp42_ = language;
				_tmp43_ = g_hash_table_lookup (_tmp41_, _tmp42_);
				_tmp44_ = _engine_list_ref0 ((EngineList*) _tmp43_);
				list = _tmp44_;
				_tmp45_ = language;
				_tmp46_ = ibus_get_language_name (_tmp45_);
				_tmp47_ = _tmp46_;
				g_print (_ ("language: %s\n"), _tmp47_);
				_g_free0 (_tmp47_);
				_tmp48_ = list;
				_tmp49_ = _tmp48_->data;
				_tmp49__length1 = _tmp48_->data_length1;
				{
					IBusEngineDesc** engine_collection = NULL;
					gint engine_collection_length1 = 0;
					gint _engine_collection_size_ = 0;
					gint engine_it = 0;
					engine_collection = _tmp49_;
					engine_collection_length1 = _tmp49__length1;
					for (engine_it = 0; engine_it < engine_collection_length1; engine_it = engine_it + 1) {
						IBusEngineDesc* _tmp50_;
						IBusEngineDesc* engine = NULL;
						_tmp50_ = _g_object_ref0 (engine_collection[engine_it]);
						engine = _tmp50_;
						{
							IBusEngineDesc* _tmp51_;
							const gchar* _tmp52_;
							IBusEngineDesc* _tmp53_;
							const gchar* _tmp54_;
							_tmp51_ = engine;
							_tmp52_ = ibus_engine_desc_get_name (_tmp51_);
							_tmp53_ = engine;
							_tmp54_ = ibus_engine_desc_get_longname (_tmp53_);
							g_print ("  %s - %s\n", _tmp52_, _tmp54_);
							_g_object_unref0 (engine);
						}
					}
				}
				_engine_list_unref0 (list);
			}
		}
		(language_collection == NULL) ? NULL : (language_collection = (g_list_free (language_collection), NULL));
	}
	result = EXIT_SUCCESS;
	_g_hash_table_unref0 (map);
	(engines == NULL) ? NULL : (engines = (_g_list_free__g_object_unref0_ (engines), NULL));
	_g_object_unref0 (bus);
	_g_option_context_free0 (option);
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add3 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add4 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add5 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add8 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gint
exec_setxkbmap (IBusEngineDesc* engine)
{
	gchar* layout = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* variant = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* option = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* standard_error = NULL;
	gint exit_status = 0;
	gchar** args = NULL;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint args_length1;
	gint _args_size_;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_;
	gchar** _tmp33_;
	gint _tmp33__length1;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	g_return_val_if_fail (engine != NULL, 0);
	_tmp0_ = ibus_engine_desc_get_layout (engine);
	_tmp1_ = g_strdup (_tmp0_);
	layout = _tmp1_;
	_tmp2_ = ibus_engine_desc_get_layout_variant (engine);
	_tmp3_ = g_strdup (_tmp2_);
	variant = _tmp3_;
	_tmp4_ = ibus_engine_desc_get_layout_option (engine);
	_tmp5_ = g_strdup (_tmp4_);
	option = _tmp5_;
	standard_error = NULL;
	exit_status = 0;
	_tmp6_ = g_strdup ("setxkbmap");
	_tmp7_ = g_new0 (gchar*, 1 + 1);
	_tmp7_[0] = _tmp6_;
	args = _tmp7_;
	args_length1 = 1;
	_args_size_ = args_length1;
	_tmp10_ = layout;
	if (_tmp10_ != NULL) {
		const gchar* _tmp11_;
		_tmp11_ = layout;
		_tmp9_ = g_strcmp0 (_tmp11_, "") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp12_;
		_tmp12_ = layout;
		_tmp8_ = g_strcmp0 (_tmp12_, "default") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = g_strdup ("-layout");
		_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp13_);
		_tmp14_ = layout;
		_tmp15_ = g_strdup (_tmp14_);
		_vala_array_add3 (&args, &args_length1, &_args_size_, _tmp15_);
	}
	_tmp18_ = variant;
	if (_tmp18_ != NULL) {
		const gchar* _tmp19_;
		_tmp19_ = variant;
		_tmp17_ = g_strcmp0 (_tmp19_, "") != 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		const gchar* _tmp20_;
		_tmp20_ = variant;
		_tmp16_ = g_strcmp0 (_tmp20_, "default") != 0;
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		_tmp21_ = g_strdup ("-variant");
		_vala_array_add4 (&args, &args_length1, &_args_size_, _tmp21_);
		_tmp22_ = variant;
		_tmp23_ = g_strdup (_tmp22_);
		_vala_array_add5 (&args, &args_length1, &_args_size_, _tmp23_);
	}
	_tmp26_ = option;
	if (_tmp26_ != NULL) {
		const gchar* _tmp27_;
		_tmp27_ = option;
		_tmp25_ = g_strcmp0 (_tmp27_, "") != 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		const gchar* _tmp28_;
		_tmp28_ = option;
		_tmp24_ = g_strcmp0 (_tmp28_, "default") != 0;
	} else {
		_tmp24_ = FALSE;
	}
	if (_tmp24_) {
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp29_ = g_strdup ("-option");
		_vala_array_add6 (&args, &args_length1, &_args_size_, _tmp29_);
		_tmp30_ = g_strdup ("-option");
		_vala_array_add7 (&args, &args_length1, &_args_size_, _tmp30_);
		_tmp31_ = option;
		_tmp32_ = g_strdup (_tmp31_);
		_vala_array_add8 (&args, &args_length1, &_args_size_, _tmp32_);
	}
	_tmp33_ = args;
	_tmp33__length1 = args_length1;
	if (_tmp33__length1 == 1) {
		result = EXIT_FAILURE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	{
		gboolean _tmp34_ = FALSE;
		gchar** _tmp35_;
		gint _tmp35__length1;
		gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gboolean _tmp38_;
		_tmp35_ = args;
		_tmp35__length1 = args_length1;
		_tmp38_ = g_spawn_sync (NULL, _tmp35_, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_tmp36_, &_tmp37_, &_inner_error0_);
		_g_free0 (standard_error);
		standard_error = _tmp36_;
		exit_status = _tmp37_;
		_tmp34_ = _tmp38_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp39_ = -1;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp39_;
		}
		if (!_tmp34_) {
			const gchar* _tmp40_;
			_tmp40_ = ibus_engine_desc_get_layout (engine);
			g_warning ("main.vala:135: Switch xkb layout to %s failed.", _tmp40_);
			result = EXIT_FAILURE;
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (standard_error);
			_g_free0 (option);
			_g_free0 (variant);
			_g_free0 (layout);
			return result;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp41_;
		const gchar* _tmp42_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp41_ = e;
		_tmp42_ = _tmp41_->message;
		g_warning ("main.vala:140: Execute setxkbmap failed: %s", _tmp42_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp43_ = -1;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp43_;
	}
	if (exit_status != 0) {
		const gchar* _tmp44_ = NULL;
		const gchar* _tmp45_;
		_tmp45_ = standard_error;
		_tmp44_ = _tmp45_;
		if (_tmp44_ == NULL) {
			_tmp44_ = "(null)";
		}
		g_warning ("main.vala:145: Execute setxkbmap failed: %s", _tmp44_);
		result = EXIT_FAILURE;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_error);
		_g_free0 (option);
		_g_free0 (variant);
		_g_free0 (layout);
		return result;
	}
	result = EXIT_SUCCESS;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (standard_error);
	_g_free0 (option);
	_g_free0 (variant);
	_g_free0 (layout);
	return result;
}

gint
get_set_engine (gchar** argv,
                gint argv_length1)
{
	IBusBus* bus = NULL;
	IBusBus* _tmp0_;
	gchar* engine = NULL;
	const gchar* _tmp3_;
	IBusBus* _tmp10_;
	const gchar* _tmp11_;
	IBusEngineDesc* desc = NULL;
	IBusBus* _tmp13_;
	IBusEngineDesc* _tmp14_;
	IBusEngineDesc* _tmp15_;
	GSettings* settings = NULL;
	GSettings* _tmp17_;
	GSettings* _tmp18_;
	gint result = 0;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	engine = NULL;
	if (argv_length1 > 1) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = argv[1];
		_tmp2_ = g_strdup (_tmp1_);
		_g_free0 (engine);
		engine = _tmp2_;
	}
	_tmp3_ = engine;
	if (_tmp3_ == NULL) {
		IBusEngineDesc* desc = NULL;
		IBusBus* _tmp4_;
		IBusEngineDesc* _tmp5_;
		IBusEngineDesc* _tmp6_;
		IBusEngineDesc* _tmp8_;
		const gchar* _tmp9_;
		_tmp4_ = bus;
		_tmp5_ = ibus_bus_get_global_engine (_tmp4_);
		desc = _tmp5_;
		_tmp6_ = desc;
		if (_tmp6_ == NULL) {
			FILE* _tmp7_;
			_tmp7_ = stderr;
			fprintf (_tmp7_, "%s", _ ("No engine is set.\n"));
			result = EXIT_FAILURE;
			_g_object_unref0 (desc);
			_g_free0 (engine);
			_g_object_unref0 (bus);
			return result;
		}
		_tmp8_ = desc;
		_tmp9_ = ibus_engine_desc_get_name (_tmp8_);
		g_print ("%s\n", _tmp9_);
		result = EXIT_SUCCESS;
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp10_ = bus;
	_tmp11_ = engine;
	if (!ibus_bus_set_global_engine (_tmp10_, _tmp11_)) {
		FILE* _tmp12_;
		_tmp12_ = stderr;
		fprintf (_tmp12_, "%s", _ ("Set global engine failed.\n"));
		result = EXIT_FAILURE;
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp13_ = bus;
	_tmp14_ = ibus_bus_get_global_engine (_tmp13_);
	desc = _tmp14_;
	_tmp15_ = desc;
	if (_tmp15_ == NULL) {
		FILE* _tmp16_;
		_tmp16_ = stderr;
		fprintf (_tmp16_, "%s", _ ("Get global engine failed.\n"));
		result = EXIT_FAILURE;
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	_tmp17_ = g_settings_new (IBUS_SCHEMAS_GENERAL);
	settings = _tmp17_;
	_tmp18_ = settings;
	if (!g_settings_get_boolean (_tmp18_, "use-system-keyboard-layout")) {
		IBusEngineDesc* _tmp19_;
		_tmp19_ = desc;
		result = exec_setxkbmap (_tmp19_);
		_g_object_unref0 (settings);
		_g_object_unref0 (desc);
		_g_free0 (engine);
		_g_object_unref0 (bus);
		return result;
	}
	result = EXIT_SUCCESS;
	_g_object_unref0 (settings);
	_g_object_unref0 (desc);
	_g_free0 (engine);
	_g_object_unref0 (bus);
	return result;
}

gint
message_watch (gchar** argv,
               gint argv_length1)
{
	gint result = 0;
	result = EXIT_SUCCESS;
	return result;
}

gint
restart_daemon (gchar** argv,
                gint argv_length1)
{
	IBusBus* bus = NULL;
	IBusBus* _tmp0_;
	IBusBus* _tmp1_;
	IBusBus* _tmp3_;
	gint result = 0;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	_tmp1_ = bus;
	if (_tmp1_ == NULL) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "%s", _ ("Can't connect to IBus.\n"));
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		return result;
	}
	_tmp3_ = bus;
	ibus_bus_exit (_tmp3_, TRUE);
	result = EXIT_SUCCESS;
	_g_object_unref0 (bus);
	return result;
}

gint
exit_daemon (gchar** argv,
             gint argv_length1)
{
	IBusBus* bus = NULL;
	IBusBus* _tmp0_;
	IBusBus* _tmp1_;
	IBusBus* _tmp3_;
	gint result = 0;
	_tmp0_ = get_bus ();
	bus = _tmp0_;
	_tmp1_ = bus;
	if (_tmp1_ == NULL) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		fprintf (_tmp2_, "%s", _ ("Can't connect to IBus.\n"));
		result = EXIT_FAILURE;
		_g_object_unref0 (bus);
		return result;
	}
	_tmp3_ = bus;
	ibus_bus_exit (_tmp3_, FALSE);
	result = EXIT_SUCCESS;
	_g_object_unref0 (bus);
	return result;
}

gint
print_version (gchar** argv,
               gint argv_length1)
{
	gint result = 0;
	g_print ("IBus %s\n", PACKAGE_VERSION);
	result = EXIT_SUCCESS;
	return result;
}

gint
read_cache (gchar** argv,
            gint argv_length1)
{
	static const GOptionEntry options[3] = {{"system", (gchar) 0, 0, G_OPTION_ARG_NONE, &is_system, N_ ("Read the system registry cache."), NULL}, {"file", (gchar) 0, 0, G_OPTION_ARG_STRING, &cache_file, N_ ("Read the registry cache FILE."), "FILE"}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	IBusRegistry* registry = NULL;
	IBusRegistry* _tmp8_;
	const gchar* _tmp9_;
	GString* output = NULL;
	GString* _tmp15_;
	IBusRegistry* _tmp16_;
	GString* _tmp17_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, (gint*) (&argv_length1), &argv, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = ibus_registry_new ();
	g_object_ref_sink (_tmp8_);
	registry = _tmp8_;
	_tmp9_ = cache_file;
	if (_tmp9_ != NULL) {
		IBusRegistry* _tmp10_;
		const gchar* _tmp11_;
		_tmp10_ = registry;
		_tmp11_ = cache_file;
		if (!ibus_registry_load_cache_file (_tmp10_, _tmp11_)) {
			FILE* _tmp12_;
			_tmp12_ = stderr;
			fprintf (_tmp12_, "%s", _ ("The registry cache is invalid.\n"));
			result = EXIT_FAILURE;
			_g_object_unref0 (registry);
			_g_option_context_free0 (option);
			return result;
		}
	} else {
		IBusRegistry* _tmp13_;
		_tmp13_ = registry;
		if (!ibus_registry_load_cache (_tmp13_, !is_system)) {
			FILE* _tmp14_;
			_tmp14_ = stderr;
			fprintf (_tmp14_, "%s", _ ("The registry cache is invalid.\n"));
			result = EXIT_FAILURE;
			_g_object_unref0 (registry);
			_g_option_context_free0 (option);
			return result;
		}
	}
	_tmp15_ = g_string_new ("");
	output = _tmp15_;
	_tmp16_ = registry;
	_tmp17_ = output;
	ibus_registry_output (_tmp16_, _tmp17_, 1);
	_tmp18_ = output;
	_tmp19_ = _tmp18_->str;
	g_print ("%s\n", _tmp19_);
	result = EXIT_SUCCESS;
	_g_string_free0 (output);
	_g_object_unref0 (registry);
	_g_option_context_free0 (option);
	return result;
}

gint
write_cache (gchar** argv,
             gint argv_length1)
{
	static const GOptionEntry options[3] = {{"system", (gchar) 0, 0, G_OPTION_ARG_NONE, &is_system, N_ ("Write the system registry cache."), NULL}, {"file", (gchar) 0, 0, G_OPTION_ARG_STRING, &cache_file, N_ ("Write the registry cache FILE."), "FILE"}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	IBusRegistry* registry = NULL;
	IBusRegistry* _tmp8_;
	IBusRegistry* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp14_ = 0;
	IBusRegistry* _tmp15_;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, (gint*) (&argv_length1), &argv, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	_tmp8_ = ibus_registry_new ();
	g_object_ref_sink (_tmp8_);
	registry = _tmp8_;
	_tmp9_ = registry;
	ibus_registry_load (_tmp9_);
	_tmp10_ = cache_file;
	if (_tmp10_ != NULL) {
		gint _tmp11_ = 0;
		IBusRegistry* _tmp12_;
		const gchar* _tmp13_;
		_tmp12_ = registry;
		_tmp13_ = cache_file;
		if (ibus_registry_save_cache_file (_tmp12_, _tmp13_)) {
			_tmp11_ = EXIT_SUCCESS;
		} else {
			_tmp11_ = EXIT_FAILURE;
		}
		result = _tmp11_;
		_g_object_unref0 (registry);
		_g_option_context_free0 (option);
		return result;
	}
	_tmp15_ = registry;
	if (ibus_registry_save_cache (_tmp15_, !is_system)) {
		_tmp14_ = EXIT_SUCCESS;
	} else {
		_tmp14_ = EXIT_FAILURE;
	}
	result = _tmp14_;
	_g_object_unref0 (registry);
	_g_option_context_free0 (option);
	return result;
}

gint
print_address (gchar** argv,
               gint argv_length1)
{
	gchar* address = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	gint result = 0;
	_tmp0_ = ibus_get_address ();
	_tmp1_ = g_strdup (_tmp0_);
	address = _tmp1_;
	_tmp3_ = address;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		_tmp4_ = address;
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = "(null)";
	}
	g_print ("%s\n", _tmp2_);
	result = EXIT_SUCCESS;
	_g_free0 (address);
	return result;
}

gint
read_config_options (gchar** argv,
                     gint argv_length1)
{
	static const GOptionEntry options[2] = {{"engine-id", (gchar) 0, 0, G_OPTION_ARG_STRING, &engine_id, N_ ("Use engine schema paths instead of ibus core, " "which can be comma-separated values."), "ENGINE_ID"}, {NULL}};
	GOptionContext* option = NULL;
	GOptionContext* _tmp0_;
	GOptionContext* _tmp1_;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	_tmp0_ = g_option_context_new (NULL);
	option = _tmp0_;
	_tmp1_ = option;
	g_option_context_add_main_entries (_tmp1_, options, GETTEXT_PACKAGE);
	{
		GOptionContext* _tmp2_;
		_tmp2_ = option;
		g_option_context_parse (_tmp2_, (gint*) (&argv_length1), &argv, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp3_ = -1;
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			_g_option_context_free0 (option);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp3_;
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		FILE* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = stderr;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		fprintf (_tmp4_, "%s\n", _tmp6_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (option);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp7_ = -1;
		_g_option_context_free0 (option);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp7_;
	}
	result = EXIT_SUCCESS;
	_g_option_context_free0 (option);
	return result;
}

static gpointer
_g_settings_schema_source_ref0 (gpointer self)
{
	return self ? g_settings_schema_source_ref (self) : NULL;
}

GSList*
get_ibus_schemas (void)
{
	gchar** ids = NULL;
	gchar** _tmp0_;
	gint ids_length1;
	gint _ids_size_;
	const gchar* _tmp1_;
	GSList* ibus_schemas = NULL;
	GSettingsSchemaSource* schema_source = NULL;
	GSettingsSchemaSource* _tmp5_;
	GSettingsSchemaSource* _tmp6_;
	gchar** list_schemas = NULL;
	gchar** _tmp7_;
	gint list_schemas_length1;
	gint _list_schemas_size_;
	GSettingsSchemaSource* _tmp8_;
	gchar** _tmp9_ = NULL;
	gchar** _tmp10_;
	gint _tmp10__length1;
	GSList* _tmp28_;
	GCompareFunc _tmp29_;
	GSList* result = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	ids = _tmp0_;
	ids_length1 = 0;
	_ids_size_ = ids_length1;
	_tmp1_ = engine_id;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		gchar** _tmp3_;
		gchar** _tmp4_;
		_tmp2_ = engine_id;
		_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ",", 0);
		ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
		ids = _tmp4_;
		ids_length1 = _vala_array_length (_tmp3_);
		_ids_size_ = ids_length1;
	}
	ibus_schemas = NULL;
	_tmp5_ = g_settings_schema_source_get_default ();
	_tmp6_ = _g_settings_schema_source_ref0 (_tmp5_);
	schema_source = _tmp6_;
	_tmp7_ = g_new0 (gchar*, 0 + 1);
	list_schemas = _tmp7_;
	list_schemas_length1 = 0;
	_list_schemas_size_ = list_schemas_length1;
	_tmp8_ = schema_source;
	g_settings_schema_source_list_schemas (_tmp8_, TRUE, &_tmp9_, NULL);
	list_schemas = (_vala_array_free (list_schemas, list_schemas_length1, (GDestroyNotify) g_free), NULL);
	list_schemas = _tmp9_;
	list_schemas_length1 = -1;
	_list_schemas_size_ = list_schemas_length1;
	list_schemas_length1 = _vala_array_length (list_schemas);
	_tmp10_ = list_schemas;
	_tmp10__length1 = list_schemas_length1;
	{
		gchar** schema_collection = NULL;
		gint schema_collection_length1 = 0;
		gint _schema_collection_size_ = 0;
		gint schema_it = 0;
		schema_collection = _tmp10_;
		schema_collection_length1 = _tmp10__length1;
		for (schema_it = 0; schema_it < schema_collection_length1; schema_it = schema_it + 1) {
			gchar* _tmp11_;
			gchar* schema = NULL;
			_tmp11_ = g_strdup (schema_collection[schema_it]);
			schema = _tmp11_;
			{
				gchar** _tmp12_;
				gint _tmp12__length1;
				_tmp12_ = ids;
				_tmp12__length1 = ids_length1;
				if (_tmp12__length1 != 0) {
					gchar** _tmp13_;
					gint _tmp13__length1;
					_tmp13_ = ids;
					_tmp13__length1 = ids_length1;
					{
						gchar** id_collection = NULL;
						gint id_collection_length1 = 0;
						gint _id_collection_size_ = 0;
						gint id_it = 0;
						id_collection = _tmp13_;
						id_collection_length1 = _tmp13__length1;
						for (id_it = 0; id_it < id_collection_length1; id_it = id_it + 1) {
							const gchar* id = NULL;
							id = id_collection[id_it];
							{
								gboolean _tmp14_ = FALSE;
								const gchar* _tmp15_;
								const gchar* _tmp16_;
								_tmp15_ = id;
								_tmp16_ = schema;
								if (g_strcmp0 (_tmp15_, _tmp16_) == 0) {
									_tmp14_ = TRUE;
								} else {
									const gchar* _tmp17_;
									const gchar* _tmp18_;
									gchar* _tmp19_;
									gchar* _tmp20_;
									_tmp17_ = schema;
									_tmp18_ = id;
									_tmp19_ = g_strconcat ("org.freedesktop.ibus.engine.", _tmp18_, NULL);
									_tmp20_ = _tmp19_;
									_tmp14_ = g_str_has_prefix (_tmp17_, _tmp20_);
									_g_free0 (_tmp20_);
								}
								if (_tmp14_) {
									const gchar* _tmp21_;
									gchar* _tmp22_;
									_tmp21_ = schema;
									_tmp22_ = g_strdup (_tmp21_);
									ibus_schemas = g_slist_prepend (ibus_schemas, _tmp22_);
									break;
								}
							}
						}
					}
				} else {
					gboolean _tmp23_ = FALSE;
					const gchar* _tmp24_;
					_tmp24_ = schema;
					if (g_str_has_prefix (_tmp24_, "org.freedesktop.ibus")) {
						const gchar* _tmp25_;
						_tmp25_ = schema;
						_tmp23_ = !g_str_has_prefix (_tmp25_, "org.freedesktop.ibus.engine");
					} else {
						_tmp23_ = FALSE;
					}
					if (_tmp23_) {
						const gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp26_ = schema;
						_tmp27_ = g_strdup (_tmp26_);
						ibus_schemas = g_slist_prepend (ibus_schemas, _tmp27_);
					}
				}
				_g_free0 (schema);
			}
		}
	}
	_tmp28_ = ibus_schemas;
	if (g_slist_length (_tmp28_) == ((guint) 0)) {
		g_printerr ("Not found schemas of \"org.freedesktop.ibus\"\n");
		result = ibus_schemas;
		list_schemas = (_vala_array_free (list_schemas, list_schemas_length1, (GDestroyNotify) g_free), NULL);
		_g_settings_schema_source_unref0 (schema_source);
		ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp29_ = ((GCompareFunc) g_strcmp0);
	ibus_schemas = g_slist_sort (ibus_schemas, _tmp29_);
	result = ibus_schemas;
	list_schemas = (_vala_array_free (list_schemas, list_schemas_length1, (GDestroyNotify) g_free), NULL);
	_g_settings_schema_source_unref0 (schema_source);
	ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static inline void
_g_slist_free__g_free0_ (GSList* self)
{
	g_slist_free_full (self, (GDestroyNotify) _g_free0_);
}

gint
read_config (gchar** argv,
             gint argv_length1)
{
	GSList* ibus_schemas = NULL;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GSettingsSchemaSource* schema_source = NULL;
	GSettingsSchemaSource* _tmp2_;
	GSettingsSchemaSource* _tmp3_;
	GString* output = NULL;
	GString* _tmp4_;
	GSList* _tmp5_;
	GString* _tmp26_;
	const gchar* _tmp27_;
	gint result = 0;
	if (read_config_options (argv, (gint) argv_length1) == EXIT_FAILURE) {
		result = EXIT_FAILURE;
		return result;
	}
	_tmp0_ = get_ibus_schemas ();
	ibus_schemas = _tmp0_;
	_tmp1_ = ibus_schemas;
	if (g_slist_length (_tmp1_) == ((guint) 0)) {
		result = EXIT_FAILURE;
		(ibus_schemas == NULL) ? NULL : (ibus_schemas = (_g_slist_free__g_free0_ (ibus_schemas), NULL));
		return result;
	}
	_tmp2_ = g_settings_schema_source_get_default ();
	_tmp3_ = _g_settings_schema_source_ref0 (_tmp2_);
	schema_source = _tmp3_;
	_tmp4_ = g_string_new ("");
	output = _tmp4_;
	_tmp5_ = ibus_schemas;
	{
		GSList* schema_collection = NULL;
		GSList* schema_it = NULL;
		schema_collection = _tmp5_;
		for (schema_it = schema_collection; schema_it != NULL; schema_it = schema_it->next) {
			gchar* _tmp6_;
			gchar* schema = NULL;
			_tmp6_ = g_strdup ((const gchar*) schema_it->data);
			schema = _tmp6_;
			{
				GSettingsSchema* settings_schema = NULL;
				GSettingsSchemaSource* _tmp7_;
				const gchar* _tmp8_;
				GSettingsSchema* _tmp9_;
				GSettings* settings = NULL;
				const gchar* _tmp10_;
				GSettings* _tmp11_;
				GString* _tmp12_;
				const gchar* _tmp13_;
				GSettingsSchema* _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_;
				_tmp7_ = schema_source;
				_tmp8_ = schema;
				_tmp9_ = g_settings_schema_source_lookup (_tmp7_, _tmp8_, FALSE);
				settings_schema = _tmp9_;
				_tmp10_ = schema;
				_tmp11_ = g_settings_new (_tmp10_);
				settings = _tmp11_;
				_tmp12_ = output;
				_tmp13_ = schema;
				g_string_append_printf (_tmp12_, "SCHEMA: %s\n", _tmp13_);
				_tmp14_ = settings_schema;
				_tmp16_ = _tmp15_ = g_settings_schema_list_keys (_tmp14_);
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp16_;
					key_collection_length1 = _vala_array_length (_tmp15_);
					for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
						gchar* _tmp17_;
						gchar* key = NULL;
						_tmp17_ = g_strdup (key_collection[key_it]);
						key = _tmp17_;
						{
							GVariant* variant = NULL;
							GSettings* _tmp18_;
							const gchar* _tmp19_;
							GVariant* _tmp20_;
							GString* _tmp21_;
							const gchar* _tmp22_;
							GVariant* _tmp23_;
							gchar* _tmp24_;
							gchar* _tmp25_;
							_tmp18_ = settings;
							_tmp19_ = key;
							_tmp20_ = g_settings_get_value (_tmp18_, _tmp19_);
							variant = _tmp20_;
							_tmp21_ = output;
							_tmp22_ = key;
							_tmp23_ = variant;
							_tmp24_ = g_variant_print (_tmp23_, TRUE);
							_tmp25_ = _tmp24_;
							g_string_append_printf (_tmp21_, "  %s: %s\n", _tmp22_, _tmp25_);
							_g_free0 (_tmp25_);
							_g_variant_unref0 (variant);
							_g_free0 (key);
						}
					}
					key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_object_unref0 (settings);
				_g_settings_schema_unref0 (settings_schema);
				_g_free0 (schema);
			}
		}
	}
	_tmp26_ = output;
	_tmp27_ = _tmp26_->str;
	g_print ("%s", _tmp27_);
	result = EXIT_SUCCESS;
	_g_string_free0 (output);
	_g_settings_schema_source_unref0 (schema_source);
	(ibus_schemas == NULL) ? NULL : (ibus_schemas = (_g_slist_free__g_free0_ (ibus_schemas), NULL));
	return result;
}

gint
reset_config (gchar** argv,
              gint argv_length1)
{
	GSList* ibus_schemas = NULL;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GSettingsSchemaSource* schema_source = NULL;
	GSettingsSchemaSource* _tmp2_;
	GSettingsSchemaSource* _tmp3_;
	GSList* _tmp4_;
	gint result = 0;
	if (read_config_options (argv, (gint) argv_length1) == EXIT_FAILURE) {
		result = EXIT_FAILURE;
		return result;
	}
	_tmp0_ = get_ibus_schemas ();
	ibus_schemas = _tmp0_;
	_tmp1_ = ibus_schemas;
	if (g_slist_length (_tmp1_) == ((guint) 0)) {
		result = EXIT_FAILURE;
		(ibus_schemas == NULL) ? NULL : (ibus_schemas = (_g_slist_free__g_free0_ (ibus_schemas), NULL));
		return result;
	}
	g_print ("%s\n", _ ("Resetting…"));
	_tmp2_ = g_settings_schema_source_get_default ();
	_tmp3_ = _g_settings_schema_source_ref0 (_tmp2_);
	schema_source = _tmp3_;
	_tmp4_ = ibus_schemas;
	{
		GSList* schema_collection = NULL;
		GSList* schema_it = NULL;
		schema_collection = _tmp4_;
		for (schema_it = schema_collection; schema_it != NULL; schema_it = schema_it->next) {
			gchar* _tmp5_;
			gchar* schema = NULL;
			_tmp5_ = g_strdup ((const gchar*) schema_it->data);
			schema = _tmp5_;
			{
				GSettingsSchema* settings_schema = NULL;
				GSettingsSchemaSource* _tmp6_;
				const gchar* _tmp7_;
				GSettingsSchema* _tmp8_;
				GSettings* settings = NULL;
				const gchar* _tmp9_;
				GSettings* _tmp10_;
				const gchar* _tmp11_;
				GSettingsSchema* _tmp12_;
				gchar** _tmp13_;
				gchar** _tmp14_;
				_tmp6_ = schema_source;
				_tmp7_ = schema;
				_tmp8_ = g_settings_schema_source_lookup (_tmp6_, _tmp7_, FALSE);
				settings_schema = _tmp8_;
				_tmp9_ = schema;
				_tmp10_ = g_settings_new (_tmp9_);
				settings = _tmp10_;
				_tmp11_ = schema;
				g_print ("SCHEMA: %s\n", _tmp11_);
				_tmp12_ = settings_schema;
				_tmp14_ = _tmp13_ = g_settings_schema_list_keys (_tmp12_);
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
					key_collection = _tmp14_;
					key_collection_length1 = _vala_array_length (_tmp13_);
					for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
						gchar* _tmp15_;
						gchar* key = NULL;
						_tmp15_ = g_strdup (key_collection[key_it]);
						key = _tmp15_;
						{
							const gchar* _tmp16_;
							GSettings* _tmp17_;
							const gchar* _tmp18_;
							_tmp16_ = key;
							g_print ("  %s\n", _tmp16_);
							_tmp17_ = settings;
							_tmp18_ = key;
							g_settings_reset (_tmp17_, _tmp18_);
							_g_free0 (key);
						}
					}
					key_collection = (_vala_array_free (key_collection, key_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_object_unref0 (settings);
				_g_settings_schema_unref0 (settings_schema);
				_g_free0 (schema);
			}
		}
	}
	g_settings_sync ();
	g_print ("%s\n", _ ("Done"));
	result = EXIT_SUCCESS;
	_g_settings_schema_source_unref0 (schema_source);
	(ibus_schemas == NULL) ? NULL : (ibus_schemas = (_g_slist_free__g_free0_ (ibus_schemas), NULL));
	return result;
}

gint
emoji_dialog (gchar** argv,
              gint argv_length1)
{
	gchar* cmd = NULL;
	gchar* _tmp0_;
	GFile* file = NULL;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** env = NULL;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint env_length1;
	gint _env_size_;
	GError* _inner_error0_ = NULL;
	gint result = 0;
	_tmp0_ = g_strdup (LIBEXECDIR "/ibus-ui-emojier");
	cmd = _tmp0_;
	_tmp1_ = cmd;
	_tmp2_ = g_file_new_for_path (_tmp1_);
	file = _tmp2_;
	_tmp3_ = file;
	if (!g_file_query_exists (_tmp3_, NULL)) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("../ui/gtk3/ibus-ui-emojier");
		_g_free0 (cmd);
		cmd = _tmp4_;
	}
	_tmp5_ = cmd;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (argv[0]);
	argv[0] = _tmp6_;
	_tmp8_ = _tmp7_ = g_get_environ ();
	env = _tmp8_;
	env_length1 = _vala_array_length (_tmp7_);
	_env_size_ = env_length1;
	{
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp9_ = env;
		_tmp9__length1 = env_length1;
		g_spawn_async (NULL, argv, _tmp9_, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp10_ = -1;
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (file);
			_g_free0 (cmd);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		FILE* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = stderr;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		fprintf (_tmp11_, "%s\n", _tmp13_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (file);
		_g_free0 (cmd);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp14_ = -1;
		env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (file);
		_g_free0 (cmd);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp14_;
	}
	result = EXIT_SUCCESS;
	env = (_vala_array_free (env, env_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (file);
	_g_free0 (cmd);
	return result;
}

gint
print_help (gchar** argv,
            gint argv_length1)
{
	FILE* _tmp0_;
	gint result = 0;
	_tmp0_ = stdout;
	print_usage (_tmp0_);
	result = EXIT_SUCCESS;
	return result;
}

CommandEntry*
command_entry_dup (const CommandEntry* self)
{
	CommandEntry* dup;
	dup = g_new0 (CommandEntry, 1);
	memcpy (dup, self, sizeof (CommandEntry));
	return dup;
}

void
command_entry_free (CommandEntry* self)
{
	g_free (self);
}

static GType
command_entry_get_type_once (void)
{
	GType command_entry_type_id;
	command_entry_type_id = g_boxed_type_register_static ("CommandEntry", (GBoxedCopyFunc) command_entry_dup, (GBoxedFreeFunc) command_entry_free);
	return command_entry_type_id;
}

GType
command_entry_get_type (void)
{
	static volatile gsize command_entry_type_id__volatile = 0;
	if (g_once_init_enter (&command_entry_type_id__volatile)) {
		GType command_entry_type_id;
		command_entry_type_id = command_entry_get_type_once ();
		g_once_init_leave (&command_entry_type_id__volatile, command_entry_type_id);
	}
	return command_entry_type_id__volatile;
}

static gint
_get_set_engine_entry_func (gchar** argv,
                            gint argv_length1,
                            gpointer self)
{
	gint result;
	result = get_set_engine (argv, argv_length1);
	return result;
}

static gint
_exit_daemon_entry_func (gchar** argv,
                         gint argv_length1,
                         gpointer self)
{
	gint result;
	result = exit_daemon (argv, argv_length1);
	return result;
}

static gint
_list_engine_entry_func (gchar** argv,
                         gint argv_length1,
                         gpointer self)
{
	gint result;
	result = list_engine (argv, argv_length1);
	return result;
}

static gint
_message_watch_entry_func (gchar** argv,
                           gint argv_length1,
                           gpointer self)
{
	gint result;
	result = message_watch (argv, argv_length1);
	return result;
}

static gint
_restart_daemon_entry_func (gchar** argv,
                            gint argv_length1,
                            gpointer self)
{
	gint result;
	result = restart_daemon (argv, argv_length1);
	return result;
}

static gint
_print_version_entry_func (gchar** argv,
                           gint argv_length1,
                           gpointer self)
{
	gint result;
	result = print_version (argv, argv_length1);
	return result;
}

static gint
_read_cache_entry_func (gchar** argv,
                        gint argv_length1,
                        gpointer self)
{
	gint result;
	result = read_cache (argv, argv_length1);
	return result;
}

static gint
_write_cache_entry_func (gchar** argv,
                         gint argv_length1,
                         gpointer self)
{
	gint result;
	result = write_cache (argv, argv_length1);
	return result;
}

static gint
_print_address_entry_func (gchar** argv,
                           gint argv_length1,
                           gpointer self)
{
	gint result;
	result = print_address (argv, argv_length1);
	return result;
}

static gint
_read_config_entry_func (gchar** argv,
                         gint argv_length1,
                         gpointer self)
{
	gint result;
	result = read_config (argv, argv_length1);
	return result;
}

static gint
_reset_config_entry_func (gchar** argv,
                          gint argv_length1,
                          gpointer self)
{
	gint result;
	result = reset_config (argv, argv_length1);
	return result;
}

static gint
_emoji_dialog_entry_func (gchar** argv,
                          gint argv_length1,
                          gpointer self)
{
	gint result;
	result = emoji_dialog (argv, argv_length1);
	return result;
}

static gint
_print_help_entry_func (gchar** argv,
                        gint argv_length1,
                        gpointer self)
{
	gint result;
	result = print_help (argv, argv_length1);
	return result;
}

void
print_usage (FILE* stream)
{
	const gchar* _tmp0_;
	g_return_if_fail (stream != NULL);
	_tmp0_ = program_name;
	fprintf (stream, _ ("Usage: %s COMMAND [OPTION...]\n\n"), _tmp0_);
	fprintf (stream, "%s", _ ("Commands:\n"));
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				CommandEntry _tmp3_;
				const gchar* _tmp4_;
				CommandEntry _tmp5_;
				const gchar* _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < G_N_ELEMENTS (commands))) {
					break;
				}
				_tmp3_ = commands[i];
				_tmp4_ = _tmp3_.name;
				_tmp5_ = commands[i];
				_tmp6_ = _tmp5_.description;
				fprintf (stream, "  %-12s    %s\n", _tmp4_, g_dgettext (NULL, _tmp6_));
			}
		}
	}
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gint length)
{
	if (length >= 0) {
		gchar** result;
		gint i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gint
_vala_main (gchar** argv,
            gint argv_length1)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** new_argv = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gint new_argv_length1;
	gint _new_argv_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	const gchar* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	FILE* _tmp17_;
	const gchar* _tmp18_;
	FILE* _tmp19_;
	gint result = 0;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	ibus_init ();
	_tmp0_ = argv[0];
	_tmp1_ = g_path_get_basename (_tmp0_);
	_g_free0 (program_name);
	program_name = _tmp1_;
	if (argv_length1 < 2) {
		FILE* _tmp2_;
		_tmp2_ = stderr;
		print_usage (_tmp2_);
		result = EXIT_FAILURE;
		return result;
	}
	_tmp3_ = ((argv + 1) != NULL) ? _vala_array_dup1 (argv + 1, argv_length1 - 1) : ((gpointer) (argv + 1));
	_tmp3__length1 = argv_length1 - 1;
	new_argv = _tmp3_;
	new_argv_length1 = _tmp3__length1;
	_new_argv_size_ = new_argv_length1;
	_tmp4_ = new_argv;
	_tmp4__length1 = new_argv_length1;
	_tmp5_ = program_name;
	_tmp6_ = new_argv;
	_tmp6__length1 = new_argv_length1;
	_tmp7_ = _tmp6_[0];
	_tmp8_ = g_strdup_printf ("%s %s", _tmp5_, _tmp7_);
	_g_free0 (_tmp4_[0]);
	_tmp4_[0] = _tmp8_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				CommandEntry _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				if (!_tmp9_) {
					gint _tmp10_;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				if (!(i < G_N_ELEMENTS (commands))) {
					break;
				}
				_tmp11_ = commands[i];
				_tmp12_ = _tmp11_.name;
				_tmp13_ = argv[1];
				if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
					CommandEntry _tmp14_;
					EntryFunc _tmp15_;
					gpointer _tmp15__target;
					gchar** _tmp16_;
					gint _tmp16__length1;
					_tmp14_ = commands[i];
					_tmp15_ = _tmp14_.entry;
					_tmp15__target = _tmp14_.entry_target;
					_tmp16_ = new_argv;
					_tmp16__length1 = new_argv_length1;
					result = _tmp15_ (_tmp16_, (gint) _tmp16__length1, _tmp15__target);
					new_argv = (_vala_array_free (new_argv, new_argv_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
			}
		}
	}
	_tmp17_ = stderr;
	_tmp18_ = argv[1];
	fprintf (_tmp17_, _ ("%s is unknown command!\n"), _tmp18_);
	_tmp19_ = stderr;
	print_usage (_tmp19_);
	result = EXIT_FAILURE;
	new_argv = (_vala_array_free (new_argv, new_argv_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return _vala_main (argv, argc);
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gint i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

