/* propertypanel.c generated by valac 0.22.0, the Vala compiler
 * generated from propertypanel.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2013 Red Hat, Inc.
 * Copyright(c) 2013 Peng Huang <shawn.p.huang@gmail.com>
 * Copyright(c) 2013 Takao Fujiwara <takao.fujiwara1@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301
 * USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <ibus.h>
#include <gdk/gdk.h>
#include <string.h>
#include <cairo.h>
#include <stdlib.h>


#define TYPE_PANEL_SHOW (panel_show_get_type ())

#define TYPE_PROPERTY_PANEL (property_panel_get_type ())
#define PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROPERTY_PANEL, PropertyPanel))
#define PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROPERTY_PANEL, PropertyPanelClass))
#define IS_PROPERTY_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROPERTY_PANEL))
#define IS_PROPERTY_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROPERTY_PANEL))
#define PROPERTY_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROPERTY_PANEL, PropertyPanelClass))

typedef struct _PropertyPanel PropertyPanel;
typedef struct _PropertyPanelClass PropertyPanelClass;
typedef struct _PropertyPanelPrivate PropertyPanelPrivate;

#define TYPE_IPROP_TOOL_ITEM (iprop_tool_item_get_type ())
#define IPROP_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPROP_TOOL_ITEM, IPropToolItem))
#define IS_IPROP_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPROP_TOOL_ITEM))
#define IPROP_TOOL_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPROP_TOOL_ITEM, IPropToolItemIface))

typedef struct _IPropToolItem IPropToolItem;
typedef struct _IPropToolItemIface IPropToolItemIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_HANDLE (handle_get_type ())
#define HANDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HANDLE, Handle))
#define HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HANDLE, HandleClass))
#define IS_HANDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HANDLE))
#define IS_HANDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HANDLE))
#define HANDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HANDLE, HandleClass))

typedef struct _Handle Handle;
typedef struct _HandleClass HandleClass;

#define TYPE_PROP_TOOL_BUTTON (prop_tool_button_get_type ())
#define PROP_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_TOOL_BUTTON, PropToolButton))
#define PROP_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_TOOL_BUTTON, PropToolButtonClass))
#define IS_PROP_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_TOOL_BUTTON))
#define IS_PROP_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_TOOL_BUTTON))
#define PROP_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_TOOL_BUTTON, PropToolButtonClass))

typedef struct _PropToolButton PropToolButton;
typedef struct _PropToolButtonClass PropToolButtonClass;

#define TYPE_PROP_TOGGLE_TOOL_BUTTON (prop_toggle_tool_button_get_type ())
#define PROP_TOGGLE_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton))
#define PROP_TOGGLE_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButtonClass))
#define IS_PROP_TOGGLE_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_TOGGLE_TOOL_BUTTON))
#define IS_PROP_TOGGLE_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_TOGGLE_TOOL_BUTTON))
#define PROP_TOGGLE_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButtonClass))

typedef struct _PropToggleToolButton PropToggleToolButton;
typedef struct _PropToggleToolButtonClass PropToggleToolButtonClass;

#define TYPE_PROP_MENU_TOOL_BUTTON (prop_menu_tool_button_get_type ())
#define PROP_MENU_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButton))
#define PROP_MENU_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButtonClass))
#define IS_PROP_MENU_TOOL_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_MENU_TOOL_BUTTON))
#define IS_PROP_MENU_TOOL_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_MENU_TOOL_BUTTON))
#define PROP_MENU_TOOL_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButtonClass))

typedef struct _PropMenuToolButton PropMenuToolButton;
typedef struct _PropMenuToolButtonClass PropMenuToolButtonClass;

#define TYPE_PROP_SEPARATOR_TOOL_ITEM (prop_separator_tool_item_get_type ())
#define PROP_SEPARATOR_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_SEPARATOR_TOOL_ITEM, PropSeparatorToolItem))
#define PROP_SEPARATOR_TOOL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_SEPARATOR_TOOL_ITEM, PropSeparatorToolItemClass))
#define IS_PROP_SEPARATOR_TOOL_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_SEPARATOR_TOOL_ITEM))
#define IS_PROP_SEPARATOR_TOOL_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_SEPARATOR_TOOL_ITEM))
#define PROP_SEPARATOR_TOOL_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_SEPARATOR_TOOL_ITEM, PropSeparatorToolItemClass))

typedef struct _PropSeparatorToolItem PropSeparatorToolItem;
typedef struct _PropSeparatorToolItemClass PropSeparatorToolItemClass;

#define TYPE_PROP_MENU (prop_menu_get_type ())
#define PROP_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_MENU, PropMenu))
#define PROP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_MENU, PropMenuClass))
#define IS_PROP_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_MENU))
#define IS_PROP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_MENU))
#define PROP_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_MENU, PropMenuClass))

typedef struct _PropMenu PropMenu;
typedef struct _PropMenuClass PropMenuClass;
typedef struct _PropMenuPrivate PropMenuPrivate;

#define TYPE_IPROP_ITEM (iprop_item_get_type ())
#define IPROP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPROP_ITEM, IPropItem))
#define IS_IPROP_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPROP_ITEM))
#define IPROP_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPROP_ITEM, IPropItemIface))

typedef struct _IPropItem IPropItem;
typedef struct _IPropItemIface IPropItemIface;

#define TYPE_PROP_CHECK_MENU_ITEM (prop_check_menu_item_get_type ())
#define PROP_CHECK_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_CHECK_MENU_ITEM, PropCheckMenuItem))
#define PROP_CHECK_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_CHECK_MENU_ITEM, PropCheckMenuItemClass))
#define IS_PROP_CHECK_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_CHECK_MENU_ITEM))
#define IS_PROP_CHECK_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_CHECK_MENU_ITEM))
#define PROP_CHECK_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_CHECK_MENU_ITEM, PropCheckMenuItemClass))

typedef struct _PropCheckMenuItem PropCheckMenuItem;
typedef struct _PropCheckMenuItemClass PropCheckMenuItemClass;

#define TYPE_PROP_RADIO_MENU_ITEM (prop_radio_menu_item_get_type ())
#define PROP_RADIO_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_RADIO_MENU_ITEM, PropRadioMenuItem))
#define PROP_RADIO_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_RADIO_MENU_ITEM, PropRadioMenuItemClass))
#define IS_PROP_RADIO_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_RADIO_MENU_ITEM))
#define IS_PROP_RADIO_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_RADIO_MENU_ITEM))
#define PROP_RADIO_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_RADIO_MENU_ITEM, PropRadioMenuItemClass))

typedef struct _PropRadioMenuItem PropRadioMenuItem;
typedef struct _PropRadioMenuItemClass PropRadioMenuItemClass;

#define TYPE_PROP_IMAGE_MENU_ITEM (prop_image_menu_item_get_type ())
#define PROP_IMAGE_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_IMAGE_MENU_ITEM, PropImageMenuItem))
#define PROP_IMAGE_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_IMAGE_MENU_ITEM, PropImageMenuItemClass))
#define IS_PROP_IMAGE_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_IMAGE_MENU_ITEM))
#define IS_PROP_IMAGE_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_IMAGE_MENU_ITEM))
#define PROP_IMAGE_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_IMAGE_MENU_ITEM, PropImageMenuItemClass))

typedef struct _PropImageMenuItem PropImageMenuItem;
typedef struct _PropImageMenuItemClass PropImageMenuItemClass;

#define TYPE_PROP_SEPARATOR_MENU_ITEM (prop_separator_menu_item_get_type ())
#define PROP_SEPARATOR_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROP_SEPARATOR_MENU_ITEM, PropSeparatorMenuItem))
#define PROP_SEPARATOR_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROP_SEPARATOR_MENU_ITEM, PropSeparatorMenuItemClass))
#define IS_PROP_SEPARATOR_MENU_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROP_SEPARATOR_MENU_ITEM))
#define IS_PROP_SEPARATOR_MENU_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROP_SEPARATOR_MENU_ITEM))
#define PROP_SEPARATOR_MENU_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROP_SEPARATOR_MENU_ITEM, PropSeparatorMenuItemClass))

typedef struct _PropSeparatorMenuItem PropSeparatorMenuItem;
typedef struct _PropSeparatorMenuItemClass PropSeparatorMenuItemClass;
typedef struct _PropToolButtonPrivate PropToolButtonPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
typedef struct _PropToggleToolButtonPrivate PropToggleToolButtonPrivate;
typedef struct _PropMenuToolButtonPrivate PropMenuToolButtonPrivate;
typedef struct _PropSeparatorToolItemPrivate PropSeparatorToolItemPrivate;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	PANEL_SHOW_DO_NOT_SHOW,
	PANEL_SHOW_AUTO_HIDE,
	PANEL_SHOW_ALWAYS
} PanelShow;

struct _PropertyPanel {
	GtkBox parent_instance;
	PropertyPanelPrivate * priv;
};

struct _PropertyPanelClass {
	GtkBoxClass parent_class;
};

struct _IPropToolItemIface {
	GTypeInterface parent_iface;
	void (*update_property) (IPropToolItem* self, IBusProperty* prop);
};

struct _PropertyPanelPrivate {
	GtkWindow* m_toplevel;
	IBusPropList* m_props;
	IPropToolItem** m_items;
	gint m_items_length1;
	gint _m_items_size_;
	GdkRectangle m_cursor_location;
	gint m_show;
	guint m_auto_hide_timeout;
	guint m_auto_hide_timeout_id;
};

struct _PropMenu {
	GtkMenu parent_instance;
	PropMenuPrivate * priv;
};

struct _PropMenuClass {
	GtkMenuClass parent_class;
};

struct _IPropItemIface {
	GTypeInterface parent_iface;
	void (*update_property) (IPropItem* self, IBusProperty* prop);
};

struct _PropMenuPrivate {
	GtkWidget* m_parent_button;
	IPropItem** m_items;
	gint m_items_length1;
	gint _m_items_size_;
};

struct _PropToolButton {
	GtkToolButton parent_instance;
	PropToolButtonPrivate * priv;
};

struct _PropToolButtonClass {
	GtkToolButtonClass parent_class;
};

struct _PropToolButtonPrivate {
	IBusProperty* m_prop;
};

struct _PropToggleToolButton {
	GtkToggleToolButton parent_instance;
	PropToggleToolButtonPrivate * priv;
};

struct _PropToggleToolButtonClass {
	GtkToggleToolButtonClass parent_class;
};

struct _PropToggleToolButtonPrivate {
	IBusProperty* m_prop;
};

struct _PropMenuToolButton {
	PropToggleToolButton parent_instance;
	PropMenuToolButtonPrivate * priv;
};

struct _PropMenuToolButtonClass {
	PropToggleToolButtonClass parent_class;
};

struct _PropMenuToolButtonPrivate {
	PropMenu* m_menu;
};

struct _PropSeparatorToolItem {
	GtkSeparatorToolItem parent_instance;
	PropSeparatorToolItemPrivate * priv;
};

struct _PropSeparatorToolItemClass {
	GtkSeparatorToolItemClass parent_class;
};


static gpointer property_panel_parent_class = NULL;
static gpointer prop_menu_parent_class = NULL;
static IPropToolItemIface* prop_menu_iprop_tool_item_parent_iface = NULL;
static gpointer prop_tool_button_parent_class = NULL;
static IPropToolItemIface* prop_tool_button_iprop_tool_item_parent_iface = NULL;
static gpointer prop_toggle_tool_button_parent_class = NULL;
static IPropToolItemIface* prop_toggle_tool_button_iprop_tool_item_parent_iface = NULL;
static gpointer prop_menu_tool_button_parent_class = NULL;
static IPropToolItemIface* prop_menu_tool_button_iprop_tool_item_parent_iface = NULL;
static gpointer prop_separator_tool_item_parent_class = NULL;
static IPropToolItemIface* prop_separator_tool_item_iprop_tool_item_parent_iface = NULL;

GType panel_show_get_type (void) G_GNUC_CONST;
GType property_panel_get_type (void) G_GNUC_CONST;
GType iprop_tool_item_get_type (void) G_GNUC_CONST;
#define PROPERTY_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROPERTY_PANEL, PropertyPanelPrivate))
enum  {
	PROPERTY_PANEL_DUMMY_PROPERTY
};
PropertyPanel* property_panel_new (void);
PropertyPanel* property_panel_construct (GType object_type);
GType handle_get_type (void) G_GNUC_CONST;
Handle* handle_new (void);
Handle* handle_construct (GType object_type);
void property_panel_set_properties (PropertyPanel* self, IBusPropList* props);
static void property_panel_create_menu_items (PropertyPanel* self);
void property_panel_update_property (PropertyPanel* self, IBusProperty* prop);
void iprop_tool_item_update_property (IPropToolItem* self, IBusProperty* prop);
static void property_panel_show_with_auto_hide_timer (PropertyPanel* self);
void property_panel_set_cursor_location (PropertyPanel* self, gint x, gint y, gint width, gint height);
static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t* s1, const cairo_rectangle_int_t* s2);
static void property_panel_hide_if_necessary (PropertyPanel* self);
static void property_panel_adjust_window_position (PropertyPanel* self);
void property_panel_set_preedit_text (PropertyPanel* self, IBusText* text, guint cursor);
void property_panel_set_auxiliary_text (PropertyPanel* self, IBusText* text);
void property_panel_set_lookup_table (PropertyPanel* self, IBusLookupTable* table);
void property_panel_show (PropertyPanel* self);
void property_panel_hide (PropertyPanel* self);
void property_panel_focus_in (PropertyPanel* self);
void property_panel_set_show (PropertyPanel* self, gint _show);
void property_panel_set_auto_hide_timeout (PropertyPanel* self, guint timeout);
static void property_panel_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width);
static void property_panel_real_get_preferred_height (GtkWidget* base, gint* minimum_width, gint* natural_width);
PropToolButton* prop_tool_button_new (IBusProperty* prop);
PropToolButton* prop_tool_button_construct (GType object_type, IBusProperty* prop);
GType prop_tool_button_get_type (void) G_GNUC_CONST;
PropToggleToolButton* prop_toggle_tool_button_new (IBusProperty* prop);
PropToggleToolButton* prop_toggle_tool_button_construct (GType object_type, IBusProperty* prop);
GType prop_toggle_tool_button_get_type (void) G_GNUC_CONST;
PropMenuToolButton* prop_menu_tool_button_new (IBusProperty* prop);
PropMenuToolButton* prop_menu_tool_button_construct (GType object_type, IBusProperty* prop);
GType prop_menu_tool_button_get_type (void) G_GNUC_CONST;
PropSeparatorToolItem* prop_separator_tool_item_new (IBusProperty* prop);
PropSeparatorToolItem* prop_separator_tool_item_construct (GType object_type, IBusProperty* prop);
GType prop_separator_tool_item_get_type (void) G_GNUC_CONST;
static void _vala_array_add25 (IPropToolItem*** array, int* length, int* size, IPropToolItem* value);
static void ____lambda21_ (PropertyPanel* self, IPropToolItem* w, const gchar* k, gint s);
static void _____lambda21__iprop_tool_item_property_activate (IPropToolItem* _sender, const gchar* key, gint state, gpointer self);
static void property_panel_move (PropertyPanel* self, gint x, gint y);
static gboolean __lambda22_ (PropertyPanel* self);
static gboolean ___lambda22__gsource_func (gpointer self);
static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void property_panel_finalize (GObject* obj);
GType prop_menu_get_type (void) G_GNUC_CONST;
GType iprop_item_get_type (void) G_GNUC_CONST;
#define PROP_MENU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROP_MENU, PropMenuPrivate))
enum  {
	PROP_MENU_DUMMY_PROPERTY
};
PropMenu* prop_menu_new (IBusProperty* prop);
PropMenu* prop_menu_construct (GType object_type, IBusProperty* prop);
static void prop_menu_create_items (PropMenu* self, IBusPropList* props);
static void prop_menu_real_update_property (IPropToolItem* base, IBusProperty* prop);
void iprop_item_update_property (IPropItem* self, IBusProperty* prop);
void prop_menu_popup (PropMenu* self, guint button, guint32 activate_time, GtkWidget* widget);
static void prop_menu_menu_position (PropMenu* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in);
static void _prop_menu_menu_position_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self);
static void prop_menu_real_destroy (GtkWidget* base);
GType prop_check_menu_item_get_type (void) G_GNUC_CONST;
GType prop_radio_menu_item_get_type (void) G_GNUC_CONST;
PropImageMenuItem* prop_image_menu_item_new (IBusProperty* property);
PropImageMenuItem* prop_image_menu_item_construct (GType object_type, IBusProperty* property);
GType prop_image_menu_item_get_type (void) G_GNUC_CONST;
PropCheckMenuItem* prop_check_menu_item_new (IBusProperty* property);
PropCheckMenuItem* prop_check_menu_item_construct (GType object_type, IBusProperty* property);
PropRadioMenuItem* prop_radio_menu_item_new (IBusProperty* property, PropRadioMenuItem* group_source);
PropRadioMenuItem* prop_radio_menu_item_construct (GType object_type, IBusProperty* property, PropRadioMenuItem* group_source);
PropSeparatorMenuItem* prop_separator_menu_item_new (IBusProperty* property);
PropSeparatorMenuItem* prop_separator_menu_item_construct (GType object_type, IBusProperty* property);
GType prop_separator_menu_item_get_type (void) G_GNUC_CONST;
static void ____lambda18_ (PropMenu* self, IPropItem* w, const gchar* k, gint s);
static void _____lambda18__iprop_item_property_activate (IPropItem* _sender, const gchar* key, gint state, gpointer self);
static void _vala_array_add26 (IPropItem*** array, int* length, int* size, IPropItem* value);
static void prop_menu_finalize (GObject* obj);
#define PROP_TOOL_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROP_TOOL_BUTTON, PropToolButtonPrivate))
enum  {
	PROP_TOOL_BUTTON_DUMMY_PROPERTY
};
static void prop_tool_button_sync (PropToolButton* self);
static void prop_tool_button_real_update_property (IPropToolItem* base, IBusProperty* prop);
void prop_tool_button_set_icon_name (PropToolButton* self, const gchar* icon_name);
static void prop_tool_button_real_clicked (GtkToolButton* base);
GType icon_widget_get_type (void) G_GNUC_CONST;
IconWidget* icon_widget_new (const gchar* icon_name_or_path, GtkIconSize size);
IconWidget* icon_widget_construct (GType object_type, const gchar* icon_name_or_path, GtkIconSize size);
static void prop_tool_button_finalize (GObject* obj);
#define PROP_TOGGLE_TOOL_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButtonPrivate))
enum  {
	PROP_TOGGLE_TOOL_BUTTON_DUMMY_PROPERTY
};
static void prop_toggle_tool_button_sync (PropToggleToolButton* self);
void prop_toggle_tool_button_set_property (PropToggleToolButton* self, IBusProperty* prop);
static void prop_toggle_tool_button_real_update_property (IPropToolItem* base, IBusProperty* prop);
void prop_toggle_tool_button_set_icon_name (PropToggleToolButton* self, const gchar* icon_name);
static void prop_toggle_tool_button_real_toggled (GtkToggleToolButton* base);
static void prop_toggle_tool_button_finalize (GObject* obj);
#define PROP_MENU_TOOL_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButtonPrivate))
enum  {
	PROP_MENU_TOOL_BUTTON_DUMMY_PROPERTY
};
static void __lambda19_ (PropMenuToolButton* self, GtkMenuShell* m);
static void ___lambda19__gtk_menu_shell_deactivate (GtkMenuShell* _sender, gpointer self);
static void __lambda20_ (PropMenuToolButton* self, IPropToolItem* w, const gchar* k, gint s);
static void ___lambda20__iprop_tool_item_property_activate (IPropToolItem* _sender, const gchar* key, gint state, gpointer self);
static void prop_menu_tool_button_real_update_property (IPropToolItem* base, IBusProperty* prop);
static void prop_menu_tool_button_real_toggled (GtkToggleToolButton* base);
static void prop_menu_tool_button_real_destroy (GtkWidget* base);
static void prop_menu_tool_button_finalize (GObject* obj);
enum  {
	PROP_SEPARATOR_TOOL_ITEM_DUMMY_PROPERTY
};
static void prop_separator_tool_item_real_update_property (IPropToolItem* base, IBusProperty* prop);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType panel_show_get_type (void) {
	static volatile gsize panel_show_type_id__volatile = 0;
	if (g_once_init_enter (&panel_show_type_id__volatile)) {
		static const GEnumValue values[] = {{PANEL_SHOW_DO_NOT_SHOW, "PANEL_SHOW_DO_NOT_SHOW", "do-not-show"}, {PANEL_SHOW_AUTO_HIDE, "PANEL_SHOW_AUTO_HIDE", "auto-hide"}, {PANEL_SHOW_ALWAYS, "PANEL_SHOW_ALWAYS", "always"}, {0, NULL, NULL}};
		GType panel_show_type_id;
		panel_show_type_id = g_enum_register_static ("PanelShow", values);
		g_once_init_leave (&panel_show_type_id__volatile, panel_show_type_id);
	}
	return panel_show_type_id__volatile;
}


PropertyPanel* property_panel_construct (GType object_type) {
	PropertyPanel * self = NULL;
	GtkWindow* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	Handle* handle = NULL;
	Handle* _tmp2_ = NULL;
	GtkWindow* _tmp3_ = NULL;
	self = (PropertyPanel*) g_object_new (object_type, "orientation", GTK_ORIENTATION_HORIZONTAL, "spacing", 0, NULL);
	gtk_widget_set_visible ((GtkWidget*) self, TRUE);
	_tmp0_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_POPUP);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->m_toplevel);
	self->priv->m_toplevel = _tmp0_;
	_tmp1_ = self->priv->m_toplevel;
	gtk_widget_add_events ((GtkWidget*) _tmp1_, (gint) GDK_BUTTON_PRESS_MASK);
	_tmp2_ = handle_new ();
	g_object_ref_sink (_tmp2_);
	handle = _tmp2_;
	gtk_widget_set_visible ((GtkWidget*) handle, TRUE);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) handle, FALSE, FALSE, (guint) 0);
	_tmp3_ = self->priv->m_toplevel;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) self);
	_g_object_unref0 (handle);
	return self;
}


PropertyPanel* property_panel_new (void) {
	return property_panel_construct (TYPE_PROPERTY_PANEL);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void property_panel_set_properties (PropertyPanel* self, IBusPropList* props) {
	IPropToolItem** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	IPropToolItem** _tmp3_ = NULL;
	IBusPropList* _tmp4_ = NULL;
	IBusPropList* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (props != NULL);
	_tmp0_ = self->priv->m_items;
	_tmp0__length1 = self->priv->m_items_length1;
	{
		IPropToolItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp0_;
		item_collection_length1 = _tmp0__length1;
		for (item_it = 0; item_it < _tmp0__length1; item_it = item_it + 1) {
			IPropToolItem* _tmp1_ = NULL;
			IPropToolItem* item = NULL;
			_tmp1_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp1_;
			{
				IPropToolItem* _tmp2_ = NULL;
				_tmp2_ = item;
				gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp2_) : NULL);
				_g_object_unref0 (item);
			}
		}
	}
	_tmp3_ = g_new0 (IPropToolItem*, 0 + 1);
	self->priv->m_items = (_vala_array_free (self->priv->m_items, self->priv->m_items_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_items = _tmp3_;
	self->priv->m_items_length1 = 0;
	self->priv->_m_items_size_ = self->priv->m_items_length1;
	_tmp4_ = props;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->m_props);
	self->priv->m_props = _tmp5_;
	property_panel_create_menu_items (self);
}


void property_panel_update_property (PropertyPanel* self, IBusProperty* prop) {
	IBusProperty* _tmp0_ = NULL;
	IBusProperty* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	IBusPropList* _tmp3_ = NULL;
	IPropToolItem** _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop;
	_vala_assert (_tmp0_ != NULL, "prop != null");
	_tmp1_ = prop;
	_tmp2_ = ibus_property_get_key (_tmp1_);
	g_debug ("propertypanel.vala:71: update_property(prop.key = %s)\n", _tmp2_);
	_tmp3_ = self->priv->m_props;
	if (_tmp3_ != NULL) {
		IBusPropList* _tmp4_ = NULL;
		IBusProperty* _tmp5_ = NULL;
		_tmp4_ = self->priv->m_props;
		_tmp5_ = prop;
		ibus_prop_list_update_property (_tmp4_, _tmp5_);
	}
	_tmp6_ = self->priv->m_items;
	_tmp6__length1 = self->priv->m_items_length1;
	{
		IPropToolItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp6_;
		item_collection_length1 = _tmp6__length1;
		for (item_it = 0; item_it < _tmp6__length1; item_it = item_it + 1) {
			IPropToolItem* _tmp7_ = NULL;
			IPropToolItem* item = NULL;
			_tmp7_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp7_;
			{
				IPropToolItem* _tmp8_ = NULL;
				IBusProperty* _tmp9_ = NULL;
				_tmp8_ = item;
				_tmp9_ = prop;
				iprop_tool_item_update_property (_tmp8_, _tmp9_);
				_g_object_unref0 (item);
			}
		}
	}
	property_panel_show_with_auto_hide_timer (self);
}


static gboolean _cairo_rectangle_int_equal (const cairo_rectangle_int_t* s1, const cairo_rectangle_int_t* s2) {
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->x != s2->x) {
		return FALSE;
	}
	if (s1->y != s2->y) {
		return FALSE;
	}
	if (s1->width != s2->width) {
		return FALSE;
	}
	if (s1->height != s2->height) {
		return FALSE;
	}
	return TRUE;
}


void property_panel_set_cursor_location (PropertyPanel* self, gint x, gint y, gint width, gint height) {
	GdkRectangle location = {0};
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _tmp5_ = {0};
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	GdkRectangle _tmp19_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = x;
	_tmp1_ = y;
	_tmp2_ = width;
	_tmp3_ = height;
	memset (&_tmp4_, 0, sizeof (GdkRectangle));
	_tmp4_.x = _tmp0_;
	_tmp4_.y = _tmp1_;
	_tmp4_.width = _tmp2_;
	_tmp4_.height = _tmp3_;
	location = _tmp4_;
	_tmp5_ = self->priv->m_cursor_location;
	_tmp6_ = location;
	if (_cairo_rectangle_int_equal (&_tmp5_, &_tmp6_) == TRUE) {
		return;
	}
	_tmp7_ = x;
	_tmp8_ = y;
	_tmp9_ = width;
	_tmp10_ = height;
	g_debug ("propertypanel.vala:108: set_cursor_location(x = %d, y = %d, width = %d" \
", height = %d)\n", _tmp7_, _tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = self->priv->m_show;
	if (_tmp11_ == ((gint) PANEL_SHOW_AUTO_HIDE)) {
		gboolean _tmp12_ = FALSE;
		GdkRectangle _tmp13_ = {0};
		gint _tmp14_ = 0;
		gboolean _tmp17_ = FALSE;
		_tmp13_ = self->priv->m_cursor_location;
		_tmp14_ = _tmp13_.x;
		if (_tmp14_ != (-1)) {
			_tmp12_ = TRUE;
		} else {
			GdkRectangle _tmp15_ = {0};
			gint _tmp16_ = 0;
			_tmp15_ = self->priv->m_cursor_location;
			_tmp16_ = _tmp15_.y;
			_tmp12_ = _tmp16_ != (-1);
		}
		_tmp17_ = _tmp12_;
		if (_tmp17_) {
			GdkRectangle _tmp18_ = {0};
			_tmp18_ = location;
			self->priv->m_cursor_location = _tmp18_;
			property_panel_hide_if_necessary (self);
			property_panel_adjust_window_position (self);
			return;
		}
	}
	_tmp19_ = location;
	self->priv->m_cursor_location = _tmp19_;
	property_panel_adjust_window_position (self);
	property_panel_show_with_auto_hide_timer (self);
}


void property_panel_set_preedit_text (PropertyPanel* self, IBusText* text, guint cursor) {
	gboolean _tmp0_ = FALSE;
	IBusText* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	guint _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp1_ = text;
	if (_tmp1_ == NULL) {
		guint _tmp2_ = 0U;
		_tmp2_ = cursor;
		_tmp0_ = _tmp2_ == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		return;
	}
	_tmp4_ = cursor;
	g_debug ("propertypanel.vala:132: set_preedit_text(text, cursor = %u)\n", _tmp4_);
	property_panel_hide_if_necessary (self);
}


void property_panel_set_auxiliary_text (PropertyPanel* self, IBusText* text) {
	IBusText* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = text;
	if (_tmp0_ == NULL) {
		return;
	}
	g_debug ("propertypanel.vala:144: set_auxiliary_text(text)\n");
	property_panel_hide_if_necessary (self);
}


void property_panel_set_lookup_table (PropertyPanel* self, IBusLookupTable* table) {
	IBusLookupTable* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = table;
	if (_tmp0_ == NULL) {
		return;
	}
	g_debug ("propertypanel.vala:153: set_lookup_table(table)\n");
	property_panel_hide_if_necessary (self);
}


void property_panel_show (PropertyPanel* self) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->m_show;
	if (_tmp1_ == ((gint) PANEL_SHOW_DO_NOT_SHOW)) {
		_tmp0_ = TRUE;
	} else {
		IPropToolItem** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		_tmp2_ = self->priv->m_items;
		_tmp2__length1 = self->priv->m_items_length1;
		_tmp0_ = _tmp2__length1 == 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GtkWindow* _tmp4_ = NULL;
		_tmp4_ = self->priv->m_toplevel;
		gtk_widget_hide ((GtkWidget*) _tmp4_);
		return;
	} else {
		gint _tmp5_ = 0;
		_tmp5_ = self->priv->m_show;
		if (_tmp5_ == ((gint) PANEL_SHOW_ALWAYS)) {
			GtkWindow* _tmp6_ = NULL;
			_tmp6_ = self->priv->m_toplevel;
			gtk_widget_show_all ((GtkWidget*) _tmp6_);
			return;
		}
	}
}


void property_panel_hide (PropertyPanel* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}


void property_panel_focus_in (PropertyPanel* self) {
	GdkRectangle _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_debug ("propertypanel.vala:176: focus_in()\n");
	property_panel_hide_if_necessary (self);
	_tmp0_.x = -1;
	_tmp0_.y = -1;
	_tmp0_.width = 0;
	_tmp0_.height = 0;
	self->priv->m_cursor_location = _tmp0_;
}


void property_panel_set_show (PropertyPanel* self, gint _show) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = _show;
	self->priv->m_show = _tmp0_;
	property_panel_show (self);
}


void property_panel_set_auto_hide_timeout (PropertyPanel* self, guint timeout) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = timeout;
	self->priv->m_auto_hide_timeout = _tmp0_;
}


static void property_panel_real_get_preferred_width (GtkWidget* base, gint* minimum_width, gint* natural_width) {
	PropertyPanel * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkWindow* _tmp2_ = NULL;
	self = (PropertyPanel*) base;
	GTK_WIDGET_CLASS (property_panel_parent_class)->get_preferred_width ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BOX, GtkBox), &_tmp0_, &_tmp1_);
	_vala_minimum_width = _tmp0_;
	_vala_natural_width = _tmp1_;
	_tmp2_ = self->priv->m_toplevel;
	gtk_window_resize (_tmp2_, 1, 1);
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}


static void property_panel_real_get_preferred_height (GtkWidget* base, gint* minimum_width, gint* natural_width) {
	PropertyPanel * self;
	gint _vala_minimum_width = 0;
	gint _vala_natural_width = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkWindow* _tmp2_ = NULL;
	self = (PropertyPanel*) base;
	GTK_WIDGET_CLASS (property_panel_parent_class)->get_preferred_height ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_BOX, GtkBox), &_tmp0_, &_tmp1_);
	_vala_minimum_width = _tmp0_;
	_vala_natural_width = _tmp1_;
	_tmp2_ = self->priv->m_toplevel;
	gtk_window_resize (_tmp2_, 1, 1);
	if (minimum_width) {
		*minimum_width = _vala_minimum_width;
	}
	if (natural_width) {
		*natural_width = _vala_natural_width;
	}
}


static void _vala_array_add25 (IPropToolItem*** array, int* length, int* size, IPropToolItem* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IPropToolItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void ____lambda21_ (PropertyPanel* self, IPropToolItem* w, const gchar* k, gint s) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	_tmp0_ = k;
	_tmp1_ = s;
	g_signal_emit_by_name (self, "property-activate", _tmp0_, _tmp1_);
}


static void _____lambda21__iprop_tool_item_property_activate (IPropToolItem* _sender, const gchar* key, gint state, gpointer self) {
	____lambda21_ (self, _sender, key, state);
}


static void property_panel_create_menu_items (PropertyPanel* self) {
	gint i = 0;
	g_return_if_fail (self != NULL);
	i = 0;
	while (TRUE) {
		IBusProperty* prop = NULL;
		IBusPropList* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		IBusProperty* _tmp2_ = NULL;
		IBusProperty* _tmp3_ = NULL;
		IBusProperty* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		IPropToolItem* item = NULL;
		IBusProperty* _tmp6_ = NULL;
		IBusPropType _tmp7_ = 0;
		IPropToolItem* _tmp18_ = NULL;
		_tmp0_ = self->priv->m_props;
		_tmp1_ = i;
		_tmp2_ = ibus_prop_list_get (_tmp0_, (guint) _tmp1_);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		prop = _tmp3_;
		_tmp4_ = prop;
		if (_tmp4_ == NULL) {
			_g_object_unref0 (prop);
			break;
		}
		_tmp5_ = i;
		i = _tmp5_ + 1;
		item = NULL;
		_tmp6_ = prop;
		_tmp7_ = ibus_property_get_prop_type (_tmp6_);
		switch (_tmp7_) {
			case PROP_TYPE_NORMAL:
			{
				IBusProperty* _tmp8_ = NULL;
				PropToolButton* _tmp9_ = NULL;
				_tmp8_ = prop;
				_tmp9_ = prop_tool_button_new (_tmp8_);
				g_object_ref_sink (_tmp9_);
				_g_object_unref0 (item);
				item = (IPropToolItem*) _tmp9_;
				break;
			}
			case PROP_TYPE_TOGGLE:
			{
				IBusProperty* _tmp10_ = NULL;
				PropToggleToolButton* _tmp11_ = NULL;
				_tmp10_ = prop;
				_tmp11_ = prop_toggle_tool_button_new (_tmp10_);
				g_object_ref_sink (_tmp11_);
				_g_object_unref0 (item);
				item = (IPropToolItem*) _tmp11_;
				break;
			}
			case PROP_TYPE_MENU:
			{
				IBusProperty* _tmp12_ = NULL;
				PropMenuToolButton* _tmp13_ = NULL;
				_tmp12_ = prop;
				_tmp13_ = prop_menu_tool_button_new (_tmp12_);
				g_object_ref_sink (_tmp13_);
				_g_object_unref0 (item);
				item = (IPropToolItem*) _tmp13_;
				break;
			}
			case PROP_TYPE_SEPARATOR:
			{
				IBusProperty* _tmp14_ = NULL;
				PropSeparatorToolItem* _tmp15_ = NULL;
				_tmp14_ = prop;
				_tmp15_ = prop_separator_tool_item_new (_tmp14_);
				g_object_ref_sink (_tmp15_);
				_g_object_unref0 (item);
				item = (IPropToolItem*) _tmp15_;
				break;
			}
			default:
			{
				IBusProperty* _tmp16_ = NULL;
				IBusPropType _tmp17_ = 0;
				_tmp16_ = prop;
				_tmp17_ = ibus_property_get_prop_type (_tmp16_);
				g_warning ("propertypanel.vala:235: unknown property type %d", (gint) _tmp17_);
				break;
			}
		}
		_tmp18_ = item;
		if (_tmp18_ != NULL) {
			IPropToolItem* _tmp19_ = NULL;
			IPropToolItem** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			IPropToolItem* _tmp21_ = NULL;
			IPropToolItem* _tmp22_ = NULL;
			IPropToolItem* _tmp23_ = NULL;
			_tmp19_ = item;
			gtk_box_pack_start ((GtkBox*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, GTK_TYPE_WIDGET) ? ((GtkWidget*) _tmp19_) : NULL, FALSE, FALSE, (guint) 0);
			_tmp20_ = self->priv->m_items;
			_tmp20__length1 = self->priv->m_items_length1;
			_tmp21_ = item;
			_tmp22_ = _g_object_ref0 (_tmp21_);
			_vala_array_add25 (&self->priv->m_items, &self->priv->m_items_length1, &self->priv->_m_items_size_, _tmp22_);
			_tmp23_ = item;
			g_signal_connect_object (_tmp23_, "property-activate", (GCallback) _____lambda21__iprop_tool_item_property_activate, self, 0);
		}
		_g_object_unref0 (item);
		_g_object_unref0 (prop);
	}
}


static void property_panel_move (PropertyPanel* self, gint x, gint y) {
	GtkWindow* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_toplevel;
	_tmp1_ = x;
	_tmp2_ = y;
	gtk_window_move (_tmp0_, _tmp1_, _tmp2_);
}


static void property_panel_adjust_window_position (PropertyPanel* self) {
	GdkPoint cursor_right_bottom = {0};
	GdkRectangle _tmp0_ = {0};
	gint _tmp1_ = 0;
	GdkRectangle _tmp2_ = {0};
	gint _tmp3_ = 0;
	GdkRectangle _tmp4_ = {0};
	gint _tmp5_ = 0;
	GdkRectangle _tmp6_ = {0};
	gint _tmp7_ = 0;
	GdkPoint _tmp8_ = {0};
	GtkAllocation allocation = {0};
	GtkWindow* _tmp9_ = NULL;
	GtkAllocation _tmp10_ = {0};
	GdkPoint window_right_bottom = {0};
	GdkPoint _tmp11_ = {0};
	gint _tmp12_ = 0;
	GtkAllocation _tmp13_ = {0};
	gint _tmp14_ = 0;
	GdkPoint _tmp15_ = {0};
	gint _tmp16_ = 0;
	GtkAllocation _tmp17_ = {0};
	gint _tmp18_ = 0;
	GdkPoint _tmp19_ = {0};
	GdkWindow* root = NULL;
	GdkWindow* _tmp20_ = NULL;
	GdkWindow* _tmp21_ = NULL;
	gint root_width = 0;
	GdkWindow* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint root_height = 0;
	GdkWindow* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint x = 0;
	gint y = 0;
	GdkPoint _tmp26_ = {0};
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GdkPoint _tmp34_ = {0};
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_cursor_location;
	_tmp1_ = _tmp0_.x;
	_tmp2_ = self->priv->m_cursor_location;
	_tmp3_ = _tmp2_.width;
	_tmp4_ = self->priv->m_cursor_location;
	_tmp5_ = _tmp4_.y;
	_tmp6_ = self->priv->m_cursor_location;
	_tmp7_ = _tmp6_.height;
	_tmp8_.x = _tmp1_ + _tmp3_;
	_tmp8_.y = _tmp5_ + _tmp7_;
	cursor_right_bottom = _tmp8_;
	_tmp9_ = self->priv->m_toplevel;
	gtk_widget_get_allocation ((GtkWidget*) _tmp9_, &_tmp10_);
	allocation = _tmp10_;
	_tmp11_ = cursor_right_bottom;
	_tmp12_ = _tmp11_.x;
	_tmp13_ = allocation;
	_tmp14_ = _tmp13_.width;
	_tmp15_ = cursor_right_bottom;
	_tmp16_ = _tmp15_.y;
	_tmp17_ = allocation;
	_tmp18_ = _tmp17_.height;
	_tmp19_.x = _tmp12_ + _tmp14_;
	_tmp19_.y = _tmp16_ + _tmp18_;
	window_right_bottom = _tmp19_;
	_tmp20_ = gdk_get_default_root_window ();
	_tmp21_ = _g_object_ref0 (_tmp20_);
	root = _tmp21_;
	_tmp22_ = root;
	_tmp23_ = gdk_window_get_width (_tmp22_);
	root_width = _tmp23_;
	_tmp24_ = root;
	_tmp25_ = gdk_window_get_height (_tmp24_);
	root_height = _tmp25_;
	_tmp26_ = window_right_bottom;
	_tmp27_ = _tmp26_.x;
	_tmp28_ = root_width;
	if (_tmp27_ > _tmp28_) {
		gint _tmp29_ = 0;
		GtkAllocation _tmp30_ = {0};
		gint _tmp31_ = 0;
		_tmp29_ = root_width;
		_tmp30_ = allocation;
		_tmp31_ = _tmp30_.width;
		x = _tmp29_ - _tmp31_;
	} else {
		GdkPoint _tmp32_ = {0};
		gint _tmp33_ = 0;
		_tmp32_ = cursor_right_bottom;
		_tmp33_ = _tmp32_.x;
		x = _tmp33_;
	}
	_tmp34_ = window_right_bottom;
	_tmp35_ = _tmp34_.y;
	_tmp36_ = root_height;
	if (_tmp35_ > _tmp36_) {
		GdkRectangle _tmp37_ = {0};
		gint _tmp38_ = 0;
		GtkAllocation _tmp39_ = {0};
		gint _tmp40_ = 0;
		_tmp37_ = self->priv->m_cursor_location;
		_tmp38_ = _tmp37_.y;
		_tmp39_ = allocation;
		_tmp40_ = _tmp39_.height;
		y = _tmp38_ - _tmp40_;
	} else {
		GdkPoint _tmp41_ = {0};
		gint _tmp42_ = 0;
		_tmp41_ = cursor_right_bottom;
		_tmp42_ = _tmp41_.y;
		y = _tmp42_;
	}
	_tmp43_ = x;
	_tmp44_ = y;
	property_panel_move (self, _tmp43_, _tmp44_);
	_g_object_unref0 (root);
}


static gboolean __lambda22_ (PropertyPanel* self) {
	gboolean result = FALSE;
	GtkWindow* _tmp0_ = NULL;
	_tmp0_ = self->priv->m_toplevel;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	self->priv->m_auto_hide_timeout_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean ___lambda22__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda22_ (self);
	return result;
}


static void property_panel_show_with_auto_hide_timer (PropertyPanel* self) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
	guint _tmp4_ = 0U;
	GtkWindow* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->m_show;
	if (_tmp1_ != ((gint) PANEL_SHOW_AUTO_HIDE)) {
		_tmp0_ = TRUE;
	} else {
		IPropToolItem** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		_tmp2_ = self->priv->m_items;
		_tmp2__length1 = self->priv->m_items_length1;
		_tmp0_ = _tmp2__length1 == 0;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		return;
	}
	_tmp4_ = self->priv->m_auto_hide_timeout_id;
	if (_tmp4_ != ((guint) 0)) {
		guint _tmp5_ = 0U;
		_tmp5_ = self->priv->m_auto_hide_timeout_id;
		g_source_remove (_tmp5_);
	}
	_tmp6_ = self->priv->m_toplevel;
	gtk_widget_show_all ((GtkWidget*) _tmp6_);
	_tmp7_ = self->priv->m_auto_hide_timeout;
	_tmp8_ = g_timeout_add_full (G_PRIORITY_DEFAULT_IDLE, _tmp7_, ___lambda22__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->m_auto_hide_timeout_id = _tmp8_;
}


static void property_panel_hide_if_necessary (PropertyPanel* self) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->m_show;
	if (_tmp1_ == ((gint) PANEL_SHOW_AUTO_HIDE)) {
		guint _tmp2_ = 0U;
		_tmp2_ = self->priv->m_auto_hide_timeout_id;
		_tmp0_ = _tmp2_ != ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		guint _tmp4_ = 0U;
		GtkWindow* _tmp5_ = NULL;
		_tmp4_ = self->priv->m_auto_hide_timeout_id;
		g_source_remove (_tmp4_);
		self->priv->m_auto_hide_timeout_id = (guint) 0;
		_tmp5_ = self->priv->m_toplevel;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
	}
}


static void g_cclosure_user_marshal_VOID__STRING_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_INT) (gpointer data1, const char* arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_int (param_values + 2), data2);
}


static void property_panel_class_init (PropertyPanelClass * klass) {
	property_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PropertyPanelPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = property_panel_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = property_panel_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->finalize = property_panel_finalize;
	g_signal_new ("property_activate", TYPE_PROPERTY_PANEL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
}


static void property_panel_instance_init (PropertyPanel * self) {
	GdkRectangle _tmp0_ = {0};
	self->priv = PROPERTY_PANEL_GET_PRIVATE (self);
	memset (&_tmp0_, 0, sizeof (GdkRectangle));
	_tmp0_.x = -1;
	_tmp0_.y = -1;
	_tmp0_.width = 0;
	_tmp0_.height = 0;
	self->priv->m_cursor_location = _tmp0_;
	self->priv->m_show = (gint) PANEL_SHOW_AUTO_HIDE;
	self->priv->m_auto_hide_timeout = (guint) 10000;
	self->priv->m_auto_hide_timeout_id = (guint) 0;
}


static void property_panel_finalize (GObject* obj) {
	PropertyPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROPERTY_PANEL, PropertyPanel);
	_g_object_unref0 (self->priv->m_toplevel);
	_g_object_unref0 (self->priv->m_props);
	self->priv->m_items = (_vala_array_free (self->priv->m_items, self->priv->m_items_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (property_panel_parent_class)->finalize (obj);
}


GType property_panel_get_type (void) {
	static volatile gsize property_panel_type_id__volatile = 0;
	if (g_once_init_enter (&property_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropertyPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) property_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropertyPanel), 0, (GInstanceInitFunc) property_panel_instance_init, NULL };
		GType property_panel_type_id;
		property_panel_type_id = g_type_register_static (GTK_TYPE_BOX, "PropertyPanel", &g_define_type_info, 0);
		g_once_init_leave (&property_panel_type_id__volatile, property_panel_type_id);
	}
	return property_panel_type_id__volatile;
}


void iprop_tool_item_update_property (IPropToolItem* self, IBusProperty* prop) {
	g_return_if_fail (self != NULL);
	IPROP_TOOL_ITEM_GET_INTERFACE (self)->update_property (self, prop);
}


static void iprop_tool_item_base_init (IPropToolItemIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("property_activate", TYPE_IPROP_TOOL_ITEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_INT, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_INT);
	}
}


GType iprop_tool_item_get_type (void) {
	static volatile gsize iprop_tool_item_type_id__volatile = 0;
	if (g_once_init_enter (&iprop_tool_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IPropToolItemIface), (GBaseInitFunc) iprop_tool_item_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType iprop_tool_item_type_id;
		iprop_tool_item_type_id = g_type_register_static (G_TYPE_INTERFACE, "IPropToolItem", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (iprop_tool_item_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&iprop_tool_item_type_id__volatile, iprop_tool_item_type_id);
	}
	return iprop_tool_item_type_id__volatile;
}


PropMenu* prop_menu_construct (GType object_type, IBusProperty* prop) {
	PropMenu * self = NULL;
	IBusProperty* _tmp0_ = NULL;
	IBusPropList* _tmp1_ = NULL;
	IBusProperty* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropMenu*) g_object_new (object_type, NULL);
	gtk_menu_shell_set_take_focus ((GtkMenuShell*) self, FALSE);
	_tmp0_ = prop;
	_tmp1_ = ibus_property_get_sub_props (_tmp0_);
	prop_menu_create_items (self, _tmp1_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp2_ = prop;
	_tmp3_ = ibus_property_get_sensitive (_tmp2_);
	gtk_widget_set_sensitive ((GtkWidget*) self, _tmp3_);
	return self;
}


PropMenu* prop_menu_new (IBusProperty* prop) {
	return prop_menu_construct (TYPE_PROP_MENU, prop);
}


static void prop_menu_real_update_property (IPropToolItem* base, IBusProperty* prop) {
	PropMenu * self;
	IPropItem** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = (PropMenu*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_items;
	_tmp0__length1 = self->priv->m_items_length1;
	{
		IPropItem** item_collection = NULL;
		gint item_collection_length1 = 0;
		gint _item_collection_size_ = 0;
		gint item_it = 0;
		item_collection = _tmp0_;
		item_collection_length1 = _tmp0__length1;
		for (item_it = 0; item_it < _tmp0__length1; item_it = item_it + 1) {
			IPropItem* _tmp1_ = NULL;
			IPropItem* item = NULL;
			_tmp1_ = _g_object_ref0 (item_collection[item_it]);
			item = _tmp1_;
			{
				IPropItem* _tmp2_ = NULL;
				IBusProperty* _tmp3_ = NULL;
				_tmp2_ = item;
				_tmp3_ = prop;
				iprop_item_update_property (_tmp2_, _tmp3_);
				_g_object_unref0 (item);
			}
		}
	}
}


static void _prop_menu_menu_position_gtk_menu_position_func (GtkMenu* menu, gint* x, gint* y, gboolean* push_in, gpointer self) {
	prop_menu_menu_position (self, menu, x, y, push_in);
}


void prop_menu_popup (PropMenu* self, guint button, guint32 activate_time, GtkWidget* widget) {
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint32 _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->m_parent_button);
	self->priv->m_parent_button = _tmp1_;
	_tmp2_ = button;
	_tmp3_ = activate_time;
	gtk_menu_popup (G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_MENU, GtkMenu), NULL, NULL, _prop_menu_menu_position_gtk_menu_position_func, self, _tmp2_, _tmp3_);
}


static void prop_menu_real_destroy (GtkWidget* base) {
	PropMenu * self;
	IPropItem** _tmp0_ = NULL;
	self = (PropMenu*) base;
	_g_object_unref0 (self->priv->m_parent_button);
	self->priv->m_parent_button = NULL;
	_tmp0_ = g_new0 (IPropItem*, 0 + 1);
	self->priv->m_items = (_vala_array_free (self->priv->m_items, self->priv->m_items_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->m_items = _tmp0_;
	self->priv->m_items_length1 = 0;
	self->priv->_m_items_size_ = self->priv->m_items_length1;
	GTK_WIDGET_CLASS (prop_menu_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_MENU, GtkMenu));
}


static void ____lambda18_ (PropMenu* self, IPropItem* w, const gchar* k, gint s) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	_tmp0_ = k;
	_tmp1_ = s;
	g_signal_emit_by_name ((IPropToolItem*) self, "property-activate", _tmp0_, _tmp1_);
}


static void _____lambda18__iprop_item_property_activate (IPropItem* _sender, const gchar* key, gint state, gpointer self) {
	____lambda18_ (self, _sender, key, state);
}


static void _vala_array_add26 (IPropItem*** array, int* length, int* size, IPropItem* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (IPropItem*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void prop_menu_create_items (PropMenu* self, IBusPropList* props) {
	gint i = 0;
	PropRadioMenuItem* last_radio = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (props != NULL);
	i = 0;
	last_radio = NULL;
	while (TRUE) {
		IBusProperty* prop = NULL;
		IBusPropList* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		IBusProperty* _tmp2_ = NULL;
		IBusProperty* _tmp3_ = NULL;
		IBusProperty* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		IPropItem* item = NULL;
		IBusProperty* _tmp6_ = NULL;
		IBusPropType _tmp7_ = 0;
		IBusProperty* _tmp29_ = NULL;
		IBusPropType _tmp30_ = 0;
		IPropItem* _tmp31_ = NULL;
		_tmp0_ = props;
		_tmp1_ = i;
		_tmp2_ = ibus_prop_list_get (_tmp0_, (guint) _tmp1_);
		_tmp3_ = _g_object_ref0 (_tmp2_);
		prop = _tmp3_;
		_tmp4_ = prop;
		if (_tmp4_ == NULL) {
			_g_object_unref0 (prop);
			break;
		}
		_tmp5_ = i;
		i = _tmp5_ + 1;
		item = NULL;
		_tmp6_ = prop;
		_tmp7_ = ibus_property_get_prop_type (_tmp6_);
		switch (_tmp7_) {
			case PROP_TYPE_NORMAL:
			{
				IBusProperty* _tmp8_ = NULL;
				PropImageMenuItem* _tmp9_ = NULL;
				_tmp8_ = prop;
				_tmp9_ = prop_image_menu_item_new (_tmp8_);
				g_object_ref_sink (_tmp9_);
				_g_object_unref0 (item);
				item = (IPropItem*) _tmp9_;
				break;
			}
			case PROP_TYPE_TOGGLE:
			{
				IBusProperty* _tmp10_ = NULL;
				PropCheckMenuItem* _tmp11_ = NULL;
				_tmp10_ = prop;
				_tmp11_ = prop_check_menu_item_new (_tmp10_);
				g_object_ref_sink (_tmp11_);
				_g_object_unref0 (item);
				item = (IPropItem*) _tmp11_;
				break;
			}
			case PROP_TYPE_RADIO:
			{
				IBusProperty* _tmp12_ = NULL;
				PropRadioMenuItem* _tmp13_ = NULL;
				PropRadioMenuItem* _tmp14_ = NULL;
				PropRadioMenuItem* _tmp15_ = NULL;
				IPropItem* _tmp16_ = NULL;
				_tmp12_ = prop;
				_tmp13_ = last_radio;
				_tmp14_ = prop_radio_menu_item_new (_tmp12_, _tmp13_);
				g_object_ref_sink (_tmp14_);
				_g_object_unref0 (last_radio);
				last_radio = _tmp14_;
				_tmp15_ = last_radio;
				_tmp16_ = _g_object_ref0 ((IPropItem*) _tmp15_);
				_g_object_unref0 (item);
				item = _tmp16_;
				break;
			}
			case PROP_TYPE_MENU:
			{
				{
					PropImageMenuItem* menuitem = NULL;
					IBusProperty* _tmp17_ = NULL;
					PropImageMenuItem* _tmp18_ = NULL;
					PropImageMenuItem* _tmp19_ = NULL;
					IBusProperty* _tmp20_ = NULL;
					PropMenu* _tmp21_ = NULL;
					PropMenu* _tmp22_ = NULL;
					PropImageMenuItem* _tmp23_ = NULL;
					IPropItem* _tmp24_ = NULL;
					_tmp17_ = prop;
					_tmp18_ = prop_image_menu_item_new (_tmp17_);
					g_object_ref_sink (_tmp18_);
					menuitem = _tmp18_;
					_tmp19_ = menuitem;
					_tmp20_ = prop;
					_tmp21_ = prop_menu_new (_tmp20_);
					g_object_ref_sink (_tmp21_);
					_tmp22_ = _tmp21_;
					gtk_menu_item_set_submenu ((GtkMenuItem*) _tmp19_, (GtkWidget*) _tmp22_);
					_g_object_unref0 (_tmp22_);
					_tmp23_ = menuitem;
					_tmp24_ = _g_object_ref0 ((IPropItem*) _tmp23_);
					_g_object_unref0 (item);
					item = _tmp24_;
					_g_object_unref0 (menuitem);
				}
				break;
			}
			case PROP_TYPE_SEPARATOR:
			{
				IBusProperty* _tmp25_ = NULL;
				PropSeparatorMenuItem* _tmp26_ = NULL;
				_tmp25_ = prop;
				_tmp26_ = prop_separator_menu_item_new (_tmp25_);
				g_object_ref_sink (_tmp26_);
				_g_object_unref0 (item);
				item = (IPropItem*) _tmp26_;
				break;
			}
			default:
			{
				IBusProperty* _tmp27_ = NULL;
				IBusPropType _tmp28_ = 0;
				_tmp27_ = prop;
				_tmp28_ = ibus_property_get_prop_type (_tmp27_);
				g_warning ("propertypanel.vala:382: Unknown property type: %d", (gint) _tmp28_);
				break;
			}
		}
		_tmp29_ = prop;
		_tmp30_ = ibus_property_get_prop_type (_tmp29_);
		if (_tmp30_ != PROP_TYPE_RADIO) {
			_g_object_unref0 (last_radio);
			last_radio = NULL;
		}
		_tmp31_ = item;
		if (_tmp31_ != NULL) {
			IPropItem* _tmp32_ = NULL;
			IPropItem* _tmp33_ = NULL;
			IPropItem** _tmp34_ = NULL;
			gint _tmp34__length1 = 0;
			IPropItem* _tmp35_ = NULL;
			IPropItem* _tmp36_ = NULL;
			_tmp32_ = item;
			gtk_menu_shell_append ((GtkMenuShell*) self, (GtkWidget*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp32_, GTK_TYPE_MENU_ITEM) ? ((GtkMenuItem*) _tmp32_) : NULL));
			_tmp33_ = item;
			g_signal_connect_object (_tmp33_, "property-activate", (GCallback) _____lambda18__iprop_item_property_activate, self, 0);
			_tmp34_ = self->priv->m_items;
			_tmp34__length1 = self->priv->m_items_length1;
			_tmp35_ = item;
			_tmp36_ = _g_object_ref0 (_tmp35_);
			_vala_array_add26 (&self->priv->m_items, &self->priv->m_items_length1, &self->priv->_m_items_size_, _tmp36_);
		}
		_g_object_unref0 (item);
		_g_object_unref0 (prop);
	}
	_g_object_unref0 (last_radio);
}


static void prop_menu_menu_position (PropMenu* self, GtkMenu* menu, gint* x, gint* y, gboolean* push_in) {
	gint _vala_x = 0;
	gint _vala_y = 0;
	gboolean _vala_push_in = FALSE;
	GtkWidget* button = NULL;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GdkScreen* screen = NULL;
	GtkWidget* _tmp2_ = NULL;
	GdkScreen* _tmp3_ = NULL;
	GdkScreen* _tmp4_ = NULL;
	gint monitor = 0;
	GdkScreen* _tmp5_ = NULL;
	GtkWidget* _tmp6_ = NULL;
	GdkWindow* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GdkRectangle monitor_location = {0};
	GdkScreen* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	GdkRectangle _tmp11_ = {0};
	GtkWidget* _tmp12_ = NULL;
	GdkWindow* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GtkAllocation button_allocation = {0};
	GtkWidget* _tmp16_ = NULL;
	GtkAllocation _tmp17_ = {0};
	gint _tmp18_ = 0;
	GtkAllocation _tmp19_ = {0};
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	GtkAllocation _tmp22_ = {0};
	gint _tmp23_ = 0;
	gint menu_width = 0;
	gint menu_height = 0;
	GtkMenu* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	GdkRectangle _tmp29_ = {0};
	gint _tmp30_ = 0;
	gint _tmp44_ = 0;
	GtkAllocation _tmp45_ = {0};
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	GdkRectangle _tmp48_ = {0};
	gint _tmp49_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (menu != NULL);
	_tmp0_ = self->priv->m_parent_button;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	button = _tmp1_;
	_tmp2_ = button;
	_tmp3_ = gtk_widget_get_screen (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	screen = _tmp4_;
	_tmp5_ = screen;
	_tmp6_ = button;
	_tmp7_ = gtk_widget_get_window (_tmp6_);
	_tmp8_ = gdk_screen_get_monitor_at_window (_tmp5_, _tmp7_);
	monitor = _tmp8_;
	_tmp9_ = screen;
	_tmp10_ = monitor;
	gdk_screen_get_monitor_geometry (_tmp9_, _tmp10_, &_tmp11_);
	monitor_location = _tmp11_;
	_tmp12_ = button;
	_tmp13_ = gtk_widget_get_window (_tmp12_);
	gdk_window_get_origin (_tmp13_, &_tmp14_, &_tmp15_);
	_vala_x = _tmp14_;
	_vala_y = _tmp15_;
	_tmp16_ = button;
	gtk_widget_get_allocation (_tmp16_, &_tmp17_);
	button_allocation = _tmp17_;
	_tmp18_ = _vala_x;
	_tmp19_ = button_allocation;
	_tmp20_ = _tmp19_.x;
	_vala_x = _tmp18_ + _tmp20_;
	_tmp21_ = _vala_y;
	_tmp22_ = button_allocation;
	_tmp23_ = _tmp22_.y;
	_vala_y = _tmp21_ + _tmp23_;
	_tmp24_ = menu;
	gtk_widget_get_size_request ((GtkWidget*) _tmp24_, &_tmp25_, &_tmp26_);
	menu_width = _tmp25_;
	menu_height = _tmp26_;
	_tmp27_ = _vala_x;
	_tmp28_ = menu_width;
	_tmp29_ = monitor_location;
	_tmp30_ = _tmp29_.width;
	if ((_tmp27_ + _tmp28_) >= _tmp30_) {
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
		GtkAllocation _tmp33_ = {0};
		gint _tmp34_ = 0;
		_tmp31_ = _vala_x;
		_tmp32_ = menu_width;
		_tmp33_ = button_allocation;
		_tmp34_ = _tmp33_.width;
		_vala_x = _tmp31_ - (_tmp32_ - _tmp34_);
	} else {
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		_tmp35_ = _vala_x;
		_tmp36_ = menu_width;
		if ((_tmp35_ - _tmp36_) <= 0) {
		} else {
			gint _tmp37_ = 0;
			GdkRectangle _tmp38_ = {0};
			gint _tmp39_ = 0;
			_tmp37_ = _vala_x;
			_tmp38_ = monitor_location;
			_tmp39_ = _tmp38_.width;
			if (_tmp37_ <= ((_tmp39_ * 3) / 4)) {
			} else {
				gint _tmp40_ = 0;
				gint _tmp41_ = 0;
				GtkAllocation _tmp42_ = {0};
				gint _tmp43_ = 0;
				_tmp40_ = _vala_x;
				_tmp41_ = menu_width;
				_tmp42_ = button_allocation;
				_tmp43_ = _tmp42_.width;
				_vala_x = _tmp40_ - (_tmp41_ - _tmp43_);
			}
		}
	}
	_tmp44_ = _vala_y;
	_tmp45_ = button_allocation;
	_tmp46_ = _tmp45_.height;
	_tmp47_ = menu_width;
	_tmp48_ = monitor_location;
	_tmp49_ = _tmp48_.height;
	if (((_tmp44_ + _tmp46_) + _tmp47_) >= _tmp49_) {
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		_tmp50_ = _vala_y;
		_tmp51_ = menu_height;
		_vala_y = _tmp50_ - _tmp51_;
	} else {
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		_tmp52_ = _vala_y;
		_tmp53_ = menu_height;
		if ((_tmp52_ - _tmp53_) <= 0) {
			gint _tmp54_ = 0;
			GtkAllocation _tmp55_ = {0};
			gint _tmp56_ = 0;
			_tmp54_ = _vala_y;
			_tmp55_ = button_allocation;
			_tmp56_ = _tmp55_.height;
			_vala_y = _tmp54_ + _tmp56_;
		} else {
			gint _tmp57_ = 0;
			GdkRectangle _tmp58_ = {0};
			gint _tmp59_ = 0;
			_tmp57_ = _vala_y;
			_tmp58_ = monitor_location;
			_tmp59_ = _tmp58_.height;
			if (_tmp57_ <= ((_tmp59_ * 3) / 4)) {
				gint _tmp60_ = 0;
				GtkAllocation _tmp61_ = {0};
				gint _tmp62_ = 0;
				_tmp60_ = _vala_y;
				_tmp61_ = button_allocation;
				_tmp62_ = _tmp61_.height;
				_vala_y = _tmp60_ + _tmp62_;
			} else {
				gint _tmp63_ = 0;
				gint _tmp64_ = 0;
				_tmp63_ = _vala_y;
				_tmp64_ = menu_height;
				_vala_y = _tmp63_ - _tmp64_;
			}
		}
	}
	_vala_push_in = FALSE;
	_g_object_unref0 (screen);
	_g_object_unref0 (button);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (push_in) {
		*push_in = _vala_push_in;
	}
}


static void prop_menu_class_init (PropMenuClass * klass) {
	prop_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PropMenuPrivate));
	GTK_WIDGET_CLASS (klass)->destroy = prop_menu_real_destroy;
	G_OBJECT_CLASS (klass)->finalize = prop_menu_finalize;
}


static void prop_menu_iprop_tool_item_interface_init (IPropToolItemIface * iface) {
	prop_menu_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*)(IPropToolItem*, IBusProperty*)) prop_menu_real_update_property;
}


static void prop_menu_instance_init (PropMenu * self) {
	self->priv = PROP_MENU_GET_PRIVATE (self);
}


static void prop_menu_finalize (GObject* obj) {
	PropMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROP_MENU, PropMenu);
	_g_object_unref0 (self->priv->m_parent_button);
	self->priv->m_items = (_vala_array_free (self->priv->m_items, self->priv->m_items_length1, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (prop_menu_parent_class)->finalize (obj);
}


GType prop_menu_get_type (void) {
	static volatile gsize prop_menu_type_id__volatile = 0;
	if (g_once_init_enter (&prop_menu_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropMenu), 0, (GInstanceInitFunc) prop_menu_instance_init, NULL };
		static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_menu_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType prop_menu_type_id;
		prop_menu_type_id = g_type_register_static (GTK_TYPE_MENU, "PropMenu", &g_define_type_info, 0);
		g_type_add_interface_static (prop_menu_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
		g_once_init_leave (&prop_menu_type_id__volatile, prop_menu_type_id);
	}
	return prop_menu_type_id__volatile;
}


PropToolButton* prop_tool_button_construct (GType object_type, IBusProperty* prop) {
	PropToolButton * self = NULL;
	gchar* label = NULL;
	IBusProperty* _tmp0_ = NULL;
	IBusText* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	IBusProperty* _tmp4_ = NULL;
	IBusProperty* _tmp5_ = NULL;
	g_return_val_if_fail (prop != NULL, NULL);
	_tmp0_ = prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	label = _tmp3_;
	self = (PropToolButton*) g_object_new (object_type, "label", label, NULL);
	_tmp4_ = prop;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->m_prop);
	self->priv->m_prop = _tmp5_;
	gtk_tool_item_set_homogeneous ((GtkToolItem*) self, FALSE);
	prop_tool_button_sync (self);
	_g_free0 (label);
	return self;
}


PropToolButton* prop_tool_button_new (IBusProperty* prop) {
	return prop_tool_button_construct (TYPE_PROP_TOOL_BUTTON, prop);
}


static void prop_tool_button_real_update_property (IPropToolItem* base, IBusProperty* prop) {
	PropToolButton * self;
	IBusProperty* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	IBusProperty* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	IBusProperty* _tmp4_ = NULL;
	IBusProperty* _tmp5_ = NULL;
	IBusText* _tmp6_ = NULL;
	IBusProperty* _tmp7_ = NULL;
	IBusProperty* _tmp8_ = NULL;
	IBusText* _tmp9_ = NULL;
	IBusProperty* _tmp10_ = NULL;
	IBusProperty* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	IBusProperty* _tmp13_ = NULL;
	IBusProperty* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	IBusProperty* _tmp16_ = NULL;
	IBusProperty* _tmp17_ = NULL;
	IBusPropState _tmp18_ = 0;
	IBusProperty* _tmp19_ = NULL;
	IBusProperty* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	self = (PropToolButton*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_key (_tmp0_);
	_tmp2_ = prop;
	_tmp3_ = ibus_property_get_key (_tmp2_);
	if (g_strcmp0 (_tmp1_, _tmp3_) != 0) {
		return;
	}
	_tmp4_ = self->priv->m_prop;
	_tmp5_ = prop;
	_tmp6_ = ibus_property_get_symbol (_tmp5_);
	ibus_property_set_symbol (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->m_prop;
	_tmp8_ = prop;
	_tmp9_ = ibus_property_get_tooltip (_tmp8_);
	ibus_property_set_tooltip (_tmp7_, _tmp9_);
	_tmp10_ = self->priv->m_prop;
	_tmp11_ = prop;
	_tmp12_ = ibus_property_get_sensitive (_tmp11_);
	ibus_property_set_sensitive (_tmp10_, _tmp12_);
	_tmp13_ = self->priv->m_prop;
	_tmp14_ = prop;
	_tmp15_ = ibus_property_get_icon (_tmp14_);
	ibus_property_set_icon (_tmp13_, _tmp15_);
	_tmp16_ = self->priv->m_prop;
	_tmp17_ = prop;
	_tmp18_ = ibus_property_get_state (_tmp17_);
	ibus_property_set_state (_tmp16_, _tmp18_);
	_tmp19_ = self->priv->m_prop;
	_tmp20_ = prop;
	_tmp21_ = ibus_property_get_visible (_tmp20_);
	ibus_property_set_visible (_tmp19_, _tmp21_);
	prop_tool_button_sync (self);
}


static void prop_tool_button_sync (PropToolButton* self) {
	IBusProperty* _tmp0_ = NULL;
	IBusText* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	IBusProperty* _tmp3_ = NULL;
	IBusText* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	IBusProperty* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	IBusProperty* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	IBusProperty* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	gtk_tool_button_set_label ((GtkToolButton*) self, _tmp2_);
	_tmp3_ = self->priv->m_prop;
	_tmp4_ = ibus_property_get_tooltip (_tmp3_);
	_tmp5_ = ibus_text_get_text (_tmp4_);
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) self, _tmp5_);
	_tmp6_ = self->priv->m_prop;
	_tmp7_ = ibus_property_get_sensitive (_tmp6_);
	gtk_widget_set_sensitive ((GtkWidget*) self, _tmp7_);
	_tmp8_ = self->priv->m_prop;
	_tmp9_ = ibus_property_get_icon (_tmp8_);
	prop_tool_button_set_icon_name (self, _tmp9_);
	_tmp10_ = self->priv->m_prop;
	_tmp11_ = ibus_property_get_visible (_tmp10_);
	if (_tmp11_) {
		gtk_widget_show ((GtkWidget*) self);
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
}


static void prop_tool_button_real_clicked (GtkToolButton* base) {
	PropToolButton * self;
	IBusProperty* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	IBusProperty* _tmp2_ = NULL;
	IBusPropState _tmp3_ = 0;
	self = (PropToolButton*) base;
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_key (_tmp0_);
	_tmp2_ = self->priv->m_prop;
	_tmp3_ = ibus_property_get_state (_tmp2_);
	g_signal_emit_by_name ((IPropToolItem*) self, "property-activate", _tmp1_, (gint) _tmp3_);
}


void prop_tool_button_set_icon_name (PropToolButton* self, const gchar* icon_name) {
	gchar* label = NULL;
	IBusProperty* _tmp0_ = NULL;
	IBusText* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	IconWidget* icon_widget = NULL;
	const gchar* _tmp4_ = NULL;
	IconWidget* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	label = _tmp3_;
	icon_widget = NULL;
	_tmp4_ = label;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		const gchar* _tmp5_ = NULL;
		IconWidget* _tmp6_ = NULL;
		_g_free0 (label);
		label = NULL;
		_tmp5_ = icon_name;
		_tmp6_ = icon_widget_new (_tmp5_, GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (icon_widget);
		icon_widget = _tmp6_;
		gtk_tool_item_set_is_important ((GtkToolItem*) self, FALSE);
	} else {
		gtk_tool_item_set_is_important ((GtkToolItem*) self, TRUE);
	}
	_tmp7_ = icon_widget;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) self, (GtkWidget*) _tmp7_);
	_g_object_unref0 (icon_widget);
	_g_free0 (label);
}


static void prop_tool_button_class_init (PropToolButtonClass * klass) {
	prop_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PropToolButtonPrivate));
	GTK_TOOL_BUTTON_CLASS (klass)->clicked = prop_tool_button_real_clicked;
	G_OBJECT_CLASS (klass)->finalize = prop_tool_button_finalize;
}


static void prop_tool_button_iprop_tool_item_interface_init (IPropToolItemIface * iface) {
	prop_tool_button_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*)(IPropToolItem*, IBusProperty*)) prop_tool_button_real_update_property;
}


static void prop_tool_button_instance_init (PropToolButton * self) {
	self->priv = PROP_TOOL_BUTTON_GET_PRIVATE (self);
	self->priv->m_prop = NULL;
}


static void prop_tool_button_finalize (GObject* obj) {
	PropToolButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROP_TOOL_BUTTON, PropToolButton);
	_g_object_unref0 (self->priv->m_prop);
	G_OBJECT_CLASS (prop_tool_button_parent_class)->finalize (obj);
}


GType prop_tool_button_get_type (void) {
	static volatile gsize prop_tool_button_type_id__volatile = 0;
	if (g_once_init_enter (&prop_tool_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropToolButton), 0, (GInstanceInitFunc) prop_tool_button_instance_init, NULL };
		static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_tool_button_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType prop_tool_button_type_id;
		prop_tool_button_type_id = g_type_register_static (GTK_TYPE_TOOL_BUTTON, "PropToolButton", &g_define_type_info, 0);
		g_type_add_interface_static (prop_tool_button_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
		g_once_init_leave (&prop_tool_button_type_id__volatile, prop_tool_button_type_id);
	}
	return prop_tool_button_type_id__volatile;
}


PropToggleToolButton* prop_toggle_tool_button_construct (GType object_type, IBusProperty* prop) {
	PropToggleToolButton * self = NULL;
	IBusProperty* _tmp0_ = NULL;
	IBusProperty* _tmp1_ = NULL;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropToggleToolButton*) g_object_new (object_type, NULL);
	_tmp0_ = prop;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->m_prop);
	self->priv->m_prop = _tmp1_;
	gtk_tool_item_set_homogeneous ((GtkToolItem*) self, FALSE);
	prop_toggle_tool_button_sync (self);
	return self;
}


PropToggleToolButton* prop_toggle_tool_button_new (IBusProperty* prop) {
	return prop_toggle_tool_button_construct (TYPE_PROP_TOGGLE_TOOL_BUTTON, prop);
}


void prop_toggle_tool_button_set_property (PropToggleToolButton* self, IBusProperty* prop) {
	IBusProperty* _tmp0_ = NULL;
	IBusProperty* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->m_prop);
	self->priv->m_prop = _tmp1_;
	prop_toggle_tool_button_sync (self);
}


static void prop_toggle_tool_button_real_update_property (IPropToolItem* base, IBusProperty* prop) {
	PropToggleToolButton * self;
	IBusProperty* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	IBusProperty* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	IBusProperty* _tmp4_ = NULL;
	IBusProperty* _tmp5_ = NULL;
	IBusText* _tmp6_ = NULL;
	IBusProperty* _tmp7_ = NULL;
	IBusProperty* _tmp8_ = NULL;
	IBusText* _tmp9_ = NULL;
	IBusProperty* _tmp10_ = NULL;
	IBusProperty* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	IBusProperty* _tmp13_ = NULL;
	IBusProperty* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	IBusProperty* _tmp16_ = NULL;
	IBusProperty* _tmp17_ = NULL;
	IBusPropState _tmp18_ = 0;
	IBusProperty* _tmp19_ = NULL;
	IBusProperty* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	self = (PropToggleToolButton*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_key (_tmp0_);
	_tmp2_ = prop;
	_tmp3_ = ibus_property_get_key (_tmp2_);
	if (g_strcmp0 (_tmp1_, _tmp3_) != 0) {
		return;
	}
	_tmp4_ = self->priv->m_prop;
	_tmp5_ = prop;
	_tmp6_ = ibus_property_get_symbol (_tmp5_);
	ibus_property_set_symbol (_tmp4_, _tmp6_);
	_tmp7_ = self->priv->m_prop;
	_tmp8_ = prop;
	_tmp9_ = ibus_property_get_tooltip (_tmp8_);
	ibus_property_set_tooltip (_tmp7_, _tmp9_);
	_tmp10_ = self->priv->m_prop;
	_tmp11_ = prop;
	_tmp12_ = ibus_property_get_sensitive (_tmp11_);
	ibus_property_set_sensitive (_tmp10_, _tmp12_);
	_tmp13_ = self->priv->m_prop;
	_tmp14_ = prop;
	_tmp15_ = ibus_property_get_icon (_tmp14_);
	ibus_property_set_icon (_tmp13_, _tmp15_);
	_tmp16_ = self->priv->m_prop;
	_tmp17_ = prop;
	_tmp18_ = ibus_property_get_state (_tmp17_);
	ibus_property_set_state (_tmp16_, _tmp18_);
	_tmp19_ = self->priv->m_prop;
	_tmp20_ = prop;
	_tmp21_ = ibus_property_get_visible (_tmp20_);
	ibus_property_set_visible (_tmp19_, _tmp21_);
	prop_toggle_tool_button_sync (self);
}


static void prop_toggle_tool_button_sync (PropToggleToolButton* self) {
	IBusProperty* _tmp0_ = NULL;
	IBusText* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	IBusProperty* _tmp3_ = NULL;
	IBusText* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	IBusProperty* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	IBusProperty* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	IBusProperty* _tmp10_ = NULL;
	IBusPropState _tmp11_ = 0;
	IBusProperty* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	gtk_tool_button_set_label ((GtkToolButton*) self, _tmp2_);
	_tmp3_ = self->priv->m_prop;
	_tmp4_ = ibus_property_get_tooltip (_tmp3_);
	_tmp5_ = ibus_text_get_text (_tmp4_);
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) self, _tmp5_);
	_tmp6_ = self->priv->m_prop;
	_tmp7_ = ibus_property_get_sensitive (_tmp6_);
	gtk_widget_set_sensitive ((GtkWidget*) self, _tmp7_);
	_tmp8_ = self->priv->m_prop;
	_tmp9_ = ibus_property_get_icon (_tmp8_);
	prop_toggle_tool_button_set_icon_name (self, _tmp9_);
	_tmp10_ = self->priv->m_prop;
	_tmp11_ = ibus_property_get_state (_tmp10_);
	gtk_toggle_tool_button_set_active ((GtkToggleToolButton*) self, _tmp11_ == PROP_STATE_CHECKED);
	_tmp12_ = self->priv->m_prop;
	_tmp13_ = ibus_property_get_visible (_tmp12_);
	if (_tmp13_) {
		gtk_widget_show ((GtkWidget*) self);
	} else {
		gtk_widget_hide ((GtkWidget*) self);
	}
}


static void prop_toggle_tool_button_real_toggled (GtkToggleToolButton* base) {
	PropToggleToolButton * self;
	gboolean do_emit = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp7_ = FALSE;
	self = (PropToggleToolButton*) base;
	do_emit = FALSE;
	_tmp0_ = gtk_toggle_tool_button_get_active ((GtkToggleToolButton*) self);
	if (_tmp0_) {
		IBusProperty* _tmp1_ = NULL;
		IBusPropState _tmp2_ = 0;
		IBusProperty* _tmp3_ = NULL;
		_tmp1_ = self->priv->m_prop;
		_tmp2_ = ibus_property_get_state (_tmp1_);
		if (_tmp2_ != PROP_STATE_CHECKED) {
			do_emit = TRUE;
		}
		_tmp3_ = self->priv->m_prop;
		ibus_property_set_state (_tmp3_, PROP_STATE_CHECKED);
	} else {
		IBusProperty* _tmp4_ = NULL;
		IBusPropState _tmp5_ = 0;
		IBusProperty* _tmp6_ = NULL;
		_tmp4_ = self->priv->m_prop;
		_tmp5_ = ibus_property_get_state (_tmp4_);
		if (_tmp5_ != PROP_STATE_UNCHECKED) {
			do_emit = TRUE;
		}
		_tmp6_ = self->priv->m_prop;
		ibus_property_set_state (_tmp6_, PROP_STATE_UNCHECKED);
	}
	_tmp7_ = do_emit;
	if (_tmp7_) {
		IBusProperty* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		IBusProperty* _tmp10_ = NULL;
		IBusPropState _tmp11_ = 0;
		_tmp8_ = self->priv->m_prop;
		_tmp9_ = ibus_property_get_key (_tmp8_);
		_tmp10_ = self->priv->m_prop;
		_tmp11_ = ibus_property_get_state (_tmp10_);
		g_signal_emit_by_name ((IPropToolItem*) self, "property-activate", _tmp9_, (gint) _tmp11_);
	}
}


void prop_toggle_tool_button_set_icon_name (PropToggleToolButton* self, const gchar* icon_name) {
	gchar* label = NULL;
	IBusProperty* _tmp0_ = NULL;
	IBusText* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	IconWidget* icon_widget = NULL;
	const gchar* _tmp4_ = NULL;
	IconWidget* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_name != NULL);
	_tmp0_ = self->priv->m_prop;
	_tmp1_ = ibus_property_get_symbol (_tmp0_);
	_tmp2_ = ibus_text_get_text (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	label = _tmp3_;
	icon_widget = NULL;
	_tmp4_ = label;
	if (g_strcmp0 (_tmp4_, "") == 0) {
		const gchar* _tmp5_ = NULL;
		IconWidget* _tmp6_ = NULL;
		_g_free0 (label);
		label = NULL;
		_tmp5_ = icon_name;
		_tmp6_ = icon_widget_new (_tmp5_, GTK_ICON_SIZE_BUTTON);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (icon_widget);
		icon_widget = _tmp6_;
		gtk_tool_item_set_is_important ((GtkToolItem*) self, FALSE);
	} else {
		gtk_tool_item_set_is_important ((GtkToolItem*) self, TRUE);
	}
	_tmp7_ = icon_widget;
	gtk_tool_button_set_icon_widget ((GtkToolButton*) self, (GtkWidget*) _tmp7_);
	_g_object_unref0 (icon_widget);
	_g_free0 (label);
}


static void prop_toggle_tool_button_class_init (PropToggleToolButtonClass * klass) {
	prop_toggle_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PropToggleToolButtonPrivate));
	GTK_TOGGLE_TOOL_BUTTON_CLASS (klass)->toggled = prop_toggle_tool_button_real_toggled;
	G_OBJECT_CLASS (klass)->finalize = prop_toggle_tool_button_finalize;
}


static void prop_toggle_tool_button_iprop_tool_item_interface_init (IPropToolItemIface * iface) {
	prop_toggle_tool_button_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*)(IPropToolItem*, IBusProperty*)) prop_toggle_tool_button_real_update_property;
}


static void prop_toggle_tool_button_instance_init (PropToggleToolButton * self) {
	self->priv = PROP_TOGGLE_TOOL_BUTTON_GET_PRIVATE (self);
	self->priv->m_prop = NULL;
}


static void prop_toggle_tool_button_finalize (GObject* obj) {
	PropToggleToolButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton);
	_g_object_unref0 (self->priv->m_prop);
	G_OBJECT_CLASS (prop_toggle_tool_button_parent_class)->finalize (obj);
}


GType prop_toggle_tool_button_get_type (void) {
	static volatile gsize prop_toggle_tool_button_type_id__volatile = 0;
	if (g_once_init_enter (&prop_toggle_tool_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropToggleToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_toggle_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropToggleToolButton), 0, (GInstanceInitFunc) prop_toggle_tool_button_instance_init, NULL };
		static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_toggle_tool_button_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType prop_toggle_tool_button_type_id;
		prop_toggle_tool_button_type_id = g_type_register_static (GTK_TYPE_TOGGLE_TOOL_BUTTON, "PropToggleToolButton", &g_define_type_info, 0);
		g_type_add_interface_static (prop_toggle_tool_button_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
		g_once_init_leave (&prop_toggle_tool_button_type_id__volatile, prop_toggle_tool_button_type_id);
	}
	return prop_toggle_tool_button_type_id__volatile;
}


static void __lambda19_ (PropMenuToolButton* self, GtkMenuShell* m) {
	g_return_if_fail (m != NULL);
	gtk_toggle_tool_button_set_active ((GtkToggleToolButton*) self, FALSE);
}


static void ___lambda19__gtk_menu_shell_deactivate (GtkMenuShell* _sender, gpointer self) {
	__lambda19_ (self, _sender);
}


static void __lambda20_ (PropMenuToolButton* self, IPropToolItem* w, const gchar* k, gint s) {
	const gchar* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	g_return_if_fail (w != NULL);
	g_return_if_fail (k != NULL);
	_tmp0_ = k;
	_tmp1_ = s;
	g_signal_emit_by_name ((IPropToolItem*) self, "property-activate", _tmp0_, _tmp1_);
}


static void ___lambda20__iprop_tool_item_property_activate (IPropToolItem* _sender, const gchar* key, gint state, gpointer self) {
	__lambda20_ (self, _sender, key, state);
}


PropMenuToolButton* prop_menu_tool_button_construct (GType object_type, IBusProperty* prop) {
	PropMenuToolButton * self = NULL;
	IBusProperty* _tmp0_ = NULL;
	PropMenu* _tmp1_ = NULL;
	PropMenu* _tmp2_ = NULL;
	PropMenu* _tmp3_ = NULL;
	IBusProperty* _tmp4_ = NULL;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropMenuToolButton*) g_object_new (object_type, NULL);
	_tmp0_ = prop;
	_tmp1_ = prop_menu_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->m_menu);
	self->priv->m_menu = _tmp1_;
	_tmp2_ = self->priv->m_menu;
	g_signal_connect_object ((GtkMenuShell*) _tmp2_, "deactivate", (GCallback) ___lambda19__gtk_menu_shell_deactivate, self, 0);
	_tmp3_ = self->priv->m_menu;
	g_signal_connect_object ((IPropToolItem*) _tmp3_, "property-activate", (GCallback) ___lambda20__iprop_tool_item_property_activate, self, 0);
	_tmp4_ = prop;
	prop_toggle_tool_button_set_property (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton), _tmp4_);
	return self;
}


PropMenuToolButton* prop_menu_tool_button_new (IBusProperty* prop) {
	return prop_menu_tool_button_construct (TYPE_PROP_MENU_TOOL_BUTTON, prop);
}


static void prop_menu_tool_button_real_update_property (IPropToolItem* base, IBusProperty* prop) {
	PropMenuToolButton * self;
	IBusProperty* _tmp0_ = NULL;
	PropMenu* _tmp1_ = NULL;
	IBusProperty* _tmp2_ = NULL;
	self = (PropMenuToolButton*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = prop;
	prop_menu_tool_button_iprop_tool_item_parent_iface->update_property ((IPropToolItem*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton), _tmp0_);
	_tmp1_ = self->priv->m_menu;
	_tmp2_ = prop;
	iprop_tool_item_update_property ((IPropToolItem*) _tmp1_, _tmp2_);
}


static void prop_menu_tool_button_real_toggled (GtkToggleToolButton* base) {
	PropMenuToolButton * self;
	gboolean _tmp0_ = FALSE;
	self = (PropMenuToolButton*) base;
	_tmp0_ = gtk_toggle_tool_button_get_active ((GtkToggleToolButton*) self);
	if (_tmp0_) {
		PropMenu* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp1_ = self->priv->m_menu;
		_tmp2_ = gtk_get_current_event_time ();
		prop_menu_popup (_tmp1_, (guint) 0, _tmp2_, (GtkWidget*) self);
	}
}


static void prop_menu_tool_button_real_destroy (GtkWidget* base) {
	PropMenuToolButton * self;
	self = (PropMenuToolButton*) base;
	_g_object_unref0 (self->priv->m_menu);
	self->priv->m_menu = NULL;
	GTK_WIDGET_CLASS (prop_menu_tool_button_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_PROP_TOGGLE_TOOL_BUTTON, PropToggleToolButton));
}


static void prop_menu_tool_button_class_init (PropMenuToolButtonClass * klass) {
	prop_menu_tool_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PropMenuToolButtonPrivate));
	GTK_TOGGLE_TOOL_BUTTON_CLASS (klass)->toggled = prop_menu_tool_button_real_toggled;
	GTK_WIDGET_CLASS (klass)->destroy = prop_menu_tool_button_real_destroy;
	G_OBJECT_CLASS (klass)->finalize = prop_menu_tool_button_finalize;
}


static void prop_menu_tool_button_iprop_tool_item_interface_init (IPropToolItemIface * iface) {
	prop_menu_tool_button_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*)(IPropToolItem*, IBusProperty*)) prop_menu_tool_button_real_update_property;
}


static void prop_menu_tool_button_instance_init (PropMenuToolButton * self) {
	self->priv = PROP_MENU_TOOL_BUTTON_GET_PRIVATE (self);
	self->priv->m_menu = NULL;
}


static void prop_menu_tool_button_finalize (GObject* obj) {
	PropMenuToolButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PROP_MENU_TOOL_BUTTON, PropMenuToolButton);
	_g_object_unref0 (self->priv->m_menu);
	G_OBJECT_CLASS (prop_menu_tool_button_parent_class)->finalize (obj);
}


GType prop_menu_tool_button_get_type (void) {
	static volatile gsize prop_menu_tool_button_type_id__volatile = 0;
	if (g_once_init_enter (&prop_menu_tool_button_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropMenuToolButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_menu_tool_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropMenuToolButton), 0, (GInstanceInitFunc) prop_menu_tool_button_instance_init, NULL };
		static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_menu_tool_button_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType prop_menu_tool_button_type_id;
		prop_menu_tool_button_type_id = g_type_register_static (TYPE_PROP_TOGGLE_TOOL_BUTTON, "PropMenuToolButton", &g_define_type_info, 0);
		g_type_add_interface_static (prop_menu_tool_button_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
		g_once_init_leave (&prop_menu_tool_button_type_id__volatile, prop_menu_tool_button_type_id);
	}
	return prop_menu_tool_button_type_id__volatile;
}


PropSeparatorToolItem* prop_separator_tool_item_construct (GType object_type, IBusProperty* prop) {
	PropSeparatorToolItem * self = NULL;
	g_return_val_if_fail (prop != NULL, NULL);
	self = (PropSeparatorToolItem*) g_object_new (object_type, NULL);
	gtk_tool_item_set_homogeneous ((GtkToolItem*) self, FALSE);
	return self;
}


PropSeparatorToolItem* prop_separator_tool_item_new (IBusProperty* prop) {
	return prop_separator_tool_item_construct (TYPE_PROP_SEPARATOR_TOOL_ITEM, prop);
}


static void prop_separator_tool_item_real_update_property (IPropToolItem* base, IBusProperty* prop) {
	PropSeparatorToolItem * self;
	self = (PropSeparatorToolItem*) base;
	g_return_if_fail (prop != NULL);
}


static void prop_separator_tool_item_class_init (PropSeparatorToolItemClass * klass) {
	prop_separator_tool_item_parent_class = g_type_class_peek_parent (klass);
}


static void prop_separator_tool_item_iprop_tool_item_interface_init (IPropToolItemIface * iface) {
	prop_separator_tool_item_iprop_tool_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_property = (void (*)(IPropToolItem*, IBusProperty*)) prop_separator_tool_item_real_update_property;
}


static void prop_separator_tool_item_instance_init (PropSeparatorToolItem * self) {
}


GType prop_separator_tool_item_get_type (void) {
	static volatile gsize prop_separator_tool_item_type_id__volatile = 0;
	if (g_once_init_enter (&prop_separator_tool_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PropSeparatorToolItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prop_separator_tool_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PropSeparatorToolItem), 0, (GInstanceInitFunc) prop_separator_tool_item_instance_init, NULL };
		static const GInterfaceInfo iprop_tool_item_info = { (GInterfaceInitFunc) prop_separator_tool_item_iprop_tool_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType prop_separator_tool_item_type_id;
		prop_separator_tool_item_type_id = g_type_register_static (GTK_TYPE_SEPARATOR_TOOL_ITEM, "PropSeparatorToolItem", &g_define_type_info, 0);
		g_type_add_interface_static (prop_separator_tool_item_type_id, TYPE_IPROP_TOOL_ITEM, &iprop_tool_item_info);
		g_once_init_leave (&prop_separator_tool_item_type_id__volatile, prop_separator_tool_item_type_id);
	}
	return prop_separator_tool_item_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



