/***************************************************************************
 *   Copyright © 2009-2010 Harald Sitter <apachelogger@ubuntu.com>         *
 *   Copyright © 2009-2010 Jonathan Thomas <echidnaman@kubuntu.org>        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU General Public License as        *
 *   published by the Free Software Foundation; either version 2 of        *
 *   the License or (at your option) version 3 or any later version        *
 *   accepted by the membership of KDE e.V. (or its successor approved     *
 *   by the membership of KDE e.V.), which shall act as a proxy            *
 *   defined in Section 14 of version 3 of the license.                    *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#include "kubuntufirefoxinstaller.h"

#include <QStringBuilder>

#include <KIcon>
#include <KProcess>

KubuntuFirefoxInstaller::KubuntuFirefoxInstaller(QWidget* parent)
        : QMainWindow(parent)
{
    QString appName = i18n("Mozilla Firefox Installer");

    ui_mainwindow.setupUi(this);

    KIcon icon("firefox-installer");
    setWindowIcon(icon);

    setWindowTitle(appName);

    ui_mainwindow.welcome_heading_label->setText("<h1>" % appName % "</h1>");

    ui_mainwindow.image_label->setMargin(50);
    ui_mainwindow.image_label->setPixmap(icon.pixmap(128,128));

    ui_mainwindow.install_button->setIcon(KIcon("list-add"));
    ui_mainwindow.install_button->setIconSize(QSize(16,16));
    ui_mainwindow.install_button->setText(i18n("Install"));
    connect(ui_mainwindow.install_button, SIGNAL(released()), this,
            SLOT(invokeInstall()));

    ui_mainwindow.quit_button->setIcon(KIcon("application-exit"));
    ui_mainwindow.quit_button->setIconSize(QSize(16, 16));
    ui_mainwindow.quit_button->setText(i18n("Exit"));

    ui_mainwindow.text_label->setMargin(20);
    ui_mainwindow.text_label->setWordWrap(true);
    ui_mainwindow.text_label->setAlignment(Qt::AlignTop|Qt::AlignLeading|
                                           Qt::AlignLeft);
    ui_mainwindow.text_label->setText(i18n("Mozilla Firefox is the popular, "
                                           "award-winning web browser used by "
                                           "millions for its simplicity, "
                                           "security features and sizable "
                                           "collection of addons."));

    setWindowState(Qt::WindowFullScreen);
}

KubuntuFirefoxInstaller::~KubuntuFirefoxInstaller()
{
}

void KubuntuFirefoxInstaller::invokeInstall()
{
    hide();
    KProcess::startDetached("kubuntu-firefox-installer", QStringList() << "-i");
    close();
}

#include "kubuntufirefoxinstaller.moc"
