/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-preinstalled-application-info.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */


#ifndef __UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO_H
#define __UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO_H

#include "unity-webapps-application-info.h"


#define UNITY_WEBAPPS_TYPE_PREINSTALLED_APPLICATION_INFO              (unity_webapps_preinstalled_application_info_get_type())
#define UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), UNITY_WEBAPPS_TYPE_PREINSTALLED_APPLICATION_INFO, UnityWebappsPreinstalledApplicationInfo))
#define UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), UNITY_WEBAPPS_TYPE_PREINSTALLED_APPLICATION_INFO, UnityWebappsPreinstalledApplicationInfoClass))
#define UNITY_WEBAPPS_IS_PREINSTALLED_APPLICATION_INFO(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), UNITY_WEBAPPS_TYPE_PREINSTALLED_APPLICATION_INFO))
#define UNITY_WEBAPPS_IS_PREINSTALLED_APPLICATION_INFO_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_WEBAPPS_TYPE_PREINSTALLED_APPLICATION_INFO))
#define UNITY_WEBAPPS_PREINSTALLED_APPLICATION_INFO_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), UNITY_WEBAPPS_TYPE_PREINSTALLED_APPLICATION_INFO, UnityWebappsPreinstalledApplicationInfoClass))

typedef struct _UnityWebappsPreinstalledApplicationInfoPrivate UnityWebappsPreinstalledApplicationInfoPrivate;

typedef struct _UnityWebappsPreinstalledApplicationInfo UnityWebappsPreinstalledApplicationInfo;


struct _UnityWebappsPreinstalledApplicationInfo {
	UnityWebappsApplicationInfo object;
	
	UnityWebappsPreinstalledApplicationInfoPrivate *priv;
};

typedef struct _UnityWebappsPreinstalledApplicationInfoClass UnityWebappsPreinstalledApplicationInfoClass;

struct _UnityWebappsPreinstalledApplicationInfoClass
{
	UnityWebappsApplicationInfoClass parent_class;
};

GType unity_webapps_preinstalled_application_info_get_type (void) G_GNUC_CONST;

UnityWebappsApplicationInfo *unity_webapps_preinstalled_application_info_new (const gchar *name,
																			  const gchar *domain,
																			  const gchar *icon_url,
																			  const gchar *mime_types,
																			  const gchar *desktop_name);

#endif
