/*
 * unity-webapps-debug.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 * 
 unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#include "unity-webapps-debug.h"
#include <string.h>

guint unity_webapps_debug_flags = 0;

void
unity_webapps_debug_initialize_flags ()
{
  const gchar *flags;
  
  flags = g_getenv("UNITY_WEBAPPS_DEBUG_FLAGS");
  
  if ((flags == NULL) ||
      (strlen(flags) == 0))
    {
      return;
    }
  
  unity_webapps_debug_flags |= g_parse_debug_string (flags,
						     unity_webapps_debug_keys,
						     G_N_ELEMENTS (unity_webapps_debug_keys));
}
