/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * view-activity-tracker.c
 * Copyright (C) Canonical LTD 2011
 *
 * Author: Robert Carr <racarr@canonical.com>
 *
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

static UnityWebappsService *service = NULL;
static GMainLoop *mainloop = NULL;

void
print_context_for_name (const gchar *name)
{
	UnityWebappsContext *context;
	const gchar *cname;
	const gchar *domain;

	context = unity_webapps_context_new_for_context_name (service, name);

	if (context == NULL)
		{
			return;
		}

	cname = unity_webapps_context_get_name (context);
	domain = unity_webapps_context_get_domain (context);

	gint interests = g_variant_n_children (unity_webapps_context_list_interests (context));
	printf("Context (%s), %s (%s) interest #%d\n", name, cname, domain, interests);

	g_object_unref (G_OBJECT (context));
}

void
print_context_list ()
{
	gchar **context;
	gchar **context_list = unity_webapps_service_list_contexts (service);

	printf("===== Listing Contexts ===== \n");

	for (context = context_list; context && *context; context++)
		{
			if (strlen (*context) == 0)
				continue;
			print_context_for_name (*context);
		}
	printf("================================\n");

	g_strfreev (context_list);
}

static void
on_interest_appeared (UnityWebappsContext *context, gint id, gpointer data)
{
	printf("interest appeared\n");
	print_context_list ();
}

static void
on_interest_vanished (UnityWebappsContext *context, gint id, gpointer data)
{
	printf("interest vanished\n");
	print_context_list ();
}

static void
on_context_appeared (UnityWebappsService *service,
					 const gchar *name,
					 gpointer user_data)
{
	UnityWebappsContext *context;

	context = unity_webapps_context_new_for_context_name (service, name);

	unity_webapps_context_on_interest_appeared (context, on_interest_appeared, NULL);
	unity_webapps_context_on_interest_vanished (context, on_interest_vanished, NULL);

	printf("Context appeared \n");
	print_context_list ();
}

static void
on_context_vanished (UnityWebappsService *service,
					 const gchar *name,
					 gpointer user_data)
{
	printf("Context vanished \n");
	print_context_list ();
}


gint
main (gint argc, gchar **argv)
{
	g_type_init ();

	service = unity_webapps_service_new ();

	print_context_list ();

	unity_webapps_service_on_context_appeared (service, on_context_appeared, NULL);
	unity_webapps_service_on_context_vanished (service, on_context_vanished, NULL);

	mainloop = g_main_loop_new (NULL, FALSE);

	g_main_loop_run (mainloop);

	exit (0);
}
