#include <gio/gio.h>

#include "unity-webapps-application-manifest.h"
#include "unity-webapps-application-collector.h"
#include "unity-webapps-debug.h"

typedef struct _ManifestTestFixture {
  UnityWebappsApplicationCollector *collector;
} ManifestTestFixture;


static void
setup_fixture_simple (ManifestTestFixture *fixture, gconstpointer user_data)
{
  const gchar *path[] = {TEST_DATA, NULL};
  fixture->collector = unity_webapps_application_collector_new (path);
}


static void
teardown_fixture_simple (ManifestTestFixture *fixture, gconstpointer user_data)
{
  g_object_unref (G_OBJECT (fixture->collector));
}

static void
test_load_simple_collection_1 (ManifestTestFixture *fixture, gconstpointer user_data)
{
  g_assert (unity_webapps_application_collector_search_path (fixture->collector));
  g_assert (g_hash_table_size (unity_webapps_application_collector_get_applications (fixture->collector)) == 6);
}

int 
main (int argc, char **argv)
{
  g_type_init ();
  g_test_init (&argc, &argv, NULL);
  
  unity_webapps_debug_initialize_flags ();
  
  g_test_add("/Applications/Collector/Simple/Load", ManifestTestFixture, NULL,
	     setup_fixture_simple, test_load_simple_collection_1, teardown_fixture_simple);
  
  return g_test_run ();
}
