#include <stdlib.h>
#include <stdio.h>

#include "unity-webapps-service.h"
#include "unity-webapps-context.h"

#include "uwa-test-client.h"

#define ICON_URL "http://www.ubuntu.com/sites/www.ubuntu.com/files/active/02_ubuntu/U_homepage/picto-desktop.png"

static GMainLoop *mainloop = NULL;

static guint callbacks = 0;

static void
on_action_one(UnityWebappsContext *context, gpointer user_data)
{
  callbacks ++;
  
  printf("Action one invoked\n");
}
static void
on_action_two (UnityWebappsContext *context, gpointer user_data)
{
  callbacks ++;
  
  printf("Action two invoked\n");
}

static void
on_action_three(UnityWebappsContext *context, gpointer user_data)
{
  callbacks ++;
  
  printf("Action three invoked\n");
}
static void
on_action_four (UnityWebappsContext *context, gpointer user_data)
{
  callbacks ++;
  
  printf("Action four invoked\n");
  
  if (callbacks == 4)
    {
      uwa_emit_test_finished ();
    }
}

static void
context_ready (UnityWebappsContext *context, gpointer user_data)
{
  UnityWebappsApplicationActionDesc arg[] = {{"/foo/bar/baz", on_action_one, NULL},
                                             {"/foo/bar/doublebar", on_action_two, NULL},
                                             {"/foo/baz/bar", on_action_three, NULL},
                                             {"/foot/boo/yaz", on_action_four, NULL}};
  unity_webapps_context_add_application_actions (context, arg, 4);
}

gint
main (gint argc, gchar **argv)
{
  UnityWebappsService *service;
  
  g_type_init ();
  
  service = unity_webapps_service_new ();
  
  unity_webapps_context_new (service, "Test", "test.ts", ICON_URL, NULL, context_ready, NULL);
  
  mainloop = g_main_loop_new (NULL, FALSE);
  
  g_main_loop_run (mainloop);
  
  return 0;  
}
