/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_OCCLUSION_QUERY},
	{93, PKT3_SET_PREDICATION},
	{109, PKT3_COND_EXEC},
	{119, PKT3_PRED_EXEC},
	{129, PKT3_DRAW_INDIRECT},
	{143, PKT3_DRAW_INDEX_INDIRECT},
	{163, PKT3_INDEX_BASE},
	{174, PKT3_DRAW_INDEX_2},
	{187, PKT3_CONTEXT_CONTROL},
	{203, PKT3_INDEX_TYPE},
	{214, PKT3_DRAW_INDIRECT_MULTI},
	{234, PKT3_DRAW_INDEX_AUTO},
	{250, PKT3_DRAW_INDEX_IMMD},
	{266, PKT3_NUM_INSTANCES},
	{280, PKT3_DRAW_INDEX_MULTI_AUTO},
	{302, PKT3_INDIRECT_BUFFER_SI},
	{321, PKT3_INDIRECT_BUFFER_CONST},
	{343, PKT3_STRMOUT_BUFFER_UPDATE},
	{365, PKT3_DRAW_INDEX_OFFSET_2},
	{385, PKT3_WRITE_DATA},
	{396, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{422, PKT3_MEM_SEMAPHORE},
	{436, PKT3_MPEG_INDEX},
	{447, PKT3_WAIT_REG_MEM},
	{460, PKT3_MEM_WRITE},
	{470, PKT3_INDIRECT_BUFFER_CIK},
	{490, PKT3_COPY_DATA},
	{500, PKT3_PFP_SYNC_ME},
	{512, PKT3_SURFACE_SYNC},
	{525, PKT3_ME_INITIALIZE},
	{539, PKT3_COND_WRITE},
	{550, PKT3_EVENT_WRITE},
	{562, PKT3_EVENT_WRITE_EOP},
	{578, PKT3_RELEASE_MEM},
	{590, PKT3_ONE_REG_WRITE},
	{604, PKT3_ACQUIRE_MEM},
	{616, PKT3_SET_CONFIG_REG},
	{631, PKT3_SET_CONTEXT_REG},
	{647, PKT3_SET_SH_REG},
	{658, PKT3_SET_SH_REG_OFFSET},
	{676, PKT3_SET_UCONFIG_REG},
	{692, PKT3_LOAD_CONST_RAM},
	{707, PKT3_WRITE_CONST_RAM},
	{723, PKT3_DUMP_CONST_RAM},
	{738, PKT3_INCREMENT_CE_COUNTER},
	{759, PKT3_INCREMENT_DE_COUNTER},
	{780, PKT3_WAIT_ON_CE_COUNTER},
	{799, PKT3_IT_OPCODE_C},
	{811, PKT3_CP_DMA},
	{818, PKT3_DMA_DATA},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{827, S_2C3_COUNT_INDIRECT_ENABLE(~0u)},
	{849, S_2C3_DRAW_INDEX_ENABLE(~0u)},
	/* 2 */
	{877, S_370_ENGINE_SEL(~0u), 4, 0},
	{888, S_370_WR_CONFIRM(~0u)},
	{899, S_370_WR_ONE_ADDR(~0u)},
	{972, S_370_DST_SEL(~0u), 6, 4},
	/* 6 */
	{980, S_3F2_IB_SIZE(~0u)},
	{988, S_3F2_CHAIN(~0u)},
	{994, S_3F2_VALID(~0u)},
	/* 9 */
	{1000, S_410_SRC_ADDR_LO(~0u)},
	/* 10 */
	{1012, S_411_CP_SYNC(~0u)},
	{1044, S_411_SRC_SEL(~0u), 4, 10},
	{1052, S_411_ENGINE(~0u), 2, 0},
	{1083, S_411_DSL_SEL(~0u), 4, 14},
	{1091, S_411_SRC_ADDR_HI(~0u)},
	/* 15 */
	{1103, S_412_DST_ADDR_LO(~0u)},
	/* 16 */
	{1115, S_413_DST_ADDR_HI(~0u)},
	/* 17 */
	{1127, S_414_BYTE_COUNT(~0u)},
	{1138, S_414_DISABLE_WR_CONFIRM(~0u)},
	{1186, S_414_SRC_SWAP(~0u), 4, 18},
	{1195, S_414_DST_SWAP(~0u), 4, 18},
	{1211, S_414_SAS(~0u), 2, 22},
	{1215, S_414_DAS(~0u), 2, 22},
	{1242, S_414_SAIC(~0u), 2, 24},
	{1247, S_414_DAIC(~0u), 2, 24},
	{1252, S_414_RAW_WAIT(~0u)},
	/* 26 */
	{1012, S_500_CP_SYNC(~0u)},
	{1044, S_500_SRC_SEL(~0u), 4, 10},
	{1083, S_500_DSL_SEL(~0u), 4, 14},
	{1052, S_500_ENGINE(~0u), 2, 0},
	/* 30 */
	{1261, S_000E4C_SDMA_RQ_PENDING(~0u)},
	{1277, S_000E4C_TST_RQ_PENDING(~0u)},
	{1292, S_000E4C_SDMA1_RQ_PENDING(~0u)},
	{1309, S_000E4C_VCE0_RQ_PENDING(~0u)},
	{1325, S_000E4C_VP8_BUSY(~0u)},
	{1334, S_000E4C_SDMA_BUSY(~0u)},
	{1344, S_000E4C_SDMA1_BUSY(~0u)},
	{1355, S_000E4C_VCE0_BUSY(~0u)},
	{1365, S_000E4C_XDMA_BUSY(~0u)},
	{1375, S_000E4C_CHUB_BUSY(~0u)},
	{1385, S_000E4C_SDMA2_BUSY(~0u)},
	{1396, S_000E4C_SDMA3_BUSY(~0u)},
	{1407, S_000E4C_SAMSCP_BUSY(~0u)},
	{1419, S_000E4C_ISP_BUSY(~0u)},
	{1428, S_000E4C_VCE1_BUSY(~0u)},
	{1438, S_000E4C_ODE_BUSY(~0u)},
	{1447, S_000E4C_SDMA2_RQ_PENDING(~0u)},
	{1464, S_000E4C_SDMA3_RQ_PENDING(~0u)},
	{1481, S_000E4C_SAMSCP_RQ_PENDING(~0u)},
	{1499, S_000E4C_ISP_RQ_PENDING(~0u)},
	{1514, S_000E4C_VCE1_RQ_PENDING(~0u)},
	/* 51 */
	{1530, S_000E50_UVD_RQ_PENDING(~0u)},
	{1545, S_000E50_SAMMSP_RQ_PENDING(~0u)},
	{1563, S_000E50_ACP_RQ_PENDING(~0u)},
	{1578, S_000E50_SMU_RQ_PENDING(~0u)},
	{1593, S_000E50_GRBM_RQ_PENDING(~0u)},
	{1609, S_000E50_HI_RQ_PENDING(~0u)},
	{1623, S_000E50_VMC_BUSY(~0u)},
	{1632, S_000E50_MCB_BUSY(~0u)},
	{1641, S_000E50_MCB_NON_DISPLAY_BUSY(~0u)},
	{1662, S_000E50_MCC_BUSY(~0u)},
	{1671, S_000E50_MCD_BUSY(~0u)},
	{1680, S_000E50_VMC1_BUSY(~0u)},
	{1690, S_000E50_SEM_BUSY(~0u)},
	{1699, S_000E50_ACP_BUSY(~0u)},
	{1708, S_000E50_IH_BUSY(~0u)},
	{1716, S_000E50_UVD_BUSY(~0u)},
	{1725, S_000E50_SAMMSP_BUSY(~0u)},
	{1737, S_000E50_GCATCL2_BUSY(~0u)},
	{1750, S_000E50_OSATCL2_BUSY(~0u)},
	{1763, S_000E50_BIF_BUSY(~0u)},
	/* 71 */
	{1772, S_000E54_MCC0_BUSY(~0u)},
	{1782, S_000E54_MCC1_BUSY(~0u)},
	{1792, S_000E54_MCC2_BUSY(~0u)},
	{1802, S_000E54_MCC3_BUSY(~0u)},
	{1812, S_000E54_MCC4_BUSY(~0u)},
	{1822, S_000E54_MCC5_BUSY(~0u)},
	{1832, S_000E54_MCC6_BUSY(~0u)},
	{1842, S_000E54_MCC7_BUSY(~0u)},
	{1852, S_000E54_MCD0_BUSY(~0u)},
	{1862, S_000E54_MCD1_BUSY(~0u)},
	{1872, S_000E54_MCD2_BUSY(~0u)},
	{1882, S_000E54_MCD3_BUSY(~0u)},
	{1892, S_000E54_MCD4_BUSY(~0u)},
	{1902, S_000E54_MCD5_BUSY(~0u)},
	{1912, S_000E54_MCD6_BUSY(~0u)},
	{1922, S_000E54_MCD7_BUSY(~0u)},
	/* 87 */
	{1932, S_00D034_IDLE(~0u)},
	{1937, S_00D034_REG_IDLE(~0u)},
	{1946, S_00D034_RB_EMPTY(~0u)},
	{1955, S_00D034_RB_FULL(~0u)},
	{1963, S_00D034_RB_CMD_IDLE(~0u)},
	{1975, S_00D034_RB_CMD_FULL(~0u)},
	{1987, S_00D034_IB_CMD_IDLE(~0u)},
	{1999, S_00D034_IB_CMD_FULL(~0u)},
	{2011, S_00D034_BLOCK_IDLE(~0u)},
	{2022, S_00D034_INSIDE_IB(~0u)},
	{2032, S_00D034_EX_IDLE(~0u)},
	{2040, S_00D034_EX_IDLE_POLL_TIMER_EXPIRE(~0u)},
	{2066, S_00D034_PACKET_READY(~0u)},
	{2079, S_00D034_MC_WR_IDLE(~0u)},
	{2090, S_00D034_SRBM_IDLE(~0u)},
	{2100, S_00D034_CONTEXT_EMPTY(~0u)},
	{2114, S_00D034_DELTA_RPTR_FULL(~0u)},
	{2130, S_00D034_RB_MC_RREQ_IDLE(~0u)},
	{2146, S_00D034_IB_MC_RREQ_IDLE(~0u)},
	{2162, S_00D034_MC_RD_IDLE(~0u)},
	{2173, S_00D034_DELTA_RPTR_EMPTY(~0u)},
	{2190, S_00D034_MC_RD_RET_STALL(~0u)},
	{2206, S_00D034_MC_RD_NO_POLL_IDLE(~0u)},
	{2225, S_00D034_PREV_CMD_IDLE(~0u)},
	{2239, S_00D034_SEM_IDLE(~0u)},
	{2248, S_00D034_SEM_REQ_STALL(~0u)},
	{2262, S_00D034_SEM_RESP_STATE(~0u)},
	{2277, S_00D034_INT_IDLE(~0u)},
	{2286, S_00D034_INT_REQ_STALL(~0u)},
	/* 116 */
	{2300, S_008008_ME0PIPE1_CMDFIFO_AVAIL(~0u)},
	{2323, S_008008_ME0PIPE1_CF_RQ_PENDING(~0u)},
	{2346, S_008008_ME0PIPE1_PF_RQ_PENDING(~0u)},
	{2369, S_008008_ME1PIPE0_RQ_PENDING(~0u)},
	{2389, S_008008_ME1PIPE1_RQ_PENDING(~0u)},
	{2409, S_008008_ME1PIPE2_RQ_PENDING(~0u)},
	{2429, S_008008_ME1PIPE3_RQ_PENDING(~0u)},
	{2449, S_008008_ME2PIPE0_RQ_PENDING(~0u)},
	{2469, S_008008_ME2PIPE1_RQ_PENDING(~0u)},
	{2489, S_008008_ME2PIPE2_RQ_PENDING(~0u)},
	{2509, S_008008_ME2PIPE3_RQ_PENDING(~0u)},
	{2529, S_008008_RLC_RQ_PENDING(~0u)},
	{2544, S_008008_RLC_BUSY(~0u)},
	{2553, S_008008_TC_BUSY(~0u)},
	{2561, S_008008_TCC_CC_RESIDENT(~0u)},
	{2577, S_008008_CPF_BUSY(~0u)},
	{2586, S_008008_CPC_BUSY(~0u)},
	{2595, S_008008_CPG_BUSY(~0u)},
	/* 134 */
	{2604, S_008010_ME0PIPE0_CMDFIFO_AVAIL(~0u)},
	{2627, S_008010_SRBM_RQ_PENDING(~0u)},
	{2643, S_008010_ME0PIPE0_CF_RQ_PENDING(~0u)},
	{2666, S_008010_ME0PIPE0_PF_RQ_PENDING(~0u)},
	{2689, S_008010_GDS_DMA_RQ_PENDING(~0u)},
	{2708, S_008010_DB_CLEAN(~0u)},
	{2717, S_008010_CB_CLEAN(~0u)},
	{2726, S_008010_TA_BUSY(~0u)},
	{2734, S_008010_GDS_BUSY(~0u)},
	{2743, S_008010_WD_BUSY_NO_DMA(~0u)},
	{2758, S_008010_VGT_BUSY(~0u)},
	{2767, S_008010_IA_BUSY_NO_DMA(~0u)},
	{2782, S_008010_IA_BUSY(~0u)},
	{2790, S_008010_SX_BUSY(~0u)},
	{2798, S_008010_WD_BUSY(~0u)},
	{2806, S_008010_SPI_BUSY(~0u)},
	{2815, S_008010_BCI_BUSY(~0u)},
	{2824, S_008010_SC_BUSY(~0u)},
	{2832, S_008010_PA_BUSY(~0u)},
	{2840, S_008010_DB_BUSY(~0u)},
	{2848, S_008010_CP_COHERENCY_BUSY(~0u)},
	{1411, S_008010_CP_BUSY(~0u)},
	{1633, S_008010_CB_BUSY(~0u)},
	{2866, S_008010_GUI_ACTIVE(~0u)},
	/* 158 */
	{2877, S_0084FC_OFFSET_UPDATE_DONE(~0u)},
	/* 159 */
	{2896, S_0085F0_DEST_BASE_0_ENA(~0u)},
	{2912, S_0085F0_DEST_BASE_1_ENA(~0u)},
	{2928, S_0085F0_CB0_DEST_BASE_ENA(~0u)},
	{2946, S_0085F0_CB1_DEST_BASE_ENA(~0u)},
	{2964, S_0085F0_CB2_DEST_BASE_ENA(~0u)},
	{2982, S_0085F0_CB3_DEST_BASE_ENA(~0u)},
	{3000, S_0085F0_CB4_DEST_BASE_ENA(~0u)},
	{3018, S_0085F0_CB5_DEST_BASE_ENA(~0u)},
	{3036, S_0085F0_CB6_DEST_BASE_ENA(~0u)},
	{3054, S_0085F0_CB7_DEST_BASE_ENA(~0u)},
	{3072, S_0085F0_DB_DEST_BASE_ENA(~0u)},
	{3089, S_0085F0_DEST_BASE_2_ENA(~0u)},
	{3105, S_0085F0_DEST_BASE_3_ENA(~0u)},
	{3121, S_0085F0_TCL1_ACTION_ENA(~0u)},
	{3137, S_0085F0_TC_ACTION_ENA(~0u)},
	{3151, S_0085F0_CB_ACTION_ENA(~0u)},
	{3165, S_0085F0_DB_ACTION_ENA(~0u)},
	{3179, S_0085F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3200, S_0085F0_SH_ICACHE_ACTION_ENA(~0u)},
	/* 178 */
	{2708, S_008014_DB_CLEAN(~0u)},
	{2717, S_008014_CB_CLEAN(~0u)},
	{2815, S_008014_BCI_BUSY(~0u)},
	{2758, S_008014_VGT_BUSY(~0u)},
	{2832, S_008014_PA_BUSY(~0u)},
	{2726, S_008014_TA_BUSY(~0u)},
	{2790, S_008014_SX_BUSY(~0u)},
	{2806, S_008014_SPI_BUSY(~0u)},
	{2824, S_008014_SC_BUSY(~0u)},
	{2840, S_008014_DB_BUSY(~0u)},
	{1633, S_008014_CB_BUSY(~0u)},
	/* 189 */
	{2708, S_008018_DB_CLEAN(~0u)},
	{2717, S_008018_CB_CLEAN(~0u)},
	{2815, S_008018_BCI_BUSY(~0u)},
	{2758, S_008018_VGT_BUSY(~0u)},
	{2832, S_008018_PA_BUSY(~0u)},
	{2726, S_008018_TA_BUSY(~0u)},
	{2790, S_008018_SX_BUSY(~0u)},
	{2806, S_008018_SPI_BUSY(~0u)},
	{2824, S_008018_SC_BUSY(~0u)},
	{2840, S_008018_DB_BUSY(~0u)},
	{1633, S_008018_CB_BUSY(~0u)},
	/* 200 */
	{2708, S_008038_DB_CLEAN(~0u)},
	{2717, S_008038_CB_CLEAN(~0u)},
	{2815, S_008038_BCI_BUSY(~0u)},
	{2758, S_008038_VGT_BUSY(~0u)},
	{2832, S_008038_PA_BUSY(~0u)},
	{2726, S_008038_TA_BUSY(~0u)},
	{2790, S_008038_SX_BUSY(~0u)},
	{2806, S_008038_SPI_BUSY(~0u)},
	{2824, S_008038_SC_BUSY(~0u)},
	{2840, S_008038_DB_BUSY(~0u)},
	{1633, S_008038_CB_BUSY(~0u)},
	/* 211 */
	{2708, S_00803C_DB_CLEAN(~0u)},
	{2717, S_00803C_CB_CLEAN(~0u)},
	{2815, S_00803C_BCI_BUSY(~0u)},
	{2758, S_00803C_VGT_BUSY(~0u)},
	{2832, S_00803C_PA_BUSY(~0u)},
	{2726, S_00803C_TA_BUSY(~0u)},
	{2790, S_00803C_SX_BUSY(~0u)},
	{2806, S_00803C_SPI_BUSY(~0u)},
	{2824, S_00803C_SC_BUSY(~0u)},
	{2840, S_00803C_DB_BUSY(~0u)},
	{1633, S_00803C_CB_BUSY(~0u)},
	/* 222 */
	{2877, S_0300FC_OFFSET_UPDATE_DONE(~0u)},
	/* 223 */
	{3221, S_0301E4_COHER_BASE_HI_256B(~0u)},
	/* 224 */
	{3240, S_0301EC_START_DELAY_COUNT(~0u)},
	/* 225 */
	{2896, S_0301F0_DEST_BASE_0_ENA(~0u)},
	{2912, S_0301F0_DEST_BASE_1_ENA(~0u)},
	{3258, S_0301F0_TC_SD_ACTION_ENA(~0u)},
	{3275, S_0301F0_TC_NC_ACTION_ENA(~0u)},
	{2928, S_0301F0_CB0_DEST_BASE_ENA(~0u)},
	{2946, S_0301F0_CB1_DEST_BASE_ENA(~0u)},
	{2964, S_0301F0_CB2_DEST_BASE_ENA(~0u)},
	{2982, S_0301F0_CB3_DEST_BASE_ENA(~0u)},
	{3000, S_0301F0_CB4_DEST_BASE_ENA(~0u)},
	{3018, S_0301F0_CB5_DEST_BASE_ENA(~0u)},
	{3036, S_0301F0_CB6_DEST_BASE_ENA(~0u)},
	{3054, S_0301F0_CB7_DEST_BASE_ENA(~0u)},
	{3072, S_0301F0_DB_DEST_BASE_ENA(~0u)},
	{3292, S_0301F0_TCL1_VOL_ACTION_ENA(~0u)},
	{3312, S_0301F0_TC_VOL_ACTION_ENA(~0u)},
	{3330, S_0301F0_TC_WB_ACTION_ENA(~0u)},
	{3089, S_0301F0_DEST_BASE_2_ENA(~0u)},
	{3105, S_0301F0_DEST_BASE_3_ENA(~0u)},
	{3121, S_0301F0_TCL1_ACTION_ENA(~0u)},
	{3137, S_0301F0_TC_ACTION_ENA(~0u)},
	{3151, S_0301F0_CB_ACTION_ENA(~0u)},
	{3165, S_0301F0_DB_ACTION_ENA(~0u)},
	{3179, S_0301F0_SH_KCACHE_ACTION_ENA(~0u)},
	{3347, S_0301F0_SH_KCACHE_VOL_ACTION_ENA(~0u)},
	{3200, S_0301F0_SH_ICACHE_ACTION_ENA(~0u)},
	{3372, S_0301F0_SH_KCACHE_WB_ACTION_ENA(~0u)},
	{3396, S_0301F0_SH_SD_ACTION_ENA(~0u)},
	/* 252 */
	{3413, S_0301FC_MATCHING_GFX_CNTX(~0u)},
	{3431, S_0301FC_MEID(~0u)},
	{3436, S_0301FC_PHASE1_STATUS(~0u)},
	{3443, S_0301FC_STATUS(~0u)},
	/* 256 */
	{3450, S_008210_MEC1_BUSY(~0u)},
	{3460, S_008210_MEC2_BUSY(~0u)},
	{3470, S_008210_DC0_BUSY(~0u)},
	{3479, S_008210_DC1_BUSY(~0u)},
	{3488, S_008210_RCIU1_BUSY(~0u)},
	{3499, S_008210_RCIU2_BUSY(~0u)},
	{3510, S_008210_ROQ1_BUSY(~0u)},
	{3520, S_008210_ROQ2_BUSY(~0u)},
	{3530, S_008210_TCIU_BUSY(~0u)},
	{3540, S_008210_SCRATCH_RAM_BUSY(~0u)},
	{3557, S_008210_QU_BUSY(~0u)},
	{3565, S_008210_ATCL2IU_BUSY(~0u)},
	{3578, S_008210_CPG_CPC_BUSY(~0u)},
	{3591, S_008210_CPF_CPC_BUSY(~0u)},
	{2586, S_008210_CPC_BUSY(~0u)},
	/* 271 */
	{3604, S_008214_MEC1_LOAD_BUSY(~0u)},
	{3619, S_008214_MEC1_SEMAPOHRE_BUSY(~0u)},
	{3639, S_008214_MEC1_MUTEX_BUSY(~0u)},
	{3655, S_008214_MEC1_MESSAGE_BUSY(~0u)},
	{3673, S_008214_MEC1_EOP_QUEUE_BUSY(~0u)},
	{3693, S_008214_MEC1_IQ_QUEUE_BUSY(~0u)},
	{3712, S_008214_MEC1_IB_QUEUE_BUSY(~0u)},
	{3731, S_008214_MEC1_TC_BUSY(~0u)},
	{3744, S_008214_MEC1_DMA_BUSY(~0u)},
	{3758, S_008214_MEC1_PARTIAL_FLUSH_BUSY(~0u)},
	{3782, S_008214_MEC1_PIPE0_BUSY(~0u)},
	{3798, S_008214_MEC1_PIPE1_BUSY(~0u)},
	{3814, S_008214_MEC1_PIPE2_BUSY(~0u)},
	{3830, S_008214_MEC1_PIPE3_BUSY(~0u)},
	{3846, S_008214_MEC2_LOAD_BUSY(~0u)},
	{3861, S_008214_MEC2_SEMAPOHRE_BUSY(~0u)},
	{3881, S_008214_MEC2_MUTEX_BUSY(~0u)},
	{3897, S_008214_MEC2_MESSAGE_BUSY(~0u)},
	{3915, S_008214_MEC2_EOP_QUEUE_BUSY(~0u)},
	{3935, S_008214_MEC2_IQ_QUEUE_BUSY(~0u)},
	{3954, S_008214_MEC2_IB_QUEUE_BUSY(~0u)},
	{3973, S_008214_MEC2_TC_BUSY(~0u)},
	{3986, S_008214_MEC2_DMA_BUSY(~0u)},
	{4000, S_008214_MEC2_PARTIAL_FLUSH_BUSY(~0u)},
	{4024, S_008214_MEC2_PIPE0_BUSY(~0u)},
	{4040, S_008214_MEC2_PIPE1_BUSY(~0u)},
	{4056, S_008214_MEC2_PIPE2_BUSY(~0u)},
	{4072, S_008214_MEC2_PIPE3_BUSY(~0u)},
	/* 299 */
	{4088, S_008218_RCIU_TX_FREE_STALL(~0u)},
	{4107, S_008218_RCIU_PRIV_VIOLATION(~0u)},
	{4127, S_008218_TCIU_TX_FREE_STALL(~0u)},
	{4146, S_008218_MEC1_DECODING_PACKET(~0u)},
	{4167, S_008218_MEC1_WAIT_ON_RCIU(~0u)},
	{4185, S_008218_MEC1_WAIT_ON_RCIU_READ(~0u)},
	{4208, S_008218_MEC1_WAIT_ON_ROQ_DATA(~0u)},
	{4230, S_008218_MEC2_DECODING_PACKET(~0u)},
	{4251, S_008218_MEC2_WAIT_ON_RCIU(~0u)},
	{4269, S_008218_MEC2_WAIT_ON_RCIU_READ(~0u)},
	{4292, S_008218_MEC2_WAIT_ON_ROQ_DATA(~0u)},
	{4314, S_008218_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4338, S_008218_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4362, S_008218_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 313 */
	{4385, S_00821C_POST_WPTR_GFX_BUSY(~0u)},
	{4404, S_00821C_CSF_BUSY(~0u)},
	{4413, S_00821C_ROQ_ALIGN_BUSY(~0u)},
	{4428, S_00821C_ROQ_RING_BUSY(~0u)},
	{4442, S_00821C_ROQ_INDIRECT1_BUSY(~0u)},
	{4461, S_00821C_ROQ_INDIRECT2_BUSY(~0u)},
	{4480, S_00821C_ROQ_STATE_BUSY(~0u)},
	{4495, S_00821C_ROQ_CE_RING_BUSY(~0u)},
	{4512, S_00821C_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4534, S_00821C_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{4556, S_00821C_SEMAPHORE_BUSY(~0u)},
	{4571, S_00821C_INTERRUPT_BUSY(~0u)},
	{3530, S_00821C_TCIU_BUSY(~0u)},
	{4586, S_00821C_HQD_BUSY(~0u)},
	{4595, S_00821C_PRT_BUSY(~0u)},
	{3565, S_00821C_ATCL2IU_BUSY(~0u)},
	{4604, S_00821C_CPF_GFX_BUSY(~0u)},
	{4617, S_00821C_CPF_CMP_BUSY(~0u)},
	{4630, S_00821C_GRBM_CPF_STAT_BUSY(~0u)},
	{4649, S_00821C_CPC_CPF_BUSY(~0u)},
	{2577, S_00821C_CPF_BUSY(~0u)},
	/* 334 */
	{4662, S_008220_REG_BUS_FIFO_BUSY(~0u)},
	{4680, S_008220_CSF_RING_BUSY(~0u)},
	{4694, S_008220_CSF_INDIRECT1_BUSY(~0u)},
	{4713, S_008220_CSF_INDIRECT2_BUSY(~0u)},
	{4732, S_008220_CSF_STATE_BUSY(~0u)},
	{4747, S_008220_CSF_CE_INDR1_BUSY(~0u)},
	{4765, S_008220_CSF_CE_INDR2_BUSY(~0u)},
	{4783, S_008220_CSF_ARBITER_BUSY(~0u)},
	{4800, S_008220_CSF_INPUT_BUSY(~0u)},
	{4815, S_008220_OUTSTANDING_READ_TAGS(~0u)},
	{4837, S_008220_HPD_PROCESSING_EOP_BUSY(~0u)},
	{4861, S_008220_HQD_DISPATCH_BUSY(~0u)},
	{4879, S_008220_HQD_IQ_TIMER_BUSY(~0u)},
	{4897, S_008220_HQD_DMA_OFFLOAD_BUSY(~0u)},
	{4918, S_008220_HQD_WAIT_SEMAPHORE_BUSY(~0u)},
	{4942, S_008220_HQD_SIGNAL_SEMAPHORE_BUSY(~0u)},
	{4968, S_008220_HQD_MESSAGE_BUSY(~0u)},
	{4985, S_008220_HQD_PQ_FETCHER_BUSY(~0u)},
	{5005, S_008220_HQD_IB_FETCHER_BUSY(~0u)},
	{5025, S_008220_HQD_IQ_FETCHER_BUSY(~0u)},
	{5045, S_008220_HQD_EOP_FETCHER_BUSY(~0u)},
	{5066, S_008220_HQD_CONSUMED_RPTR_BUSY(~0u)},
	{5089, S_008220_HQD_FETCHER_ARB_BUSY(~0u)},
	{5110, S_008220_HQD_ROQ_ALIGN_BUSY(~0u)},
	{5129, S_008220_HQD_ROQ_EOP_BUSY(~0u)},
	{5146, S_008220_HQD_ROQ_IQ_BUSY(~0u)},
	{5162, S_008220_HQD_ROQ_PQ_BUSY(~0u)},
	{5178, S_008220_HQD_ROQ_IB_BUSY(~0u)},
	{5194, S_008220_HQD_WPTR_POLL_BUSY(~0u)},
	{5213, S_008220_HQD_PQ_BUSY(~0u)},
	{5225, S_008220_HQD_IB_BUSY(~0u)},
	/* 365 */
	{5237, S_008224_RING_FETCHING_DATA(~0u)},
	{5256, S_008224_INDR1_FETCHING_DATA(~0u)},
	{5276, S_008224_INDR2_FETCHING_DATA(~0u)},
	{5296, S_008224_STATE_FETCHING_DATA(~0u)},
	{5316, S_008224_TCIU_WAITING_ON_FREE(~0u)},
	{5337, S_008224_TCIU_WAITING_ON_TAGS(~0u)},
	{4314, S_008224_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4338, S_008224_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4362, S_008224_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 374 */
	{5358, S_030230_COHER_SIZE_HI_256B(~0u)},
	/* 375 */
	{5377, S_0088B0_PRIM_COUNT(~0u)},
	/* 376 */
	{5388, S_0088C4_VS_NO_EXTRA_BUFFER(~0u)},
	{5407, S_0088C4_STREAMOUT_FULL_FLUSH(~0u)},
	{5428, S_0088C4_ES_LIMIT(~0u)},
	/* 379 */
	{5437, S_0088D4_VERT_REUSE(~0u)},
	/* 380 */
	{5964, S_008958_PRIM_TYPE(~0u), 29, 26},
	/* 381 */
	{203, S_00895C_INDEX_TYPE(~0u), 2, 55},
	/* 382 */
	{38, S_008988_SIZE(~0u)},
	/* 383 */
	{6016, S_0089B0_OFFCHIP_BUFFERING(~0u)},
	/* 384 */
	{6034, S_008A14_CLIP_VTX_REORDER_ENA(~0u)},
	{6055, S_008A14_NUM_CLIP_SEQ(~0u)},
	{6068, S_008A14_CLIPPED_PRIM_SEQ_STALL(~0u)},
	{6091, S_008A14_VE_NAN_PROC_DISABLE(~0u)},
	/* 388 */
	{6111, S_008A60_LINE_STIPPLE_VALUE(~0u)},
	/* 389 */
	{6130, S_008B10_CURRENT_PTR(~0u)},
	{6142, S_008B10_CURRENT_COUNT(~0u)},
	/* 391 */
	{6156, S_008670_CE_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{6181, S_008670_CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV(~0u)},
	{6219, S_008670_CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER(~0u)},
	{6260, S_008670_CE_TO_RAM_INIT_NOT_RDY(~0u)},
	{6283, S_008670_CE_TO_RAM_DUMP_NOT_RDY(~0u)},
	{6306, S_008670_CE_TO_RAM_WRITE_NOT_RDY(~0u)},
	{6330, S_008670_CE_TO_INC_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6360, S_008670_CE_TO_WR_FIFO_NOT_RDY_TO_RCV(~0u)},
	{6389, S_008670_CE_WAITING_ON_BUFFER_DATA(~0u)},
	{6415, S_008670_CE_WAITING_ON_CE_BUFFER_FLAG(~0u)},
	{6444, S_008670_CE_WAITING_ON_DE_COUNTER(~0u)},
	{6469, S_008670_CE_WAITING_ON_DE_COUNTER_UNDERFLOW(~0u)},
	{5316, S_008670_TCIU_WAITING_ON_FREE(~0u)},
	{5337, S_008670_TCIU_WAITING_ON_TAGS(~0u)},
	{6504, S_008670_CE_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{6532, S_008670_CE_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{4314, S_008670_ATCL2IU_WAITING_ON_FREE(~0u)},
	{4338, S_008670_ATCL2IU_WAITING_ON_TAGS(~0u)},
	{4362, S_008670_ATCL1_WAITING_ON_TRANS(~0u)},
	/* 410 */
	{6562, S_008674_RBIU_TO_DMA_NOT_RDY_TO_RCV(~0u)},
	{6589, S_008674_RBIU_TO_SEM_NOT_RDY_TO_RCV(~0u)},
	{6616, S_008674_RBIU_TO_MEMWR_NOT_RDY_TO_RCV(~0u)},
	{6645, S_008674_ME_HAS_ACTIVE_CE_BUFFER_FLAG(~0u)},
	{6674, S_008674_ME_HAS_ACTIVE_DE_BUFFER_FLAG(~0u)},
	{6703, S_008674_ME_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{6731, S_008674_ME_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{6761, S_008674_ME_WAITING_ON_TC_READ_DATA(~0u)},
	{6788, S_008674_ME_WAITING_ON_REG_READ_DATA(~0u)},
	{6816, S_008674_RCIU_WAITING_ON_GDS_FREE(~0u)},
	{6841, S_008674_RCIU_WAITING_ON_GRBM_FREE(~0u)},
	{6867, S_008674_RCIU_WAITING_ON_VGT_FREE(~0u)},
	{6892, S_008674_RCIU_STALLED_ON_ME_READ(~0u)},
	{6916, S_008674_RCIU_STALLED_ON_DMA_READ(~0u)},
	{6941, S_008674_RCIU_STALLED_ON_APPEND_READ(~0u)},
	{6969, S_008674_RCIU_HALTED_BY_REG_VIOLATION(~0u)},
	/* 426 */
	{6998, S_008678_PFP_TO_CSF_NOT_RDY_TO_RCV(~0u)},
	{7024, S_008678_PFP_TO_MEQ_NOT_RDY_TO_RCV(~0u)},
	{7050, S_008678_PFP_TO_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7077, S_008678_PFP_TO_VGT_WRITES_PENDING(~0u)},
	{7103, S_008678_PFP_RCIU_READ_PENDING(~0u)},
	{7125, S_008678_PFP_WAITING_ON_BUFFER_DATA(~0u)},
	{7152, S_008678_ME_WAIT_ON_CE_COUNTER(~0u)},
	{7174, S_008678_ME_WAIT_ON_AVAIL_BUFFER(~0u)},
	{7198, S_008678_GFX_CNTX_NOT_AVAIL_TO_ME(~0u)},
	{7223, S_008678_ME_RCIU_NOT_RDY_TO_RCV(~0u)},
	{7246, S_008678_ME_TO_CONST_NOT_RDY_TO_RCV(~0u)},
	{7273, S_008678_ME_WAITING_DATA_FROM_PFP(~0u)},
	{7298, S_008678_ME_WAITING_ON_PARTIAL_FLUSH(~0u)},
	{7326, S_008678_MEQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7351, S_008678_STQ_TO_ME_NOT_RDY_TO_RCV(~0u)},
	{7376, S_008678_ME_WAITING_DATA_FROM_STQ(~0u)},
	{7401, S_008678_PFP_STALLED_ON_TC_WR_CONFIRM(~0u)},
	{7430, S_008678_PFP_STALLED_ON_ATOMIC_RTN_DATA(~0u)},
	{7461, S_008678_EOPD_FIFO_NEEDS_SC_EOP_DONE(~0u)},
	{7489, S_008678_EOPD_FIFO_NEEDS_WR_CONFIRM(~0u)},
	{7516, S_008678_STRMO_WR_OF_PRIM_DATA_PENDING(~0u)},
	{7546, S_008678_PIPE_STATS_WR_DATA_PENDING(~0u)},
	{7573, S_008678_APPEND_RDY_WAIT_ON_CS_DONE(~0u)},
	{7600, S_008678_APPEND_RDY_WAIT_ON_PS_DONE(~0u)},
	{7627, S_008678_APPEND_WAIT_ON_WR_CONFIRM(~0u)},
	{7653, S_008678_APPEND_ACTIVE_PARTITION(~0u)},
	{7677, S_008678_APPEND_WAITING_TO_SEND_MEMWRITE(~0u)},
	{7709, S_008678_SURF_SYNC_NEEDS_IDLE_CNTXS(~0u)},
	{7736, S_008678_SURF_SYNC_NEEDS_ALL_CLEAN(~0u)},
	/* 455 */
	{4428, S_008680_ROQ_RING_BUSY(~0u)},
	{4442, S_008680_ROQ_INDIRECT1_BUSY(~0u)},
	{4461, S_008680_ROQ_INDIRECT2_BUSY(~0u)},
	{4480, S_008680_ROQ_STATE_BUSY(~0u)},
	{7762, S_008680_DC_BUSY(~0u)},
	{3565, S_008680_ATCL2IU_BUSY(~0u)},
	{7770, S_008680_PFP_BUSY(~0u)},
	{7779, S_008680_MEQ_BUSY(~0u)},
	{7788, S_008680_ME_BUSY(~0u)},
	{7796, S_008680_QUERY_BUSY(~0u)},
	{4556, S_008680_SEMAPHORE_BUSY(~0u)},
	{4571, S_008680_INTERRUPT_BUSY(~0u)},
	{7807, S_008680_SURFACE_SYNC_BUSY(~0u)},
	{1335, S_008680_DMA_BUSY(~0u)},
	{7825, S_008680_RCIU_BUSY(~0u)},
	{3540, S_008680_SCRATCH_RAM_BUSY(~0u)},
	{7835, S_008680_CPC_CPG_BUSY(~0u)},
	{7848, S_008680_CE_BUSY(~0u)},
	{3530, S_008680_TCIU_BUSY(~0u)},
	{4495, S_008680_ROQ_CE_RING_BUSY(~0u)},
	{4512, S_008680_ROQ_CE_INDIRECT1_BUSY(~0u)},
	{4534, S_008680_ROQ_CE_INDIRECT2_BUSY(~0u)},
	{1411, S_008680_CP_BUSY(~0u)},
	/* 478 */
	{7856, S_030800_INSTANCE_INDEX(~0u)},
	{7871, S_030800_SH_INDEX(~0u)},
	{7880, S_030800_SE_INDEX(~0u)},
	{7889, S_030800_SH_BROADCAST_WRITES(~0u)},
	{7909, S_030800_INSTANCE_BROADCAST_WRITES(~0u)},
	{7935, S_030800_SE_BROADCAST_WRITES(~0u)},
	/* 484 */
	{5964, S_030908_PRIM_TYPE(~0u), 29, 57},
	/* 485 */
	{203, S_03090C_INDEX_TYPE(~0u), 2, 55},
	/* 486 */
	{38, S_030938_SIZE(~0u)},
	/* 487 */
	{6016, S_03093C_OFFCHIP_BUFFERING(~0u)},
	{8003, S_03093C_OFFCHIP_GRANULARITY(~0u), 4, 86},
	/* 489 */
	{6111, S_030A00_LINE_STIPPLE_VALUE(~0u)},
	/* 490 */
	{6130, S_030A04_CURRENT_PTR(~0u)},
	{6142, S_030A04_CURRENT_COUNT(~0u)},
	/* 492 */
	{445, S_030A10_X(~0u)},
	{91, S_030A10_Y(~0u)},
	/* 494 */
	{445, S_030A14_X(~0u)},
	{91, S_030A14_Y(~0u)},
	/* 496 */
	{445, S_030A18_X(~0u)},
	{91, S_030A18_Y(~0u)},
	/* 498 */
	{445, S_030A2C_X(~0u)},
	{91, S_030A2C_Y(~0u)},
	/* 500 */
	{8023, S_008BF0_ENABLE_PA_SC_OUT_OF_ORDER(~0u)},
	{8049, S_008BF0_DISABLE_SC_DB_TILE_FIX(~0u)},
	{8072, S_008BF0_DISABLE_AA_MASK_FULL_FIX(~0u)},
	{8097, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOCATIONS(~0u)},
	{8128, S_008BF0_ENABLE_1XMSAA_SAMPLE_LOC_CENTROID(~0u)},
	{8162, S_008BF0_DISABLE_SCISSOR_FIX(~0u)},
	{8182, S_008BF0_DISABLE_PW_BUBBLE_COLLAPSE(~0u)},
	{8209, S_008BF0_SEND_UNLIT_STILES_TO_PACKER(~0u)},
	{8237, S_008BF0_DISABLE_DUALGRAD_PERF_OPTIMIZATION(~0u)},
	/* 509 */
	{8272, S_008C08_INST_INVALIDATE(~0u)},
	{8288, S_008C08_DATA_INVALIDATE(~0u)},
	/* 511 */
	{8272, S_030D20_INST_INVALIDATE(~0u)},
	{8288, S_030D20_DATA_INVALIDATE(~0u)},
	{8304, S_030D20_INVALIDATE_VOLATILE(~0u)},
	/* 514 */
	{8324, S_008C0C_RET(~0u)},
	{8328, S_008C0C_RUI(~0u)},
	{8332, S_008C0C_RNG(~0u)},
	/* 517 */
	{8336, S_008DFC_EN(~0u)},
	{8398, S_008DFC_TGT(~0u), 33, 90},
	{8402, S_008DFC_COMPR(~0u)},
	{2891, S_008DFC_DONE(~0u)},
	{8408, S_008DFC_VM(~0u)},
	{8428, S_008DFC_ENCODING(~0u), 63, 123},
	/* 523 */
	{8437, S_030E04_ADDRESS(~0u)},
	/* 524 */
	{8445, S_030F04_COUNT_HI(~0u)},
	/* 525 */
	{8454, S_008F04_BASE_ADDRESS_HI(~0u)},
	{8470, S_008F04_STRIDE(~0u)},
	{8477, S_008F04_CACHE_SWIZZLE(~0u)},
	{8491, S_008F04_SWIZZLE_ENABLE(~0u)},
	/* 529 */
	{8445, S_030F0C_COUNT_HI(~0u)},
	/* 530 */
	{8596, S_008F0C_DST_SEL_X(~0u), 8, 186},
	{8606, S_008F0C_DST_SEL_Y(~0u), 8, 186},
	{8616, S_008F0C_DST_SEL_Z(~0u), 8, 186},
	{8626, S_008F0C_DST_SEL_W(~0u), 8, 186},
	{8810, S_008F0C_NUM_FORMAT(~0u), 8, 194},
	{9202, S_008F0C_DATA_FORMAT(~0u), 16, 202},
	{9214, S_008F0C_ELEMENT_SIZE(~0u)},
	{9227, S_008F0C_INDEX_STRIDE(~0u)},
	{9240, S_008F0C_ADD_TID_ENABLE(~0u)},
	{9255, S_008F0C_ATC(~0u)},
	{9259, S_008F0C_HASH_ENABLE(~0u)},
	{9271, S_008F0C_HEAP(~0u)},
	{9276, S_008F0C_MTYPE(~0u)},
	{209, S_008F0C_TYPE(~0u), 4, 218},
	/* 544 */
	{8445, S_030F14_COUNT_HI(~0u)},
	/* 545 */
	{8454, S_008F14_BASE_ADDRESS_HI(~0u)},
	{9351, S_008F14_MIN_LOD(~0u)},
	{9202, S_008F14_DATA_FORMAT(~0u), 64, 222},
	{8810, S_008F14_NUM_FORMAT(~0u), 16, 286},
	{9276, S_008F14_MTYPE(~0u)},
	/* 550 */
	{11341, S_008F18_WIDTH(~0u)},
	{11347, S_008F18_HEIGHT(~0u)},
	{11354, S_008F18_PERF_MOD(~0u)},
	{11363, S_008F18_INTERLACED(~0u)},
	/* 554 */
	{8445, S_030F1C_COUNT_HI(~0u)},
	/* 555 */
	{8596, S_008F1C_DST_SEL_X(~0u), 8, 186},
	{8606, S_008F1C_DST_SEL_Y(~0u), 8, 186},
	{8616, S_008F1C_DST_SEL_Z(~0u), 8, 186},
	{8626, S_008F1C_DST_SEL_W(~0u), 8, 186},
	{11374, S_008F1C_BASE_LEVEL(~0u)},
	{11385, S_008F1C_LAST_LEVEL(~0u)},
	{11396, S_008F1C_TILING_INDEX(~0u)},
	{11409, S_008F1C_POW2_PAD(~0u)},
	{9276, S_008F1C_MTYPE(~0u)},
	{9255, S_008F1C_ATC(~0u)},
	{209, S_008F1C_TYPE(~0u), 16, 302},
	/* 566 */
	{11720, S_008F20_DEPTH(~0u)},
	{11726, S_008F20_PITCH(~0u)},
	/* 568 */
	{11732, S_008F24_BASE_ARRAY(~0u)},
	{11743, S_008F24_LAST_ARRAY(~0u)},
	/* 570 */
	{11754, S_008F28_MIN_LOD_WARN(~0u)},
	{11767, S_008F28_COUNTER_BANK_ID(~0u)},
	{11783, S_008F28_LOD_HDW_CNT_EN(~0u)},
	{11798, S_008F28_COMPRESSION_EN(~0u)},
	{11813, S_008F28_ALPHA_IS_ON_MSB(~0u)},
	{11829, S_008F28_COLOR_TRANSFORM(~0u)},
	{11845, S_008F28_LOST_ALPHA_BITS(~0u)},
	{11861, S_008F28_LOST_COLOR_BITS(~0u)},
	/* 578 */
	{12059, S_008F30_CLAMP_X(~0u), 8, 318},
	{12067, S_008F30_CLAMP_Y(~0u), 8, 318},
	{12075, S_008F30_CLAMP_Z(~0u), 8, 318},
	{12083, S_008F30_MAX_ANISO_RATIO(~0u)},
	{12331, S_008F30_DEPTH_COMPARE_FUNC(~0u), 8, 326},
	{12350, S_008F30_FORCE_UNNORMALIZED(~0u)},
	{12369, S_008F30_ANISO_THRESHOLD(~0u)},
	{12385, S_008F30_MC_COORD_TRUNC(~0u)},
	{12400, S_008F30_FORCE_DEGAMMA(~0u)},
	{12414, S_008F30_ANISO_BIAS(~0u)},
	{12425, S_008F30_TRUNC_COORD(~0u)},
	{12437, S_008F30_DISABLE_CUBE_WRAP(~0u)},
	{12455, S_008F30_FILTER_MODE(~0u)},
	{12467, S_008F30_COMPAT_MODE(~0u)},
	/* 592 */
	{9351, S_008F34_MIN_LOD(~0u)},
	{12479, S_008F34_MAX_LOD(~0u)},
	{12487, S_008F34_PERF_MIP(~0u)},
	{12496, S_008F34_PERF_Z(~0u)},
	/* 596 */
	{12503, S_008F38_LOD_BIAS(~0u)},
	{12512, S_008F38_LOD_BIAS_SEC(~0u)},
	{12574, S_008F38_XY_MAG_FILTER(~0u), 2, 334},
	{12649, S_008F38_XY_MIN_FILTER(~0u), 4, 336},
	{12729, S_008F38_Z_FILTER(~0u), 3, 340},
	{12738, S_008F38_MIP_FILTER(~0u), 3, 340},
	{12749, S_008F38_MIP_POINT_PRECLAMP(~0u)},
	{12768, S_008F38_DISABLE_LSB_CEIL(~0u)},
	{12785, S_008F38_FILTER_PREC_FIX(~0u)},
	{12801, S_008F38_ANISO_OVERRIDE(~0u)},
	/* 606 */
	{12816, S_008F3C_BORDER_COLOR_PTR(~0u)},
	{12960, S_008F3C_BORDER_COLOR_TYPE(~0u), 4, 343},
	/* 608 */
	{12978, S_0090DC_VS_LOW_THRESHOLD(~0u)},
	{12995, S_0090DC_GS_LOW_THRESHOLD(~0u)},
	{13012, S_0090DC_ES_LOW_THRESHOLD(~0u)},
	{13029, S_0090DC_HS_LOW_THRESHOLD(~0u)},
	{13046, S_0090DC_LS_LOW_THRESHOLD(~0u)},
	/* 613 */
	{13063, S_0090E0_PS_CU_EN(~0u)},
	{13072, S_0090E0_VS_CU_EN(~0u)},
	/* 615 */
	{13081, S_0090E4_GS_CU_EN(~0u)},
	{13090, S_0090E4_ES_CU_EN(~0u)},
	/* 617 */
	{13099, S_0090E8_LSHS_CU_EN(~0u)},
	/* 618 */
	{13110, S_0090EC_MAX_WAVE_ID(~0u)},
	/* 619 */
	{13110, S_0090E8_MAX_WAVE_ID(~0u)},
	/* 620 */
	{13127, S_0090F0_RING_ORDER_TS0(~0u), 1, 347},
	{13142, S_0090F0_RING_ORDER_TS1(~0u)},
	{13157, S_0090F0_RING_ORDER_TS2(~0u)},
	/* 623 */
	{13172, S_00C700_PIPE_ORDER_TS0(~0u)},
	{13187, S_00C700_PIPE_ORDER_TS1(~0u)},
	{13202, S_00C700_PIPE_ORDER_TS2(~0u)},
	{13217, S_00C700_PIPE_ORDER_TS3(~0u)},
	{13232, S_00C700_TS0_DUR_MULT(~0u)},
	{13245, S_00C700_TS1_DUR_MULT(~0u)},
	{13258, S_00C700_TS2_DUR_MULT(~0u)},
	{13271, S_00C700_TS3_DUR_MULT(~0u)},
	/* 631 */
	{13284, S_0090F4_TS0_DURATION(~0u)},
	{13297, S_0090F4_TS1_DURATION(~0u)},
	/* 633 */
	{13310, S_0090F8_TS2_DURATION(~0u)},
	/* 634 */
	{38, S_008F40_SIZE(~0u)},
	/* 635 */
	{669, S_008F44_OFFSET(~0u)},
	/* 636 */
	{8445, S_030FFC_COUNT_HI(~0u)},
	/* 637 */
	{13323, S_009100_GPR_WRITE_PRIORITY(~0u)},
	{13342, S_009100_EXP_PRIORITY_ORDER(~0u)},
	{13361, S_009100_ENABLE_SQG_TOP_EVENTS(~0u)},
	{13383, S_009100_ENABLE_SQG_BOP_EVENTS(~0u)},
	{13405, S_009100_RSRC_MGMT_RESET(~0u)},
	/* 642 */
	{13674, S_00913C_VTX_DONE_DELAY(~0u), 16, 348},
	{13689, S_00913C_INTERP_ONE_PRIM_PER_ROW(~0u)},
	{13713, S_00913C_PC_LIMIT_ENABLE(~0u)},
	{13729, S_00913C_PC_LIMIT_STRICT(~0u)},
	{13745, S_00913C_PC_LIMIT_SIZE(~0u)},
	/* 647 */
	{13759, S_00936C_TYPE_A(~0u)},
	{13766, S_00936C_VGPR_A(~0u)},
	{13773, S_00936C_SGPR_A(~0u)},
	{13780, S_00936C_LDS_A(~0u)},
	{13786, S_00936C_WAVES_A(~0u)},
	{13794, S_00936C_EN_A(~0u)},
	{13799, S_00936C_TYPE_B(~0u)},
	{13806, S_00936C_VGPR_B(~0u)},
	{13813, S_00936C_SGPR_B(~0u)},
	{13820, S_00936C_LDS_B(~0u)},
	{13826, S_00936C_WAVES_B(~0u)},
	{13834, S_00936C_EN_B(~0u)},
	/* 659 */
	{13839, S_009858_MSAA1_X(~0u)},
	{13847, S_009858_MSAA1_Y(~0u)},
	{13855, S_009858_MSAA2_X(~0u)},
	{13863, S_009858_MSAA2_Y(~0u)},
	{13871, S_009858_MSAA4_X(~0u)},
	{13879, S_009858_MSAA4_Y(~0u)},
	{13887, S_009858_MSAA8_X(~0u)},
	{13895, S_009858_MSAA8_Y(~0u)},
	{13903, S_009858_MSAA16_X(~0u)},
	{13912, S_009858_MSAA16_Y(~0u)},
	/* 669 */
	{13921, S_0098F8_NUM_PIPES(~0u)},
	{13931, S_0098F8_PIPE_INTERLEAVE_SIZE(~0u)},
	{13952, S_0098F8_BANK_INTERLEAVE_SIZE(~0u)},
	{13973, S_0098F8_NUM_SHADER_ENGINES(~0u)},
	{13992, S_0098F8_SHADER_ENGINE_TILE_SIZE(~0u)},
	{14016, S_0098F8_NUM_GPUS(~0u)},
	{14025, S_0098F8_MULTI_GPU_TILE_SIZE(~0u)},
	{14045, S_0098F8_ROW_SIZE(~0u)},
	{14054, S_0098F8_NUM_LOWER_PIPES(~0u)},
	/* 678 */
	{14187, S_009910_MICRO_TILE_MODE(~0u), 4, 364},
	{14432, S_009910_ARRAY_MODE(~0u), 16, 368},
	{14794, S_009910_PIPE_CONFIG(~0u), 15, 384},
	{14984, S_009910_TILE_SPLIT(~0u), 7, 399},
	{15087, S_009910_BANK_WIDTH(~0u), 4, 406},
	{15194, S_009910_BANK_HEIGHT(~0u), 4, 410},
	{15306, S_009910_MACRO_TILE_ASPECT(~0u), 4, 414},
	{15393, S_009910_NUM_BANKS(~0u), 4, 418},
	{15434, S_009910_MICRO_TILE_MODE_NEW(~0u), 4, 422},
	{15454, S_009910_SAMPLE_SPLIT(~0u)},
	/* 688 */
	{15087, S_009990_BANK_WIDTH(~0u)},
	{15194, S_009990_BANK_HEIGHT(~0u)},
	{15306, S_009990_MACRO_TILE_ASPECT(~0u)},
	{15393, S_009990_NUM_BANKS(~0u)},
	/* 692 */
	{15467, S_00B004_MEM_BASE(~0u)},
	/* 693 */
	{15467, S_00B00C_MEM_BASE(~0u)},
	/* 694 */
	{13066, S_00B01C_CU_EN(~0u)},
	{15476, S_00B01C_WAVE_LIMIT(~0u)},
	{15487, S_00B01C_LOCK_LOW_THRESHOLD(~0u)},
	/* 697 */
	{15467, S_00B024_MEM_BASE(~0u)},
	/* 698 */
	{15506, S_00B028_VGPRS(~0u)},
	{15512, S_00B028_SGPRS(~0u)},
	{13333, S_00B028_PRIORITY(~0u)},
	{15561, S_00B028_FLOAT_MODE(~0u), 241, 426},
	{15572, S_00B028_PRIV(~0u)},
	{15577, S_00B028_DX10_CLAMP(~0u)},
	{15588, S_00B028_DEBUG_MODE(~0u)},
	{15599, S_00B028_IEEE_MODE(~0u)},
	{15609, S_00B028_CU_GROUP_DISABLE(~0u)},
	{15626, S_00B028_CACHE_CTL(~0u)},
	{15636, S_00B028_CDBG_USER(~0u)},
	/* 709 */
	{15646, S_00B02C_SCRATCH_EN(~0u)},
	{15657, S_00B02C_USER_SGPR(~0u)},
	{15667, S_00B02C_TRAP_PRESENT(~0u)},
	{15680, S_00B02C_WAVE_CNT_EN(~0u)},
	{15692, S_00B02C_EXTRA_LDS_SIZE(~0u)},
	{15707, S_00B02C_EXCP_EN(~0u)},
	{15715, S_00B02C_EXCP_EN_CIK(~0u)},
	/* 716 */
	{15467, S_00B104_MEM_BASE(~0u)},
	/* 717 */
	{15467, S_00B10C_MEM_BASE(~0u)},
	/* 718 */
	{13066, S_00B118_CU_EN(~0u)},
	{15476, S_00B118_WAVE_LIMIT(~0u)},
	{15487, S_00B118_LOCK_LOW_THRESHOLD(~0u)},
	/* 721 */
	{5431, S_00B11C_LIMIT(~0u)},
	/* 722 */
	{15467, S_00B124_MEM_BASE(~0u)},
	/* 723 */
	{15506, S_00B128_VGPRS(~0u)},
	{15512, S_00B128_SGPRS(~0u)},
	{13333, S_00B128_PRIORITY(~0u)},
	{15561, S_00B128_FLOAT_MODE(~0u)},
	{15572, S_00B128_PRIV(~0u)},
	{15577, S_00B128_DX10_CLAMP(~0u)},
	{15588, S_00B128_DEBUG_MODE(~0u)},
	{15599, S_00B128_IEEE_MODE(~0u)},
	{15727, S_00B128_VGPR_COMP_CNT(~0u)},
	{15741, S_00B128_CU_GROUP_ENABLE(~0u)},
	{15626, S_00B128_CACHE_CTL(~0u)},
	{15636, S_00B128_CDBG_USER(~0u)},
	/* 735 */
	{15646, S_00B12C_SCRATCH_EN(~0u)},
	{15657, S_00B12C_USER_SGPR(~0u)},
	{15667, S_00B12C_TRAP_PRESENT(~0u)},
	{15757, S_00B12C_OC_LDS_EN(~0u)},
	{15767, S_00B12C_SO_BASE0_EN(~0u)},
	{15779, S_00B12C_SO_BASE1_EN(~0u)},
	{15791, S_00B12C_SO_BASE2_EN(~0u)},
	{15803, S_00B12C_SO_BASE3_EN(~0u)},
	{15815, S_00B12C_SO_EN(~0u)},
	{15707, S_00B12C_EXCP_EN(~0u)},
	{15715, S_00B12C_EXCP_EN_CIK(~0u)},
	{15821, S_00B12C_DISPATCH_DRAW_EN(~0u)},
	/* 747 */
	{15467, S_00B204_MEM_BASE(~0u)},
	/* 748 */
	{15467, S_00B20C_MEM_BASE(~0u)},
	/* 749 */
	{13066, S_00B21C_CU_EN(~0u)},
	{15476, S_00B21C_WAVE_LIMIT(~0u)},
	{15487, S_00B21C_LOCK_LOW_THRESHOLD(~0u)},
	{15838, S_00B21C_GROUP_FIFO_DEPTH(~0u)},
	/* 753 */
	{15467, S_00B224_MEM_BASE(~0u)},
	/* 754 */
	{15506, S_00B228_VGPRS(~0u)},
	{15512, S_00B228_SGPRS(~0u)},
	{13333, S_00B228_PRIORITY(~0u)},
	{15561, S_00B228_FLOAT_MODE(~0u)},
	{15572, S_00B228_PRIV(~0u)},
	{15577, S_00B228_DX10_CLAMP(~0u)},
	{15588, S_00B228_DEBUG_MODE(~0u)},
	{15599, S_00B228_IEEE_MODE(~0u)},
	{15741, S_00B228_CU_GROUP_ENABLE(~0u)},
	{15626, S_00B228_CACHE_CTL(~0u)},
	{15636, S_00B228_CDBG_USER(~0u)},
	/* 765 */
	{15646, S_00B22C_SCRATCH_EN(~0u)},
	{15657, S_00B22C_USER_SGPR(~0u)},
	{15667, S_00B22C_TRAP_PRESENT(~0u)},
	{15707, S_00B22C_EXCP_EN(~0u)},
	{15715, S_00B22C_EXCP_EN_CIK(~0u)},
	/* 770 */
	{15467, S_00B304_MEM_BASE(~0u)},
	/* 771 */
	{15467, S_00B30C_MEM_BASE(~0u)},
	/* 772 */
	{13066, S_00B31C_CU_EN(~0u)},
	{15476, S_00B31C_WAVE_LIMIT(~0u)},
	{15487, S_00B31C_LOCK_LOW_THRESHOLD(~0u)},
	{15838, S_00B31C_GROUP_FIFO_DEPTH(~0u)},
	/* 776 */
	{15467, S_00B324_MEM_BASE(~0u)},
	/* 777 */
	{15506, S_00B328_VGPRS(~0u)},
	{15512, S_00B328_SGPRS(~0u)},
	{13333, S_00B328_PRIORITY(~0u)},
	{15561, S_00B328_FLOAT_MODE(~0u)},
	{15572, S_00B328_PRIV(~0u)},
	{15577, S_00B328_DX10_CLAMP(~0u)},
	{15588, S_00B328_DEBUG_MODE(~0u)},
	{15599, S_00B328_IEEE_MODE(~0u)},
	{15727, S_00B328_VGPR_COMP_CNT(~0u)},
	{15741, S_00B328_CU_GROUP_ENABLE(~0u)},
	{15626, S_00B328_CACHE_CTL(~0u)},
	{15636, S_00B328_CDBG_USER(~0u)},
	/* 789 */
	{15646, S_00B32C_SCRATCH_EN(~0u)},
	{15657, S_00B32C_USER_SGPR(~0u)},
	{15667, S_00B32C_TRAP_PRESENT(~0u)},
	{15757, S_00B32C_OC_LDS_EN(~0u)},
	{15707, S_00B32C_EXCP_EN(~0u)},
	{15698, S_00B32C_LDS_SIZE(~0u)},
	/* 795 */
	{15467, S_00B404_MEM_BASE(~0u)},
	/* 796 */
	{15467, S_00B40C_MEM_BASE(~0u)},
	/* 797 */
	{15476, S_00B41C_WAVE_LIMIT(~0u)},
	{15487, S_00B41C_LOCK_LOW_THRESHOLD(~0u)},
	{15838, S_00B41C_GROUP_FIFO_DEPTH(~0u)},
	/* 800 */
	{15467, S_00B424_MEM_BASE(~0u)},
	/* 801 */
	{15506, S_00B428_VGPRS(~0u)},
	{15512, S_00B428_SGPRS(~0u)},
	{13333, S_00B428_PRIORITY(~0u)},
	{15561, S_00B428_FLOAT_MODE(~0u)},
	{15572, S_00B428_PRIV(~0u)},
	{15577, S_00B428_DX10_CLAMP(~0u)},
	{15588, S_00B428_DEBUG_MODE(~0u)},
	{15599, S_00B428_IEEE_MODE(~0u)},
	{15626, S_00B428_CACHE_CTL(~0u)},
	{15636, S_00B428_CDBG_USER(~0u)},
	/* 811 */
	{15646, S_00B42C_SCRATCH_EN(~0u)},
	{15657, S_00B42C_USER_SGPR(~0u)},
	{15667, S_00B42C_TRAP_PRESENT(~0u)},
	{15757, S_00B42C_OC_LDS_EN(~0u)},
	{15855, S_00B42C_TG_SIZE_EN(~0u)},
	{15707, S_00B42C_EXCP_EN(~0u)},
	/* 817 */
	{15467, S_00B504_MEM_BASE(~0u)},
	/* 818 */
	{15467, S_00B50C_MEM_BASE(~0u)},
	/* 819 */
	{13066, S_00B51C_CU_EN(~0u)},
	{15476, S_00B51C_WAVE_LIMIT(~0u)},
	{15487, S_00B51C_LOCK_LOW_THRESHOLD(~0u)},
	{15838, S_00B51C_GROUP_FIFO_DEPTH(~0u)},
	/* 823 */
	{15467, S_00B524_MEM_BASE(~0u)},
	/* 824 */
	{15506, S_00B528_VGPRS(~0u)},
	{15512, S_00B528_SGPRS(~0u)},
	{13333, S_00B528_PRIORITY(~0u)},
	{15561, S_00B528_FLOAT_MODE(~0u)},
	{15572, S_00B528_PRIV(~0u)},
	{15577, S_00B528_DX10_CLAMP(~0u)},
	{15588, S_00B528_DEBUG_MODE(~0u)},
	{15599, S_00B528_IEEE_MODE(~0u)},
	{15727, S_00B528_VGPR_COMP_CNT(~0u)},
	{15626, S_00B528_CACHE_CTL(~0u)},
	{15636, S_00B528_CDBG_USER(~0u)},
	/* 835 */
	{15646, S_00B52C_SCRATCH_EN(~0u)},
	{15657, S_00B52C_USER_SGPR(~0u)},
	{15667, S_00B52C_TRAP_PRESENT(~0u)},
	{15698, S_00B52C_LDS_SIZE(~0u)},
	{15707, S_00B52C_EXCP_EN(~0u)},
	/* 840 */
	{15866, S_00B800_COMPUTE_SHADER_EN(~0u)},
	{15884, S_00B800_PARTIAL_TG_EN(~0u)},
	{15898, S_00B800_FORCE_START_AT_000(~0u)},
	{15917, S_00B800_ORDERED_APPEND_ENBL(~0u)},
	{15937, S_00B800_ORDERED_APPEND_MODE(~0u)},
	{15957, S_00B800_USE_THREAD_DIMENSIONS(~0u)},
	{15979, S_00B800_ORDER_MODE(~0u)},
	{15990, S_00B800_DISPATCH_CACHE_CNTL(~0u)},
	{16010, S_00B800_SCALAR_L1_INV_VOL(~0u)},
	{16028, S_00B800_VECTOR_L1_INV_VOL(~0u)},
	{16046, S_00B800_DATA_ATC(~0u)},
	{16055, S_00B800_RESTORE(~0u)},
	/* 852 */
	{16063, S_00B81C_NUM_THREAD_FULL(~0u)},
	{16079, S_00B81C_NUM_THREAD_PARTIAL(~0u)},
	/* 854 */
	{16063, S_00B820_NUM_THREAD_FULL(~0u)},
	{16079, S_00B820_NUM_THREAD_PARTIAL(~0u)},
	/* 856 */
	{16063, S_00B824_NUM_THREAD_FULL(~0u)},
	{16079, S_00B824_NUM_THREAD_PARTIAL(~0u)},
	/* 858 */
	{13110, S_00B82C_MAX_WAVE_ID(~0u)},
	/* 859 */
	{16098, S_00B828_PIPELINESTAT_ENABLE(~0u)},
	/* 860 */
	{16118, S_00B82C_PERFCOUNT_ENABLE(~0u)},
	/* 861 */
	{391, S_00B834_DATA(~0u)},
	{16135, S_00B834_INST_ATC(~0u)},
	/* 863 */
	{391, S_00B83C_DATA(~0u)},
	/* 864 */
	{391, S_00B844_DATA(~0u)},
	/* 865 */
	{15506, S_00B848_VGPRS(~0u)},
	{15512, S_00B848_SGPRS(~0u)},
	{13333, S_00B848_PRIORITY(~0u)},
	{15561, S_00B848_FLOAT_MODE(~0u)},
	{15572, S_00B848_PRIV(~0u)},
	{15577, S_00B848_DX10_CLAMP(~0u)},
	{15588, S_00B848_DEBUG_MODE(~0u)},
	{15599, S_00B848_IEEE_MODE(~0u)},
	{16144, S_00B848_BULKY(~0u)},
	{15636, S_00B848_CDBG_USER(~0u)},
	/* 875 */
	{15646, S_00B84C_SCRATCH_EN(~0u)},
	{15657, S_00B84C_USER_SGPR(~0u)},
	{15667, S_00B84C_TRAP_PRESENT(~0u)},
	{16150, S_00B84C_TGID_X_EN(~0u)},
	{16160, S_00B84C_TGID_Y_EN(~0u)},
	{16170, S_00B84C_TGID_Z_EN(~0u)},
	{15855, S_00B84C_TG_SIZE_EN(~0u)},
	{16180, S_00B84C_TIDIG_COMP_CNT(~0u)},
	{16195, S_00B84C_EXCP_EN_MSB(~0u)},
	{15698, S_00B84C_LDS_SIZE(~0u)},
	{15707, S_00B84C_EXCP_EN(~0u)},
	/* 886 */
	{391, S_00B850_DATA(~0u)},
	/* 887 */
	{16207, S_00B854_WAVES_PER_SH(~0u)},
	{16220, S_00B854_WAVES_PER_SH_CIK(~0u)},
	{16237, S_00B854_TG_PER_CU(~0u)},
	{16247, S_00B854_LOCK_THRESHOLD(~0u)},
	{16262, S_00B854_SIMD_DEST_CNTL(~0u)},
	{16277, S_00B854_FORCE_SIMD_DIST(~0u)},
	{16293, S_00B854_CU_GROUP_COUNT(~0u)},
	/* 894 */
	{16308, S_00B858_SH0_CU_EN(~0u)},
	{16318, S_00B858_SH1_CU_EN(~0u)},
	/* 896 */
	{16308, S_00B85C_SH0_CU_EN(~0u)},
	{16318, S_00B85C_SH1_CU_EN(~0u)},
	/* 898 */
	{16328, S_00B860_WAVES(~0u)},
	{16334, S_00B860_WAVESIZE(~0u)},
	/* 900 */
	{16308, S_00B864_SH0_CU_EN(~0u)},
	{16318, S_00B864_SH1_CU_EN(~0u)},
	/* 902 */
	{16308, S_00B868_SH0_CU_EN(~0u)},
	{16318, S_00B868_SH1_CU_EN(~0u)},
	/* 904 */
	{16343, S_00B87C_SEND_SEID(~0u)},
	{14515, S_00B87C_RESERVED2(~0u)},
	{16353, S_00B87C_RESERVED3(~0u)},
	{16363, S_00B87C_RESERVED4(~0u)},
	{16373, S_00B87C_WAVE_ID_BASE(~0u)},
	/* 909 */
	{16386, S_00B888_PAYLOAD(~0u)},
	{16394, S_00B888_IS_EVENT(~0u)},
	{16403, S_00B888_IS_STATE(~0u)},
	/* 912 */
	{906, S_00B890_ADDR(~0u)},
	/* 913 */
	{9255, S_00B894_ATC(~0u)},
	{9276, S_00B894_MTYPE(~0u)},
	/* 915 */
	{16412, S_034404_PERFCOUNTER_HI(~0u)},
	/* 916 */
	{16427, S_036004_PERF_SEL2(~0u)},
	{16437, S_036004_PERF_SEL3(~0u)},
	/* 918 */
	{16447, S_036008_PERF_SEL(~0u)},
	{16456, S_036008_PERF_SEL1(~0u)},
	{16466, S_036008_CNTR_MODE(~0u)},
	/* 921 */
	{16427, S_036010_PERF_SEL2(~0u)},
	{16437, S_036010_PERF_SEL3(~0u)},
	/* 923 */
	{16427, S_036018_PERF_SEL2(~0u)},
	{16437, S_036018_PERF_SEL3(~0u)},
	/* 925 */
	{16447, S_03601C_PERF_SEL(~0u)},
	{16456, S_03601C_PERF_SEL1(~0u)},
	{16466, S_03601C_CNTR_MODE(~0u)},
	/* 928 */
	{16523, S_036020_PERFMON_STATE(~0u), 3, 667},
	{16537, S_036020_SPM_PERFMON_STATE(~0u)},
	{16555, S_036020_PERFMON_ENABLE_MODE(~0u)},
	{16575, S_036020_PERFMON_SAMPLE_ENABLE(~0u)},
	/* 932 */
	{16447, S_036024_PERF_SEL(~0u)},
	{16456, S_036024_PERF_SEL1(~0u)},
	{16466, S_036024_CNTR_MODE(~0u)},
	/* 935 */
	{16447, S_036100_PERF_SEL(~0u)},
	{16597, S_036100_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16624, S_036100_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16651, S_036100_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16678, S_036100_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16704, S_036100_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16730, S_036100_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16757, S_036100_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16783, S_036100_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16809, S_036100_GRBM_BUSY_USER_DEFINED_MASK(~0u)},
	{16837, S_036100_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16863, S_036100_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16889, S_036100_CP_BUSY_USER_DEFINED_MASK(~0u)},
	{16915, S_036100_IA_BUSY_USER_DEFINED_MASK(~0u)},
	{16941, S_036100_GDS_BUSY_USER_DEFINED_MASK(~0u)},
	{16968, S_036100_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	{16995, S_036100_RLC_BUSY_USER_DEFINED_MASK(~0u)},
	{17022, S_036100_TC_BUSY_USER_DEFINED_MASK(~0u)},
	{17048, S_036100_WD_BUSY_USER_DEFINED_MASK(~0u)},
	/* 954 */
	{16447, S_036108_PERF_SEL(~0u)},
	{16597, S_036108_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16624, S_036108_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16678, S_036108_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16704, S_036108_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16730, S_036108_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16757, S_036108_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16837, S_036108_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16863, S_036108_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16651, S_036108_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16783, S_036108_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16968, S_036108_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 966 */
	{16447, S_03610C_PERF_SEL(~0u)},
	{16597, S_03610C_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16624, S_03610C_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16678, S_03610C_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16704, S_03610C_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16730, S_03610C_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16757, S_03610C_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16837, S_03610C_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16863, S_03610C_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16651, S_03610C_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16783, S_03610C_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16968, S_03610C_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 978 */
	{16447, S_036110_PERF_SEL(~0u)},
	{16597, S_036110_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16624, S_036110_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16678, S_036110_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16704, S_036110_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16730, S_036110_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16757, S_036110_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16837, S_036110_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16863, S_036110_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16651, S_036110_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16783, S_036110_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16968, S_036110_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 990 */
	{16447, S_036114_PERF_SEL(~0u)},
	{16597, S_036114_DB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16624, S_036114_CB_CLEAN_USER_DEFINED_MASK(~0u)},
	{16678, S_036114_TA_BUSY_USER_DEFINED_MASK(~0u)},
	{16704, S_036114_SX_BUSY_USER_DEFINED_MASK(~0u)},
	{16730, S_036114_SPI_BUSY_USER_DEFINED_MASK(~0u)},
	{16757, S_036114_SC_BUSY_USER_DEFINED_MASK(~0u)},
	{16837, S_036114_DB_BUSY_USER_DEFINED_MASK(~0u)},
	{16863, S_036114_CB_BUSY_USER_DEFINED_MASK(~0u)},
	{16651, S_036114_VGT_BUSY_USER_DEFINED_MASK(~0u)},
	{16783, S_036114_PA_BUSY_USER_DEFINED_MASK(~0u)},
	{16968, S_036114_BCI_BUSY_USER_DEFINED_MASK(~0u)},
	/* 1002 */
	{16447, S_036200_PERF_SEL(~0u)},
	{17074, S_036200_PERF_MODE(~0u)},
	/* 1004 */
	{16447, S_036210_PERF_SEL(~0u)},
	{16456, S_036210_PERF_SEL1(~0u)},
	{16466, S_036210_CNTR_MODE(~0u)},
	{17084, S_036210_PERF_MODE1(~0u)},
	{17074, S_036210_PERF_MODE(~0u)},
	/* 1009 */
	{16427, S_036220_PERF_SEL2(~0u)},
	{16437, S_036220_PERF_SEL3(~0u)},
	{17095, S_036220_PERF_MODE3(~0u)},
	{17106, S_036220_PERF_MODE2(~0u)},
	/* 1013 */
	{16447, S_036230_PERF_SEL(~0u)},
	{16456, S_036230_PERF_SEL1(~0u)},
	{16466, S_036230_CNTR_MODE(~0u)},
	{17084, S_036230_PERF_MODE1(~0u)},
	{17074, S_036230_PERF_MODE(~0u)},
	/* 1018 */
	{16427, S_036240_PERF_SEL2(~0u)},
	{16437, S_036240_PERF_SEL3(~0u)},
	{17095, S_036240_PERF_MODE3(~0u)},
	{17106, S_036240_PERF_MODE2(~0u)},
	/* 1022 */
	{17117, S_036250_PERF_SEID_IGNORE_MASK(~0u)},
	/* 1023 */
	{16447, S_036400_PERF_SEL(~0u)},
	{16456, S_036400_PERF_SEL1(~0u)},
	{16466, S_036400_CNTR_MODE(~0u)},
	/* 1026 */
	{16427, S_036404_PERF_SEL2(~0u)},
	{16437, S_036404_PERF_SEL3(~0u)},
	/* 1028 */
	{16447, S_036500_PERF_SEL(~0u)},
	{16456, S_036500_PERF_SEL1(~0u)},
	{16466, S_036500_CNTR_MODE(~0u)},
	/* 1031 */
	{16427, S_036504_PERF_SEL2(~0u)},
	{16437, S_036504_PERF_SEL3(~0u)},
	/* 1033 */
	{16447, S_036600_PERF_SEL(~0u)},
	{16456, S_036600_PERF_SEL1(~0u)},
	{16466, S_036600_CNTR_MODE(~0u)},
	/* 1036 */
	{16427, S_036610_PERF_SEL2(~0u)},
	{16437, S_036610_PERF_SEL3(~0u)},
	/* 1038 */
	{17139, S_036628_BIN0_MIN(~0u)},
	{17148, S_036628_BIN0_MAX(~0u)},
	{17157, S_036628_BIN1_MIN(~0u)},
	{17166, S_036628_BIN1_MAX(~0u)},
	{17175, S_036628_BIN2_MIN(~0u)},
	{17184, S_036628_BIN2_MAX(~0u)},
	{17193, S_036628_BIN3_MIN(~0u)},
	{17202, S_036628_BIN3_MAX(~0u)},
	/* 1046 */
	{16447, S_036700_PERF_SEL(~0u)},
	{17211, S_036700_SQC_BANK_MASK(~0u)},
	{17225, S_036700_SQC_CLIENT_MASK(~0u)},
	{17241, S_036700_SPM_MODE(~0u)},
	{17250, S_036700_SIMD_MASK(~0u)},
	{17074, S_036700_PERF_MODE(~0u)},
	/* 1052 */
	{17260, S_036780_PS_EN(~0u)},
	{17266, S_036780_VS_EN(~0u)},
	{17272, S_036780_GS_EN(~0u)},
	{17278, S_036780_ES_EN(~0u)},
	{17284, S_036780_HS_EN(~0u)},
	{17290, S_036780_LS_EN(~0u)},
	{17296, S_036780_CS_EN(~0u)},
	{17302, S_036780_CNTR_RATE(~0u)},
	{17312, S_036780_DISABLE_FLUSH(~0u)},
	/* 1061 */
	{17326, S_036784_SH0_MASK(~0u)},
	{17335, S_036784_SH1_MASK(~0u)},
	/* 1063 */
	{17344, S_036788_FORCE_EN(~0u)},
	/* 1064 */
	{17353, S_036900_PERFCOUNTER_SELECT(~0u)},
	{17372, S_036900_PERFCOUNTER_SELECT1(~0u)},
	{16466, S_036900_CNTR_MODE(~0u)},
	/* 1067 */
	{17392, S_036910_PERFCOUNTER_SELECT2(~0u)},
	{17412, S_036910_PERFCOUNTER_SELECT3(~0u)},
	/* 1069 */
	{17353, S_036A00_PERFCOUNTER_SELECT(~0u)},
	{17372, S_036A00_PERFCOUNTER_SELECT1(~0u)},
	{16466, S_036A00_CNTR_MODE(~0u)},
	/* 1072 */
	{17392, S_036A10_PERFCOUNTER_SELECT2(~0u)},
	{17412, S_036A10_PERFCOUNTER_SELECT3(~0u)},
	/* 1074 */
	{16447, S_036B00_PERF_SEL(~0u)},
	{16456, S_036B00_PERF_SEL1(~0u)},
	{16466, S_036B00_CNTR_MODE(~0u)},
	{17084, S_036B00_PERF_MODE1(~0u)},
	{17074, S_036B00_PERF_MODE(~0u)},
	/* 1079 */
	{16427, S_036B04_PERF_SEL2(~0u)},
	{16437, S_036B04_PERF_SEL3(~0u)},
	{17095, S_036B04_PERF_MODE3(~0u)},
	{17106, S_036B04_PERF_MODE2(~0u)},
	/* 1083 */
	{16447, S_036C00_PERF_SEL(~0u)},
	{16456, S_036C00_PERF_SEL1(~0u)},
	{16466, S_036C00_CNTR_MODE(~0u)},
	{17084, S_036C00_PERF_MODE1(~0u)},
	{17074, S_036C00_PERF_MODE(~0u)},
	/* 1088 */
	{16427, S_036C04_PERF_SEL2(~0u)},
	{16437, S_036C04_PERF_SEL3(~0u)},
	{17095, S_036C04_PERF_MODE3(~0u)},
	{17106, S_036C04_PERF_MODE2(~0u)},
	/* 1092 */
	{16447, S_036D00_PERF_SEL(~0u)},
	{16456, S_036D00_PERF_SEL1(~0u)},
	{16466, S_036D00_CNTR_MODE(~0u)},
	{17084, S_036D00_PERF_MODE1(~0u)},
	{17074, S_036D00_PERF_MODE(~0u)},
	/* 1097 */
	{16427, S_036D04_PERF_SEL2(~0u)},
	{16437, S_036D04_PERF_SEL3(~0u)},
	{17095, S_036D04_PERF_MODE3(~0u)},
	{17106, S_036D04_PERF_MODE2(~0u)},
	/* 1101 */
	{16447, S_036E00_PERF_SEL(~0u)},
	{16456, S_036E00_PERF_SEL1(~0u)},
	{16466, S_036E00_CNTR_MODE(~0u)},
	{17084, S_036E00_PERF_MODE1(~0u)},
	{17074, S_036E00_PERF_MODE(~0u)},
	/* 1106 */
	{16427, S_036E04_PERF_SEL2(~0u)},
	{16437, S_036E04_PERF_SEL3(~0u)},
	{17106, S_036E04_PERF_MODE2(~0u)},
	{17095, S_036E04_PERF_MODE3(~0u)},
	/* 1110 */
	{16447, S_036E40_PERF_SEL(~0u)},
	{16456, S_036E40_PERF_SEL1(~0u)},
	{16466, S_036E40_CNTR_MODE(~0u)},
	{17084, S_036E40_PERF_MODE1(~0u)},
	{17074, S_036E40_PERF_MODE(~0u)},
	/* 1115 */
	{16427, S_036E44_PERF_SEL2(~0u)},
	{16437, S_036E44_PERF_SEL3(~0u)},
	{17106, S_036E44_PERF_MODE2(~0u)},
	{17095, S_036E44_PERF_MODE3(~0u)},
	/* 1119 */
	{17432, S_037000_OP_FILTER_ENABLE(~0u)},
	{17449, S_037000_OP_FILTER_SEL(~0u)},
	{17463, S_037000_FORMAT_FILTER_ENABLE(~0u)},
	{17484, S_037000_FORMAT_FILTER_SEL(~0u)},
	{17502, S_037000_CLEAR_FILTER_ENABLE(~0u)},
	{17522, S_037000_CLEAR_FILTER_SEL(~0u)},
	{17539, S_037000_MRT_FILTER_ENABLE(~0u)},
	{17557, S_037000_MRT_FILTER_SEL(~0u)},
	{17572, S_037000_NUM_SAMPLES_FILTER_ENABLE(~0u)},
	{17598, S_037000_NUM_SAMPLES_FILTER_SEL(~0u)},
	{17621, S_037000_NUM_FRAGMENTS_FILTER_ENABLE(~0u)},
	{17649, S_037000_NUM_FRAGMENTS_FILTER_SEL(~0u)},
	/* 1131 */
	{16447, S_037004_PERF_SEL(~0u)},
	{16456, S_037004_PERF_SEL1(~0u)},
	{16466, S_037004_CNTR_MODE(~0u)},
	{17084, S_037004_PERF_MODE1(~0u)},
	{17074, S_037004_PERF_MODE(~0u)},
	/* 1136 */
	{16427, S_037008_PERF_SEL2(~0u)},
	{16437, S_037008_PERF_SEL3(~0u)},
	{17095, S_037008_PERF_MODE3(~0u)},
	{17106, S_037008_PERF_MODE2(~0u)},
	/* 1140 */
	{16447, S_037100_PERF_SEL(~0u)},
	{16456, S_037100_PERF_SEL1(~0u)},
	{16466, S_037100_CNTR_MODE(~0u)},
	{17084, S_037100_PERF_MODE1(~0u)},
	{17074, S_037100_PERF_MODE(~0u)},
	/* 1145 */
	{16427, S_037104_PERF_SEL2(~0u)},
	{16437, S_037104_PERF_SEL3(~0u)},
	{17095, S_037104_PERF_MODE3(~0u)},
	{17106, S_037104_PERF_MODE2(~0u)},
	/* 1149 */
	{17674, S_028000_DEPTH_CLEAR_ENABLE(~0u)},
	{17693, S_028000_STENCIL_CLEAR_ENABLE(~0u)},
	{17714, S_028000_DEPTH_COPY(~0u)},
	{17725, S_028000_STENCIL_COPY(~0u)},
	{17738, S_028000_RESUMMARIZE_ENABLE(~0u)},
	{17757, S_028000_STENCIL_COMPRESS_DISABLE(~0u)},
	{17782, S_028000_DEPTH_COMPRESS_DISABLE(~0u)},
	{17805, S_028000_COPY_CENTROID(~0u)},
	{17819, S_028000_COPY_SAMPLE(~0u)},
	{17831, S_028000_DECOMPRESS_ENABLE(~0u)},
	/* 1159 */
	{17849, S_028004_ZPASS_INCREMENT_DISABLE(~0u)},
	{17873, S_028004_PERFECT_ZPASS_COUNTS(~0u)},
	{17894, S_028004_SAMPLE_RATE(~0u)},
	{17906, S_028004_ZPASS_ENABLE(~0u)},
	{17919, S_028004_ZFAIL_ENABLE(~0u)},
	{17932, S_028004_SFAIL_ENABLE(~0u)},
	{17945, S_028004_DBFAIL_ENABLE(~0u)},
	{17959, S_028004_SLICE_EVEN_ENABLE(~0u)},
	{17977, S_028004_SLICE_ODD_ENABLE(~0u)},
	/* 1168 */
	{17994, S_028008_SLICE_START(~0u)},
	{18006, S_028008_SLICE_MAX(~0u)},
	{18016, S_028008_Z_READ_ONLY(~0u)},
	{18028, S_028008_STENCIL_READ_ONLY(~0u)},
	/* 1172 */
	{18098, S_02800C_FORCE_HIZ_ENABLE(~0u), 4, 670},
	{18115, S_02800C_FORCE_HIS_ENABLE0(~0u), 4, 670},
	{18133, S_02800C_FORCE_HIS_ENABLE1(~0u), 4, 670},
	{18151, S_02800C_FORCE_SHADER_Z_ORDER(~0u)},
	{18172, S_02800C_FAST_Z_DISABLE(~0u)},
	{18187, S_02800C_FAST_STENCIL_DISABLE(~0u)},
	{18208, S_02800C_NOOP_CULL_DISABLE(~0u)},
	{18226, S_02800C_FORCE_COLOR_KILL(~0u)},
	{18243, S_02800C_FORCE_Z_READ(~0u)},
	{18256, S_02800C_FORCE_STENCIL_READ(~0u)},
	{18275, S_02800C_FORCE_FULL_Z_RANGE(~0u), 4, 670},
	{18294, S_02800C_FORCE_QC_SMASK_CONFLICT(~0u)},
	{18318, S_02800C_DISABLE_VIEWPORT_CLAMP(~0u)},
	{18341, S_02800C_IGNORE_SC_ZRANGE(~0u)},
	{18358, S_02800C_DISABLE_FULLY_COVERED(~0u)},
	{18443, S_02800C_FORCE_Z_LIMIT_SUMM(~0u), 4, 674},
	{18462, S_02800C_MAX_TILES_IN_DTT(~0u)},
	{18479, S_02800C_DISABLE_TILE_RATE_TILES(~0u)},
	{18503, S_02800C_FORCE_Z_DIRTY(~0u)},
	{18517, S_02800C_FORCE_STENCIL_DIRTY(~0u)},
	{18537, S_02800C_FORCE_Z_VALID(~0u)},
	{18551, S_02800C_FORCE_STENCIL_VALID(~0u)},
	{18571, S_02800C_PRESERVE_COMPRESSION(~0u)},
	/* 1195 */
	{18645, S_028010_PARTIAL_SQUAD_LAUNCH_CONTROL(~0u), 4, 678},
	{18674, S_028010_PARTIAL_SQUAD_LAUNCH_COUNTDOWN(~0u)},
	{18705, S_028010_DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION(~0u)},
	{18741, S_028010_DISABLE_SMEM_EXPCLEAR_OPTIMIZATION(~0u)},
	{18776, S_028010_DISABLE_COLOR_ON_VALIDATION(~0u)},
	{18804, S_028010_DECOMPRESS_Z_ON_FLUSH(~0u)},
	{18826, S_028010_DISABLE_REG_SNOOP(~0u)},
	{18844, S_028010_DEPTH_BOUNDS_HIER_DEPTH_DISABLE(~0u)},
	{18876, S_028010_SEPARATE_HIZS_FUNC_ENABLE(~0u)},
	{18902, S_028010_HIZ_ZFUNC(~0u)},
	{18912, S_028010_HIS_SFUNC_FF(~0u)},
	{18925, S_028010_HIS_SFUNC_BF(~0u)},
	{18938, S_028010_PRESERVE_ZRANGE(~0u)},
	{18954, S_028010_PRESERVE_SRESULTS(~0u)},
	{18972, S_028010_DISABLE_FAST_PASS(~0u)},
	/* 1210 */
	{18990, S_028028_CLEAR(~0u)},
	/* 1211 */
	{18996, S_028030_TL_X(~0u)},
	{19001, S_028030_TL_Y(~0u)},
	/* 1213 */
	{19006, S_028034_BR_X(~0u)},
	{19011, S_028034_BR_Y(~0u)},
	/* 1215 */
	{19016, S_02803C_ADDR5_SWIZZLE_MASK(~0u)},
	{14432, S_02803C_ARRAY_MODE(~0u), 7, 682},
	{14794, S_02803C_PIPE_CONFIG(~0u), 18, 689},
	{15087, S_02803C_BANK_WIDTH(~0u), 4, 406},
	{15194, S_02803C_BANK_HEIGHT(~0u), 4, 410},
	{15306, S_02803C_MACRO_TILE_ASPECT(~0u), 4, 414},
	{15393, S_02803C_NUM_BANKS(~0u), 4, 418},
	/* 1222 */
	{8814, S_028040_FORMAT(~0u), 4, 707},
	{19168, S_028040_NUM_SAMPLES(~0u)},
	{14984, S_028040_TILE_SPLIT(~0u), 7, 399},
	{19180, S_028040_TILE_MODE_INDEX(~0u)},
	{19196, S_028040_DECOMPRESS_ON_N_ZPLANES(~0u)},
	{19220, S_028040_ALLOW_EXPCLEAR(~0u)},
	{19235, S_028040_READ_SIZE(~0u)},
	{19245, S_028040_TILE_SURFACE_ENABLE(~0u)},
	{19265, S_028040_CLEAR_DISALLOWED(~0u)},
	{19282, S_028040_ZRANGE_PRECISION(~0u)},
	/* 1232 */
	{8814, S_028044_FORMAT(~0u), 2, 711},
	{14984, S_028044_TILE_SPLIT(~0u), 7, 399},
	{19180, S_028044_TILE_MODE_INDEX(~0u)},
	{19220, S_028044_ALLOW_EXPCLEAR(~0u)},
	{19325, S_028044_TILE_STENCIL_DISABLE(~0u)},
	{19265, S_028044_CLEAR_DISALLOWED(~0u)},
	/* 1238 */
	{19346, S_028058_PITCH_TILE_MAX(~0u)},
	{19361, S_028058_HEIGHT_TILE_MAX(~0u)},
	/* 1240 */
	{19377, S_02805C_SLICE_TILE_MAX(~0u)},
	/* 1241 */
	{8437, S_028084_ADDRESS(~0u)},
	/* 1242 */
	{19392, S_028200_WINDOW_X_OFFSET(~0u)},
	{19408, S_028200_WINDOW_Y_OFFSET(~0u)},
	/* 1244 */
	{18996, S_028204_TL_X(~0u)},
	{19001, S_028204_TL_Y(~0u)},
	{19424, S_028204_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1247 */
	{19006, S_028208_BR_X(~0u)},
	{19011, S_028208_BR_Y(~0u)},
	/* 1249 */
	{19446, S_02820C_CLIP_RULE(~0u)},
	/* 1250 */
	{18996, S_028210_TL_X(~0u)},
	{19001, S_028210_TL_Y(~0u)},
	/* 1252 */
	{19006, S_028214_BR_X(~0u)},
	{19011, S_028214_BR_Y(~0u)},
	/* 1254 */
	{19456, S_028230_ER_TRI(~0u)},
	{12539, S_028230_ER_POINT(~0u)},
	{19463, S_028230_ER_RECT(~0u)},
	{19471, S_028230_ER_LINE_LR(~0u)},
	{19482, S_028230_ER_LINE_RL(~0u)},
	{19493, S_028230_ER_LINE_TB(~0u)},
	{19504, S_028230_ER_LINE_BT(~0u)},
	/* 1261 */
	{19515, S_028234_HW_SCREEN_OFFSET_X(~0u)},
	{19534, S_028234_HW_SCREEN_OFFSET_Y(~0u)},
	/* 1263 */
	{19553, S_028238_TARGET0_ENABLE(~0u)},
	{19568, S_028238_TARGET1_ENABLE(~0u)},
	{19583, S_028238_TARGET2_ENABLE(~0u)},
	{19598, S_028238_TARGET3_ENABLE(~0u)},
	{19613, S_028238_TARGET4_ENABLE(~0u)},
	{19628, S_028238_TARGET5_ENABLE(~0u)},
	{19643, S_028238_TARGET6_ENABLE(~0u)},
	{19658, S_028238_TARGET7_ENABLE(~0u)},
	/* 1271 */
	{19673, S_02823C_OUTPUT0_ENABLE(~0u)},
	{19688, S_02823C_OUTPUT1_ENABLE(~0u)},
	{19703, S_02823C_OUTPUT2_ENABLE(~0u)},
	{19718, S_02823C_OUTPUT3_ENABLE(~0u)},
	{19733, S_02823C_OUTPUT4_ENABLE(~0u)},
	{19748, S_02823C_OUTPUT5_ENABLE(~0u)},
	{19763, S_02823C_OUTPUT6_ENABLE(~0u)},
	{19778, S_02823C_OUTPUT7_ENABLE(~0u)},
	/* 1279 */
	{18996, S_028240_TL_X(~0u)},
	{19001, S_028240_TL_Y(~0u)},
	{19424, S_028240_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1282 */
	{19006, S_028244_BR_X(~0u)},
	{19011, S_028244_BR_Y(~0u)},
	/* 1284 */
	{18996, S_028250_TL_X(~0u)},
	{19001, S_028250_TL_Y(~0u)},
	{19424, S_028250_WINDOW_OFFSET_DISABLE(~0u)},
	/* 1287 */
	{19006, S_028254_BR_X(~0u)},
	{19011, S_028254_BR_Y(~0u)},
	/* 1289 */
	{19885, S_028350_RB_MAP_PKR0(~0u), 4, 713},
	{19897, S_028350_RB_MAP_PKR1(~0u), 4, 713},
	{20009, S_028350_RB_XSEL2(~0u), 4, 717},
	{20018, S_028350_RB_XSEL(~0u)},
	{20026, S_028350_RB_YSEL(~0u)},
	{20130, S_028350_PKR_MAP(~0u), 4, 721},
	{20238, S_028350_PKR_XSEL(~0u), 4, 725},
	{20347, S_028350_PKR_YSEL(~0u), 4, 729},
	{20460, S_028350_PKR_XSEL2(~0u), 4, 733},
	{20562, S_028350_SC_MAP(~0u), 4, 737},
	{20708, S_028350_SC_XSEL(~0u), 4, 741},
	{20855, S_028350_SC_YSEL(~0u), 4, 745},
	{20955, S_028350_SE_MAP(~0u), 4, 749},
	{21101, S_028350_SE_XSEL(~0u), 4, 753},
	{21248, S_028350_SE_YSEL(~0u), 4, 757},
	/* 1304 */
	{21368, S_028354_SE_PAIR_MAP(~0u), 4, 761},
	{21539, S_028354_SE_PAIR_XSEL(~0u), 4, 765},
	{21711, S_028354_SE_PAIR_YSEL(~0u), 4, 769},
	/* 1307 */
	{17959, S_028358_SLICE_EVEN_ENABLE(~0u)},
	{17977, S_028358_SLICE_ODD_ENABLE(~0u)},
	/* 1309 */
	{21724, S_028424_OVERWRITE_COMBINER_DISABLE(~0u)},
	{21751, S_028424_OVERWRITE_COMBINER_MRT_SHARING_DISABLE(~0u)},
	{21790, S_028424_OVERWRITE_COMBINER_WATERMARK(~0u)},
	/* 1312 */
	{22056, S_02842C_STENCILFAIL(~0u), 16, 773},
	{22068, S_02842C_STENCILZPASS(~0u), 16, 773},
	{22081, S_02842C_STENCILZFAIL(~0u), 16, 773},
	{22094, S_02842C_STENCILFAIL_BF(~0u), 16, 773},
	{22109, S_02842C_STENCILZPASS_BF(~0u), 16, 773},
	{22125, S_02842C_STENCILZFAIL_BF(~0u), 16, 773},
	/* 1318 */
	{22141, S_028430_STENCILTESTVAL(~0u)},
	{22156, S_028430_STENCILMASK(~0u)},
	{22168, S_028430_STENCILWRITEMASK(~0u)},
	{22185, S_028430_STENCILOPVAL(~0u)},
	/* 1322 */
	{22198, S_028434_STENCILTESTVAL_BF(~0u)},
	{22216, S_028434_STENCILMASK_BF(~0u)},
	{22231, S_028434_STENCILWRITEMASK_BF(~0u)},
	{22251, S_028434_STENCILOPVAL_BF(~0u)},
	/* 1326 */
	{669, S_028644_OFFSET(~0u)},
	{22274, S_028644_DEFAULT_VAL(~0u), 1, 789},
	{22286, S_028644_FLAT_SHADE(~0u)},
	{22297, S_028644_CYL_WRAP(~0u)},
	{22306, S_028644_PT_SPRITE_TEX(~0u)},
	{22320, S_028644_DUP(~0u)},
	{22324, S_028644_FP16_INTERP_MODE(~0u)},
	{22341, S_028644_USE_DEFAULT_ATTR1(~0u)},
	{22359, S_028644_DEFAULT_VAL_ATTR1(~0u)},
	{22377, S_028644_PT_SPRITE_TEX_ATTR1(~0u)},
	{22397, S_028644_ATTR0_VALID(~0u)},
	{22409, S_028644_ATTR1_VALID(~0u)},
	/* 1338 */
	{22421, S_0286C4_VS_EXPORT_COUNT(~0u)},
	{22437, S_0286C4_VS_HALF_PACK(~0u)},
	{22450, S_0286C4_VS_EXPORTS_FOG(~0u)},
	{22465, S_0286C4_VS_OUT_FOG_VEC_ADDR(~0u)},
	/* 1342 */
	{22485, S_0286CC_PERSP_SAMPLE_ENA(~0u)},
	{22502, S_0286CC_PERSP_CENTER_ENA(~0u)},
	{22519, S_0286CC_PERSP_CENTROID_ENA(~0u)},
	{22538, S_0286CC_PERSP_PULL_MODEL_ENA(~0u)},
	{22559, S_0286CC_LINEAR_SAMPLE_ENA(~0u)},
	{22577, S_0286CC_LINEAR_CENTER_ENA(~0u)},
	{22595, S_0286CC_LINEAR_CENTROID_ENA(~0u)},
	{22615, S_0286CC_LINE_STIPPLE_TEX_ENA(~0u)},
	{22636, S_0286CC_POS_X_FLOAT_ENA(~0u)},
	{22652, S_0286CC_POS_Y_FLOAT_ENA(~0u)},
	{22668, S_0286CC_POS_Z_FLOAT_ENA(~0u)},
	{22684, S_0286CC_POS_W_FLOAT_ENA(~0u)},
	{22700, S_0286CC_FRONT_FACE_ENA(~0u)},
	{22715, S_0286CC_ANCILLARY_ENA(~0u)},
	{22729, S_0286CC_SAMPLE_COVERAGE_ENA(~0u)},
	{22749, S_0286CC_POS_FIXED_PT_ENA(~0u)},
	/* 1358 */
	{22485, S_0286D0_PERSP_SAMPLE_ENA(~0u)},
	{22502, S_0286D0_PERSP_CENTER_ENA(~0u)},
	{22519, S_0286D0_PERSP_CENTROID_ENA(~0u)},
	{22538, S_0286D0_PERSP_PULL_MODEL_ENA(~0u)},
	{22559, S_0286D0_LINEAR_SAMPLE_ENA(~0u)},
	{22577, S_0286D0_LINEAR_CENTER_ENA(~0u)},
	{22595, S_0286D0_LINEAR_CENTROID_ENA(~0u)},
	{22615, S_0286D0_LINE_STIPPLE_TEX_ENA(~0u)},
	{22636, S_0286D0_POS_X_FLOAT_ENA(~0u)},
	{22652, S_0286D0_POS_Y_FLOAT_ENA(~0u)},
	{22668, S_0286D0_POS_Z_FLOAT_ENA(~0u)},
	{22684, S_0286D0_POS_W_FLOAT_ENA(~0u)},
	{22700, S_0286D0_FRONT_FACE_ENA(~0u)},
	{22715, S_0286D0_ANCILLARY_ENA(~0u)},
	{22729, S_0286D0_SAMPLE_COVERAGE_ENA(~0u)},
	{22749, S_0286D0_POS_FIXED_PT_ENA(~0u)},
	/* 1374 */
	{22766, S_0286D4_FLAT_SHADE_ENA(~0u)},
	{22781, S_0286D4_PNT_SPRITE_ENA(~0u)},
	{22904, S_0286D4_PNT_SPRITE_OVRD_X(~0u), 5, 790},
	{22922, S_0286D4_PNT_SPRITE_OVRD_Y(~0u), 5, 790},
	{22940, S_0286D4_PNT_SPRITE_OVRD_Z(~0u), 5, 790},
	{22958, S_0286D4_PNT_SPRITE_OVRD_W(~0u), 5, 790},
	{22976, S_0286D4_PNT_SPRITE_TOP_1(~0u)},
	/* 1381 */
	{22993, S_0286D8_NUM_INTERP(~0u)},
	{23004, S_0286D8_PARAM_GEN(~0u)},
	{23014, S_0286D8_FOG_ADDR(~0u)},
	{23023, S_0286D8_BC_OPTIMIZE_DISABLE(~0u)},
	{23043, S_0286D8_PASS_FOG_THROUGH_PS(~0u)},
	/* 1386 */
	{23063, S_0286E0_PERSP_CENTER_CNTL(~0u)},
	{23081, S_0286E0_PERSP_CENTROID_CNTL(~0u)},
	{23101, S_0286E0_LINEAR_CENTER_CNTL(~0u)},
	{23120, S_0286E0_LINEAR_CENTROID_CNTL(~0u)},
	{23190, S_0286E0_POS_FLOAT_LOCATION(~0u), 1, 795},
	{23209, S_0286E0_POS_FLOAT_ULC(~0u)},
	{23223, S_0286E0_FRONT_FACE_ALL_BITS(~0u)},
	/* 1393 */
	{16328, S_0286E8_WAVES(~0u)},
	{16334, S_0286E8_WAVESIZE(~0u)},
	/* 1395 */
	{23243, S_028704_NUM_PS_WAVES(~0u)},
	{23256, S_028704_NUM_VS_WAVES(~0u)},
	{23269, S_028704_NUM_GS_WAVES(~0u)},
	{23282, S_028704_NUM_ES_WAVES(~0u)},
	{23295, S_028704_NUM_HS_WAVES(~0u)},
	/* 1400 */
	{23308, S_028708_NUM_LS_WAVES(~0u)},
	/* 1401 */
	{23409, S_02870C_POS0_EXPORT_FORMAT(~0u), 5, 796},
	{23428, S_02870C_POS1_EXPORT_FORMAT(~0u), 5, 796},
	{23447, S_02870C_POS2_EXPORT_FORMAT(~0u), 5, 796},
	{23466, S_02870C_POS3_EXPORT_FORMAT(~0u), 5, 796},
	/* 1405 */
	{23685, S_028710_Z_EXPORT_FORMAT(~0u), 10, 801},
	/* 1406 */
	{23701, S_028714_COL0_EXPORT_FORMAT(~0u), 10, 801},
	{23720, S_028714_COL1_EXPORT_FORMAT(~0u), 10, 801},
	{23739, S_028714_COL2_EXPORT_FORMAT(~0u), 10, 801},
	{23758, S_028714_COL3_EXPORT_FORMAT(~0u), 10, 801},
	{23777, S_028714_COL4_EXPORT_FORMAT(~0u), 10, 801},
	{23796, S_028714_COL5_EXPORT_FORMAT(~0u), 10, 801},
	{23815, S_028714_COL6_EXPORT_FORMAT(~0u), 10, 801},
	{23834, S_028714_COL7_EXPORT_FORMAT(~0u), 10, 801},
	/* 1414 */
	{24088, S_028754_MRT0(~0u), 11, 811},
	{24093, S_028754_MRT1(~0u)},
	{24098, S_028754_MRT2(~0u)},
	{24103, S_028754_MRT3(~0u)},
	{24108, S_028754_MRT4(~0u)},
	{24113, S_028754_MRT5(~0u)},
	{24118, S_028754_MRT6(~0u)},
	{24123, S_028754_MRT7(~0u)},
	/* 1422 */
	{24208, S_028758_MRT0_EPSILON(~0u), 16, 822},
	{24221, S_028758_MRT1_EPSILON(~0u)},
	{24234, S_028758_MRT2_EPSILON(~0u)},
	{24247, S_028758_MRT3_EPSILON(~0u)},
	{24260, S_028758_MRT4_EPSILON(~0u)},
	{24273, S_028758_MRT5_EPSILON(~0u)},
	{24286, S_028758_MRT6_EPSILON(~0u)},
	{24299, S_028758_MRT7_EPSILON(~0u)},
	/* 1430 */
	{24312, S_02875C_MRT0_COLOR_OPT_DISABLE(~0u)},
	{24335, S_02875C_MRT0_ALPHA_OPT_DISABLE(~0u)},
	{24358, S_02875C_MRT1_COLOR_OPT_DISABLE(~0u)},
	{24381, S_02875C_MRT1_ALPHA_OPT_DISABLE(~0u)},
	{24404, S_02875C_MRT2_COLOR_OPT_DISABLE(~0u)},
	{24427, S_02875C_MRT2_ALPHA_OPT_DISABLE(~0u)},
	{24450, S_02875C_MRT3_COLOR_OPT_DISABLE(~0u)},
	{24473, S_02875C_MRT3_ALPHA_OPT_DISABLE(~0u)},
	{24496, S_02875C_MRT4_COLOR_OPT_DISABLE(~0u)},
	{24519, S_02875C_MRT4_ALPHA_OPT_DISABLE(~0u)},
	{24542, S_02875C_MRT5_COLOR_OPT_DISABLE(~0u)},
	{24565, S_02875C_MRT5_ALPHA_OPT_DISABLE(~0u)},
	{24588, S_02875C_MRT6_COLOR_OPT_DISABLE(~0u)},
	{24611, S_02875C_MRT6_ALPHA_OPT_DISABLE(~0u)},
	{24634, S_02875C_MRT7_COLOR_OPT_DISABLE(~0u)},
	{24657, S_02875C_MRT7_ALPHA_OPT_DISABLE(~0u)},
	{24680, S_02875C_PIXEN_ZERO_OPT_DISABLE(~0u)},
	/* 1447 */
	{24971, S_028760_COLOR_SRC_OPT(~0u), 8, 838},
	{24985, S_028760_COLOR_DST_OPT(~0u)},
	{25133, S_028760_COLOR_COMB_FCN(~0u), 8, 846},
	{25148, S_028760_ALPHA_SRC_OPT(~0u)},
	{25162, S_028760_ALPHA_DST_OPT(~0u)},
	{25176, S_028760_ALPHA_COMB_FCN(~0u)},
	/* 1453 */
	{24971, S_028764_COLOR_SRC_OPT(~0u)},
	{24985, S_028764_COLOR_DST_OPT(~0u)},
	{25133, S_028764_COLOR_COMB_FCN(~0u)},
	{25148, S_028764_ALPHA_SRC_OPT(~0u)},
	{25162, S_028764_ALPHA_DST_OPT(~0u)},
	{25176, S_028764_ALPHA_COMB_FCN(~0u)},
	/* 1459 */
	{24971, S_028768_COLOR_SRC_OPT(~0u)},
	{24985, S_028768_COLOR_DST_OPT(~0u)},
	{25133, S_028768_COLOR_COMB_FCN(~0u)},
	{25148, S_028768_ALPHA_SRC_OPT(~0u)},
	{25162, S_028768_ALPHA_DST_OPT(~0u)},
	{25176, S_028768_ALPHA_COMB_FCN(~0u)},
	/* 1465 */
	{24971, S_02876C_COLOR_SRC_OPT(~0u)},
	{24985, S_02876C_COLOR_DST_OPT(~0u)},
	{25133, S_02876C_COLOR_COMB_FCN(~0u)},
	{25148, S_02876C_ALPHA_SRC_OPT(~0u)},
	{25162, S_02876C_ALPHA_DST_OPT(~0u)},
	{25176, S_02876C_ALPHA_COMB_FCN(~0u)},
	/* 1471 */
	{24971, S_028770_COLOR_SRC_OPT(~0u)},
	{24985, S_028770_COLOR_DST_OPT(~0u)},
	{25133, S_028770_COLOR_COMB_FCN(~0u)},
	{25148, S_028770_ALPHA_SRC_OPT(~0u)},
	{25162, S_028770_ALPHA_DST_OPT(~0u)},
	{25176, S_028770_ALPHA_COMB_FCN(~0u)},
	/* 1477 */
	{24971, S_028774_COLOR_SRC_OPT(~0u)},
	{24985, S_028774_COLOR_DST_OPT(~0u)},
	{25133, S_028774_COLOR_COMB_FCN(~0u)},
	{25148, S_028774_ALPHA_SRC_OPT(~0u)},
	{25162, S_028774_ALPHA_DST_OPT(~0u)},
	{25176, S_028774_ALPHA_COMB_FCN(~0u)},
	/* 1483 */
	{24971, S_028778_COLOR_SRC_OPT(~0u)},
	{24985, S_028778_COLOR_DST_OPT(~0u)},
	{25133, S_028778_COLOR_COMB_FCN(~0u)},
	{25148, S_028778_ALPHA_SRC_OPT(~0u)},
	{25162, S_028778_ALPHA_DST_OPT(~0u)},
	{25176, S_028778_ALPHA_COMB_FCN(~0u)},
	/* 1489 */
	{24971, S_02877C_COLOR_SRC_OPT(~0u)},
	{24985, S_02877C_COLOR_DST_OPT(~0u)},
	{25133, S_02877C_COLOR_COMB_FCN(~0u)},
	{25148, S_02877C_ALPHA_SRC_OPT(~0u)},
	{25162, S_02877C_ALPHA_DST_OPT(~0u)},
	{25176, S_02877C_ALPHA_COMB_FCN(~0u)},
	/* 1495 */
	{25585, S_028780_COLOR_SRCBLEND(~0u), 21, 854},
	{25133, S_028780_COLOR_COMB_FCN(~0u), 5, 875},
	{25690, S_028780_COLOR_DESTBLEND(~0u), 21, 854},
	{25706, S_028780_ALPHA_SRCBLEND(~0u), 21, 854},
	{25176, S_028780_ALPHA_COMB_FCN(~0u), 5, 875},
	{25721, S_028780_ALPHA_DESTBLEND(~0u), 21, 854},
	{25737, S_028780_SEPARATE_ALPHA_BLEND(~0u)},
	{842, S_028780_ENABLE(~0u)},
	{25758, S_028780_DISABLE_ROP3(~0u)},
	/* 1504 */
	{25771, S_0287CC_SRC_STATE_ID(~0u)},
	/* 1505 */
	{25784, S_0287E4_BASE_ADDR(~0u)},
	/* 1506 */
	{25872, S_0287F0_SOURCE_SELECT(~0u), 4, 880},
	{25918, S_0287F0_MAJOR_MODE(~0u), 2, 884},
	{25929, S_0287F0_NOT_EOP(~0u)},
	{25937, S_0287F0_USE_OPAQUE(~0u)},
	/* 1510 */
	{25948, S_0287F8_ADDRESS_LOW(~0u)},
	/* 1511 */
	{25960, S_028800_STENCIL_ENABLE(~0u)},
	{18106, S_028800_Z_ENABLE(~0u)},
	{25975, S_028800_Z_WRITE_ENABLE(~0u)},
	{25990, S_028800_DEPTH_BOUNDS_ENABLE(~0u)},
	{18906, S_028800_ZFUNC(~0u), 8, 886},
	{26105, S_028800_BACKFACE_ENABLE(~0u)},
	{26208, S_028800_STENCILFUNC(~0u), 8, 894},
	{26220, S_028800_STENCILFUNC_BF(~0u), 8, 894},
	{26235, S_028800_ENABLE_COLOR_WRITES_ON_DEPTH_FAIL(~0u)},
	{26269, S_028800_DISABLE_COLOR_WRITES_ON_DEPTH_PASS(~0u)},
	/* 1521 */
	{26304, S_028804_MAX_ANCHOR_SAMPLES(~0u)},
	{26323, S_028804_PS_ITER_SAMPLES(~0u)},
	{26339, S_028804_MASK_EXPORT_NUM_SAMPLES(~0u)},
	{26363, S_028804_ALPHA_TO_MASK_NUM_SAMPLES(~0u)},
	{26389, S_028804_HIGH_QUALITY_INTERSECTIONS(~0u)},
	{26416, S_028804_INCOHERENT_EQAA_READS(~0u)},
	{26438, S_028804_INTERPOLATE_COMP_Z(~0u)},
	{26457, S_028804_INTERPOLATE_SRC_Z(~0u)},
	{26475, S_028804_STATIC_ANCHOR_ASSOCIATIONS(~0u)},
	{26502, S_028804_ALPHA_TO_MASK_EQAA_DISABLE(~0u)},
	{26529, S_028804_OVERRASTERIZATION_AMOUNT(~0u)},
	{26554, S_028804_ENABLE_POSTZ_OVERRASTERIZATION(~0u)},
	/* 1533 */
	{26585, S_028808_DISABLE_DUAL_QUAD(~0u)},
	{26603, S_028808_DEGAMMA_ENABLE(~0u)},
	{12462, S_028808_MODE(~0u), 7, 902},
	{25766, S_028808_ROP3(~0u), 256, 909},
	/* 1537 */
	{26908, S_02880C_Z_EXPORT_ENABLE(~0u)},
	{26924, S_02880C_STENCIL_TEST_VAL_EXPORT_ENABLE(~0u)},
	{26955, S_02880C_STENCIL_OP_VAL_EXPORT_ENABLE(~0u)},
	{18164, S_02880C_Z_ORDER(~0u), 4, 1165},
	{27034, S_02880C_KILL_ENABLE(~0u)},
	{27046, S_02880C_COVERAGE_TO_MASK_ENABLE(~0u)},
	{27070, S_02880C_MASK_EXPORT_ENABLE(~0u)},
	{27089, S_02880C_EXEC_ON_HIER_FAIL(~0u)},
	{27107, S_02880C_EXEC_ON_NOOP(~0u)},
	{27120, S_02880C_ALPHA_TO_MASK_DISABLE(~0u)},
	{27142, S_02880C_DEPTH_BEFORE_SHADER(~0u)},
	{27232, S_02880C_CONSERVATIVE_Z_EXPORT(~0u), 4, 1169},
	{27254, S_02880C_DUAL_QUAD_DISABLE(~0u)},
	/* 1550 */
	{27272, S_028810_UCP_ENA_0(~0u)},
	{27282, S_028810_UCP_ENA_1(~0u)},
	{27292, S_028810_UCP_ENA_2(~0u)},
	{27302, S_028810_UCP_ENA_3(~0u)},
	{27312, S_028810_UCP_ENA_4(~0u)},
	{27322, S_028810_UCP_ENA_5(~0u)},
	{27332, S_028810_PS_UCP_Y_SCALE_NEG(~0u)},
	{27351, S_028810_PS_UCP_MODE(~0u)},
	{27363, S_028810_CLIP_DISABLE(~0u)},
	{27376, S_028810_UCP_CULL_ONLY_ENA(~0u)},
	{27394, S_028810_BOUNDARY_EDGE_FLAG_ENA(~0u)},
	{27417, S_028810_DX_CLIP_SPACE_DEF(~0u)},
	{27435, S_028810_DIS_CLIP_ERR_DETECT(~0u)},
	{27455, S_028810_VTX_KILL_OR(~0u)},
	{27467, S_028810_DX_RASTERIZATION_KILL(~0u)},
	{27489, S_028810_DX_LINEAR_ATTR_CLIP_ENA(~0u)},
	{27513, S_028810_VTE_VPORT_PROVOKE_DISABLE(~0u)},
	{27539, S_028810_ZCLIP_NEAR_DISABLE(~0u)},
	{27558, S_028810_ZCLIP_FAR_DISABLE(~0u)},
	/* 1569 */
	{27576, S_028814_CULL_FRONT(~0u)},
	{27587, S_028814_CULL_BACK(~0u)},
	{27597, S_028814_FACE(~0u)},
	{27612, S_028814_POLY_MODE(~0u), 2, 1173},
	{27678, S_028814_POLYMODE_FRONT_PTYPE(~0u), 3, 1175},
	{27699, S_028814_POLYMODE_BACK_PTYPE(~0u), 3, 1175},
	{27719, S_028814_POLY_OFFSET_FRONT_ENABLE(~0u)},
	{27744, S_028814_POLY_OFFSET_BACK_ENABLE(~0u)},
	{27768, S_028814_POLY_OFFSET_PARA_ENABLE(~0u)},
	{27792, S_028814_VTX_WINDOW_OFFSET_ENABLE(~0u)},
	{27817, S_028814_PROVOKING_VTX_LAST(~0u)},
	{27836, S_028814_PERSP_CORR_DIS(~0u)},
	{27851, S_028814_MULTI_PRIM_IB_ENA(~0u)},
	/* 1582 */
	{27869, S_028818_VPORT_X_SCALE_ENA(~0u)},
	{27887, S_028818_VPORT_X_OFFSET_ENA(~0u)},
	{27906, S_028818_VPORT_Y_SCALE_ENA(~0u)},
	{27924, S_028818_VPORT_Y_OFFSET_ENA(~0u)},
	{27943, S_028818_VPORT_Z_SCALE_ENA(~0u)},
	{27961, S_028818_VPORT_Z_OFFSET_ENA(~0u)},
	{27980, S_028818_VTX_XY_FMT(~0u)},
	{27991, S_028818_VTX_Z_FMT(~0u)},
	{28001, S_028818_VTX_W0_FMT(~0u)},
	/* 1591 */
	{28012, S_02881C_CLIP_DIST_ENA_0(~0u)},
	{28028, S_02881C_CLIP_DIST_ENA_1(~0u)},
	{28044, S_02881C_CLIP_DIST_ENA_2(~0u)},
	{28060, S_02881C_CLIP_DIST_ENA_3(~0u)},
	{28076, S_02881C_CLIP_DIST_ENA_4(~0u)},
	{28092, S_02881C_CLIP_DIST_ENA_5(~0u)},
	{28108, S_02881C_CLIP_DIST_ENA_6(~0u)},
	{28124, S_02881C_CLIP_DIST_ENA_7(~0u)},
	{28140, S_02881C_CULL_DIST_ENA_0(~0u)},
	{28156, S_02881C_CULL_DIST_ENA_1(~0u)},
	{28172, S_02881C_CULL_DIST_ENA_2(~0u)},
	{28188, S_02881C_CULL_DIST_ENA_3(~0u)},
	{28204, S_02881C_CULL_DIST_ENA_4(~0u)},
	{28220, S_02881C_CULL_DIST_ENA_5(~0u)},
	{28236, S_02881C_CULL_DIST_ENA_6(~0u)},
	{28252, S_02881C_CULL_DIST_ENA_7(~0u)},
	{28268, S_02881C_USE_VTX_POINT_SIZE(~0u)},
	{28287, S_02881C_USE_VTX_EDGE_FLAG(~0u)},
	{28305, S_02881C_USE_VTX_RENDER_TARGET_INDX(~0u)},
	{28332, S_02881C_USE_VTX_VIEWPORT_INDX(~0u)},
	{28354, S_02881C_USE_VTX_KILL_FLAG(~0u)},
	{28372, S_02881C_VS_OUT_MISC_VEC_ENA(~0u)},
	{28392, S_02881C_VS_OUT_CCDIST0_VEC_ENA(~0u)},
	{28415, S_02881C_VS_OUT_CCDIST1_VEC_ENA(~0u)},
	{28438, S_02881C_VS_OUT_MISC_SIDE_BUS_ENA(~0u)},
	{28463, S_02881C_USE_VTX_GS_CUT_FLAG(~0u)},
	{28483, S_02881C_USE_VTX_LINE_WIDTH(~0u)},
	/* 1618 */
	{28502, S_028820_VTE_XY_INF_DISCARD(~0u)},
	{28521, S_028820_VTE_Z_INF_DISCARD(~0u)},
	{28539, S_028820_VTE_W_INF_DISCARD(~0u)},
	{28557, S_028820_VTE_0XNANINF_IS_0(~0u)},
	{28575, S_028820_VTE_XY_NAN_RETAIN(~0u)},
	{28593, S_028820_VTE_Z_NAN_RETAIN(~0u)},
	{28610, S_028820_VTE_W_NAN_RETAIN(~0u)},
	{28627, S_028820_VTE_W_RECIP_NAN_IS_0(~0u)},
	{28648, S_028820_VS_XY_NAN_TO_INF(~0u)},
	{28665, S_028820_VS_XY_INF_RETAIN(~0u)},
	{28682, S_028820_VS_Z_NAN_TO_INF(~0u)},
	{28698, S_028820_VS_Z_INF_RETAIN(~0u)},
	{28714, S_028820_VS_W_NAN_TO_INF(~0u)},
	{28730, S_028820_VS_W_INF_RETAIN(~0u)},
	{28746, S_028820_VS_CLIP_DIST_INF_DISCARD(~0u)},
	{28771, S_028820_VTE_NO_OUTPUT_NEG_0(~0u)},
	/* 1634 */
	{28791, S_028824_LINE_STIPPLE_RESET(~0u)},
	{28810, S_028824_EXPAND_FULL_LENGTH(~0u)},
	{28829, S_028824_FRACTIONAL_ACCUM(~0u)},
	{28846, S_028824_DIAMOND_ADJUST(~0u)},
	/* 1638 */
	{28861, S_02882C_TRIANGLE_FILTER_DISABLE(~0u)},
	{28885, S_02882C_LINE_FILTER_DISABLE(~0u)},
	{28905, S_02882C_POINT_FILTER_DISABLE(~0u)},
	{28926, S_02882C_RECTANGLE_FILTER_DISABLE(~0u)},
	{28951, S_02882C_TRIANGLE_EXPAND_ENA(~0u)},
	{28971, S_02882C_LINE_EXPAND_ENA(~0u)},
	{28987, S_02882C_POINT_EXPAND_ENA(~0u)},
	{29004, S_02882C_RECTANGLE_EXPAND_ENA(~0u)},
	{29025, S_02882C_PRIM_EXPAND_CONSTANT(~0u)},
	{29046, S_02882C_XMAX_RIGHT_EXCLUSION(~0u)},
	{29067, S_02882C_YMAX_BOTTOM_EXCLUSION(~0u)},
	/* 1649 */
	{29089, S_028830_SMALL_PRIM_FILTER_ENABLE(~0u)},
	{28861, S_028830_TRIANGLE_FILTER_DISABLE(~0u)},
	{28885, S_028830_LINE_FILTER_DISABLE(~0u)},
	{28905, S_028830_POINT_FILTER_DISABLE(~0u)},
	{28926, S_028830_RECTANGLE_FILTER_DISABLE(~0u)},
	/* 1654 */
	{11347, S_028A00_HEIGHT(~0u)},
	{11341, S_028A00_WIDTH(~0u)},
	/* 1656 */
	{29114, S_028A04_MIN_SIZE(~0u)},
	{29123, S_028A04_MAX_SIZE(~0u)},
	/* 1658 */
	{11341, S_028A08_WIDTH(~0u)},
	/* 1659 */
	{29132, S_028A0C_LINE_PATTERN(~0u)},
	{29145, S_028A0C_REPEAT_COUNT(~0u)},
	{29158, S_028A0C_PATTERN_BIT_ORDER(~0u)},
	{29176, S_028A0C_AUTO_RESET_CNTL(~0u)},
	/* 1663 */
	{29297, S_028A10_PATH_SELECT(~0u), 5, 1178},
	/* 1664 */
	{29309, S_028A14_TESS_MODE(~0u)},
	/* 1665 */
	{29319, S_028A20_REUSE_DEPTH(~0u)},
	/* 1666 */
	{5964, S_028A24_PRIM_TYPE(~0u), 18, 1183},
	{29686, S_028A24_RETAIN_ORDER(~0u)},
	{29699, S_028A24_RETAIN_QUADS(~0u)},
	{29780, S_028A24_PRIM_ORDER(~0u), 5, 1201},
	/* 1670 */
	{29791, S_028A28_FIRST_DECR(~0u)},
	/* 1671 */
	{29797, S_028A2C_DECR(~0u)},
	/* 1672 */
	{29802, S_028A30_COMP_X_EN(~0u)},
	{29812, S_028A30_COMP_Y_EN(~0u)},
	{29822, S_028A30_COMP_Z_EN(~0u)},
	{29832, S_028A30_COMP_W_EN(~0u)},
	{8470, S_028A30_STRIDE(~0u)},
	{29842, S_028A30_SHIFT(~0u)},
	/* 1678 */
	{29802, S_028A34_COMP_X_EN(~0u)},
	{29812, S_028A34_COMP_Y_EN(~0u)},
	{29822, S_028A34_COMP_Z_EN(~0u)},
	{29832, S_028A34_COMP_W_EN(~0u)},
	{8470, S_028A34_STRIDE(~0u)},
	{29842, S_028A34_SHIFT(~0u)},
	/* 1684 */
	{30007, S_028A38_X_CONV(~0u), 9, 1206},
	{19399, S_028A38_X_OFFSET(~0u)},
	{30014, S_028A38_Y_CONV(~0u), 9, 1206},
	{19415, S_028A38_Y_OFFSET(~0u)},
	{30021, S_028A38_Z_CONV(~0u), 9, 1206},
	{30028, S_028A38_Z_OFFSET(~0u)},
	{30037, S_028A38_W_CONV(~0u), 9, 1206},
	{30044, S_028A38_W_OFFSET(~0u)},
	/* 1692 */
	{30007, S_028A3C_X_CONV(~0u), 9, 1206},
	{19399, S_028A3C_X_OFFSET(~0u)},
	{30014, S_028A3C_Y_CONV(~0u), 9, 1206},
	{19415, S_028A3C_Y_OFFSET(~0u)},
	{30021, S_028A3C_Z_CONV(~0u), 9, 1206},
	{30028, S_028A3C_Z_OFFSET(~0u)},
	{30037, S_028A3C_W_CONV(~0u), 9, 1206},
	{30044, S_028A3C_W_OFFSET(~0u)},
	/* 1700 */
	{12462, S_028A40_MODE(~0u), 6, 1215},
	{8531, S_028A40_RESERVED_0(~0u)},
	{30171, S_028A40_CUT_MODE(~0u), 4, 1221},
	{8549, S_028A40_RESERVED_1(~0u)},
	{30180, S_028A40_GS_C_PACK_EN(~0u)},
	{30193, S_028A40_RESERVED_2(~0u)},
	{30204, S_028A40_ES_PASSTHRU(~0u)},
	{30216, S_028A40_COMPUTE_MODE(~0u)},
	{30229, S_028A40_FAST_COMPUTE_MODE(~0u)},
	{30247, S_028A40_ELEMENT_INFO_EN(~0u)},
	{30263, S_028A40_PARTIAL_THD_AT_EOI(~0u)},
	{30282, S_028A40_SUPPRESS_CUTS(~0u)},
	{30296, S_028A40_ES_WRITE_OPTIMIZE(~0u)},
	{30314, S_028A40_GS_WRITE_OPTIMIZE(~0u)},
	{30365, S_028A40_ONCHIP(~0u), 4, 1225},
	/* 1715 */
	{30372, S_028A44_ES_VERTS_PER_SUBGRP(~0u)},
	{30392, S_028A44_GS_PRIMS_PER_SUBGRP(~0u)},
	/* 1717 */
	{30412, S_028A48_MSAA_ENABLE(~0u)},
	{30424, S_028A48_VPORT_SCISSOR_ENABLE(~0u)},
	{30445, S_028A48_LINE_STIPPLE_ENABLE(~0u)},
	{30465, S_028A48_SEND_UNLIT_STILES_TO_PKR(~0u)},
	/* 1721 */
	{30490, S_028A4C_WALK_SIZE(~0u)},
	{30500, S_028A4C_WALK_ALIGNMENT(~0u)},
	{30515, S_028A4C_WALK_ALIGN8_PRIM_FITS_ST(~0u)},
	{30540, S_028A4C_WALK_FENCE_ENABLE(~0u)},
	{30558, S_028A4C_WALK_FENCE_SIZE(~0u)},
	{30574, S_028A4C_SUPERTILE_WALK_ORDER_ENABLE(~0u)},
	{30579, S_028A4C_TILE_WALK_ORDER_ENABLE(~0u)},
	{30602, S_028A4C_TILE_COVER_DISABLE(~0u)},
	{30621, S_028A4C_TILE_COVER_NO_SCISSOR(~0u)},
	{30643, S_028A4C_ZMM_LINE_EXTENT(~0u)},
	{30659, S_028A4C_ZMM_LINE_OFFSET(~0u)},
	{30675, S_028A4C_ZMM_RECT_EXTENT(~0u)},
	{30691, S_028A4C_KILL_PIX_POST_HI_Z(~0u)},
	{30710, S_028A4C_KILL_PIX_POST_DETAIL_MASK(~0u)},
	{30736, S_028A4C_PS_ITER_SAMPLE(~0u)},
	{30751, S_028A4C_MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE(~0u)},
	{30791, S_028A4C_MULTI_GPU_SUPERTILE_ENABLE(~0u)},
	{30818, S_028A4C_GPU_ID_OVERRIDE_ENABLE(~0u)},
	{30841, S_028A4C_GPU_ID_OVERRIDE(~0u)},
	{30857, S_028A4C_MULTI_GPU_PRIM_DISCARD_ENABLE(~0u)},
	{30887, S_028A4C_FORCE_EOV_CNTDWN_ENABLE(~0u)},
	{30911, S_028A4C_FORCE_EOV_REZ_ENABLE(~0u)},
	{30932, S_028A4C_OUT_OF_ORDER_PRIMITIVE_ENABLE(~0u)},
	{30962, S_028A4C_OUT_OF_ORDER_WATER_MARK(~0u)},
	/* 1745 */
	{30986, S_028A54_GS_PER_ES(~0u)},
	/* 1746 */
	{30996, S_028A58_ES_PER_GS(~0u)},
	/* 1747 */
	{31006, S_028A5C_GS_PER_VS(~0u)},
	/* 1748 */
	{669, S_028A60_OFFSET(~0u)},
	/* 1749 */
	{669, S_028A64_OFFSET(~0u)},
	/* 1750 */
	{669, S_028A68_OFFSET(~0u)},
	/* 1751 */
	{31084, S_028A6C_OUTPRIM_TYPE(~0u), 3, 1229},
	{31097, S_028A6C_OUTPRIM_TYPE_1(~0u)},
	{31112, S_028A6C_OUTPRIM_TYPE_2(~0u)},
	{31127, S_028A6C_OUTPRIM_TYPE_3(~0u)},
	{31142, S_028A6C_UNIQUE_TYPE_PER_STREAM(~0u)},
	/* 1756 */
	{203, S_028A7C_INDEX_TYPE(~0u), 3, 1232},
	{31279, S_028A7C_SWAP_MODE(~0u), 4, 1235},
	{31340, S_028A7C_BUF_TYPE(~0u), 3, 1239},
	{31382, S_028A7C_RDREQ_POLICY(~0u), 2, 1242},
	{31395, S_028A7C_RDREQ_POLICY_VI(~0u)},
	{9255, S_028A7C_ATC(~0u)},
	{25929, S_028A7C_NOT_EOP(~0u)},
	{31411, S_028A7C_REQ_PATH(~0u)},
	{9276, S_028A7C_MTYPE(~0u)},
	/* 1765 */
	{31420, S_028A84_PRIMITIVEID_EN(~0u)},
	{31435, S_028A84_DISABLE_RESET_ON_EOI(~0u)},
	/* 1767 */
	{32391, S_028A90_EVENT_TYPE(~0u), 59, 1244},
	{8459, S_028A90_ADDRESS_HI(~0u)},
	{32402, S_028A90_EXTENDED_EVENT(~0u)},
	/* 1770 */
	{32417, S_028A94_RESET_EN(~0u)},
	/* 1771 */
	{32426, S_028AA8_PRIMGROUP_SIZE(~0u)},
	{32441, S_028AA8_PARTIAL_VS_WAVE_ON(~0u)},
	{32460, S_028AA8_SWITCH_ON_EOP(~0u)},
	{32474, S_028AA8_PARTIAL_ES_WAVE_ON(~0u)},
	{32493, S_028AA8_SWITCH_ON_EOI(~0u)},
	{32507, S_028AA8_WD_SWITCH_ON_EOP(~0u)},
	{32524, S_028AA8_MAX_PRIMGRP_IN_WAVE(~0u)},
	/* 1778 */
	{32544, S_028AAC_ITEMSIZE(~0u)},
	/* 1779 */
	{32544, S_028AB0_ITEMSIZE(~0u)},
	/* 1780 */
	{32553, S_028AB4_REUSE_OFF(~0u)},
	/* 1781 */
	{32563, S_028AB8_VTX_CNT_EN(~0u)},
	/* 1782 */
	{12567, S_028ABC_LINEAR(~0u)},
	{32574, S_028ABC_FULL_CACHE(~0u)},
	{32585, S_028ABC_HTILE_USES_PRELOAD_WIN(~0u)},
	{32608, S_028ABC_PRELOAD(~0u)},
	{32616, S_028ABC_PREFETCH_WIDTH(~0u)},
	{32631, S_028ABC_PREFETCH_HEIGHT(~0u)},
	{32647, S_028ABC_DST_OUTSIDE_ZERO_TO_ONE(~0u)},
	{32671, S_028ABC_TC_COMPATIBLE(~0u)},
	/* 1790 */
	{32685, S_028AC0_COMPAREFUNC0(~0u), 8, 894},
	{32698, S_028AC0_COMPAREVALUE0(~0u)},
	{32712, S_028AC0_COMPAREMASK0(~0u)},
	{18125, S_028AC0_ENABLE0(~0u)},
	/* 1794 */
	{32725, S_028AC4_COMPAREFUNC1(~0u), 8, 894},
	{32738, S_028AC4_COMPAREVALUE1(~0u)},
	{32752, S_028AC4_COMPAREMASK1(~0u)},
	{18143, S_028AC4_ENABLE1(~0u)},
	/* 1798 */
	{32765, S_028AC8_START_X(~0u)},
	{32773, S_028AC8_START_Y(~0u)},
	{32781, S_028AC8_MAX_X(~0u)},
	{32787, S_028AC8_MAX_Y(~0u)},
	/* 1802 */
	{8470, S_028AD4_STRIDE(~0u)},
	/* 1803 */
	{8470, S_028AE4_STRIDE(~0u)},
	/* 1804 */
	{8470, S_028AF4_STRIDE(~0u)},
	/* 1805 */
	{8470, S_028B04_STRIDE(~0u)},
	/* 1806 */
	{32793, S_028B30_VERTEX_STRIDE(~0u)},
	/* 1807 */
	{32807, S_028B38_MAX_VERT_OUT(~0u)},
	/* 1808 */
	{32820, S_028B50_ACCUM_ISOLINE(~0u)},
	{32834, S_028B50_ACCUM_TRI(~0u)},
	{32844, S_028B50_ACCUM_QUAD(~0u)},
	{32855, S_028B50_DONUT_SPLIT(~0u)},
	{32867, S_028B50_TRAP_SPLIT(~0u)},
	/* 1813 */
	{17290, S_028B54_LS_EN(~0u), 3, 1303},
	{17284, S_028B54_HS_EN(~0u)},
	{17278, S_028B54_ES_EN(~0u), 3, 1306},
	{17272, S_028B54_GS_EN(~0u)},
	{17266, S_028B54_VS_EN(~0u), 3, 1309},
	{33001, S_028B54_DYNAMIC_HS(~0u)},
	{15821, S_028B54_DISPATCH_DRAW_EN(~0u)},
	{33012, S_028B54_DIS_DEALLOC_ACCUM_0(~0u)},
	{33032, S_028B54_DIS_DEALLOC_ACCUM_1(~0u)},
	{33052, S_028B54_VS_WAVE_ID_EN(~0u)},
	/* 1823 */
	{33066, S_028B58_NUM_PATCHES(~0u)},
	{33078, S_028B58_HS_NUM_INPUT_CP(~0u)},
	{33094, S_028B58_HS_NUM_OUTPUT_CP(~0u)},
	/* 1826 */
	{32544, S_028B5C_ITEMSIZE(~0u)},
	/* 1827 */
	{32544, S_028B60_ITEMSIZE(~0u)},
	/* 1828 */
	{32544, S_028B64_ITEMSIZE(~0u)},
	/* 1829 */
	{32544, S_028B68_ITEMSIZE(~0u)},
	/* 1830 */
	{209, S_028B6C_TYPE(~0u), 3, 1312},
	{33200, S_028B6C_PARTITIONING(~0u), 4, 1315},
	{33277, S_028B6C_TOPOLOGY(~0u), 4, 1319},
	{33286, S_028B6C_RESERVED_REDUC_AXIS(~0u)},
	{33306, S_028B6C_DEPRECATED(~0u)},
	{33317, S_028B6C_NUM_DS_WAVES_PER_SIMD(~0u)},
	{33339, S_028B6C_DISABLE_DONUTS(~0u)},
	{31382, S_028B6C_RDREQ_POLICY(~0u), 3, 1323},
	{31395, S_028B6C_RDREQ_POLICY_VI(~0u)},
	{33478, S_028B6C_DISTRIBUTION_MODE(~0u), 4, 1326},
	{9276, S_028B6C_MTYPE(~0u)},
	/* 1841 */
	{33496, S_028B70_ALPHA_TO_MASK_ENABLE(~0u)},
	{33517, S_028B70_ALPHA_TO_MASK_OFFSET0(~0u)},
	{33539, S_028B70_ALPHA_TO_MASK_OFFSET1(~0u)},
	{33561, S_028B70_ALPHA_TO_MASK_OFFSET2(~0u)},
	{33583, S_028B70_ALPHA_TO_MASK_OFFSET3(~0u)},
	{33605, S_028B70_OFFSET_ROUND(~0u)},
	/* 1847 */
	{33618, S_028B78_POLY_OFFSET_NEG_NUM_DB_BITS(~0u)},
	{33646, S_028B78_POLY_OFFSET_DB_IS_FLOAT_FMT(~0u)},
	/* 1849 */
	{842, S_028B90_ENABLE(~0u)},
	{15737, S_028B90_CNT(~0u)},
	/* 1851 */
	{33674, S_028B94_STREAMOUT_0_EN(~0u)},
	{33689, S_028B94_STREAMOUT_1_EN(~0u)},
	{33704, S_028B94_STREAMOUT_2_EN(~0u)},
	{33719, S_028B94_STREAMOUT_3_EN(~0u)},
	{33734, S_028B94_RAST_STREAM(~0u)},
	{33746, S_028B94_RAST_STREAM_MASK(~0u)},
	{33763, S_028B94_USE_RAST_STREAM_MASK(~0u)},
	/* 1858 */
	{33784, S_028B98_STREAM_0_BUFFER_EN(~0u)},
	{33803, S_028B98_STREAM_1_BUFFER_EN(~0u)},
	{33822, S_028B98_STREAM_2_BUFFER_EN(~0u)},
	{33841, S_028B98_STREAM_3_BUFFER_EN(~0u)},
	/* 1862 */
	{33860, S_028BD4_DISTANCE_0(~0u)},
	{33871, S_028BD4_DISTANCE_1(~0u)},
	{33882, S_028BD4_DISTANCE_2(~0u)},
	{33893, S_028BD4_DISTANCE_3(~0u)},
	{33904, S_028BD4_DISTANCE_4(~0u)},
	{33915, S_028BD4_DISTANCE_5(~0u)},
	{33926, S_028BD4_DISTANCE_6(~0u)},
	{33937, S_028BD4_DISTANCE_7(~0u)},
	/* 1870 */
	{33948, S_028BD8_DISTANCE_8(~0u)},
	{33959, S_028BD8_DISTANCE_9(~0u)},
	{33970, S_028BD8_DISTANCE_10(~0u)},
	{33982, S_028BD8_DISTANCE_11(~0u)},
	{33994, S_028BD8_DISTANCE_12(~0u)},
	{34006, S_028BD8_DISTANCE_13(~0u)},
	{34018, S_028BD8_DISTANCE_14(~0u)},
	{34030, S_028BD8_DISTANCE_15(~0u)},
	/* 1878 */
	{34042, S_028BDC_EXPAND_LINE_WIDTH(~0u)},
	{34060, S_028BDC_LAST_PIXEL(~0u)},
	{34071, S_028BDC_PERPENDICULAR_ENDCAP_ENA(~0u)},
	{34096, S_028BDC_DX10_DIAMOND_TEST_ENA(~0u)},
	/* 1882 */
	{34118, S_028BE0_MSAA_NUM_SAMPLES(~0u)},
	{34135, S_028BE0_AA_MASK_CENTROID_DTMN(~0u)},
	{34157, S_028BE0_MAX_SAMPLE_DIST(~0u)},
	{34173, S_028BE0_MSAA_EXPOSED_SAMPLES(~0u)},
	{34194, S_028BE0_DETAIL_TO_EXPOSED_MODE(~0u)},
	/* 1887 */
	{34217, S_028BE4_PIX_CENTER(~0u)},
	{34278, S_028BE4_ROUND_MODE(~0u), 4, 1330},
	{34494, S_028BE4_QUANT_MODE(~0u), 8, 1334},
	/* 1890 */
	{34505, S_028BF8_S0_X(~0u)},
	{34510, S_028BF8_S0_Y(~0u)},
	{34515, S_028BF8_S1_X(~0u)},
	{34520, S_028BF8_S1_Y(~0u)},
	{34525, S_028BF8_S2_X(~0u)},
	{34530, S_028BF8_S2_Y(~0u)},
	{34535, S_028BF8_S3_X(~0u)},
	{34540, S_028BF8_S3_Y(~0u)},
	/* 1898 */
	{34545, S_028BFC_S4_X(~0u)},
	{34550, S_028BFC_S4_Y(~0u)},
	{34555, S_028BFC_S5_X(~0u)},
	{34560, S_028BFC_S5_Y(~0u)},
	{34565, S_028BFC_S6_X(~0u)},
	{34570, S_028BFC_S6_Y(~0u)},
	{34575, S_028BFC_S7_X(~0u)},
	{34580, S_028BFC_S7_Y(~0u)},
	/* 1906 */
	{34585, S_028C00_S8_X(~0u)},
	{34590, S_028C00_S8_Y(~0u)},
	{34595, S_028C00_S9_X(~0u)},
	{34600, S_028C00_S9_Y(~0u)},
	{34605, S_028C00_S10_X(~0u)},
	{34611, S_028C00_S10_Y(~0u)},
	{34617, S_028C00_S11_X(~0u)},
	{34623, S_028C00_S11_Y(~0u)},
	/* 1914 */
	{34629, S_028C04_S12_X(~0u)},
	{34635, S_028C04_S12_Y(~0u)},
	{34641, S_028C04_S13_X(~0u)},
	{34647, S_028C04_S13_Y(~0u)},
	{34653, S_028C04_S14_X(~0u)},
	{34659, S_028C04_S14_Y(~0u)},
	{34665, S_028C04_S15_X(~0u)},
	{34671, S_028C04_S15_Y(~0u)},
	/* 1922 */
	{34505, S_028C08_S0_X(~0u)},
	{34510, S_028C08_S0_Y(~0u)},
	{34515, S_028C08_S1_X(~0u)},
	{34520, S_028C08_S1_Y(~0u)},
	{34525, S_028C08_S2_X(~0u)},
	{34530, S_028C08_S2_Y(~0u)},
	{34535, S_028C08_S3_X(~0u)},
	{34540, S_028C08_S3_Y(~0u)},
	/* 1930 */
	{34545, S_028C0C_S4_X(~0u)},
	{34550, S_028C0C_S4_Y(~0u)},
	{34555, S_028C0C_S5_X(~0u)},
	{34560, S_028C0C_S5_Y(~0u)},
	{34565, S_028C0C_S6_X(~0u)},
	{34570, S_028C0C_S6_Y(~0u)},
	{34575, S_028C0C_S7_X(~0u)},
	{34580, S_028C0C_S7_Y(~0u)},
	/* 1938 */
	{34585, S_028C10_S8_X(~0u)},
	{34590, S_028C10_S8_Y(~0u)},
	{34595, S_028C10_S9_X(~0u)},
	{34600, S_028C10_S9_Y(~0u)},
	{34605, S_028C10_S10_X(~0u)},
	{34611, S_028C10_S10_Y(~0u)},
	{34617, S_028C10_S11_X(~0u)},
	{34623, S_028C10_S11_Y(~0u)},
	/* 1946 */
	{34629, S_028C14_S12_X(~0u)},
	{34635, S_028C14_S12_Y(~0u)},
	{34641, S_028C14_S13_X(~0u)},
	{34647, S_028C14_S13_Y(~0u)},
	{34653, S_028C14_S14_X(~0u)},
	{34659, S_028C14_S14_Y(~0u)},
	{34665, S_028C14_S15_X(~0u)},
	{34671, S_028C14_S15_Y(~0u)},
	/* 1954 */
	{34505, S_028C18_S0_X(~0u)},
	{34510, S_028C18_S0_Y(~0u)},
	{34515, S_028C18_S1_X(~0u)},
	{34520, S_028C18_S1_Y(~0u)},
	{34525, S_028C18_S2_X(~0u)},
	{34530, S_028C18_S2_Y(~0u)},
	{34535, S_028C18_S3_X(~0u)},
	{34540, S_028C18_S3_Y(~0u)},
	/* 1962 */
	{34545, S_028C1C_S4_X(~0u)},
	{34550, S_028C1C_S4_Y(~0u)},
	{34555, S_028C1C_S5_X(~0u)},
	{34560, S_028C1C_S5_Y(~0u)},
	{34565, S_028C1C_S6_X(~0u)},
	{34570, S_028C1C_S6_Y(~0u)},
	{34575, S_028C1C_S7_X(~0u)},
	{34580, S_028C1C_S7_Y(~0u)},
	/* 1970 */
	{34585, S_028C20_S8_X(~0u)},
	{34590, S_028C20_S8_Y(~0u)},
	{34595, S_028C20_S9_X(~0u)},
	{34600, S_028C20_S9_Y(~0u)},
	{34605, S_028C20_S10_X(~0u)},
	{34611, S_028C20_S10_Y(~0u)},
	{34617, S_028C20_S11_X(~0u)},
	{34623, S_028C20_S11_Y(~0u)},
	/* 1978 */
	{34629, S_028C24_S12_X(~0u)},
	{34635, S_028C24_S12_Y(~0u)},
	{34641, S_028C24_S13_X(~0u)},
	{34647, S_028C24_S13_Y(~0u)},
	{34653, S_028C24_S14_X(~0u)},
	{34659, S_028C24_S14_Y(~0u)},
	{34665, S_028C24_S15_X(~0u)},
	{34671, S_028C24_S15_Y(~0u)},
	/* 1986 */
	{34505, S_028C28_S0_X(~0u)},
	{34510, S_028C28_S0_Y(~0u)},
	{34515, S_028C28_S1_X(~0u)},
	{34520, S_028C28_S1_Y(~0u)},
	{34525, S_028C28_S2_X(~0u)},
	{34530, S_028C28_S2_Y(~0u)},
	{34535, S_028C28_S3_X(~0u)},
	{34540, S_028C28_S3_Y(~0u)},
	/* 1994 */
	{34545, S_028C2C_S4_X(~0u)},
	{34550, S_028C2C_S4_Y(~0u)},
	{34555, S_028C2C_S5_X(~0u)},
	{34560, S_028C2C_S5_Y(~0u)},
	{34565, S_028C2C_S6_X(~0u)},
	{34570, S_028C2C_S6_Y(~0u)},
	{34575, S_028C2C_S7_X(~0u)},
	{34580, S_028C2C_S7_Y(~0u)},
	/* 2002 */
	{34585, S_028C30_S8_X(~0u)},
	{34590, S_028C30_S8_Y(~0u)},
	{34595, S_028C30_S9_X(~0u)},
	{34600, S_028C30_S9_Y(~0u)},
	{34605, S_028C30_S10_X(~0u)},
	{34611, S_028C30_S10_Y(~0u)},
	{34617, S_028C30_S11_X(~0u)},
	{34623, S_028C30_S11_Y(~0u)},
	/* 2010 */
	{34629, S_028C34_S12_X(~0u)},
	{34635, S_028C34_S12_Y(~0u)},
	{34641, S_028C34_S13_X(~0u)},
	{34647, S_028C34_S13_Y(~0u)},
	{34653, S_028C34_S14_X(~0u)},
	{34659, S_028C34_S14_Y(~0u)},
	{34665, S_028C34_S15_X(~0u)},
	{34671, S_028C34_S15_Y(~0u)},
	/* 2018 */
	{34677, S_028C38_AA_MASK_X0Y0(~0u)},
	{34690, S_028C38_AA_MASK_X1Y0(~0u)},
	/* 2020 */
	{34703, S_028C3C_AA_MASK_X0Y1(~0u)},
	{34716, S_028C3C_AA_MASK_X1Y1(~0u)},
	/* 2022 */
	{34729, S_028C40_REALIGN_DQUADS_AFTER_N_WAVES(~0u)},
	/* 2023 */
	{34758, S_028C58_VTX_REUSE_DEPTH(~0u)},
	/* 2024 */
	{34774, S_028C5C_DEALLOC_DIST(~0u)},
	/* 2025 */
	{19352, S_028C64_TILE_MAX(~0u)},
	{34787, S_028C64_FMASK_TILE_MAX(~0u)},
	/* 2027 */
	{19352, S_028C68_TILE_MAX(~0u)},
	/* 2028 */
	{17994, S_028C6C_SLICE_START(~0u)},
	{18006, S_028C6C_SLICE_MAX(~0u)},
	/* 2030 */
	{34853, S_028C70_ENDIAN(~0u), 4, 1342},
	{8814, S_028C70_FORMAT(~0u), 23, 1346},
	{14209, S_028C70_LINEAR_GENERAL(~0u)},
	{35220, S_028C70_NUMBER_TYPE(~0u), 8, 1369},
	{35276, S_028C70_COMP_SWAP(~0u), 4, 1377},
	{26652, S_028C70_FAST_CLEAR(~0u)},
	{18580, S_028C70_COMPRESSION(~0u)},
	{35286, S_028C70_BLEND_CLAMP(~0u)},
	{35298, S_028C70_BLEND_BYPASS(~0u)},
	{35311, S_028C70_SIMPLE_FLOAT(~0u)},
	{34278, S_028C70_ROUND_MODE(~0u)},
	{35324, S_028C70_CMASK_IS_LINEAR(~0u)},
	{35551, S_028C70_BLEND_OPT_DONT_RD_DST(~0u), 8, 1381},
	{35573, S_028C70_BLEND_OPT_DISCARD_PIXEL(~0u), 8, 1381},
	{35597, S_028C70_FMASK_COMPRESSION_DISABLE(~0u)},
	{35623, S_028C70_FMASK_COMPRESS_1FRAG_ONLY(~0u)},
	{35649, S_028C70_DCC_ENABLE(~0u)},
	{35660, S_028C70_CMASK_ADDR_TYPE(~0u)},
	/* 2048 */
	{19180, S_028C74_TILE_MODE_INDEX(~0u)},
	{35676, S_028C74_FMASK_TILE_MODE_INDEX(~0u)},
	{35698, S_028C74_FMASK_BANK_HEIGHT(~0u)},
	{19168, S_028C74_NUM_SAMPLES(~0u)},
	{35716, S_028C74_NUM_FRAGMENTS(~0u)},
	{35730, S_028C74_FORCE_DST_ALPHA_1(~0u)},
	/* 2054 */
	{21724, S_028C78_OVERWRITE_COMBINER_DISABLE(~0u)},
	{35748, S_028C78_KEY_CLEAR_ENABLE(~0u)},
	{35765, S_028C78_MAX_UNCOMPRESSED_BLOCK_SIZE(~0u)},
	{35793, S_028C78_MIN_COMPRESSED_BLOCK_SIZE(~0u)},
	{35819, S_028C78_MAX_COMPRESSED_BLOCK_SIZE(~0u)},
	{11829, S_028C78_COLOR_TRANSFORM(~0u)},
	{35845, S_028C78_INDEPENDENT_64B_BLOCKS(~0u)},
	{35868, S_028C78_LOSSY_RGB_PRECISION(~0u)},
	{35888, S_028C78_LOSSY_ALPHA_PRECISION(~0u)},
	/* 2063 */
	{19352, S_028C80_TILE_MAX(~0u)},
	/* 2064 */
	{19352, S_028C88_TILE_MAX(~0u)},
};

static const struct si_reg sid_reg_table[] = {
	{35910, R_2C3_DRAW_INDEX_LOC, 2, 0},
	{195, R_370_CONTROL, 4, 2},
	{1103, R_371_DST_ADDR_LO},
	{1115, R_372_DST_ADDR_HI},
	{35925, R_3F0_IB_BASE_LO},
	{35936, R_3F1_IB_BASE_HI},
	{195, R_3F2_CONTROL, 3, 6},
	{35947, R_410_CP_DMA_WORD0, 1, 9},
	{35960, R_411_CP_DMA_WORD1, 5, 10},
	{35973, R_412_CP_DMA_WORD2, 1, 15},
	{35986, R_413_CP_DMA_WORD3, 1, 16},
	{35999, R_414_COMMAND, 9, 17},
	{36007, R_500_DMA_DATA_WORD0, 4, 26},
	{1000, R_501_SRC_ADDR_LO},
	{1091, R_502_SRC_ADDR_HI},
	{1103, R_503_DST_ADDR_LO},
	{1115, R_504_DST_ADDR_HI},
	{36022, R_000E4C_SRBM_STATUS2, 21, 30},
	{36035, R_000E50_SRBM_STATUS, 20, 51},
	{36047, R_000E54_SRBM_STATUS3, 16, 71},
	{36060, R_00D034_SDMA0_STATUS_REG, 29, 87},
	{36077, R_00D834_SDMA1_STATUS_REG, 29, 87},
	{36094, R_008008_GRBM_STATUS2, 18, 116},
	{36107, R_008010_GRBM_STATUS, 24, 134},
	{36119, R_0084FC_CP_STRMOUT_CNTL, 1, 158},
	{36135, R_0085F0_CP_COHER_CNTL, 19, 159},
	{36149, R_0085F4_CP_COHER_SIZE},
	{36163, R_0085F8_CP_COHER_BASE},
	{36177, R_008014_GRBM_STATUS_SE0, 11, 178},
	{36193, R_008018_GRBM_STATUS_SE1, 11, 189},
	{36209, R_008038_GRBM_STATUS_SE2, 11, 200},
	{36225, R_00803C_GRBM_STATUS_SE3, 11, 211},
	{36119, R_0300FC_CP_STRMOUT_CNTL, 1, 222},
	{36241, R_0301E4_CP_COHER_BASE_HI, 1, 223},
	{36258, R_0301EC_CP_COHER_START_DELAY, 1, 224},
	{36135, R_0301F0_CP_COHER_CNTL, 27, 225},
	{36149, R_0301F4_CP_COHER_SIZE},
	{36163, R_0301F8_CP_COHER_BASE},
	{36279, R_0301FC_CP_COHER_STATUS, 4, 252},
	{36295, R_008210_CP_CPC_STATUS, 15, 256},
	{36309, R_008214_CP_CPC_BUSY_STAT, 28, 271},
	{36326, R_008218_CP_CPC_STALLED_STAT1, 14, 299},
	{36347, R_00821C_CP_CPF_STATUS, 21, 313},
	{36361, R_008220_CP_CPF_BUSY_STAT, 31, 334},
	{36378, R_008224_CP_CPF_STALLED_STAT1, 9, 365},
	{36399, R_030230_CP_COHER_SIZE_HI, 1, 374},
	{36416, R_0088B0_VGT_VTX_VECT_EJECT_REG, 1, 375},
	{36439, R_0088C4_VGT_CACHE_INVALIDATION, 3, 376},
	{36462, R_0088C8_VGT_ESGS_RING_SIZE},
	{36481, R_0088CC_VGT_GSVS_RING_SIZE},
	{36500, R_0088D4_VGT_GS_VERTEX_REUSE, 1, 379},
	{36520, R_008958_VGT_PRIMITIVE_TYPE, 1, 380},
	{36539, R_00895C_VGT_INDEX_TYPE, 1, 381},
	{36554, R_008960_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{36587, R_008964_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{36620, R_008968_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{36653, R_00896C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{36686, R_008970_VGT_NUM_INDICES},
	{36702, R_008974_VGT_NUM_INSTANCES},
	{36720, R_008988_VGT_TF_RING_SIZE, 1, 382},
	{36737, R_0089B0_VGT_HS_OFFCHIP_PARAM, 1, 383},
	{36758, R_0089B8_VGT_TF_MEMORY_BASE},
	{36777, R_008A14_PA_CL_ENHANCE, 4, 384},
	{36791, R_008A60_PA_SU_LINE_STIPPLE_VALUE, 1, 388},
	{36816, R_008B10_PA_SC_LINE_STIPPLE_STATE, 2, 389},
	{36841, R_008670_CP_STALLED_STAT3, 19, 391},
	{36858, R_008674_CP_STALLED_STAT1, 16, 410},
	{36875, R_008678_CP_STALLED_STAT2, 29, 426},
	{36892, R_008680_CP_STAT, 23, 455},
	{36900, R_030800_GRBM_GFX_INDEX, 6, 478},
	{36462, R_030900_VGT_ESGS_RING_SIZE},
	{36481, R_030904_VGT_GSVS_RING_SIZE},
	{36520, R_030908_VGT_PRIMITIVE_TYPE, 1, 484},
	{36539, R_03090C_VGT_INDEX_TYPE, 1, 485},
	{36554, R_030910_VGT_STRMOUT_BUFFER_FILLED_SIZE_0},
	{36587, R_030914_VGT_STRMOUT_BUFFER_FILLED_SIZE_1},
	{36620, R_030918_VGT_STRMOUT_BUFFER_FILLED_SIZE_2},
	{36653, R_03091C_VGT_STRMOUT_BUFFER_FILLED_SIZE_3},
	{36686, R_030930_VGT_NUM_INDICES},
	{36702, R_030934_VGT_NUM_INSTANCES},
	{36720, R_030938_VGT_TF_RING_SIZE, 1, 486},
	{36737, R_03093C_VGT_HS_OFFCHIP_PARAM, 2, 487},
	{36758, R_030940_VGT_TF_MEMORY_BASE},
	{36791, R_030A00_PA_SU_LINE_STIPPLE_VALUE, 1, 489},
	{36816, R_030A04_PA_SC_LINE_STIPPLE_STATE, 2, 490},
	{36915, R_030A10_PA_SC_SCREEN_EXTENT_MIN_0, 2, 492},
	{36941, R_030A14_PA_SC_SCREEN_EXTENT_MAX_0, 2, 494},
	{36967, R_030A18_PA_SC_SCREEN_EXTENT_MIN_1, 2, 496},
	{36993, R_030A2C_PA_SC_SCREEN_EXTENT_MAX_1, 2, 498},
	{37019, R_008BF0_PA_SC_ENHANCE, 9, 500},
	{37033, R_008C08_SQC_CACHES, 2, 509},
	{37033, R_030D20_SQC_CACHES, 3, 511},
	{37044, R_008C0C_SQ_RANDOM_WAVE_PRI, 3, 514},
	{37063, R_008DFC_SQ_EXP_0, 6, 517},
	{37072, R_030E00_TA_CS_BC_BASE_ADDR},
	{37091, R_030E04_TA_CS_BC_BASE_ADDR_HI, 1, 523},
	{37113, R_030F00_DB_OCCLUSION_COUNT0_LOW},
	{37137, R_008F00_SQ_BUF_RSRC_WORD0},
	{37155, R_030F04_DB_OCCLUSION_COUNT0_HI, 1, 524},
	{37178, R_008F04_SQ_BUF_RSRC_WORD1, 4, 525},
	{37196, R_030F08_DB_OCCLUSION_COUNT1_LOW},
	{37220, R_008F08_SQ_BUF_RSRC_WORD2},
	{37238, R_030F0C_DB_OCCLUSION_COUNT1_HI, 1, 529},
	{37261, R_008F0C_SQ_BUF_RSRC_WORD3, 14, 530},
	{37279, R_030F10_DB_OCCLUSION_COUNT2_LOW},
	{37303, R_008F10_SQ_IMG_RSRC_WORD0},
	{37321, R_030F14_DB_OCCLUSION_COUNT2_HI, 1, 544},
	{37344, R_008F14_SQ_IMG_RSRC_WORD1, 5, 545},
	{37362, R_030F18_DB_OCCLUSION_COUNT3_LOW},
	{37386, R_008F18_SQ_IMG_RSRC_WORD2, 4, 550},
	{37404, R_030F1C_DB_OCCLUSION_COUNT3_HI, 1, 554},
	{37427, R_008F1C_SQ_IMG_RSRC_WORD3, 11, 555},
	{37445, R_008F20_SQ_IMG_RSRC_WORD4, 2, 566},
	{37463, R_008F24_SQ_IMG_RSRC_WORD5, 2, 568},
	{37481, R_008F28_SQ_IMG_RSRC_WORD6, 8, 570},
	{37499, R_008F2C_SQ_IMG_RSRC_WORD7},
	{37517, R_008F30_SQ_IMG_SAMP_WORD0, 14, 578},
	{37535, R_008F34_SQ_IMG_SAMP_WORD1, 4, 592},
	{37553, R_008F38_SQ_IMG_SAMP_WORD2, 10, 596},
	{37571, R_008F3C_SQ_IMG_SAMP_WORD3, 2, 606},
	{37589, R_0090DC_SPI_DYN_GPR_LOCK_EN, 5, 608},
	{37609, R_0090E0_SPI_STATIC_THREAD_MGMT_1, 2, 613},
	{37634, R_0090E4_SPI_STATIC_THREAD_MGMT_2, 2, 615},
	{37659, R_0090E8_SPI_STATIC_THREAD_MGMT_3, 1, 617},
	{37684, R_0090EC_SPI_PS_MAX_WAVE_ID, 1, 618},
	{37684, R_0090E8_SPI_PS_MAX_WAVE_ID, 1, 619},
	{37703, R_0090F0_SPI_ARB_PRIORITY, 3, 620},
	{37703, R_00C700_SPI_ARB_PRIORITY, 8, 623},
	{37720, R_0090F4_SPI_ARB_CYCLES_0, 2, 631},
	{37737, R_0090F8_SPI_ARB_CYCLES_1, 1, 633},
	{37754, R_008F40_SQ_FLAT_SCRATCH_WORD0, 1, 634},
	{37776, R_008F44_SQ_FLAT_SCRATCH_WORD1, 1, 635},
	{37798, R_030FF8_DB_ZPASS_COUNT_LOW},
	{37817, R_030FFC_DB_ZPASS_COUNT_HI, 1, 636},
	{37835, R_009100_SPI_CONFIG_CNTL, 5, 637},
	{37851, R_00913C_SPI_CONFIG_CNTL_1, 5, 642},
	{37869, R_00936C_SPI_RESOURCE_RESERVE_CU_AB_0, 12, 647},
	{37072, R_00950C_TA_CS_BC_BASE_ADDR},
	{37898, R_009858_DB_SUBTILE_CONTROL, 10, 659},
	{37917, R_0098F8_GB_ADDR_CONFIG, 9, 669},
	{37932, R_009910_GB_TILE_MODE0, 10, 678},
	{37946, R_009914_GB_TILE_MODE1, 10, 678},
	{37960, R_009918_GB_TILE_MODE2, 10, 678},
	{37974, R_00991C_GB_TILE_MODE3, 10, 678},
	{37988, R_009920_GB_TILE_MODE4, 10, 678},
	{38002, R_009924_GB_TILE_MODE5, 10, 678},
	{38016, R_009928_GB_TILE_MODE6, 10, 678},
	{38030, R_00992C_GB_TILE_MODE7, 10, 678},
	{38044, R_009930_GB_TILE_MODE8, 10, 678},
	{38058, R_009934_GB_TILE_MODE9, 10, 678},
	{38072, R_009938_GB_TILE_MODE10, 10, 678},
	{38087, R_00993C_GB_TILE_MODE11, 10, 678},
	{38102, R_009940_GB_TILE_MODE12, 10, 678},
	{38117, R_009944_GB_TILE_MODE13, 10, 678},
	{38132, R_009948_GB_TILE_MODE14, 10, 678},
	{38147, R_00994C_GB_TILE_MODE15, 10, 678},
	{38162, R_009950_GB_TILE_MODE16, 10, 678},
	{38177, R_009954_GB_TILE_MODE17, 10, 678},
	{38192, R_009958_GB_TILE_MODE18, 10, 678},
	{38207, R_00995C_GB_TILE_MODE19, 10, 678},
	{38222, R_009960_GB_TILE_MODE20, 10, 678},
	{38237, R_009964_GB_TILE_MODE21, 10, 678},
	{38252, R_009968_GB_TILE_MODE22, 10, 678},
	{38267, R_00996C_GB_TILE_MODE23, 10, 678},
	{38282, R_009970_GB_TILE_MODE24, 10, 678},
	{38297, R_009974_GB_TILE_MODE25, 10, 678},
	{38312, R_009978_GB_TILE_MODE26, 10, 678},
	{38327, R_00997C_GB_TILE_MODE27, 10, 678},
	{38342, R_009980_GB_TILE_MODE28, 10, 678},
	{38357, R_009984_GB_TILE_MODE29, 10, 678},
	{38372, R_009988_GB_TILE_MODE30, 10, 678},
	{38387, R_00998C_GB_TILE_MODE31, 10, 678},
	{38402, R_009990_GB_MACROTILE_MODE0, 4, 688},
	{38421, R_009994_GB_MACROTILE_MODE1, 4, 688},
	{38440, R_009998_GB_MACROTILE_MODE2, 4, 688},
	{38459, R_00999C_GB_MACROTILE_MODE3, 4, 688},
	{38478, R_0099A0_GB_MACROTILE_MODE4, 4, 688},
	{38497, R_0099A4_GB_MACROTILE_MODE5, 4, 688},
	{38516, R_0099A8_GB_MACROTILE_MODE6, 4, 688},
	{38535, R_0099AC_GB_MACROTILE_MODE7, 4, 688},
	{38554, R_0099B0_GB_MACROTILE_MODE8, 4, 688},
	{38573, R_0099B4_GB_MACROTILE_MODE9, 4, 688},
	{38592, R_0099B8_GB_MACROTILE_MODE10, 4, 688},
	{38612, R_0099BC_GB_MACROTILE_MODE11, 4, 688},
	{38632, R_0099C0_GB_MACROTILE_MODE12, 4, 688},
	{38652, R_0099C4_GB_MACROTILE_MODE13, 4, 688},
	{38672, R_0099C8_GB_MACROTILE_MODE14, 4, 688},
	{38692, R_0099CC_GB_MACROTILE_MODE15, 4, 688},
	{38712, R_00B000_SPI_SHADER_TBA_LO_PS},
	{38733, R_00B004_SPI_SHADER_TBA_HI_PS, 1, 692},
	{38754, R_00B008_SPI_SHADER_TMA_LO_PS},
	{38775, R_00B00C_SPI_SHADER_TMA_HI_PS, 1, 693},
	{38796, R_00B01C_SPI_SHADER_PGM_RSRC3_PS, 3, 694},
	{38820, R_00B020_SPI_SHADER_PGM_LO_PS},
	{38841, R_00B024_SPI_SHADER_PGM_HI_PS, 1, 697},
	{38862, R_00B028_SPI_SHADER_PGM_RSRC1_PS, 11, 698},
	{38886, R_00B02C_SPI_SHADER_PGM_RSRC2_PS, 7, 709},
	{38910, R_00B030_SPI_SHADER_USER_DATA_PS_0},
	{38936, R_00B034_SPI_SHADER_USER_DATA_PS_1},
	{38962, R_00B038_SPI_SHADER_USER_DATA_PS_2},
	{38988, R_00B03C_SPI_SHADER_USER_DATA_PS_3},
	{39014, R_00B040_SPI_SHADER_USER_DATA_PS_4},
	{39040, R_00B044_SPI_SHADER_USER_DATA_PS_5},
	{39066, R_00B048_SPI_SHADER_USER_DATA_PS_6},
	{39092, R_00B04C_SPI_SHADER_USER_DATA_PS_7},
	{39118, R_00B050_SPI_SHADER_USER_DATA_PS_8},
	{39144, R_00B054_SPI_SHADER_USER_DATA_PS_9},
	{39170, R_00B058_SPI_SHADER_USER_DATA_PS_10},
	{39197, R_00B05C_SPI_SHADER_USER_DATA_PS_11},
	{39224, R_00B060_SPI_SHADER_USER_DATA_PS_12},
	{39251, R_00B064_SPI_SHADER_USER_DATA_PS_13},
	{39278, R_00B068_SPI_SHADER_USER_DATA_PS_14},
	{39305, R_00B06C_SPI_SHADER_USER_DATA_PS_15},
	{39332, R_00B100_SPI_SHADER_TBA_LO_VS},
	{39353, R_00B104_SPI_SHADER_TBA_HI_VS, 1, 716},
	{39374, R_00B108_SPI_SHADER_TMA_LO_VS},
	{39395, R_00B10C_SPI_SHADER_TMA_HI_VS, 1, 717},
	{39416, R_00B118_SPI_SHADER_PGM_RSRC3_VS, 3, 718},
	{39440, R_00B11C_SPI_SHADER_LATE_ALLOC_VS, 1, 721},
	{39465, R_00B120_SPI_SHADER_PGM_LO_VS},
	{39486, R_00B124_SPI_SHADER_PGM_HI_VS, 1, 722},
	{39507, R_00B128_SPI_SHADER_PGM_RSRC1_VS, 12, 723},
	{39531, R_00B12C_SPI_SHADER_PGM_RSRC2_VS, 12, 735},
	{39555, R_00B130_SPI_SHADER_USER_DATA_VS_0},
	{39581, R_00B134_SPI_SHADER_USER_DATA_VS_1},
	{39607, R_00B138_SPI_SHADER_USER_DATA_VS_2},
	{39633, R_00B13C_SPI_SHADER_USER_DATA_VS_3},
	{39659, R_00B140_SPI_SHADER_USER_DATA_VS_4},
	{39685, R_00B144_SPI_SHADER_USER_DATA_VS_5},
	{39711, R_00B148_SPI_SHADER_USER_DATA_VS_6},
	{39737, R_00B14C_SPI_SHADER_USER_DATA_VS_7},
	{39763, R_00B150_SPI_SHADER_USER_DATA_VS_8},
	{39789, R_00B154_SPI_SHADER_USER_DATA_VS_9},
	{39815, R_00B158_SPI_SHADER_USER_DATA_VS_10},
	{39842, R_00B15C_SPI_SHADER_USER_DATA_VS_11},
	{39869, R_00B160_SPI_SHADER_USER_DATA_VS_12},
	{39896, R_00B164_SPI_SHADER_USER_DATA_VS_13},
	{39923, R_00B168_SPI_SHADER_USER_DATA_VS_14},
	{39950, R_00B16C_SPI_SHADER_USER_DATA_VS_15},
	{39977, R_00B200_SPI_SHADER_TBA_LO_GS},
	{39998, R_00B204_SPI_SHADER_TBA_HI_GS, 1, 747},
	{40019, R_00B208_SPI_SHADER_TMA_LO_GS},
	{40040, R_00B20C_SPI_SHADER_TMA_HI_GS, 1, 748},
	{40061, R_00B21C_SPI_SHADER_PGM_RSRC3_GS, 4, 749},
	{40085, R_00B220_SPI_SHADER_PGM_LO_GS},
	{40106, R_00B224_SPI_SHADER_PGM_HI_GS, 1, 753},
	{40127, R_00B228_SPI_SHADER_PGM_RSRC1_GS, 11, 754},
	{40151, R_00B22C_SPI_SHADER_PGM_RSRC2_GS, 5, 765},
	{40175, R_00B230_SPI_SHADER_USER_DATA_GS_0},
	{40201, R_00B234_SPI_SHADER_USER_DATA_GS_1},
	{40227, R_00B238_SPI_SHADER_USER_DATA_GS_2},
	{40253, R_00B23C_SPI_SHADER_USER_DATA_GS_3},
	{40279, R_00B240_SPI_SHADER_USER_DATA_GS_4},
	{40305, R_00B244_SPI_SHADER_USER_DATA_GS_5},
	{40331, R_00B248_SPI_SHADER_USER_DATA_GS_6},
	{40357, R_00B24C_SPI_SHADER_USER_DATA_GS_7},
	{40383, R_00B250_SPI_SHADER_USER_DATA_GS_8},
	{40409, R_00B254_SPI_SHADER_USER_DATA_GS_9},
	{40435, R_00B258_SPI_SHADER_USER_DATA_GS_10},
	{40462, R_00B25C_SPI_SHADER_USER_DATA_GS_11},
	{40489, R_00B260_SPI_SHADER_USER_DATA_GS_12},
	{40516, R_00B264_SPI_SHADER_USER_DATA_GS_13},
	{40543, R_00B268_SPI_SHADER_USER_DATA_GS_14},
	{40570, R_00B26C_SPI_SHADER_USER_DATA_GS_15},
	{40597, R_00B300_SPI_SHADER_TBA_LO_ES},
	{40618, R_00B304_SPI_SHADER_TBA_HI_ES, 1, 770},
	{40639, R_00B308_SPI_SHADER_TMA_LO_ES},
	{40660, R_00B30C_SPI_SHADER_TMA_HI_ES, 1, 771},
	{40681, R_00B31C_SPI_SHADER_PGM_RSRC3_ES, 4, 772},
	{40705, R_00B320_SPI_SHADER_PGM_LO_ES},
	{40726, R_00B324_SPI_SHADER_PGM_HI_ES, 1, 776},
	{40747, R_00B328_SPI_SHADER_PGM_RSRC1_ES, 12, 777},
	{40771, R_00B32C_SPI_SHADER_PGM_RSRC2_ES, 6, 789},
	{40795, R_00B330_SPI_SHADER_USER_DATA_ES_0},
	{40821, R_00B334_SPI_SHADER_USER_DATA_ES_1},
	{40847, R_00B338_SPI_SHADER_USER_DATA_ES_2},
	{40873, R_00B33C_SPI_SHADER_USER_DATA_ES_3},
	{40899, R_00B340_SPI_SHADER_USER_DATA_ES_4},
	{40925, R_00B344_SPI_SHADER_USER_DATA_ES_5},
	{40951, R_00B348_SPI_SHADER_USER_DATA_ES_6},
	{40977, R_00B34C_SPI_SHADER_USER_DATA_ES_7},
	{41003, R_00B350_SPI_SHADER_USER_DATA_ES_8},
	{41029, R_00B354_SPI_SHADER_USER_DATA_ES_9},
	{41055, R_00B358_SPI_SHADER_USER_DATA_ES_10},
	{41082, R_00B35C_SPI_SHADER_USER_DATA_ES_11},
	{41109, R_00B360_SPI_SHADER_USER_DATA_ES_12},
	{41136, R_00B364_SPI_SHADER_USER_DATA_ES_13},
	{41163, R_00B368_SPI_SHADER_USER_DATA_ES_14},
	{41190, R_00B36C_SPI_SHADER_USER_DATA_ES_15},
	{41217, R_00B400_SPI_SHADER_TBA_LO_HS},
	{41238, R_00B404_SPI_SHADER_TBA_HI_HS, 1, 795},
	{41259, R_00B408_SPI_SHADER_TMA_LO_HS},
	{41280, R_00B40C_SPI_SHADER_TMA_HI_HS, 1, 796},
	{41301, R_00B41C_SPI_SHADER_PGM_RSRC3_HS, 3, 797},
	{41325, R_00B420_SPI_SHADER_PGM_LO_HS},
	{41346, R_00B424_SPI_SHADER_PGM_HI_HS, 1, 800},
	{41367, R_00B428_SPI_SHADER_PGM_RSRC1_HS, 10, 801},
	{41391, R_00B42C_SPI_SHADER_PGM_RSRC2_HS, 6, 811},
	{41415, R_00B430_SPI_SHADER_USER_DATA_HS_0},
	{41441, R_00B434_SPI_SHADER_USER_DATA_HS_1},
	{41467, R_00B438_SPI_SHADER_USER_DATA_HS_2},
	{41493, R_00B43C_SPI_SHADER_USER_DATA_HS_3},
	{41519, R_00B440_SPI_SHADER_USER_DATA_HS_4},
	{41545, R_00B444_SPI_SHADER_USER_DATA_HS_5},
	{41571, R_00B448_SPI_SHADER_USER_DATA_HS_6},
	{41597, R_00B44C_SPI_SHADER_USER_DATA_HS_7},
	{41623, R_00B450_SPI_SHADER_USER_DATA_HS_8},
	{41649, R_00B454_SPI_SHADER_USER_DATA_HS_9},
	{41675, R_00B458_SPI_SHADER_USER_DATA_HS_10},
	{41702, R_00B45C_SPI_SHADER_USER_DATA_HS_11},
	{41729, R_00B460_SPI_SHADER_USER_DATA_HS_12},
	{41756, R_00B464_SPI_SHADER_USER_DATA_HS_13},
	{41783, R_00B468_SPI_SHADER_USER_DATA_HS_14},
	{41810, R_00B46C_SPI_SHADER_USER_DATA_HS_15},
	{41837, R_00B500_SPI_SHADER_TBA_LO_LS},
	{41858, R_00B504_SPI_SHADER_TBA_HI_LS, 1, 817},
	{41879, R_00B508_SPI_SHADER_TMA_LO_LS},
	{41900, R_00B50C_SPI_SHADER_TMA_HI_LS, 1, 818},
	{41921, R_00B51C_SPI_SHADER_PGM_RSRC3_LS, 4, 819},
	{41945, R_00B520_SPI_SHADER_PGM_LO_LS},
	{41966, R_00B524_SPI_SHADER_PGM_HI_LS, 1, 823},
	{41987, R_00B528_SPI_SHADER_PGM_RSRC1_LS, 11, 824},
	{42011, R_00B52C_SPI_SHADER_PGM_RSRC2_LS, 5, 835},
	{42035, R_00B530_SPI_SHADER_USER_DATA_LS_0},
	{42061, R_00B534_SPI_SHADER_USER_DATA_LS_1},
	{42087, R_00B538_SPI_SHADER_USER_DATA_LS_2},
	{42113, R_00B53C_SPI_SHADER_USER_DATA_LS_3},
	{42139, R_00B540_SPI_SHADER_USER_DATA_LS_4},
	{42165, R_00B544_SPI_SHADER_USER_DATA_LS_5},
	{42191, R_00B548_SPI_SHADER_USER_DATA_LS_6},
	{42217, R_00B54C_SPI_SHADER_USER_DATA_LS_7},
	{42243, R_00B550_SPI_SHADER_USER_DATA_LS_8},
	{42269, R_00B554_SPI_SHADER_USER_DATA_LS_9},
	{42295, R_00B558_SPI_SHADER_USER_DATA_LS_10},
	{42322, R_00B55C_SPI_SHADER_USER_DATA_LS_11},
	{42349, R_00B560_SPI_SHADER_USER_DATA_LS_12},
	{42376, R_00B564_SPI_SHADER_USER_DATA_LS_13},
	{42403, R_00B568_SPI_SHADER_USER_DATA_LS_14},
	{42430, R_00B56C_SPI_SHADER_USER_DATA_LS_15},
	{42457, R_00B800_COMPUTE_DISPATCH_INITIATOR, 12, 840},
	{42484, R_00B804_COMPUTE_DIM_X},
	{42498, R_00B808_COMPUTE_DIM_Y},
	{42512, R_00B80C_COMPUTE_DIM_Z},
	{42526, R_00B810_COMPUTE_START_X},
	{42542, R_00B814_COMPUTE_START_Y},
	{42558, R_00B818_COMPUTE_START_Z},
	{42574, R_00B81C_COMPUTE_NUM_THREAD_X, 2, 852},
	{42595, R_00B820_COMPUTE_NUM_THREAD_Y, 2, 854},
	{42616, R_00B824_COMPUTE_NUM_THREAD_Z, 2, 856},
	{42637, R_00B82C_COMPUTE_MAX_WAVE_ID, 1, 858},
	{42657, R_00B828_COMPUTE_PIPELINESTAT_ENABLE, 1, 859},
	{42685, R_00B82C_COMPUTE_PERFCOUNT_ENABLE, 1, 860},
	{42710, R_00B830_COMPUTE_PGM_LO},
	{42725, R_00B834_COMPUTE_PGM_HI, 2, 861},
	{42740, R_00B838_COMPUTE_TBA_LO},
	{42755, R_00B83C_COMPUTE_TBA_HI, 1, 863},
	{42770, R_00B840_COMPUTE_TMA_LO},
	{42785, R_00B844_COMPUTE_TMA_HI, 1, 864},
	{42800, R_00B848_COMPUTE_PGM_RSRC1, 10, 865},
	{42818, R_00B84C_COMPUTE_PGM_RSRC2, 11, 875},
	{42836, R_00B850_COMPUTE_VMID, 1, 886},
	{42849, R_00B854_COMPUTE_RESOURCE_LIMITS, 7, 887},
	{42873, R_00B858_COMPUTE_STATIC_THREAD_MGMT_SE0, 2, 894},
	{42904, R_00B85C_COMPUTE_STATIC_THREAD_MGMT_SE1, 2, 896},
	{42935, R_00B860_COMPUTE_TMPRING_SIZE, 2, 898},
	{42956, R_00B864_COMPUTE_STATIC_THREAD_MGMT_SE2, 2, 900},
	{42987, R_00B868_COMPUTE_STATIC_THREAD_MGMT_SE3, 2, 902},
	{43018, R_00B86C_COMPUTE_RESTART_X},
	{43036, R_00B870_COMPUTE_RESTART_Y},
	{43054, R_00B874_COMPUTE_RESTART_Z},
	{43072, R_00B87C_COMPUTE_MISC_RESERVED, 5, 904},
	{43094, R_00B880_COMPUTE_DISPATCH_ID},
	{43114, R_00B884_COMPUTE_THREADGROUP_ID},
	{43137, R_00B888_COMPUTE_RELAUNCH, 3, 909},
	{43154, R_00B88C_COMPUTE_WAVE_RESTORE_ADDR_LO},
	{43183, R_00B890_COMPUTE_WAVE_RESTORE_ADDR_HI, 1, 912},
	{43212, R_00B894_COMPUTE_WAVE_RESTORE_CONTROL, 2, 913},
	{43241, R_00B900_COMPUTE_USER_DATA_0},
	{43261, R_00B904_COMPUTE_USER_DATA_1},
	{43281, R_00B908_COMPUTE_USER_DATA_2},
	{43301, R_00B90C_COMPUTE_USER_DATA_3},
	{43321, R_00B910_COMPUTE_USER_DATA_4},
	{43341, R_00B914_COMPUTE_USER_DATA_5},
	{43361, R_00B918_COMPUTE_USER_DATA_6},
	{43381, R_00B91C_COMPUTE_USER_DATA_7},
	{43401, R_00B920_COMPUTE_USER_DATA_8},
	{43421, R_00B924_COMPUTE_USER_DATA_9},
	{43441, R_00B928_COMPUTE_USER_DATA_10},
	{43462, R_00B92C_COMPUTE_USER_DATA_11},
	{43483, R_00B930_COMPUTE_USER_DATA_12},
	{43504, R_00B934_COMPUTE_USER_DATA_13},
	{43525, R_00B938_COMPUTE_USER_DATA_14},
	{43546, R_00B93C_COMPUTE_USER_DATA_15},
	{43567, R_00B9FC_COMPUTE_NOWHERE},
	{43583, R_034000_CPG_PERFCOUNTER1_LO},
	{43603, R_034004_CPG_PERFCOUNTER1_HI},
	{43623, R_034008_CPG_PERFCOUNTER0_LO},
	{43643, R_03400C_CPG_PERFCOUNTER0_HI},
	{43663, R_034010_CPC_PERFCOUNTER1_LO},
	{43683, R_034014_CPC_PERFCOUNTER1_HI},
	{43703, R_034018_CPC_PERFCOUNTER0_LO},
	{43723, R_03401C_CPC_PERFCOUNTER0_HI},
	{43743, R_034020_CPF_PERFCOUNTER1_LO},
	{43763, R_034024_CPF_PERFCOUNTER1_HI},
	{43783, R_034028_CPF_PERFCOUNTER0_LO},
	{43803, R_03402C_CPF_PERFCOUNTER0_HI},
	{43823, R_034100_GRBM_PERFCOUNTER0_LO},
	{43844, R_034104_GRBM_PERFCOUNTER0_HI},
	{43865, R_03410C_GRBM_PERFCOUNTER1_LO},
	{43886, R_034110_GRBM_PERFCOUNTER1_HI},
	{43907, R_034114_GRBM_SE0_PERFCOUNTER_LO},
	{43931, R_034118_GRBM_SE0_PERFCOUNTER_HI},
	{43955, R_03411C_GRBM_SE1_PERFCOUNTER_LO},
	{43979, R_034120_GRBM_SE1_PERFCOUNTER_HI},
	{44003, R_034124_GRBM_SE2_PERFCOUNTER_LO},
	{44027, R_034128_GRBM_SE2_PERFCOUNTER_HI},
	{44051, R_03412C_GRBM_SE3_PERFCOUNTER_LO},
	{44075, R_034130_GRBM_SE3_PERFCOUNTER_HI},
	{44099, R_034200_WD_PERFCOUNTER0_LO},
	{44118, R_034204_WD_PERFCOUNTER0_HI},
	{44137, R_034208_WD_PERFCOUNTER1_LO},
	{44156, R_03420C_WD_PERFCOUNTER1_HI},
	{44175, R_034210_WD_PERFCOUNTER2_LO},
	{44194, R_034214_WD_PERFCOUNTER2_HI},
	{44213, R_034218_WD_PERFCOUNTER3_LO},
	{44232, R_03421C_WD_PERFCOUNTER3_HI},
	{44251, R_034220_IA_PERFCOUNTER0_LO},
	{44270, R_034224_IA_PERFCOUNTER0_HI},
	{44289, R_034228_IA_PERFCOUNTER1_LO},
	{44308, R_03422C_IA_PERFCOUNTER1_HI},
	{44327, R_034230_IA_PERFCOUNTER2_LO},
	{44346, R_034234_IA_PERFCOUNTER2_HI},
	{44365, R_034238_IA_PERFCOUNTER3_LO},
	{44384, R_03423C_IA_PERFCOUNTER3_HI},
	{44403, R_034240_VGT_PERFCOUNTER0_LO},
	{44423, R_034244_VGT_PERFCOUNTER0_HI},
	{44443, R_034248_VGT_PERFCOUNTER1_LO},
	{44463, R_03424C_VGT_PERFCOUNTER1_HI},
	{44483, R_034250_VGT_PERFCOUNTER2_LO},
	{44503, R_034254_VGT_PERFCOUNTER2_HI},
	{44523, R_034258_VGT_PERFCOUNTER3_LO},
	{44543, R_03425C_VGT_PERFCOUNTER3_HI},
	{44563, R_034400_PA_SU_PERFCOUNTER0_LO},
	{44585, R_034404_PA_SU_PERFCOUNTER0_HI, 1, 915},
	{44607, R_034408_PA_SU_PERFCOUNTER1_LO},
	{44629, R_03440C_PA_SU_PERFCOUNTER1_HI, 1, 915},
	{44651, R_034410_PA_SU_PERFCOUNTER2_LO},
	{44673, R_034414_PA_SU_PERFCOUNTER2_HI, 1, 915},
	{44695, R_034418_PA_SU_PERFCOUNTER3_LO},
	{44717, R_03441C_PA_SU_PERFCOUNTER3_HI, 1, 915},
	{44739, R_034500_PA_SC_PERFCOUNTER0_LO},
	{44761, R_034504_PA_SC_PERFCOUNTER0_HI},
	{44783, R_034508_PA_SC_PERFCOUNTER1_LO},
	{44805, R_03450C_PA_SC_PERFCOUNTER1_HI},
	{44827, R_034510_PA_SC_PERFCOUNTER2_LO},
	{44849, R_034514_PA_SC_PERFCOUNTER2_HI},
	{44871, R_034518_PA_SC_PERFCOUNTER3_LO},
	{44893, R_03451C_PA_SC_PERFCOUNTER3_HI},
	{44915, R_034520_PA_SC_PERFCOUNTER4_LO},
	{44937, R_034524_PA_SC_PERFCOUNTER4_HI},
	{44959, R_034528_PA_SC_PERFCOUNTER5_LO},
	{44981, R_03452C_PA_SC_PERFCOUNTER5_HI},
	{45003, R_034530_PA_SC_PERFCOUNTER6_LO},
	{45025, R_034534_PA_SC_PERFCOUNTER6_HI},
	{45047, R_034538_PA_SC_PERFCOUNTER7_LO},
	{45069, R_03453C_PA_SC_PERFCOUNTER7_HI},
	{45091, R_034600_SPI_PERFCOUNTER0_HI},
	{45111, R_034604_SPI_PERFCOUNTER0_LO},
	{45131, R_034608_SPI_PERFCOUNTER1_HI},
	{45151, R_03460C_SPI_PERFCOUNTER1_LO},
	{45171, R_034610_SPI_PERFCOUNTER2_HI},
	{45191, R_034614_SPI_PERFCOUNTER2_LO},
	{45211, R_034618_SPI_PERFCOUNTER3_HI},
	{45231, R_03461C_SPI_PERFCOUNTER3_LO},
	{45251, R_034620_SPI_PERFCOUNTER4_HI},
	{45271, R_034624_SPI_PERFCOUNTER4_LO},
	{45291, R_034628_SPI_PERFCOUNTER5_HI},
	{45311, R_03462C_SPI_PERFCOUNTER5_LO},
	{45331, R_034700_SQ_PERFCOUNTER0_LO},
	{45350, R_034704_SQ_PERFCOUNTER0_HI},
	{45369, R_034708_SQ_PERFCOUNTER1_LO},
	{45388, R_03470C_SQ_PERFCOUNTER1_HI},
	{45407, R_034710_SQ_PERFCOUNTER2_LO},
	{45426, R_034714_SQ_PERFCOUNTER2_HI},
	{45445, R_034718_SQ_PERFCOUNTER3_LO},
	{45464, R_03471C_SQ_PERFCOUNTER3_HI},
	{45483, R_034720_SQ_PERFCOUNTER4_LO},
	{45502, R_034724_SQ_PERFCOUNTER4_HI},
	{45521, R_034728_SQ_PERFCOUNTER5_LO},
	{45540, R_03472C_SQ_PERFCOUNTER5_HI},
	{45559, R_034730_SQ_PERFCOUNTER6_LO},
	{45578, R_034734_SQ_PERFCOUNTER6_HI},
	{45597, R_034738_SQ_PERFCOUNTER7_LO},
	{45616, R_03473C_SQ_PERFCOUNTER7_HI},
	{45635, R_034740_SQ_PERFCOUNTER8_LO},
	{45654, R_034744_SQ_PERFCOUNTER8_HI},
	{45673, R_034748_SQ_PERFCOUNTER9_LO},
	{45692, R_03474C_SQ_PERFCOUNTER9_HI},
	{45711, R_034750_SQ_PERFCOUNTER10_LO},
	{45731, R_034754_SQ_PERFCOUNTER10_HI},
	{45751, R_034758_SQ_PERFCOUNTER11_LO},
	{45771, R_03475C_SQ_PERFCOUNTER11_HI},
	{45791, R_034760_SQ_PERFCOUNTER12_LO},
	{45811, R_034764_SQ_PERFCOUNTER12_HI},
	{45831, R_034768_SQ_PERFCOUNTER13_LO},
	{45851, R_03476C_SQ_PERFCOUNTER13_HI},
	{45871, R_034770_SQ_PERFCOUNTER14_LO},
	{45891, R_034774_SQ_PERFCOUNTER14_HI},
	{45911, R_034778_SQ_PERFCOUNTER15_LO},
	{45931, R_03477C_SQ_PERFCOUNTER15_HI},
	{45951, R_034900_SX_PERFCOUNTER0_LO},
	{45970, R_034904_SX_PERFCOUNTER0_HI},
	{45989, R_034908_SX_PERFCOUNTER1_LO},
	{46008, R_03490C_SX_PERFCOUNTER1_HI},
	{46027, R_034910_SX_PERFCOUNTER2_LO},
	{46046, R_034914_SX_PERFCOUNTER2_HI},
	{46065, R_034918_SX_PERFCOUNTER3_LO},
	{46084, R_03491C_SX_PERFCOUNTER3_HI},
	{46103, R_034A00_GDS_PERFCOUNTER0_LO},
	{46123, R_034A04_GDS_PERFCOUNTER0_HI},
	{46143, R_034A08_GDS_PERFCOUNTER1_LO},
	{46163, R_034A0C_GDS_PERFCOUNTER1_HI},
	{46183, R_034A10_GDS_PERFCOUNTER2_LO},
	{46203, R_034A14_GDS_PERFCOUNTER2_HI},
	{46223, R_034A18_GDS_PERFCOUNTER3_LO},
	{46243, R_034A1C_GDS_PERFCOUNTER3_HI},
	{46263, R_034B00_TA_PERFCOUNTER0_LO},
	{46282, R_034B04_TA_PERFCOUNTER0_HI},
	{46301, R_034B08_TA_PERFCOUNTER1_LO},
	{46320, R_034B0C_TA_PERFCOUNTER1_HI},
	{46339, R_034C00_TD_PERFCOUNTER0_LO},
	{46358, R_034C04_TD_PERFCOUNTER0_HI},
	{46377, R_034C08_TD_PERFCOUNTER1_LO},
	{46396, R_034C0C_TD_PERFCOUNTER1_HI},
	{46415, R_034D00_TCP_PERFCOUNTER0_LO},
	{46435, R_034D04_TCP_PERFCOUNTER0_HI},
	{46455, R_034D08_TCP_PERFCOUNTER1_LO},
	{46475, R_034D0C_TCP_PERFCOUNTER1_HI},
	{46495, R_034D10_TCP_PERFCOUNTER2_LO},
	{46515, R_034D14_TCP_PERFCOUNTER2_HI},
	{46535, R_034D18_TCP_PERFCOUNTER3_LO},
	{46555, R_034D1C_TCP_PERFCOUNTER3_HI},
	{46575, R_034E00_TCC_PERFCOUNTER0_LO},
	{46595, R_034E04_TCC_PERFCOUNTER0_HI},
	{46615, R_034E08_TCC_PERFCOUNTER1_LO},
	{46635, R_034E0C_TCC_PERFCOUNTER1_HI},
	{46655, R_034E10_TCC_PERFCOUNTER2_LO},
	{46675, R_034E14_TCC_PERFCOUNTER2_HI},
	{46695, R_034E18_TCC_PERFCOUNTER3_LO},
	{46715, R_034E1C_TCC_PERFCOUNTER3_HI},
	{46735, R_034E40_TCA_PERFCOUNTER0_LO},
	{46755, R_034E44_TCA_PERFCOUNTER0_HI},
	{46775, R_034E48_TCA_PERFCOUNTER1_LO},
	{46795, R_034E4C_TCA_PERFCOUNTER1_HI},
	{46815, R_034E50_TCA_PERFCOUNTER2_LO},
	{46835, R_034E54_TCA_PERFCOUNTER2_HI},
	{46855, R_034E58_TCA_PERFCOUNTER3_LO},
	{46875, R_034E5C_TCA_PERFCOUNTER3_HI},
	{46895, R_035018_CB_PERFCOUNTER0_LO},
	{46914, R_03501C_CB_PERFCOUNTER0_HI},
	{46933, R_035020_CB_PERFCOUNTER1_LO},
	{46952, R_035024_CB_PERFCOUNTER1_HI},
	{46971, R_035028_CB_PERFCOUNTER2_LO},
	{46990, R_03502C_CB_PERFCOUNTER2_HI},
	{47009, R_035030_CB_PERFCOUNTER3_LO},
	{47028, R_035034_CB_PERFCOUNTER3_HI},
	{47047, R_035100_DB_PERFCOUNTER0_LO},
	{47066, R_035104_DB_PERFCOUNTER0_HI},
	{47085, R_035108_DB_PERFCOUNTER1_LO},
	{47104, R_03510C_DB_PERFCOUNTER1_HI},
	{47123, R_035110_DB_PERFCOUNTER2_LO},
	{47142, R_035114_DB_PERFCOUNTER2_HI},
	{47161, R_035118_DB_PERFCOUNTER3_LO},
	{47180, R_03511C_DB_PERFCOUNTER3_HI},
	{47199, R_035200_RLC_PERFCOUNTER0_LO},
	{47219, R_035204_RLC_PERFCOUNTER0_HI},
	{47239, R_035208_RLC_PERFCOUNTER1_LO},
	{47259, R_03520C_RLC_PERFCOUNTER1_HI},
	{47279, R_036000_CPG_PERFCOUNTER1_SELECT, 3, 918},
	{47303, R_036004_CPG_PERFCOUNTER0_SELECT1, 2, 916},
	{47328, R_036008_CPG_PERFCOUNTER0_SELECT, 3, 918},
	{47352, R_03600C_CPC_PERFCOUNTER1_SELECT, 3, 932},
	{47376, R_036010_CPC_PERFCOUNTER0_SELECT1, 2, 921},
	{47401, R_036014_CPF_PERFCOUNTER1_SELECT, 3, 925},
	{47425, R_036018_CPF_PERFCOUNTER0_SELECT1, 2, 923},
	{47450, R_03601C_CPF_PERFCOUNTER0_SELECT, 3, 925},
	{47474, R_036020_CP_PERFMON_CNTL, 4, 928},
	{47490, R_036024_CPC_PERFCOUNTER0_SELECT, 3, 932},
	{47514, R_036100_GRBM_PERFCOUNTER0_SELECT, 19, 935},
	{47539, R_036104_GRBM_PERFCOUNTER1_SELECT, 19, 935},
	{47564, R_036108_GRBM_SE0_PERFCOUNTER_SELECT, 12, 954},
	{47592, R_03610C_GRBM_SE1_PERFCOUNTER_SELECT, 12, 966},
	{47620, R_036110_GRBM_SE2_PERFCOUNTER_SELECT, 12, 978},
	{47648, R_036114_GRBM_SE3_PERFCOUNTER_SELECT, 12, 990},
	{47676, R_036200_WD_PERFCOUNTER0_SELECT, 2, 1002},
	{47699, R_036204_WD_PERFCOUNTER1_SELECT, 2, 1002},
	{47722, R_036208_WD_PERFCOUNTER2_SELECT, 2, 1002},
	{47745, R_03620C_WD_PERFCOUNTER3_SELECT, 2, 1002},
	{47768, R_036210_IA_PERFCOUNTER0_SELECT, 5, 1004},
	{47791, R_036214_IA_PERFCOUNTER1_SELECT, 5, 1004},
	{47814, R_036218_IA_PERFCOUNTER2_SELECT, 5, 1004},
	{47837, R_03621C_IA_PERFCOUNTER3_SELECT, 5, 1004},
	{47860, R_036220_IA_PERFCOUNTER0_SELECT1, 4, 1009},
	{47884, R_036230_VGT_PERFCOUNTER0_SELECT, 5, 1013},
	{47908, R_036234_VGT_PERFCOUNTER1_SELECT, 5, 1013},
	{47932, R_036238_VGT_PERFCOUNTER2_SELECT, 5, 1013},
	{47956, R_03623C_VGT_PERFCOUNTER3_SELECT, 5, 1013},
	{47980, R_036240_VGT_PERFCOUNTER0_SELECT1, 4, 1018},
	{48005, R_036244_VGT_PERFCOUNTER1_SELECT1},
	{48030, R_036250_VGT_PERFCOUNTER_SEID_MASK, 1, 1022},
	{48056, R_036400_PA_SU_PERFCOUNTER0_SELECT, 3, 1023},
	{48082, R_036404_PA_SU_PERFCOUNTER0_SELECT1, 2, 1026},
	{48109, R_036408_PA_SU_PERFCOUNTER1_SELECT, 3, 1023},
	{48135, R_03640C_PA_SU_PERFCOUNTER1_SELECT1},
	{48162, R_036410_PA_SU_PERFCOUNTER2_SELECT, 3, 1023},
	{48188, R_036414_PA_SU_PERFCOUNTER3_SELECT, 3, 1023},
	{48214, R_036500_PA_SC_PERFCOUNTER0_SELECT, 3, 1028},
	{48240, R_036504_PA_SC_PERFCOUNTER0_SELECT1, 2, 1031},
	{48267, R_036508_PA_SC_PERFCOUNTER1_SELECT, 3, 1028},
	{48293, R_03650C_PA_SC_PERFCOUNTER2_SELECT, 3, 1028},
	{48319, R_036510_PA_SC_PERFCOUNTER3_SELECT, 3, 1028},
	{48345, R_036514_PA_SC_PERFCOUNTER4_SELECT, 3, 1028},
	{48371, R_036518_PA_SC_PERFCOUNTER5_SELECT, 3, 1028},
	{48397, R_03651C_PA_SC_PERFCOUNTER6_SELECT, 3, 1028},
	{48423, R_036520_PA_SC_PERFCOUNTER7_SELECT, 3, 1028},
	{48449, R_036600_SPI_PERFCOUNTER0_SELECT, 3, 1033},
	{48473, R_036604_SPI_PERFCOUNTER1_SELECT, 3, 1033},
	{48497, R_036608_SPI_PERFCOUNTER2_SELECT, 3, 1033},
	{48521, R_03660C_SPI_PERFCOUNTER3_SELECT, 3, 1033},
	{48545, R_036610_SPI_PERFCOUNTER0_SELECT1, 2, 1036},
	{48570, R_036614_SPI_PERFCOUNTER1_SELECT1},
	{48595, R_036618_SPI_PERFCOUNTER2_SELECT1},
	{48620, R_03661C_SPI_PERFCOUNTER3_SELECT1},
	{48645, R_036620_SPI_PERFCOUNTER4_SELECT, 3, 1033},
	{48669, R_036624_SPI_PERFCOUNTER5_SELECT, 3, 1033},
	{48693, R_036628_SPI_PERFCOUNTER_BINS, 8, 1038},
	{48714, R_036700_SQ_PERFCOUNTER0_SELECT, 6, 1046},
	{48737, R_036704_SQ_PERFCOUNTER1_SELECT, 6, 1046},
	{48760, R_036708_SQ_PERFCOUNTER2_SELECT, 6, 1046},
	{48783, R_03670C_SQ_PERFCOUNTER3_SELECT, 6, 1046},
	{48806, R_036710_SQ_PERFCOUNTER4_SELECT, 6, 1046},
	{48829, R_036714_SQ_PERFCOUNTER5_SELECT, 6, 1046},
	{48852, R_036718_SQ_PERFCOUNTER6_SELECT, 6, 1046},
	{48875, R_03671C_SQ_PERFCOUNTER7_SELECT, 6, 1046},
	{48898, R_036720_SQ_PERFCOUNTER8_SELECT, 6, 1046},
	{48921, R_036724_SQ_PERFCOUNTER9_SELECT, 6, 1046},
	{48944, R_036728_SQ_PERFCOUNTER10_SELECT, 6, 1046},
	{48968, R_03672C_SQ_PERFCOUNTER11_SELECT, 6, 1046},
	{48992, R_036730_SQ_PERFCOUNTER12_SELECT, 6, 1046},
	{49016, R_036734_SQ_PERFCOUNTER13_SELECT, 6, 1046},
	{49040, R_036738_SQ_PERFCOUNTER14_SELECT, 6, 1046},
	{49064, R_03673C_SQ_PERFCOUNTER15_SELECT, 6, 1046},
	{49088, R_036780_SQ_PERFCOUNTER_CTRL, 9, 1052},
	{49108, R_036784_SQ_PERFCOUNTER_MASK, 2, 1061},
	{49128, R_036788_SQ_PERFCOUNTER_CTRL2, 1, 1063},
	{49149, R_036900_SX_PERFCOUNTER0_SELECT, 3, 1064},
	{49172, R_036904_SX_PERFCOUNTER1_SELECT, 3, 1064},
	{49195, R_036908_SX_PERFCOUNTER2_SELECT, 3, 1064},
	{49218, R_03690C_SX_PERFCOUNTER3_SELECT, 3, 1064},
	{49241, R_036910_SX_PERFCOUNTER0_SELECT1, 2, 1067},
	{49265, R_036914_SX_PERFCOUNTER1_SELECT1},
	{49289, R_036A00_GDS_PERFCOUNTER0_SELECT, 3, 1069},
	{49313, R_036A04_GDS_PERFCOUNTER1_SELECT, 3, 1069},
	{49337, R_036A08_GDS_PERFCOUNTER2_SELECT, 3, 1069},
	{49361, R_036A0C_GDS_PERFCOUNTER3_SELECT, 3, 1069},
	{49385, R_036A10_GDS_PERFCOUNTER0_SELECT1, 2, 1072},
	{49410, R_036B00_TA_PERFCOUNTER0_SELECT, 5, 1074},
	{49433, R_036B04_TA_PERFCOUNTER0_SELECT1, 4, 1079},
	{49457, R_036B08_TA_PERFCOUNTER1_SELECT, 5, 1074},
	{49480, R_036C00_TD_PERFCOUNTER0_SELECT, 5, 1083},
	{49503, R_036C04_TD_PERFCOUNTER0_SELECT1, 4, 1088},
	{49527, R_036C08_TD_PERFCOUNTER1_SELECT, 5, 1083},
	{49550, R_036D00_TCP_PERFCOUNTER0_SELECT, 5, 1092},
	{49574, R_036D04_TCP_PERFCOUNTER0_SELECT1, 4, 1097},
	{49599, R_036D08_TCP_PERFCOUNTER1_SELECT, 5, 1092},
	{49623, R_036D0C_TCP_PERFCOUNTER1_SELECT1},
	{49648, R_036D10_TCP_PERFCOUNTER2_SELECT, 5, 1092},
	{49672, R_036D14_TCP_PERFCOUNTER3_SELECT, 5, 1092},
	{49696, R_036E00_TCC_PERFCOUNTER0_SELECT, 5, 1101},
	{49720, R_036E04_TCC_PERFCOUNTER0_SELECT1, 4, 1106},
	{49745, R_036E08_TCC_PERFCOUNTER1_SELECT, 5, 1101},
	{49769, R_036E0C_TCC_PERFCOUNTER1_SELECT1},
	{49794, R_036E10_TCC_PERFCOUNTER2_SELECT, 5, 1101},
	{49818, R_036E14_TCC_PERFCOUNTER3_SELECT, 5, 1101},
	{49842, R_036E40_TCA_PERFCOUNTER0_SELECT, 5, 1110},
	{49866, R_036E44_TCA_PERFCOUNTER0_SELECT1, 4, 1115},
	{49891, R_036E48_TCA_PERFCOUNTER1_SELECT, 5, 1110},
	{49915, R_036E4C_TCA_PERFCOUNTER1_SELECT1},
	{49940, R_036E50_TCA_PERFCOUNTER2_SELECT, 5, 1110},
	{49964, R_036E54_TCA_PERFCOUNTER3_SELECT, 5, 1110},
	{49988, R_037000_CB_PERFCOUNTER_FILTER, 12, 1119},
	{50010, R_037004_CB_PERFCOUNTER0_SELECT, 5, 1131},
	{50033, R_037008_CB_PERFCOUNTER0_SELECT1, 4, 1136},
	{50057, R_03700C_CB_PERFCOUNTER1_SELECT, 5, 1131},
	{50080, R_037010_CB_PERFCOUNTER2_SELECT, 5, 1131},
	{50103, R_037014_CB_PERFCOUNTER3_SELECT, 5, 1131},
	{50126, R_037100_DB_PERFCOUNTER0_SELECT, 5, 1140},
	{50149, R_037104_DB_PERFCOUNTER0_SELECT1, 4, 1145},
	{50173, R_037108_DB_PERFCOUNTER1_SELECT, 5, 1140},
	{50196, R_03710C_DB_PERFCOUNTER1_SELECT1},
	{50220, R_037110_DB_PERFCOUNTER2_SELECT, 5, 1140},
	{50243, R_037118_DB_PERFCOUNTER3_SELECT, 5, 1140},
	{50266, R_028000_DB_RENDER_CONTROL, 10, 1149},
	{50284, R_028004_DB_COUNT_CONTROL, 9, 1159},
	{50301, R_028008_DB_DEPTH_VIEW, 4, 1168},
	{50315, R_02800C_DB_RENDER_OVERRIDE, 23, 1172},
	{50334, R_028010_DB_RENDER_OVERRIDE2, 15, 1195},
	{50354, R_028014_DB_HTILE_DATA_BASE},
	{50373, R_028020_DB_DEPTH_BOUNDS_MIN},
	{50393, R_028024_DB_DEPTH_BOUNDS_MAX},
	{50413, R_028028_DB_STENCIL_CLEAR, 1, 1210},
	{50430, R_02802C_DB_DEPTH_CLEAR},
	{50445, R_028030_PA_SC_SCREEN_SCISSOR_TL, 2, 1211},
	{50469, R_028034_PA_SC_SCREEN_SCISSOR_BR, 2, 1213},
	{50493, R_02803C_DB_DEPTH_INFO, 7, 1215},
	{50507, R_028040_DB_Z_INFO, 10, 1222},
	{50517, R_028044_DB_STENCIL_INFO, 6, 1232},
	{50533, R_028048_DB_Z_READ_BASE},
	{50548, R_02804C_DB_STENCIL_READ_BASE},
	{50569, R_028050_DB_Z_WRITE_BASE},
	{50585, R_028054_DB_STENCIL_WRITE_BASE},
	{50607, R_028058_DB_DEPTH_SIZE, 2, 1238},
	{50621, R_02805C_DB_DEPTH_SLICE, 1, 1240},
	{50636, R_028080_TA_BC_BASE_ADDR},
	{50652, R_028084_TA_BC_BASE_ADDR_HI, 1, 1241},
	{50671, R_0281E8_COHER_DEST_BASE_HI_0},
	{50692, R_0281EC_COHER_DEST_BASE_HI_1},
	{50713, R_0281F0_COHER_DEST_BASE_HI_2},
	{50734, R_0281F4_COHER_DEST_BASE_HI_3},
	{50755, R_0281F8_COHER_DEST_BASE_2},
	{50773, R_0281FC_COHER_DEST_BASE_3},
	{50791, R_028200_PA_SC_WINDOW_OFFSET, 2, 1242},
	{50811, R_028204_PA_SC_WINDOW_SCISSOR_TL, 3, 1244},
	{50835, R_028208_PA_SC_WINDOW_SCISSOR_BR, 2, 1247},
	{50859, R_02820C_PA_SC_CLIPRECT_RULE, 1, 1249},
	{50879, R_028210_PA_SC_CLIPRECT_0_TL, 2, 1250},
	{50899, R_028214_PA_SC_CLIPRECT_0_BR, 2, 1252},
	{50919, R_028218_PA_SC_CLIPRECT_1_TL, 2, 1250},
	{50939, R_02821C_PA_SC_CLIPRECT_1_BR, 2, 1252},
	{50959, R_028220_PA_SC_CLIPRECT_2_TL, 2, 1250},
	{50979, R_028224_PA_SC_CLIPRECT_2_BR, 2, 1252},
	{50999, R_028228_PA_SC_CLIPRECT_3_TL, 2, 1250},
	{51019, R_02822C_PA_SC_CLIPRECT_3_BR, 2, 1252},
	{51039, R_028230_PA_SC_EDGERULE, 7, 1254},
	{51054, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 2, 1261},
	{51083, R_028238_CB_TARGET_MASK, 8, 1263},
	{51098, R_02823C_CB_SHADER_MASK, 8, 1271},
	{51113, R_028240_PA_SC_GENERIC_SCISSOR_TL, 3, 1279},
	{51138, R_028244_PA_SC_GENERIC_SCISSOR_BR, 2, 1282},
	{51163, R_028248_COHER_DEST_BASE_0},
	{51181, R_02824C_COHER_DEST_BASE_1},
	{51199, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 3, 1284},
	{51224, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 2, 1287},
	{51249, R_028258_PA_SC_VPORT_SCISSOR_1_TL, 3, 1284},
	{51274, R_02825C_PA_SC_VPORT_SCISSOR_1_BR, 2, 1287},
	{51299, R_028260_PA_SC_VPORT_SCISSOR_2_TL, 3, 1284},
	{51324, R_028264_PA_SC_VPORT_SCISSOR_2_BR, 2, 1287},
	{51349, R_028268_PA_SC_VPORT_SCISSOR_3_TL, 3, 1284},
	{51374, R_02826C_PA_SC_VPORT_SCISSOR_3_BR, 2, 1287},
	{51399, R_028270_PA_SC_VPORT_SCISSOR_4_TL, 3, 1284},
	{51424, R_028274_PA_SC_VPORT_SCISSOR_4_BR, 2, 1287},
	{51449, R_028278_PA_SC_VPORT_SCISSOR_5_TL, 3, 1284},
	{51474, R_02827C_PA_SC_VPORT_SCISSOR_5_BR, 2, 1287},
	{51499, R_028280_PA_SC_VPORT_SCISSOR_6_TL, 3, 1284},
	{51524, R_028284_PA_SC_VPORT_SCISSOR_6_BR, 2, 1287},
	{51549, R_028288_PA_SC_VPORT_SCISSOR_7_TL, 3, 1284},
	{51574, R_02828C_PA_SC_VPORT_SCISSOR_7_BR, 2, 1287},
	{51599, R_028290_PA_SC_VPORT_SCISSOR_8_TL, 3, 1284},
	{51624, R_028294_PA_SC_VPORT_SCISSOR_8_BR, 2, 1287},
	{51649, R_028298_PA_SC_VPORT_SCISSOR_9_TL, 3, 1284},
	{51674, R_02829C_PA_SC_VPORT_SCISSOR_9_BR, 2, 1287},
	{51699, R_0282A0_PA_SC_VPORT_SCISSOR_10_TL, 3, 1284},
	{51725, R_0282A4_PA_SC_VPORT_SCISSOR_10_BR, 2, 1287},
	{51751, R_0282A8_PA_SC_VPORT_SCISSOR_11_TL, 3, 1284},
	{51777, R_0282AC_PA_SC_VPORT_SCISSOR_11_BR, 2, 1287},
	{51803, R_0282B0_PA_SC_VPORT_SCISSOR_12_TL, 3, 1284},
	{51829, R_0282B4_PA_SC_VPORT_SCISSOR_12_BR, 2, 1287},
	{51855, R_0282B8_PA_SC_VPORT_SCISSOR_13_TL, 3, 1284},
	{51881, R_0282BC_PA_SC_VPORT_SCISSOR_13_BR, 2, 1287},
	{51907, R_0282C0_PA_SC_VPORT_SCISSOR_14_TL, 3, 1284},
	{51933, R_0282C4_PA_SC_VPORT_SCISSOR_14_BR, 2, 1287},
	{51959, R_0282C8_PA_SC_VPORT_SCISSOR_15_TL, 3, 1284},
	{51985, R_0282CC_PA_SC_VPORT_SCISSOR_15_BR, 2, 1287},
	{52011, R_0282D0_PA_SC_VPORT_ZMIN_0},
	{52030, R_0282D4_PA_SC_VPORT_ZMAX_0},
	{52049, R_0282D8_PA_SC_VPORT_ZMIN_1},
	{52068, R_0282DC_PA_SC_VPORT_ZMAX_1},
	{52087, R_0282E0_PA_SC_VPORT_ZMIN_2},
	{52106, R_0282E4_PA_SC_VPORT_ZMAX_2},
	{52125, R_0282E8_PA_SC_VPORT_ZMIN_3},
	{52144, R_0282EC_PA_SC_VPORT_ZMAX_3},
	{52163, R_0282F0_PA_SC_VPORT_ZMIN_4},
	{52182, R_0282F4_PA_SC_VPORT_ZMAX_4},
	{52201, R_0282F8_PA_SC_VPORT_ZMIN_5},
	{52220, R_0282FC_PA_SC_VPORT_ZMAX_5},
	{52239, R_028300_PA_SC_VPORT_ZMIN_6},
	{52258, R_028304_PA_SC_VPORT_ZMAX_6},
	{52277, R_028308_PA_SC_VPORT_ZMIN_7},
	{52296, R_02830C_PA_SC_VPORT_ZMAX_7},
	{52315, R_028310_PA_SC_VPORT_ZMIN_8},
	{52334, R_028314_PA_SC_VPORT_ZMAX_8},
	{52353, R_028318_PA_SC_VPORT_ZMIN_9},
	{52372, R_02831C_PA_SC_VPORT_ZMAX_9},
	{52391, R_028320_PA_SC_VPORT_ZMIN_10},
	{52411, R_028324_PA_SC_VPORT_ZMAX_10},
	{52431, R_028328_PA_SC_VPORT_ZMIN_11},
	{52451, R_02832C_PA_SC_VPORT_ZMAX_11},
	{52471, R_028330_PA_SC_VPORT_ZMIN_12},
	{52491, R_028334_PA_SC_VPORT_ZMAX_12},
	{52511, R_028338_PA_SC_VPORT_ZMIN_13},
	{52531, R_02833C_PA_SC_VPORT_ZMAX_13},
	{52551, R_028340_PA_SC_VPORT_ZMIN_14},
	{52571, R_028344_PA_SC_VPORT_ZMAX_14},
	{52591, R_028348_PA_SC_VPORT_ZMIN_15},
	{52611, R_02834C_PA_SC_VPORT_ZMAX_15},
	{52631, R_028350_PA_SC_RASTER_CONFIG, 15, 1289},
	{52651, R_028354_PA_SC_RASTER_CONFIG_1, 3, 1304},
	{52673, R_028358_PA_SC_SCREEN_EXTENT_CONTROL, 2, 1307},
	{52701, R_028400_VGT_MAX_VTX_INDX},
	{52718, R_028404_VGT_MIN_VTX_INDX},
	{52735, R_028408_VGT_INDX_OFFSET},
	{52751, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX},
	{52780, R_028414_CB_BLEND_RED},
	{52793, R_028418_CB_BLEND_GREEN},
	{52808, R_02841C_CB_BLEND_BLUE},
	{52822, R_028420_CB_BLEND_ALPHA},
	{52837, R_028424_CB_DCC_CONTROL, 3, 1309},
	{52852, R_02842C_DB_STENCIL_CONTROL, 6, 1312},
	{52871, R_028430_DB_STENCILREFMASK, 4, 1318},
	{52889, R_028434_DB_STENCILREFMASK_BF, 4, 1322},
	{52910, R_02843C_PA_CL_VPORT_XSCALE},
	{52929, R_028440_PA_CL_VPORT_XOFFSET},
	{52949, R_028444_PA_CL_VPORT_YSCALE},
	{52968, R_028448_PA_CL_VPORT_YOFFSET},
	{52988, R_02844C_PA_CL_VPORT_ZSCALE},
	{53007, R_028450_PA_CL_VPORT_ZOFFSET},
	{53027, R_028454_PA_CL_VPORT_XSCALE_1},
	{53048, R_028458_PA_CL_VPORT_XOFFSET_1},
	{53070, R_02845C_PA_CL_VPORT_YSCALE_1},
	{53091, R_028460_PA_CL_VPORT_YOFFSET_1},
	{53113, R_028464_PA_CL_VPORT_ZSCALE_1},
	{53134, R_028468_PA_CL_VPORT_ZOFFSET_1},
	{53156, R_02846C_PA_CL_VPORT_XSCALE_2},
	{53177, R_028470_PA_CL_VPORT_XOFFSET_2},
	{53199, R_028474_PA_CL_VPORT_YSCALE_2},
	{53220, R_028478_PA_CL_VPORT_YOFFSET_2},
	{53242, R_02847C_PA_CL_VPORT_ZSCALE_2},
	{53263, R_028480_PA_CL_VPORT_ZOFFSET_2},
	{53285, R_028484_PA_CL_VPORT_XSCALE_3},
	{53306, R_028488_PA_CL_VPORT_XOFFSET_3},
	{53328, R_02848C_PA_CL_VPORT_YSCALE_3},
	{53349, R_028490_PA_CL_VPORT_YOFFSET_3},
	{53371, R_028494_PA_CL_VPORT_ZSCALE_3},
	{53392, R_028498_PA_CL_VPORT_ZOFFSET_3},
	{53414, R_02849C_PA_CL_VPORT_XSCALE_4},
	{53435, R_0284A0_PA_CL_VPORT_XOFFSET_4},
	{53457, R_0284A4_PA_CL_VPORT_YSCALE_4},
	{53478, R_0284A8_PA_CL_VPORT_YOFFSET_4},
	{53500, R_0284AC_PA_CL_VPORT_ZSCALE_4},
	{53521, R_0284B0_PA_CL_VPORT_ZOFFSET_4},
	{53543, R_0284B4_PA_CL_VPORT_XSCALE_5},
	{53564, R_0284B8_PA_CL_VPORT_XOFFSET_5},
	{53586, R_0284BC_PA_CL_VPORT_YSCALE_5},
	{53607, R_0284C0_PA_CL_VPORT_YOFFSET_5},
	{53629, R_0284C4_PA_CL_VPORT_ZSCALE_5},
	{53650, R_0284C8_PA_CL_VPORT_ZOFFSET_5},
	{53672, R_0284CC_PA_CL_VPORT_XSCALE_6},
	{53693, R_0284D0_PA_CL_VPORT_XOFFSET_6},
	{53715, R_0284D4_PA_CL_VPORT_YSCALE_6},
	{53736, R_0284D8_PA_CL_VPORT_YOFFSET_6},
	{53758, R_0284DC_PA_CL_VPORT_ZSCALE_6},
	{53779, R_0284E0_PA_CL_VPORT_ZOFFSET_6},
	{53801, R_0284E4_PA_CL_VPORT_XSCALE_7},
	{53822, R_0284E8_PA_CL_VPORT_XOFFSET_7},
	{53844, R_0284EC_PA_CL_VPORT_YSCALE_7},
	{53865, R_0284F0_PA_CL_VPORT_YOFFSET_7},
	{53887, R_0284F4_PA_CL_VPORT_ZSCALE_7},
	{53908, R_0284F8_PA_CL_VPORT_ZOFFSET_7},
	{53930, R_0284FC_PA_CL_VPORT_XSCALE_8},
	{53951, R_028500_PA_CL_VPORT_XOFFSET_8},
	{53973, R_028504_PA_CL_VPORT_YSCALE_8},
	{53994, R_028508_PA_CL_VPORT_YOFFSET_8},
	{54016, R_02850C_PA_CL_VPORT_ZSCALE_8},
	{54037, R_028510_PA_CL_VPORT_ZOFFSET_8},
	{54059, R_028514_PA_CL_VPORT_XSCALE_9},
	{54080, R_028518_PA_CL_VPORT_XOFFSET_9},
	{54102, R_02851C_PA_CL_VPORT_YSCALE_9},
	{54123, R_028520_PA_CL_VPORT_YOFFSET_9},
	{54145, R_028524_PA_CL_VPORT_ZSCALE_9},
	{54166, R_028528_PA_CL_VPORT_ZOFFSET_9},
	{54188, R_02852C_PA_CL_VPORT_XSCALE_10},
	{54210, R_028530_PA_CL_VPORT_XOFFSET_10},
	{54233, R_028534_PA_CL_VPORT_YSCALE_10},
	{54255, R_028538_PA_CL_VPORT_YOFFSET_10},
	{54278, R_02853C_PA_CL_VPORT_ZSCALE_10},
	{54300, R_028540_PA_CL_VPORT_ZOFFSET_10},
	{54323, R_028544_PA_CL_VPORT_XSCALE_11},
	{54345, R_028548_PA_CL_VPORT_XOFFSET_11},
	{54368, R_02854C_PA_CL_VPORT_YSCALE_11},
	{54390, R_028550_PA_CL_VPORT_YOFFSET_11},
	{54413, R_028554_PA_CL_VPORT_ZSCALE_11},
	{54435, R_028558_PA_CL_VPORT_ZOFFSET_11},
	{54458, R_02855C_PA_CL_VPORT_XSCALE_12},
	{54480, R_028560_PA_CL_VPORT_XOFFSET_12},
	{54503, R_028564_PA_CL_VPORT_YSCALE_12},
	{54525, R_028568_PA_CL_VPORT_YOFFSET_12},
	{54548, R_02856C_PA_CL_VPORT_ZSCALE_12},
	{54570, R_028570_PA_CL_VPORT_ZOFFSET_12},
	{54593, R_028574_PA_CL_VPORT_XSCALE_13},
	{54615, R_028578_PA_CL_VPORT_XOFFSET_13},
	{54638, R_02857C_PA_CL_VPORT_YSCALE_13},
	{54660, R_028580_PA_CL_VPORT_YOFFSET_13},
	{54683, R_028584_PA_CL_VPORT_ZSCALE_13},
	{54705, R_028588_PA_CL_VPORT_ZOFFSET_13},
	{54728, R_02858C_PA_CL_VPORT_XSCALE_14},
	{54750, R_028590_PA_CL_VPORT_XOFFSET_14},
	{54773, R_028594_PA_CL_VPORT_YSCALE_14},
	{54795, R_028598_PA_CL_VPORT_YOFFSET_14},
	{54818, R_02859C_PA_CL_VPORT_ZSCALE_14},
	{54840, R_0285A0_PA_CL_VPORT_ZOFFSET_14},
	{54863, R_0285A4_PA_CL_VPORT_XSCALE_15},
	{54885, R_0285A8_PA_CL_VPORT_XOFFSET_15},
	{54908, R_0285AC_PA_CL_VPORT_YSCALE_15},
	{54930, R_0285B0_PA_CL_VPORT_YOFFSET_15},
	{54953, R_0285B4_PA_CL_VPORT_ZSCALE_15},
	{54975, R_0285B8_PA_CL_VPORT_ZOFFSET_15},
	{54998, R_0285BC_PA_CL_UCP_0_X},
	{55012, R_0285C0_PA_CL_UCP_0_Y},
	{55026, R_0285C4_PA_CL_UCP_0_Z},
	{55040, R_0285C8_PA_CL_UCP_0_W},
	{55054, R_0285CC_PA_CL_UCP_1_X},
	{55068, R_0285D0_PA_CL_UCP_1_Y},
	{55082, R_0285D4_PA_CL_UCP_1_Z},
	{55096, R_0285D8_PA_CL_UCP_1_W},
	{55110, R_0285DC_PA_CL_UCP_2_X},
	{55124, R_0285E0_PA_CL_UCP_2_Y},
	{55138, R_0285E4_PA_CL_UCP_2_Z},
	{55152, R_0285E8_PA_CL_UCP_2_W},
	{55166, R_0285EC_PA_CL_UCP_3_X},
	{55180, R_0285F0_PA_CL_UCP_3_Y},
	{55194, R_0285F4_PA_CL_UCP_3_Z},
	{55208, R_0285F8_PA_CL_UCP_3_W},
	{55222, R_0285FC_PA_CL_UCP_4_X},
	{55236, R_028600_PA_CL_UCP_4_Y},
	{55250, R_028604_PA_CL_UCP_4_Z},
	{55264, R_028608_PA_CL_UCP_4_W},
	{55278, R_02860C_PA_CL_UCP_5_X},
	{55292, R_028610_PA_CL_UCP_5_Y},
	{55306, R_028614_PA_CL_UCP_5_Z},
	{55320, R_028618_PA_CL_UCP_5_W},
	{55334, R_028644_SPI_PS_INPUT_CNTL_0, 12, 1326},
	{55354, R_028648_SPI_PS_INPUT_CNTL_1, 12, 1326},
	{55374, R_02864C_SPI_PS_INPUT_CNTL_2, 12, 1326},
	{55394, R_028650_SPI_PS_INPUT_CNTL_3, 12, 1326},
	{55414, R_028654_SPI_PS_INPUT_CNTL_4, 12, 1326},
	{55434, R_028658_SPI_PS_INPUT_CNTL_5, 12, 1326},
	{55454, R_02865C_SPI_PS_INPUT_CNTL_6, 12, 1326},
	{55474, R_028660_SPI_PS_INPUT_CNTL_7, 12, 1326},
	{55494, R_028664_SPI_PS_INPUT_CNTL_8, 12, 1326},
	{55514, R_028668_SPI_PS_INPUT_CNTL_9, 12, 1326},
	{55534, R_02866C_SPI_PS_INPUT_CNTL_10, 12, 1326},
	{55555, R_028670_SPI_PS_INPUT_CNTL_11, 12, 1326},
	{55576, R_028674_SPI_PS_INPUT_CNTL_12, 12, 1326},
	{55597, R_028678_SPI_PS_INPUT_CNTL_13, 12, 1326},
	{55618, R_02867C_SPI_PS_INPUT_CNTL_14, 12, 1326},
	{55639, R_028680_SPI_PS_INPUT_CNTL_15, 12, 1326},
	{55660, R_028684_SPI_PS_INPUT_CNTL_16, 12, 1326},
	{55681, R_028688_SPI_PS_INPUT_CNTL_17, 12, 1326},
	{55702, R_02868C_SPI_PS_INPUT_CNTL_18, 12, 1326},
	{55723, R_028690_SPI_PS_INPUT_CNTL_19, 12, 1326},
	{55744, R_028694_SPI_PS_INPUT_CNTL_20, 12, 1326},
	{55765, R_028698_SPI_PS_INPUT_CNTL_21, 12, 1326},
	{55786, R_02869C_SPI_PS_INPUT_CNTL_22, 12, 1326},
	{55807, R_0286A0_SPI_PS_INPUT_CNTL_23, 12, 1326},
	{55828, R_0286A4_SPI_PS_INPUT_CNTL_24, 12, 1326},
	{55849, R_0286A8_SPI_PS_INPUT_CNTL_25, 12, 1326},
	{55870, R_0286AC_SPI_PS_INPUT_CNTL_26, 12, 1326},
	{55891, R_0286B0_SPI_PS_INPUT_CNTL_27, 12, 1326},
	{55912, R_0286B4_SPI_PS_INPUT_CNTL_28, 12, 1326},
	{55933, R_0286B8_SPI_PS_INPUT_CNTL_29, 12, 1326},
	{55954, R_0286BC_SPI_PS_INPUT_CNTL_30, 12, 1326},
	{55975, R_0286C0_SPI_PS_INPUT_CNTL_31, 12, 1326},
	{55996, R_0286C4_SPI_VS_OUT_CONFIG, 4, 1338},
	{56014, R_0286CC_SPI_PS_INPUT_ENA, 16, 1342},
	{56031, R_0286D0_SPI_PS_INPUT_ADDR, 16, 1358},
	{56049, R_0286D4_SPI_INTERP_CONTROL_0, 7, 1374},
	{56070, R_0286D8_SPI_PS_IN_CONTROL, 5, 1381},
	{56088, R_0286E0_SPI_BARYC_CNTL, 7, 1386},
	{56103, R_0286E8_SPI_TMPRING_SIZE, 2, 1393},
	{56120, R_028704_SPI_WAVE_MGMT_1, 5, 1395},
	{56136, R_028708_SPI_WAVE_MGMT_2, 1, 1400},
	{56152, R_02870C_SPI_SHADER_POS_FORMAT, 4, 1401},
	{56174, R_028710_SPI_SHADER_Z_FORMAT, 1, 1405},
	{56194, R_028714_SPI_SHADER_COL_FORMAT, 8, 1406},
	{56216, R_028754_SX_PS_DOWNCONVERT, 8, 1414},
	{56234, R_028758_SX_BLEND_OPT_EPSILON, 8, 1422},
	{56255, R_02875C_SX_BLEND_OPT_CONTROL, 17, 1430},
	{56276, R_028760_SX_MRT0_BLEND_OPT, 6, 1447},
	{56294, R_028764_SX_MRT1_BLEND_OPT, 6, 1453},
	{56312, R_028768_SX_MRT2_BLEND_OPT, 6, 1459},
	{56330, R_02876C_SX_MRT3_BLEND_OPT, 6, 1465},
	{56348, R_028770_SX_MRT4_BLEND_OPT, 6, 1471},
	{56366, R_028774_SX_MRT5_BLEND_OPT, 6, 1477},
	{56384, R_028778_SX_MRT6_BLEND_OPT, 6, 1483},
	{56402, R_02877C_SX_MRT7_BLEND_OPT, 6, 1489},
	{56420, R_028780_CB_BLEND0_CONTROL, 9, 1495},
	{56438, R_028784_CB_BLEND1_CONTROL, 9, 1495},
	{56456, R_028788_CB_BLEND2_CONTROL, 9, 1495},
	{56474, R_02878C_CB_BLEND3_CONTROL, 9, 1495},
	{56492, R_028790_CB_BLEND4_CONTROL, 9, 1495},
	{56510, R_028794_CB_BLEND5_CONTROL, 9, 1495},
	{56528, R_028798_CB_BLEND6_CONTROL, 9, 1495},
	{56546, R_02879C_CB_BLEND7_CONTROL, 9, 1495},
	{56564, R_0287CC_CS_COPY_STATE, 1, 1504},
	{56578, R_0287D4_PA_CL_POINT_X_RAD},
	{56596, R_0287D8_PA_CL_POINT_Y_RAD},
	{56614, R_0287DC_PA_CL_POINT_SIZE},
	{56631, R_0287E0_PA_CL_POINT_CULL_RAD},
	{56652, R_0287E4_VGT_DMA_BASE_HI, 1, 1505},
	{56668, R_0287E8_VGT_DMA_BASE},
	{56681, R_0287F0_VGT_DRAW_INITIATOR, 4, 1506},
	{56700, R_0287F4_VGT_IMMED_DATA},
	{56715, R_0287F8_VGT_EVENT_ADDRESS_REG, 1, 1510},
	{56737, R_028800_DB_DEPTH_CONTROL, 10, 1511},
	{56754, R_028804_DB_EQAA, 12, 1521},
	{56762, R_028808_CB_COLOR_CONTROL, 4, 1533},
	{56779, R_02880C_DB_SHADER_CONTROL, 13, 1537},
	{56797, R_028810_PA_CL_CLIP_CNTL, 19, 1550},
	{56813, R_028814_PA_SU_SC_MODE_CNTL, 13, 1569},
	{56832, R_028818_PA_CL_VTE_CNTL, 9, 1582},
	{56847, R_02881C_PA_CL_VS_OUT_CNTL, 27, 1591},
	{56865, R_028820_PA_CL_NANINF_CNTL, 16, 1618},
	{56883, R_028824_PA_SU_LINE_STIPPLE_CNTL, 4, 1634},
	{56907, R_028828_PA_SU_LINE_STIPPLE_SCALE},
	{56932, R_02882C_PA_SU_PRIM_FILTER_CNTL, 11, 1638},
	{56955, R_028830_PA_SU_SMALL_PRIM_FILTER_CNTL, 5, 1649},
	{56984, R_028A00_PA_SU_POINT_SIZE, 2, 1654},
	{57001, R_028A04_PA_SU_POINT_MINMAX, 2, 1656},
	{57020, R_028A08_PA_SU_LINE_CNTL, 1, 1658},
	{57036, R_028A0C_PA_SC_LINE_STIPPLE, 4, 1659},
	{57055, R_028A10_VGT_OUTPUT_PATH_CNTL, 1, 1663},
	{57076, R_028A14_VGT_HOS_CNTL, 1, 1664},
	{57089, R_028A18_VGT_HOS_MAX_TESS_LEVEL},
	{57112, R_028A1C_VGT_HOS_MIN_TESS_LEVEL},
	{57135, R_028A20_VGT_HOS_REUSE_DEPTH, 1, 1665},
	{57155, R_028A24_VGT_GROUP_PRIM_TYPE, 4, 1666},
	{57175, R_028A28_VGT_GROUP_FIRST_DECR, 1, 1670},
	{57196, R_028A2C_VGT_GROUP_DECR, 1, 1671},
	{57211, R_028A30_VGT_GROUP_VECT_0_CNTL, 6, 1672},
	{57233, R_028A34_VGT_GROUP_VECT_1_CNTL, 6, 1678},
	{57255, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 8, 1684},
	{57281, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 8, 1692},
	{57307, R_028A40_VGT_GS_MODE, 15, 1700},
	{57319, R_028A44_VGT_GS_ONCHIP_CNTL, 2, 1715},
	{57338, R_028A48_PA_SC_MODE_CNTL_0, 4, 1717},
	{57356, R_028A4C_PA_SC_MODE_CNTL_1, 24, 1721},
	{57374, R_028A50_VGT_ENHANCE},
	{57386, R_028A54_VGT_GS_PER_ES, 1, 1745},
	{57400, R_028A58_VGT_ES_PER_GS, 1, 1746},
	{57414, R_028A5C_VGT_GS_PER_VS, 1, 1747},
	{57428, R_028A60_VGT_GSVS_RING_OFFSET_1, 1, 1748},
	{57451, R_028A64_VGT_GSVS_RING_OFFSET_2, 1, 1749},
	{57474, R_028A68_VGT_GSVS_RING_OFFSET_3, 1, 1750},
	{57497, R_028A6C_VGT_GS_OUT_PRIM_TYPE, 5, 1751},
	{57518, R_028A70_IA_ENHANCE},
	{57529, R_028A74_VGT_DMA_SIZE},
	{57542, R_028A78_VGT_DMA_MAX_SIZE},
	{57559, R_028A7C_VGT_DMA_INDEX_TYPE, 9, 1756},
	{57578, R_028A80_WD_ENHANCE},
	{57589, R_028A84_VGT_PRIMITIVEID_EN, 2, 1765},
	{57608, R_028A88_VGT_DMA_NUM_INSTANCES},
	{57630, R_028A8C_VGT_PRIMITIVEID_RESET},
	{57652, R_028A90_VGT_EVENT_INITIATOR, 3, 1767},
	{57672, R_028A94_VGT_MULTI_PRIM_IB_RESET_EN, 1, 1770},
	{57699, R_028AA0_VGT_INSTANCE_STEP_RATE_0},
	{57724, R_028AA4_VGT_INSTANCE_STEP_RATE_1},
	{57749, R_028AA8_IA_MULTI_VGT_PARAM, 7, 1771},
	{57768, R_028AAC_VGT_ESGS_RING_ITEMSIZE, 1, 1778},
	{57791, R_028AB0_VGT_GSVS_RING_ITEMSIZE, 1, 1779},
	{57814, R_028AB4_VGT_REUSE_OFF, 1, 1780},
	{57828, R_028AB8_VGT_VTX_CNT_EN, 1, 1781},
	{57843, R_028ABC_DB_HTILE_SURFACE, 8, 1782},
	{57860, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 4, 1790},
	{57887, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 4, 1794},
	{57914, R_028AC8_DB_PRELOAD_CONTROL, 4, 1798},
	{57933, R_028AD0_VGT_STRMOUT_BUFFER_SIZE_0},
	{57959, R_028AD4_VGT_STRMOUT_VTX_STRIDE_0, 1, 1802},
	{57984, R_028ADC_VGT_STRMOUT_BUFFER_OFFSET_0},
	{58012, R_028AE0_VGT_STRMOUT_BUFFER_SIZE_1},
	{58038, R_028AE4_VGT_STRMOUT_VTX_STRIDE_1, 1, 1803},
	{58063, R_028AEC_VGT_STRMOUT_BUFFER_OFFSET_1},
	{58091, R_028AF0_VGT_STRMOUT_BUFFER_SIZE_2},
	{58117, R_028AF4_VGT_STRMOUT_VTX_STRIDE_2, 1, 1804},
	{58142, R_028AFC_VGT_STRMOUT_BUFFER_OFFSET_2},
	{58170, R_028B00_VGT_STRMOUT_BUFFER_SIZE_3},
	{58196, R_028B04_VGT_STRMOUT_VTX_STRIDE_3, 1, 1805},
	{58221, R_028B0C_VGT_STRMOUT_BUFFER_OFFSET_3},
	{58249, R_028B28_VGT_STRMOUT_DRAW_OPAQUE_OFFSET},
	{58280, R_028B2C_VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE},
	{58323, R_028B30_VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE, 1, 1806},
	{58361, R_028B38_VGT_GS_MAX_VERT_OUT, 1, 1807},
	{58381, R_028B50_VGT_TESS_DISTRIBUTION, 5, 1808},
	{58403, R_028B54_VGT_SHADER_STAGES_EN, 10, 1813},
	{58424, R_028B58_VGT_LS_HS_CONFIG, 3, 1823},
	{58441, R_028B5C_VGT_GS_VERT_ITEMSIZE, 1, 1826},
	{58462, R_028B60_VGT_GS_VERT_ITEMSIZE_1, 1, 1827},
	{58485, R_028B64_VGT_GS_VERT_ITEMSIZE_2, 1, 1828},
	{58508, R_028B68_VGT_GS_VERT_ITEMSIZE_3, 1, 1829},
	{58531, R_028B6C_VGT_TF_PARAM, 11, 1830},
	{58544, R_028B70_DB_ALPHA_TO_MASK, 6, 1841},
	{58561, R_028B74_VGT_DISPATCH_DRAW_INDEX},
	{58585, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 2, 1847},
	{58615, R_028B7C_PA_SU_POLY_OFFSET_CLAMP},
	{58639, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE},
	{58669, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET},
	{58700, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE},
	{58729, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET},
	{58759, R_028B90_VGT_GS_INSTANCE_CNT, 2, 1849},
	{58779, R_028B94_VGT_STRMOUT_CONFIG, 7, 1851},
	{58798, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 4, 1858},
	{58824, R_028BD4_PA_SC_CENTROID_PRIORITY_0, 8, 1862},
	{58850, R_028BD8_PA_SC_CENTROID_PRIORITY_1, 8, 1870},
	{58876, R_028BDC_PA_SC_LINE_CNTL, 4, 1878},
	{58892, R_028BE0_PA_SC_AA_CONFIG, 5, 1882},
	{58908, R_028BE4_PA_SU_VTX_CNTL, 3, 1887},
	{58923, R_028BE8_PA_CL_GB_VERT_CLIP_ADJ},
	{58946, R_028BEC_PA_CL_GB_VERT_DISC_ADJ},
	{58969, R_028BF0_PA_CL_GB_HORZ_CLIP_ADJ},
	{58992, R_028BF4_PA_CL_GB_HORZ_DISC_ADJ},
	{59015, R_028BF8_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0, 8, 1890},
	{59049, R_028BFC_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1, 8, 1898},
	{59083, R_028C00_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2, 8, 1906},
	{59117, R_028C04_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3, 8, 1914},
	{59151, R_028C08_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0, 8, 1922},
	{59185, R_028C0C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1, 8, 1930},
	{59219, R_028C10_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2, 8, 1938},
	{59253, R_028C14_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3, 8, 1946},
	{59287, R_028C18_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0, 8, 1954},
	{59321, R_028C1C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1, 8, 1962},
	{59355, R_028C20_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2, 8, 1970},
	{59389, R_028C24_PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3, 8, 1978},
	{59423, R_028C28_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0, 8, 1986},
	{59457, R_028C2C_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1, 8, 1994},
	{59491, R_028C30_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2, 8, 2002},
	{59525, R_028C34_PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3, 8, 2010},
	{59559, R_028C38_PA_SC_AA_MASK_X0Y0_X1Y0, 2, 2018},
	{59583, R_028C3C_PA_SC_AA_MASK_X0Y1_X1Y1, 2, 2020},
	{59607, R_028C40_PA_SC_SHADER_CONTROL, 1, 2022},
	{59628, R_028C58_VGT_VERTEX_REUSE_BLOCK_CNTL, 1, 2023},
	{59656, R_028C5C_VGT_OUT_DEALLOC_CNTL, 1, 2024},
	{59677, R_028C60_CB_COLOR0_BASE},
	{59692, R_028C64_CB_COLOR0_PITCH, 2, 2025},
	{59708, R_028C68_CB_COLOR0_SLICE, 1, 2027},
	{59724, R_028C6C_CB_COLOR0_VIEW, 2, 2028},
	{59739, R_028C70_CB_COLOR0_INFO, 18, 2030},
	{59754, R_028C74_CB_COLOR0_ATTRIB, 6, 2048},
	{59771, R_028C78_CB_COLOR0_DCC_CONTROL, 9, 2054},
	{59793, R_028C7C_CB_COLOR0_CMASK},
	{59809, R_028C80_CB_COLOR0_CMASK_SLICE, 1, 2063},
	{59831, R_028C84_CB_COLOR0_FMASK},
	{59847, R_028C88_CB_COLOR0_FMASK_SLICE, 1, 2064},
	{59869, R_028C8C_CB_COLOR0_CLEAR_WORD0},
	{59891, R_028C90_CB_COLOR0_CLEAR_WORD1},
	{59913, R_028C94_CB_COLOR0_DCC_BASE},
	{59932, R_028C9C_CB_COLOR1_BASE},
	{59947, R_028CA0_CB_COLOR1_PITCH, 2, 2025},
	{59963, R_028CA4_CB_COLOR1_SLICE, 1, 2027},
	{59979, R_028CA8_CB_COLOR1_VIEW, 2, 2028},
	{59994, R_028CAC_CB_COLOR1_INFO, 18, 2030},
	{60009, R_028CB0_CB_COLOR1_ATTRIB, 6, 2048},
	{60026, R_028CB4_CB_COLOR1_DCC_CONTROL, 9, 2054},
	{60048, R_028CB8_CB_COLOR1_CMASK},
	{60064, R_028CBC_CB_COLOR1_CMASK_SLICE, 1, 2063},
	{60086, R_028CC0_CB_COLOR1_FMASK},
	{60102, R_028CC4_CB_COLOR1_FMASK_SLICE, 1, 2064},
	{60124, R_028CC8_CB_COLOR1_CLEAR_WORD0},
	{60146, R_028CCC_CB_COLOR1_CLEAR_WORD1},
	{60168, R_028CD0_CB_COLOR1_DCC_BASE},
	{60187, R_028CD8_CB_COLOR2_BASE},
	{60202, R_028CDC_CB_COLOR2_PITCH, 2, 2025},
	{60218, R_028CE0_CB_COLOR2_SLICE, 1, 2027},
	{60234, R_028CE4_CB_COLOR2_VIEW, 2, 2028},
	{60249, R_028CE8_CB_COLOR2_INFO, 18, 2030},
	{60264, R_028CEC_CB_COLOR2_ATTRIB, 6, 2048},
	{60281, R_028CF0_CB_COLOR2_DCC_CONTROL, 9, 2054},
	{60303, R_028CF4_CB_COLOR2_CMASK},
	{60319, R_028CF8_CB_COLOR2_CMASK_SLICE, 1, 2063},
	{60341, R_028CFC_CB_COLOR2_FMASK},
	{60357, R_028D00_CB_COLOR2_FMASK_SLICE, 1, 2064},
	{60379, R_028D04_CB_COLOR2_CLEAR_WORD0},
	{60401, R_028D08_CB_COLOR2_CLEAR_WORD1},
	{60423, R_028D0C_CB_COLOR2_DCC_BASE},
	{60442, R_028D14_CB_COLOR3_BASE},
	{60457, R_028D18_CB_COLOR3_PITCH, 2, 2025},
	{60473, R_028D1C_CB_COLOR3_SLICE, 1, 2027},
	{60489, R_028D20_CB_COLOR3_VIEW, 2, 2028},
	{60504, R_028D24_CB_COLOR3_INFO, 18, 2030},
	{60519, R_028D28_CB_COLOR3_ATTRIB, 6, 2048},
	{60536, R_028D2C_CB_COLOR3_DCC_CONTROL, 9, 2054},
	{60558, R_028D30_CB_COLOR3_CMASK},
	{60574, R_028D34_CB_COLOR3_CMASK_SLICE, 1, 2063},
	{60596, R_028D38_CB_COLOR3_FMASK},
	{60612, R_028D3C_CB_COLOR3_FMASK_SLICE, 1, 2064},
	{60634, R_028D40_CB_COLOR3_CLEAR_WORD0},
	{60656, R_028D44_CB_COLOR3_CLEAR_WORD1},
	{60678, R_028D48_CB_COLOR3_DCC_BASE},
	{60697, R_028D50_CB_COLOR4_BASE},
	{60712, R_028D54_CB_COLOR4_PITCH, 2, 2025},
	{60728, R_028D58_CB_COLOR4_SLICE, 1, 2027},
	{60744, R_028D5C_CB_COLOR4_VIEW, 2, 2028},
	{60759, R_028D60_CB_COLOR4_INFO, 18, 2030},
	{60774, R_028D64_CB_COLOR4_ATTRIB, 6, 2048},
	{60791, R_028D68_CB_COLOR4_DCC_CONTROL, 9, 2054},
	{60813, R_028D6C_CB_COLOR4_CMASK},
	{60829, R_028D70_CB_COLOR4_CMASK_SLICE, 1, 2063},
	{60851, R_028D74_CB_COLOR4_FMASK},
	{60867, R_028D78_CB_COLOR4_FMASK_SLICE, 1, 2064},
	{60889, R_028D7C_CB_COLOR4_CLEAR_WORD0},
	{60911, R_028D80_CB_COLOR4_CLEAR_WORD1},
	{60933, R_028D84_CB_COLOR4_DCC_BASE},
	{60952, R_028D8C_CB_COLOR5_BASE},
	{60967, R_028D90_CB_COLOR5_PITCH, 2, 2025},
	{60983, R_028D94_CB_COLOR5_SLICE, 1, 2027},
	{60999, R_028D98_CB_COLOR5_VIEW, 2, 2028},
	{61014, R_028D9C_CB_COLOR5_INFO, 18, 2030},
	{61029, R_028DA0_CB_COLOR5_ATTRIB, 6, 2048},
	{61046, R_028DA4_CB_COLOR5_DCC_CONTROL, 9, 2054},
	{61068, R_028DA8_CB_COLOR5_CMASK},
	{61084, R_028DAC_CB_COLOR5_CMASK_SLICE, 1, 2063},
	{61106, R_028DB0_CB_COLOR5_FMASK},
	{61122, R_028DB4_CB_COLOR5_FMASK_SLICE, 1, 2064},
	{61144, R_028DB8_CB_COLOR5_CLEAR_WORD0},
	{61166, R_028DBC_CB_COLOR5_CLEAR_WORD1},
	{61188, R_028DC0_CB_COLOR5_DCC_BASE},
	{61207, R_028DC8_CB_COLOR6_BASE},
	{61222, R_028DCC_CB_COLOR6_PITCH, 2, 2025},
	{61238, R_028DD0_CB_COLOR6_SLICE, 1, 2027},
	{61254, R_028DD4_CB_COLOR6_VIEW, 2, 2028},
	{61269, R_028DD8_CB_COLOR6_INFO, 18, 2030},
	{61284, R_028DDC_CB_COLOR6_ATTRIB, 6, 2048},
	{61301, R_028DE0_CB_COLOR6_DCC_CONTROL, 9, 2054},
	{61323, R_028DE4_CB_COLOR6_CMASK},
	{61339, R_028DE8_CB_COLOR6_CMASK_SLICE, 1, 2063},
	{61361, R_028DEC_CB_COLOR6_FMASK},
	{61377, R_028DF0_CB_COLOR6_FMASK_SLICE, 1, 2064},
	{61399, R_028DF4_CB_COLOR6_CLEAR_WORD0},
	{61421, R_028DF8_CB_COLOR6_CLEAR_WORD1},
	{61443, R_028DFC_CB_COLOR6_DCC_BASE},
	{61462, R_028E04_CB_COLOR7_BASE},
	{61477, R_028E08_CB_COLOR7_PITCH, 2, 2025},
	{61493, R_028E0C_CB_COLOR7_SLICE, 1, 2027},
	{61509, R_028E10_CB_COLOR7_VIEW, 2, 2028},
	{61524, R_028E14_CB_COLOR7_INFO, 18, 2030},
	{61539, R_028E18_CB_COLOR7_ATTRIB, 6, 2048},
	{61556, R_028E1C_CB_COLOR7_DCC_CONTROL, 9, 2054},
	{61578, R_028E20_CB_COLOR7_CMASK},
	{61594, R_028E24_CB_COLOR7_CMASK_SLICE, 1, 2063},
	{61616, R_028E28_CB_COLOR7_FMASK},
	{61632, R_028E2C_CB_COLOR7_FMASK_SLICE, 1, 2064},
	{61654, R_028E30_CB_COLOR7_CLEAR_WORD0},
	{61676, R_028E34_CB_COLOR7_CLEAR_WORD1},
	{61698, R_028E38_CB_COLOR7_DCC_BASE},
};

static const char sid_strings[] =
	"NOP\0" /* 0 */
	"SET_BASE\0" /* 4 */
	"CLEAR_STATE\0" /* 13 */
	"INDEX_BUFFER_SIZE\0" /* 25, 38 */
	"DISPATCH_DIRECT\0" /* 43 */
	"DISPATCH_INDIRECT\0" /* 59 */
	"OCCLUSION_QUERY\0" /* 91, 77 */
	"SET_PREDICATION\0" /* 93 */
	"COND_EXEC\0" /* 109 */
	"PRED_EXEC\0" /* 119 */
	"DRAW_INDIRECT\0" /* 129 */
	"DRAW_INDEX_INDIRECT\0" /* 143 */
	"INDEX_BASE\0" /* 163 */
	"DRAW_INDEX_2\0" /* 174 */
	"CONTEXT_CONTROL\0" /* 187, 195 */
	"INDEX_TYPE\0" /* 209, 203 */
	"DRAW_INDIRECT_MULTI\0" /* 214 */
	"DRAW_INDEX_AUTO\0" /* 234 */
	"DRAW_INDEX_IMMD\0" /* 250 */
	"NUM_INSTANCES\0" /* 266 */
	"DRAW_INDEX_MULTI_AUTO\0" /* 280 */
	"INDIRECT_BUFFER_SI\0" /* 302 */
	"INDIRECT_BUFFER_CONST\0" /* 321 */
	"STRMOUT_BUFFER_UPDATE\0" /* 343 */
	"DRAW_INDEX_OFFSET_2\0" /* 365 */
	"WRITE_DATA\0" /* 385, 391 */
	"DRAW_INDEX_INDIRECT_MULTI\0" /* 396 */
	"MEM_SEMAPHORE\0" /* 422 */
	"MPEG_INDEX\0" /* 436, 445 */
	"WAIT_REG_MEM\0" /* 447 */
	"MEM_WRITE\0" /* 460 */
	"INDIRECT_BUFFER_CIK\0" /* 470 */
	"COPY_DATA\0" /* 490 */
	"PFP_SYNC_ME\0" /* 500, 509 */
	"SURFACE_SYNC\0" /* 512 */
	"ME_INITIALIZE\0" /* 525 */
	"COND_WRITE\0" /* 539 */
	"EVENT_WRITE\0" /* 550 */
	"EVENT_WRITE_EOP\0" /* 562 */
	"RELEASE_MEM\0" /* 578 */
	"ONE_REG_WRITE\0" /* 590 */
	"ACQUIRE_MEM\0" /* 604 */
	"SET_CONFIG_REG\0" /* 616 */
	"SET_CONTEXT_REG\0" /* 631 */
	"SET_SH_REG\0" /* 647 */
	"SET_SH_REG_OFFSET\0" /* 658, 669 */
	"SET_UCONFIG_REG\0" /* 676 */
	"LOAD_CONST_RAM\0" /* 692 */
	"WRITE_CONST_RAM\0" /* 707 */
	"DUMP_CONST_RAM\0" /* 723 */
	"INCREMENT_CE_COUNTER\0" /* 738 */
	"INCREMENT_DE_COUNTER\0" /* 759 */
	"WAIT_ON_CE_COUNTER\0" /* 780 */
	"IT_OPCODE_C\0" /* 799 */
	"CP_DMA\0" /* 811 */
	"DMA_DATA\0" /* 818 */
	"COUNT_INDIRECT_ENABLE\0" /* 842, 827 */
	"DRAW_INDEX_ENABLE\0" /* 849 */
	"PFP\0" /* 867 */
	"CE\0" /* 871 */
	"DE\0" /* 874 */
	"ENGINE_SEL\0" /* 877 */
	"WR_CONFIRM\0" /* 888 */
	"WR_ONE_ADDR\0" /* 906, 899 */
	"MEM_MAPPED_REGISTER\0" /* 922, 911 */
	"MEMORY_SYNC\0" /* 931 */
	"TC_L2\0" /* 943 */
	"GDS\0" /* 949 */
	"RESERVED\0" /* 953 */
	"MEM_ASYNC\0" /* 962 */
	"DST_SEL\0" /* 972 */
	"IB_SIZE\0" /* 980 */
	"CHAIN\0" /* 988 */
	"VALID\0" /* 994 */
	"SRC_ADDR_LO\0" /* 1000 */
	"CP_SYNC\0" /* 1012 */
	"SRC_ADDR\0" /* 1020 */
	"SRC_ADDR_TC_L2\0" /* 1029 */
	"SRC_SEL\0" /* 1044 */
	"ENGINE\0" /* 1052 */
	"DST_ADDR\0" /* 1059 */
	"DST_ADDR_TC_L2\0" /* 1068 */
	"DSL_SEL\0" /* 1083 */
	"SRC_ADDR_HI\0" /* 1091 */
	"DST_ADDR_LO\0" /* 1103 */
	"DST_ADDR_HI\0" /* 1115 */
	"BYTE_COUNT\0" /* 1127 */
	"DISABLE_WR_CONFIRM\0" /* 1138 */
	"NONE\0" /* 1157 */
	"8_IN_16\0" /* 1162 */
	"8_IN_32\0" /* 1170 */
	"8_IN_64\0" /* 1178 */
	"SRC_SWAP\0" /* 1186 */
	"DST_SWAP\0" /* 1195 */
	"MEMORY\0" /* 1204 */
	"SAS\0" /* 1211 */
	"DAS\0" /* 1215 */
	"INCREMENT\0" /* 1219 */
	"NO_INCREMENT\0" /* 1229 */
	"SAIC\0" /* 1242 */
	"DAIC\0" /* 1247 */
	"RAW_WAIT\0" /* 1252 */
	"SDMA_RQ_PENDING\0" /* 1261 */
	"TST_RQ_PENDING\0" /* 1277 */
	"SDMA1_RQ_PENDING\0" /* 1292 */
	"VCE0_RQ_PENDING\0" /* 1309 */
	"VP8_BUSY\0" /* 1325 */
	"SDMA_BUSY\0" /* 1334, 1335 */
	"SDMA1_BUSY\0" /* 1344 */
	"VCE0_BUSY\0" /* 1355 */
	"XDMA_BUSY\0" /* 1365 */
	"CHUB_BUSY\0" /* 1375 */
	"SDMA2_BUSY\0" /* 1385 */
	"SDMA3_BUSY\0" /* 1396 */
	"SAMSCP_BUSY\0" /* 1411, 1407 */
	"ISP_BUSY\0" /* 1419 */
	"VCE1_BUSY\0" /* 1428 */
	"ODE_BUSY\0" /* 1438 */
	"SDMA2_RQ_PENDING\0" /* 1447 */
	"SDMA3_RQ_PENDING\0" /* 1464 */
	"SAMSCP_RQ_PENDING\0" /* 1481 */
	"ISP_RQ_PENDING\0" /* 1499 */
	"VCE1_RQ_PENDING\0" /* 1514 */
	"UVD_RQ_PENDING\0" /* 1530 */
	"SAMMSP_RQ_PENDING\0" /* 1545 */
	"ACP_RQ_PENDING\0" /* 1563 */
	"SMU_RQ_PENDING\0" /* 1578 */
	"GRBM_RQ_PENDING\0" /* 1593 */
	"HI_RQ_PENDING\0" /* 1609 */
	"VMC_BUSY\0" /* 1623 */
	"MCB_BUSY\0" /* 1632, 1633 */
	"MCB_NON_DISPLAY_BUSY\0" /* 1641 */
	"MCC_BUSY\0" /* 1662 */
	"MCD_BUSY\0" /* 1671 */
	"VMC1_BUSY\0" /* 1680 */
	"SEM_BUSY\0" /* 1690 */
	"ACP_BUSY\0" /* 1699 */
	"IH_BUSY\0" /* 1708 */
	"UVD_BUSY\0" /* 1716 */
	"SAMMSP_BUSY\0" /* 1725 */
	"GCATCL2_BUSY\0" /* 1737 */
	"OSATCL2_BUSY\0" /* 1750 */
	"BIF_BUSY\0" /* 1763 */
	"MCC0_BUSY\0" /* 1772 */
	"MCC1_BUSY\0" /* 1782 */
	"MCC2_BUSY\0" /* 1792 */
	"MCC3_BUSY\0" /* 1802 */
	"MCC4_BUSY\0" /* 1812 */
	"MCC5_BUSY\0" /* 1822 */
	"MCC6_BUSY\0" /* 1832 */
	"MCC7_BUSY\0" /* 1842 */
	"MCD0_BUSY\0" /* 1852 */
	"MCD1_BUSY\0" /* 1862 */
	"MCD2_BUSY\0" /* 1872 */
	"MCD3_BUSY\0" /* 1882 */
	"MCD4_BUSY\0" /* 1892 */
	"MCD5_BUSY\0" /* 1902 */
	"MCD6_BUSY\0" /* 1912 */
	"MCD7_BUSY\0" /* 1922 */
	"IDLE\0" /* 1932 */
	"REG_IDLE\0" /* 1937 */
	"RB_EMPTY\0" /* 1946 */
	"RB_FULL\0" /* 1955 */
	"RB_CMD_IDLE\0" /* 1963 */
	"RB_CMD_FULL\0" /* 1975 */
	"IB_CMD_IDLE\0" /* 1987 */
	"IB_CMD_FULL\0" /* 1999 */
	"BLOCK_IDLE\0" /* 2011 */
	"INSIDE_IB\0" /* 2022 */
	"EX_IDLE\0" /* 2032 */
	"EX_IDLE_POLL_TIMER_EXPIRE\0" /* 2040 */
	"PACKET_READY\0" /* 2066 */
	"MC_WR_IDLE\0" /* 2079 */
	"SRBM_IDLE\0" /* 2090 */
	"CONTEXT_EMPTY\0" /* 2100 */
	"DELTA_RPTR_FULL\0" /* 2114 */
	"RB_MC_RREQ_IDLE\0" /* 2130 */
	"IB_MC_RREQ_IDLE\0" /* 2146 */
	"MC_RD_IDLE\0" /* 2162 */
	"DELTA_RPTR_EMPTY\0" /* 2173 */
	"MC_RD_RET_STALL\0" /* 2190 */
	"MC_RD_NO_POLL_IDLE\0" /* 2206 */
	"PREV_CMD_IDLE\0" /* 2225 */
	"SEM_IDLE\0" /* 2239 */
	"SEM_REQ_STALL\0" /* 2248 */
	"SEM_RESP_STATE\0" /* 2262 */
	"INT_IDLE\0" /* 2277 */
	"INT_REQ_STALL\0" /* 2286 */
	"ME0PIPE1_CMDFIFO_AVAIL\0" /* 2300 */
	"ME0PIPE1_CF_RQ_PENDING\0" /* 2323 */
	"ME0PIPE1_PF_RQ_PENDING\0" /* 2346 */
	"ME1PIPE0_RQ_PENDING\0" /* 2369 */
	"ME1PIPE1_RQ_PENDING\0" /* 2389 */
	"ME1PIPE2_RQ_PENDING\0" /* 2409 */
	"ME1PIPE3_RQ_PENDING\0" /* 2429 */
	"ME2PIPE0_RQ_PENDING\0" /* 2449 */
	"ME2PIPE1_RQ_PENDING\0" /* 2469 */
	"ME2PIPE2_RQ_PENDING\0" /* 2489 */
	"ME2PIPE3_RQ_PENDING\0" /* 2509 */
	"RLC_RQ_PENDING\0" /* 2529 */
	"RLC_BUSY\0" /* 2544 */
	"TC_BUSY\0" /* 2553 */
	"TCC_CC_RESIDENT\0" /* 2561 */
	"CPF_BUSY\0" /* 2577 */
	"CPC_BUSY\0" /* 2586 */
	"CPG_BUSY\0" /* 2595 */
	"ME0PIPE0_CMDFIFO_AVAIL\0" /* 2604 */
	"SRBM_RQ_PENDING\0" /* 2627 */
	"ME0PIPE0_CF_RQ_PENDING\0" /* 2643 */
	"ME0PIPE0_PF_RQ_PENDING\0" /* 2666 */
	"GDS_DMA_RQ_PENDING\0" /* 2689 */
	"DB_CLEAN\0" /* 2708 */
	"CB_CLEAN\0" /* 2717 */
	"TA_BUSY\0" /* 2726 */
	"GDS_BUSY\0" /* 2734 */
	"WD_BUSY_NO_DMA\0" /* 2743 */
	"VGT_BUSY\0" /* 2758 */
	"IA_BUSY_NO_DMA\0" /* 2767 */
	"IA_BUSY\0" /* 2782 */
	"SX_BUSY\0" /* 2790 */
	"WD_BUSY\0" /* 2798 */
	"SPI_BUSY\0" /* 2806 */
	"BCI_BUSY\0" /* 2815 */
	"SC_BUSY\0" /* 2824 */
	"PA_BUSY\0" /* 2832 */
	"DB_BUSY\0" /* 2840 */
	"CP_COHERENCY_BUSY\0" /* 2848 */
	"GUI_ACTIVE\0" /* 2866 */
	"OFFSET_UPDATE_DONE\0" /* 2891, 2877 */
	"DEST_BASE_0_ENA\0" /* 2896 */
	"DEST_BASE_1_ENA\0" /* 2912 */
	"CB0_DEST_BASE_ENA\0" /* 2928 */
	"CB1_DEST_BASE_ENA\0" /* 2946 */
	"CB2_DEST_BASE_ENA\0" /* 2964 */
	"CB3_DEST_BASE_ENA\0" /* 2982 */
	"CB4_DEST_BASE_ENA\0" /* 3000 */
	"CB5_DEST_BASE_ENA\0" /* 3018 */
	"CB6_DEST_BASE_ENA\0" /* 3036 */
	"CB7_DEST_BASE_ENA\0" /* 3054 */
	"DB_DEST_BASE_ENA\0" /* 3072 */
	"DEST_BASE_2_ENA\0" /* 3089 */
	"DEST_BASE_3_ENA\0" /* 3105 */
	"TCL1_ACTION_ENA\0" /* 3121 */
	"TC_ACTION_ENA\0" /* 3137 */
	"CB_ACTION_ENA\0" /* 3151 */
	"DB_ACTION_ENA\0" /* 3165 */
	"SH_KCACHE_ACTION_ENA\0" /* 3179 */
	"SH_ICACHE_ACTION_ENA\0" /* 3200 */
	"COHER_BASE_HI_256B\0" /* 3221 */
	"START_DELAY_COUNT\0" /* 3240 */
	"TC_SD_ACTION_ENA\0" /* 3258 */
	"TC_NC_ACTION_ENA\0" /* 3275 */
	"TCL1_VOL_ACTION_ENA\0" /* 3292 */
	"TC_VOL_ACTION_ENA\0" /* 3312 */
	"TC_WB_ACTION_ENA\0" /* 3330 */
	"SH_KCACHE_VOL_ACTION_ENA\0" /* 3347 */
	"SH_KCACHE_WB_ACTION_ENA\0" /* 3372 */
	"SH_SD_ACTION_ENA\0" /* 3396 */
	"MATCHING_GFX_CNTX\0" /* 3413 */
	"MEID\0" /* 3431 */
	"PHASE1_STATUS\0" /* 3443, 3436 */
	"MEC1_BUSY\0" /* 3450 */
	"MEC2_BUSY\0" /* 3460 */
	"DC0_BUSY\0" /* 3470 */
	"DC1_BUSY\0" /* 3479 */
	"RCIU1_BUSY\0" /* 3488 */
	"RCIU2_BUSY\0" /* 3499 */
	"ROQ1_BUSY\0" /* 3510 */
	"ROQ2_BUSY\0" /* 3520 */
	"TCIU_BUSY\0" /* 3530 */
	"SCRATCH_RAM_BUSY\0" /* 3540 */
	"QU_BUSY\0" /* 3557 */
	"ATCL2IU_BUSY\0" /* 3565 */
	"CPG_CPC_BUSY\0" /* 3578 */
	"CPF_CPC_BUSY\0" /* 3591 */
	"MEC1_LOAD_BUSY\0" /* 3604 */
	"MEC1_SEMAPOHRE_BUSY\0" /* 3619 */
	"MEC1_MUTEX_BUSY\0" /* 3639 */
	"MEC1_MESSAGE_BUSY\0" /* 3655 */
	"MEC1_EOP_QUEUE_BUSY\0" /* 3673 */
	"MEC1_IQ_QUEUE_BUSY\0" /* 3693 */
	"MEC1_IB_QUEUE_BUSY\0" /* 3712 */
	"MEC1_TC_BUSY\0" /* 3731 */
	"MEC1_DMA_BUSY\0" /* 3744 */
	"MEC1_PARTIAL_FLUSH_BUSY\0" /* 3758 */
	"MEC1_PIPE0_BUSY\0" /* 3782 */
	"MEC1_PIPE1_BUSY\0" /* 3798 */
	"MEC1_PIPE2_BUSY\0" /* 3814 */
	"MEC1_PIPE3_BUSY\0" /* 3830 */
	"MEC2_LOAD_BUSY\0" /* 3846 */
	"MEC2_SEMAPOHRE_BUSY\0" /* 3861 */
	"MEC2_MUTEX_BUSY\0" /* 3881 */
	"MEC2_MESSAGE_BUSY\0" /* 3897 */
	"MEC2_EOP_QUEUE_BUSY\0" /* 3915 */
	"MEC2_IQ_QUEUE_BUSY\0" /* 3935 */
	"MEC2_IB_QUEUE_BUSY\0" /* 3954 */
	"MEC2_TC_BUSY\0" /* 3973 */
	"MEC2_DMA_BUSY\0" /* 3986 */
	"MEC2_PARTIAL_FLUSH_BUSY\0" /* 4000 */
	"MEC2_PIPE0_BUSY\0" /* 4024 */
	"MEC2_PIPE1_BUSY\0" /* 4040 */
	"MEC2_PIPE2_BUSY\0" /* 4056 */
	"MEC2_PIPE3_BUSY\0" /* 4072 */
	"RCIU_TX_FREE_STALL\0" /* 4088 */
	"RCIU_PRIV_VIOLATION\0" /* 4107 */
	"TCIU_TX_FREE_STALL\0" /* 4127 */
	"MEC1_DECODING_PACKET\0" /* 4146 */
	"MEC1_WAIT_ON_RCIU\0" /* 4167 */
	"MEC1_WAIT_ON_RCIU_READ\0" /* 4185 */
	"MEC1_WAIT_ON_ROQ_DATA\0" /* 4208 */
	"MEC2_DECODING_PACKET\0" /* 4230 */
	"MEC2_WAIT_ON_RCIU\0" /* 4251 */
	"MEC2_WAIT_ON_RCIU_READ\0" /* 4269 */
	"MEC2_WAIT_ON_ROQ_DATA\0" /* 4292 */
	"ATCL2IU_WAITING_ON_FREE\0" /* 4314 */
	"ATCL2IU_WAITING_ON_TAGS\0" /* 4338 */
	"ATCL1_WAITING_ON_TRANS\0" /* 4362 */
	"POST_WPTR_GFX_BUSY\0" /* 4385 */
	"CSF_BUSY\0" /* 4404 */
	"ROQ_ALIGN_BUSY\0" /* 4413 */
	"ROQ_RING_BUSY\0" /* 4428 */
	"ROQ_INDIRECT1_BUSY\0" /* 4442 */
	"ROQ_INDIRECT2_BUSY\0" /* 4461 */
	"ROQ_STATE_BUSY\0" /* 4480 */
	"ROQ_CE_RING_BUSY\0" /* 4495 */
	"ROQ_CE_INDIRECT1_BUSY\0" /* 4512 */
	"ROQ_CE_INDIRECT2_BUSY\0" /* 4534 */
	"SEMAPHORE_BUSY\0" /* 4556 */
	"INTERRUPT_BUSY\0" /* 4571 */
	"HQD_BUSY\0" /* 4586 */
	"PRT_BUSY\0" /* 4595 */
	"CPF_GFX_BUSY\0" /* 4604 */
	"CPF_CMP_BUSY\0" /* 4617 */
	"GRBM_CPF_STAT_BUSY\0" /* 4630 */
	"CPC_CPF_BUSY\0" /* 4649 */
	"REG_BUS_FIFO_BUSY\0" /* 4662 */
	"CSF_RING_BUSY\0" /* 4680 */
	"CSF_INDIRECT1_BUSY\0" /* 4694 */
	"CSF_INDIRECT2_BUSY\0" /* 4713 */
	"CSF_STATE_BUSY\0" /* 4732 */
	"CSF_CE_INDR1_BUSY\0" /* 4747 */
	"CSF_CE_INDR2_BUSY\0" /* 4765 */
	"CSF_ARBITER_BUSY\0" /* 4783 */
	"CSF_INPUT_BUSY\0" /* 4800 */
	"OUTSTANDING_READ_TAGS\0" /* 4815 */
	"HPD_PROCESSING_EOP_BUSY\0" /* 4837 */
	"HQD_DISPATCH_BUSY\0" /* 4861 */
	"HQD_IQ_TIMER_BUSY\0" /* 4879 */
	"HQD_DMA_OFFLOAD_BUSY\0" /* 4897 */
	"HQD_WAIT_SEMAPHORE_BUSY\0" /* 4918 */
	"HQD_SIGNAL_SEMAPHORE_BUSY\0" /* 4942 */
	"HQD_MESSAGE_BUSY\0" /* 4968 */
	"HQD_PQ_FETCHER_BUSY\0" /* 4985 */
	"HQD_IB_FETCHER_BUSY\0" /* 5005 */
	"HQD_IQ_FETCHER_BUSY\0" /* 5025 */
	"HQD_EOP_FETCHER_BUSY\0" /* 5045 */
	"HQD_CONSUMED_RPTR_BUSY\0" /* 5066 */
	"HQD_FETCHER_ARB_BUSY\0" /* 5089 */
	"HQD_ROQ_ALIGN_BUSY\0" /* 5110 */
	"HQD_ROQ_EOP_BUSY\0" /* 5129 */
	"HQD_ROQ_IQ_BUSY\0" /* 5146 */
	"HQD_ROQ_PQ_BUSY\0" /* 5162 */
	"HQD_ROQ_IB_BUSY\0" /* 5178 */
	"HQD_WPTR_POLL_BUSY\0" /* 5194 */
	"HQD_PQ_BUSY\0" /* 5213 */
	"HQD_IB_BUSY\0" /* 5225 */
	"RING_FETCHING_DATA\0" /* 5237 */
	"INDR1_FETCHING_DATA\0" /* 5256 */
	"INDR2_FETCHING_DATA\0" /* 5276 */
	"STATE_FETCHING_DATA\0" /* 5296 */
	"TCIU_WAITING_ON_FREE\0" /* 5316 */
	"TCIU_WAITING_ON_TAGS\0" /* 5337 */
	"COHER_SIZE_HI_256B\0" /* 5358 */
	"PRIM_COUNT\0" /* 5377 */
	"VS_NO_EXTRA_BUFFER\0" /* 5388 */
	"STREAMOUT_FULL_FLUSH\0" /* 5407 */
	"ES_LIMIT\0" /* 5428, 5431 */
	"VERT_REUSE\0" /* 5437 */
	"DI_PT_NONE\0" /* 5448 */
	"DI_PT_POINTLIST\0" /* 5459 */
	"DI_PT_LINELIST\0" /* 5475 */
	"DI_PT_LINESTRIP\0" /* 5490 */
	"DI_PT_TRILIST\0" /* 5506 */
	"DI_PT_TRIFAN\0" /* 5520 */
	"DI_PT_TRISTRIP\0" /* 5533 */
	"DI_PT_UNUSED_0\0" /* 5548 */
	"DI_PT_UNUSED_1\0" /* 5563 */
	"DI_PT_PATCH\0" /* 5578 */
	"DI_PT_LINELIST_ADJ\0" /* 5590 */
	"DI_PT_LINESTRIP_ADJ\0" /* 5609 */
	"DI_PT_TRILIST_ADJ\0" /* 5629 */
	"DI_PT_TRISTRIP_ADJ\0" /* 5647 */
	"DI_PT_UNUSED_3\0" /* 5666 */
	"DI_PT_UNUSED_4\0" /* 5681 */
	"DI_PT_TRI_WITH_WFLAGS\0" /* 5696 */
	"DI_PT_RECTLIST\0" /* 5718 */
	"DI_PT_LINELOOP\0" /* 5733 */
	"DI_PT_QUADLIST\0" /* 5748 */
	"DI_PT_QUADSTRIP\0" /* 5763 */
	"DI_PT_POLYGON\0" /* 5779 */
	"DI_PT_2D_COPY_RECT_LIST_V0\0" /* 5793 */
	"DI_PT_2D_COPY_RECT_LIST_V1\0" /* 5820 */
	"DI_PT_2D_COPY_RECT_LIST_V2\0" /* 5847 */
	"DI_PT_2D_COPY_RECT_LIST_V3\0" /* 5874 */
	"DI_PT_2D_FILL_RECT_LIST\0" /* 5901 */
	"DI_PT_2D_LINE_STRIP\0" /* 5925 */
	"DI_PT_2D_TRI_STRIP\0" /* 5945 */
	"PRIM_TYPE\0" /* 5964 */
	"DI_INDEX_SIZE_16_BIT\0" /* 5974 */
	"DI_INDEX_SIZE_32_BIT\0" /* 5995 */
	"OFFCHIP_BUFFERING\0" /* 6016 */
	"CLIP_VTX_REORDER_ENA\0" /* 6034 */
	"NUM_CLIP_SEQ\0" /* 6055 */
	"CLIPPED_PRIM_SEQ_STALL\0" /* 6068 */
	"VE_NAN_PROC_DISABLE\0" /* 6091 */
	"LINE_STIPPLE_VALUE\0" /* 6111 */
	"CURRENT_PTR\0" /* 6130 */
	"CURRENT_COUNT\0" /* 6142 */
	"CE_TO_CSF_NOT_RDY_TO_RCV\0" /* 6156 */
	"CE_TO_RAM_INIT_FETCHER_NOT_RDY_TO_RCV\0" /* 6181 */
	"CE_WAITING_ON_DATA_FROM_RAM_INIT_FETCHER\0" /* 6219 */
	"CE_TO_RAM_INIT_NOT_RDY\0" /* 6260 */
	"CE_TO_RAM_DUMP_NOT_RDY\0" /* 6283 */
	"CE_TO_RAM_WRITE_NOT_RDY\0" /* 6306 */
	"CE_TO_INC_FIFO_NOT_RDY_TO_RCV\0" /* 6330 */
	"CE_TO_WR_FIFO_NOT_RDY_TO_RCV\0" /* 6360 */
	"CE_WAITING_ON_BUFFER_DATA\0" /* 6389 */
	"CE_WAITING_ON_CE_BUFFER_FLAG\0" /* 6415 */
	"CE_WAITING_ON_DE_COUNTER\0" /* 6444 */
	"CE_WAITING_ON_DE_COUNTER_UNDERFLOW\0" /* 6469 */
	"CE_STALLED_ON_TC_WR_CONFIRM\0" /* 6504 */
	"CE_STALLED_ON_ATOMIC_RTN_DATA\0" /* 6532 */
	"RBIU_TO_DMA_NOT_RDY_TO_RCV\0" /* 6562 */
	"RBIU_TO_SEM_NOT_RDY_TO_RCV\0" /* 6589 */
	"RBIU_TO_MEMWR_NOT_RDY_TO_RCV\0" /* 6616 */
	"ME_HAS_ACTIVE_CE_BUFFER_FLAG\0" /* 6645 */
	"ME_HAS_ACTIVE_DE_BUFFER_FLAG\0" /* 6674 */
	"ME_STALLED_ON_TC_WR_CONFIRM\0" /* 6703 */
	"ME_STALLED_ON_ATOMIC_RTN_DATA\0" /* 6731 */
	"ME_WAITING_ON_TC_READ_DATA\0" /* 6761 */
	"ME_WAITING_ON_REG_READ_DATA\0" /* 6788 */
	"RCIU_WAITING_ON_GDS_FREE\0" /* 6816 */
	"RCIU_WAITING_ON_GRBM_FREE\0" /* 6841 */
	"RCIU_WAITING_ON_VGT_FREE\0" /* 6867 */
	"RCIU_STALLED_ON_ME_READ\0" /* 6892 */
	"RCIU_STALLED_ON_DMA_READ\0" /* 6916 */
	"RCIU_STALLED_ON_APPEND_READ\0" /* 6941 */
	"RCIU_HALTED_BY_REG_VIOLATION\0" /* 6969 */
	"PFP_TO_CSF_NOT_RDY_TO_RCV\0" /* 6998 */
	"PFP_TO_MEQ_NOT_RDY_TO_RCV\0" /* 7024 */
	"PFP_TO_RCIU_NOT_RDY_TO_RCV\0" /* 7050 */
	"PFP_TO_VGT_WRITES_PENDING\0" /* 7077 */
	"PFP_RCIU_READ_PENDING\0" /* 7103 */
	"PFP_WAITING_ON_BUFFER_DATA\0" /* 7125 */
	"ME_WAIT_ON_CE_COUNTER\0" /* 7152 */
	"ME_WAIT_ON_AVAIL_BUFFER\0" /* 7174 */
	"GFX_CNTX_NOT_AVAIL_TO_ME\0" /* 7198 */
	"ME_RCIU_NOT_RDY_TO_RCV\0" /* 7223 */
	"ME_TO_CONST_NOT_RDY_TO_RCV\0" /* 7246 */
	"ME_WAITING_DATA_FROM_PFP\0" /* 7273 */
	"ME_WAITING_ON_PARTIAL_FLUSH\0" /* 7298 */
	"MEQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7326 */
	"STQ_TO_ME_NOT_RDY_TO_RCV\0" /* 7351 */
	"ME_WAITING_DATA_FROM_STQ\0" /* 7376 */
	"PFP_STALLED_ON_TC_WR_CONFIRM\0" /* 7401 */
	"PFP_STALLED_ON_ATOMIC_RTN_DATA\0" /* 7430 */
	"EOPD_FIFO_NEEDS_SC_EOP_DONE\0" /* 7461 */
	"EOPD_FIFO_NEEDS_WR_CONFIRM\0" /* 7489 */
	"STRMO_WR_OF_PRIM_DATA_PENDING\0" /* 7516 */
	"PIPE_STATS_WR_DATA_PENDING\0" /* 7546 */
	"APPEND_RDY_WAIT_ON_CS_DONE\0" /* 7592, 7573 */
	"APPEND_RDY_WAIT_ON_PS_DONE\0" /* 7600, 7619 */
	"APPEND_WAIT_ON_WR_CONFIRM\0" /* 7627 */
	"APPEND_ACTIVE_PARTITION\0" /* 7653 */
	"APPEND_WAITING_TO_SEND_MEMWRITE\0" /* 7677 */
	"SURF_SYNC_NEEDS_IDLE_CNTXS\0" /* 7709 */
	"SURF_SYNC_NEEDS_ALL_CLEAN\0" /* 7736 */
	"DC_BUSY\0" /* 7762 */
	"PFP_BUSY\0" /* 7770 */
	"MEQ_BUSY\0" /* 7779 */
	"ME_BUSY\0" /* 7788 */
	"QUERY_BUSY\0" /* 7796 */
	"SURFACE_SYNC_BUSY\0" /* 7807 */
	"RCIU_BUSY\0" /* 7825 */
	"CPC_CPG_BUSY\0" /* 7835 */
	"CE_BUSY\0" /* 7848 */
	"INSTANCE_INDEX\0" /* 7856 */
	"SH_INDEX\0" /* 7871 */
	"SE_INDEX\0" /* 7880 */
	"SH_BROADCAST_WRITES\0" /* 7889 */
	"INSTANCE_BROADCAST_WRITES\0" /* 7909 */
	"SE_BROADCAST_WRITES\0" /* 7935 */
	"X_8K_DWORDS\0" /* 7955 */
	"X_4K_DWORDS\0" /* 7967 */
	"X_2K_DWORDS\0" /* 7979 */
	"X_1K_DWORDS\0" /* 7991 */
	"OFFCHIP_GRANULARITY\0" /* 8003 */
	"ENABLE_PA_SC_OUT_OF_ORDER\0" /* 8023 */
	"DISABLE_SC_DB_TILE_FIX\0" /* 8049 */
	"DISABLE_AA_MASK_FULL_FIX\0" /* 8072 */
	"ENABLE_1XMSAA_SAMPLE_LOCATIONS\0" /* 8097 */
	"ENABLE_1XMSAA_SAMPLE_LOC_CENTROID\0" /* 8128 */
	"DISABLE_SCISSOR_FIX\0" /* 8162 */
	"DISABLE_PW_BUBBLE_COLLAPSE\0" /* 8182 */
	"SEND_UNLIT_STILES_TO_PACKER\0" /* 8209 */
	"DISABLE_DUALGRAD_PERF_OPTIMIZATION\0" /* 8237 */
	"INST_INVALIDATE\0" /* 8272 */
	"DATA_INVALIDATE\0" /* 8288 */
	"INVALIDATE_VOLATILE\0" /* 8304 */
	"RET\0" /* 8324 */
	"RUI\0" /* 8328 */
	"RNG\0" /* 8332 */
	"EN\0" /* 8336 */
	"SQ_EXP_MRT\0" /* 8339 */
	"SQ_EXP_MRTZ\0" /* 8350 */
	"SQ_EXP_NULL\0" /* 8362 */
	"SQ_EXP_POS\0" /* 8374 */
	"SQ_EXP_PARAM\0" /* 8385 */
	"TGT\0" /* 8398 */
	"COMPR\0" /* 8402 */
	"VM\0" /* 8408 */
	"SQ_ENC_EXP_FIELD\0" /* 8411 */
	"ENCODING\0" /* 8428 */
	"ADDRESS\0" /* 8437 */
	"COUNT_HI\0" /* 8445 */
	"BASE_ADDRESS_HI\0" /* 8459, 8454 */
	"STRIDE\0" /* 8470 */
	"CACHE_SWIZZLE\0" /* 8477 */
	"SWIZZLE_ENABLE\0" /* 8491 */
	"SQ_SEL_0\0" /* 8506 */
	"SQ_SEL_1\0" /* 8515 */
	"SQ_SEL_RESERVED_0\0" /* 8531, 8524 */
	"SQ_SEL_RESERVED_1\0" /* 8549, 8542 */
	"SQ_SEL_X\0" /* 8560 */
	"SQ_SEL_Y\0" /* 8569 */
	"SQ_SEL_Z\0" /* 8578 */
	"SQ_SEL_W\0" /* 8587 */
	"DST_SEL_X\0" /* 8596 */
	"DST_SEL_Y\0" /* 8606 */
	"DST_SEL_Z\0" /* 8616 */
	"DST_SEL_W\0" /* 8626 */
	"BUF_NUM_FORMAT_UNORM\0" /* 8636 */
	"BUF_NUM_FORMAT_SNORM\0" /* 8657 */
	"BUF_NUM_FORMAT_USCALED\0" /* 8678 */
	"BUF_NUM_FORMAT_SSCALED\0" /* 8701 */
	"BUF_NUM_FORMAT_UINT\0" /* 8724 */
	"BUF_NUM_FORMAT_SINT\0" /* 8744 */
	"BUF_NUM_FORMAT_SNORM_OGL\0" /* 8764 */
	"BUF_NUM_FORMAT_FLOAT\0" /* 8789 */
	"NUM_FORMAT\0" /* 8810, 8814 */
	"BUF_DATA_FORMAT_INVALID\0" /* 8821 */
	"BUF_DATA_FORMAT_8\0" /* 8845 */
	"BUF_DATA_FORMAT_16\0" /* 8863 */
	"BUF_DATA_FORMAT_8_8\0" /* 8882 */
	"BUF_DATA_FORMAT_32\0" /* 8902 */
	"BUF_DATA_FORMAT_16_16\0" /* 8921 */
	"BUF_DATA_FORMAT_10_11_11\0" /* 8943 */
	"BUF_DATA_FORMAT_11_11_10\0" /* 8968 */
	"BUF_DATA_FORMAT_10_10_10_2\0" /* 8993 */
	"BUF_DATA_FORMAT_2_10_10_10\0" /* 9020 */
	"BUF_DATA_FORMAT_8_8_8_8\0" /* 9047 */
	"BUF_DATA_FORMAT_32_32\0" /* 9071 */
	"BUF_DATA_FORMAT_16_16_16_16\0" /* 9093 */
	"BUF_DATA_FORMAT_32_32_32\0" /* 9121 */
	"BUF_DATA_FORMAT_32_32_32_32\0" /* 9146 */
	"BUF_DATA_FORMAT_RESERVED_15\0" /* 9174 */
	"DATA_FORMAT\0" /* 9202 */
	"ELEMENT_SIZE\0" /* 9214 */
	"INDEX_STRIDE\0" /* 9227 */
	"ADD_TID_ENABLE\0" /* 9240 */
	"ATC\0" /* 9255 */
	"HASH_ENABLE\0" /* 9259 */
	"HEAP\0" /* 9271 */
	"MTYPE\0" /* 9276 */
	"SQ_RSRC_BUF\0" /* 9282 */
	"SQ_RSRC_BUF_RSVD_1\0" /* 9294 */
	"SQ_RSRC_BUF_RSVD_2\0" /* 9313 */
	"SQ_RSRC_BUF_RSVD_3\0" /* 9332 */
	"MIN_LOD\0" /* 9351 */
	"IMG_DATA_FORMAT_INVALID\0" /* 9359 */
	"IMG_DATA_FORMAT_8\0" /* 9383 */
	"IMG_DATA_FORMAT_16\0" /* 9401 */
	"IMG_DATA_FORMAT_8_8\0" /* 9420 */
	"IMG_DATA_FORMAT_32\0" /* 9440 */
	"IMG_DATA_FORMAT_16_16\0" /* 9459 */
	"IMG_DATA_FORMAT_10_11_11\0" /* 9481 */
	"IMG_DATA_FORMAT_11_11_10\0" /* 9506 */
	"IMG_DATA_FORMAT_10_10_10_2\0" /* 9531 */
	"IMG_DATA_FORMAT_2_10_10_10\0" /* 9558 */
	"IMG_DATA_FORMAT_8_8_8_8\0" /* 9585 */
	"IMG_DATA_FORMAT_32_32\0" /* 9609 */
	"IMG_DATA_FORMAT_16_16_16_16\0" /* 9631 */
	"IMG_DATA_FORMAT_32_32_32\0" /* 9659 */
	"IMG_DATA_FORMAT_32_32_32_32\0" /* 9684 */
	"IMG_DATA_FORMAT_RESERVED_15\0" /* 9712 */
	"IMG_DATA_FORMAT_5_6_5\0" /* 9740 */
	"IMG_DATA_FORMAT_1_5_5_5\0" /* 9762 */
	"IMG_DATA_FORMAT_5_5_5_1\0" /* 9786 */
	"IMG_DATA_FORMAT_4_4_4_4\0" /* 9810 */
	"IMG_DATA_FORMAT_8_24\0" /* 9834 */
	"IMG_DATA_FORMAT_24_8\0" /* 9855 */
	"IMG_DATA_FORMAT_X24_8_32\0" /* 9876 */
	"IMG_DATA_FORMAT_8_AS_8_8_8_8\0" /* 9901 */
	"IMG_DATA_FORMAT_ETC2_RGB\0" /* 9930 */
	"IMG_DATA_FORMAT_ETC2_RGBA\0" /* 9955 */
	"IMG_DATA_FORMAT_ETC2_R\0" /* 9981 */
	"IMG_DATA_FORMAT_ETC2_RG\0" /* 10004 */
	"IMG_DATA_FORMAT_ETC2_RGBA1\0" /* 10028 */
	"IMG_DATA_FORMAT_RESERVED_29\0" /* 10055 */
	"IMG_DATA_FORMAT_RESERVED_30\0" /* 10083 */
	"IMG_DATA_FORMAT_RESERVED_31\0" /* 10111 */
	"IMG_DATA_FORMAT_GB_GR\0" /* 10139 */
	"IMG_DATA_FORMAT_BG_RG\0" /* 10161 */
	"IMG_DATA_FORMAT_5_9_9_9\0" /* 10183 */
	"IMG_DATA_FORMAT_BC1\0" /* 10207 */
	"IMG_DATA_FORMAT_BC2\0" /* 10227 */
	"IMG_DATA_FORMAT_BC3\0" /* 10247 */
	"IMG_DATA_FORMAT_BC4\0" /* 10267 */
	"IMG_DATA_FORMAT_BC5\0" /* 10287 */
	"IMG_DATA_FORMAT_BC6\0" /* 10307 */
	"IMG_DATA_FORMAT_BC7\0" /* 10327 */
	"IMG_DATA_FORMAT_16_AS_16_16_16_16\0" /* 10347 */
	"IMG_DATA_FORMAT_16_AS_32_32_32_32\0" /* 10381 */
	"IMG_DATA_FORMAT_FMASK8_S2_F1\0" /* 10415 */
	"IMG_DATA_FORMAT_FMASK8_S4_F1\0" /* 10444 */
	"IMG_DATA_FORMAT_FMASK8_S8_F1\0" /* 10473 */
	"IMG_DATA_FORMAT_FMASK8_S2_F2\0" /* 10502 */
	"IMG_DATA_FORMAT_FMASK8_S4_F2\0" /* 10531 */
	"IMG_DATA_FORMAT_FMASK8_S4_F4\0" /* 10560 */
	"IMG_DATA_FORMAT_FMASK16_S16_F1\0" /* 10589 */
	"IMG_DATA_FORMAT_FMASK16_S8_F2\0" /* 10620 */
	"IMG_DATA_FORMAT_FMASK32_S16_F2\0" /* 10650 */
	"IMG_DATA_FORMAT_FMASK32_S8_F4\0" /* 10681 */
	"IMG_DATA_FORMAT_FMASK32_S8_F8\0" /* 10711 */
	"IMG_DATA_FORMAT_FMASK64_S16_F4\0" /* 10741 */
	"IMG_DATA_FORMAT_FMASK64_S16_F8\0" /* 10772 */
	"IMG_DATA_FORMAT_4_4\0" /* 10803 */
	"IMG_DATA_FORMAT_6_5_5\0" /* 10823 */
	"IMG_DATA_FORMAT_1\0" /* 10845 */
	"IMG_DATA_FORMAT_1_REVERSED\0" /* 10863 */
	"IMG_DATA_FORMAT_32_AS_8\0" /* 10890 */
	"IMG_DATA_FORMAT_32_AS_8_8\0" /* 10914 */
	"IMG_DATA_FORMAT_32_AS_32_32_32_32\0" /* 10940 */
	"IMG_NUM_FORMAT_UNORM\0" /* 10974 */
	"IMG_NUM_FORMAT_SNORM\0" /* 10995 */
	"IMG_NUM_FORMAT_USCALED\0" /* 11016 */
	"IMG_NUM_FORMAT_SSCALED\0" /* 11039 */
	"IMG_NUM_FORMAT_UINT\0" /* 11062 */
	"IMG_NUM_FORMAT_SINT\0" /* 11082 */
	"IMG_NUM_FORMAT_SNORM_OGL\0" /* 11102 */
	"IMG_NUM_FORMAT_FLOAT\0" /* 11127 */
	"IMG_NUM_FORMAT_RESERVED_8\0" /* 11148 */
	"IMG_NUM_FORMAT_SRGB\0" /* 11174 */
	"IMG_NUM_FORMAT_UBNORM\0" /* 11194 */
	"IMG_NUM_FORMAT_UBNORM_OGL\0" /* 11216 */
	"IMG_NUM_FORMAT_UBINT\0" /* 11242 */
	"IMG_NUM_FORMAT_UBSCALED\0" /* 11263 */
	"IMG_NUM_FORMAT_RESERVED_14\0" /* 11287 */
	"IMG_NUM_FORMAT_RESERVED_15\0" /* 11314 */
	"WIDTH\0" /* 11341 */
	"HEIGHT\0" /* 11347 */
	"PERF_MOD\0" /* 11354 */
	"INTERLACED\0" /* 11363 */
	"BASE_LEVEL\0" /* 11374 */
	"LAST_LEVEL\0" /* 11385 */
	"TILING_INDEX\0" /* 11396 */
	"POW2_PAD\0" /* 11409 */
	"SQ_RSRC_IMG_RSVD_0\0" /* 11418 */
	"SQ_RSRC_IMG_RSVD_1\0" /* 11437 */
	"SQ_RSRC_IMG_RSVD_2\0" /* 11456 */
	"SQ_RSRC_IMG_RSVD_3\0" /* 11475 */
	"SQ_RSRC_IMG_RSVD_4\0" /* 11494 */
	"SQ_RSRC_IMG_RSVD_5\0" /* 11513 */
	"SQ_RSRC_IMG_RSVD_6\0" /* 11532 */
	"SQ_RSRC_IMG_RSVD_7\0" /* 11551 */
	"SQ_RSRC_IMG_1D\0" /* 11570 */
	"SQ_RSRC_IMG_2D\0" /* 11585 */
	"SQ_RSRC_IMG_3D\0" /* 11600 */
	"SQ_RSRC_IMG_CUBE\0" /* 11615 */
	"SQ_RSRC_IMG_1D_ARRAY\0" /* 11632 */
	"SQ_RSRC_IMG_2D_ARRAY\0" /* 11653 */
	"SQ_RSRC_IMG_2D_MSAA\0" /* 11674 */
	"SQ_RSRC_IMG_2D_MSAA_ARRAY\0" /* 11694 */
	"DEPTH\0" /* 11720 */
	"PITCH\0" /* 11726 */
	"BASE_ARRAY\0" /* 11732 */
	"LAST_ARRAY\0" /* 11743 */
	"MIN_LOD_WARN\0" /* 11754 */
	"COUNTER_BANK_ID\0" /* 11767 */
	"LOD_HDW_CNT_EN\0" /* 11783 */
	"COMPRESSION_EN\0" /* 11798 */
	"ALPHA_IS_ON_MSB\0" /* 11813 */
	"COLOR_TRANSFORM\0" /* 11829 */
	"LOST_ALPHA_BITS\0" /* 11845 */
	"LOST_COLOR_BITS\0" /* 11861 */
	"SQ_TEX_WRAP\0" /* 11877 */
	"SQ_TEX_MIRROR\0" /* 11889 */
	"SQ_TEX_CLAMP_LAST_TEXEL\0" /* 11903 */
	"SQ_TEX_MIRROR_ONCE_LAST_TEXEL\0" /* 11927 */
	"SQ_TEX_CLAMP_HALF_BORDER\0" /* 11957 */
	"SQ_TEX_MIRROR_ONCE_HALF_BORDER\0" /* 11982 */
	"SQ_TEX_CLAMP_BORDER\0" /* 12013 */
	"SQ_TEX_MIRROR_ONCE_BORDER\0" /* 12033 */
	"CLAMP_X\0" /* 12059 */
	"CLAMP_Y\0" /* 12067 */
	"CLAMP_Z\0" /* 12075 */
	"MAX_ANISO_RATIO\0" /* 12083 */
	"SQ_TEX_DEPTH_COMPARE_NEVER\0" /* 12099 */
	"SQ_TEX_DEPTH_COMPARE_LESS\0" /* 12126 */
	"SQ_TEX_DEPTH_COMPARE_EQUAL\0" /* 12152 */
	"SQ_TEX_DEPTH_COMPARE_LESSEQUAL\0" /* 12179 */
	"SQ_TEX_DEPTH_COMPARE_GREATER\0" /* 12210 */
	"SQ_TEX_DEPTH_COMPARE_NOTEQUAL\0" /* 12239 */
	"SQ_TEX_DEPTH_COMPARE_GREATEREQUAL\0" /* 12269 */
	"SQ_TEX_DEPTH_COMPARE_ALWAYS\0" /* 12303 */
	"DEPTH_COMPARE_FUNC\0" /* 12331 */
	"FORCE_UNNORMALIZED\0" /* 12350 */
	"ANISO_THRESHOLD\0" /* 12369 */
	"MC_COORD_TRUNC\0" /* 12385 */
	"FORCE_DEGAMMA\0" /* 12400 */
	"ANISO_BIAS\0" /* 12414 */
	"TRUNC_COORD\0" /* 12425 */
	"DISABLE_CUBE_WRAP\0" /* 12437 */
	"FILTER_MODE\0" /* 12462, 12455 */
	"COMPAT_MODE\0" /* 12467 */
	"MAX_LOD\0" /* 12479 */
	"PERF_MIP\0" /* 12487 */
	"PERF_Z\0" /* 12496 */
	"LOD_BIAS\0" /* 12503 */
	"LOD_BIAS_SEC\0" /* 12512 */
	"SQ_TEX_XY_FILTER_POINT\0" /* 12539, 12525 */
	"SQ_TEX_XY_FILTER_BILINEAR\0" /* 12548, 12567 */
	"XY_MAG_FILTER\0" /* 12574 */
	"SQ_TEX_XY_FILTER_ANISO_POINT\0" /* 12588 */
	"SQ_TEX_XY_FILTER_ANISO_BILINEAR\0" /* 12617 */
	"XY_MIN_FILTER\0" /* 12649 */
	"SQ_TEX_Z_FILTER_NONE\0" /* 12663 */
	"SQ_TEX_Z_FILTER_POINT\0" /* 12684 */
	"SQ_TEX_Z_FILTER_LINEAR\0" /* 12706 */
	"Z_FILTER\0" /* 12729 */
	"MIP_FILTER\0" /* 12738 */
	"MIP_POINT_PRECLAMP\0" /* 12749 */
	"DISABLE_LSB_CEIL\0" /* 12768 */
	"FILTER_PREC_FIX\0" /* 12785 */
	"ANISO_OVERRIDE\0" /* 12801 */
	"BORDER_COLOR_PTR\0" /* 12816 */
	"SQ_TEX_BORDER_COLOR_TRANS_BLACK\0" /* 12833 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_BLACK\0" /* 12865 */
	"SQ_TEX_BORDER_COLOR_OPAQUE_WHITE\0" /* 12898 */
	"SQ_TEX_BORDER_COLOR_REGISTER\0" /* 12931 */
	"BORDER_COLOR_TYPE\0" /* 12960 */
	"VS_LOW_THRESHOLD\0" /* 12978 */
	"GS_LOW_THRESHOLD\0" /* 12995 */
	"ES_LOW_THRESHOLD\0" /* 13012 */
	"HS_LOW_THRESHOLD\0" /* 13029 */
	"LS_LOW_THRESHOLD\0" /* 13046 */
	"PS_CU_EN\0" /* 13066, 13063 */
	"VS_CU_EN\0" /* 13072 */
	"GS_CU_EN\0" /* 13081 */
	"ES_CU_EN\0" /* 13090 */
	"LSHS_CU_EN\0" /* 13099 */
	"MAX_WAVE_ID\0" /* 13110 */
	"X_R0\0" /* 13122 */
	"RING_ORDER_TS0\0" /* 13127 */
	"RING_ORDER_TS1\0" /* 13142 */
	"RING_ORDER_TS2\0" /* 13157 */
	"PIPE_ORDER_TS0\0" /* 13172 */
	"PIPE_ORDER_TS1\0" /* 13187 */
	"PIPE_ORDER_TS2\0" /* 13202 */
	"PIPE_ORDER_TS3\0" /* 13217 */
	"TS0_DUR_MULT\0" /* 13232 */
	"TS1_DUR_MULT\0" /* 13245 */
	"TS2_DUR_MULT\0" /* 13258 */
	"TS3_DUR_MULT\0" /* 13271 */
	"TS0_DURATION\0" /* 13284 */
	"TS1_DURATION\0" /* 13297 */
	"TS2_DURATION\0" /* 13310 */
	"GPR_WRITE_PRIORITY\0" /* 13323, 13333 */
	"EXP_PRIORITY_ORDER\0" /* 13342 */
	"ENABLE_SQG_TOP_EVENTS\0" /* 13361 */
	"ENABLE_SQG_BOP_EVENTS\0" /* 13383 */
	"RSRC_MGMT_RESET\0" /* 13405 */
	"X_DELAY_14_CLKS\0" /* 13421 */
	"X_DELAY_16_CLKS\0" /* 13437 */
	"X_DELAY_18_CLKS\0" /* 13453 */
	"X_DELAY_20_CLKS\0" /* 13469 */
	"X_DELAY_22_CLKS\0" /* 13485 */
	"X_DELAY_24_CLKS\0" /* 13501 */
	"X_DELAY_26_CLKS\0" /* 13517 */
	"X_DELAY_28_CLKS\0" /* 13533 */
	"X_DELAY_30_CLKS\0" /* 13549 */
	"X_DELAY_32_CLKS\0" /* 13565 */
	"X_DELAY_34_CLKS\0" /* 13581 */
	"X_DELAY_4_CLKS\0" /* 13597 */
	"X_DELAY_6_CLKS\0" /* 13612 */
	"X_DELAY_8_CLKS\0" /* 13627 */
	"X_DELAY_10_CLKS\0" /* 13642 */
	"X_DELAY_12_CLKS\0" /* 13658 */
	"VTX_DONE_DELAY\0" /* 13674 */
	"INTERP_ONE_PRIM_PER_ROW\0" /* 13689 */
	"PC_LIMIT_ENABLE\0" /* 13713 */
	"PC_LIMIT_STRICT\0" /* 13729 */
	"PC_LIMIT_SIZE\0" /* 13745 */
	"TYPE_A\0" /* 13759 */
	"VGPR_A\0" /* 13766 */
	"SGPR_A\0" /* 13773 */
	"LDS_A\0" /* 13780 */
	"WAVES_A\0" /* 13786 */
	"EN_A\0" /* 13794 */
	"TYPE_B\0" /* 13799 */
	"VGPR_B\0" /* 13806 */
	"SGPR_B\0" /* 13813 */
	"LDS_B\0" /* 13820 */
	"WAVES_B\0" /* 13826 */
	"EN_B\0" /* 13834 */
	"MSAA1_X\0" /* 13839 */
	"MSAA1_Y\0" /* 13847 */
	"MSAA2_X\0" /* 13855 */
	"MSAA2_Y\0" /* 13863 */
	"MSAA4_X\0" /* 13871 */
	"MSAA4_Y\0" /* 13879 */
	"MSAA8_X\0" /* 13887 */
	"MSAA8_Y\0" /* 13895 */
	"MSAA16_X\0" /* 13903 */
	"MSAA16_Y\0" /* 13912 */
	"NUM_PIPES\0" /* 13921 */
	"PIPE_INTERLEAVE_SIZE\0" /* 13931 */
	"BANK_INTERLEAVE_SIZE\0" /* 13952 */
	"NUM_SHADER_ENGINES\0" /* 13973 */
	"SHADER_ENGINE_TILE_SIZE\0" /* 13992 */
	"NUM_GPUS\0" /* 14016 */
	"MULTI_GPU_TILE_SIZE\0" /* 14025 */
	"ROW_SIZE\0" /* 14045 */
	"NUM_LOWER_PIPES\0" /* 14054 */
	"ADDR_SURF_DISPLAY_MICRO_TILING\0" /* 14070 */
	"ADDR_SURF_THIN_MICRO_TILING\0" /* 14101 */
	"ADDR_SURF_DEPTH_MICRO_TILING\0" /* 14129 */
	"ADDR_SURF_THICK_MICRO_TILING\0" /* 14158 */
	"MICRO_TILE_MODE\0" /* 14187 */
	"ARRAY_LINEAR_GENERAL\0" /* 14209, 14203 */
	"ARRAY_LINEAR_ALIGNED\0" /* 14224 */
	"ARRAY_1D_TILED_THIN1\0" /* 14245 */
	"ARRAY_1D_TILED_THICK\0" /* 14266 */
	"ARRAY_2D_TILED_THIN1\0" /* 14287 */
	"ARRAY_2D_TILED_THICK\0" /* 14308 */
	"ARRAY_2D_TILED_XTHICK\0" /* 14329 */
	"ARRAY_3D_TILED_THIN1\0" /* 14351 */
	"ARRAY_3D_TILED_THICK\0" /* 14372 */
	"ARRAY_3D_TILED_XTHICK\0" /* 14393 */
	"ARRAY_POWER_SAVE\0" /* 14415 */
	"ARRAY_MODE\0" /* 14432 */
	"ADDR_SURF_P2\0" /* 14443 */
	"ADDR_SURF_P2_RESERVED0\0" /* 14456 */
	"ADDR_SURF_P2_RESERVED1\0" /* 14479 */
	"ADDR_SURF_P2_RESERVED2\0" /* 14515, 14502 */
	"X_ADDR_SURF_P4_8X16\0" /* 14525 */
	"X_ADDR_SURF_P4_16X16\0" /* 14545 */
	"X_ADDR_SURF_P4_16X32\0" /* 14566 */
	"X_ADDR_SURF_P4_32X32\0" /* 14587 */
	"X_ADDR_SURF_P8_16X16_8X16\0" /* 14608 */
	"X_ADDR_SURF_P8_16X32_8X16\0" /* 14634 */
	"X_ADDR_SURF_P8_32X32_8X16\0" /* 14660 */
	"X_ADDR_SURF_P8_16X32_16X16\0" /* 14686 */
	"X_ADDR_SURF_P8_32X32_16X16\0" /* 14713 */
	"X_ADDR_SURF_P8_32X32_16X32\0" /* 14740 */
	"X_ADDR_SURF_P8_32X64_32X32\0" /* 14767 */
	"PIPE_CONFIG\0" /* 14794 */
	"ADDR_SURF_TILE_SPLIT_64B\0" /* 14806 */
	"ADDR_SURF_TILE_SPLIT_128B\0" /* 14831 */
	"ADDR_SURF_TILE_SPLIT_256B\0" /* 14857 */
	"ADDR_SURF_TILE_SPLIT_512B\0" /* 14883 */
	"ADDR_SURF_TILE_SPLIT_1KB\0" /* 14909 */
	"ADDR_SURF_TILE_SPLIT_2KB\0" /* 14934 */
	"ADDR_SURF_TILE_SPLIT_4KB\0" /* 14959 */
	"TILE_SPLIT\0" /* 14984 */
	"ADDR_SURF_BANK_WIDTH_1\0" /* 14995 */
	"ADDR_SURF_BANK_WIDTH_2\0" /* 15018 */
	"ADDR_SURF_BANK_WIDTH_4\0" /* 15041 */
	"ADDR_SURF_BANK_WIDTH_8\0" /* 15064 */
	"BANK_WIDTH\0" /* 15087 */
	"ADDR_SURF_BANK_HEIGHT_1\0" /* 15098 */
	"ADDR_SURF_BANK_HEIGHT_2\0" /* 15122 */
	"ADDR_SURF_BANK_HEIGHT_4\0" /* 15146 */
	"ADDR_SURF_BANK_HEIGHT_8\0" /* 15170 */
	"BANK_HEIGHT\0" /* 15194 */
	"ADDR_SURF_MACRO_ASPECT_1\0" /* 15206 */
	"ADDR_SURF_MACRO_ASPECT_2\0" /* 15231 */
	"ADDR_SURF_MACRO_ASPECT_4\0" /* 15256 */
	"ADDR_SURF_MACRO_ASPECT_8\0" /* 15281 */
	"MACRO_TILE_ASPECT\0" /* 15306 */
	"ADDR_SURF_2_BANK\0" /* 15324 */
	"ADDR_SURF_4_BANK\0" /* 15341 */
	"ADDR_SURF_8_BANK\0" /* 15358 */
	"ADDR_SURF_16_BANK\0" /* 15375 */
	"NUM_BANKS\0" /* 15393 */
	"ADDR_SURF_ROTATED_MICRO_TILING\0" /* 15403 */
	"MICRO_TILE_MODE_NEW\0" /* 15434 */
	"SAMPLE_SPLIT\0" /* 15454 */
	"MEM_BASE\0" /* 15467 */
	"WAVE_LIMIT\0" /* 15476 */
	"LOCK_LOW_THRESHOLD\0" /* 15487 */
	"VGPRS\0" /* 15506 */
	"SGPRS\0" /* 15512 */
	"FP_32_DENORMS\0" /* 15518 */
	"FP_64_DENORMS\0" /* 15532 */
	"FP_ALL_DENORMS\0" /* 15546 */
	"FLOAT_MODE\0" /* 15561 */
	"PRIV\0" /* 15572 */
	"DX10_CLAMP\0" /* 15577 */
	"DEBUG_MODE\0" /* 15588 */
	"IEEE_MODE\0" /* 15599 */
	"CU_GROUP_DISABLE\0" /* 15609 */
	"CACHE_CTL\0" /* 15626 */
	"CDBG_USER\0" /* 15636 */
	"SCRATCH_EN\0" /* 15646 */
	"USER_SGPR\0" /* 15657 */
	"TRAP_PRESENT\0" /* 15667 */
	"WAVE_CNT_EN\0" /* 15680 */
	"EXTRA_LDS_SIZE\0" /* 15698, 15692 */
	"EXCP_EN\0" /* 15707 */
	"EXCP_EN_CIK\0" /* 15715 */
	"VGPR_COMP_CNT\0" /* 15737, 15727 */
	"CU_GROUP_ENABLE\0" /* 15741 */
	"OC_LDS_EN\0" /* 15757 */
	"SO_BASE0_EN\0" /* 15767 */
	"SO_BASE1_EN\0" /* 15779 */
	"SO_BASE2_EN\0" /* 15791 */
	"SO_BASE3_EN\0" /* 15803 */
	"SO_EN\0" /* 15815 */
	"DISPATCH_DRAW_EN\0" /* 15821 */
	"GROUP_FIFO_DEPTH\0" /* 15838 */
	"TG_SIZE_EN\0" /* 15855 */
	"COMPUTE_SHADER_EN\0" /* 15866 */
	"PARTIAL_TG_EN\0" /* 15884 */
	"FORCE_START_AT_000\0" /* 15898 */
	"ORDERED_APPEND_ENBL\0" /* 15917 */
	"ORDERED_APPEND_MODE\0" /* 15937 */
	"USE_THREAD_DIMENSIONS\0" /* 15957 */
	"ORDER_MODE\0" /* 15979 */
	"DISPATCH_CACHE_CNTL\0" /* 15990 */
	"SCALAR_L1_INV_VOL\0" /* 16010 */
	"VECTOR_L1_INV_VOL\0" /* 16028 */
	"DATA_ATC\0" /* 16046 */
	"RESTORE\0" /* 16055 */
	"NUM_THREAD_FULL\0" /* 16063 */
	"NUM_THREAD_PARTIAL\0" /* 16079 */
	"PIPELINESTAT_ENABLE\0" /* 16098 */
	"PERFCOUNT_ENABLE\0" /* 16118 */
	"INST_ATC\0" /* 16135 */
	"BULKY\0" /* 16144 */
	"TGID_X_EN\0" /* 16150 */
	"TGID_Y_EN\0" /* 16160 */
	"TGID_Z_EN\0" /* 16170 */
	"TIDIG_COMP_CNT\0" /* 16180 */
	"EXCP_EN_MSB\0" /* 16195 */
	"WAVES_PER_SH\0" /* 16207 */
	"WAVES_PER_SH_CIK\0" /* 16220 */
	"TG_PER_CU\0" /* 16237 */
	"LOCK_THRESHOLD\0" /* 16247 */
	"SIMD_DEST_CNTL\0" /* 16262 */
	"FORCE_SIMD_DIST\0" /* 16277 */
	"CU_GROUP_COUNT\0" /* 16293 */
	"SH0_CU_EN\0" /* 16308 */
	"SH1_CU_EN\0" /* 16318 */
	"WAVES\0" /* 16328 */
	"WAVESIZE\0" /* 16334 */
	"SEND_SEID\0" /* 16343 */
	"RESERVED3\0" /* 16353 */
	"RESERVED4\0" /* 16363 */
	"WAVE_ID_BASE\0" /* 16373 */
	"PAYLOAD\0" /* 16386 */
	"IS_EVENT\0" /* 16394 */
	"IS_STATE\0" /* 16403 */
	"PERFCOUNTER_HI\0" /* 16412 */
	"PERF_SEL2\0" /* 16427 */
	"PERF_SEL3\0" /* 16437 */
	"PERF_SEL\0" /* 16447 */
	"PERF_SEL1\0" /* 16456 */
	"CNTR_MODE\0" /* 16466 */
	"DISABLE_AND_RESET\0" /* 16476 */
	"START_COUNTING\0" /* 16494 */
	"STOP_COUNTING\0" /* 16509 */
	"PERFMON_STATE\0" /* 16523 */
	"SPM_PERFMON_STATE\0" /* 16537 */
	"PERFMON_ENABLE_MODE\0" /* 16555 */
	"PERFMON_SAMPLE_ENABLE\0" /* 16575 */
	"DB_CLEAN_USER_DEFINED_MASK\0" /* 16597 */
	"CB_CLEAN_USER_DEFINED_MASK\0" /* 16624 */
	"VGT_BUSY_USER_DEFINED_MASK\0" /* 16651 */
	"TA_BUSY_USER_DEFINED_MASK\0" /* 16678 */
	"SX_BUSY_USER_DEFINED_MASK\0" /* 16704 */
	"SPI_BUSY_USER_DEFINED_MASK\0" /* 16730 */
	"SC_BUSY_USER_DEFINED_MASK\0" /* 16757 */
	"PA_BUSY_USER_DEFINED_MASK\0" /* 16783 */
	"GRBM_BUSY_USER_DEFINED_MASK\0" /* 16809 */
	"DB_BUSY_USER_DEFINED_MASK\0" /* 16837 */
	"CB_BUSY_USER_DEFINED_MASK\0" /* 16863 */
	"CP_BUSY_USER_DEFINED_MASK\0" /* 16889 */
	"IA_BUSY_USER_DEFINED_MASK\0" /* 16915 */
	"GDS_BUSY_USER_DEFINED_MASK\0" /* 16941 */
	"BCI_BUSY_USER_DEFINED_MASK\0" /* 16968 */
	"RLC_BUSY_USER_DEFINED_MASK\0" /* 16995 */
	"TC_BUSY_USER_DEFINED_MASK\0" /* 17022 */
	"WD_BUSY_USER_DEFINED_MASK\0" /* 17048 */
	"PERF_MODE\0" /* 17074 */
	"PERF_MODE1\0" /* 17084 */
	"PERF_MODE3\0" /* 17095 */
	"PERF_MODE2\0" /* 17106 */
	"PERF_SEID_IGNORE_MASK\0" /* 17117 */
	"BIN0_MIN\0" /* 17139 */
	"BIN0_MAX\0" /* 17148 */
	"BIN1_MIN\0" /* 17157 */
	"BIN1_MAX\0" /* 17166 */
	"BIN2_MIN\0" /* 17175 */
	"BIN2_MAX\0" /* 17184 */
	"BIN3_MIN\0" /* 17193 */
	"BIN3_MAX\0" /* 17202 */
	"SQC_BANK_MASK\0" /* 17211 */
	"SQC_CLIENT_MASK\0" /* 17225 */
	"SPM_MODE\0" /* 17241 */
	"SIMD_MASK\0" /* 17250 */
	"PS_EN\0" /* 17260 */
	"VS_EN\0" /* 17266 */
	"GS_EN\0" /* 17272 */
	"ES_EN\0" /* 17278 */
	"HS_EN\0" /* 17284 */
	"LS_EN\0" /* 17290 */
	"CS_EN\0" /* 17296 */
	"CNTR_RATE\0" /* 17302 */
	"DISABLE_FLUSH\0" /* 17312 */
	"SH0_MASK\0" /* 17326 */
	"SH1_MASK\0" /* 17335 */
	"FORCE_EN\0" /* 17344 */
	"PERFCOUNTER_SELECT\0" /* 17353 */
	"PERFCOUNTER_SELECT1\0" /* 17372 */
	"PERFCOUNTER_SELECT2\0" /* 17392 */
	"PERFCOUNTER_SELECT3\0" /* 17412 */
	"OP_FILTER_ENABLE\0" /* 17432 */
	"OP_FILTER_SEL\0" /* 17449 */
	"FORMAT_FILTER_ENABLE\0" /* 17463 */
	"FORMAT_FILTER_SEL\0" /* 17484 */
	"CLEAR_FILTER_ENABLE\0" /* 17502 */
	"CLEAR_FILTER_SEL\0" /* 17522 */
	"MRT_FILTER_ENABLE\0" /* 17539 */
	"MRT_FILTER_SEL\0" /* 17557 */
	"NUM_SAMPLES_FILTER_ENABLE\0" /* 17572 */
	"NUM_SAMPLES_FILTER_SEL\0" /* 17598 */
	"NUM_FRAGMENTS_FILTER_ENABLE\0" /* 17621 */
	"NUM_FRAGMENTS_FILTER_SEL\0" /* 17649 */
	"DEPTH_CLEAR_ENABLE\0" /* 17674 */
	"STENCIL_CLEAR_ENABLE\0" /* 17693 */
	"DEPTH_COPY\0" /* 17714 */
	"STENCIL_COPY\0" /* 17725 */
	"RESUMMARIZE_ENABLE\0" /* 17738 */
	"STENCIL_COMPRESS_DISABLE\0" /* 17757 */
	"DEPTH_COMPRESS_DISABLE\0" /* 17782 */
	"COPY_CENTROID\0" /* 17805 */
	"COPY_SAMPLE\0" /* 17819 */
	"DECOMPRESS_ENABLE\0" /* 17831 */
	"ZPASS_INCREMENT_DISABLE\0" /* 17849 */
	"PERFECT_ZPASS_COUNTS\0" /* 17873 */
	"SAMPLE_RATE\0" /* 17894 */
	"ZPASS_ENABLE\0" /* 17906 */
	"ZFAIL_ENABLE\0" /* 17919 */
	"SFAIL_ENABLE\0" /* 17932 */
	"DBFAIL_ENABLE\0" /* 17945 */
	"SLICE_EVEN_ENABLE\0" /* 17959 */
	"SLICE_ODD_ENABLE\0" /* 17977 */
	"SLICE_START\0" /* 17994 */
	"SLICE_MAX\0" /* 18006 */
	"Z_READ_ONLY\0" /* 18016 */
	"STENCIL_READ_ONLY\0" /* 18028 */
	"FORCE_OFF\0" /* 18046 */
	"FORCE_ENABLE\0" /* 18056 */
	"FORCE_DISABLE\0" /* 18069 */
	"FORCE_RESERVED\0" /* 18083 */
	"FORCE_HIZ_ENABLE\0" /* 18098, 18106 */
	"FORCE_HIS_ENABLE0\0" /* 18115, 18125 */
	"FORCE_HIS_ENABLE1\0" /* 18133, 18143 */
	"FORCE_SHADER_Z_ORDER\0" /* 18164, 18151 */
	"FAST_Z_DISABLE\0" /* 18172 */
	"FAST_STENCIL_DISABLE\0" /* 18187 */
	"NOOP_CULL_DISABLE\0" /* 18208 */
	"FORCE_COLOR_KILL\0" /* 18226 */
	"FORCE_Z_READ\0" /* 18243 */
	"FORCE_STENCIL_READ\0" /* 18256 */
	"FORCE_FULL_Z_RANGE\0" /* 18275 */
	"FORCE_QC_SMASK_CONFLICT\0" /* 18294 */
	"DISABLE_VIEWPORT_CLAMP\0" /* 18318 */
	"IGNORE_SC_ZRANGE\0" /* 18341 */
	"DISABLE_FULLY_COVERED\0" /* 18358 */
	"FORCE_SUMM_OFF\0" /* 18380 */
	"FORCE_SUMM_MINZ\0" /* 18395 */
	"FORCE_SUMM_MAXZ\0" /* 18411 */
	"FORCE_SUMM_BOTH\0" /* 18427 */
	"FORCE_Z_LIMIT_SUMM\0" /* 18443 */
	"MAX_TILES_IN_DTT\0" /* 18462 */
	"DISABLE_TILE_RATE_TILES\0" /* 18479 */
	"FORCE_Z_DIRTY\0" /* 18503 */
	"FORCE_STENCIL_DIRTY\0" /* 18517 */
	"FORCE_Z_VALID\0" /* 18537 */
	"FORCE_STENCIL_VALID\0" /* 18551 */
	"PRESERVE_COMPRESSION\0" /* 18571, 18580 */
	"PSLC_AUTO\0" /* 18592 */
	"PSLC_ON_HANG_ONLY\0" /* 18602 */
	"PSLC_ASAP\0" /* 18620 */
	"PSLC_COUNTDOWN\0" /* 18630 */
	"PARTIAL_SQUAD_LAUNCH_CONTROL\0" /* 18645 */
	"PARTIAL_SQUAD_LAUNCH_COUNTDOWN\0" /* 18674 */
	"DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION\0" /* 18705 */
	"DISABLE_SMEM_EXPCLEAR_OPTIMIZATION\0" /* 18741 */
	"DISABLE_COLOR_ON_VALIDATION\0" /* 18776 */
	"DECOMPRESS_Z_ON_FLUSH\0" /* 18804 */
	"DISABLE_REG_SNOOP\0" /* 18826 */
	"DEPTH_BOUNDS_HIER_DEPTH_DISABLE\0" /* 18844 */
	"SEPARATE_HIZS_FUNC_ENABLE\0" /* 18876 */
	"HIZ_ZFUNC\0" /* 18906, 18902 */
	"HIS_SFUNC_FF\0" /* 18912 */
	"HIS_SFUNC_BF\0" /* 18925 */
	"PRESERVE_ZRANGE\0" /* 18938 */
	"PRESERVE_SRESULTS\0" /* 18954 */
	"DISABLE_FAST_PASS\0" /* 18972 */
	"CLEAR\0" /* 18990 */
	"TL_X\0" /* 18996 */
	"TL_Y\0" /* 19001 */
	"BR_X\0" /* 19006 */
	"BR_Y\0" /* 19011 */
	"ADDR5_SWIZZLE_MASK\0" /* 19016 */
	"ARRAY_PRT_TILED_THIN1\0" /* 19035 */
	"ARRAY_PRT_2D_TILED_THIN1\0" /* 19057 */
	"X_ADDR_SURF_P16_32X32_8X16\0" /* 19082 */
	"X_ADDR_SURF_P16_32X32_16X16\0" /* 19109 */
	"Z_INVALID\0" /* 19137 */
	"Z_16\0" /* 19147 */
	"Z_24\0" /* 19152 */
	"Z_32_FLOAT\0" /* 19157 */
	"NUM_SAMPLES\0" /* 19168 */
	"TILE_MODE_INDEX\0" /* 19180 */
	"DECOMPRESS_ON_N_ZPLANES\0" /* 19196 */
	"ALLOW_EXPCLEAR\0" /* 19220 */
	"READ_SIZE\0" /* 19235 */
	"TILE_SURFACE_ENABLE\0" /* 19245 */
	"CLEAR_DISALLOWED\0" /* 19265 */
	"ZRANGE_PRECISION\0" /* 19282 */
	"STENCIL_INVALID\0" /* 19299 */
	"STENCIL_8\0" /* 19315 */
	"TILE_STENCIL_DISABLE\0" /* 19325 */
	"PITCH_TILE_MAX\0" /* 19352, 19346 */
	"HEIGHT_TILE_MAX\0" /* 19361 */
	"SLICE_TILE_MAX\0" /* 19377 */
	"WINDOW_X_OFFSET\0" /* 19392, 19399 */
	"WINDOW_Y_OFFSET\0" /* 19408, 19415 */
	"WINDOW_OFFSET_DISABLE\0" /* 19424 */
	"CLIP_RULE\0" /* 19446 */
	"ER_TRI\0" /* 19456 */
	"ER_RECT\0" /* 19463 */
	"ER_LINE_LR\0" /* 19471 */
	"ER_LINE_RL\0" /* 19482 */
	"ER_LINE_TB\0" /* 19493 */
	"ER_LINE_BT\0" /* 19504 */
	"HW_SCREEN_OFFSET_X\0" /* 19515 */
	"HW_SCREEN_OFFSET_Y\0" /* 19534 */
	"TARGET0_ENABLE\0" /* 19553 */
	"TARGET1_ENABLE\0" /* 19568 */
	"TARGET2_ENABLE\0" /* 19583 */
	"TARGET3_ENABLE\0" /* 19598 */
	"TARGET4_ENABLE\0" /* 19613 */
	"TARGET5_ENABLE\0" /* 19628 */
	"TARGET6_ENABLE\0" /* 19643 */
	"TARGET7_ENABLE\0" /* 19658 */
	"OUTPUT0_ENABLE\0" /* 19673 */
	"OUTPUT1_ENABLE\0" /* 19688 */
	"OUTPUT2_ENABLE\0" /* 19703 */
	"OUTPUT3_ENABLE\0" /* 19718 */
	"OUTPUT4_ENABLE\0" /* 19733 */
	"OUTPUT5_ENABLE\0" /* 19748 */
	"OUTPUT6_ENABLE\0" /* 19763 */
	"OUTPUT7_ENABLE\0" /* 19778 */
	"RASTER_CONFIG_RB_MAP_0\0" /* 19793 */
	"RASTER_CONFIG_RB_MAP_1\0" /* 19816 */
	"RASTER_CONFIG_RB_MAP_2\0" /* 19839 */
	"RASTER_CONFIG_RB_MAP_3\0" /* 19862 */
	"RB_MAP_PKR0\0" /* 19885 */
	"RB_MAP_PKR1\0" /* 19897 */
	"RASTER_CONFIG_RB_XSEL2_0\0" /* 19909 */
	"RASTER_CONFIG_RB_XSEL2_1\0" /* 19934 */
	"RASTER_CONFIG_RB_XSEL2_2\0" /* 19959 */
	"RASTER_CONFIG_RB_XSEL2_3\0" /* 19984 */
	"RB_XSEL2\0" /* 20009 */
	"RB_XSEL\0" /* 20018 */
	"RB_YSEL\0" /* 20026 */
	"RASTER_CONFIG_PKR_MAP_0\0" /* 20034 */
	"RASTER_CONFIG_PKR_MAP_1\0" /* 20058 */
	"RASTER_CONFIG_PKR_MAP_2\0" /* 20082 */
	"RASTER_CONFIG_PKR_MAP_3\0" /* 20106 */
	"PKR_MAP\0" /* 20130 */
	"RASTER_CONFIG_PKR_XSEL_0\0" /* 20138 */
	"RASTER_CONFIG_PKR_XSEL_1\0" /* 20163 */
	"RASTER_CONFIG_PKR_XSEL_2\0" /* 20188 */
	"RASTER_CONFIG_PKR_XSEL_3\0" /* 20213 */
	"PKR_XSEL\0" /* 20238 */
	"RASTER_CONFIG_PKR_YSEL_0\0" /* 20247 */
	"RASTER_CONFIG_PKR_YSEL_1\0" /* 20272 */
	"RASTER_CONFIG_PKR_YSEL_2\0" /* 20297 */
	"RASTER_CONFIG_PKR_YSEL_3\0" /* 20322 */
	"PKR_YSEL\0" /* 20347 */
	"RASTER_CONFIG_PKR_XSEL2_0\0" /* 20356 */
	"RASTER_CONFIG_PKR_XSEL2_1\0" /* 20382 */
	"RASTER_CONFIG_PKR_XSEL2_2\0" /* 20408 */
	"RASTER_CONFIG_PKR_XSEL2_3\0" /* 20434 */
	"PKR_XSEL2\0" /* 20460 */
	"RASTER_CONFIG_SC_MAP_0\0" /* 20470 */
	"RASTER_CONFIG_SC_MAP_1\0" /* 20493 */
	"RASTER_CONFIG_SC_MAP_2\0" /* 20516 */
	"RASTER_CONFIG_SC_MAP_3\0" /* 20539 */
	"SC_MAP\0" /* 20562 */
	"RASTER_CONFIG_SC_XSEL_8_WIDE_TILE\0" /* 20569 */
	"RASTER_CONFIG_SC_XSEL_16_WIDE_TILE\0" /* 20603 */
	"RASTER_CONFIG_SC_XSEL_32_WIDE_TILE\0" /* 20638 */
	"RASTER_CONFIG_SC_XSEL_64_WIDE_TILE\0" /* 20673 */
	"SC_XSEL\0" /* 20708 */
	"RASTER_CONFIG_SC_YSEL_8_WIDE_TILE\0" /* 20716 */
	"RASTER_CONFIG_SC_YSEL_16_WIDE_TILE\0" /* 20750 */
	"RASTER_CONFIG_SC_YSEL_32_WIDE_TILE\0" /* 20785 */
	"RASTER_CONFIG_SC_YSEL_64_WIDE_TILE\0" /* 20820 */
	"SC_YSEL\0" /* 20855 */
	"RASTER_CONFIG_SE_MAP_0\0" /* 20863 */
	"RASTER_CONFIG_SE_MAP_1\0" /* 20886 */
	"RASTER_CONFIG_SE_MAP_2\0" /* 20909 */
	"RASTER_CONFIG_SE_MAP_3\0" /* 20932 */
	"SE_MAP\0" /* 20955 */
	"RASTER_CONFIG_SE_XSEL_8_WIDE_TILE\0" /* 20962 */
	"RASTER_CONFIG_SE_XSEL_16_WIDE_TILE\0" /* 20996 */
	"RASTER_CONFIG_SE_XSEL_32_WIDE_TILE\0" /* 21031 */
	"RASTER_CONFIG_SE_XSEL_64_WIDE_TILE\0" /* 21066 */
	"SE_XSEL\0" /* 21101 */
	"RASTER_CONFIG_SE_YSEL_8_WIDE_TILE\0" /* 21109 */
	"RASTER_CONFIG_SE_YSEL_16_WIDE_TILE\0" /* 21143 */
	"RASTER_CONFIG_SE_YSEL_32_WIDE_TILE\0" /* 21178 */
	"RASTER_CONFIG_SE_YSEL_64_WIDE_TILE\0" /* 21213 */
	"SE_YSEL\0" /* 21248 */
	"RASTER_CONFIG_SE_PAIR_MAP_0\0" /* 21256 */
	"RASTER_CONFIG_SE_PAIR_MAP_1\0" /* 21284 */
	"RASTER_CONFIG_SE_PAIR_MAP_2\0" /* 21312 */
	"RASTER_CONFIG_SE_PAIR_MAP_3\0" /* 21340 */
	"SE_PAIR_MAP\0" /* 21368 */
	"RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE\0" /* 21380 */
	"RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE\0" /* 21419 */
	"RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE\0" /* 21459 */
	"RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE\0" /* 21499 */
	"SE_PAIR_XSEL\0" /* 21539 */
	"RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE\0" /* 21552 */
	"RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE\0" /* 21591 */
	"RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE\0" /* 21631 */
	"RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE\0" /* 21671 */
	"SE_PAIR_YSEL\0" /* 21711 */
	"OVERWRITE_COMBINER_DISABLE\0" /* 21724 */
	"OVERWRITE_COMBINER_MRT_SHARING_DISABLE\0" /* 21751 */
	"OVERWRITE_COMBINER_WATERMARK\0" /* 21790 */
	"STENCIL_KEEP\0" /* 21819 */
	"STENCIL_ZERO\0" /* 21832 */
	"STENCIL_ONES\0" /* 21845 */
	"STENCIL_REPLACE_TEST\0" /* 21858 */
	"STENCIL_REPLACE_OP\0" /* 21879 */
	"STENCIL_ADD_CLAMP\0" /* 21898 */
	"STENCIL_SUB_CLAMP\0" /* 21916 */
	"STENCIL_INVERT\0" /* 21934 */
	"STENCIL_ADD_WRAP\0" /* 21949 */
	"STENCIL_SUB_WRAP\0" /* 21966 */
	"STENCIL_AND\0" /* 21983 */
	"STENCIL_OR\0" /* 21995 */
	"STENCIL_XOR\0" /* 22006 */
	"STENCIL_NAND\0" /* 22018 */
	"STENCIL_NOR\0" /* 22031 */
	"STENCIL_XNOR\0" /* 22043 */
	"STENCILFAIL\0" /* 22056 */
	"STENCILZPASS\0" /* 22068 */
	"STENCILZFAIL\0" /* 22081 */
	"STENCILFAIL_BF\0" /* 22094 */
	"STENCILZPASS_BF\0" /* 22109 */
	"STENCILZFAIL_BF\0" /* 22125 */
	"STENCILTESTVAL\0" /* 22141 */
	"STENCILMASK\0" /* 22156 */
	"STENCILWRITEMASK\0" /* 22168 */
	"STENCILOPVAL\0" /* 22185 */
	"STENCILTESTVAL_BF\0" /* 22198 */
	"STENCILMASK_BF\0" /* 22216 */
	"STENCILWRITEMASK_BF\0" /* 22231 */
	"STENCILOPVAL_BF\0" /* 22251 */
	"X_0_0F\0" /* 22267 */
	"DEFAULT_VAL\0" /* 22274 */
	"FLAT_SHADE\0" /* 22286 */
	"CYL_WRAP\0" /* 22297 */
	"PT_SPRITE_TEX\0" /* 22306 */
	"DUP\0" /* 22320 */
	"FP16_INTERP_MODE\0" /* 22324 */
	"USE_DEFAULT_ATTR1\0" /* 22341 */
	"DEFAULT_VAL_ATTR1\0" /* 22359 */
	"PT_SPRITE_TEX_ATTR1\0" /* 22377 */
	"ATTR0_VALID\0" /* 22397 */
	"ATTR1_VALID\0" /* 22409 */
	"VS_EXPORT_COUNT\0" /* 22421 */
	"VS_HALF_PACK\0" /* 22437 */
	"VS_EXPORTS_FOG\0" /* 22450 */
	"VS_OUT_FOG_VEC_ADDR\0" /* 22465 */
	"PERSP_SAMPLE_ENA\0" /* 22485 */
	"PERSP_CENTER_ENA\0" /* 22502 */
	"PERSP_CENTROID_ENA\0" /* 22519 */
	"PERSP_PULL_MODEL_ENA\0" /* 22538 */
	"LINEAR_SAMPLE_ENA\0" /* 22559 */
	"LINEAR_CENTER_ENA\0" /* 22577 */
	"LINEAR_CENTROID_ENA\0" /* 22595 */
	"LINE_STIPPLE_TEX_ENA\0" /* 22615 */
	"POS_X_FLOAT_ENA\0" /* 22636 */
	"POS_Y_FLOAT_ENA\0" /* 22652 */
	"POS_Z_FLOAT_ENA\0" /* 22668 */
	"POS_W_FLOAT_ENA\0" /* 22684 */
	"FRONT_FACE_ENA\0" /* 22700 */
	"ANCILLARY_ENA\0" /* 22715 */
	"SAMPLE_COVERAGE_ENA\0" /* 22729 */
	"POS_FIXED_PT_ENA\0" /* 22749 */
	"FLAT_SHADE_ENA\0" /* 22766 */
	"PNT_SPRITE_ENA\0" /* 22781 */
	"SPI_PNT_SPRITE_SEL_0\0" /* 22796 */
	"SPI_PNT_SPRITE_SEL_1\0" /* 22817 */
	"SPI_PNT_SPRITE_SEL_S\0" /* 22838 */
	"SPI_PNT_SPRITE_SEL_T\0" /* 22859 */
	"SPI_PNT_SPRITE_SEL_NONE\0" /* 22880 */
	"PNT_SPRITE_OVRD_X\0" /* 22904 */
	"PNT_SPRITE_OVRD_Y\0" /* 22922 */
	"PNT_SPRITE_OVRD_Z\0" /* 22940 */
	"PNT_SPRITE_OVRD_W\0" /* 22958 */
	"PNT_SPRITE_TOP_1\0" /* 22976 */
	"NUM_INTERP\0" /* 22993 */
	"PARAM_GEN\0" /* 23004 */
	"FOG_ADDR\0" /* 23014 */
	"BC_OPTIMIZE_DISABLE\0" /* 23023 */
	"PASS_FOG_THROUGH_PS\0" /* 23043 */
	"PERSP_CENTER_CNTL\0" /* 23063 */
	"PERSP_CENTROID_CNTL\0" /* 23081 */
	"LINEAR_CENTER_CNTL\0" /* 23101 */
	"LINEAR_CENTROID_CNTL\0" /* 23120 */
	"X_CALCULATE_PER_PIXEL_FLOATING_POINT_POSITION_AT\0" /* 23141 */
	"POS_FLOAT_LOCATION\0" /* 23190 */
	"POS_FLOAT_ULC\0" /* 23209 */
	"FRONT_FACE_ALL_BITS\0" /* 23223 */
	"NUM_PS_WAVES\0" /* 23243 */
	"NUM_VS_WAVES\0" /* 23256 */
	"NUM_GS_WAVES\0" /* 23269 */
	"NUM_ES_WAVES\0" /* 23282 */
	"NUM_HS_WAVES\0" /* 23295 */
	"NUM_LS_WAVES\0" /* 23308 */
	"SPI_SHADER_NONE\0" /* 23321 */
	"SPI_SHADER_1COMP\0" /* 23337 */
	"SPI_SHADER_2COMP\0" /* 23354 */
	"SPI_SHADER_4COMPRESS\0" /* 23371 */
	"SPI_SHADER_4COMP\0" /* 23392 */
	"POS0_EXPORT_FORMAT\0" /* 23409 */
	"POS1_EXPORT_FORMAT\0" /* 23428 */
	"POS2_EXPORT_FORMAT\0" /* 23447 */
	"POS3_EXPORT_FORMAT\0" /* 23466 */
	"SPI_SHADER_ZERO\0" /* 23485 */
	"SPI_SHADER_32_R\0" /* 23501 */
	"SPI_SHADER_32_GR\0" /* 23517 */
	"SPI_SHADER_32_AR\0" /* 23534 */
	"SPI_SHADER_FP16_ABGR\0" /* 23551 */
	"SPI_SHADER_UNORM16_ABGR\0" /* 23572 */
	"SPI_SHADER_SNORM16_ABGR\0" /* 23596 */
	"SPI_SHADER_UINT16_ABGR\0" /* 23620 */
	"SPI_SHADER_SINT16_ABGR\0" /* 23643 */
	"SPI_SHADER_32_ABGR\0" /* 23666 */
	"Z_EXPORT_FORMAT\0" /* 23685 */
	"COL0_EXPORT_FORMAT\0" /* 23701 */
	"COL1_EXPORT_FORMAT\0" /* 23720 */
	"COL2_EXPORT_FORMAT\0" /* 23739 */
	"COL3_EXPORT_FORMAT\0" /* 23758 */
	"COL4_EXPORT_FORMAT\0" /* 23777 */
	"COL5_EXPORT_FORMAT\0" /* 23796 */
	"COL6_EXPORT_FORMAT\0" /* 23815 */
	"COL7_EXPORT_FORMAT\0" /* 23834 */
	"SX_RT_EXPORT_NO_CONVERSION\0" /* 23853 */
	"SX_RT_EXPORT_32_R\0" /* 23880 */
	"SX_RT_EXPORT_32_A\0" /* 23898 */
	"SX_RT_EXPORT_10_11_11\0" /* 23916 */
	"SX_RT_EXPORT_2_10_10_10\0" /* 23938 */
	"SX_RT_EXPORT_8_8_8_8\0" /* 23962 */
	"SX_RT_EXPORT_5_6_5\0" /* 23983 */
	"SX_RT_EXPORT_1_5_5_5\0" /* 24002 */
	"SX_RT_EXPORT_4_4_4_4\0" /* 24023 */
	"SX_RT_EXPORT_16_16_GR\0" /* 24044 */
	"SX_RT_EXPORT_16_16_AR\0" /* 24066 */
	"MRT0\0" /* 24088 */
	"MRT1\0" /* 24093 */
	"MRT2\0" /* 24098 */
	"MRT3\0" /* 24103 */
	"MRT4\0" /* 24108 */
	"MRT5\0" /* 24113 */
	"MRT6\0" /* 24118 */
	"MRT7\0" /* 24123 */
	"EXACT\0" /* 24128 */
	"11BIT_FORMAT\0" /* 24134 */
	"10BIT_FORMAT\0" /* 24147 */
	"8BIT_FORMAT\0" /* 24160 */
	"6BIT_FORMAT\0" /* 24172 */
	"5BIT_FORMAT\0" /* 24184 */
	"4BIT_FORMAT\0" /* 24196 */
	"MRT0_EPSILON\0" /* 24208 */
	"MRT1_EPSILON\0" /* 24221 */
	"MRT2_EPSILON\0" /* 24234 */
	"MRT3_EPSILON\0" /* 24247 */
	"MRT4_EPSILON\0" /* 24260 */
	"MRT5_EPSILON\0" /* 24273 */
	"MRT6_EPSILON\0" /* 24286 */
	"MRT7_EPSILON\0" /* 24299 */
	"MRT0_COLOR_OPT_DISABLE\0" /* 24312 */
	"MRT0_ALPHA_OPT_DISABLE\0" /* 24335 */
	"MRT1_COLOR_OPT_DISABLE\0" /* 24358 */
	"MRT1_ALPHA_OPT_DISABLE\0" /* 24381 */
	"MRT2_COLOR_OPT_DISABLE\0" /* 24404 */
	"MRT2_ALPHA_OPT_DISABLE\0" /* 24427 */
	"MRT3_COLOR_OPT_DISABLE\0" /* 24450 */
	"MRT3_ALPHA_OPT_DISABLE\0" /* 24473 */
	"MRT4_COLOR_OPT_DISABLE\0" /* 24496 */
	"MRT4_ALPHA_OPT_DISABLE\0" /* 24519 */
	"MRT5_COLOR_OPT_DISABLE\0" /* 24542 */
	"MRT5_ALPHA_OPT_DISABLE\0" /* 24565 */
	"MRT6_COLOR_OPT_DISABLE\0" /* 24588 */
	"MRT6_ALPHA_OPT_DISABLE\0" /* 24611 */
	"MRT7_COLOR_OPT_DISABLE\0" /* 24634 */
	"MRT7_ALPHA_OPT_DISABLE\0" /* 24657 */
	"PIXEN_ZERO_OPT_DISABLE\0" /* 24680 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_ALL\0" /* 24703 */
	"BLEND_OPT_PRESERVE_ALL_IGNORE_NONE\0" /* 24738 */
	"BLEND_OPT_PRESERVE_C1_IGNORE_C0\0" /* 24773 */
	"BLEND_OPT_PRESERVE_C0_IGNORE_C1\0" /* 24805 */
	"BLEND_OPT_PRESERVE_A1_IGNORE_A0\0" /* 24837 */
	"BLEND_OPT_PRESERVE_A0_IGNORE_A1\0" /* 24869 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_A0\0" /* 24901 */
	"BLEND_OPT_PRESERVE_NONE_IGNORE_NONE\0" /* 24935 */
	"COLOR_SRC_OPT\0" /* 24971 */
	"COLOR_DST_OPT\0" /* 24985 */
	"OPT_COMB_NONE\0" /* 24999 */
	"OPT_COMB_ADD\0" /* 25013 */
	"OPT_COMB_SUBTRACT\0" /* 25026 */
	"OPT_COMB_MIN\0" /* 25044 */
	"OPT_COMB_MAX\0" /* 25057 */
	"OPT_COMB_REVSUBTRACT\0" /* 25070 */
	"OPT_COMB_BLEND_DISABLED\0" /* 25091 */
	"OPT_COMB_SAFE_ADD\0" /* 25115 */
	"COLOR_COMB_FCN\0" /* 25133 */
	"ALPHA_SRC_OPT\0" /* 25148 */
	"ALPHA_DST_OPT\0" /* 25162 */
	"ALPHA_COMB_FCN\0" /* 25176 */
	"BLEND_ZERO\0" /* 25191 */
	"BLEND_ONE\0" /* 25202 */
	"BLEND_SRC_COLOR\0" /* 25212 */
	"BLEND_ONE_MINUS_SRC_COLOR\0" /* 25228 */
	"BLEND_SRC_ALPHA\0" /* 25254 */
	"BLEND_ONE_MINUS_SRC_ALPHA\0" /* 25270 */
	"BLEND_DST_ALPHA\0" /* 25296 */
	"BLEND_ONE_MINUS_DST_ALPHA\0" /* 25312 */
	"BLEND_DST_COLOR\0" /* 25338 */
	"BLEND_ONE_MINUS_DST_COLOR\0" /* 25354 */
	"BLEND_SRC_ALPHA_SATURATE\0" /* 25380 */
	"BLEND_CONSTANT_COLOR\0" /* 25405 */
	"BLEND_ONE_MINUS_CONSTANT_COLOR\0" /* 25426 */
	"BLEND_SRC1_COLOR\0" /* 25457 */
	"BLEND_INV_SRC1_COLOR\0" /* 25474 */
	"BLEND_SRC1_ALPHA\0" /* 25495 */
	"BLEND_INV_SRC1_ALPHA\0" /* 25512 */
	"BLEND_CONSTANT_ALPHA\0" /* 25533 */
	"BLEND_ONE_MINUS_CONSTANT_ALPHA\0" /* 25554 */
	"COLOR_SRCBLEND\0" /* 25585 */
	"COMB_DST_PLUS_SRC\0" /* 25600 */
	"COMB_SRC_MINUS_DST\0" /* 25618 */
	"COMB_MIN_DST_SRC\0" /* 25637 */
	"COMB_MAX_DST_SRC\0" /* 25654 */
	"COMB_DST_MINUS_SRC\0" /* 25671 */
	"COLOR_DESTBLEND\0" /* 25690 */
	"ALPHA_SRCBLEND\0" /* 25706 */
	"ALPHA_DESTBLEND\0" /* 25721 */
	"SEPARATE_ALPHA_BLEND\0" /* 25737 */
	"DISABLE_ROP3\0" /* 25766, 25758 */
	"SRC_STATE_ID\0" /* 25771 */
	"BASE_ADDR\0" /* 25784 */
	"DI_SRC_SEL_DMA\0" /* 25794 */
	"DI_SRC_SEL_IMMEDIATE\0" /* 25809 */
	"DI_SRC_SEL_AUTO_INDEX\0" /* 25830 */
	"DI_SRC_SEL_RESERVED\0" /* 25852 */
	"SOURCE_SELECT\0" /* 25872 */
	"DI_MAJOR_MODE_0\0" /* 25886 */
	"DI_MAJOR_MODE_1\0" /* 25902 */
	"MAJOR_MODE\0" /* 25918 */
	"NOT_EOP\0" /* 25929 */
	"USE_OPAQUE\0" /* 25937 */
	"ADDRESS_LOW\0" /* 25948 */
	"STENCIL_ENABLE\0" /* 25960 */
	"Z_WRITE_ENABLE\0" /* 25975 */
	"DEPTH_BOUNDS_ENABLE\0" /* 25990 */
	"FRAG_NEVER\0" /* 26010 */
	"FRAG_LESS\0" /* 26021 */
	"FRAG_EQUAL\0" /* 26031 */
	"FRAG_LEQUAL\0" /* 26042 */
	"FRAG_GREATER\0" /* 26054 */
	"FRAG_NOTEQUAL\0" /* 26067 */
	"FRAG_GEQUAL\0" /* 26081 */
	"FRAG_ALWAYS\0" /* 26093 */
	"BACKFACE_ENABLE\0" /* 26105 */
	"REF_NEVER\0" /* 26121 */
	"REF_LESS\0" /* 26131 */
	"REF_EQUAL\0" /* 26140 */
	"REF_LEQUAL\0" /* 26150 */
	"REF_GREATER\0" /* 26161 */
	"REF_NOTEQUAL\0" /* 26173 */
	"REF_GEQUAL\0" /* 26186 */
	"REF_ALWAYS\0" /* 26197 */
	"STENCILFUNC\0" /* 26208 */
	"STENCILFUNC_BF\0" /* 26220 */
	"ENABLE_COLOR_WRITES_ON_DEPTH_FAIL\0" /* 26235 */
	"DISABLE_COLOR_WRITES_ON_DEPTH_PASS\0" /* 26269 */
	"MAX_ANCHOR_SAMPLES\0" /* 26304 */
	"PS_ITER_SAMPLES\0" /* 26323 */
	"MASK_EXPORT_NUM_SAMPLES\0" /* 26339 */
	"ALPHA_TO_MASK_NUM_SAMPLES\0" /* 26363 */
	"HIGH_QUALITY_INTERSECTIONS\0" /* 26389 */
	"INCOHERENT_EQAA_READS\0" /* 26416 */
	"INTERPOLATE_COMP_Z\0" /* 26438 */
	"INTERPOLATE_SRC_Z\0" /* 26457 */
	"STATIC_ANCHOR_ASSOCIATIONS\0" /* 26475 */
	"ALPHA_TO_MASK_EQAA_DISABLE\0" /* 26502 */
	"OVERRASTERIZATION_AMOUNT\0" /* 26529 */
	"ENABLE_POSTZ_OVERRASTERIZATION\0" /* 26554 */
	"DISABLE_DUAL_QUAD\0" /* 26585 */
	"DEGAMMA_ENABLE\0" /* 26603 */
	"CB_DISABLE\0" /* 26618 */
	"CB_NORMAL\0" /* 26629 */
	"CB_ELIMINATE_FAST_CLEAR\0" /* 26652, 26639 */
	"CB_RESOLVE\0" /* 26663 */
	"CB_FMASK_DECOMPRESS\0" /* 26674 */
	"CB_DCC_DECOMPRESS\0" /* 26694 */
	"X_0X00\0" /* 26712 */
	"X_0X05\0" /* 26719 */
	"X_0X0A\0" /* 26726 */
	"X_0X0F\0" /* 26733 */
	"X_0X11\0" /* 26740 */
	"X_0X22\0" /* 26747 */
	"X_0X33\0" /* 26754 */
	"X_0X44\0" /* 26761 */
	"X_0X50\0" /* 26768 */
	"X_0X55\0" /* 26775 */
	"X_0X5A\0" /* 26782 */
	"X_0X5F\0" /* 26789 */
	"X_0X66\0" /* 26796 */
	"X_0X77\0" /* 26803 */
	"X_0X88\0" /* 26810 */
	"X_0X99\0" /* 26817 */
	"X_0XA0\0" /* 26824 */
	"X_0XA5\0" /* 26831 */
	"X_0XAA\0" /* 26838 */
	"X_0XAF\0" /* 26845 */
	"X_0XBB\0" /* 26852 */
	"X_0XCC\0" /* 26859 */
	"X_0XDD\0" /* 26866 */
	"X_0XEE\0" /* 26873 */
	"X_0XF0\0" /* 26880 */
	"X_0XF5\0" /* 26887 */
	"X_0XFA\0" /* 26894 */
	"X_0XFF\0" /* 26901 */
	"Z_EXPORT_ENABLE\0" /* 26908 */
	"STENCIL_TEST_VAL_EXPORT_ENABLE\0" /* 26924 */
	"STENCIL_OP_VAL_EXPORT_ENABLE\0" /* 26955 */
	"LATE_Z\0" /* 26984 */
	"EARLY_Z_THEN_LATE_Z\0" /* 26991 */
	"RE_Z\0" /* 27011 */
	"EARLY_Z_THEN_RE_Z\0" /* 27016 */
	"KILL_ENABLE\0" /* 27034 */
	"COVERAGE_TO_MASK_ENABLE\0" /* 27046 */
	"MASK_EXPORT_ENABLE\0" /* 27070 */
	"EXEC_ON_HIER_FAIL\0" /* 27089 */
	"EXEC_ON_NOOP\0" /* 27107 */
	"ALPHA_TO_MASK_DISABLE\0" /* 27120 */
	"DEPTH_BEFORE_SHADER\0" /* 27142 */
	"EXPORT_ANY_Z\0" /* 27162 */
	"EXPORT_LESS_THAN_Z\0" /* 27175 */
	"EXPORT_GREATER_THAN_Z\0" /* 27194 */
	"EXPORT_RESERVED\0" /* 27216 */
	"CONSERVATIVE_Z_EXPORT\0" /* 27232 */
	"DUAL_QUAD_DISABLE\0" /* 27254 */
	"UCP_ENA_0\0" /* 27272 */
	"UCP_ENA_1\0" /* 27282 */
	"UCP_ENA_2\0" /* 27292 */
	"UCP_ENA_3\0" /* 27302 */
	"UCP_ENA_4\0" /* 27312 */
	"UCP_ENA_5\0" /* 27322 */
	"PS_UCP_Y_SCALE_NEG\0" /* 27332 */
	"PS_UCP_MODE\0" /* 27351 */
	"CLIP_DISABLE\0" /* 27363 */
	"UCP_CULL_ONLY_ENA\0" /* 27376 */
	"BOUNDARY_EDGE_FLAG_ENA\0" /* 27394 */
	"DX_CLIP_SPACE_DEF\0" /* 27417 */
	"DIS_CLIP_ERR_DETECT\0" /* 27435 */
	"VTX_KILL_OR\0" /* 27455 */
	"DX_RASTERIZATION_KILL\0" /* 27467 */
	"DX_LINEAR_ATTR_CLIP_ENA\0" /* 27489 */
	"VTE_VPORT_PROVOKE_DISABLE\0" /* 27513 */
	"ZCLIP_NEAR_DISABLE\0" /* 27539 */
	"ZCLIP_FAR_DISABLE\0" /* 27558 */
	"CULL_FRONT\0" /* 27576 */
	"CULL_BACK\0" /* 27587 */
	"FACE\0" /* 27597 */
	"X_DISABLE_POLY_MODE\0" /* 27602, 27612 */
	"X_DUAL_MODE\0" /* 27622 */
	"X_DRAW_POINTS\0" /* 27634 */
	"X_DRAW_LINES\0" /* 27648 */
	"X_DRAW_TRIANGLES\0" /* 27661 */
	"POLYMODE_FRONT_PTYPE\0" /* 27678 */
	"POLYMODE_BACK_PTYPE\0" /* 27699 */
	"POLY_OFFSET_FRONT_ENABLE\0" /* 27719 */
	"POLY_OFFSET_BACK_ENABLE\0" /* 27744 */
	"POLY_OFFSET_PARA_ENABLE\0" /* 27768 */
	"VTX_WINDOW_OFFSET_ENABLE\0" /* 27792 */
	"PROVOKING_VTX_LAST\0" /* 27817 */
	"PERSP_CORR_DIS\0" /* 27836 */
	"MULTI_PRIM_IB_ENA\0" /* 27851 */
	"VPORT_X_SCALE_ENA\0" /* 27869 */
	"VPORT_X_OFFSET_ENA\0" /* 27887 */
	"VPORT_Y_SCALE_ENA\0" /* 27906 */
	"VPORT_Y_OFFSET_ENA\0" /* 27924 */
	"VPORT_Z_SCALE_ENA\0" /* 27943 */
	"VPORT_Z_OFFSET_ENA\0" /* 27961 */
	"VTX_XY_FMT\0" /* 27980 */
	"VTX_Z_FMT\0" /* 27991 */
	"VTX_W0_FMT\0" /* 28001 */
	"CLIP_DIST_ENA_0\0" /* 28012 */
	"CLIP_DIST_ENA_1\0" /* 28028 */
	"CLIP_DIST_ENA_2\0" /* 28044 */
	"CLIP_DIST_ENA_3\0" /* 28060 */
	"CLIP_DIST_ENA_4\0" /* 28076 */
	"CLIP_DIST_ENA_5\0" /* 28092 */
	"CLIP_DIST_ENA_6\0" /* 28108 */
	"CLIP_DIST_ENA_7\0" /* 28124 */
	"CULL_DIST_ENA_0\0" /* 28140 */
	"CULL_DIST_ENA_1\0" /* 28156 */
	"CULL_DIST_ENA_2\0" /* 28172 */
	"CULL_DIST_ENA_3\0" /* 28188 */
	"CULL_DIST_ENA_4\0" /* 28204 */
	"CULL_DIST_ENA_5\0" /* 28220 */
	"CULL_DIST_ENA_6\0" /* 28236 */
	"CULL_DIST_ENA_7\0" /* 28252 */
	"USE_VTX_POINT_SIZE\0" /* 28268 */
	"USE_VTX_EDGE_FLAG\0" /* 28287 */
	"USE_VTX_RENDER_TARGET_INDX\0" /* 28305 */
	"USE_VTX_VIEWPORT_INDX\0" /* 28332 */
	"USE_VTX_KILL_FLAG\0" /* 28354 */
	"VS_OUT_MISC_VEC_ENA\0" /* 28372 */
	"VS_OUT_CCDIST0_VEC_ENA\0" /* 28392 */
	"VS_OUT_CCDIST1_VEC_ENA\0" /* 28415 */
	"VS_OUT_MISC_SIDE_BUS_ENA\0" /* 28438 */
	"USE_VTX_GS_CUT_FLAG\0" /* 28463 */
	"USE_VTX_LINE_WIDTH\0" /* 28483 */
	"VTE_XY_INF_DISCARD\0" /* 28502 */
	"VTE_Z_INF_DISCARD\0" /* 28521 */
	"VTE_W_INF_DISCARD\0" /* 28539 */
	"VTE_0XNANINF_IS_0\0" /* 28557 */
	"VTE_XY_NAN_RETAIN\0" /* 28575 */
	"VTE_Z_NAN_RETAIN\0" /* 28593 */
	"VTE_W_NAN_RETAIN\0" /* 28610 */
	"VTE_W_RECIP_NAN_IS_0\0" /* 28627 */
	"VS_XY_NAN_TO_INF\0" /* 28648 */
	"VS_XY_INF_RETAIN\0" /* 28665 */
	"VS_Z_NAN_TO_INF\0" /* 28682 */
	"VS_Z_INF_RETAIN\0" /* 28698 */
	"VS_W_NAN_TO_INF\0" /* 28714 */
	"VS_W_INF_RETAIN\0" /* 28730 */
	"VS_CLIP_DIST_INF_DISCARD\0" /* 28746 */
	"VTE_NO_OUTPUT_NEG_0\0" /* 28771 */
	"LINE_STIPPLE_RESET\0" /* 28791 */
	"EXPAND_FULL_LENGTH\0" /* 28810 */
	"FRACTIONAL_ACCUM\0" /* 28829 */
	"DIAMOND_ADJUST\0" /* 28846 */
	"TRIANGLE_FILTER_DISABLE\0" /* 28861 */
	"LINE_FILTER_DISABLE\0" /* 28885 */
	"POINT_FILTER_DISABLE\0" /* 28905 */
	"RECTANGLE_FILTER_DISABLE\0" /* 28926 */
	"TRIANGLE_EXPAND_ENA\0" /* 28951 */
	"LINE_EXPAND_ENA\0" /* 28971 */
	"POINT_EXPAND_ENA\0" /* 28987 */
	"RECTANGLE_EXPAND_ENA\0" /* 29004 */
	"PRIM_EXPAND_CONSTANT\0" /* 29025 */
	"XMAX_RIGHT_EXCLUSION\0" /* 29046 */
	"YMAX_BOTTOM_EXCLUSION\0" /* 29067 */
	"SMALL_PRIM_FILTER_ENABLE\0" /* 29089 */
	"MIN_SIZE\0" /* 29114 */
	"MAX_SIZE\0" /* 29123 */
	"LINE_PATTERN\0" /* 29132 */
	"REPEAT_COUNT\0" /* 29145 */
	"PATTERN_BIT_ORDER\0" /* 29158 */
	"AUTO_RESET_CNTL\0" /* 29176 */
	"VGT_OUTPATH_VTX_REUSE\0" /* 29192 */
	"VGT_OUTPATH_TESS_EN\0" /* 29214 */
	"VGT_OUTPATH_PASSTHRU\0" /* 29234 */
	"VGT_OUTPATH_GS_BLOCK\0" /* 29255 */
	"VGT_OUTPATH_HS_BLOCK\0" /* 29276 */
	"PATH_SELECT\0" /* 29297 */
	"TESS_MODE\0" /* 29309 */
	"REUSE_DEPTH\0" /* 29319 */
	"VGT_GRP_3D_POINT\0" /* 29331 */
	"VGT_GRP_3D_LINE\0" /* 29348 */
	"VGT_GRP_3D_TRI\0" /* 29364 */
	"VGT_GRP_3D_RECT\0" /* 29379 */
	"VGT_GRP_3D_QUAD\0" /* 29395 */
	"VGT_GRP_2D_COPY_RECT_V0\0" /* 29411 */
	"VGT_GRP_2D_COPY_RECT_V1\0" /* 29435 */
	"VGT_GRP_2D_COPY_RECT_V2\0" /* 29459 */
	"VGT_GRP_2D_COPY_RECT_V3\0" /* 29483 */
	"VGT_GRP_2D_FILL_RECT\0" /* 29507 */
	"VGT_GRP_2D_LINE\0" /* 29528 */
	"VGT_GRP_2D_TRI\0" /* 29544 */
	"VGT_GRP_PRIM_INDEX_LINE\0" /* 29559 */
	"VGT_GRP_PRIM_INDEX_TRI\0" /* 29583 */
	"VGT_GRP_PRIM_INDEX_QUAD\0" /* 29606 */
	"VGT_GRP_3D_LINE_ADJ\0" /* 29630 */
	"VGT_GRP_3D_TRI_ADJ\0" /* 29650 */
	"VGT_GRP_3D_PATCH\0" /* 29669 */
	"RETAIN_ORDER\0" /* 29686 */
	"RETAIN_QUADS\0" /* 29699 */
	"VGT_GRP_LIST\0" /* 29712 */
	"VGT_GRP_STRIP\0" /* 29725 */
	"VGT_GRP_FAN\0" /* 29739 */
	"VGT_GRP_LOOP\0" /* 29751 */
	"VGT_GRP_POLYGON\0" /* 29764 */
	"PRIM_ORDER\0" /* 29780 */
	"FIRST_DECR\0" /* 29797, 29791 */
	"COMP_X_EN\0" /* 29802 */
	"COMP_Y_EN\0" /* 29812 */
	"COMP_Z_EN\0" /* 29822 */
	"COMP_W_EN\0" /* 29832 */
	"SHIFT\0" /* 29842 */
	"VGT_GRP_INDEX_16\0" /* 29848 */
	"VGT_GRP_INDEX_32\0" /* 29865 */
	"VGT_GRP_UINT_16\0" /* 29882 */
	"VGT_GRP_UINT_32\0" /* 29898 */
	"VGT_GRP_SINT_16\0" /* 29914 */
	"VGT_GRP_SINT_32\0" /* 29930 */
	"VGT_GRP_FLOAT_32\0" /* 29946 */
	"VGT_GRP_AUTO_PRIM\0" /* 29963 */
	"VGT_GRP_FIX_1_23_TO_FLOAT\0" /* 29981 */
	"X_CONV\0" /* 30007 */
	"Y_CONV\0" /* 30014 */
	"Z_CONV\0" /* 30021 */
	"Z_OFFSET\0" /* 30028 */
	"W_CONV\0" /* 30037 */
	"W_OFFSET\0" /* 30044 */
	"GS_OFF\0" /* 30053 */
	"GS_SCENARIO_A\0" /* 30060 */
	"GS_SCENARIO_B\0" /* 30074 */
	"GS_SCENARIO_G\0" /* 30088 */
	"GS_SCENARIO_C\0" /* 30102 */
	"SPRITE_EN\0" /* 30116 */
	"GS_CUT_1024\0" /* 30126 */
	"GS_CUT_512\0" /* 30138 */
	"GS_CUT_256\0" /* 30149 */
	"GS_CUT_128\0" /* 30160 */
	"CUT_MODE\0" /* 30171 */
	"GS_C_PACK_EN\0" /* 30180 */
	"RESERVED_2\0" /* 30193 */
	"ES_PASSTHRU\0" /* 30204 */
	"COMPUTE_MODE\0" /* 30216 */
	"FAST_COMPUTE_MODE\0" /* 30229 */
	"ELEMENT_INFO_EN\0" /* 30247 */
	"PARTIAL_THD_AT_EOI\0" /* 30263 */
	"SUPPRESS_CUTS\0" /* 30282 */
	"ES_WRITE_OPTIMIZE\0" /* 30296 */
	"GS_WRITE_OPTIMIZE\0" /* 30314 */
	"X_0_OFFCHIP_GS\0" /* 30332 */
	"X_3_ES_AND_GS_ARE_ONCHIP\0" /* 30347, 30365 */
	"ES_VERTS_PER_SUBGRP\0" /* 30372 */
	"GS_PRIMS_PER_SUBGRP\0" /* 30392 */
	"MSAA_ENABLE\0" /* 30412 */
	"VPORT_SCISSOR_ENABLE\0" /* 30424 */
	"LINE_STIPPLE_ENABLE\0" /* 30445 */
	"SEND_UNLIT_STILES_TO_PKR\0" /* 30465 */
	"WALK_SIZE\0" /* 30490 */
	"WALK_ALIGNMENT\0" /* 30500 */
	"WALK_ALIGN8_PRIM_FITS_ST\0" /* 30515 */
	"WALK_FENCE_ENABLE\0" /* 30540 */
	"WALK_FENCE_SIZE\0" /* 30558 */
	"SUPERTILE_WALK_ORDER_ENABLE\0" /* 30579, 30574 */
	"TILE_COVER_DISABLE\0" /* 30602 */
	"TILE_COVER_NO_SCISSOR\0" /* 30621 */
	"ZMM_LINE_EXTENT\0" /* 30643 */
	"ZMM_LINE_OFFSET\0" /* 30659 */
	"ZMM_RECT_EXTENT\0" /* 30675 */
	"KILL_PIX_POST_HI_Z\0" /* 30691 */
	"KILL_PIX_POST_DETAIL_MASK\0" /* 30710 */
	"PS_ITER_SAMPLE\0" /* 30736 */
	"MULTI_SHADER_ENGINE_PRIM_DISCARD_ENABLE\0" /* 30751 */
	"MULTI_GPU_SUPERTILE_ENABLE\0" /* 30791 */
	"GPU_ID_OVERRIDE_ENABLE\0" /* 30818 */
	"GPU_ID_OVERRIDE\0" /* 30841 */
	"MULTI_GPU_PRIM_DISCARD_ENABLE\0" /* 30857 */
	"FORCE_EOV_CNTDWN_ENABLE\0" /* 30887 */
	"FORCE_EOV_REZ_ENABLE\0" /* 30911 */
	"OUT_OF_ORDER_PRIMITIVE_ENABLE\0" /* 30932 */
	"OUT_OF_ORDER_WATER_MARK\0" /* 30962 */
	"GS_PER_ES\0" /* 30986 */
	"ES_PER_GS\0" /* 30996 */
	"GS_PER_VS\0" /* 31006 */
	"OUTPRIM_TYPE_POINTLIST\0" /* 31016 */
	"OUTPRIM_TYPE_LINESTRIP\0" /* 31039 */
	"OUTPRIM_TYPE_TRISTRIP\0" /* 31062 */
	"OUTPRIM_TYPE\0" /* 31084 */
	"OUTPRIM_TYPE_1\0" /* 31097 */
	"OUTPRIM_TYPE_2\0" /* 31112 */
	"OUTPRIM_TYPE_3\0" /* 31127 */
	"UNIQUE_TYPE_PER_STREAM\0" /* 31142 */
	"VGT_INDEX_16\0" /* 31165 */
	"VGT_INDEX_32\0" /* 31178 */
	"VGT_INDEX_8\0" /* 31191 */
	"VGT_DMA_SWAP_NONE\0" /* 31203 */
	"VGT_DMA_SWAP_16_BIT\0" /* 31221 */
	"VGT_DMA_SWAP_32_BIT\0" /* 31241 */
	"VGT_DMA_SWAP_WORD\0" /* 31261 */
	"SWAP_MODE\0" /* 31279 */
	"VGT_DMA_BUF_MEM\0" /* 31289 */
	"VGT_DMA_BUF_RING\0" /* 31305 */
	"VGT_DMA_BUF_SETUP\0" /* 31322 */
	"BUF_TYPE\0" /* 31340 */
	"VGT_POLICY_LRU\0" /* 31349 */
	"VGT_POLICY_STREAM\0" /* 31364 */
	"RDREQ_POLICY\0" /* 31382 */
	"RDREQ_POLICY_VI\0" /* 31395 */
	"REQ_PATH\0" /* 31411 */
	"PRIMITIVEID_EN\0" /* 31420 */
	"DISABLE_RESET_ON_EOI\0" /* 31435 */
	"SAMPLE_STREAMOUTSTATS1\0" /* 31456 */
	"SAMPLE_STREAMOUTSTATS2\0" /* 31479 */
	"SAMPLE_STREAMOUTSTATS3\0" /* 31502 */
	"CACHE_FLUSH_TS\0" /* 31525 */
	"CONTEXT_DONE\0" /* 31540 */
	"CACHE_FLUSH\0" /* 31553 */
	"CS_PARTIAL_FLUSH\0" /* 31565 */
	"VGT_STREAMOUT_SYNC\0" /* 31582 */
	"VGT_STREAMOUT_RESET\0" /* 31601 */
	"END_OF_PIPE_INCR_DE\0" /* 31621 */
	"END_OF_PIPE_IB_END\0" /* 31641 */
	"RST_PIX_CNT\0" /* 31660 */
	"VS_PARTIAL_FLUSH\0" /* 31672 */
	"PS_PARTIAL_FLUSH\0" /* 31689 */
	"FLUSH_HS_OUTPUT\0" /* 31706 */
	"FLUSH_LS_OUTPUT\0" /* 31722 */
	"CACHE_FLUSH_AND_INV_TS_EVENT\0" /* 31738 */
	"ZPASS_DONE\0" /* 31767 */
	"CACHE_FLUSH_AND_INV_EVENT\0" /* 31778 */
	"PERFCOUNTER_START\0" /* 31804 */
	"PERFCOUNTER_STOP\0" /* 31822 */
	"PIPELINESTAT_START\0" /* 31839 */
	"PIPELINESTAT_STOP\0" /* 31858 */
	"PERFCOUNTER_SAMPLE\0" /* 31876 */
	"FLUSH_ES_OUTPUT\0" /* 31895 */
	"FLUSH_GS_OUTPUT\0" /* 31911 */
	"SAMPLE_PIPELINESTAT\0" /* 31927 */
	"SO_VGTSTREAMOUT_FLUSH\0" /* 31947 */
	"SAMPLE_STREAMOUTSTATS\0" /* 31969 */
	"RESET_VTX_CNT\0" /* 31991 */
	"BLOCK_CONTEXT_DONE\0" /* 32005 */
	"CS_CONTEXT_DONE\0" /* 32024 */
	"VGT_FLUSH\0" /* 32040 */
	"SC_SEND_DB_VPZ\0" /* 32050 */
	"BOTTOM_OF_PIPE_TS\0" /* 32065 */
	"DB_CACHE_FLUSH_AND_INV\0" /* 32083 */
	"FLUSH_AND_INV_DB_DATA_TS\0" /* 32106 */
	"FLUSH_AND_INV_DB_META\0" /* 32131 */
	"FLUSH_AND_INV_CB_DATA_TS\0" /* 32153 */
	"FLUSH_AND_INV_CB_META\0" /* 32178 */
	"FLUSH_AND_INV_CB_PIXEL_DATA\0" /* 32200 */
	"THREAD_TRACE_START\0" /* 32228 */
	"THREAD_TRACE_STOP\0" /* 32247 */
	"THREAD_TRACE_MARKER\0" /* 32265 */
	"THREAD_TRACE_FLUSH\0" /* 32285 */
	"THREAD_TRACE_FINISH\0" /* 32304 */
	"PIXEL_PIPE_STAT_CONTROL\0" /* 32324 */
	"PIXEL_PIPE_STAT_DUMP\0" /* 32348 */
	"PIXEL_PIPE_STAT_RESET\0" /* 32369 */
	"EVENT_TYPE\0" /* 32391 */
	"EXTENDED_EVENT\0" /* 32402 */
	"RESET_EN\0" /* 32417 */
	"PRIMGROUP_SIZE\0" /* 32426 */
	"PARTIAL_VS_WAVE_ON\0" /* 32441 */
	"SWITCH_ON_EOP\0" /* 32460 */
	"PARTIAL_ES_WAVE_ON\0" /* 32474 */
	"SWITCH_ON_EOI\0" /* 32493 */
	"WD_SWITCH_ON_EOP\0" /* 32507 */
	"MAX_PRIMGRP_IN_WAVE\0" /* 32524 */
	"ITEMSIZE\0" /* 32544 */
	"REUSE_OFF\0" /* 32553 */
	"VTX_CNT_EN\0" /* 32563 */
	"FULL_CACHE\0" /* 32574 */
	"HTILE_USES_PRELOAD_WIN\0" /* 32585 */
	"PRELOAD\0" /* 32608 */
	"PREFETCH_WIDTH\0" /* 32616 */
	"PREFETCH_HEIGHT\0" /* 32631 */
	"DST_OUTSIDE_ZERO_TO_ONE\0" /* 32647 */
	"TC_COMPATIBLE\0" /* 32671 */
	"COMPAREFUNC0\0" /* 32685 */
	"COMPAREVALUE0\0" /* 32698 */
	"COMPAREMASK0\0" /* 32712 */
	"COMPAREFUNC1\0" /* 32725 */
	"COMPAREVALUE1\0" /* 32738 */
	"COMPAREMASK1\0" /* 32752 */
	"START_X\0" /* 32765 */
	"START_Y\0" /* 32773 */
	"MAX_X\0" /* 32781 */
	"MAX_Y\0" /* 32787 */
	"VERTEX_STRIDE\0" /* 32793 */
	"MAX_VERT_OUT\0" /* 32807 */
	"ACCUM_ISOLINE\0" /* 32820 */
	"ACCUM_TRI\0" /* 32834 */
	"ACCUM_QUAD\0" /* 32844 */
	"DONUT_SPLIT\0" /* 32855 */
	"TRAP_SPLIT\0" /* 32867 */
	"LS_STAGE_OFF\0" /* 32878 */
	"LS_STAGE_ON\0" /* 32891 */
	"CS_STAGE_ON\0" /* 32903 */
	"ES_STAGE_OFF\0" /* 32915 */
	"ES_STAGE_DS\0" /* 32928 */
	"ES_STAGE_REAL\0" /* 32940 */
	"VS_STAGE_REAL\0" /* 32954 */
	"VS_STAGE_DS\0" /* 32968 */
	"VS_STAGE_COPY_SHADER\0" /* 32980 */
	"DYNAMIC_HS\0" /* 33001 */
	"DIS_DEALLOC_ACCUM_0\0" /* 33012 */
	"DIS_DEALLOC_ACCUM_1\0" /* 33032 */
	"VS_WAVE_ID_EN\0" /* 33052 */
	"NUM_PATCHES\0" /* 33066 */
	"HS_NUM_INPUT_CP\0" /* 33078 */
	"HS_NUM_OUTPUT_CP\0" /* 33094 */
	"TESS_ISOLINE\0" /* 33111 */
	"TESS_TRIANGLE\0" /* 33124 */
	"TESS_QUAD\0" /* 33138 */
	"PART_INTEGER\0" /* 33148 */
	"PART_POW2\0" /* 33161 */
	"PART_FRAC_ODD\0" /* 33171 */
	"PART_FRAC_EVEN\0" /* 33185 */
	"PARTITIONING\0" /* 33200 */
	"OUTPUT_POINT\0" /* 33213 */
	"OUTPUT_LINE\0" /* 33226 */
	"OUTPUT_TRIANGLE_CW\0" /* 33238 */
	"OUTPUT_TRIANGLE_CCW\0" /* 33257 */
	"TOPOLOGY\0" /* 33277 */
	"RESERVED_REDUC_AXIS\0" /* 33286 */
	"DEPRECATED\0" /* 33306 */
	"NUM_DS_WAVES_PER_SIMD\0" /* 33317 */
	"DISABLE_DONUTS\0" /* 33339 */
	"VGT_POLICY_BYPASS\0" /* 33354 */
	"DISTRIBUTION_MODE_NO_DIST\0" /* 33372 */
	"DISTRIBUTION_MODE_PATCHES\0" /* 33398 */
	"DISTRIBUTION_MODE_DONUTS\0" /* 33424 */
	"DISTRIBUTION_MODE_TRAPEZOIDS\0" /* 33449 */
	"DISTRIBUTION_MODE\0" /* 33478 */
	"ALPHA_TO_MASK_ENABLE\0" /* 33496 */
	"ALPHA_TO_MASK_OFFSET0\0" /* 33517 */
	"ALPHA_TO_MASK_OFFSET1\0" /* 33539 */
	"ALPHA_TO_MASK_OFFSET2\0" /* 33561 */
	"ALPHA_TO_MASK_OFFSET3\0" /* 33583 */
	"OFFSET_ROUND\0" /* 33605 */
	"POLY_OFFSET_NEG_NUM_DB_BITS\0" /* 33618 */
	"POLY_OFFSET_DB_IS_FLOAT_FMT\0" /* 33646 */
	"STREAMOUT_0_EN\0" /* 33674 */
	"STREAMOUT_1_EN\0" /* 33689 */
	"STREAMOUT_2_EN\0" /* 33704 */
	"STREAMOUT_3_EN\0" /* 33719 */
	"RAST_STREAM\0" /* 33734 */
	"RAST_STREAM_MASK\0" /* 33746 */
	"USE_RAST_STREAM_MASK\0" /* 33763 */
	"STREAM_0_BUFFER_EN\0" /* 33784 */
	"STREAM_1_BUFFER_EN\0" /* 33803 */
	"STREAM_2_BUFFER_EN\0" /* 33822 */
	"STREAM_3_BUFFER_EN\0" /* 33841 */
	"DISTANCE_0\0" /* 33860 */
	"DISTANCE_1\0" /* 33871 */
	"DISTANCE_2\0" /* 33882 */
	"DISTANCE_3\0" /* 33893 */
	"DISTANCE_4\0" /* 33904 */
	"DISTANCE_5\0" /* 33915 */
	"DISTANCE_6\0" /* 33926 */
	"DISTANCE_7\0" /* 33937 */
	"DISTANCE_8\0" /* 33948 */
	"DISTANCE_9\0" /* 33959 */
	"DISTANCE_10\0" /* 33970 */
	"DISTANCE_11\0" /* 33982 */
	"DISTANCE_12\0" /* 33994 */
	"DISTANCE_13\0" /* 34006 */
	"DISTANCE_14\0" /* 34018 */
	"DISTANCE_15\0" /* 34030 */
	"EXPAND_LINE_WIDTH\0" /* 34042 */
	"LAST_PIXEL\0" /* 34060 */
	"PERPENDICULAR_ENDCAP_ENA\0" /* 34071 */
	"DX10_DIAMOND_TEST_ENA\0" /* 34096 */
	"MSAA_NUM_SAMPLES\0" /* 34118 */
	"AA_MASK_CENTROID_DTMN\0" /* 34135 */
	"MAX_SAMPLE_DIST\0" /* 34157 */
	"MSAA_EXPOSED_SAMPLES\0" /* 34173 */
	"DETAIL_TO_EXPOSED_MODE\0" /* 34194 */
	"PIX_CENTER\0" /* 34217 */
	"X_TRUNCATE\0" /* 34228 */
	"X_ROUND\0" /* 34239 */
	"X_ROUND_TO_EVEN\0" /* 34247 */
	"X_ROUND_TO_ODD\0" /* 34263 */
	"ROUND_MODE\0" /* 34278 */
	"X_16_8_FIXED_POINT_1_16TH\0" /* 34289 */
	"X_16_8_FIXED_POINT_1_8TH\0" /* 34315 */
	"X_16_8_FIXED_POINT_1_4TH\0" /* 34340 */
	"X_16_8_FIXED_POINT_1_2\0" /* 34365 */
	"X_16_8_FIXED_POINT_1\0" /* 34388 */
	"X_16_8_FIXED_POINT_1_256TH\0" /* 34409 */
	"X_14_10_FIXED_POINT_1_1024TH\0" /* 34436 */
	"X_12_12_FIXED_POINT_1_4096TH\0" /* 34465 */
	"QUANT_MODE\0" /* 34494 */
	"S0_X\0" /* 34505 */
	"S0_Y\0" /* 34510 */
	"S1_X\0" /* 34515 */
	"S1_Y\0" /* 34520 */
	"S2_X\0" /* 34525 */
	"S2_Y\0" /* 34530 */
	"S3_X\0" /* 34535 */
	"S3_Y\0" /* 34540 */
	"S4_X\0" /* 34545 */
	"S4_Y\0" /* 34550 */
	"S5_X\0" /* 34555 */
	"S5_Y\0" /* 34560 */
	"S6_X\0" /* 34565 */
	"S6_Y\0" /* 34570 */
	"S7_X\0" /* 34575 */
	"S7_Y\0" /* 34580 */
	"S8_X\0" /* 34585 */
	"S8_Y\0" /* 34590 */
	"S9_X\0" /* 34595 */
	"S9_Y\0" /* 34600 */
	"S10_X\0" /* 34605 */
	"S10_Y\0" /* 34611 */
	"S11_X\0" /* 34617 */
	"S11_Y\0" /* 34623 */
	"S12_X\0" /* 34629 */
	"S12_Y\0" /* 34635 */
	"S13_X\0" /* 34641 */
	"S13_Y\0" /* 34647 */
	"S14_X\0" /* 34653 */
	"S14_Y\0" /* 34659 */
	"S15_X\0" /* 34665 */
	"S15_Y\0" /* 34671 */
	"AA_MASK_X0Y0\0" /* 34677 */
	"AA_MASK_X1Y0\0" /* 34690 */
	"AA_MASK_X0Y1\0" /* 34703 */
	"AA_MASK_X1Y1\0" /* 34716 */
	"REALIGN_DQUADS_AFTER_N_WAVES\0" /* 34729 */
	"VTX_REUSE_DEPTH\0" /* 34758 */
	"DEALLOC_DIST\0" /* 34774 */
	"FMASK_TILE_MAX\0" /* 34787 */
	"ENDIAN_NONE\0" /* 34802 */
	"ENDIAN_8IN16\0" /* 34814 */
	"ENDIAN_8IN32\0" /* 34827 */
	"ENDIAN_8IN64\0" /* 34840 */
	"ENDIAN\0" /* 34853 */
	"COLOR_INVALID\0" /* 34860 */
	"COLOR_8\0" /* 34874 */
	"COLOR_16\0" /* 34882 */
	"COLOR_8_8\0" /* 34891 */
	"COLOR_32\0" /* 34901 */
	"COLOR_16_16\0" /* 34910 */
	"COLOR_10_11_11\0" /* 34922 */
	"COLOR_11_11_10\0" /* 34937 */
	"COLOR_10_10_10_2\0" /* 34952 */
	"COLOR_2_10_10_10\0" /* 34969 */
	"COLOR_8_8_8_8\0" /* 34986 */
	"COLOR_32_32\0" /* 35000 */
	"COLOR_16_16_16_16\0" /* 35012 */
	"COLOR_32_32_32_32\0" /* 35030 */
	"COLOR_5_6_5\0" /* 35048 */
	"COLOR_1_5_5_5\0" /* 35060 */
	"COLOR_5_5_5_1\0" /* 35074 */
	"COLOR_4_4_4_4\0" /* 35088 */
	"COLOR_8_24\0" /* 35102 */
	"COLOR_24_8\0" /* 35113 */
	"COLOR_X24_8_32_FLOAT\0" /* 35124 */
	"NUMBER_UNORM\0" /* 35145 */
	"NUMBER_SNORM\0" /* 35158 */
	"NUMBER_UINT\0" /* 35171 */
	"NUMBER_SINT\0" /* 35183 */
	"NUMBER_SRGB\0" /* 35195 */
	"NUMBER_FLOAT\0" /* 35207 */
	"NUMBER_TYPE\0" /* 35220 */
	"SWAP_STD\0" /* 35232 */
	"SWAP_ALT\0" /* 35241 */
	"SWAP_STD_REV\0" /* 35250 */
	"SWAP_ALT_REV\0" /* 35263 */
	"COMP_SWAP\0" /* 35276 */
	"BLEND_CLAMP\0" /* 35286 */
	"BLEND_BYPASS\0" /* 35298 */
	"SIMPLE_FLOAT\0" /* 35311 */
	"CMASK_IS_LINEAR\0" /* 35324 */
	"FORCE_OPT_AUTO\0" /* 35340 */
	"FORCE_OPT_DISABLE\0" /* 35355 */
	"FORCE_OPT_ENABLE_IF_SRC_A_0\0" /* 35373 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_0\0" /* 35401 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_0\0" /* 35431 */
	"FORCE_OPT_ENABLE_IF_SRC_A_1\0" /* 35462 */
	"FORCE_OPT_ENABLE_IF_SRC_RGB_1\0" /* 35490 */
	"FORCE_OPT_ENABLE_IF_SRC_ARGB_1\0" /* 35520 */
	"BLEND_OPT_DONT_RD_DST\0" /* 35551 */
	"BLEND_OPT_DISCARD_PIXEL\0" /* 35573 */
	"FMASK_COMPRESSION_DISABLE\0" /* 35597 */
	"FMASK_COMPRESS_1FRAG_ONLY\0" /* 35623 */
	"DCC_ENABLE\0" /* 35649 */
	"CMASK_ADDR_TYPE\0" /* 35660 */
	"FMASK_TILE_MODE_INDEX\0" /* 35676 */
	"FMASK_BANK_HEIGHT\0" /* 35698 */
	"NUM_FRAGMENTS\0" /* 35716 */
	"FORCE_DST_ALPHA_1\0" /* 35730 */
	"KEY_CLEAR_ENABLE\0" /* 35748 */
	"MAX_UNCOMPRESSED_BLOCK_SIZE\0" /* 35765 */
	"MIN_COMPRESSED_BLOCK_SIZE\0" /* 35793 */
	"MAX_COMPRESSED_BLOCK_SIZE\0" /* 35819 */
	"INDEPENDENT_64B_BLOCKS\0" /* 35845 */
	"LOSSY_RGB_PRECISION\0" /* 35868 */
	"LOSSY_ALPHA_PRECISION\0" /* 35888 */
	"DRAW_INDEX_LOC\0" /* 35910 */
	"IB_BASE_LO\0" /* 35925 */
	"IB_BASE_HI\0" /* 35936 */
	"CP_DMA_WORD0\0" /* 35947 */
	"CP_DMA_WORD1\0" /* 35960 */
	"CP_DMA_WORD2\0" /* 35973 */
	"CP_DMA_WORD3\0" /* 35986 */
	"COMMAND\0" /* 35999 */
	"DMA_DATA_WORD0\0" /* 36007 */
	"SRBM_STATUS2\0" /* 36022 */
	"SRBM_STATUS\0" /* 36035 */
	"SRBM_STATUS3\0" /* 36047 */
	"SDMA0_STATUS_REG\0" /* 36060 */
	"SDMA1_STATUS_REG\0" /* 36077 */
	"GRBM_STATUS2\0" /* 36094 */
	"GRBM_STATUS\0" /* 36107 */
	"CP_STRMOUT_CNTL\0" /* 36119 */
	"CP_COHER_CNTL\0" /* 36135 */
	"CP_COHER_SIZE\0" /* 36149 */
	"CP_COHER_BASE\0" /* 36163 */
	"GRBM_STATUS_SE0\0" /* 36177 */
	"GRBM_STATUS_SE1\0" /* 36193 */
	"GRBM_STATUS_SE2\0" /* 36209 */
	"GRBM_STATUS_SE3\0" /* 36225 */
	"CP_COHER_BASE_HI\0" /* 36241 */
	"CP_COHER_START_DELAY\0" /* 36258 */
	"CP_COHER_STATUS\0" /* 36279 */
	"CP_CPC_STATUS\0" /* 36295 */
	"CP_CPC_BUSY_STAT\0" /* 36309 */
	"CP_CPC_STALLED_STAT1\0" /* 36326 */
	"CP_CPF_STATUS\0" /* 36347 */
	"CP_CPF_BUSY_STAT\0" /* 36361 */
	"CP_CPF_STALLED_STAT1\0" /* 36378 */
	"CP_COHER_SIZE_HI\0" /* 36399 */
	"VGT_VTX_VECT_EJECT_REG\0" /* 36416 */
	"VGT_CACHE_INVALIDATION\0" /* 36439 */
	"VGT_ESGS_RING_SIZE\0" /* 36462 */
	"VGT_GSVS_RING_SIZE\0" /* 36481 */
	"VGT_GS_VERTEX_REUSE\0" /* 36500 */
	"VGT_PRIMITIVE_TYPE\0" /* 36520 */
	"VGT_INDEX_TYPE\0" /* 36539 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_0\0" /* 36554 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_1\0" /* 36587 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_2\0" /* 36620 */
	"VGT_STRMOUT_BUFFER_FILLED_SIZE_3\0" /* 36653 */
	"VGT_NUM_INDICES\0" /* 36686 */
	"VGT_NUM_INSTANCES\0" /* 36702 */
	"VGT_TF_RING_SIZE\0" /* 36720 */
	"VGT_HS_OFFCHIP_PARAM\0" /* 36737 */
	"VGT_TF_MEMORY_BASE\0" /* 36758 */
	"PA_CL_ENHANCE\0" /* 36777 */
	"PA_SU_LINE_STIPPLE_VALUE\0" /* 36791 */
	"PA_SC_LINE_STIPPLE_STATE\0" /* 36816 */
	"CP_STALLED_STAT3\0" /* 36841 */
	"CP_STALLED_STAT1\0" /* 36858 */
	"CP_STALLED_STAT2\0" /* 36875 */
	"CP_STAT\0" /* 36892 */
	"GRBM_GFX_INDEX\0" /* 36900 */
	"PA_SC_SCREEN_EXTENT_MIN_0\0" /* 36915 */
	"PA_SC_SCREEN_EXTENT_MAX_0\0" /* 36941 */
	"PA_SC_SCREEN_EXTENT_MIN_1\0" /* 36967 */
	"PA_SC_SCREEN_EXTENT_MAX_1\0" /* 36993 */
	"PA_SC_ENHANCE\0" /* 37019 */
	"SQC_CACHES\0" /* 37033 */
	"SQ_RANDOM_WAVE_PRI\0" /* 37044 */
	"SQ_EXP_0\0" /* 37063 */
	"TA_CS_BC_BASE_ADDR\0" /* 37072 */
	"TA_CS_BC_BASE_ADDR_HI\0" /* 37091 */
	"DB_OCCLUSION_COUNT0_LOW\0" /* 37113 */
	"SQ_BUF_RSRC_WORD0\0" /* 37137 */
	"DB_OCCLUSION_COUNT0_HI\0" /* 37155 */
	"SQ_BUF_RSRC_WORD1\0" /* 37178 */
	"DB_OCCLUSION_COUNT1_LOW\0" /* 37196 */
	"SQ_BUF_RSRC_WORD2\0" /* 37220 */
	"DB_OCCLUSION_COUNT1_HI\0" /* 37238 */
	"SQ_BUF_RSRC_WORD3\0" /* 37261 */
	"DB_OCCLUSION_COUNT2_LOW\0" /* 37279 */
	"SQ_IMG_RSRC_WORD0\0" /* 37303 */
	"DB_OCCLUSION_COUNT2_HI\0" /* 37321 */
	"SQ_IMG_RSRC_WORD1\0" /* 37344 */
	"DB_OCCLUSION_COUNT3_LOW\0" /* 37362 */
	"SQ_IMG_RSRC_WORD2\0" /* 37386 */
	"DB_OCCLUSION_COUNT3_HI\0" /* 37404 */
	"SQ_IMG_RSRC_WORD3\0" /* 37427 */
	"SQ_IMG_RSRC_WORD4\0" /* 37445 */
	"SQ_IMG_RSRC_WORD5\0" /* 37463 */
	"SQ_IMG_RSRC_WORD6\0" /* 37481 */
	"SQ_IMG_RSRC_WORD7\0" /* 37499 */
	"SQ_IMG_SAMP_WORD0\0" /* 37517 */
	"SQ_IMG_SAMP_WORD1\0" /* 37535 */
	"SQ_IMG_SAMP_WORD2\0" /* 37553 */
	"SQ_IMG_SAMP_WORD3\0" /* 37571 */
	"SPI_DYN_GPR_LOCK_EN\0" /* 37589 */
	"SPI_STATIC_THREAD_MGMT_1\0" /* 37609 */
	"SPI_STATIC_THREAD_MGMT_2\0" /* 37634 */
	"SPI_STATIC_THREAD_MGMT_3\0" /* 37659 */
	"SPI_PS_MAX_WAVE_ID\0" /* 37684 */
	"SPI_ARB_PRIORITY\0" /* 37703 */
	"SPI_ARB_CYCLES_0\0" /* 37720 */
	"SPI_ARB_CYCLES_1\0" /* 37737 */
	"SQ_FLAT_SCRATCH_WORD0\0" /* 37754 */
	"SQ_FLAT_SCRATCH_WORD1\0" /* 37776 */
	"DB_ZPASS_COUNT_LOW\0" /* 37798 */
	"DB_ZPASS_COUNT_HI\0" /* 37817 */
	"SPI_CONFIG_CNTL\0" /* 37835 */
	"SPI_CONFIG_CNTL_1\0" /* 37851 */
	"SPI_RESOURCE_RESERVE_CU_AB_0\0" /* 37869 */
	"DB_SUBTILE_CONTROL\0" /* 37898 */
	"GB_ADDR_CONFIG\0" /* 37917 */
	"GB_TILE_MODE0\0" /* 37932 */
	"GB_TILE_MODE1\0" /* 37946 */
	"GB_TILE_MODE2\0" /* 37960 */
	"GB_TILE_MODE3\0" /* 37974 */
	"GB_TILE_MODE4\0" /* 37988 */
	"GB_TILE_MODE5\0" /* 38002 */
	"GB_TILE_MODE6\0" /* 38016 */
	"GB_TILE_MODE7\0" /* 38030 */
	"GB_TILE_MODE8\0" /* 38044 */
	"GB_TILE_MODE9\0" /* 38058 */
	"GB_TILE_MODE10\0" /* 38072 */
	"GB_TILE_MODE11\0" /* 38087 */
	"GB_TILE_MODE12\0" /* 38102 */
	"GB_TILE_MODE13\0" /* 38117 */
	"GB_TILE_MODE14\0" /* 38132 */
	"GB_TILE_MODE15\0" /* 38147 */
	"GB_TILE_MODE16\0" /* 38162 */
	"GB_TILE_MODE17\0" /* 38177 */
	"GB_TILE_MODE18\0" /* 38192 */
	"GB_TILE_MODE19\0" /* 38207 */
	"GB_TILE_MODE20\0" /* 38222 */
	"GB_TILE_MODE21\0" /* 38237 */
	"GB_TILE_MODE22\0" /* 38252 */
	"GB_TILE_MODE23\0" /* 38267 */
	"GB_TILE_MODE24\0" /* 38282 */
	"GB_TILE_MODE25\0" /* 38297 */
	"GB_TILE_MODE26\0" /* 38312 */
	"GB_TILE_MODE27\0" /* 38327 */
	"GB_TILE_MODE28\0" /* 38342 */
	"GB_TILE_MODE29\0" /* 38357 */
	"GB_TILE_MODE30\0" /* 38372 */
	"GB_TILE_MODE31\0" /* 38387 */
	"GB_MACROTILE_MODE0\0" /* 38402 */
	"GB_MACROTILE_MODE1\0" /* 38421 */
	"GB_MACROTILE_MODE2\0" /* 38440 */
	"GB_MACROTILE_MODE3\0" /* 38459 */
	"GB_MACROTILE_MODE4\0" /* 38478 */
	"GB_MACROTILE_MODE5\0" /* 38497 */
	"GB_MACROTILE_MODE6\0" /* 38516 */
	"GB_MACROTILE_MODE7\0" /* 38535 */
	"GB_MACROTILE_MODE8\0" /* 38554 */
	"GB_MACROTILE_MODE9\0" /* 38573 */
	"GB_MACROTILE_MODE10\0" /* 38592 */
	"GB_MACROTILE_MODE11\0" /* 38612 */
	"GB_MACROTILE_MODE12\0" /* 38632 */
	"GB_MACROTILE_MODE13\0" /* 38652 */
	"GB_MACROTILE_MODE14\0" /* 38672 */
	"GB_MACROTILE_MODE15\0" /* 38692 */
	"SPI_SHADER_TBA_LO_PS\0" /* 38712 */
	"SPI_SHADER_TBA_HI_PS\0" /* 38733 */
	"SPI_SHADER_TMA_LO_PS\0" /* 38754 */
	"SPI_SHADER_TMA_HI_PS\0" /* 38775 */
	"SPI_SHADER_PGM_RSRC3_PS\0" /* 38796 */
	"SPI_SHADER_PGM_LO_PS\0" /* 38820 */
	"SPI_SHADER_PGM_HI_PS\0" /* 38841 */
	"SPI_SHADER_PGM_RSRC1_PS\0" /* 38862 */
	"SPI_SHADER_PGM_RSRC2_PS\0" /* 38886 */
	"SPI_SHADER_USER_DATA_PS_0\0" /* 38910 */
	"SPI_SHADER_USER_DATA_PS_1\0" /* 38936 */
	"SPI_SHADER_USER_DATA_PS_2\0" /* 38962 */
	"SPI_SHADER_USER_DATA_PS_3\0" /* 38988 */
	"SPI_SHADER_USER_DATA_PS_4\0" /* 39014 */
	"SPI_SHADER_USER_DATA_PS_5\0" /* 39040 */
	"SPI_SHADER_USER_DATA_PS_6\0" /* 39066 */
	"SPI_SHADER_USER_DATA_PS_7\0" /* 39092 */
	"SPI_SHADER_USER_DATA_PS_8\0" /* 39118 */
	"SPI_SHADER_USER_DATA_PS_9\0" /* 39144 */
	"SPI_SHADER_USER_DATA_PS_10\0" /* 39170 */
	"SPI_SHADER_USER_DATA_PS_11\0" /* 39197 */
	"SPI_SHADER_USER_DATA_PS_12\0" /* 39224 */
	"SPI_SHADER_USER_DATA_PS_13\0" /* 39251 */
	"SPI_SHADER_USER_DATA_PS_14\0" /* 39278 */
	"SPI_SHADER_USER_DATA_PS_15\0" /* 39305 */
	"SPI_SHADER_TBA_LO_VS\0" /* 39332 */
	"SPI_SHADER_TBA_HI_VS\0" /* 39353 */
	"SPI_SHADER_TMA_LO_VS\0" /* 39374 */
	"SPI_SHADER_TMA_HI_VS\0" /* 39395 */
	"SPI_SHADER_PGM_RSRC3_VS\0" /* 39416 */
	"SPI_SHADER_LATE_ALLOC_VS\0" /* 39440 */
	"SPI_SHADER_PGM_LO_VS\0" /* 39465 */
	"SPI_SHADER_PGM_HI_VS\0" /* 39486 */
	"SPI_SHADER_PGM_RSRC1_VS\0" /* 39507 */
	"SPI_SHADER_PGM_RSRC2_VS\0" /* 39531 */
	"SPI_SHADER_USER_DATA_VS_0\0" /* 39555 */
	"SPI_SHADER_USER_DATA_VS_1\0" /* 39581 */
	"SPI_SHADER_USER_DATA_VS_2\0" /* 39607 */
	"SPI_SHADER_USER_DATA_VS_3\0" /* 39633 */
	"SPI_SHADER_USER_DATA_VS_4\0" /* 39659 */
	"SPI_SHADER_USER_DATA_VS_5\0" /* 39685 */
	"SPI_SHADER_USER_DATA_VS_6\0" /* 39711 */
	"SPI_SHADER_USER_DATA_VS_7\0" /* 39737 */
	"SPI_SHADER_USER_DATA_VS_8\0" /* 39763 */
	"SPI_SHADER_USER_DATA_VS_9\0" /* 39789 */
	"SPI_SHADER_USER_DATA_VS_10\0" /* 39815 */
	"SPI_SHADER_USER_DATA_VS_11\0" /* 39842 */
	"SPI_SHADER_USER_DATA_VS_12\0" /* 39869 */
	"SPI_SHADER_USER_DATA_VS_13\0" /* 39896 */
	"SPI_SHADER_USER_DATA_VS_14\0" /* 39923 */
	"SPI_SHADER_USER_DATA_VS_15\0" /* 39950 */
	"SPI_SHADER_TBA_LO_GS\0" /* 39977 */
	"SPI_SHADER_TBA_HI_GS\0" /* 39998 */
	"SPI_SHADER_TMA_LO_GS\0" /* 40019 */
	"SPI_SHADER_TMA_HI_GS\0" /* 40040 */
	"SPI_SHADER_PGM_RSRC3_GS\0" /* 40061 */
	"SPI_SHADER_PGM_LO_GS\0" /* 40085 */
	"SPI_SHADER_PGM_HI_GS\0" /* 40106 */
	"SPI_SHADER_PGM_RSRC1_GS\0" /* 40127 */
	"SPI_SHADER_PGM_RSRC2_GS\0" /* 40151 */
	"SPI_SHADER_USER_DATA_GS_0\0" /* 40175 */
	"SPI_SHADER_USER_DATA_GS_1\0" /* 40201 */
	"SPI_SHADER_USER_DATA_GS_2\0" /* 40227 */
	"SPI_SHADER_USER_DATA_GS_3\0" /* 40253 */
	"SPI_SHADER_USER_DATA_GS_4\0" /* 40279 */
	"SPI_SHADER_USER_DATA_GS_5\0" /* 40305 */
	"SPI_SHADER_USER_DATA_GS_6\0" /* 40331 */
	"SPI_SHADER_USER_DATA_GS_7\0" /* 40357 */
	"SPI_SHADER_USER_DATA_GS_8\0" /* 40383 */
	"SPI_SHADER_USER_DATA_GS_9\0" /* 40409 */
	"SPI_SHADER_USER_DATA_GS_10\0" /* 40435 */
	"SPI_SHADER_USER_DATA_GS_11\0" /* 40462 */
	"SPI_SHADER_USER_DATA_GS_12\0" /* 40489 */
	"SPI_SHADER_USER_DATA_GS_13\0" /* 40516 */
	"SPI_SHADER_USER_DATA_GS_14\0" /* 40543 */
	"SPI_SHADER_USER_DATA_GS_15\0" /* 40570 */
	"SPI_SHADER_TBA_LO_ES\0" /* 40597 */
	"SPI_SHADER_TBA_HI_ES\0" /* 40618 */
	"SPI_SHADER_TMA_LO_ES\0" /* 40639 */
	"SPI_SHADER_TMA_HI_ES\0" /* 40660 */
	"SPI_SHADER_PGM_RSRC3_ES\0" /* 40681 */
	"SPI_SHADER_PGM_LO_ES\0" /* 40705 */
	"SPI_SHADER_PGM_HI_ES\0" /* 40726 */
	"SPI_SHADER_PGM_RSRC1_ES\0" /* 40747 */
	"SPI_SHADER_PGM_RSRC2_ES\0" /* 40771 */
	"SPI_SHADER_USER_DATA_ES_0\0" /* 40795 */
	"SPI_SHADER_USER_DATA_ES_1\0" /* 40821 */
	"SPI_SHADER_USER_DATA_ES_2\0" /* 40847 */
	"SPI_SHADER_USER_DATA_ES_3\0" /* 40873 */
	"SPI_SHADER_USER_DATA_ES_4\0" /* 40899 */
	"SPI_SHADER_USER_DATA_ES_5\0" /* 40925 */
	"SPI_SHADER_USER_DATA_ES_6\0" /* 40951 */
	"SPI_SHADER_USER_DATA_ES_7\0" /* 40977 */
	"SPI_SHADER_USER_DATA_ES_8\0" /* 41003 */
	"SPI_SHADER_USER_DATA_ES_9\0" /* 41029 */
	"SPI_SHADER_USER_DATA_ES_10\0" /* 41055 */
	"SPI_SHADER_USER_DATA_ES_11\0" /* 41082 */
	"SPI_SHADER_USER_DATA_ES_12\0" /* 41109 */
	"SPI_SHADER_USER_DATA_ES_13\0" /* 41136 */
	"SPI_SHADER_USER_DATA_ES_14\0" /* 41163 */
	"SPI_SHADER_USER_DATA_ES_15\0" /* 41190 */
	"SPI_SHADER_TBA_LO_HS\0" /* 41217 */
	"SPI_SHADER_TBA_HI_HS\0" /* 41238 */
	"SPI_SHADER_TMA_LO_HS\0" /* 41259 */
	"SPI_SHADER_TMA_HI_HS\0" /* 41280 */
	"SPI_SHADER_PGM_RSRC3_HS\0" /* 41301 */
	"SPI_SHADER_PGM_LO_HS\0" /* 41325 */
	"SPI_SHADER_PGM_HI_HS\0" /* 41346 */
	"SPI_SHADER_PGM_RSRC1_HS\0" /* 41367 */
	"SPI_SHADER_PGM_RSRC2_HS\0" /* 41391 */
	"SPI_SHADER_USER_DATA_HS_0\0" /* 41415 */
	"SPI_SHADER_USER_DATA_HS_1\0" /* 41441 */
	"SPI_SHADER_USER_DATA_HS_2\0" /* 41467 */
	"SPI_SHADER_USER_DATA_HS_3\0" /* 41493 */
	"SPI_SHADER_USER_DATA_HS_4\0" /* 41519 */
	"SPI_SHADER_USER_DATA_HS_5\0" /* 41545 */
	"SPI_SHADER_USER_DATA_HS_6\0" /* 41571 */
	"SPI_SHADER_USER_DATA_HS_7\0" /* 41597 */
	"SPI_SHADER_USER_DATA_HS_8\0" /* 41623 */
	"SPI_SHADER_USER_DATA_HS_9\0" /* 41649 */
	"SPI_SHADER_USER_DATA_HS_10\0" /* 41675 */
	"SPI_SHADER_USER_DATA_HS_11\0" /* 41702 */
	"SPI_SHADER_USER_DATA_HS_12\0" /* 41729 */
	"SPI_SHADER_USER_DATA_HS_13\0" /* 41756 */
	"SPI_SHADER_USER_DATA_HS_14\0" /* 41783 */
	"SPI_SHADER_USER_DATA_HS_15\0" /* 41810 */
	"SPI_SHADER_TBA_LO_LS\0" /* 41837 */
	"SPI_SHADER_TBA_HI_LS\0" /* 41858 */
	"SPI_SHADER_TMA_LO_LS\0" /* 41879 */
	"SPI_SHADER_TMA_HI_LS\0" /* 41900 */
	"SPI_SHADER_PGM_RSRC3_LS\0" /* 41921 */
	"SPI_SHADER_PGM_LO_LS\0" /* 41945 */
	"SPI_SHADER_PGM_HI_LS\0" /* 41966 */
	"SPI_SHADER_PGM_RSRC1_LS\0" /* 41987 */
	"SPI_SHADER_PGM_RSRC2_LS\0" /* 42011 */
	"SPI_SHADER_USER_DATA_LS_0\0" /* 42035 */
	"SPI_SHADER_USER_DATA_LS_1\0" /* 42061 */
	"SPI_SHADER_USER_DATA_LS_2\0" /* 42087 */
	"SPI_SHADER_USER_DATA_LS_3\0" /* 42113 */
	"SPI_SHADER_USER_DATA_LS_4\0" /* 42139 */
	"SPI_SHADER_USER_DATA_LS_5\0" /* 42165 */
	"SPI_SHADER_USER_DATA_LS_6\0" /* 42191 */
	"SPI_SHADER_USER_DATA_LS_7\0" /* 42217 */
	"SPI_SHADER_USER_DATA_LS_8\0" /* 42243 */
	"SPI_SHADER_USER_DATA_LS_9\0" /* 42269 */
	"SPI_SHADER_USER_DATA_LS_10\0" /* 42295 */
	"SPI_SHADER_USER_DATA_LS_11\0" /* 42322 */
	"SPI_SHADER_USER_DATA_LS_12\0" /* 42349 */
	"SPI_SHADER_USER_DATA_LS_13\0" /* 42376 */
	"SPI_SHADER_USER_DATA_LS_14\0" /* 42403 */
	"SPI_SHADER_USER_DATA_LS_15\0" /* 42430 */
	"COMPUTE_DISPATCH_INITIATOR\0" /* 42457 */
	"COMPUTE_DIM_X\0" /* 42484 */
	"COMPUTE_DIM_Y\0" /* 42498 */
	"COMPUTE_DIM_Z\0" /* 42512 */
	"COMPUTE_START_X\0" /* 42526 */
	"COMPUTE_START_Y\0" /* 42542 */
	"COMPUTE_START_Z\0" /* 42558 */
	"COMPUTE_NUM_THREAD_X\0" /* 42574 */
	"COMPUTE_NUM_THREAD_Y\0" /* 42595 */
	"COMPUTE_NUM_THREAD_Z\0" /* 42616 */
	"COMPUTE_MAX_WAVE_ID\0" /* 42637 */
	"COMPUTE_PIPELINESTAT_ENABLE\0" /* 42657 */
	"COMPUTE_PERFCOUNT_ENABLE\0" /* 42685 */
	"COMPUTE_PGM_LO\0" /* 42710 */
	"COMPUTE_PGM_HI\0" /* 42725 */
	"COMPUTE_TBA_LO\0" /* 42740 */
	"COMPUTE_TBA_HI\0" /* 42755 */
	"COMPUTE_TMA_LO\0" /* 42770 */
	"COMPUTE_TMA_HI\0" /* 42785 */
	"COMPUTE_PGM_RSRC1\0" /* 42800 */
	"COMPUTE_PGM_RSRC2\0" /* 42818 */
	"COMPUTE_VMID\0" /* 42836 */
	"COMPUTE_RESOURCE_LIMITS\0" /* 42849 */
	"COMPUTE_STATIC_THREAD_MGMT_SE0\0" /* 42873 */
	"COMPUTE_STATIC_THREAD_MGMT_SE1\0" /* 42904 */
	"COMPUTE_TMPRING_SIZE\0" /* 42935 */
	"COMPUTE_STATIC_THREAD_MGMT_SE2\0" /* 42956 */
	"COMPUTE_STATIC_THREAD_MGMT_SE3\0" /* 42987 */
	"COMPUTE_RESTART_X\0" /* 43018 */
	"COMPUTE_RESTART_Y\0" /* 43036 */
	"COMPUTE_RESTART_Z\0" /* 43054 */
	"COMPUTE_MISC_RESERVED\0" /* 43072 */
	"COMPUTE_DISPATCH_ID\0" /* 43094 */
	"COMPUTE_THREADGROUP_ID\0" /* 43114 */
	"COMPUTE_RELAUNCH\0" /* 43137 */
	"COMPUTE_WAVE_RESTORE_ADDR_LO\0" /* 43154 */
	"COMPUTE_WAVE_RESTORE_ADDR_HI\0" /* 43183 */
	"COMPUTE_WAVE_RESTORE_CONTROL\0" /* 43212 */
	"COMPUTE_USER_DATA_0\0" /* 43241 */
	"COMPUTE_USER_DATA_1\0" /* 43261 */
	"COMPUTE_USER_DATA_2\0" /* 43281 */
	"COMPUTE_USER_DATA_3\0" /* 43301 */
	"COMPUTE_USER_DATA_4\0" /* 43321 */
	"COMPUTE_USER_DATA_5\0" /* 43341 */
	"COMPUTE_USER_DATA_6\0" /* 43361 */
	"COMPUTE_USER_DATA_7\0" /* 43381 */
	"COMPUTE_USER_DATA_8\0" /* 43401 */
	"COMPUTE_USER_DATA_9\0" /* 43421 */
	"COMPUTE_USER_DATA_10\0" /* 43441 */
	"COMPUTE_USER_DATA_11\0" /* 43462 */
	"COMPUTE_USER_DATA_12\0" /* 43483 */
	"COMPUTE_USER_DATA_13\0" /* 43504 */
	"COMPUTE_USER_DATA_14\0" /* 43525 */
	"COMPUTE_USER_DATA_15\0" /* 43546 */
	"COMPUTE_NOWHERE\0" /* 43567 */
	"CPG_PERFCOUNTER1_LO\0" /* 43583 */
	"CPG_PERFCOUNTER1_HI\0" /* 43603 */
	"CPG_PERFCOUNTER0_LO\0" /* 43623 */
	"CPG_PERFCOUNTER0_HI\0" /* 43643 */
	"CPC_PERFCOUNTER1_LO\0" /* 43663 */
	"CPC_PERFCOUNTER1_HI\0" /* 43683 */
	"CPC_PERFCOUNTER0_LO\0" /* 43703 */
	"CPC_PERFCOUNTER0_HI\0" /* 43723 */
	"CPF_PERFCOUNTER1_LO\0" /* 43743 */
	"CPF_PERFCOUNTER1_HI\0" /* 43763 */
	"CPF_PERFCOUNTER0_LO\0" /* 43783 */
	"CPF_PERFCOUNTER0_HI\0" /* 43803 */
	"GRBM_PERFCOUNTER0_LO\0" /* 43823 */
	"GRBM_PERFCOUNTER0_HI\0" /* 43844 */
	"GRBM_PERFCOUNTER1_LO\0" /* 43865 */
	"GRBM_PERFCOUNTER1_HI\0" /* 43886 */
	"GRBM_SE0_PERFCOUNTER_LO\0" /* 43907 */
	"GRBM_SE0_PERFCOUNTER_HI\0" /* 43931 */
	"GRBM_SE1_PERFCOUNTER_LO\0" /* 43955 */
	"GRBM_SE1_PERFCOUNTER_HI\0" /* 43979 */
	"GRBM_SE2_PERFCOUNTER_LO\0" /* 44003 */
	"GRBM_SE2_PERFCOUNTER_HI\0" /* 44027 */
	"GRBM_SE3_PERFCOUNTER_LO\0" /* 44051 */
	"GRBM_SE3_PERFCOUNTER_HI\0" /* 44075 */
	"WD_PERFCOUNTER0_LO\0" /* 44099 */
	"WD_PERFCOUNTER0_HI\0" /* 44118 */
	"WD_PERFCOUNTER1_LO\0" /* 44137 */
	"WD_PERFCOUNTER1_HI\0" /* 44156 */
	"WD_PERFCOUNTER2_LO\0" /* 44175 */
	"WD_PERFCOUNTER2_HI\0" /* 44194 */
	"WD_PERFCOUNTER3_LO\0" /* 44213 */
	"WD_PERFCOUNTER3_HI\0" /* 44232 */
	"IA_PERFCOUNTER0_LO\0" /* 44251 */
	"IA_PERFCOUNTER0_HI\0" /* 44270 */
	"IA_PERFCOUNTER1_LO\0" /* 44289 */
	"IA_PERFCOUNTER1_HI\0" /* 44308 */
	"IA_PERFCOUNTER2_LO\0" /* 44327 */
	"IA_PERFCOUNTER2_HI\0" /* 44346 */
	"IA_PERFCOUNTER3_LO\0" /* 44365 */
	"IA_PERFCOUNTER3_HI\0" /* 44384 */
	"VGT_PERFCOUNTER0_LO\0" /* 44403 */
	"VGT_PERFCOUNTER0_HI\0" /* 44423 */
	"VGT_PERFCOUNTER1_LO\0" /* 44443 */
	"VGT_PERFCOUNTER1_HI\0" /* 44463 */
	"VGT_PERFCOUNTER2_LO\0" /* 44483 */
	"VGT_PERFCOUNTER2_HI\0" /* 44503 */
	"VGT_PERFCOUNTER3_LO\0" /* 44523 */
	"VGT_PERFCOUNTER3_HI\0" /* 44543 */
	"PA_SU_PERFCOUNTER0_LO\0" /* 44563 */
	"PA_SU_PERFCOUNTER0_HI\0" /* 44585 */
	"PA_SU_PERFCOUNTER1_LO\0" /* 44607 */
	"PA_SU_PERFCOUNTER1_HI\0" /* 44629 */
	"PA_SU_PERFCOUNTER2_LO\0" /* 44651 */
	"PA_SU_PERFCOUNTER2_HI\0" /* 44673 */
	"PA_SU_PERFCOUNTER3_LO\0" /* 44695 */
	"PA_SU_PERFCOUNTER3_HI\0" /* 44717 */
	"PA_SC_PERFCOUNTER0_LO\0" /* 44739 */
	"PA_SC_PERFCOUNTER0_HI\0" /* 44761 */
	"PA_SC_PERFCOUNTER1_LO\0" /* 44783 */
	"PA_SC_PERFCOUNTER1_HI\0" /* 44805 */
	"PA_SC_PERFCOUNTER2_LO\0" /* 44827 */
	"PA_SC_PERFCOUNTER2_HI\0" /* 44849 */
	"PA_SC_PERFCOUNTER3_LO\0" /* 44871 */
	"PA_SC_PERFCOUNTER3_HI\0" /* 44893 */
	"PA_SC_PERFCOUNTER4_LO\0" /* 44915 */
	"PA_SC_PERFCOUNTER4_HI\0" /* 44937 */
	"PA_SC_PERFCOUNTER5_LO\0" /* 44959 */
	"PA_SC_PERFCOUNTER5_HI\0" /* 44981 */
	"PA_SC_PERFCOUNTER6_LO\0" /* 45003 */
	"PA_SC_PERFCOUNTER6_HI\0" /* 45025 */
	"PA_SC_PERFCOUNTER7_LO\0" /* 45047 */
	"PA_SC_PERFCOUNTER7_HI\0" /* 45069 */
	"SPI_PERFCOUNTER0_HI\0" /* 45091 */
	"SPI_PERFCOUNTER0_LO\0" /* 45111 */
	"SPI_PERFCOUNTER1_HI\0" /* 45131 */
	"SPI_PERFCOUNTER1_LO\0" /* 45151 */
	"SPI_PERFCOUNTER2_HI\0" /* 45171 */
	"SPI_PERFCOUNTER2_LO\0" /* 45191 */
	"SPI_PERFCOUNTER3_HI\0" /* 45211 */
	"SPI_PERFCOUNTER3_LO\0" /* 45231 */
	"SPI_PERFCOUNTER4_HI\0" /* 45251 */
	"SPI_PERFCOUNTER4_LO\0" /* 45271 */
	"SPI_PERFCOUNTER5_HI\0" /* 45291 */
	"SPI_PERFCOUNTER5_LO\0" /* 45311 */
	"SQ_PERFCOUNTER0_LO\0" /* 45331 */
	"SQ_PERFCOUNTER0_HI\0" /* 45350 */
	"SQ_PERFCOUNTER1_LO\0" /* 45369 */
	"SQ_PERFCOUNTER1_HI\0" /* 45388 */
	"SQ_PERFCOUNTER2_LO\0" /* 45407 */
	"SQ_PERFCOUNTER2_HI\0" /* 45426 */
	"SQ_PERFCOUNTER3_LO\0" /* 45445 */
	"SQ_PERFCOUNTER3_HI\0" /* 45464 */
	"SQ_PERFCOUNTER4_LO\0" /* 45483 */
	"SQ_PERFCOUNTER4_HI\0" /* 45502 */
	"SQ_PERFCOUNTER5_LO\0" /* 45521 */
	"SQ_PERFCOUNTER5_HI\0" /* 45540 */
	"SQ_PERFCOUNTER6_LO\0" /* 45559 */
	"SQ_PERFCOUNTER6_HI\0" /* 45578 */
	"SQ_PERFCOUNTER7_LO\0" /* 45597 */
	"SQ_PERFCOUNTER7_HI\0" /* 45616 */
	"SQ_PERFCOUNTER8_LO\0" /* 45635 */
	"SQ_PERFCOUNTER8_HI\0" /* 45654 */
	"SQ_PERFCOUNTER9_LO\0" /* 45673 */
	"SQ_PERFCOUNTER9_HI\0" /* 45692 */
	"SQ_PERFCOUNTER10_LO\0" /* 45711 */
	"SQ_PERFCOUNTER10_HI\0" /* 45731 */
	"SQ_PERFCOUNTER11_LO\0" /* 45751 */
	"SQ_PERFCOUNTER11_HI\0" /* 45771 */
	"SQ_PERFCOUNTER12_LO\0" /* 45791 */
	"SQ_PERFCOUNTER12_HI\0" /* 45811 */
	"SQ_PERFCOUNTER13_LO\0" /* 45831 */
	"SQ_PERFCOUNTER13_HI\0" /* 45851 */
	"SQ_PERFCOUNTER14_LO\0" /* 45871 */
	"SQ_PERFCOUNTER14_HI\0" /* 45891 */
	"SQ_PERFCOUNTER15_LO\0" /* 45911 */
	"SQ_PERFCOUNTER15_HI\0" /* 45931 */
	"SX_PERFCOUNTER0_LO\0" /* 45951 */
	"SX_PERFCOUNTER0_HI\0" /* 45970 */
	"SX_PERFCOUNTER1_LO\0" /* 45989 */
	"SX_PERFCOUNTER1_HI\0" /* 46008 */
	"SX_PERFCOUNTER2_LO\0" /* 46027 */
	"SX_PERFCOUNTER2_HI\0" /* 46046 */
	"SX_PERFCOUNTER3_LO\0" /* 46065 */
	"SX_PERFCOUNTER3_HI\0" /* 46084 */
	"GDS_PERFCOUNTER0_LO\0" /* 46103 */
	"GDS_PERFCOUNTER0_HI\0" /* 46123 */
	"GDS_PERFCOUNTER1_LO\0" /* 46143 */
	"GDS_PERFCOUNTER1_HI\0" /* 46163 */
	"GDS_PERFCOUNTER2_LO\0" /* 46183 */
	"GDS_PERFCOUNTER2_HI\0" /* 46203 */
	"GDS_PERFCOUNTER3_LO\0" /* 46223 */
	"GDS_PERFCOUNTER3_HI\0" /* 46243 */
	"TA_PERFCOUNTER0_LO\0" /* 46263 */
	"TA_PERFCOUNTER0_HI\0" /* 46282 */
	"TA_PERFCOUNTER1_LO\0" /* 46301 */
	"TA_PERFCOUNTER1_HI\0" /* 46320 */
	"TD_PERFCOUNTER0_LO\0" /* 46339 */
	"TD_PERFCOUNTER0_HI\0" /* 46358 */
	"TD_PERFCOUNTER1_LO\0" /* 46377 */
	"TD_PERFCOUNTER1_HI\0" /* 46396 */
	"TCP_PERFCOUNTER0_LO\0" /* 46415 */
	"TCP_PERFCOUNTER0_HI\0" /* 46435 */
	"TCP_PERFCOUNTER1_LO\0" /* 46455 */
	"TCP_PERFCOUNTER1_HI\0" /* 46475 */
	"TCP_PERFCOUNTER2_LO\0" /* 46495 */
	"TCP_PERFCOUNTER2_HI\0" /* 46515 */
	"TCP_PERFCOUNTER3_LO\0" /* 46535 */
	"TCP_PERFCOUNTER3_HI\0" /* 46555 */
	"TCC_PERFCOUNTER0_LO\0" /* 46575 */
	"TCC_PERFCOUNTER0_HI\0" /* 46595 */
	"TCC_PERFCOUNTER1_LO\0" /* 46615 */
	"TCC_PERFCOUNTER1_HI\0" /* 46635 */
	"TCC_PERFCOUNTER2_LO\0" /* 46655 */
	"TCC_PERFCOUNTER2_HI\0" /* 46675 */
	"TCC_PERFCOUNTER3_LO\0" /* 46695 */
	"TCC_PERFCOUNTER3_HI\0" /* 46715 */
	"TCA_PERFCOUNTER0_LO\0" /* 46735 */
	"TCA_PERFCOUNTER0_HI\0" /* 46755 */
	"TCA_PERFCOUNTER1_LO\0" /* 46775 */
	"TCA_PERFCOUNTER1_HI\0" /* 46795 */
	"TCA_PERFCOUNTER2_LO\0" /* 46815 */
	"TCA_PERFCOUNTER2_HI\0" /* 46835 */
	"TCA_PERFCOUNTER3_LO\0" /* 46855 */
	"TCA_PERFCOUNTER3_HI\0" /* 46875 */
	"CB_PERFCOUNTER0_LO\0" /* 46895 */
	"CB_PERFCOUNTER0_HI\0" /* 46914 */
	"CB_PERFCOUNTER1_LO\0" /* 46933 */
	"CB_PERFCOUNTER1_HI\0" /* 46952 */
	"CB_PERFCOUNTER2_LO\0" /* 46971 */
	"CB_PERFCOUNTER2_HI\0" /* 46990 */
	"CB_PERFCOUNTER3_LO\0" /* 47009 */
	"CB_PERFCOUNTER3_HI\0" /* 47028 */
	"DB_PERFCOUNTER0_LO\0" /* 47047 */
	"DB_PERFCOUNTER0_HI\0" /* 47066 */
	"DB_PERFCOUNTER1_LO\0" /* 47085 */
	"DB_PERFCOUNTER1_HI\0" /* 47104 */
	"DB_PERFCOUNTER2_LO\0" /* 47123 */
	"DB_PERFCOUNTER2_HI\0" /* 47142 */
	"DB_PERFCOUNTER3_LO\0" /* 47161 */
	"DB_PERFCOUNTER3_HI\0" /* 47180 */
	"RLC_PERFCOUNTER0_LO\0" /* 47199 */
	"RLC_PERFCOUNTER0_HI\0" /* 47219 */
	"RLC_PERFCOUNTER1_LO\0" /* 47239 */
	"RLC_PERFCOUNTER1_HI\0" /* 47259 */
	"CPG_PERFCOUNTER1_SELECT\0" /* 47279 */
	"CPG_PERFCOUNTER0_SELECT1\0" /* 47303 */
	"CPG_PERFCOUNTER0_SELECT\0" /* 47328 */
	"CPC_PERFCOUNTER1_SELECT\0" /* 47352 */
	"CPC_PERFCOUNTER0_SELECT1\0" /* 47376 */
	"CPF_PERFCOUNTER1_SELECT\0" /* 47401 */
	"CPF_PERFCOUNTER0_SELECT1\0" /* 47425 */
	"CPF_PERFCOUNTER0_SELECT\0" /* 47450 */
	"CP_PERFMON_CNTL\0" /* 47474 */
	"CPC_PERFCOUNTER0_SELECT\0" /* 47490 */
	"GRBM_PERFCOUNTER0_SELECT\0" /* 47514 */
	"GRBM_PERFCOUNTER1_SELECT\0" /* 47539 */
	"GRBM_SE0_PERFCOUNTER_SELECT\0" /* 47564 */
	"GRBM_SE1_PERFCOUNTER_SELECT\0" /* 47592 */
	"GRBM_SE2_PERFCOUNTER_SELECT\0" /* 47620 */
	"GRBM_SE3_PERFCOUNTER_SELECT\0" /* 47648 */
	"WD_PERFCOUNTER0_SELECT\0" /* 47676 */
	"WD_PERFCOUNTER1_SELECT\0" /* 47699 */
	"WD_PERFCOUNTER2_SELECT\0" /* 47722 */
	"WD_PERFCOUNTER3_SELECT\0" /* 47745 */
	"IA_PERFCOUNTER0_SELECT\0" /* 47768 */
	"IA_PERFCOUNTER1_SELECT\0" /* 47791 */
	"IA_PERFCOUNTER2_SELECT\0" /* 47814 */
	"IA_PERFCOUNTER3_SELECT\0" /* 47837 */
	"IA_PERFCOUNTER0_SELECT1\0" /* 47860 */
	"VGT_PERFCOUNTER0_SELECT\0" /* 47884 */
	"VGT_PERFCOUNTER1_SELECT\0" /* 47908 */
	"VGT_PERFCOUNTER2_SELECT\0" /* 47932 */
	"VGT_PERFCOUNTER3_SELECT\0" /* 47956 */
	"VGT_PERFCOUNTER0_SELECT1\0" /* 47980 */
	"VGT_PERFCOUNTER1_SELECT1\0" /* 48005 */
	"VGT_PERFCOUNTER_SEID_MASK\0" /* 48030 */
	"PA_SU_PERFCOUNTER0_SELECT\0" /* 48056 */
	"PA_SU_PERFCOUNTER0_SELECT1\0" /* 48082 */
	"PA_SU_PERFCOUNTER1_SELECT\0" /* 48109 */
	"PA_SU_PERFCOUNTER1_SELECT1\0" /* 48135 */
	"PA_SU_PERFCOUNTER2_SELECT\0" /* 48162 */
	"PA_SU_PERFCOUNTER3_SELECT\0" /* 48188 */
	"PA_SC_PERFCOUNTER0_SELECT\0" /* 48214 */
	"PA_SC_PERFCOUNTER0_SELECT1\0" /* 48240 */
	"PA_SC_PERFCOUNTER1_SELECT\0" /* 48267 */
	"PA_SC_PERFCOUNTER2_SELECT\0" /* 48293 */
	"PA_SC_PERFCOUNTER3_SELECT\0" /* 48319 */
	"PA_SC_PERFCOUNTER4_SELECT\0" /* 48345 */
	"PA_SC_PERFCOUNTER5_SELECT\0" /* 48371 */
	"PA_SC_PERFCOUNTER6_SELECT\0" /* 48397 */
	"PA_SC_PERFCOUNTER7_SELECT\0" /* 48423 */
	"SPI_PERFCOUNTER0_SELECT\0" /* 48449 */
	"SPI_PERFCOUNTER1_SELECT\0" /* 48473 */
	"SPI_PERFCOUNTER2_SELECT\0" /* 48497 */
	"SPI_PERFCOUNTER3_SELECT\0" /* 48521 */
	"SPI_PERFCOUNTER0_SELECT1\0" /* 48545 */
	"SPI_PERFCOUNTER1_SELECT1\0" /* 48570 */
	"SPI_PERFCOUNTER2_SELECT1\0" /* 48595 */
	"SPI_PERFCOUNTER3_SELECT1\0" /* 48620 */
	"SPI_PERFCOUNTER4_SELECT\0" /* 48645 */
	"SPI_PERFCOUNTER5_SELECT\0" /* 48669 */
	"SPI_PERFCOUNTER_BINS\0" /* 48693 */
	"SQ_PERFCOUNTER0_SELECT\0" /* 48714 */
	"SQ_PERFCOUNTER1_SELECT\0" /* 48737 */
	"SQ_PERFCOUNTER2_SELECT\0" /* 48760 */
	"SQ_PERFCOUNTER3_SELECT\0" /* 48783 */
	"SQ_PERFCOUNTER4_SELECT\0" /* 48806 */
	"SQ_PERFCOUNTER5_SELECT\0" /* 48829 */
	"SQ_PERFCOUNTER6_SELECT\0" /* 48852 */
	"SQ_PERFCOUNTER7_SELECT\0" /* 48875 */
	"SQ_PERFCOUNTER8_SELECT\0" /* 48898 */
	"SQ_PERFCOUNTER9_SELECT\0" /* 48921 */
	"SQ_PERFCOUNTER10_SELECT\0" /* 48944 */
	"SQ_PERFCOUNTER11_SELECT\0" /* 48968 */
	"SQ_PERFCOUNTER12_SELECT\0" /* 48992 */
	"SQ_PERFCOUNTER13_SELECT\0" /* 49016 */
	"SQ_PERFCOUNTER14_SELECT\0" /* 49040 */
	"SQ_PERFCOUNTER15_SELECT\0" /* 49064 */
	"SQ_PERFCOUNTER_CTRL\0" /* 49088 */
	"SQ_PERFCOUNTER_MASK\0" /* 49108 */
	"SQ_PERFCOUNTER_CTRL2\0" /* 49128 */
	"SX_PERFCOUNTER0_SELECT\0" /* 49149 */
	"SX_PERFCOUNTER1_SELECT\0" /* 49172 */
	"SX_PERFCOUNTER2_SELECT\0" /* 49195 */
	"SX_PERFCOUNTER3_SELECT\0" /* 49218 */
	"SX_PERFCOUNTER0_SELECT1\0" /* 49241 */
	"SX_PERFCOUNTER1_SELECT1\0" /* 49265 */
	"GDS_PERFCOUNTER0_SELECT\0" /* 49289 */
	"GDS_PERFCOUNTER1_SELECT\0" /* 49313 */
	"GDS_PERFCOUNTER2_SELECT\0" /* 49337 */
	"GDS_PERFCOUNTER3_SELECT\0" /* 49361 */
	"GDS_PERFCOUNTER0_SELECT1\0" /* 49385 */
	"TA_PERFCOUNTER0_SELECT\0" /* 49410 */
	"TA_PERFCOUNTER0_SELECT1\0" /* 49433 */
	"TA_PERFCOUNTER1_SELECT\0" /* 49457 */
	"TD_PERFCOUNTER0_SELECT\0" /* 49480 */
	"TD_PERFCOUNTER0_SELECT1\0" /* 49503 */
	"TD_PERFCOUNTER1_SELECT\0" /* 49527 */
	"TCP_PERFCOUNTER0_SELECT\0" /* 49550 */
	"TCP_PERFCOUNTER0_SELECT1\0" /* 49574 */
	"TCP_PERFCOUNTER1_SELECT\0" /* 49599 */
	"TCP_PERFCOUNTER1_SELECT1\0" /* 49623 */
	"TCP_PERFCOUNTER2_SELECT\0" /* 49648 */
	"TCP_PERFCOUNTER3_SELECT\0" /* 49672 */
	"TCC_PERFCOUNTER0_SELECT\0" /* 49696 */
	"TCC_PERFCOUNTER0_SELECT1\0" /* 49720 */
	"TCC_PERFCOUNTER1_SELECT\0" /* 49745 */
	"TCC_PERFCOUNTER1_SELECT1\0" /* 49769 */
	"TCC_PERFCOUNTER2_SELECT\0" /* 49794 */
	"TCC_PERFCOUNTER3_SELECT\0" /* 49818 */
	"TCA_PERFCOUNTER0_SELECT\0" /* 49842 */
	"TCA_PERFCOUNTER0_SELECT1\0" /* 49866 */
	"TCA_PERFCOUNTER1_SELECT\0" /* 49891 */
	"TCA_PERFCOUNTER1_SELECT1\0" /* 49915 */
	"TCA_PERFCOUNTER2_SELECT\0" /* 49940 */
	"TCA_PERFCOUNTER3_SELECT\0" /* 49964 */
	"CB_PERFCOUNTER_FILTER\0" /* 49988 */
	"CB_PERFCOUNTER0_SELECT\0" /* 50010 */
	"CB_PERFCOUNTER0_SELECT1\0" /* 50033 */
	"CB_PERFCOUNTER1_SELECT\0" /* 50057 */
	"CB_PERFCOUNTER2_SELECT\0" /* 50080 */
	"CB_PERFCOUNTER3_SELECT\0" /* 50103 */
	"DB_PERFCOUNTER0_SELECT\0" /* 50126 */
	"DB_PERFCOUNTER0_SELECT1\0" /* 50149 */
	"DB_PERFCOUNTER1_SELECT\0" /* 50173 */
	"DB_PERFCOUNTER1_SELECT1\0" /* 50196 */
	"DB_PERFCOUNTER2_SELECT\0" /* 50220 */
	"DB_PERFCOUNTER3_SELECT\0" /* 50243 */
	"DB_RENDER_CONTROL\0" /* 50266 */
	"DB_COUNT_CONTROL\0" /* 50284 */
	"DB_DEPTH_VIEW\0" /* 50301 */
	"DB_RENDER_OVERRIDE\0" /* 50315 */
	"DB_RENDER_OVERRIDE2\0" /* 50334 */
	"DB_HTILE_DATA_BASE\0" /* 50354 */
	"DB_DEPTH_BOUNDS_MIN\0" /* 50373 */
	"DB_DEPTH_BOUNDS_MAX\0" /* 50393 */
	"DB_STENCIL_CLEAR\0" /* 50413 */
	"DB_DEPTH_CLEAR\0" /* 50430 */
	"PA_SC_SCREEN_SCISSOR_TL\0" /* 50445 */
	"PA_SC_SCREEN_SCISSOR_BR\0" /* 50469 */
	"DB_DEPTH_INFO\0" /* 50493 */
	"DB_Z_INFO\0" /* 50507 */
	"DB_STENCIL_INFO\0" /* 50517 */
	"DB_Z_READ_BASE\0" /* 50533 */
	"DB_STENCIL_READ_BASE\0" /* 50548 */
	"DB_Z_WRITE_BASE\0" /* 50569 */
	"DB_STENCIL_WRITE_BASE\0" /* 50585 */
	"DB_DEPTH_SIZE\0" /* 50607 */
	"DB_DEPTH_SLICE\0" /* 50621 */
	"TA_BC_BASE_ADDR\0" /* 50636 */
	"TA_BC_BASE_ADDR_HI\0" /* 50652 */
	"COHER_DEST_BASE_HI_0\0" /* 50671 */
	"COHER_DEST_BASE_HI_1\0" /* 50692 */
	"COHER_DEST_BASE_HI_2\0" /* 50713 */
	"COHER_DEST_BASE_HI_3\0" /* 50734 */
	"COHER_DEST_BASE_2\0" /* 50755 */
	"COHER_DEST_BASE_3\0" /* 50773 */
	"PA_SC_WINDOW_OFFSET\0" /* 50791 */
	"PA_SC_WINDOW_SCISSOR_TL\0" /* 50811 */
	"PA_SC_WINDOW_SCISSOR_BR\0" /* 50835 */
	"PA_SC_CLIPRECT_RULE\0" /* 50859 */
	"PA_SC_CLIPRECT_0_TL\0" /* 50879 */
	"PA_SC_CLIPRECT_0_BR\0" /* 50899 */
	"PA_SC_CLIPRECT_1_TL\0" /* 50919 */
	"PA_SC_CLIPRECT_1_BR\0" /* 50939 */
	"PA_SC_CLIPRECT_2_TL\0" /* 50959 */
	"PA_SC_CLIPRECT_2_BR\0" /* 50979 */
	"PA_SC_CLIPRECT_3_TL\0" /* 50999 */
	"PA_SC_CLIPRECT_3_BR\0" /* 51019 */
	"PA_SC_EDGERULE\0" /* 51039 */
	"PA_SU_HARDWARE_SCREEN_OFFSET\0" /* 51054 */
	"CB_TARGET_MASK\0" /* 51083 */
	"CB_SHADER_MASK\0" /* 51098 */
	"PA_SC_GENERIC_SCISSOR_TL\0" /* 51113 */
	"PA_SC_GENERIC_SCISSOR_BR\0" /* 51138 */
	"COHER_DEST_BASE_0\0" /* 51163 */
	"COHER_DEST_BASE_1\0" /* 51181 */
	"PA_SC_VPORT_SCISSOR_0_TL\0" /* 51199 */
	"PA_SC_VPORT_SCISSOR_0_BR\0" /* 51224 */
	"PA_SC_VPORT_SCISSOR_1_TL\0" /* 51249 */
	"PA_SC_VPORT_SCISSOR_1_BR\0" /* 51274 */
	"PA_SC_VPORT_SCISSOR_2_TL\0" /* 51299 */
	"PA_SC_VPORT_SCISSOR_2_BR\0" /* 51324 */
	"PA_SC_VPORT_SCISSOR_3_TL\0" /* 51349 */
	"PA_SC_VPORT_SCISSOR_3_BR\0" /* 51374 */
	"PA_SC_VPORT_SCISSOR_4_TL\0" /* 51399 */
	"PA_SC_VPORT_SCISSOR_4_BR\0" /* 51424 */
	"PA_SC_VPORT_SCISSOR_5_TL\0" /* 51449 */
	"PA_SC_VPORT_SCISSOR_5_BR\0" /* 51474 */
	"PA_SC_VPORT_SCISSOR_6_TL\0" /* 51499 */
	"PA_SC_VPORT_SCISSOR_6_BR\0" /* 51524 */
	"PA_SC_VPORT_SCISSOR_7_TL\0" /* 51549 */
	"PA_SC_VPORT_SCISSOR_7_BR\0" /* 51574 */
	"PA_SC_VPORT_SCISSOR_8_TL\0" /* 51599 */
	"PA_SC_VPORT_SCISSOR_8_BR\0" /* 51624 */
	"PA_SC_VPORT_SCISSOR_9_TL\0" /* 51649 */
	"PA_SC_VPORT_SCISSOR_9_BR\0" /* 51674 */
	"PA_SC_VPORT_SCISSOR_10_TL\0" /* 51699 */
	"PA_SC_VPORT_SCISSOR_10_BR\0" /* 51725 */
	"PA_SC_VPORT_SCISSOR_11_TL\0" /* 51751 */
	"PA_SC_VPORT_SCISSOR_11_BR\0" /* 51777 */
	"PA_SC_VPORT_SCISSOR_12_TL\0" /* 51803 */
	"PA_SC_VPORT_SCISSOR_12_BR\0" /* 51829 */
	"PA_SC_VPORT_SCISSOR_13_TL\0" /* 51855 */
	"PA_SC_VPORT_SCISSOR_13_BR\0" /* 51881 */
	"PA_SC_VPORT_SCISSOR_14_TL\0" /* 51907 */
	"PA_SC_VPORT_SCISSOR_14_BR\0" /* 51933 */
	"PA_SC_VPORT_SCISSOR_15_TL\0" /* 51959 */
	"PA_SC_VPORT_SCISSOR_15_BR\0" /* 51985 */
	"PA_SC_VPORT_ZMIN_0\0" /* 52011 */
	"PA_SC_VPORT_ZMAX_0\0" /* 52030 */
	"PA_SC_VPORT_ZMIN_1\0" /* 52049 */
	"PA_SC_VPORT_ZMAX_1\0" /* 52068 */
	"PA_SC_VPORT_ZMIN_2\0" /* 52087 */
	"PA_SC_VPORT_ZMAX_2\0" /* 52106 */
	"PA_SC_VPORT_ZMIN_3\0" /* 52125 */
	"PA_SC_VPORT_ZMAX_3\0" /* 52144 */
	"PA_SC_VPORT_ZMIN_4\0" /* 52163 */
	"PA_SC_VPORT_ZMAX_4\0" /* 52182 */
	"PA_SC_VPORT_ZMIN_5\0" /* 52201 */
	"PA_SC_VPORT_ZMAX_5\0" /* 52220 */
	"PA_SC_VPORT_ZMIN_6\0" /* 52239 */
	"PA_SC_VPORT_ZMAX_6\0" /* 52258 */
	"PA_SC_VPORT_ZMIN_7\0" /* 52277 */
	"PA_SC_VPORT_ZMAX_7\0" /* 52296 */
	"PA_SC_VPORT_ZMIN_8\0" /* 52315 */
	"PA_SC_VPORT_ZMAX_8\0" /* 52334 */
	"PA_SC_VPORT_ZMIN_9\0" /* 52353 */
	"PA_SC_VPORT_ZMAX_9\0" /* 52372 */
	"PA_SC_VPORT_ZMIN_10\0" /* 52391 */
	"PA_SC_VPORT_ZMAX_10\0" /* 52411 */
	"PA_SC_VPORT_ZMIN_11\0" /* 52431 */
	"PA_SC_VPORT_ZMAX_11\0" /* 52451 */
	"PA_SC_VPORT_ZMIN_12\0" /* 52471 */
	"PA_SC_VPORT_ZMAX_12\0" /* 52491 */
	"PA_SC_VPORT_ZMIN_13\0" /* 52511 */
	"PA_SC_VPORT_ZMAX_13\0" /* 52531 */
	"PA_SC_VPORT_ZMIN_14\0" /* 52551 */
	"PA_SC_VPORT_ZMAX_14\0" /* 52571 */
	"PA_SC_VPORT_ZMIN_15\0" /* 52591 */
	"PA_SC_VPORT_ZMAX_15\0" /* 52611 */
	"PA_SC_RASTER_CONFIG\0" /* 52631 */
	"PA_SC_RASTER_CONFIG_1\0" /* 52651 */
	"PA_SC_SCREEN_EXTENT_CONTROL\0" /* 52673 */
	"VGT_MAX_VTX_INDX\0" /* 52701 */
	"VGT_MIN_VTX_INDX\0" /* 52718 */
	"VGT_INDX_OFFSET\0" /* 52735 */
	"VGT_MULTI_PRIM_IB_RESET_INDX\0" /* 52751 */
	"CB_BLEND_RED\0" /* 52780 */
	"CB_BLEND_GREEN\0" /* 52793 */
	"CB_BLEND_BLUE\0" /* 52808 */
	"CB_BLEND_ALPHA\0" /* 52822 */
	"CB_DCC_CONTROL\0" /* 52837 */
	"DB_STENCIL_CONTROL\0" /* 52852 */
	"DB_STENCILREFMASK\0" /* 52871 */
	"DB_STENCILREFMASK_BF\0" /* 52889 */
	"PA_CL_VPORT_XSCALE\0" /* 52910 */
	"PA_CL_VPORT_XOFFSET\0" /* 52929 */
	"PA_CL_VPORT_YSCALE\0" /* 52949 */
	"PA_CL_VPORT_YOFFSET\0" /* 52968 */
	"PA_CL_VPORT_ZSCALE\0" /* 52988 */
	"PA_CL_VPORT_ZOFFSET\0" /* 53007 */
	"PA_CL_VPORT_XSCALE_1\0" /* 53027 */
	"PA_CL_VPORT_XOFFSET_1\0" /* 53048 */
	"PA_CL_VPORT_YSCALE_1\0" /* 53070 */
	"PA_CL_VPORT_YOFFSET_1\0" /* 53091 */
	"PA_CL_VPORT_ZSCALE_1\0" /* 53113 */
	"PA_CL_VPORT_ZOFFSET_1\0" /* 53134 */
	"PA_CL_VPORT_XSCALE_2\0" /* 53156 */
	"PA_CL_VPORT_XOFFSET_2\0" /* 53177 */
	"PA_CL_VPORT_YSCALE_2\0" /* 53199 */
	"PA_CL_VPORT_YOFFSET_2\0" /* 53220 */
	"PA_CL_VPORT_ZSCALE_2\0" /* 53242 */
	"PA_CL_VPORT_ZOFFSET_2\0" /* 53263 */
	"PA_CL_VPORT_XSCALE_3\0" /* 53285 */
	"PA_CL_VPORT_XOFFSET_3\0" /* 53306 */
	"PA_CL_VPORT_YSCALE_3\0" /* 53328 */
	"PA_CL_VPORT_YOFFSET_3\0" /* 53349 */
	"PA_CL_VPORT_ZSCALE_3\0" /* 53371 */
	"PA_CL_VPORT_ZOFFSET_3\0" /* 53392 */
	"PA_CL_VPORT_XSCALE_4\0" /* 53414 */
	"PA_CL_VPORT_XOFFSET_4\0" /* 53435 */
	"PA_CL_VPORT_YSCALE_4\0" /* 53457 */
	"PA_CL_VPORT_YOFFSET_4\0" /* 53478 */
	"PA_CL_VPORT_ZSCALE_4\0" /* 53500 */
	"PA_CL_VPORT_ZOFFSET_4\0" /* 53521 */
	"PA_CL_VPORT_XSCALE_5\0" /* 53543 */
	"PA_CL_VPORT_XOFFSET_5\0" /* 53564 */
	"PA_CL_VPORT_YSCALE_5\0" /* 53586 */
	"PA_CL_VPORT_YOFFSET_5\0" /* 53607 */
	"PA_CL_VPORT_ZSCALE_5\0" /* 53629 */
	"PA_CL_VPORT_ZOFFSET_5\0" /* 53650 */
	"PA_CL_VPORT_XSCALE_6\0" /* 53672 */
	"PA_CL_VPORT_XOFFSET_6\0" /* 53693 */
	"PA_CL_VPORT_YSCALE_6\0" /* 53715 */
	"PA_CL_VPORT_YOFFSET_6\0" /* 53736 */
	"PA_CL_VPORT_ZSCALE_6\0" /* 53758 */
	"PA_CL_VPORT_ZOFFSET_6\0" /* 53779 */
	"PA_CL_VPORT_XSCALE_7\0" /* 53801 */
	"PA_CL_VPORT_XOFFSET_7\0" /* 53822 */
	"PA_CL_VPORT_YSCALE_7\0" /* 53844 */
	"PA_CL_VPORT_YOFFSET_7\0" /* 53865 */
	"PA_CL_VPORT_ZSCALE_7\0" /* 53887 */
	"PA_CL_VPORT_ZOFFSET_7\0" /* 53908 */
	"PA_CL_VPORT_XSCALE_8\0" /* 53930 */
	"PA_CL_VPORT_XOFFSET_8\0" /* 53951 */
	"PA_CL_VPORT_YSCALE_8\0" /* 53973 */
	"PA_CL_VPORT_YOFFSET_8\0" /* 53994 */
	"PA_CL_VPORT_ZSCALE_8\0" /* 54016 */
	"PA_CL_VPORT_ZOFFSET_8\0" /* 54037 */
	"PA_CL_VPORT_XSCALE_9\0" /* 54059 */
	"PA_CL_VPORT_XOFFSET_9\0" /* 54080 */
	"PA_CL_VPORT_YSCALE_9\0" /* 54102 */
	"PA_CL_VPORT_YOFFSET_9\0" /* 54123 */
	"PA_CL_VPORT_ZSCALE_9\0" /* 54145 */
	"PA_CL_VPORT_ZOFFSET_9\0" /* 54166 */
	"PA_CL_VPORT_XSCALE_10\0" /* 54188 */
	"PA_CL_VPORT_XOFFSET_10\0" /* 54210 */
	"PA_CL_VPORT_YSCALE_10\0" /* 54233 */
	"PA_CL_VPORT_YOFFSET_10\0" /* 54255 */
	"PA_CL_VPORT_ZSCALE_10\0" /* 54278 */
	"PA_CL_VPORT_ZOFFSET_10\0" /* 54300 */
	"PA_CL_VPORT_XSCALE_11\0" /* 54323 */
	"PA_CL_VPORT_XOFFSET_11\0" /* 54345 */
	"PA_CL_VPORT_YSCALE_11\0" /* 54368 */
	"PA_CL_VPORT_YOFFSET_11\0" /* 54390 */
	"PA_CL_VPORT_ZSCALE_11\0" /* 54413 */
	"PA_CL_VPORT_ZOFFSET_11\0" /* 54435 */
	"PA_CL_VPORT_XSCALE_12\0" /* 54458 */
	"PA_CL_VPORT_XOFFSET_12\0" /* 54480 */
	"PA_CL_VPORT_YSCALE_12\0" /* 54503 */
	"PA_CL_VPORT_YOFFSET_12\0" /* 54525 */
	"PA_CL_VPORT_ZSCALE_12\0" /* 54548 */
	"PA_CL_VPORT_ZOFFSET_12\0" /* 54570 */
	"PA_CL_VPORT_XSCALE_13\0" /* 54593 */
	"PA_CL_VPORT_XOFFSET_13\0" /* 54615 */
	"PA_CL_VPORT_YSCALE_13\0" /* 54638 */
	"PA_CL_VPORT_YOFFSET_13\0" /* 54660 */
	"PA_CL_VPORT_ZSCALE_13\0" /* 54683 */
	"PA_CL_VPORT_ZOFFSET_13\0" /* 54705 */
	"PA_CL_VPORT_XSCALE_14\0" /* 54728 */
	"PA_CL_VPORT_XOFFSET_14\0" /* 54750 */
	"PA_CL_VPORT_YSCALE_14\0" /* 54773 */
	"PA_CL_VPORT_YOFFSET_14\0" /* 54795 */
	"PA_CL_VPORT_ZSCALE_14\0" /* 54818 */
	"PA_CL_VPORT_ZOFFSET_14\0" /* 54840 */
	"PA_CL_VPORT_XSCALE_15\0" /* 54863 */
	"PA_CL_VPORT_XOFFSET_15\0" /* 54885 */
	"PA_CL_VPORT_YSCALE_15\0" /* 54908 */
	"PA_CL_VPORT_YOFFSET_15\0" /* 54930 */
	"PA_CL_VPORT_ZSCALE_15\0" /* 54953 */
	"PA_CL_VPORT_ZOFFSET_15\0" /* 54975 */
	"PA_CL_UCP_0_X\0" /* 54998 */
	"PA_CL_UCP_0_Y\0" /* 55012 */
	"PA_CL_UCP_0_Z\0" /* 55026 */
	"PA_CL_UCP_0_W\0" /* 55040 */
	"PA_CL_UCP_1_X\0" /* 55054 */
	"PA_CL_UCP_1_Y\0" /* 55068 */
	"PA_CL_UCP_1_Z\0" /* 55082 */
	"PA_CL_UCP_1_W\0" /* 55096 */
	"PA_CL_UCP_2_X\0" /* 55110 */
	"PA_CL_UCP_2_Y\0" /* 55124 */
	"PA_CL_UCP_2_Z\0" /* 55138 */
	"PA_CL_UCP_2_W\0" /* 55152 */
	"PA_CL_UCP_3_X\0" /* 55166 */
	"PA_CL_UCP_3_Y\0" /* 55180 */
	"PA_CL_UCP_3_Z\0" /* 55194 */
	"PA_CL_UCP_3_W\0" /* 55208 */
	"PA_CL_UCP_4_X\0" /* 55222 */
	"PA_CL_UCP_4_Y\0" /* 55236 */
	"PA_CL_UCP_4_Z\0" /* 55250 */
	"PA_CL_UCP_4_W\0" /* 55264 */
	"PA_CL_UCP_5_X\0" /* 55278 */
	"PA_CL_UCP_5_Y\0" /* 55292 */
	"PA_CL_UCP_5_Z\0" /* 55306 */
	"PA_CL_UCP_5_W\0" /* 55320 */
	"SPI_PS_INPUT_CNTL_0\0" /* 55334 */
	"SPI_PS_INPUT_CNTL_1\0" /* 55354 */
	"SPI_PS_INPUT_CNTL_2\0" /* 55374 */
	"SPI_PS_INPUT_CNTL_3\0" /* 55394 */
	"SPI_PS_INPUT_CNTL_4\0" /* 55414 */
	"SPI_PS_INPUT_CNTL_5\0" /* 55434 */
	"SPI_PS_INPUT_CNTL_6\0" /* 55454 */
	"SPI_PS_INPUT_CNTL_7\0" /* 55474 */
	"SPI_PS_INPUT_CNTL_8\0" /* 55494 */
	"SPI_PS_INPUT_CNTL_9\0" /* 55514 */
	"SPI_PS_INPUT_CNTL_10\0" /* 55534 */
	"SPI_PS_INPUT_CNTL_11\0" /* 55555 */
	"SPI_PS_INPUT_CNTL_12\0" /* 55576 */
	"SPI_PS_INPUT_CNTL_13\0" /* 55597 */
	"SPI_PS_INPUT_CNTL_14\0" /* 55618 */
	"SPI_PS_INPUT_CNTL_15\0" /* 55639 */
	"SPI_PS_INPUT_CNTL_16\0" /* 55660 */
	"SPI_PS_INPUT_CNTL_17\0" /* 55681 */
	"SPI_PS_INPUT_CNTL_18\0" /* 55702 */
	"SPI_PS_INPUT_CNTL_19\0" /* 55723 */
	"SPI_PS_INPUT_CNTL_20\0" /* 55744 */
	"SPI_PS_INPUT_CNTL_21\0" /* 55765 */
	"SPI_PS_INPUT_CNTL_22\0" /* 55786 */
	"SPI_PS_INPUT_CNTL_23\0" /* 55807 */
	"SPI_PS_INPUT_CNTL_24\0" /* 55828 */
	"SPI_PS_INPUT_CNTL_25\0" /* 55849 */
	"SPI_PS_INPUT_CNTL_26\0" /* 55870 */
	"SPI_PS_INPUT_CNTL_27\0" /* 55891 */
	"SPI_PS_INPUT_CNTL_28\0" /* 55912 */
	"SPI_PS_INPUT_CNTL_29\0" /* 55933 */
	"SPI_PS_INPUT_CNTL_30\0" /* 55954 */
	"SPI_PS_INPUT_CNTL_31\0" /* 55975 */
	"SPI_VS_OUT_CONFIG\0" /* 55996 */
	"SPI_PS_INPUT_ENA\0" /* 56014 */
	"SPI_PS_INPUT_ADDR\0" /* 56031 */
	"SPI_INTERP_CONTROL_0\0" /* 56049 */
	"SPI_PS_IN_CONTROL\0" /* 56070 */
	"SPI_BARYC_CNTL\0" /* 56088 */
	"SPI_TMPRING_SIZE\0" /* 56103 */
	"SPI_WAVE_MGMT_1\0" /* 56120 */
	"SPI_WAVE_MGMT_2\0" /* 56136 */
	"SPI_SHADER_POS_FORMAT\0" /* 56152 */
	"SPI_SHADER_Z_FORMAT\0" /* 56174 */
	"SPI_SHADER_COL_FORMAT\0" /* 56194 */
	"SX_PS_DOWNCONVERT\0" /* 56216 */
	"SX_BLEND_OPT_EPSILON\0" /* 56234 */
	"SX_BLEND_OPT_CONTROL\0" /* 56255 */
	"SX_MRT0_BLEND_OPT\0" /* 56276 */
	"SX_MRT1_BLEND_OPT\0" /* 56294 */
	"SX_MRT2_BLEND_OPT\0" /* 56312 */
	"SX_MRT3_BLEND_OPT\0" /* 56330 */
	"SX_MRT4_BLEND_OPT\0" /* 56348 */
	"SX_MRT5_BLEND_OPT\0" /* 56366 */
	"SX_MRT6_BLEND_OPT\0" /* 56384 */
	"SX_MRT7_BLEND_OPT\0" /* 56402 */
	"CB_BLEND0_CONTROL\0" /* 56420 */
	"CB_BLEND1_CONTROL\0" /* 56438 */
	"CB_BLEND2_CONTROL\0" /* 56456 */
	"CB_BLEND3_CONTROL\0" /* 56474 */
	"CB_BLEND4_CONTROL\0" /* 56492 */
	"CB_BLEND5_CONTROL\0" /* 56510 */
	"CB_BLEND6_CONTROL\0" /* 56528 */
	"CB_BLEND7_CONTROL\0" /* 56546 */
	"CS_COPY_STATE\0" /* 56564 */
	"PA_CL_POINT_X_RAD\0" /* 56578 */
	"PA_CL_POINT_Y_RAD\0" /* 56596 */
	"PA_CL_POINT_SIZE\0" /* 56614 */
	"PA_CL_POINT_CULL_RAD\0" /* 56631 */
	"VGT_DMA_BASE_HI\0" /* 56652 */
	"VGT_DMA_BASE\0" /* 56668 */
	"VGT_DRAW_INITIATOR\0" /* 56681 */
	"VGT_IMMED_DATA\0" /* 56700 */
	"VGT_EVENT_ADDRESS_REG\0" /* 56715 */
	"DB_DEPTH_CONTROL\0" /* 56737 */
	"DB_EQAA\0" /* 56754 */
	"CB_COLOR_CONTROL\0" /* 56762 */
	"DB_SHADER_CONTROL\0" /* 56779 */
	"PA_CL_CLIP_CNTL\0" /* 56797 */
	"PA_SU_SC_MODE_CNTL\0" /* 56813 */
	"PA_CL_VTE_CNTL\0" /* 56832 */
	"PA_CL_VS_OUT_CNTL\0" /* 56847 */
	"PA_CL_NANINF_CNTL\0" /* 56865 */
	"PA_SU_LINE_STIPPLE_CNTL\0" /* 56883 */
	"PA_SU_LINE_STIPPLE_SCALE\0" /* 56907 */
	"PA_SU_PRIM_FILTER_CNTL\0" /* 56932 */
	"PA_SU_SMALL_PRIM_FILTER_CNTL\0" /* 56955 */
	"PA_SU_POINT_SIZE\0" /* 56984 */
	"PA_SU_POINT_MINMAX\0" /* 57001 */
	"PA_SU_LINE_CNTL\0" /* 57020 */
	"PA_SC_LINE_STIPPLE\0" /* 57036 */
	"VGT_OUTPUT_PATH_CNTL\0" /* 57055 */
	"VGT_HOS_CNTL\0" /* 57076 */
	"VGT_HOS_MAX_TESS_LEVEL\0" /* 57089 */
	"VGT_HOS_MIN_TESS_LEVEL\0" /* 57112 */
	"VGT_HOS_REUSE_DEPTH\0" /* 57135 */
	"VGT_GROUP_PRIM_TYPE\0" /* 57155 */
	"VGT_GROUP_FIRST_DECR\0" /* 57175 */
	"VGT_GROUP_DECR\0" /* 57196 */
	"VGT_GROUP_VECT_0_CNTL\0" /* 57211 */
	"VGT_GROUP_VECT_1_CNTL\0" /* 57233 */
	"VGT_GROUP_VECT_0_FMT_CNTL\0" /* 57255 */
	"VGT_GROUP_VECT_1_FMT_CNTL\0" /* 57281 */
	"VGT_GS_MODE\0" /* 57307 */
	"VGT_GS_ONCHIP_CNTL\0" /* 57319 */
	"PA_SC_MODE_CNTL_0\0" /* 57338 */
	"PA_SC_MODE_CNTL_1\0" /* 57356 */
	"VGT_ENHANCE\0" /* 57374 */
	"VGT_GS_PER_ES\0" /* 57386 */
	"VGT_ES_PER_GS\0" /* 57400 */
	"VGT_GS_PER_VS\0" /* 57414 */
	"VGT_GSVS_RING_OFFSET_1\0" /* 57428 */
	"VGT_GSVS_RING_OFFSET_2\0" /* 57451 */
	"VGT_GSVS_RING_OFFSET_3\0" /* 57474 */
	"VGT_GS_OUT_PRIM_TYPE\0" /* 57497 */
	"IA_ENHANCE\0" /* 57518 */
	"VGT_DMA_SIZE\0" /* 57529 */
	"VGT_DMA_MAX_SIZE\0" /* 57542 */
	"VGT_DMA_INDEX_TYPE\0" /* 57559 */
	"WD_ENHANCE\0" /* 57578 */
	"VGT_PRIMITIVEID_EN\0" /* 57589 */
	"VGT_DMA_NUM_INSTANCES\0" /* 57608 */
	"VGT_PRIMITIVEID_RESET\0" /* 57630 */
	"VGT_EVENT_INITIATOR\0" /* 57652 */
	"VGT_MULTI_PRIM_IB_RESET_EN\0" /* 57672 */
	"VGT_INSTANCE_STEP_RATE_0\0" /* 57699 */
	"VGT_INSTANCE_STEP_RATE_1\0" /* 57724 */
	"IA_MULTI_VGT_PARAM\0" /* 57749 */
	"VGT_ESGS_RING_ITEMSIZE\0" /* 57768 */
	"VGT_GSVS_RING_ITEMSIZE\0" /* 57791 */
	"VGT_REUSE_OFF\0" /* 57814 */
	"VGT_VTX_CNT_EN\0" /* 57828 */
	"DB_HTILE_SURFACE\0" /* 57843 */
	"DB_SRESULTS_COMPARE_STATE0\0" /* 57860 */
	"DB_SRESULTS_COMPARE_STATE1\0" /* 57887 */
	"DB_PRELOAD_CONTROL\0" /* 57914 */
	"VGT_STRMOUT_BUFFER_SIZE_0\0" /* 57933 */
	"VGT_STRMOUT_VTX_STRIDE_0\0" /* 57959 */
	"VGT_STRMOUT_BUFFER_OFFSET_0\0" /* 57984 */
	"VGT_STRMOUT_BUFFER_SIZE_1\0" /* 58012 */
	"VGT_STRMOUT_VTX_STRIDE_1\0" /* 58038 */
	"VGT_STRMOUT_BUFFER_OFFSET_1\0" /* 58063 */
	"VGT_STRMOUT_BUFFER_SIZE_2\0" /* 58091 */
	"VGT_STRMOUT_VTX_STRIDE_2\0" /* 58117 */
	"VGT_STRMOUT_BUFFER_OFFSET_2\0" /* 58142 */
	"VGT_STRMOUT_BUFFER_SIZE_3\0" /* 58170 */
	"VGT_STRMOUT_VTX_STRIDE_3\0" /* 58196 */
	"VGT_STRMOUT_BUFFER_OFFSET_3\0" /* 58221 */
	"VGT_STRMOUT_DRAW_OPAQUE_OFFSET\0" /* 58249 */
	"VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE\0" /* 58280 */
	"VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE\0" /* 58323 */
	"VGT_GS_MAX_VERT_OUT\0" /* 58361 */
	"VGT_TESS_DISTRIBUTION\0" /* 58381 */
	"VGT_SHADER_STAGES_EN\0" /* 58403 */
	"VGT_LS_HS_CONFIG\0" /* 58424 */
	"VGT_GS_VERT_ITEMSIZE\0" /* 58441 */
	"VGT_GS_VERT_ITEMSIZE_1\0" /* 58462 */
	"VGT_GS_VERT_ITEMSIZE_2\0" /* 58485 */
	"VGT_GS_VERT_ITEMSIZE_3\0" /* 58508 */
	"VGT_TF_PARAM\0" /* 58531 */
	"DB_ALPHA_TO_MASK\0" /* 58544 */
	"VGT_DISPATCH_DRAW_INDEX\0" /* 58561 */
	"PA_SU_POLY_OFFSET_DB_FMT_CNTL\0" /* 58585 */
	"PA_SU_POLY_OFFSET_CLAMP\0" /* 58615 */
	"PA_SU_POLY_OFFSET_FRONT_SCALE\0" /* 58639 */
	"PA_SU_POLY_OFFSET_FRONT_OFFSET\0" /* 58669 */
	"PA_SU_POLY_OFFSET_BACK_SCALE\0" /* 58700 */
	"PA_SU_POLY_OFFSET_BACK_OFFSET\0" /* 58729 */
	"VGT_GS_INSTANCE_CNT\0" /* 58759 */
	"VGT_STRMOUT_CONFIG\0" /* 58779 */
	"VGT_STRMOUT_BUFFER_CONFIG\0" /* 58798 */
	"PA_SC_CENTROID_PRIORITY_0\0" /* 58824 */
	"PA_SC_CENTROID_PRIORITY_1\0" /* 58850 */
	"PA_SC_LINE_CNTL\0" /* 58876 */
	"PA_SC_AA_CONFIG\0" /* 58892 */
	"PA_SU_VTX_CNTL\0" /* 58908 */
	"PA_CL_GB_VERT_CLIP_ADJ\0" /* 58923 */
	"PA_CL_GB_VERT_DISC_ADJ\0" /* 58946 */
	"PA_CL_GB_HORZ_CLIP_ADJ\0" /* 58969 */
	"PA_CL_GB_HORZ_DISC_ADJ\0" /* 58992 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0\0" /* 59015 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1\0" /* 59049 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2\0" /* 59083 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3\0" /* 59117 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0\0" /* 59151 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1\0" /* 59185 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2\0" /* 59219 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3\0" /* 59253 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0\0" /* 59287 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1\0" /* 59321 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2\0" /* 59355 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3\0" /* 59389 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0\0" /* 59423 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1\0" /* 59457 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2\0" /* 59491 */
	"PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3\0" /* 59525 */
	"PA_SC_AA_MASK_X0Y0_X1Y0\0" /* 59559 */
	"PA_SC_AA_MASK_X0Y1_X1Y1\0" /* 59583 */
	"PA_SC_SHADER_CONTROL\0" /* 59607 */
	"VGT_VERTEX_REUSE_BLOCK_CNTL\0" /* 59628 */
	"VGT_OUT_DEALLOC_CNTL\0" /* 59656 */
	"CB_COLOR0_BASE\0" /* 59677 */
	"CB_COLOR0_PITCH\0" /* 59692 */
	"CB_COLOR0_SLICE\0" /* 59708 */
	"CB_COLOR0_VIEW\0" /* 59724 */
	"CB_COLOR0_INFO\0" /* 59739 */
	"CB_COLOR0_ATTRIB\0" /* 59754 */
	"CB_COLOR0_DCC_CONTROL\0" /* 59771 */
	"CB_COLOR0_CMASK\0" /* 59793 */
	"CB_COLOR0_CMASK_SLICE\0" /* 59809 */
	"CB_COLOR0_FMASK\0" /* 59831 */
	"CB_COLOR0_FMASK_SLICE\0" /* 59847 */
	"CB_COLOR0_CLEAR_WORD0\0" /* 59869 */
	"CB_COLOR0_CLEAR_WORD1\0" /* 59891 */
	"CB_COLOR0_DCC_BASE\0" /* 59913 */
	"CB_COLOR1_BASE\0" /* 59932 */
	"CB_COLOR1_PITCH\0" /* 59947 */
	"CB_COLOR1_SLICE\0" /* 59963 */
	"CB_COLOR1_VIEW\0" /* 59979 */
	"CB_COLOR1_INFO\0" /* 59994 */
	"CB_COLOR1_ATTRIB\0" /* 60009 */
	"CB_COLOR1_DCC_CONTROL\0" /* 60026 */
	"CB_COLOR1_CMASK\0" /* 60048 */
	"CB_COLOR1_CMASK_SLICE\0" /* 60064 */
	"CB_COLOR1_FMASK\0" /* 60086 */
	"CB_COLOR1_FMASK_SLICE\0" /* 60102 */
	"CB_COLOR1_CLEAR_WORD0\0" /* 60124 */
	"CB_COLOR1_CLEAR_WORD1\0" /* 60146 */
	"CB_COLOR1_DCC_BASE\0" /* 60168 */
	"CB_COLOR2_BASE\0" /* 60187 */
	"CB_COLOR2_PITCH\0" /* 60202 */
	"CB_COLOR2_SLICE\0" /* 60218 */
	"CB_COLOR2_VIEW\0" /* 60234 */
	"CB_COLOR2_INFO\0" /* 60249 */
	"CB_COLOR2_ATTRIB\0" /* 60264 */
	"CB_COLOR2_DCC_CONTROL\0" /* 60281 */
	"CB_COLOR2_CMASK\0" /* 60303 */
	"CB_COLOR2_CMASK_SLICE\0" /* 60319 */
	"CB_COLOR2_FMASK\0" /* 60341 */
	"CB_COLOR2_FMASK_SLICE\0" /* 60357 */
	"CB_COLOR2_CLEAR_WORD0\0" /* 60379 */
	"CB_COLOR2_CLEAR_WORD1\0" /* 60401 */
	"CB_COLOR2_DCC_BASE\0" /* 60423 */
	"CB_COLOR3_BASE\0" /* 60442 */
	"CB_COLOR3_PITCH\0" /* 60457 */
	"CB_COLOR3_SLICE\0" /* 60473 */
	"CB_COLOR3_VIEW\0" /* 60489 */
	"CB_COLOR3_INFO\0" /* 60504 */
	"CB_COLOR3_ATTRIB\0" /* 60519 */
	"CB_COLOR3_DCC_CONTROL\0" /* 60536 */
	"CB_COLOR3_CMASK\0" /* 60558 */
	"CB_COLOR3_CMASK_SLICE\0" /* 60574 */
	"CB_COLOR3_FMASK\0" /* 60596 */
	"CB_COLOR3_FMASK_SLICE\0" /* 60612 */
	"CB_COLOR3_CLEAR_WORD0\0" /* 60634 */
	"CB_COLOR3_CLEAR_WORD1\0" /* 60656 */
	"CB_COLOR3_DCC_BASE\0" /* 60678 */
	"CB_COLOR4_BASE\0" /* 60697 */
	"CB_COLOR4_PITCH\0" /* 60712 */
	"CB_COLOR4_SLICE\0" /* 60728 */
	"CB_COLOR4_VIEW\0" /* 60744 */
	"CB_COLOR4_INFO\0" /* 60759 */
	"CB_COLOR4_ATTRIB\0" /* 60774 */
	"CB_COLOR4_DCC_CONTROL\0" /* 60791 */
	"CB_COLOR4_CMASK\0" /* 60813 */
	"CB_COLOR4_CMASK_SLICE\0" /* 60829 */
	"CB_COLOR4_FMASK\0" /* 60851 */
	"CB_COLOR4_FMASK_SLICE\0" /* 60867 */
	"CB_COLOR4_CLEAR_WORD0\0" /* 60889 */
	"CB_COLOR4_CLEAR_WORD1\0" /* 60911 */
	"CB_COLOR4_DCC_BASE\0" /* 60933 */
	"CB_COLOR5_BASE\0" /* 60952 */
	"CB_COLOR5_PITCH\0" /* 60967 */
	"CB_COLOR5_SLICE\0" /* 60983 */
	"CB_COLOR5_VIEW\0" /* 60999 */
	"CB_COLOR5_INFO\0" /* 61014 */
	"CB_COLOR5_ATTRIB\0" /* 61029 */
	"CB_COLOR5_DCC_CONTROL\0" /* 61046 */
	"CB_COLOR5_CMASK\0" /* 61068 */
	"CB_COLOR5_CMASK_SLICE\0" /* 61084 */
	"CB_COLOR5_FMASK\0" /* 61106 */
	"CB_COLOR5_FMASK_SLICE\0" /* 61122 */
	"CB_COLOR5_CLEAR_WORD0\0" /* 61144 */
	"CB_COLOR5_CLEAR_WORD1\0" /* 61166 */
	"CB_COLOR5_DCC_BASE\0" /* 61188 */
	"CB_COLOR6_BASE\0" /* 61207 */
	"CB_COLOR6_PITCH\0" /* 61222 */
	"CB_COLOR6_SLICE\0" /* 61238 */
	"CB_COLOR6_VIEW\0" /* 61254 */
	"CB_COLOR6_INFO\0" /* 61269 */
	"CB_COLOR6_ATTRIB\0" /* 61284 */
	"CB_COLOR6_DCC_CONTROL\0" /* 61301 */
	"CB_COLOR6_CMASK\0" /* 61323 */
	"CB_COLOR6_CMASK_SLICE\0" /* 61339 */
	"CB_COLOR6_FMASK\0" /* 61361 */
	"CB_COLOR6_FMASK_SLICE\0" /* 61377 */
	"CB_COLOR6_CLEAR_WORD0\0" /* 61399 */
	"CB_COLOR6_CLEAR_WORD1\0" /* 61421 */
	"CB_COLOR6_DCC_BASE\0" /* 61443 */
	"CB_COLOR7_BASE\0" /* 61462 */
	"CB_COLOR7_PITCH\0" /* 61477 */
	"CB_COLOR7_SLICE\0" /* 61493 */
	"CB_COLOR7_VIEW\0" /* 61509 */
	"CB_COLOR7_INFO\0" /* 61524 */
	"CB_COLOR7_ATTRIB\0" /* 61539 */
	"CB_COLOR7_DCC_CONTROL\0" /* 61556 */
	"CB_COLOR7_CMASK\0" /* 61578 */
	"CB_COLOR7_CMASK_SLICE\0" /* 61594 */
	"CB_COLOR7_FMASK\0" /* 61616 */
	"CB_COLOR7_FMASK_SLICE\0" /* 61632 */
	"CB_COLOR7_CLEAR_WORD0\0" /* 61654 */
	"CB_COLOR7_CLEAR_WORD1\0" /* 61676 */
	"CB_COLOR7_DCC_BASE\0" /* 61698 */;

static const int sid_strings_offsets[] = {
	/* 0 */ 509, 867, 871, 874,
	/* 4 */ 911, 931, 943, 949, 953, 962,
	/* 10 */ 1020, 949, 391, 1029,
	/* 14 */ 1059, 949, -1, 1068,
	/* 18 */ 1157, 1162, 1170, 1178,
	/* 22 */ 1204, 922,
	/* 24 */ 1219, 1229,
	/* 26 */ 5448, 5459, 5475, 5490, 5506, 5520, 5533, 5548, 5563, 5578, 5590, 5609, 5629, 5647, 5666, 5681, 5696, 5718, 5733, 5748, 5763, 5779, 5793, 5820, 5847, 5874, 5901, 5925, 5945,
	/* 55 */ 5974, 5995,
	/* 57 */ 5448, 5459, 5475, 5490, 5506, 5520, 5533, -1, -1, 5578, 5590, 5609, 5629, 5647, -1, -1, 5696, 5718, 5733, 5748, 5763, 5779, 5793, 5820, 5847, 5874, 5901, 5925, 5945,
	/* 86 */ 7955, 7967, 7979, 7991,
	/* 90 */ 8339, -1, -1, -1, -1, -1, -1, -1, 8350, 8362, -1, -1, 8374, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8385,
	/* 123 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 8411,
	/* 186 */ 8506, 8515, 8524, 8542, 8560, 8569, 8578, 8587,
	/* 194 */ 8636, 8657, 8678, 8701, 8724, 8744, 8764, 8789,
	/* 202 */ 8821, 8845, 8863, 8882, 8902, 8921, 8943, 8968, 8993, 9020, 9047, 9071, 9093, 9121, 9146, 9174,
	/* 218 */ 9282, 9294, 9313, 9332,
	/* 222 */ 9359, 9383, 9401, 9420, 9440, 9459, 9481, 9506, 9531, 9558, 9585, 9609, 9631, 9659, 9684, 9712, 9740, 9762, 9786, 9810, 9834, 9855, 9876, 9901, 9930, 9955, 9981, 10004, 10028, 10055, 10083, 10111, 10139, 10161, 10183, 10207, 10227, 10247, 10267, 10287, 10307, 10327, 10347, 10381, 10415, 10444, 10473, 10502, 10531, 10560, 10589, 10620, 10650, 10681, 10711, 10741, 10772, 10803, 10823, 10845, 10863, 10890, 10914, 10940,
	/* 286 */ 10974, 10995, 11016, 11039, 11062, 11082, 11102, 11127, 11148, 11174, 11194, 11216, 11242, 11263, 11287, 11314,
	/* 302 */ 11418, 11437, 11456, 11475, 11494, 11513, 11532, 11551, 11570, 11585, 11600, 11615, 11632, 11653, 11674, 11694,
	/* 318 */ 11877, 11889, 11903, 11927, 11957, 11982, 12013, 12033,
	/* 326 */ 12099, 12126, 12152, 12179, 12210, 12239, 12269, 12303,
	/* 334 */ 12525, 12548,
	/* 336 */ 12525, 12548, 12588, 12617,
	/* 340 */ 12663, 12684, 12706,
	/* 343 */ 12833, 12865, 12898, 12931,
	/* 347 */ 13122,
	/* 348 */ 13421, 13437, 13453, 13469, 13485, 13501, 13517, 13533, 13549, 13565, 13581, 13597, 13612, 13627, 13642, 13658,
	/* 364 */ 14070, 14101, 14129, 14158,
	/* 368 */ 14203, 14224, 14245, 14266, 14287, -1, -1, 14308, 14329, -1, -1, -1, 14351, 14372, 14393, 14415,
	/* 384 */ 14443, 14456, 14479, 14502, 14525, 14545, 14566, 14587, 14608, 14634, 14660, 14686, 14713, 14740, 14767,
	/* 399 */ 14806, 14831, 14857, 14883, 14909, 14934, 14959,
	/* 406 */ 14995, 15018, 15041, 15064,
	/* 410 */ 15098, 15122, 15146, 15170,
	/* 414 */ 15206, 15231, 15256, 15281,
	/* 418 */ 15324, 15341, 15358, 15375,
	/* 422 */ 14070, 14101, 14129, 15403,
	/* 426 */ -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15518, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15532, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 15546,
	/* 667 */ 16476, 16494, 16509,
	/* 670 */ 18046, 18056, 18069, 18083,
	/* 674 */ 18380, 18395, 18411, 18427,
	/* 678 */ 18592, 18602, 18620, 18630,
	/* 682 */ 14203, 14224, 14245, -1, 14287, 19035, 19057,
	/* 689 */ 14443, -1, -1, -1, 14525, 14545, 14566, 14587, 14608, 14634, 14660, 14686, 14713, 14740, 14767, -1, 19082, 19109,
	/* 707 */ 19137, 19147, 19152, 19157,
	/* 711 */ 19299, 19315,
	/* 713 */ 19793, 19816, 19839, 19862,
	/* 717 */ 19909, 19934, 19959, 19984,
	/* 721 */ 20034, 20058, 20082, 20106,
	/* 725 */ 20138, 20163, 20188, 20213,
	/* 729 */ 20247, 20272, 20297, 20322,
	/* 733 */ 20356, 20382, 20408, 20434,
	/* 737 */ 20470, 20493, 20516, 20539,
	/* 741 */ 20569, 20603, 20638, 20673,
	/* 745 */ 20716, 20750, 20785, 20820,
	/* 749 */ 20863, 20886, 20909, 20932,
	/* 753 */ 20962, 20996, 21031, 21066,
	/* 757 */ 21109, 21143, 21178, 21213,
	/* 761 */ 21256, 21284, 21312, 21340,
	/* 765 */ 21380, 21419, 21459, 21499,
	/* 769 */ 21552, 21591, 21631, 21671,
	/* 773 */ 21819, 21832, 21845, 21858, 21879, 21898, 21916, 21934, 21949, 21966, 21983, 21995, 22006, 22018, 22031, 22043,
	/* 789 */ 22267,
	/* 790 */ 22796, 22817, 22838, 22859, 22880,
	/* 795 */ 23141,
	/* 796 */ 23321, 23337, 23354, 23371, 23392,
	/* 801 */ 23485, 23501, 23517, 23534, 23551, 23572, 23596, 23620, 23643, 23666,
	/* 811 */ 23853, 23880, 23898, 23916, 23938, 23962, 23983, 24002, 24023, 24044, 24066,
	/* 822 */ 24128, 24134, -1, 24147, -1, -1, -1, 24160, -1, -1, -1, 24172, -1, 24184, -1, 24196,
	/* 838 */ 24703, 24738, 24773, 24805, 24837, 24869, 24901, 24935,
	/* 846 */ 24999, 25013, 25026, 25044, 25057, 25070, 25091, 25115,
	/* 854 */ 25191, 25202, 25212, 25228, 25254, 25270, 25296, 25312, 25338, 25354, 25380, -1, -1, 25405, 25426, 25457, 25474, 25495, 25512, 25533, 25554,
	/* 875 */ 25600, 25618, 25637, 25654, 25671,
	/* 880 */ 25794, 25809, 25830, 25852,
	/* 884 */ 25886, 25902,
	/* 886 */ 26010, 26021, 26031, 26042, 26054, 26067, 26081, 26093,
	/* 894 */ 26121, 26131, 26140, 26150, 26161, 26173, 26186, 26197,
	/* 902 */ 26618, 26629, 26639, 26663, -1, 26674, 26694,
	/* 909 */ 26712, -1, -1, -1, -1, 26719, -1, -1, -1, -1, 26726, -1, -1, -1, -1, 26733, -1, 26740, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26747, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26754, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26761, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26768, -1, -1, -1, -1, 26775, -1, -1, -1, -1, 26782, -1, -1, -1, -1, 26789, -1, -1, -1, -1, -1, -1, 26796, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26803, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26810, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26817, -1, -1, -1, -1, -1, -1, 26824, -1, -1, -1, -1, 26831, -1, -1, -1, -1, 26838, -1, -1, -1, -1, 26845, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26852, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26859, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26866, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26873, -1, 26880, -1, -1, -1, -1, 26887, -1, -1, -1, -1, 26894, -1, -1, -1, -1, 26901,
	/* 1165 */ 26984, 26991, 27011, 27016,
	/* 1169 */ 27162, 27175, 27194, 27216,
	/* 1173 */ 27602, 27622,
	/* 1175 */ 27634, 27648, 27661,
	/* 1178 */ 29192, 29214, 29234, 29255, 29276,
	/* 1183 */ 29331, 29348, 29364, 29379, 29395, 29411, 29435, 29459, 29483, 29507, 29528, 29544, 29559, 29583, 29606, 29630, 29650, 29669,
	/* 1201 */ 29712, 29725, 29739, 29751, 29764,
	/* 1206 */ 29848, 29865, 29882, 29898, 29914, 29930, 29946, 29963, 29981,
	/* 1215 */ 30053, 30060, 30074, 30088, 30102, 30116,
	/* 1221 */ 30126, 30138, 30149, 30160,
	/* 1225 */ 30332, -1, -1, 30347,
	/* 1229 */ 31016, 31039, 31062,
	/* 1232 */ 31165, 31178, 31191,
	/* 1235 */ 31203, 31221, 31241, 31261,
	/* 1239 */ 31289, 31305, 31322,
	/* 1242 */ 31349, 31364,
	/* 1244 */ -1, 31456, 31479, 31502, 31525, 31540, 31553, 31565, 31582, -1, 31601, 31621, 31641, 31660, -1, 31672, 31689, 31706, 31722, -1, 31738, 31767, 31778, 31804, 31822, 31839, 31858, 31876, 31895, 31911, 31927, 31947, 31969, 31991, 32005, 32024, 32040, -1, -1, 32050, 32065, -1, 32083, 32106, 32131, 32153, 32178, 7592, 7619, 32200, -1, 32228, 32247, 32265, 32285, 32304, 32324, 32348, 32369,
	/* 1303 */ 32878, 32891, 32903,
	/* 1306 */ 32915, 32928, 32940,
	/* 1309 */ 32954, 32968, 32980,
	/* 1312 */ 33111, 33124, 33138,
	/* 1315 */ 33148, 33161, 33171, 33185,
	/* 1319 */ 33213, 33226, 33238, 33257,
	/* 1323 */ 31349, 31364, 33354,
	/* 1326 */ 33372, 33398, 33424, 33449,
	/* 1330 */ 34228, 34239, 34247, 34263,
	/* 1334 */ 34289, 34315, 34340, 34365, 34388, 34409, 34436, 34465,
	/* 1342 */ 34802, 34814, 34827, 34840,
	/* 1346 */ 34860, 34874, 34882, 34891, 34901, 34910, 34922, 34937, 34952, 34969, 34986, 35000, 35012, -1, 35030, -1, 35048, 35060, 35074, 35088, 35102, 35113, 35124,
	/* 1369 */ 35145, 35158, -1, -1, 35171, 35183, 35195, 35207,
	/* 1377 */ 35232, 35241, 35250, 35263,
	/* 1381 */ 35340, 35355, 35373, 35401, 35431, 35462, 35490,
};

#endif
