/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class VersionManagement {
    public static String JHOTDRAW_COMPONENT = "org.jhotdraw/";
    public static String JHOTDRAW_JAR = "jhotdraw.jar";
    public static Package[] packages = new Package[]{Package.getPackage("org.jhotdraw.applet"), Package.getPackage("org.jhotdraw.application"), Package.getPackage("org.jhotdraw.contrib"), Package.getPackage("org.jhotdraw.figures"), Package.getPackage("org.jhotdraw.framework"), Package.getPackage("org.jhotdraw.standard"), Package.getPackage("org.jhotdraw.util")};

    public static String getJHotDrawVersion() {
        Package package_ = packages[4];
        return package_.getSpecificationVersion();
    }

    public static String getPackageVersion(Package package_) {
        if (package_ == null) {
            return null;
        }
        String string = package_.getSpecificationVersion();
        if (string != null) {
            return string;
        }
        String string2 = VersionManagement.normalizePackageName(package_.getName());
        String string3 = VersionManagement.getNextPackage(string2);
        return VersionManagement.getPackageVersion(Package.getPackage(string3));
    }

    public static boolean isCompatibleVersion(String string) {
        Package package_ = packages[4];
        if (string == null) {
            return package_.getSpecificationVersion() == null;
        }
        return package_.isCompatibleWith(string);
    }

    public static String readVersionFromFile(String string, String string2) {
        try {
            FileInputStream fileInputStream = new FileInputStream(string2);
            Manifest manifest = new Manifest();
            manifest.read(fileInputStream);
            Map<String, Attributes> map = manifest.getEntries();
            Iterator<Map.Entry<String, Attributes>> iterator = map.entrySet().iterator();
            if (iterator.hasNext()) {
                Map.Entry<String, Attributes> entry = iterator.next();
                String string3 = entry.getKey().toString();
                string3 = VersionManagement.normalizePackageName(string3);
                Attributes attributes = entry.getValue();
                String string4 = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
                string4 = VersionManagement.extractVersionInfo(string4);
                return string4;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    protected static String getNextPackage(String string) {
        if (string == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n > 0) {
            return string.substring(0, n);
        }
        return null;
    }

    public static String normalizePackageName(String string) {
        String string2 = string.replace('/', '.');
        if ((string2 = string2.replace(File.pathSeparatorChar, '.')).endsWith(".")) {
            int n = string2.lastIndexOf(46);
            return string2.substring(0, n);
        }
        return string2;
    }

    public static String extractVersionInfo(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        int n = string.indexOf("\"");
        n = n < 0 ? 0 : ++n;
        int n2 = string.lastIndexOf("\"");
        if (n2 < 0) {
            n2 = string.length();
        }
        return string.substring(n, n2);
    }
}

