/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.AbstractCollectionTester;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

@GwtCompatible
public class CollectionClearTester<E>
extends AbstractCollectionTester<E> {
    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE})
    public void testClear() {
        this.collection.clear();
        CollectionClearTester.assertTrue((String)"After clear(), a collection should be empty.", (boolean)this.collection.isEmpty());
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testClear_unsupported() {
        try {
            this.collection.clear();
            CollectionClearTester.fail((String)"clear() should throw UnsupportedOperation if a collection does not support it and is not empty.");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(absent={CollectionFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testClear_unsupportedByEmptyCollection() {
        try {
            this.collection.clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        this.expectUnchanged();
    }

    @CollectionFeature.Require(value={CollectionFeature.SUPPORTS_REMOVE, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testClearConcurrentWithIteration() {
        try {
            Iterator iterator = this.collection.iterator();
            this.collection.clear();
            iterator.next();
            CollectionClearTester.fail((String)"Expected ConcurrentModificationException");
        }
        catch (ConcurrentModificationException concurrentModificationException) {
            // empty catch block
        }
    }
}

