/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent.testing;

import com.google.common.annotations.Beta;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;

@Beta
public class MockFutureListener
implements Runnable {
    private final CountDownLatch countDownLatch = new CountDownLatch(1);
    private final ListenableFuture<?> future;

    public MockFutureListener(ListenableFuture<?> future) {
        this.future = future;
        future.addListener((Runnable)this, (Executor)MoreExecutors.sameThreadExecutor());
    }

    @Override
    public void run() {
        this.countDownLatch.countDown();
    }

    public void assertSuccess(Object expectedData) throws Throwable {
        Assert.assertTrue((boolean)this.countDownLatch.await(1L, TimeUnit.SECONDS));
        try {
            Assert.assertEquals((Object)expectedData, (Object)this.future.get());
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public void assertException(Throwable expectedCause) throws Exception {
        Assert.assertTrue((boolean)this.countDownLatch.await(1L, TimeUnit.SECONDS));
        try {
            this.future.get();
            Assert.fail((String)"This call was supposed to throw an ExecutionException");
        }
        catch (ExecutionException expected) {
            Assert.assertSame((Object)expectedCause, (Object)expected.getCause());
        }
    }

    public void assertTimeout() throws Exception {
        Assert.assertFalse((boolean)this.countDownLatch.await(1L, TimeUnit.SECONDS));
    }
}

