.SS "STRESS OPTION COMMANDS"
These command manage stress options, which allow developers testing
Open vSwitch to trigger behavior that otherwise would occur only in
corner cases.  Developers and testers can thereby more easily discover
bugs that would otherwise manifest only rarely or
nondeterministically.  Stress options may cause surprising behavior
even when they do not actually reveal bugs, so they should only be
enabled as part of testing Open vSwitch.
.
.IP "\fBstress/enable\fR"
.IQ "\fBstress/disable\fR"
All stress options are disabled by default.  Use \fBstress/enable\fR
to enable stress options and \fBstress/disable\fR to disable them.
.
.IP "\fBstress/list\fR"
Lists and describes the available stress options and their settings in
tabular form.  The columns in the table are:
.RS
.IP "NAME"
A single-word identifier for the option, used to identify stress
options to \fBstress/set\fR.
.
.IP "DESCRIPTION"
A description for a person unfamiliar with the detailed internals of
the code what behavior the option affects.
.
.IP "PERIOD"
Currently configured trigger period.  If the stress option is
disabled, this is \fBdisabled\fR.  Otherwise this is a number giving
the number of occurrences of the event between activations of the
stress option triggers.
.
.IP "MODE"
If the stress option is disabled, this is \fBn/a\fR.  Otherwise it is
\fBperiodic\fR if the stress option triggers after exactly the period,
or \fBrandom\fR if it triggers randomly but on average after the
number of occurrences specified by the period.
.
.IP "COUNTER"
If the stress option is disabled, this is \fBn/a\fR.  Otherwise it is
the number of occurrences of the event before the next time the stress
option triggers.
.
.IP "HITS"
The number of times that this stress option has triggered since this
program started.
.
.IP "RECOMMENDED"
A suggested period for a person unfamiliar with the internals.  It
should put reasonable stress on the system without crippling it.
.
.IP "MINIMUM"
.IQ "MAXIMUM"
Minimum and maximum values allowed for the period.
.
.IP "DEFAULT"
The default period, used when stress options have been enabled (with
\fBstress/enable\fR) but this particular stress option has not been
specifically configured (with \fBstress/set\fR).  It is \fBdisabled\fR
if the option is disabled by default.  It is nonzero for options that
can be left on at low levels without noticeable impact to the end user.
.RE
.
.IP "\fBstress/set \fIoption\fR \fIperiod\fR [\fBrandom\fR|\fBperiodic\fR]"
Sets the period at which stress \fIoption\fR triggers to
\fIperiod\fR.  A \fIperiod\fR of 0 disables \fIoption\fR.  Specify
\fBrandom\fR to make the option trigger randomly with an average
period of \fIperiod\fR, or \fBperiodic\fR to trigger exactly every
\fIperiod\fR events; the latter is the default.
.IP
If stress options have not been enabled with \fBstress/enable\fR, this
command has no effect.
