# PySNMP SMI module. Autogenerated from smidump -f python ROHC-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:34 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( ifIndex, ) = mibBuilder.importSymbols("IF-MIB", "ifIndex")
( SnmpAdminString, ) = mibBuilder.importSymbols("SNMP-FRAMEWORK-MIB", "SnmpAdminString")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "Unsigned32", "mib-2")
( DateAndTime, TextualConvention, TimeInterval, TruthValue, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "TextualConvention", "TimeInterval", "TruthValue")

# Types

class RohcChannelIdentifier(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(1,4294967295)
    
class RohcChannelIdentifierOrZero(TextualConvention, Unsigned32):
    displayHint = "d"
    subtypeSpec = Unsigned32.subtypeSpec+ValueRangeConstraint(0,4294967295)
    
class RohcCompressionRatio(TextualConvention, Unsigned32):
    displayHint = "d"
    

# Objects

rohcMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 112)).setRevisions(("2004-06-03 00:00",))
if mibBuilder.loadTexts: rohcMIB.setOrganization("IETF Robust Header Compression Working Group")
if mibBuilder.loadTexts: rohcMIB.setContactInfo("WG charter:\nhttp://www.ietf.org/html.charters/rohc-charter.html\n\nMailing Lists:\nGeneral Discussion: rohc@ietf.org\nTo Subscribe: rohc-request@ietf.org\nIn Body: subscribe your_email_address\n\nEditor:\nJuergen Quittek\nNEC Europe Ltd.\nNetwork Laboratories\nKurfuersten-Anlage 36\n\n\n\n69221 Heidelberg\nGermany\nTel: +49 6221 90511-15\nEMail: quittek@netlab.nec.de")
if mibBuilder.loadTexts: rohcMIB.setDescription("This MIB module defines a set of basic objects for\nmonitoring and configuring robust header compression.\nThe module covers information about running instances\nof ROHC (compressors or decompressors) at IP interfaces.\n\nInformation about compressor contexts and decompressor\ncontexts has different structure for different profiles.\nTherefore it is not provided by this MIB module, but by\nindividual modules for different profiles.\n\nCopyright (C) The Internet Society (2004). The\ninitial version of this MIB module was published\nin RFC 3816. For full legal notices see the RFC\nitself or see:\nhttp://www.ietf.org/copyrights/ianamib.html")
rohcObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 112, 1))
rohcInstanceObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 112, 1, 1))
rohcChannelTable = MibTable((1, 3, 6, 1, 2, 1, 112, 1, 1, 1))
if mibBuilder.loadTexts: rohcChannelTable.setDescription("This table lists and describes all ROHC channels\nper interface.")
rohcChannelEntry = MibTableRow((1, 3, 6, 1, 2, 1, 112, 1, 1, 1, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "ROHC-MIB", "rohcChannelID"))
if mibBuilder.loadTexts: rohcChannelEntry.setDescription("An entry describing a particular script.  Every script that\nis stored in non-volatile memory is required to appear in\n\n\n\nthis script table.\n\nNote, that the rohcChannelID identifies the channel\nuniquely.  The ifIndex is part of the index of this table\njust in order to allow addressing channels per interface.")
rohcChannelID = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 1, 1, 2), RohcChannelIdentifier()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rohcChannelID.setDescription("The locally arbitrary, but unique identifier associated\nwith this channel.  The value is REQUIRED to be unique\nper ROHC MIB implementation independent of the associated\ninterface.\n\nThe value is REQUIRED to remain constant at least from one\nre-initialization of the entity's network management system\nto the next re-initialization.  It is RECOMMENDED that the\nvalue persist across such re-initializations.")
rohcChannelType = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 1, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(3,1,2,)).subtype(namedValues=NamedValues(("notInUse", 1), ("rohc", 2), ("dedicatedFeedback", 3), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcChannelType.setDescription("Type of usage of the channel.  A channel might be currently\nnot in use for ROHC or feedback, it might be in use as\na ROHC channel carrying packets and optional piggy-backed\nfeedback, or it might be used as a dedicated feedback\nchannel exclusively carrying feedback.")
rohcChannelFeedbackFor = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 1, 1, 4), RohcChannelIdentifierOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcChannelFeedbackFor.setDescription("The index of another channel of this interface for which\nthe channel serves as feedback channel.\n\nIf no feedback information is transferred on this channel,\nthen the value of this ID is 0.  If the channel type is set\nto notInUse(1), then the value of this object must be 0.\nIf the channel type is rohc(2) and the value of this object\nis a valid channel ID, then feedback information is\npiggy-backed on the ROHC channel.  If the channel type is\ndedicatedFeedback(3), then feedback is transferred on this\nchannel and the value of this object MUST be different from\n0 and MUST identify an existing ROHC channel.")
rohcChannelDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 1, 1, 5), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcChannelDescr.setDescription("A textual description of the channel.")
rohcChannelStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 1, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcChannelStatus.setDescription("Status of the channel.")
rohcInstanceTable = MibTable((1, 3, 6, 1, 2, 1, 112, 1, 1, 2))
if mibBuilder.loadTexts: rohcInstanceTable.setDescription("This table lists properties of running instances\nof robust header compressors and decompressors\nat IP interfaces.  It is indexed by interface number,\nthe type of instance (compressor or decompressor),\nand the ID of the channel used by the instance as\nROHC channel.\n\nNote that the rohcChannelID uniquely identifies an\ninstance.  The ifIndex and rohcInstanceType are part\nof the index, because it simplifies accessing instances\nper interface and for addressing either compressors or\ndecompressors only.")
rohcInstanceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1)).setIndexNames((0, "IF-MIB", "ifIndex"), (0, "ROHC-MIB", "rohcInstanceType"), (0, "ROHC-MIB", "rohcChannelID"))
if mibBuilder.loadTexts: rohcInstanceEntry.setDescription("An entry describing a particular instance\nof a robust header compressor or decompressor.")
rohcInstanceType = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 2), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,)).subtype(namedValues=NamedValues(("compressor", 1), ("decompressor", 2), ))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rohcInstanceType.setDescription("Type of the instance of ROHC. It is either a\ncompressor instance or a decompressor instance.")
rohcInstanceFBChannelID = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 4), RohcChannelIdentifierOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceFBChannelID.setDescription("Identifier of the channel used for feedback.\nIf no feedback channel is used, the value of\nthis object is 0 .")
rohcInstanceVendor = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 5), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceVendor.setDescription("An object identifier that identifies the vendor who\nprovides the implementation of robust header description.\nThis object identifier SHALL point to the object identifier\ndirectly below the enterprise object identifier\n{1 3 6 1 4 1} allocated for the vendor.  The value must be\nthe object identifier {0 0} if the vendor is not known.")
rohcInstanceVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 6), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceVersion.setDescription("The version number of the implementation of robust header\ncompression.  The zero-length string shall be used if the\nimplementation does not have a version number.\n\n\n\n\nIt is suggested that the version number consist of one or\nmore decimal numbers separated by dots, where the first\nnumber is called the major version number.")
rohcInstanceDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 7), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceDescr.setDescription("A textual description of the implementation.")
rohcInstanceClockRes = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceClockRes.setDescription("This object indicates the system clock resolution in\nunits of milliseconds.  A zero (0) value means that there\nis no clock available.")
rohcInstanceMaxCID = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 9), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 16383))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceMaxCID.setDescription("The highest context ID number to be used by the\ncompressor.  Note that this parameter is not coupled to,\nbut in effect further constrained by,\nrohcChannelLargeCIDs.")
rohcInstanceLargeCIDs = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 10), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceLargeCIDs.setDescription("When retrieved, this boolean object returns false if\nthe short CID representation (0 bytes or 1 prefix byte,\ncovering CID 0 to 15) is used; it returns true, if the\nembedded CID representation (1 or 2 embedded CID bytes\ncovering CID 0 to 16383) is used.")
rohcInstanceMRRU = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 11), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceMRRU.setDescription("Maximum reconstructed reception unit.  This is the\nsize of the largest reconstructed unit in octets that\nthe decompressor is expected to reassemble from\nsegments (see RFC 3095, Section 5.2.5).  Note that this\nsize includes the CRC.  If MRRU is negotiated to be 0,\nno segment headers are allowed on the channel.")
rohcInstanceContextStorageTime = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 12), TimeInterval().clone('360000')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rohcInstanceContextStorageTime.setDescription("This object indicates the default maximum amount of time\ninformation on a context belonging to this instance is kept\nas entry in the rohcContextTable after the context is\nexpired or terminated.  The value of this object is used\nto initialize rohcContexStorageTime object when a new\ncontext is created.\nChanging the value of an rohcInstanceContextStorageTime\ninstance does not affect any entry of the rohcContextTable\ncreated previously.\nROHC-MIB implementations SHOULD store the set value of this\nobject persistently.")
rohcInstanceStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 13), Integer().subtype(subtypeSpec=SingleValueConstraint(2,1,)).subtype(namedValues=NamedValues(("enabled", 1), ("disabled", 2), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceStatus.setDescription("Status of the instance of ROHC.")
rohcInstanceContextsTotal = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceContextsTotal.setDescription("Counter of all contexts created by this instance.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
rohcInstanceContextsCurrent = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 15), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceContextsCurrent.setDescription("Number of currently active contexts created by this\ninstance.")
rohcInstancePackets = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 16), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstancePackets.setDescription("Counter of all packets passing this instance.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
rohcInstanceIRs = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 17), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceIRs.setDescription("The number of all IR packets that are either sent\nor received by this instance.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\n\n\n\nvalue of ifCounterDiscontinuityTime.")
rohcInstanceIRDYNs = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 18), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceIRDYNs.setDescription("The number of all IR-DYN packets that are either sent\nor received by this instance.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
rohcInstanceFeedbacks = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 19), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceFeedbacks.setDescription("The number of all feedbacks that are either sent\nor received by this instance.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.")
rohcInstanceCompressionRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 2, 1, 20), RohcCompressionRatio()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcInstanceCompressionRatio.setDescription("This object indicates the compression ratio so far over all\npackets on the channel served by this instance.  The\ncompression is computed over all bytes of the IP packets\nincluding the IP header but excluding all lower layer\nheaders.")
rohcProfileTable = MibTable((1, 3, 6, 1, 2, 1, 112, 1, 1, 3))
if mibBuilder.loadTexts: rohcProfileTable.setDescription("This table lists a set of profiles supported by the\ninstance.")
rohcProfileEntry = MibTableRow((1, 3, 6, 1, 2, 1, 112, 1, 1, 3, 1)).setIndexNames((0, "ROHC-MIB", "rohcChannelID"), (0, "ROHC-MIB", "rohcProfile"))
if mibBuilder.loadTexts: rohcProfileEntry.setDescription("An entry describing a particular profile supported by\nthe instance.  It is indexed by the rohcChannelID\nidentifying the instance and by the rohcProfile.")
rohcProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 3, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rohcProfile.setDescription("Identifier of a profile supported.  For a listing of\npossible profile values, see the IANA registry for\n'RObust Header Compression (ROHC) Profile Identifiers'\nat http://www.iana.org/assignments/rohc-pro-ids")
rohcProfileVendor = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 3, 1, 3), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcProfileVendor.setDescription("An object identifier that identifies the vendor who\nprovides the implementation of robust header description.\nThis object identifier SHALL point to the object identifier\ndirectly below the enterprise object identifier\n{1 3 6 1 4 1} allocated for the vendor.  The value must be\nthe object identifier {0 0} if the vendor is not known.")
rohcProfileVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 3, 1, 4), SnmpAdminString().subtype(subtypeSpec=ValueSizeConstraint(0, 32))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcProfileVersion.setDescription("The version number of the implementation of robust header\ncompression.  The zero-length string shall be used if the\nimplementation does not have a version number.\n\nIt is suggested that the version number consist of one or\nmore decimal numbers separated by dots, where the first\nnumber is called the major version number.")
rohcProfileDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 3, 1, 5), SnmpAdminString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcProfileDescr.setDescription("A textual description of the implementation.")
rohcProfileNegotiated = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 1, 3, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcProfileNegotiated.setDescription("When retrieved, this boolean object returns true\nif the profile has been negotiated to be used at\nthe instance, i.e., is supported also be the\ncorresponding compressor/decompressor.")
rohcContextTable = MibTable((1, 3, 6, 1, 2, 1, 112, 1, 2))
if mibBuilder.loadTexts: rohcContextTable.setDescription("This table lists and describes all compressor contexts\nper instance.")
rohcContextEntry = MibTableRow((1, 3, 6, 1, 2, 1, 112, 1, 2, 1)).setIndexNames((0, "ROHC-MIB", "rohcChannelID"), (0, "ROHC-MIB", "rohcContextCID"))
if mibBuilder.loadTexts: rohcContextEntry.setDescription("An entry describing a particular compressor context.")
rohcContextCID = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 2), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 16383))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: rohcContextCID.setDescription("The context identifier (CID) of this context.")
rohcContextCIDState = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 3), Integer().subtype(subtypeSpec=SingleValueConstraint(1,2,3,4,)).subtype(namedValues=NamedValues(("unused", 1), ("active", 2), ("expired", 3), ("terminated", 4), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextCIDState.setDescription("State of the CID.  When a CID is assigned to a context,\nits state changes from `unused' to `active'.  The active\ncontext may stop operation due to some explicit\nsignalling or after observing no packet for some specified\ntime.  In the first case then the CID state changes to\n`terminated', in the latter case it changes to `expired'.\nIf the CID is re-used again for another context, the\nstate changes back to `active'.")
rohcContextProfile = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 4), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0, 65535))).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextProfile.setDescription("Identifier of the profile for this context.\nThe profile is identified by its index in the\nrohcProfileTable for this instance.  There MUST exist a\ncorresponding entry in the rohcProfileTable using the\nvalue of rohcContextProfile as second part of the index\n(and using the same rohcChannelID as first part of the\nindex).")
rohcContextDecompressorDepth = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextDecompressorDepth.setDescription("This object indicates whether reverse decompression, for\nexample as described in RFC 3095, Section 6.1, is used\non this channel or not, and if used, to what extent.\n\n\n\n\nIts value is only valid for decompressor contexts, i.e.,\nif rohcInstanceType has the value decompressor(2).  For\ncompressor contexts where rohcInstanceType has the value\ncompressor(1), the value of this object is irrelevant\nand MUST be set to zero (0).\n\nThe value of the reverse decompression depth indicates\nthe maximum number of packets that are buffered, and thus\npossibly be reverse decompressed by the decompressor.\nA zero (0) value means that reverse decompression is not\nused.")
rohcContextStorageTime = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 6), TimeInterval()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: rohcContextStorageTime.setDescription("The value of this object specifies how long this row\ncan exist in the rohcContextTable after the\nrohcContextCIDState switched to expired(3) or\nterminated(4).  This object returns  the remaining time\nthat the row may exist before it is aged out.  The object\nis initialized with the value of the  associated\nrohcContextStorageTime object.  After expiration or\ntermination of the context, the value of this object ticks\nbackwards.  The entry in the rohcContextTable is destroyed\nwhen the value reaches 0.\n\nThe value of this object may be set in order to increase or\nreduce the remaining time that the row may exist.  Setting\nthe value to 0 will destroy this entry as soon as the\nrochContextCIDState has the value expired(3) or\nterminated(4).\n\nNote that there is no guarantee that the row is stored as\nlong as this object indicates.  In case of limited CID\nspace, the instance may re-use a CID before the storage\ntime of the corresponding row in rohcContextTable reaches\nthe value of 0.  In this case the information stored in this\nrow is not anymore available.")
rohcContextActivationTime = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 7), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextActivationTime.setDescription("The date and time when the context started to be able to\ncompress packets or decompress packets, respectively.\nThe value '0000000000000000'H is returned if the context\nhas not been activated yet.")
rohcContextDeactivationTime = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 8), DateAndTime().clone(hexValue='0000000000000000')).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextDeactivationTime.setDescription("The date and time when the context stopped being able to\ncompress packets or decompress packets, respectively,\nbecause it expired or was terminated for other reasons.\nThe value '0000000000000000'H is returned if the context\nhas not been deactivated yet.")
rohcContextPackets = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 9), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextPackets.setDescription("The number of all packets passing this context.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.  For checking\nifCounterDiscontinuityTime, the interface index is\nrequired.  It can be determined by reading the\nrohcChannelTable.")
rohcContextIRs = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 10), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextIRs.setDescription("The number of all IR packets sent or received,\nrespectively, by this context.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\n\n\n\nvalue of ifCounterDiscontinuityTime.  For checking\nifCounterDiscontinuityTime, the interface index is\nrequired.  It can be determined by reading the\nrohcChannelTable.")
rohcContextIRDYNs = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 11), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextIRDYNs.setDescription("The number of all IR-DYN packets sent or received,\nrespectively, by this context.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.  For checking\nifCounterDiscontinuityTime, the interface index is\nrequired.  It can be determined by reading the\nrohcChannelTable.")
rohcContextFeedbacks = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 12), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextFeedbacks.setDescription("The number of all feedbacks sent or received,\nrespectively, by this context.\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.  For checking\nifCounterDiscontinuityTime, the interface index is\nrequired.  It can be determined by reading the\nrohcChannelTable.")
rohcContextDecompressorFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 13), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextDecompressorFailures.setDescription("The number of all decompressor failures so far in this\ncontext. The number is only valid for decompressor\ncontexts, i.e., if rohcInstanceType has the value\ndecompressor(2).\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.  For checking\nifCounterDiscontinuityTime, the interface index is\nrequired.  It can be determined by reading the\nrohcChannelTable.")
rohcContextDecompressorRepairs = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 14), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextDecompressorRepairs.setDescription("The number of all context repairs so far in this\ncontext.  The number is only valid for decompressor\ncontexts, i.e., if rohcInstanceType has the value\ndecompressor(2).\n\nDiscontinuities in the value of this counter can\noccur at re-initialization of the management\nsystem, and at other times as indicated by the\nvalue of ifCounterDiscontinuityTime.  For checking\nifCounterDiscontinuityTime, the interface index is\nrequired.  It can be determined by reading the\nrohcChannelTable.")
rohcContextAllPacketsRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 15), RohcCompressionRatio()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextAllPacketsRatio.setDescription("This object indicates the compression ratio so far over all\npackets passing this context.  The compression is computed\nover all bytes of the IP packets including the IP header\nbut excluding all lower layer headers.")
rohcContextAllHeadersRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 16), RohcCompressionRatio()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextAllHeadersRatio.setDescription("This object indicates the compression ratio so far over all\npacket headers passing this context.  The compression is\ncomputed over all bytes of all headers that are subject to\ncompression for the used profile.")
rohcContextAllPacketsMeanSize = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 17), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextAllPacketsMeanSize.setDescription("This object indicates the mean compressed packet size\nof all packets passing this context.  The packet size\nincludes the IP header and payload but excludes all lower\nlayer headers.  The mean value is given in byte rounded\nto the next integer value.")
rohcContextAllHeadersMeanSize = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 18), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextAllHeadersMeanSize.setDescription("This object indicates the mean compressed packet header size\nof all packets passing this context.  The packet header size\nis the sum of the size of all headers of a packet that are\nsubject to compression for the used profile.  The mean value\nis given in byte rounded to the next integer value.")
rohcContextLastPacketsRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 19), RohcCompressionRatio()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextLastPacketsRatio.setDescription("This object indicates the compression ratio\nconcerning the last 16 packets passing this context\nor concerning all packets passing this context\nif they are less than 16, so far.  The compression is\ncomputed over all bytes of the IP packets including the IP\nheader but excluding all lower layer headers.")
rohcContextLastHeadersRatio = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 20), RohcCompressionRatio()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextLastHeadersRatio.setDescription("This object indicates the compression ratio concerning the\nheaders of the last 16 packets passing this context or\nconcerning the headers of all packets passing this context\nif they are less than 16, so far.  The compression is\ncomputed over all bytes of all headers that are subject to\ncompression for the used profile.")
rohcContextLastPacketsMeanSize = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 21), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextLastPacketsMeanSize.setDescription("This object indicates the mean compressed packet size\nconcerning the last 16 packets passing this context or\nconcerning all packets passing this context if they are\nless than 16, so far.  The packet size includes the IP\nheader and payload but excludes all lower layer headers.\nThe mean value is given in byte rounded to the next\ninteger value.")
rohcContextLastHeadersMeanSize = MibTableColumn((1, 3, 6, 1, 2, 1, 112, 1, 2, 1, 22), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: rohcContextLastHeadersMeanSize.setDescription("This object indicates the mean compressed packet header size\nconcerning the last 16 packets passing this context or\nconcerning all packets passing this context if they are\nless than 16, so far.  The packet header size is the sum of\nthe size of all headers of a packet that are subject to\ncompression for the used profile.  The mean value is given\nin byte rounded to the next integer value.")
rohcConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 112, 2))
rohcCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 112, 2, 1))
rohcGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 112, 2, 2))

# Augmentions

# Groups

rohcInstanceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 112, 2, 2, 2)).setObjects(*(("ROHC-MIB", "rohcChannelType"), ("ROHC-MIB", "rohcInstanceDescr"), ("ROHC-MIB", "rohcProfileDescr"), ("ROHC-MIB", "rohcInstanceStatus"), ("ROHC-MIB", "rohcInstanceFBChannelID"), ("ROHC-MIB", "rohcInstanceLargeCIDs"), ("ROHC-MIB", "rohcInstanceMRRU"), ("ROHC-MIB", "rohcProfileNegotiated"), ("ROHC-MIB", "rohcInstanceVersion"), ("ROHC-MIB", "rohcChannelDescr"), ("ROHC-MIB", "rohcInstanceVendor"), ("ROHC-MIB", "rohcChannelStatus"), ("ROHC-MIB", "rohcChannelFeedbackFor"), ("ROHC-MIB", "rohcProfileVendor"), ("ROHC-MIB", "rohcInstanceClockRes"), ("ROHC-MIB", "rohcProfileVersion"), ("ROHC-MIB", "rohcInstanceMaxCID"), ) )
if mibBuilder.loadTexts: rohcInstanceGroup.setDescription("A collection of objects providing information about\nROHC instances, used channels and available profiles.")
rohcStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 112, 2, 2, 4)).setObjects(*(("ROHC-MIB", "rohcInstanceFeedbacks"), ("ROHC-MIB", "rohcInstancePackets"), ("ROHC-MIB", "rohcInstanceContextsCurrent"), ("ROHC-MIB", "rohcInstanceContextsTotal"), ("ROHC-MIB", "rohcInstanceCompressionRatio"), ("ROHC-MIB", "rohcInstanceIRDYNs"), ("ROHC-MIB", "rohcInstanceIRs"), ) )
if mibBuilder.loadTexts: rohcStatisticsGroup.setDescription("A collection of objects providing ROHC statistics.")
rohcContextGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 112, 2, 2, 5)).setObjects(*(("ROHC-MIB", "rohcContextDecompressorDepth"), ("ROHC-MIB", "rohcContextProfile"), ("ROHC-MIB", "rohcContextCIDState"), ) )
if mibBuilder.loadTexts: rohcContextGroup.setDescription("A collection of objects providing information about\nROHC compressor contexts and decompressor contexts.")
rohcTimerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 112, 2, 2, 6)).setObjects(*(("ROHC-MIB", "rohcContextActivationTime"), ("ROHC-MIB", "rohcContextDeactivationTime"), ("ROHC-MIB", "rohcInstanceContextStorageTime"), ("ROHC-MIB", "rohcContextStorageTime"), ) )
if mibBuilder.loadTexts: rohcTimerGroup.setDescription("A collection of objects providing statistical information\nabout ROHC compressor contexts and decompressor contexts.")
rohcContextStatisticsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 112, 2, 2, 7)).setObjects(*(("ROHC-MIB", "rohcContextIRs"), ("ROHC-MIB", "rohcContextFeedbacks"), ("ROHC-MIB", "rohcContextAllPacketsRatio"), ("ROHC-MIB", "rohcContextPackets"), ("ROHC-MIB", "rohcContextLastPacketsMeanSize"), ("ROHC-MIB", "rohcContextAllHeadersMeanSize"), ("ROHC-MIB", "rohcContextLastPacketsRatio"), ("ROHC-MIB", "rohcContextLastHeadersMeanSize"), ("ROHC-MIB", "rohcContextLastHeadersRatio"), ("ROHC-MIB", "rohcContextIRDYNs"), ("ROHC-MIB", "rohcContextAllPacketsMeanSize"), ("ROHC-MIB", "rohcContextDecompressorRepairs"), ("ROHC-MIB", "rohcContextAllHeadersRatio"), ("ROHC-MIB", "rohcContextDecompressorFailures"), ) )
if mibBuilder.loadTexts: rohcContextStatisticsGroup.setDescription("A collection of objects providing statistical information\nabout ROHC compressor contexts and decompressor contexts.")

# Compliances

rohcCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 112, 2, 1, 1)).setObjects(*(("ROHC-MIB", "rohcContextGroup"), ("ROHC-MIB", "rohcInstanceGroup"), ("ROHC-MIB", "rohcStatisticsGroup"), ("ROHC-MIB", "rohcTimerGroup"), ("ROHC-MIB", "rohcContextStatisticsGroup"), ) )
if mibBuilder.loadTexts: rohcCompliance.setDescription("The compliance statement for SNMP entities that implement\nthe ROHC-MIB.\n\nNote that compliance with this compliance\nstatement requires compliance with the\nifCompliance3 MODULE-COMPLIANCE statement of the\nIF-MIB (RFC2863).")

# Exports

# Module identity
mibBuilder.exportSymbols("ROHC-MIB", PYSNMP_MODULE_ID=rohcMIB)

# Types
mibBuilder.exportSymbols("ROHC-MIB", RohcChannelIdentifier=RohcChannelIdentifier, RohcChannelIdentifierOrZero=RohcChannelIdentifierOrZero, RohcCompressionRatio=RohcCompressionRatio)

# Objects
mibBuilder.exportSymbols("ROHC-MIB", rohcMIB=rohcMIB, rohcObjects=rohcObjects, rohcInstanceObjects=rohcInstanceObjects, rohcChannelTable=rohcChannelTable, rohcChannelEntry=rohcChannelEntry, rohcChannelID=rohcChannelID, rohcChannelType=rohcChannelType, rohcChannelFeedbackFor=rohcChannelFeedbackFor, rohcChannelDescr=rohcChannelDescr, rohcChannelStatus=rohcChannelStatus, rohcInstanceTable=rohcInstanceTable, rohcInstanceEntry=rohcInstanceEntry, rohcInstanceType=rohcInstanceType, rohcInstanceFBChannelID=rohcInstanceFBChannelID, rohcInstanceVendor=rohcInstanceVendor, rohcInstanceVersion=rohcInstanceVersion, rohcInstanceDescr=rohcInstanceDescr, rohcInstanceClockRes=rohcInstanceClockRes, rohcInstanceMaxCID=rohcInstanceMaxCID, rohcInstanceLargeCIDs=rohcInstanceLargeCIDs, rohcInstanceMRRU=rohcInstanceMRRU, rohcInstanceContextStorageTime=rohcInstanceContextStorageTime, rohcInstanceStatus=rohcInstanceStatus, rohcInstanceContextsTotal=rohcInstanceContextsTotal, rohcInstanceContextsCurrent=rohcInstanceContextsCurrent, rohcInstancePackets=rohcInstancePackets, rohcInstanceIRs=rohcInstanceIRs, rohcInstanceIRDYNs=rohcInstanceIRDYNs, rohcInstanceFeedbacks=rohcInstanceFeedbacks, rohcInstanceCompressionRatio=rohcInstanceCompressionRatio, rohcProfileTable=rohcProfileTable, rohcProfileEntry=rohcProfileEntry, rohcProfile=rohcProfile, rohcProfileVendor=rohcProfileVendor, rohcProfileVersion=rohcProfileVersion, rohcProfileDescr=rohcProfileDescr, rohcProfileNegotiated=rohcProfileNegotiated, rohcContextTable=rohcContextTable, rohcContextEntry=rohcContextEntry, rohcContextCID=rohcContextCID, rohcContextCIDState=rohcContextCIDState, rohcContextProfile=rohcContextProfile, rohcContextDecompressorDepth=rohcContextDecompressorDepth, rohcContextStorageTime=rohcContextStorageTime, rohcContextActivationTime=rohcContextActivationTime, rohcContextDeactivationTime=rohcContextDeactivationTime, rohcContextPackets=rohcContextPackets, rohcContextIRs=rohcContextIRs, rohcContextIRDYNs=rohcContextIRDYNs, rohcContextFeedbacks=rohcContextFeedbacks, rohcContextDecompressorFailures=rohcContextDecompressorFailures, rohcContextDecompressorRepairs=rohcContextDecompressorRepairs, rohcContextAllPacketsRatio=rohcContextAllPacketsRatio, rohcContextAllHeadersRatio=rohcContextAllHeadersRatio, rohcContextAllPacketsMeanSize=rohcContextAllPacketsMeanSize, rohcContextAllHeadersMeanSize=rohcContextAllHeadersMeanSize, rohcContextLastPacketsRatio=rohcContextLastPacketsRatio, rohcContextLastHeadersRatio=rohcContextLastHeadersRatio, rohcContextLastPacketsMeanSize=rohcContextLastPacketsMeanSize, rohcContextLastHeadersMeanSize=rohcContextLastHeadersMeanSize, rohcConformance=rohcConformance, rohcCompliances=rohcCompliances, rohcGroups=rohcGroups)

# Groups
mibBuilder.exportSymbols("ROHC-MIB", rohcInstanceGroup=rohcInstanceGroup, rohcStatisticsGroup=rohcStatisticsGroup, rohcContextGroup=rohcContextGroup, rohcTimerGroup=rohcTimerGroup, rohcContextStatisticsGroup=rohcContextStatisticsGroup)

# Compliances
mibBuilder.exportSymbols("ROHC-MIB", rohcCompliance=rohcCompliance)
