/*
 * Copyright 2014 Canonical Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Jussi Pakkanen <jussi.pakkanen@canonical.com>
 *          James Henstridge <james.henstridge@canonical.com>
 *          Pawel Stolowski <pawel.stolowski@canonical.com>
*/

#include "artgeneratorcommon.h"
#include <QFile>

QString sizeToDesiredSizeString(const QSize& requestedSize)
{
    QString desiredSize = "original";
    int size = requestedSize.width() > requestedSize.height() ? requestedSize.width() : requestedSize.height();
    if (size < 128) {
        desiredSize = "small";
    } else if (size < 256) {
        desiredSize = "large";
    } else if (size < 512) {
        desiredSize = "xlarge";
    }
    return desiredSize;
}

QImage imageFromFd(int fd, QSize *realSize)
{
    QFile file;
    file.open(fd, QIODevice::ReadOnly);
    QImage image;
    image.load(&file, NULL);
    *realSize = image.size();
    return image;
}
