# -*- coding: utf-8 -*-

# Authors: Natalia B. Bidart <natalia.bidart@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""A button that opens links in the web."""

from PyQt4 import QtGui, QtCore

from twisted.internet import defer

from ubuntuone.controlpanel import cache
from ubuntuone.controlpanel.gui import (
    GET_MORE_STORAGE,
    GET_STORAGE_LINK,
)
from ubuntuone.controlpanel.gui import qt


class GoToWebButton(cache.Cache, QtGui.QPushButton):
    """The GoToWebButton widget"""

    uri = None
    legend = None

    def __init__(self, *args, **kwargs):
        """Initialize the UI of the widget."""
        super(GoToWebButton, self).__init__(*args, **kwargs)
        if self.legend is not None:
            self.setText(self.legend)

        self.clicked.connect(self.on_clicked)
        self.setCursor(QtGui.QCursor(QtCore.Qt.PointingHandCursor))

    @defer.inlineCallbacks
    @QtCore.pyqtSlot()
    def on_clicked(self):
        """Open self.uri if not None, do nothing otherwise."""
        if self.uri is not None:
            uri = yield self.backend.build_signed_iri(self.uri)
            qt.uri_hook(uri)


class GetStorageButton(GoToWebButton):
    """A specific GoToWebButton to get more storage."""

    legend = GET_MORE_STORAGE
    uri = GET_STORAGE_LINK
