# -*- coding: utf-8 -*-
#
# Copyright 2011-2012 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Tests for the Sign In Panel."""

from ubuntuone.controlpanel.gui.qt import pixmap_from_name
from ubuntuone.controlpanel.gui.qt import signin as gui
from ubuntuone.controlpanel.gui.qt.tests import BaseTestCase


class SignInPanelTestCase(BaseTestCase):

    """Test the signin panel."""

    innerclass_ui = gui.signin_ui
    innerclass_name = "Ui_Form"
    class_ui = gui.SignInPanel

    def test_all_buttons_enabled(self):
        """All the buttons are enabled at startup."""
        self.assertTrue(self.ui.isEnabled())
        self.assertTrue(self.ui.ui.login_button.isEnabled())
        self.assertTrue(self.ui.ui.register_button.isEnabled())

    def test_login_button_is_default(self):
        """The login_button is the only default button."""
        self.assertTrue(self.ui.ui.login_button.isDefault())
        self.assertFalse(self.ui.ui.register_button.isDefault())

    def test_banner_is_correct(self):
        """The banner has the correct image."""
        expected = pixmap_from_name('banner')
        self.assertEqualPixmaps(self.ui.ui.banner.pixmap(), expected)

    def test_label_is_correct(self):
        """The welcome_label has the correct text."""
        self.assertEqual(unicode(self.ui.ui.welcome_label.text()),
            gui.WELCOME_MARKUP.format(gui.WELCOME_LABEL))

    def test_buttos_are_correct(self):
        """The buttos have the correct text."""
        self.assertEqual(unicode(self.ui.ui.login_button.text()),
                         gui.EXISTING_ACCOUNT_CHOICE_BUTTON)
        self.assertEqual(unicode(self.ui.ui.register_button.text()),
                         gui.SET_UP_ACCOUNT_CHOICE_BUTTON)
