/* utils.c generated by valac 0.14.2, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <zeitgeist.h>
#include <gee.h>
#include <dee.h>
#include <unity.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UnityFilesLensUtilsGetIconForUriAsyncData UnityFilesLensUtilsGetIconForUriAsyncData;
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _UnityFilesLensUtilsListDirInternalData UnityFilesLensUtilsListDirInternalData;
typedef struct _UnityFilesLensUtilsListDirData UnityFilesLensUtilsListDirData;
typedef struct _UnityFilesLensUtilsListDirFilteredData UnityFilesLensUtilsListDirFilteredData;

#define UNITY_FILES_LENS_TYPE_RESULTS_COLUMN (unity_files_lens_results_column_get_type ())

struct _UnityFilesLensUtilsGetIconForUriAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* uri;
	gchar* mimetype;
	gchar* result;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* f;
	GFileInfo* _tmp2_;
	GFileInfo* info;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError* e;
	const gchar* _tmp6_;
	GIcon* _tmp7_;
	GIcon* icon2;
	GIcon* _tmp8_;
	gchar* _tmp9_;
	GError * _inner_error_;
};

struct _UnityFilesLensUtilsListDirInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* folder;
	gchar* name_filter;
	GSList* result;
	gchar* filter;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GSList* _result_;
	GFile* _tmp5_;
	GFileEnumerator* _tmp6_;
	GFileEnumerator* e;
	GFileEnumerator* _tmp7_;
	GList* _tmp8_;
	GList* file_infos;
	GList* _tmp9_;
	GList* _tmp10_;
	GList* info_collection;
	GList* info_it;
	GFileInfo* _tmp11_;
	GFileInfo* info;
	gboolean _tmp12_;
	GFileInfo* _tmp13_;
	gboolean _tmp14_;
	GFileInfo* _tmp15_;
	gboolean _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	const gchar* _tmp19_;
	GFileInfo* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gint _tmp25_;
	gboolean _tmp26_;
	GFileInfo* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* colkey;
	GFileInfo* _tmp30_;
	const gchar* _tmp31_;
	GFileInfo* _tmp32_;
	GFileInfo* _tmp33_;
	GCompareFunc cmpfunc;
	GCompareFunc _tmp34_;
	GError * _inner_error_;
};

struct _UnityFilesLensUtilsListDirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* folder;
	GSList* result;
	GFile* _tmp0_;
	GSList* _tmp1_;
	GSList* _tmp2_;
	GError * _inner_error_;
};

struct _UnityFilesLensUtilsListDirFilteredData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	GFile* folder;
	gchar* name_filter;
	GSList* result;
	GFile* _tmp0_;
	const gchar* _tmp1_;
	GSList* _tmp2_;
	GSList* _tmp3_;
	GError * _inner_error_;
};

typedef enum  {
	UNITY_FILES_LENS_RESULTS_COLUMN_URI = 0,
	UNITY_FILES_LENS_RESULTS_COLUMN_ICON_HINT,
	UNITY_FILES_LENS_RESULTS_COLUMN_GROUP_ID,
	UNITY_FILES_LENS_RESULTS_COLUMN_MIMETYPE,
	UNITY_FILES_LENS_RESULTS_COLUMN_DISPLAY_NAME,
	UNITY_FILES_LENS_RESULTS_COLUMN_COMMENT
} UnityFilesLensResultsColumn;



#define UNITY_FILES_LENS_UTILS_icon_attribs G_FILE_ATTRIBUTE_PREVIEW_ICON "," G_FILE_ATTRIBUTE_STANDARD_ICON "," G_FILE_ATTRIBUTE_THUMBNAIL_PATH
#define UNITY_FILES_LENS_UTILS_file_attribs G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN "," G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP "," G_FILE_ATTRIBUTE_STANDARD_SIZE "," G_FILE_ATTRIBUTE_TIME_MODIFIED "," G_FILE_ATTRIBUTE_TIME_ACCESS
#define UNITY_FILES_LENS_UTILS_hide_attribs G_FILE_ATTRIBUTE_STANDARD_IS_BACKUP "," G_FILE_ATTRIBUTE_STANDARD_IS_HIDDEN
#define UNITY_FILES_LENS_UTILS_all_attribs UNITY_FILES_LENS_UTILS_icon_attribs "," UNITY_FILES_LENS_UTILS_file_attribs "," UNITY_FILES_LENS_UTILS_hide_attribs
gchar* unity_files_lens_utils_get_icon_for_uri (const gchar* uri, const gchar* mimetype);
gchar* unity_files_lens_utils_check_icon_string (const gchar* uri, const gchar* mimetype, GFileInfo* info);
static void unity_files_lens_utils_get_icon_for_uri_async_data_free (gpointer _data);
void unity_files_lens_utils_get_icon_for_uri_async (const gchar* uri, const gchar* mimetype, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar* unity_files_lens_utils_get_icon_for_uri_finish (GAsyncResult* _res_);
static gboolean unity_files_lens_utils_get_icon_for_uri_async_co (UnityFilesLensUtilsGetIconForUriAsyncData* _data_);
static void unity_files_lens_utils_get_icon_for_uri_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint unity_files_lens_utils_cmp_file_info_by_mtime (GFileInfo* info1, GFileInfo* info2);
gchar* unity_files_lens_utils_get_month_name (GDateMonth month);
gchar* unity_files_lens_utils_get_day_name (GDateWeekday weekday);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static void unity_files_lens_utils_list_dir_internal_data_free (gpointer _data);
void unity_files_lens_utils_list_dir_internal (GFile* folder, const gchar* name_filter, GAsyncReadyCallback _callback_, gpointer _user_data_);
GSList* unity_files_lens_utils_list_dir_internal_finish (GAsyncResult* _res_, GError** error);
static gboolean unity_files_lens_utils_list_dir_internal_co (UnityFilesLensUtilsListDirInternalData* _data_);
static void unity_files_lens_utils_list_dir_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_list_free__g_object_unref0_ (GList* self);
static gint __lambda6_ (gconstpointer info1, gconstpointer info2);
static gint ___lambda6__gcompare_func (gconstpointer a, gconstpointer b);
static void unity_files_lens_utils_list_dir_data_free (gpointer _data);
void unity_files_lens_utils_list_dir (GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_);
GSList* unity_files_lens_utils_list_dir_finish (GAsyncResult* _res_, GError** error);
static gboolean unity_files_lens_utils_list_dir_co (UnityFilesLensUtilsListDirData* _data_);
static void unity_files_lens_utils_list_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_files_lens_utils_list_dir_filtered_data_free (gpointer _data);
void unity_files_lens_utils_list_dir_filtered (GFile* folder, const gchar* name_filter, GAsyncReadyCallback _callback_, gpointer _user_data_);
GSList* unity_files_lens_utils_list_dir_filtered_finish (GAsyncResult* _res_, GError** error);
static gboolean unity_files_lens_utils_list_dir_filtered_co (UnityFilesLensUtilsListDirFilteredData* _data_);
static void unity_files_lens_utils_list_dir_filtered_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gboolean unity_files_lens_utils_file_info_matches_any (GFileInfo* info, gchar** types, int types_length1);
gboolean unity_files_lens_utils_file_info_matches_type (GFileInfo* info, const gchar* type_id);
void unity_files_lens_utils_apply_uri_filter (GeeSet* valid_uris, DeeResultSet* filter_set);
GType unity_files_lens_results_column_get_type (void) G_GNUC_CONST;
gboolean unity_files_lens_utils_check_is_filter_search (UnityLensSearch* new_search, UnityLensSearch* old_search);
GeeSet* unity_files_lens_utils_get_uri_set (ZeitgeistResultSet* results);
gchar* unity_files_lens_utils_normalize_string (const gchar* input);


gchar* unity_files_lens_utils_get_icon_for_uri (const gchar* uri, const gchar* mimetype) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (mimetype != NULL, NULL);
	{
		const gchar* _tmp0_;
		GFile* _tmp1_ = NULL;
		GFile* f;
		GFile* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GFile* _tmp9_;
		GFileInfo* _tmp10_ = NULL;
		GFileInfo* info;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GFileInfo* _tmp13_;
		gchar* _tmp14_ = NULL;
		_tmp0_ = uri;
		_tmp1_ = g_file_new_for_uri (_tmp0_);
		f = _tmp1_;
		_tmp2_ = f;
		_tmp3_ = g_file_is_native (_tmp2_);
		if (!_tmp3_) {
			const gchar* _tmp4_;
			GIcon* _tmp5_ = NULL;
			GIcon* _tmp6_;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp4_ = mimetype;
			_tmp5_ = g_content_type_get_icon (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = g_icon_to_string (_tmp6_);
			_tmp8_ = _tmp7_;
			_g_object_unref0 (_tmp6_);
			result = _tmp8_;
			_g_object_unref0 (f);
			return result;
		}
		_tmp9_ = f;
		_tmp10_ = g_file_query_info (_tmp9_, UNITY_FILES_LENS_UTILS_icon_attribs, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
		info = _tmp10_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (f);
			goto __catch12_g_error;
		}
		_tmp11_ = uri;
		_tmp12_ = mimetype;
		_tmp13_ = info;
		_tmp14_ = unity_files_lens_utils_check_icon_string (_tmp11_, _tmp12_, _tmp13_);
		result = _tmp14_;
		_g_object_unref0 (info);
		_g_object_unref0 (f);
		return result;
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp15_;
		GIcon* _tmp16_ = NULL;
		GIcon* icon2;
		GIcon* _tmp17_;
		gchar* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp15_ = mimetype;
		_tmp16_ = g_content_type_get_icon (_tmp15_);
		icon2 = _tmp16_;
		_tmp17_ = icon2;
		_tmp18_ = g_icon_to_string (_tmp17_);
		result = _tmp18_;
		_g_object_unref0 (icon2);
		_g_error_free0 (e);
		return result;
	}
	__finally12:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void unity_files_lens_utils_get_icon_for_uri_async_data_free (gpointer _data) {
	UnityFilesLensUtilsGetIconForUriAsyncData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	_g_free0 (_data_->mimetype);
	_g_free0 (_data_->result);
	g_slice_free (UnityFilesLensUtilsGetIconForUriAsyncData, _data_);
}


void unity_files_lens_utils_get_icon_for_uri_async (const gchar* uri, const gchar* mimetype, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesLensUtilsGetIconForUriAsyncData* _data_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_data_ = g_slice_new0 (UnityFilesLensUtilsGetIconForUriAsyncData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_files_lens_utils_get_icon_for_uri_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_lens_utils_get_icon_for_uri_async_data_free);
	_tmp0_ = uri;
	_tmp1_ = g_strdup (_tmp0_);
	_data_->uri = _tmp1_;
	_tmp2_ = mimetype;
	_tmp3_ = g_strdup (_tmp2_);
	_data_->mimetype = _tmp3_;
	unity_files_lens_utils_get_icon_for_uri_async_co (_data_);
}


gchar* unity_files_lens_utils_get_icon_for_uri_finish (GAsyncResult* _res_) {
	gchar* result;
	UnityFilesLensUtilsGetIconForUriAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_files_lens_utils_get_icon_for_uri_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesLensUtilsGetIconForUriAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_files_lens_utils_get_icon_for_uri_async_co (_data_);
}


static gboolean unity_files_lens_utils_get_icon_for_uri_async_co (UnityFilesLensUtilsGetIconForUriAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->uri;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_file_new_for_uri (_data_->_tmp0_);
		_data_->f = _data_->_tmp1_;
		_data_->_state_ = 1;
		g_file_query_info_async (_data_->f, UNITY_FILES_LENS_UTILS_icon_attribs, G_FILE_QUERY_INFO_NONE, G_PRIORITY_LOW, NULL, unity_files_lens_utils_get_icon_for_uri_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = g_file_query_info_finish (_data_->f, _data_->_res_, &_data_->_inner_error_);
		_data_->info = _data_->_tmp2_;
		if (_data_->_inner_error_ != NULL) {
			_g_object_unref0 (_data_->f);
			goto __catch13_g_error;
		}
		_data_->_tmp3_ = _data_->uri;
		_data_->_tmp4_ = _data_->mimetype;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = unity_files_lens_utils_check_icon_string (_data_->_tmp3_, _data_->_tmp4_, _data_->info);
		_data_->result = _data_->_tmp5_;
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->f);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	goto __finally13;
	__catch13_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp6_ = _data_->mimetype;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_content_type_get_icon (_data_->_tmp6_);
		_data_->icon2 = _data_->_tmp7_;
		_data_->_tmp8_ = _data_->icon2;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = g_icon_to_string (_data_->_tmp8_);
		_data_->result = _data_->_tmp9_;
		_g_object_unref0 (_data_->icon2);
		_g_error_free0 (_data_->e);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally13:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
	g_clear_error (&_data_->_inner_error_);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


gchar* unity_files_lens_utils_check_icon_string (const gchar* uri, const gchar* mimetype, GFileInfo* info) {
	gchar* result = NULL;
	GFileInfo* _tmp0_;
	GIcon* _tmp1_ = NULL;
	GIcon* _tmp2_;
	GIcon* icon;
	GFileInfo* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* thumbnail_path;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean _tmp9_;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (mimetype != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_icon (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	icon = _tmp2_;
	_tmp3_ = info;
	_tmp4_ = g_file_info_get_attribute_byte_string (_tmp3_, G_FILE_ATTRIBUTE_THUMBNAIL_PATH);
	_tmp5_ = g_strdup (_tmp4_);
	thumbnail_path = _tmp5_;
	_tmp7_ = thumbnail_path;
	if (_tmp7_ == NULL) {
		GIcon* _tmp8_;
		_tmp8_ = icon;
		_tmp6_ = _tmp8_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp9_ = _tmp6_;
	if (_tmp9_) {
		GIcon* _tmp10_;
		gchar* _tmp11_ = NULL;
		_tmp10_ = icon;
		_tmp11_ = g_icon_to_string (_tmp10_);
		result = _tmp11_;
		_g_free0 (thumbnail_path);
		_g_object_unref0 (icon);
		return result;
	} else {
		GIcon* _tmp12_;
		_tmp12_ = icon;
		if (_tmp12_ == NULL) {
			const gchar* _tmp13_;
			GIcon* _tmp14_ = NULL;
			GIcon* _tmp15_;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			_tmp13_ = mimetype;
			_tmp14_ = g_content_type_get_icon (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = g_icon_to_string (_tmp15_);
			_tmp17_ = _tmp16_;
			_g_object_unref0 (_tmp15_);
			result = _tmp17_;
			_g_free0 (thumbnail_path);
			_g_object_unref0 (icon);
			return result;
		} else {
			const gchar* _tmp18_;
			GFile* _tmp19_ = NULL;
			GFile* _tmp20_;
			GFileIcon* _tmp21_;
			GFileIcon* _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			_tmp18_ = thumbnail_path;
			_tmp19_ = g_file_new_for_path (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = (GFileIcon*) g_file_icon_new (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_icon_to_string ((GIcon*) _tmp22_);
			_tmp24_ = _tmp23_;
			_g_object_unref0 (_tmp22_);
			_g_object_unref0 (_tmp20_);
			result = _tmp24_;
			_g_free0 (thumbnail_path);
			_g_object_unref0 (icon);
			return result;
		}
	}
	_g_free0 (thumbnail_path);
	_g_object_unref0 (icon);
}


gint unity_files_lens_utils_cmp_file_info_by_mtime (GFileInfo* info1, GFileInfo* info2) {
	gint result = 0;
	GTimeVal tv1 = {0};
	GTimeVal tv2 = {0};
	GFileInfo* _tmp0_;
	GTimeVal _tmp1_ = {0};
	GFileInfo* _tmp2_;
	GTimeVal _tmp3_ = {0};
	GTimeVal _tmp4_;
	glong _tmp5_;
	GTimeVal _tmp6_;
	glong _tmp7_;
	glong cmp;
	gint _tmp8_ = 0;
	glong _tmp9_;
	gint _tmp13_;
	g_return_val_if_fail (info1 != NULL, 0);
	g_return_val_if_fail (info2 != NULL, 0);
	_tmp0_ = info1;
	g_file_info_get_modification_time (_tmp0_, &_tmp1_);
	tv1 = _tmp1_;
	_tmp2_ = info2;
	g_file_info_get_modification_time (_tmp2_, &_tmp3_);
	tv2 = _tmp3_;
	_tmp4_ = tv1;
	_tmp5_ = _tmp4_.tv_sec;
	_tmp6_ = tv2;
	_tmp7_ = _tmp6_.tv_sec;
	cmp = _tmp5_ - _tmp7_;
	_tmp9_ = cmp;
	if (_tmp9_ < ((glong) 0)) {
		_tmp8_ = 1;
	} else {
		gint _tmp10_ = 0;
		glong _tmp11_;
		gint _tmp12_;
		_tmp11_ = cmp;
		if (_tmp11_ > ((glong) 0)) {
			_tmp10_ = -1;
		} else {
			_tmp10_ = 0;
		}
		_tmp12_ = _tmp10_;
		_tmp8_ = _tmp12_;
	}
	_tmp13_ = _tmp8_;
	result = _tmp13_;
	return result;
}


gchar* unity_files_lens_utils_get_month_name (GDateMonth month) {
	gchar* result = NULL;
	GDateMonth _tmp0_;
	gchar* _tmp27_;
	_tmp0_ = month;
	switch (_tmp0_) {
		case G_DATE_BAD_MONTH:
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			_tmp1_ = _ ("Invalid Month");
			_tmp2_ = g_strdup (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case G_DATE_JANUARY:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = _ ("January");
			_tmp4_ = g_strdup (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case G_DATE_FEBRUARY:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			_tmp5_ = _ ("February");
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case G_DATE_MARCH:
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp7_ = _ ("March");
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
		case G_DATE_APRIL:
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			_tmp9_ = _ ("April");
			_tmp10_ = g_strdup (_tmp9_);
			result = _tmp10_;
			return result;
		}
		case G_DATE_MAY:
		{
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			_tmp11_ = _ ("May");
			_tmp12_ = g_strdup (_tmp11_);
			result = _tmp12_;
			return result;
		}
		case G_DATE_JUNE:
		{
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp13_ = _ ("June");
			_tmp14_ = g_strdup (_tmp13_);
			result = _tmp14_;
			return result;
		}
		case G_DATE_JULY:
		{
			const gchar* _tmp15_ = NULL;
			gchar* _tmp16_;
			_tmp15_ = _ ("July");
			_tmp16_ = g_strdup (_tmp15_);
			result = _tmp16_;
			return result;
		}
		case G_DATE_AUGUST:
		{
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_;
			_tmp17_ = _ ("August");
			_tmp18_ = g_strdup (_tmp17_);
			result = _tmp18_;
			return result;
		}
		case G_DATE_SEPTEMBER:
		{
			const gchar* _tmp19_ = NULL;
			gchar* _tmp20_;
			_tmp19_ = _ ("September");
			_tmp20_ = g_strdup (_tmp19_);
			result = _tmp20_;
			return result;
		}
		case G_DATE_OCTOBER:
		{
			const gchar* _tmp21_ = NULL;
			gchar* _tmp22_;
			_tmp21_ = _ ("October");
			_tmp22_ = g_strdup (_tmp21_);
			result = _tmp22_;
			return result;
		}
		case G_DATE_NOVEMBER:
		{
			const gchar* _tmp23_ = NULL;
			gchar* _tmp24_;
			_tmp23_ = _ ("November");
			_tmp24_ = g_strdup (_tmp23_);
			result = _tmp24_;
			return result;
		}
		case G_DATE_DECEMBER:
		{
			const gchar* _tmp25_ = NULL;
			gchar* _tmp26_;
			_tmp25_ = _ ("December");
			_tmp26_ = g_strdup (_tmp25_);
			result = _tmp26_;
			return result;
		}
		default:
		break;
	}
	_tmp27_ = g_strdup ("Internal Error");
	result = _tmp27_;
	return result;
}


gchar* unity_files_lens_utils_get_day_name (GDateWeekday weekday) {
	gchar* result = NULL;
	GDateWeekday _tmp0_;
	_tmp0_ = weekday;
	switch (_tmp0_) {
		case G_DATE_MONDAY:
		{
			const gchar* _tmp1_ = NULL;
			gchar* _tmp2_;
			_tmp1_ = _ ("Monday");
			_tmp2_ = g_strdup (_tmp1_);
			result = _tmp2_;
			return result;
		}
		case G_DATE_TUESDAY:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			_tmp3_ = _ ("Tuesday");
			_tmp4_ = g_strdup (_tmp3_);
			result = _tmp4_;
			return result;
		}
		case G_DATE_WEDNESDAY:
		{
			const gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			_tmp5_ = _ ("Wednesday");
			_tmp6_ = g_strdup (_tmp5_);
			result = _tmp6_;
			return result;
		}
		case G_DATE_THURSDAY:
		{
			const gchar* _tmp7_ = NULL;
			gchar* _tmp8_;
			_tmp7_ = _ ("Thursday");
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		}
		case G_DATE_FRIDAY:
		{
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			_tmp9_ = _ ("Friday");
			_tmp10_ = g_strdup (_tmp9_);
			result = _tmp10_;
			return result;
		}
		case G_DATE_SATURDAY:
		{
			const gchar* _tmp11_ = NULL;
			gchar* _tmp12_;
			_tmp11_ = _ ("Saturday");
			_tmp12_ = g_strdup (_tmp11_);
			result = _tmp12_;
			return result;
		}
		case G_DATE_SUNDAY:
		{
			const gchar* _tmp13_ = NULL;
			gchar* _tmp14_;
			_tmp13_ = _ ("Sunday");
			_tmp14_ = g_strdup (_tmp13_);
			result = _tmp14_;
			return result;
		}
		default:
		{
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("Internal Error");
			result = _tmp15_;
			return result;
		}
	}
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_slist_free (self);
}


static void unity_files_lens_utils_list_dir_internal_data_free (gpointer _data) {
	UnityFilesLensUtilsListDirInternalData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->folder);
	_g_free0 (_data_->name_filter);
	__g_slist_free__g_object_unref0_0 (_data_->result);
	g_slice_free (UnityFilesLensUtilsListDirInternalData, _data_);
}


void unity_files_lens_utils_list_dir_internal (GFile* folder, const gchar* name_filter, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesLensUtilsListDirInternalData* _data_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_data_ = g_slice_new0 (UnityFilesLensUtilsListDirInternalData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_files_lens_utils_list_dir_internal);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_lens_utils_list_dir_internal_data_free);
	_tmp0_ = folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data_->folder = _tmp1_;
	_tmp2_ = name_filter;
	_tmp3_ = g_strdup (_tmp2_);
	_data_->name_filter = _tmp3_;
	unity_files_lens_utils_list_dir_internal_co (_data_);
}


GSList* unity_files_lens_utils_list_dir_internal_finish (GAsyncResult* _res_, GError** error) {
	GSList* result;
	UnityFilesLensUtilsListDirInternalData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void unity_files_lens_utils_list_dir_internal_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesLensUtilsListDirInternalData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_files_lens_utils_list_dir_internal_co (_data_);
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gint __lambda6_ (gconstpointer info1, gconstpointer info2) {
	gint result = 0;
	GCompareFunc _tmp0_;
	gconstpointer _tmp1_;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp3_;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	_tmp0_ = g_strcmp0;
	_tmp1_ = info1;
	_tmp2_ = g_file_info_get_attribute_string (G_IS_FILE_INFO (_tmp1_) ? ((GFileInfo*) _tmp1_) : NULL, "unity::collation-key");
	_tmp3_ = info2;
	_tmp4_ = g_file_info_get_attribute_string (G_IS_FILE_INFO (_tmp3_) ? ((GFileInfo*) _tmp3_) : NULL, "unity::collation-key");
	_tmp5_ = _tmp0_ (_tmp2_, _tmp4_);
	result = _tmp5_;
	return result;
}


static gint ___lambda6__gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = __lambda6_ (a, b);
	return result;
}


static gboolean unity_files_lens_utils_list_dir_internal_co (UnityFilesLensUtilsListDirInternalData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->filter = NULL;
	_data_->_tmp0_ = _data_->name_filter;
	if (_data_->_tmp0_ != NULL) {
		_data_->_tmp1_ = _data_->name_filter;
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = string_strip (_data_->_tmp1_);
		_data_->_tmp3_ = _data_->_tmp2_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = g_utf8_casefold (_data_->_tmp3_, (gssize) (-1));
		_g_free0 (_data_->filter);
		_data_->filter = _data_->_tmp4_;
		_g_free0 (_data_->_tmp3_);
	}
	_data_->_result_ = NULL;
	_data_->_tmp5_ = _data_->folder;
	_data_->_state_ = 1;
	g_file_enumerate_children_async (_data_->_tmp5_, UNITY_FILES_LENS_UTILS_all_attribs, 0, G_PRIORITY_DEFAULT, NULL, unity_files_lens_utils_list_dir_internal_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = g_file_enumerate_children_finish (_data_->_tmp5_, _data_->_res_, &_data_->_inner_error_);
	_data_->e = _data_->_tmp6_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		__g_slist_free__g_object_unref0_0 (_data_->_result_);
		_g_free0 (_data_->filter);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	while (TRUE) {
		_data_->_tmp7_ = _data_->e;
		_data_->_state_ = 2;
		g_file_enumerator_next_files_async (_data_->_tmp7_, 10, G_PRIORITY_DEFAULT, NULL, unity_files_lens_utils_list_dir_internal_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = g_file_enumerator_next_files_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->file_infos = _data_->_tmp8_;
		if (_data_->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->e);
			__g_slist_free__g_object_unref0_0 (_data_->_result_);
			_g_free0 (_data_->filter);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp9_ = _data_->file_infos;
		if (_data_->_tmp9_ == NULL) {
			__g_list_free__g_object_unref0_0 (_data_->file_infos);
			break;
		}
		_data_->_tmp10_ = _data_->file_infos;
		{
			_data_->info_collection = _data_->_tmp10_;
			_data_->info_it = NULL;
			for (_data_->info_it = _data_->info_collection; _data_->info_it != NULL; _data_->info_it = _data_->info_it->next) {
				_data_->_tmp11_ = _g_object_ref0 ((GFileInfo*) _data_->info_it->data);
				_data_->info = _data_->_tmp11_;
				{
					_data_->_tmp13_ = _data_->info;
					_data_->_tmp14_ = FALSE;
					_data_->_tmp14_ = g_file_info_get_is_hidden (_data_->_tmp13_);
					if (_data_->_tmp14_) {
						_data_->_tmp12_ = TRUE;
					} else {
						_data_->_tmp15_ = _data_->info;
						_data_->_tmp16_ = FALSE;
						_data_->_tmp16_ = g_file_info_get_is_backup (_data_->_tmp15_);
						_data_->_tmp12_ = _data_->_tmp16_;
					}
					_data_->_tmp17_ = _data_->_tmp12_;
					if (_data_->_tmp17_) {
						_g_object_unref0 (_data_->info);
						continue;
					}
					_data_->_tmp19_ = _data_->filter;
					if (_data_->_tmp19_ != NULL) {
						_data_->_tmp20_ = _data_->info;
						_data_->_tmp21_ = NULL;
						_data_->_tmp21_ = g_file_info_get_display_name (_data_->_tmp20_);
						_data_->_tmp22_ = NULL;
						_data_->_tmp22_ = g_utf8_casefold (_data_->_tmp21_, (gssize) (-1));
						_data_->_tmp23_ = _data_->_tmp22_;
						_data_->_tmp24_ = _data_->filter;
						_data_->_tmp25_ = 0;
						_data_->_tmp25_ = string_index_of (_data_->_tmp23_, _data_->_tmp24_, 0);
						_data_->_tmp18_ = _data_->_tmp25_ < 0;
						_g_free0 (_data_->_tmp23_);
					} else {
						_data_->_tmp18_ = FALSE;
					}
					_data_->_tmp26_ = _data_->_tmp18_;
					if (_data_->_tmp26_) {
						_g_object_unref0 (_data_->info);
						continue;
					}
					_data_->_tmp27_ = _data_->info;
					_data_->_tmp28_ = NULL;
					_data_->_tmp28_ = g_file_info_get_display_name (_data_->_tmp27_);
					_data_->_tmp29_ = NULL;
					_data_->_tmp29_ = g_utf8_collate_key_for_filename (_data_->_tmp28_, (gssize) (-1));
					_data_->colkey = _data_->_tmp29_;
					_data_->_tmp30_ = _data_->info;
					_data_->_tmp31_ = _data_->colkey;
					g_file_info_set_attribute_string (_data_->_tmp30_, "unity::collation-key", _data_->_tmp31_);
					_data_->_tmp32_ = _data_->info;
					_data_->_tmp33_ = _g_object_ref0 (_data_->_tmp32_);
					_data_->_result_ = g_slist_prepend (_data_->_result_, _data_->_tmp33_);
					_g_free0 (_data_->colkey);
					_g_object_unref0 (_data_->info);
				}
			}
		}
		__g_list_free__g_object_unref0_0 (_data_->file_infos);
	}
	_data_->cmpfunc = ___lambda6__gcompare_func;
	_data_->_tmp34_ = _data_->cmpfunc;
	_data_->_result_ = g_slist_sort (_data_->_result_, _data_->_tmp34_);
	_data_->result = _data_->_result_;
	_g_object_unref0 (_data_->e);
	_g_free0 (_data_->filter);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->e);
	__g_slist_free__g_object_unref0_0 (_data_->_result_);
	_g_free0 (_data_->filter);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_files_lens_utils_list_dir_data_free (gpointer _data) {
	UnityFilesLensUtilsListDirData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->folder);
	__g_slist_free__g_object_unref0_0 (_data_->result);
	g_slice_free (UnityFilesLensUtilsListDirData, _data_);
}


void unity_files_lens_utils_list_dir (GFile* folder, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesLensUtilsListDirData* _data_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	_data_ = g_slice_new0 (UnityFilesLensUtilsListDirData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_files_lens_utils_list_dir);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_lens_utils_list_dir_data_free);
	_tmp0_ = folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data_->folder = _tmp1_;
	unity_files_lens_utils_list_dir_co (_data_);
}


GSList* unity_files_lens_utils_list_dir_finish (GAsyncResult* _res_, GError** error) {
	GSList* result;
	UnityFilesLensUtilsListDirData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Asynchronously list the contents of a directory given by a path,
     * and return a list of FileInfos filled with the attributes specified
     * by Utils.all_attribs
     */
static void unity_files_lens_utils_list_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesLensUtilsListDirData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_files_lens_utils_list_dir_co (_data_);
}


static gboolean unity_files_lens_utils_list_dir_co (UnityFilesLensUtilsListDirData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->folder;
	_data_->_state_ = 1;
	unity_files_lens_utils_list_dir_internal (_data_->_tmp0_, NULL, unity_files_lens_utils_list_dir_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = unity_files_lens_utils_list_dir_internal_finish (_data_->_res_, &_data_->_inner_error_);
	_data_->_tmp2_ = _data_->_tmp1_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_tmp2_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_files_lens_utils_list_dir_filtered_data_free (gpointer _data) {
	UnityFilesLensUtilsListDirFilteredData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->folder);
	_g_free0 (_data_->name_filter);
	__g_slist_free__g_object_unref0_0 (_data_->result);
	g_slice_free (UnityFilesLensUtilsListDirFilteredData, _data_);
}


void unity_files_lens_utils_list_dir_filtered (GFile* folder, const gchar* name_filter, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityFilesLensUtilsListDirFilteredData* _data_;
	GFile* _tmp0_;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_data_ = g_slice_new0 (UnityFilesLensUtilsListDirFilteredData);
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, unity_files_lens_utils_list_dir_filtered);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_files_lens_utils_list_dir_filtered_data_free);
	_tmp0_ = folder;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_data_->folder = _tmp1_;
	_tmp2_ = name_filter;
	_tmp3_ = g_strdup (_tmp2_);
	_data_->name_filter = _tmp3_;
	unity_files_lens_utils_list_dir_filtered_co (_data_);
}


GSList* unity_files_lens_utils_list_dir_filtered_finish (GAsyncResult* _res_, GError** error) {
	GSList* result;
	UnityFilesLensUtilsListDirFilteredData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
     * Similar to list_dir, but only return list of FileInfos matching
     * name_filter name.
     */
static void unity_files_lens_utils_list_dir_filtered_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityFilesLensUtilsListDirFilteredData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_files_lens_utils_list_dir_filtered_co (_data_);
}


static gboolean unity_files_lens_utils_list_dir_filtered_co (UnityFilesLensUtilsListDirFilteredData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->folder;
	_data_->_tmp1_ = _data_->name_filter;
	_data_->_state_ = 1;
	unity_files_lens_utils_list_dir_internal (_data_->_tmp0_, _data_->_tmp1_, unity_files_lens_utils_list_dir_filtered_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = unity_files_lens_utils_list_dir_internal_finish (_data_->_res_, &_data_->_inner_error_);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->_tmp3_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gboolean unity_files_lens_utils_file_info_matches_any (GFileInfo* info, gchar** types, int types_length1) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (info != NULL, FALSE);
	_tmp0_ = types;
	_tmp0__length1 = types_length1;
	{
		gchar** type_id_collection = NULL;
		gint type_id_collection_length1 = 0;
		gint _type_id_collection_size_ = 0;
		gint type_id_it = 0;
		type_id_collection = _tmp0_;
		type_id_collection_length1 = _tmp0__length1;
		for (type_id_it = 0; type_id_it < _tmp0__length1; type_id_it = type_id_it + 1) {
			const gchar* type_id = NULL;
			type_id = type_id_collection[type_id_it];
			{
				GFileInfo* _tmp1_;
				const gchar* _tmp2_;
				gboolean _tmp3_ = FALSE;
				_tmp1_ = info;
				_tmp2_ = type_id;
				_tmp3_ = unity_files_lens_utils_file_info_matches_type (_tmp1_, _tmp2_);
				if (_tmp3_) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


gboolean unity_files_lens_utils_file_info_matches_type (GFileInfo* info, const gchar* type_id) {
	gboolean result = FALSE;
	const gchar* interpretation = NULL;
	GFileInfo* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* content_type;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	GQuark _tmp16_ = 0U;
	static GQuark _tmp15_label0 = 0;
	static GQuark _tmp15_label1 = 0;
	static GQuark _tmp15_label2 = 0;
	static GQuark _tmp15_label3 = 0;
	static GQuark _tmp15_label4 = 0;
	static GQuark _tmp15_label5 = 0;
	static GQuark _tmp15_label6 = 0;
	static GQuark _tmp15_label7 = 0;
	g_return_val_if_fail (info != NULL, FALSE);
	g_return_val_if_fail (type_id != NULL, FALSE);
	_tmp0_ = info;
	_tmp1_ = g_file_info_get_content_type (_tmp0_);
	content_type = _tmp1_;
	_tmp2_ = content_type;
	if (_tmp2_ == NULL) {
		GFileInfo* _tmp3_;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = info;
		_tmp4_ = g_file_info_get_attribute_string (_tmp3_, G_FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE);
		content_type = _tmp4_;
	}
	_tmp5_ = content_type;
	if (_tmp5_ == NULL) {
		content_type = "application/octet-stream";
	}
	_tmp6_ = content_type;
	_tmp7_ = zeitgeist_interpretation_for_mimetype (_tmp6_);
	interpretation = _tmp7_;
	_tmp8_ = interpretation;
	if (_tmp8_ == NULL) {
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_;
		gboolean _tmp12_;
		_tmp10_ = type_id;
		if (g_strcmp0 (_tmp10_, "other") == 0) {
			_tmp9_ = TRUE;
		} else {
			const gchar* _tmp11_;
			_tmp11_ = type_id;
			_tmp9_ = g_strcmp0 (_tmp11_, "all") == 0;
		}
		_tmp12_ = _tmp9_;
		result = _tmp12_;
		return result;
	}
	_tmp13_ = type_id;
	_tmp14_ = _tmp13_;
	_tmp16_ = (NULL == _tmp14_) ? 0 : g_quark_from_string (_tmp14_);
	if (_tmp16_ == ((0 != _tmp15_label0) ? _tmp15_label0 : (_tmp15_label0 = g_quark_from_static_string ("documents")))) {
		switch (0) {
			default:
			{
				gboolean _tmp17_ = FALSE;
				const gchar* _tmp18_;
				gboolean _tmp19_ = FALSE;
				gboolean _tmp22_;
				_tmp18_ = interpretation;
				_tmp19_ = zeitgeist_symbol_is_a (_tmp18_, ZEITGEIST_NFO_DOCUMENT);
				if (_tmp19_) {
					const gchar* _tmp20_;
					gboolean _tmp21_ = FALSE;
					_tmp20_ = interpretation;
					_tmp21_ = zeitgeist_symbol_is_a (_tmp20_, ZEITGEIST_NFO_PRESENTATION);
					_tmp17_ = !_tmp21_;
				} else {
					_tmp17_ = FALSE;
				}
				_tmp22_ = _tmp17_;
				result = _tmp22_;
				return result;
			}
		}
	} else if (_tmp16_ == ((0 != _tmp15_label1) ? _tmp15_label1 : (_tmp15_label1 = g_quark_from_static_string ("folders")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp23_;
				_tmp23_ = content_type;
				result = g_strcmp0 (_tmp23_, "inode/directory") == 0;
				return result;
			}
		}
	} else if (_tmp16_ == ((0 != _tmp15_label2) ? _tmp15_label2 : (_tmp15_label2 = g_quark_from_static_string ("images")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp24_;
				gboolean _tmp25_ = FALSE;
				_tmp24_ = interpretation;
				_tmp25_ = zeitgeist_symbol_is_a (_tmp24_, ZEITGEIST_NFO_IMAGE);
				result = _tmp25_;
				return result;
			}
		}
	} else if (_tmp16_ == ((0 != _tmp15_label3) ? _tmp15_label3 : (_tmp15_label3 = g_quark_from_static_string ("audio")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp26_;
				gboolean _tmp27_ = FALSE;
				_tmp26_ = interpretation;
				_tmp27_ = zeitgeist_symbol_is_a (_tmp26_, ZEITGEIST_NFO_AUDIO);
				result = _tmp27_;
				return result;
			}
		}
	} else if (_tmp16_ == ((0 != _tmp15_label4) ? _tmp15_label4 : (_tmp15_label4 = g_quark_from_static_string ("videos")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp28_;
				gboolean _tmp29_ = FALSE;
				_tmp28_ = interpretation;
				_tmp29_ = zeitgeist_symbol_is_a (_tmp28_, ZEITGEIST_NFO_VIDEO);
				result = _tmp29_;
				return result;
			}
		}
	} else if (_tmp16_ == ((0 != _tmp15_label5) ? _tmp15_label5 : (_tmp15_label5 = g_quark_from_static_string ("presentations")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp30_;
				gboolean _tmp31_ = FALSE;
				_tmp30_ = interpretation;
				_tmp31_ = zeitgeist_symbol_is_a (_tmp30_, ZEITGEIST_NFO_PRESENTATION);
				result = _tmp31_;
				return result;
			}
		}
	} else if (_tmp16_ == ((0 != _tmp15_label6) ? _tmp15_label6 : (_tmp15_label6 = g_quark_from_static_string ("other")))) {
		switch (0) {
			default:
			{
				gboolean is_recognized;
				gboolean _tmp32_;
				const gchar* _tmp33_;
				gboolean _tmp34_;
				const gchar* _tmp35_;
				gboolean _tmp36_ = FALSE;
				gboolean _tmp37_;
				const gchar* _tmp38_;
				gboolean _tmp39_ = FALSE;
				gboolean _tmp40_;
				is_recognized = FALSE;
				_tmp32_ = is_recognized;
				_tmp33_ = content_type;
				is_recognized = _tmp32_ | (g_strcmp0 (_tmp33_, "inode/directory") == 0);
				_tmp34_ = is_recognized;
				_tmp35_ = interpretation;
				_tmp36_ = zeitgeist_symbol_is_a (_tmp35_, ZEITGEIST_NFO_DOCUMENT);
				is_recognized = _tmp34_ | _tmp36_;
				_tmp37_ = is_recognized;
				_tmp38_ = interpretation;
				_tmp39_ = zeitgeist_symbol_is_a (_tmp38_, ZEITGEIST_NFO_MEDIA);
				is_recognized = _tmp37_ | _tmp39_;
				_tmp40_ = is_recognized;
				result = !_tmp40_;
				return result;
			}
		}
	} else if (_tmp16_ == ((0 != _tmp15_label7) ? _tmp15_label7 : (_tmp15_label7 = g_quark_from_static_string ("all")))) {
		switch (0) {
			default:
			{
				result = TRUE;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp41_;
				_tmp41_ = type_id;
				g_warning ("utils.vala:376: Unrecognized type: \"%s\"", _tmp41_);
				result = FALSE;
				return result;
			}
		}
	}
}


void unity_files_lens_utils_apply_uri_filter (GeeSet* valid_uris, DeeResultSet* filter_set) {
	DeeResultSet* _tmp0_;
	DeeModel* _tmp1_ = NULL;
	DeeModel* _tmp2_;
	DeeModel* model;
	guint n_removed;
	gchar* uri = NULL;
	guint _tmp18_;
	g_return_if_fail (valid_uris != NULL);
	g_return_if_fail (filter_set != NULL);
	_tmp0_ = filter_set;
	_tmp1_ = dee_result_set_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	n_removed = (guint) 0;
	{
		DeeResultSet* _tmp3_;
		DeeResultSet* _tmp4_ = NULL;
		DeeResultSet* _row_it;
		DeeModelIter* row = NULL;
		_tmp3_ = filter_set;
		_tmp4_ = _vala_dee_result_set_iterator (_tmp3_);
		_row_it = _tmp4_;
		while (TRUE) {
			DeeResultSet* _tmp5_;
			DeeModelIter* _tmp6_ = NULL;
			DeeModelIter* _tmp7_;
			DeeModel* _tmp8_;
			DeeModelIter* _tmp9_;
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			GeeSet* _tmp12_;
			const gchar* _tmp13_;
			gboolean _tmp14_ = FALSE;
			_tmp5_ = _row_it;
			_tmp6_ = _vala_dee_result_set_next_value (_tmp5_);
			row = _tmp6_;
			_tmp7_ = row;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = model;
			_tmp9_ = row;
			_tmp10_ = dee_model_get_string (_tmp8_, _tmp9_, (guint) UNITY_FILES_LENS_RESULTS_COLUMN_URI);
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (uri);
			uri = _tmp11_;
			_tmp12_ = valid_uris;
			_tmp13_ = uri;
			_tmp14_ = gee_collection_contains ((GeeCollection*) _tmp12_, _tmp13_);
			if (!_tmp14_) {
				DeeModel* _tmp15_;
				DeeModelIter* _tmp16_;
				guint _tmp17_;
				_tmp15_ = model;
				_tmp16_ = row;
				dee_model_remove (_tmp15_, _tmp16_);
				_tmp17_ = n_removed;
				n_removed = _tmp17_ + 1;
			}
		}
		_g_object_unref0 (_row_it);
	}
	_tmp18_ = n_removed;
	if (_tmp18_ > ((guint) 0)) {
		guint _tmp19_;
		_tmp19_ = n_removed;
		g_debug ("utils.vala:404: Removed %u rows from result set", _tmp19_);
	}
	_g_free0 (uri);
	_g_object_unref0 (model);
}


gboolean unity_files_lens_utils_check_is_filter_search (UnityLensSearch* new_search, UnityLensSearch* old_search) {
	gboolean result = FALSE;
	gboolean is_filter_search;
	UnityLensSearch* _tmp0_;
	g_return_val_if_fail (new_search != NULL, FALSE);
	is_filter_search = FALSE;
	_tmp0_ = old_search;
	if (_tmp0_ != NULL) {
		UnityLensSearch* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* previous_search_string;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		gboolean _tmp8_;
		_tmp1_ = old_search;
		_tmp2_ = unity_lens_search_get_search_string (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup (_tmp3_);
		previous_search_string = _tmp4_;
		_tmp6_ = previous_search_string;
		if (_tmp6_ != NULL) {
			const gchar* _tmp7_;
			_tmp7_ = previous_search_string;
			_tmp5_ = g_strcmp0 (_tmp7_, "") != 0;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp8_ = _tmp5_;
		if (_tmp8_) {
			UnityLensSearch* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gboolean _tmp13_ = FALSE;
			_tmp9_ = new_search;
			_tmp10_ = unity_lens_search_get_search_string (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = previous_search_string;
			_tmp13_ = g_str_has_prefix (_tmp11_, _tmp12_);
			is_filter_search = _tmp13_;
		}
		_g_free0 (previous_search_string);
	}
	result = is_filter_search;
	return result;
}


GeeSet* unity_files_lens_utils_get_uri_set (ZeitgeistResultSet* results) {
	GeeSet* result = NULL;
	GeeHashSet* _tmp0_;
	GeeSet* uris;
	g_return_val_if_fail (results != NULL, NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	uris = (GeeSet*) _tmp0_;
	{
		ZeitgeistResultSet* _tmp1_;
		ZeitgeistResultSet* _tmp2_ = NULL;
		ZeitgeistResultSet* _ev_it;
		ZeitgeistEvent* ev = NULL;
		_tmp1_ = results;
		_tmp2_ = _vala_zeitgeist_result_set_iterator (_tmp1_);
		_ev_it = _tmp2_;
		while (TRUE) {
			ZeitgeistResultSet* _tmp3_;
			ZeitgeistEvent* _tmp4_ = NULL;
			ZeitgeistEvent* _tmp5_;
			_tmp3_ = _ev_it;
			_tmp4_ = _vala_zeitgeist_result_set_next_value (_tmp3_);
			ev = _tmp4_;
			_tmp5_ = ev;
			if (!(_tmp5_ != NULL)) {
				break;
			}
			{
				gint i;
				i = 0;
				{
					gboolean _tmp6_;
					_tmp6_ = TRUE;
					while (TRUE) {
						gboolean _tmp7_;
						gint _tmp9_;
						ZeitgeistEvent* _tmp10_;
						gint _tmp11_ = 0;
						GeeSet* _tmp12_;
						ZeitgeistEvent* _tmp13_;
						gint _tmp14_;
						ZeitgeistSubject* _tmp15_ = NULL;
						const gchar* _tmp16_ = NULL;
						_tmp7_ = _tmp6_;
						if (!_tmp7_) {
							gint _tmp8_;
							_tmp8_ = i;
							i = _tmp8_ + 1;
						}
						_tmp6_ = FALSE;
						_tmp9_ = i;
						_tmp10_ = ev;
						_tmp11_ = zeitgeist_event_num_subjects (_tmp10_);
						if (!(_tmp9_ < _tmp11_)) {
							break;
						}
						_tmp12_ = uris;
						_tmp13_ = ev;
						_tmp14_ = i;
						_tmp15_ = zeitgeist_event_get_subject (_tmp13_, _tmp14_);
						_tmp16_ = zeitgeist_subject_get_uri (_tmp15_);
						gee_collection_add ((GeeCollection*) _tmp12_, _tmp16_);
					}
				}
			}
		}
		_g_object_unref0 (_ev_it);
	}
	result = uris;
	return result;
}


gchar* unity_files_lens_utils_normalize_string (const gchar* input) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = input;
	_tmp1_ = g_utf8_normalize (_tmp0_, (gssize) (-1), G_NORMALIZE_ALL_COMPOSE);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_utf8_casefold (_tmp2_, (gssize) (-1));
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}



