/*-----------------------------------------------------------------------------
Copyright 2007 Milan Babuskov

This file is part of Vodovod

Vodovod is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Vodovod is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Vodovod in file COPYING; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
-----------------------------------------------------------------------------*/
#ifndef AB_HISCORE_H
#define AB_HISCORE_H
#include <string>
#include <list>
//-----------------------------------------------------------------------------
class HiScore
{
public:
    std::string name;
    int level;
    int points;
    bool operator<(const HiScore& h) { return points > h.points; };
};
//-----------------------------------------------------------------------------
class HiScores
{
    std::list<HiScore> list;
public:
    typedef std::list<HiScore>::iterator iterator;
    void addHiscore(std::string name, int level, int points);
    bool canEnter(int score);

    iterator begin() { return list.begin(); };
    iterator end()   { return list.end(); };
    HiScores();
    ~HiScores();

private:
    HiScores(const HiScores &);     // disallow copy
};
//-----------------------------------------------------------------------------
HiScores &hiScores();
//-----------------------------------------------------------------------------
#endif
