/* ConjectureEntry.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.conjecture.history;

import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;

import org.grinvin.expr.Expression;
import org.grinvin.expr.ExpressionToString;

/**
 * Implementation of {@link ConjectureHistoryEntry} that holds the result of a run of a conjecturing engine.
 */
public class ConjectureEntry extends AbstractConjectureHistoryEntry<ConjectureEntry> {
    
    public static final String TYPE = "CONJECTURE";
    
    private Expression conjecture;
    
    /** Creates a new instance of ConjectureEntry */
    public ConjectureEntry(Expression conjecture) {
        super();
        this.conjecture = conjecture;
    }

    /** Creates a new instance of ConjectureEntry */
    public ConjectureEntry() {
        this(null);
    }

    public String toString(){
        ExpressionToString toString = new ExpressionToString();
        conjecture.accept(toString);
        return getTimeStamp() + "\n" + toString.getString();
    }

    public JPanel getPanel() {
        JPanel panel = new JPanel();
        JLabel label = new JLabel();        
        ExpressionToString toString = new ExpressionToString();
        conjecture.accept(toString);
        label.setText(toString.getString());
        panel.setName(DateFormat.getDateTimeInstance().format(new Date(getTimeStamp())));
        panel.add(label);
        return panel;
    }
    
    public ConjectureEntryDelegate getDelegate() {
        return new ConjectureEntryDelegate();
    }

    public String getType() {
        return TYPE;
    }
    
    Expression getConjecture() {
        return conjecture;
    }
    
}
