/* WorksheetWindowModel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.worksheet;

import be.ugent.caagt.swirl.DefaultGenericSelectionModel;
import be.ugent.caagt.swirl.GenericSelectionModel;
import java.util.HashMap;
import java.util.Map;

/**
 *
 */
public class WorksheetWindowModel extends WorksheetModel {
    
    public enum SubwindowType {
        INVARIANTLIST,
        GRAPHLIST,
        GENERATORINSTANCELIST,
        FILTERLIST,
        ENGINEPANEL,
        CONJECTURELIST;
    }
    
    //
    private final Map<SubwindowType, SubwindowModel> subwindowModels;
    
    //
    private final GenericSelectionModel<GraphListComponentType> glctModel;

    /**
     * Return the submodel which keeps track of which graph
     * list component type is currently displayed
     */
    public GenericSelectionModel<GraphListComponentType> getGlctModel() {
        return glctModel;
    }
    
    //
    public WorksheetWindowModel() {
        this.subwindowModels = new HashMap<SubwindowType, SubwindowModel>();
        for (SubwindowType type : SubwindowType.values()) {
            subwindowModels.put(type, new SubwindowModel(true, false));
        }
        this.glctModel = new DefaultGenericSelectionModel<GraphListComponentType> ();
        glctModel.setSelection(GraphListComponentType.TABLE);
    }
    
    public SubwindowModel getSubwindowModel(SubwindowType type) {
        return subwindowModels.get(type);
    }
    
    public GraphListComponentType getGraphListComponentSelected() {
        return glctModel.getSelection();
    }
            
    public void setGraphListComponentSelected(GraphListComponentType type) {
        glctModel.setSelection(type);
    }
    
}
