#ifndef __MARTIAN_MPORT_H
#define __MARTIAN_MPORT_H

#include "sysdep.h"

#ifndef TIOCM_DTR	
# define TIOCM_DTR	0x002
# define TIOCM_RTS	0x004
# define TIOCM_CTS	0x020
#endif 

typedef struct _port mport_t;

struct _port {
	mutex_t *lock;
	unsigned mctrl;
	unsigned carrier;
	void (*do_pulse) (mport_t *port);

	unsigned room;
	unsigned available;

	int tid;

	unsigned has_data	: 1;
	unsigned ready		: 1;
	unsigned pulse		: 1;

	unsigned in_pulse	: 1;

	unsigned pulsesAll;
};

enum _carrier { CLost, COk };

typedef enum _port_status { 
	PortOk = 0x10000
} port_status_t;

extern port_status_t mport_init (mport_t *port);
extern void mport_tinit (mport_t *port);

extern void mport_dump_summary (mport_t *port);

extern void mport_open (mport_t *port); 
extern void mport_close (mport_t *port); 

extern int mport_write (mport_t *port, char *buffer, int count); 
extern int mport_read (mport_t *port, char *buf, int bytes);
extern void mport_mctrl_flipflop (mport_t *port, unsigned mask);
extern void mport_mctrl_set (mport_t *port, unsigned mctrl);

extern void mport_vi (mport_t *port);

/*
int mport_has_data (mport_t *port);
int mport_ready (mport_t *port);
int mport_available (mport_t *port);
*/

static inline int mport_lock (mport_t *port) {
	return mutex_lock (port->lock);
}

static inline int mport_unlock (mport_t *port) {
	return mutex_unlock (port->lock);
}

#endif
