/* NOTE: Do not edit this file, it is generated by a script:
   ExportTrace.py --api cgGL 3.0 --prefix traceCgGL -t traverseTraceCgGL --library CgGL -o traceCgGL.c
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "trace.h"

#include <Cg/cgGL.h>

#ifdef _WIN32
# define DLLEXPORT __declspec(dllexport)
#elif defined(__GNUC__) && __GNUC__>=4
# define DLLEXPORT __attribute__ ((visibility("default")))
#elif defined(__SUNPRO_C) || defined(__SUNPRO_CC)
# define DLLEXPORT __global
#else
# define DLLEXPORT
#endif

/* Load CgGL library. */

#if defined(_WIN32)
# if !defined(WIN32_LEAN_AND_MEAN)
#   define WIN32_LEAN_AND_MEAN 1
# endif
# if !defined(NOGDI)
#   define NOGDI 1
# endif
# include <windows.h>
# undef WIN32_LEAN_AND_MEAN
# undef NOGDI
#elif defined(__APPLE__)
# include <AvailabilityMacros.h>
# if !defined(MAC_OS_X_VERSION_10_3)
#   include <mach-o/dyld.h>
# else
#   include <dlfcn.h>
# endif
#else
# include <dlfcn.h>
#endif

typedef struct _TraceCgGL_Handle *TraceCgGL_Handle;

static TraceCgGL_Handle
traceCgGL_LoadLibrary(const char *filename)
{
#if defined(_WIN32)
  return (TraceCgGL_Handle) LoadLibrary(filename);
#elif defined(__APPLE__) && !defined(MAC_OS_X_VERSION_10_3)
  return (TraceCgGL_Handle) NSAddImage(filename, NSADDIMAGE_OPTION_NONE);
#else
  return (TraceCgGL_Handle) dlopen(filename, RTLD_LAZY);
#endif
}

static int
traceCgGL_FreeLibrary(TraceCgGL_Handle handle)
{
#if defined(_WIN32)
  return FreeLibrary((HMODULE)handle) ? 1 : 0;
#elif defined(__APPLE__) && !defined(MAC_OS_X_VERSION_10_3)
  return 1;
#else
  return dlclose(handle) ? 0 : 1;
#endif
}

static void *
traceCgGL_GetProcAddress(TraceCgGL_Handle handle, const char *name)
{
#if defined(_WIN32)
  return handle ? GetProcAddress((HMODULE)handle, name) : NULL;
#elif defined(__APPLE__) && !defined(MAC_OS_X_VERSION_10_3)
  return NSIsSymbolNameDefined(name) ? NSAddressOfSymbol(NSLookupAndBindSymbol(name)) : NULL;
#else
  return dlsym(handle, name);
#endif
}

static int traceCgGL_initialized = 0;
static TraceCgGL_Handle traceCgGL_handle = NULL;

/* CgGL API function pointers. */

struct TraceCgGL_Functions
{
  CGbool (*cgGLIsProfileSupported)(CGprofile);
  void (*cgGLEnableProfile)(CGprofile);
  void (*cgGLDisableProfile)(CGprofile);
  CGprofile (*cgGLGetLatestProfile)(CGGLenum);
  void (*cgGLSetOptimalOptions)(CGprofile);
  char const **(*cgGLGetOptimalOptions)(CGprofile);
  void (*cgGLLoadProgram)(CGprogram);
  void (*cgGLUnloadProgram)(CGprogram);
  CGbool (*cgGLIsProgramLoaded)(CGprogram);
  void (*cgGLBindProgram)(CGprogram);
  void (*cgGLUnbindProgram)(CGprofile);
  GLuint (*cgGLGetProgramID)(CGprogram);
  void (*cgGLSetParameter1f)(CGparameter, float);
  void (*cgGLSetParameter2f)(CGparameter, float, float);
  void (*cgGLSetParameter3f)(CGparameter, float, float, float);
  void (*cgGLSetParameter4f)(CGparameter, float, float, float, float);
  void (*cgGLSetParameter1fv)(CGparameter, const float *);
  void (*cgGLSetParameter2fv)(CGparameter, const float *);
  void (*cgGLSetParameter3fv)(CGparameter, const float *);
  void (*cgGLSetParameter4fv)(CGparameter, const float *);
  void (*cgGLSetParameter1d)(CGparameter, double);
  void (*cgGLSetParameter2d)(CGparameter, double, double);
  void (*cgGLSetParameter3d)(CGparameter, double, double, double);
  void (*cgGLSetParameter4d)(CGparameter, double, double, double, double);
  void (*cgGLSetParameter1dv)(CGparameter, const double *);
  void (*cgGLSetParameter2dv)(CGparameter, const double *);
  void (*cgGLSetParameter3dv)(CGparameter, const double *);
  void (*cgGLSetParameter4dv)(CGparameter, const double *);
  void (*cgGLGetParameter1f)(CGparameter, float *);
  void (*cgGLGetParameter2f)(CGparameter, float *);
  void (*cgGLGetParameter3f)(CGparameter, float *);
  void (*cgGLGetParameter4f)(CGparameter, float *);
  void (*cgGLGetParameter1d)(CGparameter, double *);
  void (*cgGLGetParameter2d)(CGparameter, double *);
  void (*cgGLGetParameter3d)(CGparameter, double *);
  void (*cgGLGetParameter4d)(CGparameter, double *);
  void (*cgGLSetParameterArray1f)(CGparameter, long, long, const float *);
  void (*cgGLSetParameterArray2f)(CGparameter, long, long, const float *);
  void (*cgGLSetParameterArray3f)(CGparameter, long, long, const float *);
  void (*cgGLSetParameterArray4f)(CGparameter, long, long, const float *);
  void (*cgGLSetParameterArray1d)(CGparameter, long, long, const double *);
  void (*cgGLSetParameterArray2d)(CGparameter, long, long, const double *);
  void (*cgGLSetParameterArray3d)(CGparameter, long, long, const double *);
  void (*cgGLSetParameterArray4d)(CGparameter, long, long, const double *);
  void (*cgGLGetParameterArray1f)(CGparameter, long, long, float *);
  void (*cgGLGetParameterArray2f)(CGparameter, long, long, float *);
  void (*cgGLGetParameterArray3f)(CGparameter, long, long, float *);
  void (*cgGLGetParameterArray4f)(CGparameter, long, long, float *);
  void (*cgGLGetParameterArray1d)(CGparameter, long, long, double *);
  void (*cgGLGetParameterArray2d)(CGparameter, long, long, double *);
  void (*cgGLGetParameterArray3d)(CGparameter, long, long, double *);
  void (*cgGLGetParameterArray4d)(CGparameter, long, long, double *);
  void (*cgGLSetParameterPointer)(CGparameter, GLint, GLenum, GLsizei, const GLvoid *);
  void (*cgGLEnableClientState)(CGparameter);
  void (*cgGLDisableClientState)(CGparameter);
  void (*cgGLSetMatrixParameterdr)(CGparameter, const double *);
  void (*cgGLSetMatrixParameterfr)(CGparameter, const float *);
  void (*cgGLSetMatrixParameterdc)(CGparameter, const double *);
  void (*cgGLSetMatrixParameterfc)(CGparameter, const float *);
  void (*cgGLGetMatrixParameterdr)(CGparameter, double *);
  void (*cgGLGetMatrixParameterfr)(CGparameter, float *);
  void (*cgGLGetMatrixParameterdc)(CGparameter, double *);
  void (*cgGLGetMatrixParameterfc)(CGparameter, float *);
  void (*cgGLSetStateMatrixParameter)(CGparameter, CGGLenum, CGGLenum);
  void (*cgGLSetMatrixParameterArrayfc)(CGparameter, long, long, const float *);
  void (*cgGLSetMatrixParameterArrayfr)(CGparameter, long, long, const float *);
  void (*cgGLSetMatrixParameterArraydc)(CGparameter, long, long, const double *);
  void (*cgGLSetMatrixParameterArraydr)(CGparameter, long, long, const double *);
  void (*cgGLGetMatrixParameterArrayfc)(CGparameter, long, long, float *);
  void (*cgGLGetMatrixParameterArrayfr)(CGparameter, long, long, float *);
  void (*cgGLGetMatrixParameterArraydc)(CGparameter, long, long, double *);
  void (*cgGLGetMatrixParameterArraydr)(CGparameter, long, long, double *);
  void (*cgGLSetTextureParameter)(CGparameter, GLuint);
  GLuint (*cgGLGetTextureParameter)(CGparameter);
  void (*cgGLEnableTextureParameter)(CGparameter);
  void (*cgGLDisableTextureParameter)(CGparameter);
  GLenum (*cgGLGetTextureEnum)(CGparameter);
  void (*cgGLSetManageTextureParameters)(CGcontext, CGbool);
  CGbool (*cgGLGetManageTextureParameters)(CGcontext);
  void (*cgGLSetupSampler)(CGparameter, GLuint);
  void (*cgGLRegisterStates)(CGcontext);
  void (*cgGLEnableProgramProfiles)(CGprogram);
  void (*cgGLDisableProgramProfiles)(CGprogram);
  void (*cgGLSetDebugMode)(CGbool);
  CGbuffer (*cgGLCreateBuffer)(CGcontext, int, const void *, GLenum);
  GLuint (*cgGLGetBufferObject)(CGbuffer);
};

static struct TraceCgGL_Functions traceCgGL_Native;

/* CgGL helper function pointers. */

static size_t (*traceCgGL_helperCgGetMatrixParameterSize)(CGparameter) = NULL;
static size_t (*traceCgGL_helperCgGetParameterArraySize)(CGparameter, long, long, long) = NULL;
static size_t (*traceCgGL_helperCgGetMatrixParameterArraySize)(CGparameter, long, long) = NULL;
static size_t (*traceCgGL_helperCgCreateBufferSize)(int) = NULL;

/* Initialize TraceCgGL. */

#ifdef __APPLE__
void traceCg_init(void);
#endif

void
traceCgGL_init(void)
{
  const char *library = "CgGL";
  const char *filename = NULL;

  if (traceCgGL_initialized)
    return;

  /* Do pre-initialization */

  #ifdef __APPLE__
  traceCg_init();
  #endif

  /* Load the native library */

  filename = traceLibraryLocation(library);
  traceCgGL_handle = traceCgGL_LoadLibrary(filename);
  if (!traceCgGL_handle)
  {
    traceError("Failed to load %s from %s", library, filename);
    return;
  }
  traceInfo("Loaded %s from %s", library, filename);

  /* Load CgGL API functions. */

  memset(&traceCgGL_Native, 0, sizeof(struct TraceCgGL_Functions));

  traceCgGL_Native.cgGLIsProfileSupported = (CGbool (*)(CGprofile)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLIsProfileSupported");
  traceCgGL_Native.cgGLEnableProfile = (void (*)(CGprofile)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLEnableProfile");
  traceCgGL_Native.cgGLDisableProfile = (void (*)(CGprofile)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLDisableProfile");
  traceCgGL_Native.cgGLGetLatestProfile = (CGprofile (*)(CGGLenum)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetLatestProfile");
  traceCgGL_Native.cgGLSetOptimalOptions = (void (*)(CGprofile)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetOptimalOptions");
  traceCgGL_Native.cgGLGetOptimalOptions = (char const **(*)(CGprofile)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetOptimalOptions");
  traceCgGL_Native.cgGLLoadProgram = (void (*)(CGprogram)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLLoadProgram");
  traceCgGL_Native.cgGLUnloadProgram = (void (*)(CGprogram)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLUnloadProgram");
  traceCgGL_Native.cgGLIsProgramLoaded = (CGbool (*)(CGprogram)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLIsProgramLoaded");
  traceCgGL_Native.cgGLBindProgram = (void (*)(CGprogram)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLBindProgram");
  traceCgGL_Native.cgGLUnbindProgram = (void (*)(CGprofile)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLUnbindProgram");
  traceCgGL_Native.cgGLGetProgramID = (GLuint (*)(CGprogram)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetProgramID");
  traceCgGL_Native.cgGLSetParameter1f = (void (*)(CGparameter, float)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter1f");
  traceCgGL_Native.cgGLSetParameter2f = (void (*)(CGparameter, float, float)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter2f");
  traceCgGL_Native.cgGLSetParameter3f = (void (*)(CGparameter, float, float, float)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter3f");
  traceCgGL_Native.cgGLSetParameter4f = (void (*)(CGparameter, float, float, float, float)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter4f");
  traceCgGL_Native.cgGLSetParameter1fv = (void (*)(CGparameter, const float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter1fv");
  traceCgGL_Native.cgGLSetParameter2fv = (void (*)(CGparameter, const float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter2fv");
  traceCgGL_Native.cgGLSetParameter3fv = (void (*)(CGparameter, const float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter3fv");
  traceCgGL_Native.cgGLSetParameter4fv = (void (*)(CGparameter, const float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter4fv");
  traceCgGL_Native.cgGLSetParameter1d = (void (*)(CGparameter, double)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter1d");
  traceCgGL_Native.cgGLSetParameter2d = (void (*)(CGparameter, double, double)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter2d");
  traceCgGL_Native.cgGLSetParameter3d = (void (*)(CGparameter, double, double, double)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter3d");
  traceCgGL_Native.cgGLSetParameter4d = (void (*)(CGparameter, double, double, double, double)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter4d");
  traceCgGL_Native.cgGLSetParameter1dv = (void (*)(CGparameter, const double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter1dv");
  traceCgGL_Native.cgGLSetParameter2dv = (void (*)(CGparameter, const double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter2dv");
  traceCgGL_Native.cgGLSetParameter3dv = (void (*)(CGparameter, const double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter3dv");
  traceCgGL_Native.cgGLSetParameter4dv = (void (*)(CGparameter, const double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameter4dv");
  traceCgGL_Native.cgGLGetParameter1f = (void (*)(CGparameter, float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameter1f");
  traceCgGL_Native.cgGLGetParameter2f = (void (*)(CGparameter, float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameter2f");
  traceCgGL_Native.cgGLGetParameter3f = (void (*)(CGparameter, float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameter3f");
  traceCgGL_Native.cgGLGetParameter4f = (void (*)(CGparameter, float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameter4f");
  traceCgGL_Native.cgGLGetParameter1d = (void (*)(CGparameter, double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameter1d");
  traceCgGL_Native.cgGLGetParameter2d = (void (*)(CGparameter, double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameter2d");
  traceCgGL_Native.cgGLGetParameter3d = (void (*)(CGparameter, double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameter3d");
  traceCgGL_Native.cgGLGetParameter4d = (void (*)(CGparameter, double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameter4d");
  traceCgGL_Native.cgGLSetParameterArray1f = (void (*)(CGparameter, long, long, const float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameterArray1f");
  traceCgGL_Native.cgGLSetParameterArray2f = (void (*)(CGparameter, long, long, const float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameterArray2f");
  traceCgGL_Native.cgGLSetParameterArray3f = (void (*)(CGparameter, long, long, const float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameterArray3f");
  traceCgGL_Native.cgGLSetParameterArray4f = (void (*)(CGparameter, long, long, const float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameterArray4f");
  traceCgGL_Native.cgGLSetParameterArray1d = (void (*)(CGparameter, long, long, const double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameterArray1d");
  traceCgGL_Native.cgGLSetParameterArray2d = (void (*)(CGparameter, long, long, const double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameterArray2d");
  traceCgGL_Native.cgGLSetParameterArray3d = (void (*)(CGparameter, long, long, const double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameterArray3d");
  traceCgGL_Native.cgGLSetParameterArray4d = (void (*)(CGparameter, long, long, const double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameterArray4d");
  traceCgGL_Native.cgGLGetParameterArray1f = (void (*)(CGparameter, long, long, float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameterArray1f");
  traceCgGL_Native.cgGLGetParameterArray2f = (void (*)(CGparameter, long, long, float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameterArray2f");
  traceCgGL_Native.cgGLGetParameterArray3f = (void (*)(CGparameter, long, long, float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameterArray3f");
  traceCgGL_Native.cgGLGetParameterArray4f = (void (*)(CGparameter, long, long, float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameterArray4f");
  traceCgGL_Native.cgGLGetParameterArray1d = (void (*)(CGparameter, long, long, double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameterArray1d");
  traceCgGL_Native.cgGLGetParameterArray2d = (void (*)(CGparameter, long, long, double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameterArray2d");
  traceCgGL_Native.cgGLGetParameterArray3d = (void (*)(CGparameter, long, long, double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameterArray3d");
  traceCgGL_Native.cgGLGetParameterArray4d = (void (*)(CGparameter, long, long, double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetParameterArray4d");
  traceCgGL_Native.cgGLSetParameterPointer = (void (*)(CGparameter, GLint, GLenum, GLsizei, const GLvoid *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetParameterPointer");
  traceCgGL_Native.cgGLEnableClientState = (void (*)(CGparameter)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLEnableClientState");
  traceCgGL_Native.cgGLDisableClientState = (void (*)(CGparameter)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLDisableClientState");
  traceCgGL_Native.cgGLSetMatrixParameterdr = (void (*)(CGparameter, const double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetMatrixParameterdr");
  traceCgGL_Native.cgGLSetMatrixParameterfr = (void (*)(CGparameter, const float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetMatrixParameterfr");
  traceCgGL_Native.cgGLSetMatrixParameterdc = (void (*)(CGparameter, const double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetMatrixParameterdc");
  traceCgGL_Native.cgGLSetMatrixParameterfc = (void (*)(CGparameter, const float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetMatrixParameterfc");
  traceCgGL_Native.cgGLGetMatrixParameterdr = (void (*)(CGparameter, double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetMatrixParameterdr");
  traceCgGL_Native.cgGLGetMatrixParameterfr = (void (*)(CGparameter, float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetMatrixParameterfr");
  traceCgGL_Native.cgGLGetMatrixParameterdc = (void (*)(CGparameter, double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetMatrixParameterdc");
  traceCgGL_Native.cgGLGetMatrixParameterfc = (void (*)(CGparameter, float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetMatrixParameterfc");
  traceCgGL_Native.cgGLSetStateMatrixParameter = (void (*)(CGparameter, CGGLenum, CGGLenum)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetStateMatrixParameter");
  traceCgGL_Native.cgGLSetMatrixParameterArrayfc = (void (*)(CGparameter, long, long, const float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetMatrixParameterArrayfc");
  traceCgGL_Native.cgGLSetMatrixParameterArrayfr = (void (*)(CGparameter, long, long, const float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetMatrixParameterArrayfr");
  traceCgGL_Native.cgGLSetMatrixParameterArraydc = (void (*)(CGparameter, long, long, const double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetMatrixParameterArraydc");
  traceCgGL_Native.cgGLSetMatrixParameterArraydr = (void (*)(CGparameter, long, long, const double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetMatrixParameterArraydr");
  traceCgGL_Native.cgGLGetMatrixParameterArrayfc = (void (*)(CGparameter, long, long, float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetMatrixParameterArrayfc");
  traceCgGL_Native.cgGLGetMatrixParameterArrayfr = (void (*)(CGparameter, long, long, float *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetMatrixParameterArrayfr");
  traceCgGL_Native.cgGLGetMatrixParameterArraydc = (void (*)(CGparameter, long, long, double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetMatrixParameterArraydc");
  traceCgGL_Native.cgGLGetMatrixParameterArraydr = (void (*)(CGparameter, long, long, double *)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetMatrixParameterArraydr");
  traceCgGL_Native.cgGLSetTextureParameter = (void (*)(CGparameter, GLuint)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetTextureParameter");
  traceCgGL_Native.cgGLGetTextureParameter = (GLuint (*)(CGparameter)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetTextureParameter");
  traceCgGL_Native.cgGLEnableTextureParameter = (void (*)(CGparameter)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLEnableTextureParameter");
  traceCgGL_Native.cgGLDisableTextureParameter = (void (*)(CGparameter)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLDisableTextureParameter");
  traceCgGL_Native.cgGLGetTextureEnum = (GLenum (*)(CGparameter)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetTextureEnum");
  traceCgGL_Native.cgGLSetManageTextureParameters = (void (*)(CGcontext, CGbool)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetManageTextureParameters");
  traceCgGL_Native.cgGLGetManageTextureParameters = (CGbool (*)(CGcontext)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetManageTextureParameters");
  traceCgGL_Native.cgGLSetupSampler = (void (*)(CGparameter, GLuint)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetupSampler");
  traceCgGL_Native.cgGLRegisterStates = (void (*)(CGcontext)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLRegisterStates");
  traceCgGL_Native.cgGLEnableProgramProfiles = (void (*)(CGprogram)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLEnableProgramProfiles");
  traceCgGL_Native.cgGLDisableProgramProfiles = (void (*)(CGprogram)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLDisableProgramProfiles");
  traceCgGL_Native.cgGLSetDebugMode = (void (*)(CGbool)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLSetDebugMode");
  traceCgGL_Native.cgGLCreateBuffer = (CGbuffer (*)(CGcontext, int, const void *, GLenum)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLCreateBuffer");
  traceCgGL_Native.cgGLGetBufferObject = (GLuint (*)(CGbuffer)) traceCgGL_GetProcAddress(traceCgGL_handle, "cgGLGetBufferObject");

  /* Validate CgGL API functions. */

  if (traceCgGL_Native.cgGLIsProfileSupported)
  {
    if (traceCgGL_Native.cgGLIsProfileSupported == cgGLIsProfileSupported)
    {
      traceWarning("Ignoring cgGLIsProfileSupported loaded from traceCgGL library.");
      traceCgGL_Native.cgGLIsProfileSupported = NULL;
    }
  }
  else
  {
    traceWarning("cgGLIsProfileSupported not loaded.");
  }
  if (traceCgGL_Native.cgGLEnableProfile)
  {
    if (traceCgGL_Native.cgGLEnableProfile == cgGLEnableProfile)
    {
      traceWarning("Ignoring cgGLEnableProfile loaded from traceCgGL library.");
      traceCgGL_Native.cgGLEnableProfile = NULL;
    }
  }
  else
  {
    traceWarning("cgGLEnableProfile not loaded.");
  }
  if (traceCgGL_Native.cgGLDisableProfile)
  {
    if (traceCgGL_Native.cgGLDisableProfile == cgGLDisableProfile)
    {
      traceWarning("Ignoring cgGLDisableProfile loaded from traceCgGL library.");
      traceCgGL_Native.cgGLDisableProfile = NULL;
    }
  }
  else
  {
    traceWarning("cgGLDisableProfile not loaded.");
  }
  if (traceCgGL_Native.cgGLGetLatestProfile)
  {
    if (traceCgGL_Native.cgGLGetLatestProfile == cgGLGetLatestProfile)
    {
      traceWarning("Ignoring cgGLGetLatestProfile loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetLatestProfile = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetLatestProfile not loaded.");
  }
  if (traceCgGL_Native.cgGLSetOptimalOptions)
  {
    if (traceCgGL_Native.cgGLSetOptimalOptions == cgGLSetOptimalOptions)
    {
      traceWarning("Ignoring cgGLSetOptimalOptions loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetOptimalOptions = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetOptimalOptions not loaded.");
  }
  if (traceCgGL_Native.cgGLGetOptimalOptions)
  {
    if (traceCgGL_Native.cgGLGetOptimalOptions == cgGLGetOptimalOptions)
    {
      traceWarning("Ignoring cgGLGetOptimalOptions loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetOptimalOptions = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetOptimalOptions not loaded.");
  }
  if (traceCgGL_Native.cgGLLoadProgram)
  {
    if (traceCgGL_Native.cgGLLoadProgram == cgGLLoadProgram)
    {
      traceWarning("Ignoring cgGLLoadProgram loaded from traceCgGL library.");
      traceCgGL_Native.cgGLLoadProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgGLLoadProgram not loaded.");
  }
  if (traceCgGL_Native.cgGLUnloadProgram)
  {
    if (traceCgGL_Native.cgGLUnloadProgram == cgGLUnloadProgram)
    {
      traceWarning("Ignoring cgGLUnloadProgram loaded from traceCgGL library.");
      traceCgGL_Native.cgGLUnloadProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgGLUnloadProgram not loaded.");
  }
  if (traceCgGL_Native.cgGLIsProgramLoaded)
  {
    if (traceCgGL_Native.cgGLIsProgramLoaded == cgGLIsProgramLoaded)
    {
      traceWarning("Ignoring cgGLIsProgramLoaded loaded from traceCgGL library.");
      traceCgGL_Native.cgGLIsProgramLoaded = NULL;
    }
  }
  else
  {
    traceWarning("cgGLIsProgramLoaded not loaded.");
  }
  if (traceCgGL_Native.cgGLBindProgram)
  {
    if (traceCgGL_Native.cgGLBindProgram == cgGLBindProgram)
    {
      traceWarning("Ignoring cgGLBindProgram loaded from traceCgGL library.");
      traceCgGL_Native.cgGLBindProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgGLBindProgram not loaded.");
  }
  if (traceCgGL_Native.cgGLUnbindProgram)
  {
    if (traceCgGL_Native.cgGLUnbindProgram == cgGLUnbindProgram)
    {
      traceWarning("Ignoring cgGLUnbindProgram loaded from traceCgGL library.");
      traceCgGL_Native.cgGLUnbindProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgGLUnbindProgram not loaded.");
  }
  if (traceCgGL_Native.cgGLGetProgramID)
  {
    if (traceCgGL_Native.cgGLGetProgramID == cgGLGetProgramID)
    {
      traceWarning("Ignoring cgGLGetProgramID loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetProgramID = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetProgramID not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter1f)
  {
    if (traceCgGL_Native.cgGLSetParameter1f == cgGLSetParameter1f)
    {
      traceWarning("Ignoring cgGLSetParameter1f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter1f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter1f not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter2f)
  {
    if (traceCgGL_Native.cgGLSetParameter2f == cgGLSetParameter2f)
    {
      traceWarning("Ignoring cgGLSetParameter2f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter2f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter2f not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter3f)
  {
    if (traceCgGL_Native.cgGLSetParameter3f == cgGLSetParameter3f)
    {
      traceWarning("Ignoring cgGLSetParameter3f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter3f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter3f not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter4f)
  {
    if (traceCgGL_Native.cgGLSetParameter4f == cgGLSetParameter4f)
    {
      traceWarning("Ignoring cgGLSetParameter4f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter4f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter4f not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter1fv)
  {
    if (traceCgGL_Native.cgGLSetParameter1fv == cgGLSetParameter1fv)
    {
      traceWarning("Ignoring cgGLSetParameter1fv loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter1fv = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter1fv not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter2fv)
  {
    if (traceCgGL_Native.cgGLSetParameter2fv == cgGLSetParameter2fv)
    {
      traceWarning("Ignoring cgGLSetParameter2fv loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter2fv = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter2fv not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter3fv)
  {
    if (traceCgGL_Native.cgGLSetParameter3fv == cgGLSetParameter3fv)
    {
      traceWarning("Ignoring cgGLSetParameter3fv loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter3fv = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter3fv not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter4fv)
  {
    if (traceCgGL_Native.cgGLSetParameter4fv == cgGLSetParameter4fv)
    {
      traceWarning("Ignoring cgGLSetParameter4fv loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter4fv = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter4fv not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter1d)
  {
    if (traceCgGL_Native.cgGLSetParameter1d == cgGLSetParameter1d)
    {
      traceWarning("Ignoring cgGLSetParameter1d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter1d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter1d not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter2d)
  {
    if (traceCgGL_Native.cgGLSetParameter2d == cgGLSetParameter2d)
    {
      traceWarning("Ignoring cgGLSetParameter2d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter2d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter2d not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter3d)
  {
    if (traceCgGL_Native.cgGLSetParameter3d == cgGLSetParameter3d)
    {
      traceWarning("Ignoring cgGLSetParameter3d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter3d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter3d not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter4d)
  {
    if (traceCgGL_Native.cgGLSetParameter4d == cgGLSetParameter4d)
    {
      traceWarning("Ignoring cgGLSetParameter4d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter4d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter4d not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter1dv)
  {
    if (traceCgGL_Native.cgGLSetParameter1dv == cgGLSetParameter1dv)
    {
      traceWarning("Ignoring cgGLSetParameter1dv loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter1dv = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter1dv not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter2dv)
  {
    if (traceCgGL_Native.cgGLSetParameter2dv == cgGLSetParameter2dv)
    {
      traceWarning("Ignoring cgGLSetParameter2dv loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter2dv = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter2dv not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter3dv)
  {
    if (traceCgGL_Native.cgGLSetParameter3dv == cgGLSetParameter3dv)
    {
      traceWarning("Ignoring cgGLSetParameter3dv loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter3dv = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter3dv not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameter4dv)
  {
    if (traceCgGL_Native.cgGLSetParameter4dv == cgGLSetParameter4dv)
    {
      traceWarning("Ignoring cgGLSetParameter4dv loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameter4dv = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameter4dv not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameter1f)
  {
    if (traceCgGL_Native.cgGLGetParameter1f == cgGLGetParameter1f)
    {
      traceWarning("Ignoring cgGLGetParameter1f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameter1f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameter1f not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameter2f)
  {
    if (traceCgGL_Native.cgGLGetParameter2f == cgGLGetParameter2f)
    {
      traceWarning("Ignoring cgGLGetParameter2f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameter2f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameter2f not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameter3f)
  {
    if (traceCgGL_Native.cgGLGetParameter3f == cgGLGetParameter3f)
    {
      traceWarning("Ignoring cgGLGetParameter3f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameter3f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameter3f not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameter4f)
  {
    if (traceCgGL_Native.cgGLGetParameter4f == cgGLGetParameter4f)
    {
      traceWarning("Ignoring cgGLGetParameter4f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameter4f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameter4f not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameter1d)
  {
    if (traceCgGL_Native.cgGLGetParameter1d == cgGLGetParameter1d)
    {
      traceWarning("Ignoring cgGLGetParameter1d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameter1d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameter1d not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameter2d)
  {
    if (traceCgGL_Native.cgGLGetParameter2d == cgGLGetParameter2d)
    {
      traceWarning("Ignoring cgGLGetParameter2d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameter2d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameter2d not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameter3d)
  {
    if (traceCgGL_Native.cgGLGetParameter3d == cgGLGetParameter3d)
    {
      traceWarning("Ignoring cgGLGetParameter3d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameter3d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameter3d not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameter4d)
  {
    if (traceCgGL_Native.cgGLGetParameter4d == cgGLGetParameter4d)
    {
      traceWarning("Ignoring cgGLGetParameter4d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameter4d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameter4d not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameterArray1f)
  {
    if (traceCgGL_Native.cgGLSetParameterArray1f == cgGLSetParameterArray1f)
    {
      traceWarning("Ignoring cgGLSetParameterArray1f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameterArray1f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameterArray1f not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameterArray2f)
  {
    if (traceCgGL_Native.cgGLSetParameterArray2f == cgGLSetParameterArray2f)
    {
      traceWarning("Ignoring cgGLSetParameterArray2f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameterArray2f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameterArray2f not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameterArray3f)
  {
    if (traceCgGL_Native.cgGLSetParameterArray3f == cgGLSetParameterArray3f)
    {
      traceWarning("Ignoring cgGLSetParameterArray3f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameterArray3f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameterArray3f not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameterArray4f)
  {
    if (traceCgGL_Native.cgGLSetParameterArray4f == cgGLSetParameterArray4f)
    {
      traceWarning("Ignoring cgGLSetParameterArray4f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameterArray4f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameterArray4f not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameterArray1d)
  {
    if (traceCgGL_Native.cgGLSetParameterArray1d == cgGLSetParameterArray1d)
    {
      traceWarning("Ignoring cgGLSetParameterArray1d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameterArray1d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameterArray1d not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameterArray2d)
  {
    if (traceCgGL_Native.cgGLSetParameterArray2d == cgGLSetParameterArray2d)
    {
      traceWarning("Ignoring cgGLSetParameterArray2d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameterArray2d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameterArray2d not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameterArray3d)
  {
    if (traceCgGL_Native.cgGLSetParameterArray3d == cgGLSetParameterArray3d)
    {
      traceWarning("Ignoring cgGLSetParameterArray3d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameterArray3d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameterArray3d not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameterArray4d)
  {
    if (traceCgGL_Native.cgGLSetParameterArray4d == cgGLSetParameterArray4d)
    {
      traceWarning("Ignoring cgGLSetParameterArray4d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameterArray4d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameterArray4d not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameterArray1f)
  {
    if (traceCgGL_Native.cgGLGetParameterArray1f == cgGLGetParameterArray1f)
    {
      traceWarning("Ignoring cgGLGetParameterArray1f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameterArray1f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameterArray1f not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameterArray2f)
  {
    if (traceCgGL_Native.cgGLGetParameterArray2f == cgGLGetParameterArray2f)
    {
      traceWarning("Ignoring cgGLGetParameterArray2f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameterArray2f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameterArray2f not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameterArray3f)
  {
    if (traceCgGL_Native.cgGLGetParameterArray3f == cgGLGetParameterArray3f)
    {
      traceWarning("Ignoring cgGLGetParameterArray3f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameterArray3f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameterArray3f not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameterArray4f)
  {
    if (traceCgGL_Native.cgGLGetParameterArray4f == cgGLGetParameterArray4f)
    {
      traceWarning("Ignoring cgGLGetParameterArray4f loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameterArray4f = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameterArray4f not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameterArray1d)
  {
    if (traceCgGL_Native.cgGLGetParameterArray1d == cgGLGetParameterArray1d)
    {
      traceWarning("Ignoring cgGLGetParameterArray1d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameterArray1d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameterArray1d not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameterArray2d)
  {
    if (traceCgGL_Native.cgGLGetParameterArray2d == cgGLGetParameterArray2d)
    {
      traceWarning("Ignoring cgGLGetParameterArray2d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameterArray2d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameterArray2d not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameterArray3d)
  {
    if (traceCgGL_Native.cgGLGetParameterArray3d == cgGLGetParameterArray3d)
    {
      traceWarning("Ignoring cgGLGetParameterArray3d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameterArray3d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameterArray3d not loaded.");
  }
  if (traceCgGL_Native.cgGLGetParameterArray4d)
  {
    if (traceCgGL_Native.cgGLGetParameterArray4d == cgGLGetParameterArray4d)
    {
      traceWarning("Ignoring cgGLGetParameterArray4d loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetParameterArray4d = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetParameterArray4d not loaded.");
  }
  if (traceCgGL_Native.cgGLSetParameterPointer)
  {
    if (traceCgGL_Native.cgGLSetParameterPointer == cgGLSetParameterPointer)
    {
      traceWarning("Ignoring cgGLSetParameterPointer loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetParameterPointer = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetParameterPointer not loaded.");
  }
  if (traceCgGL_Native.cgGLEnableClientState)
  {
    if (traceCgGL_Native.cgGLEnableClientState == cgGLEnableClientState)
    {
      traceWarning("Ignoring cgGLEnableClientState loaded from traceCgGL library.");
      traceCgGL_Native.cgGLEnableClientState = NULL;
    }
  }
  else
  {
    traceWarning("cgGLEnableClientState not loaded.");
  }
  if (traceCgGL_Native.cgGLDisableClientState)
  {
    if (traceCgGL_Native.cgGLDisableClientState == cgGLDisableClientState)
    {
      traceWarning("Ignoring cgGLDisableClientState loaded from traceCgGL library.");
      traceCgGL_Native.cgGLDisableClientState = NULL;
    }
  }
  else
  {
    traceWarning("cgGLDisableClientState not loaded.");
  }
  if (traceCgGL_Native.cgGLSetMatrixParameterdr)
  {
    if (traceCgGL_Native.cgGLSetMatrixParameterdr == cgGLSetMatrixParameterdr)
    {
      traceWarning("Ignoring cgGLSetMatrixParameterdr loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetMatrixParameterdr = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetMatrixParameterdr not loaded.");
  }
  if (traceCgGL_Native.cgGLSetMatrixParameterfr)
  {
    if (traceCgGL_Native.cgGLSetMatrixParameterfr == cgGLSetMatrixParameterfr)
    {
      traceWarning("Ignoring cgGLSetMatrixParameterfr loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetMatrixParameterfr = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetMatrixParameterfr not loaded.");
  }
  if (traceCgGL_Native.cgGLSetMatrixParameterdc)
  {
    if (traceCgGL_Native.cgGLSetMatrixParameterdc == cgGLSetMatrixParameterdc)
    {
      traceWarning("Ignoring cgGLSetMatrixParameterdc loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetMatrixParameterdc = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetMatrixParameterdc not loaded.");
  }
  if (traceCgGL_Native.cgGLSetMatrixParameterfc)
  {
    if (traceCgGL_Native.cgGLSetMatrixParameterfc == cgGLSetMatrixParameterfc)
    {
      traceWarning("Ignoring cgGLSetMatrixParameterfc loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetMatrixParameterfc = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetMatrixParameterfc not loaded.");
  }
  if (traceCgGL_Native.cgGLGetMatrixParameterdr)
  {
    if (traceCgGL_Native.cgGLGetMatrixParameterdr == cgGLGetMatrixParameterdr)
    {
      traceWarning("Ignoring cgGLGetMatrixParameterdr loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetMatrixParameterdr = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetMatrixParameterdr not loaded.");
  }
  if (traceCgGL_Native.cgGLGetMatrixParameterfr)
  {
    if (traceCgGL_Native.cgGLGetMatrixParameterfr == cgGLGetMatrixParameterfr)
    {
      traceWarning("Ignoring cgGLGetMatrixParameterfr loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetMatrixParameterfr = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetMatrixParameterfr not loaded.");
  }
  if (traceCgGL_Native.cgGLGetMatrixParameterdc)
  {
    if (traceCgGL_Native.cgGLGetMatrixParameterdc == cgGLGetMatrixParameterdc)
    {
      traceWarning("Ignoring cgGLGetMatrixParameterdc loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetMatrixParameterdc = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetMatrixParameterdc not loaded.");
  }
  if (traceCgGL_Native.cgGLGetMatrixParameterfc)
  {
    if (traceCgGL_Native.cgGLGetMatrixParameterfc == cgGLGetMatrixParameterfc)
    {
      traceWarning("Ignoring cgGLGetMatrixParameterfc loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetMatrixParameterfc = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetMatrixParameterfc not loaded.");
  }
  if (traceCgGL_Native.cgGLSetStateMatrixParameter)
  {
    if (traceCgGL_Native.cgGLSetStateMatrixParameter == cgGLSetStateMatrixParameter)
    {
      traceWarning("Ignoring cgGLSetStateMatrixParameter loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetStateMatrixParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetStateMatrixParameter not loaded.");
  }
  if (traceCgGL_Native.cgGLSetMatrixParameterArrayfc)
  {
    if (traceCgGL_Native.cgGLSetMatrixParameterArrayfc == cgGLSetMatrixParameterArrayfc)
    {
      traceWarning("Ignoring cgGLSetMatrixParameterArrayfc loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetMatrixParameterArrayfc = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetMatrixParameterArrayfc not loaded.");
  }
  if (traceCgGL_Native.cgGLSetMatrixParameterArrayfr)
  {
    if (traceCgGL_Native.cgGLSetMatrixParameterArrayfr == cgGLSetMatrixParameterArrayfr)
    {
      traceWarning("Ignoring cgGLSetMatrixParameterArrayfr loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetMatrixParameterArrayfr = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetMatrixParameterArrayfr not loaded.");
  }
  if (traceCgGL_Native.cgGLSetMatrixParameterArraydc)
  {
    if (traceCgGL_Native.cgGLSetMatrixParameterArraydc == cgGLSetMatrixParameterArraydc)
    {
      traceWarning("Ignoring cgGLSetMatrixParameterArraydc loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetMatrixParameterArraydc = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetMatrixParameterArraydc not loaded.");
  }
  if (traceCgGL_Native.cgGLSetMatrixParameterArraydr)
  {
    if (traceCgGL_Native.cgGLSetMatrixParameterArraydr == cgGLSetMatrixParameterArraydr)
    {
      traceWarning("Ignoring cgGLSetMatrixParameterArraydr loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetMatrixParameterArraydr = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetMatrixParameterArraydr not loaded.");
  }
  if (traceCgGL_Native.cgGLGetMatrixParameterArrayfc)
  {
    if (traceCgGL_Native.cgGLGetMatrixParameterArrayfc == cgGLGetMatrixParameterArrayfc)
    {
      traceWarning("Ignoring cgGLGetMatrixParameterArrayfc loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetMatrixParameterArrayfc = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetMatrixParameterArrayfc not loaded.");
  }
  if (traceCgGL_Native.cgGLGetMatrixParameterArrayfr)
  {
    if (traceCgGL_Native.cgGLGetMatrixParameterArrayfr == cgGLGetMatrixParameterArrayfr)
    {
      traceWarning("Ignoring cgGLGetMatrixParameterArrayfr loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetMatrixParameterArrayfr = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetMatrixParameterArrayfr not loaded.");
  }
  if (traceCgGL_Native.cgGLGetMatrixParameterArraydc)
  {
    if (traceCgGL_Native.cgGLGetMatrixParameterArraydc == cgGLGetMatrixParameterArraydc)
    {
      traceWarning("Ignoring cgGLGetMatrixParameterArraydc loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetMatrixParameterArraydc = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetMatrixParameterArraydc not loaded.");
  }
  if (traceCgGL_Native.cgGLGetMatrixParameterArraydr)
  {
    if (traceCgGL_Native.cgGLGetMatrixParameterArraydr == cgGLGetMatrixParameterArraydr)
    {
      traceWarning("Ignoring cgGLGetMatrixParameterArraydr loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetMatrixParameterArraydr = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetMatrixParameterArraydr not loaded.");
  }
  if (traceCgGL_Native.cgGLSetTextureParameter)
  {
    if (traceCgGL_Native.cgGLSetTextureParameter == cgGLSetTextureParameter)
    {
      traceWarning("Ignoring cgGLSetTextureParameter loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetTextureParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetTextureParameter not loaded.");
  }
  if (traceCgGL_Native.cgGLGetTextureParameter)
  {
    if (traceCgGL_Native.cgGLGetTextureParameter == cgGLGetTextureParameter)
    {
      traceWarning("Ignoring cgGLGetTextureParameter loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetTextureParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetTextureParameter not loaded.");
  }
  if (traceCgGL_Native.cgGLEnableTextureParameter)
  {
    if (traceCgGL_Native.cgGLEnableTextureParameter == cgGLEnableTextureParameter)
    {
      traceWarning("Ignoring cgGLEnableTextureParameter loaded from traceCgGL library.");
      traceCgGL_Native.cgGLEnableTextureParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGLEnableTextureParameter not loaded.");
  }
  if (traceCgGL_Native.cgGLDisableTextureParameter)
  {
    if (traceCgGL_Native.cgGLDisableTextureParameter == cgGLDisableTextureParameter)
    {
      traceWarning("Ignoring cgGLDisableTextureParameter loaded from traceCgGL library.");
      traceCgGL_Native.cgGLDisableTextureParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGLDisableTextureParameter not loaded.");
  }
  if (traceCgGL_Native.cgGLGetTextureEnum)
  {
    if (traceCgGL_Native.cgGLGetTextureEnum == cgGLGetTextureEnum)
    {
      traceWarning("Ignoring cgGLGetTextureEnum loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetTextureEnum = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetTextureEnum not loaded.");
  }
  if (traceCgGL_Native.cgGLSetManageTextureParameters)
  {
    if (traceCgGL_Native.cgGLSetManageTextureParameters == cgGLSetManageTextureParameters)
    {
      traceWarning("Ignoring cgGLSetManageTextureParameters loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetManageTextureParameters = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetManageTextureParameters not loaded.");
  }
  if (traceCgGL_Native.cgGLGetManageTextureParameters)
  {
    if (traceCgGL_Native.cgGLGetManageTextureParameters == cgGLGetManageTextureParameters)
    {
      traceWarning("Ignoring cgGLGetManageTextureParameters loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetManageTextureParameters = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetManageTextureParameters not loaded.");
  }
  if (traceCgGL_Native.cgGLSetupSampler)
  {
    if (traceCgGL_Native.cgGLSetupSampler == cgGLSetupSampler)
    {
      traceWarning("Ignoring cgGLSetupSampler loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetupSampler = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetupSampler not loaded.");
  }
  if (traceCgGL_Native.cgGLRegisterStates)
  {
    if (traceCgGL_Native.cgGLRegisterStates == cgGLRegisterStates)
    {
      traceWarning("Ignoring cgGLRegisterStates loaded from traceCgGL library.");
      traceCgGL_Native.cgGLRegisterStates = NULL;
    }
  }
  else
  {
    traceWarning("cgGLRegisterStates not loaded.");
  }
  if (traceCgGL_Native.cgGLEnableProgramProfiles)
  {
    if (traceCgGL_Native.cgGLEnableProgramProfiles == cgGLEnableProgramProfiles)
    {
      traceWarning("Ignoring cgGLEnableProgramProfiles loaded from traceCgGL library.");
      traceCgGL_Native.cgGLEnableProgramProfiles = NULL;
    }
  }
  else
  {
    traceWarning("cgGLEnableProgramProfiles not loaded.");
  }
  if (traceCgGL_Native.cgGLDisableProgramProfiles)
  {
    if (traceCgGL_Native.cgGLDisableProgramProfiles == cgGLDisableProgramProfiles)
    {
      traceWarning("Ignoring cgGLDisableProgramProfiles loaded from traceCgGL library.");
      traceCgGL_Native.cgGLDisableProgramProfiles = NULL;
    }
  }
  else
  {
    traceWarning("cgGLDisableProgramProfiles not loaded.");
  }
  if (traceCgGL_Native.cgGLSetDebugMode)
  {
    if (traceCgGL_Native.cgGLSetDebugMode == cgGLSetDebugMode)
    {
      traceWarning("Ignoring cgGLSetDebugMode loaded from traceCgGL library.");
      traceCgGL_Native.cgGLSetDebugMode = NULL;
    }
  }
  else
  {
    traceWarning("cgGLSetDebugMode not loaded.");
  }
  if (traceCgGL_Native.cgGLCreateBuffer)
  {
    if (traceCgGL_Native.cgGLCreateBuffer == cgGLCreateBuffer)
    {
      traceWarning("Ignoring cgGLCreateBuffer loaded from traceCgGL library.");
      traceCgGL_Native.cgGLCreateBuffer = NULL;
    }
  }
  else
  {
    traceWarning("cgGLCreateBuffer not loaded.");
  }
  if (traceCgGL_Native.cgGLGetBufferObject)
  {
    if (traceCgGL_Native.cgGLGetBufferObject == cgGLGetBufferObject)
    {
      traceWarning("Ignoring cgGLGetBufferObject loaded from traceCgGL library.");
      traceCgGL_Native.cgGLGetBufferObject = NULL;
    }
  }
  else
  {
    traceWarning("cgGLGetBufferObject not loaded.");
  }

  /* Load CgGL helper function pointers. */

  traceCgGL_helperCgGetMatrixParameterSize = (size_t (*)(CGparameter)) traceGetProcAddress("traceCgHelperCgGetMatrixParameterSize");
  traceCgGL_helperCgGetParameterArraySize = (size_t (*)(CGparameter, long, long, long)) traceGetProcAddress("traceCgHelperCgGetParameterArraySize");
  traceCgGL_helperCgGetMatrixParameterArraySize = (size_t (*)(CGparameter, long, long)) traceGetProcAddress("traceCgHelperCgGetMatrixParameterArraySize");
  traceCgGL_helperCgCreateBufferSize = (size_t (*)(int)) traceGetProcAddress("traceCgHelperCgCreateBufferSize");

  /* Validate CgGL helper function pointers. */

  if (!traceCgGL_helperCgGetMatrixParameterSize)
    traceWarning("Helper helperCgGetMatrixParameterSize not found; some parameters may not be traced.");
  if (!traceCgGL_helperCgGetParameterArraySize)
    traceWarning("Helper helperCgGetParameterArraySize not found; some parameters may not be traced.");
  if (!traceCgGL_helperCgGetMatrixParameterArraySize)
    traceWarning("Helper helperCgGetMatrixParameterArraySize not found; some parameters may not be traced.");
  if (!traceCgGL_helperCgCreateBufferSize)
    traceWarning("Helper helperCgCreateBufferSize not found; some parameters may not be traced.");

  traceCgGL_initialized = 1;
}

/* CgGL API wrapper functions. */

DLLEXPORT CGbool
cgGLIsProfileSupported(CGprofile profile)
{
  CGbool ret = CG_FALSE;
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLIsProfileSupported");

  if (!traceCgGL_Native.cgGLIsProfileSupported)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLIsProfileSupported");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("profile", "%lu", profile);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCgGL_Native.cgGLIsProfileSupported(profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgGLEnableProfile(CGprofile profile)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLEnableProfile");

  if (!traceCgGL_Native.cgGLEnableProfile)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLEnableProfile");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("profile", "%lu", profile);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLEnableProfile(profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLDisableProfile(CGprofile profile)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLDisableProfile");

  if (!traceCgGL_Native.cgGLDisableProfile)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLDisableProfile");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("profile", "%lu", profile);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLDisableProfile(profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGprofile
cgGLGetLatestProfile(CGGLenum profile_type)
{
  CGprofile ret = (CGprofile) 0;
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetLatestProfile");

  if (!traceCgGL_Native.cgGLGetLatestProfile)
    return (CGprofile) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetLatestProfile");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("profile_type", "%lu", profile_type);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCgGL_Native.cgGLGetLatestProfile(profile_type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgGLSetOptimalOptions(CGprofile profile)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetOptimalOptions");

  if (!traceCgGL_Native.cgGLSetOptimalOptions)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetOptimalOptions");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("profile", "%lu", profile);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetOptimalOptions(profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT char const **
cgGLGetOptimalOptions(CGprofile profile)
{
  char const **ret = NULL;
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetOptimalOptions");

  if (!traceCgGL_Native.cgGLGetOptimalOptions)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetOptimalOptions");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("profile", "%lu", profile);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCgGL_Native.cgGLGetOptimalOptions(profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceReturn("%s[]", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgGLLoadProgram(CGprogram program)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLLoadProgram");

  if (!traceCgGL_Native.cgGLLoadProgram)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLLoadProgram");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLLoadProgram(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLUnloadProgram(CGprogram program)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLUnloadProgram");

  if (!traceCgGL_Native.cgGLUnloadProgram)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLUnloadProgram");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLUnloadProgram(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGbool
cgGLIsProgramLoaded(CGprogram program)
{
  CGbool ret = CG_FALSE;
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLIsProgramLoaded");

  if (!traceCgGL_Native.cgGLIsProgramLoaded)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLIsProgramLoaded");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCgGL_Native.cgGLIsProgramLoaded(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgGLBindProgram(CGprogram program)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLBindProgram");

  if (!traceCgGL_Native.cgGLBindProgram)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLBindProgram");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLBindProgram(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLUnbindProgram(CGprofile profile)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLUnbindProgram");

  if (!traceCgGL_Native.cgGLUnbindProgram)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLUnbindProgram");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("profile", "%lu", profile);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLUnbindProgram(profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT GLuint
cgGLGetProgramID(CGprogram program)
{
  GLuint ret = 0;
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetProgramID");

  if (!traceCgGL_Native.cgGLGetProgramID)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetProgramID");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCgGL_Native.cgGLGetProgramID(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceReturn("%u", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgGLSetParameter1f(CGparameter param, float x)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter1f");

  if (!traceCgGL_Native.cgGLSetParameter1f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter1f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("x", "%f", x);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter1f(param, x);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter2f(CGparameter param, float x, float y)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter2f");

  if (!traceCgGL_Native.cgGLSetParameter2f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter2f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("x", "%f", x);
    traceInputParameter("y", "%f", y);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter2f(param, x, y);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter3f(CGparameter param, float x, float y, float z)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter3f");

  if (!traceCgGL_Native.cgGLSetParameter3f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter3f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("x", "%f", x);
    traceInputParameter("y", "%f", y);
    traceInputParameter("z", "%f", z);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter3f(param, x, y, z);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter4f(CGparameter param, float x, float y, float z, float w)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter4f");

  if (!traceCgGL_Native.cgGLSetParameter4f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter4f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("x", "%f", x);
    traceInputParameter("y", "%f", y);
    traceInputParameter("z", "%f", z);
    traceInputParameter("w", "%f", w);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter4f(param, x, y, z, w);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter1fv(CGparameter param, const float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter1fv");

  if (!traceCgGL_Native.cgGLSetParameter1fv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter1fv");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("v", "%f[%d]", v, 1);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter1fv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter2fv(CGparameter param, const float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter2fv");

  if (!traceCgGL_Native.cgGLSetParameter2fv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter2fv");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("v", "%f[%d]", v, 2);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter2fv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter3fv(CGparameter param, const float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter3fv");

  if (!traceCgGL_Native.cgGLSetParameter3fv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter3fv");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("v", "%f[%d]", v, 3);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter3fv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter4fv(CGparameter param, const float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter4fv");

  if (!traceCgGL_Native.cgGLSetParameter4fv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter4fv");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("v", "%f[%d]", v, 4);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter4fv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter1d(CGparameter param, double x)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter1d");

  if (!traceCgGL_Native.cgGLSetParameter1d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter1d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("x", "%lf", x);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter1d(param, x);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter2d(CGparameter param, double x, double y)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter2d");

  if (!traceCgGL_Native.cgGLSetParameter2d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter2d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("x", "%lf", x);
    traceInputParameter("y", "%lf", y);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter2d(param, x, y);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter3d(CGparameter param, double x, double y, double z)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter3d");

  if (!traceCgGL_Native.cgGLSetParameter3d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter3d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("x", "%lf", x);
    traceInputParameter("y", "%lf", y);
    traceInputParameter("z", "%lf", z);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter3d(param, x, y, z);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter4d(CGparameter param, double x, double y, double z, double w)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter4d");

  if (!traceCgGL_Native.cgGLSetParameter4d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter4d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("x", "%lf", x);
    traceInputParameter("y", "%lf", y);
    traceInputParameter("z", "%lf", z);
    traceInputParameter("w", "%lf", w);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter4d(param, x, y, z, w);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter1dv(CGparameter param, const double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter1dv");

  if (!traceCgGL_Native.cgGLSetParameter1dv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter1dv");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("v", "%lf[%d]", v, 1);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter1dv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter2dv(CGparameter param, const double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter2dv");

  if (!traceCgGL_Native.cgGLSetParameter2dv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter2dv");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("v", "%lf[%d]", v, 2);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter2dv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter3dv(CGparameter param, const double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter3dv");

  if (!traceCgGL_Native.cgGLSetParameter3dv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter3dv");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("v", "%lf[%d]", v, 3);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter3dv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameter4dv(CGparameter param, const double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameter4dv");

  if (!traceCgGL_Native.cgGLSetParameter4dv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameter4dv");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("v", "%lf[%d]", v, 4);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameter4dv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameter1f(CGparameter param, float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameter1f");

  if (!traceCgGL_Native.cgGLGetParameter1f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameter1f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameter1f(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%f[%d]", v, 1);

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameter2f(CGparameter param, float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameter2f");

  if (!traceCgGL_Native.cgGLGetParameter2f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameter2f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameter2f(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%f[%d]", v, 2);

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameter3f(CGparameter param, float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameter3f");

  if (!traceCgGL_Native.cgGLGetParameter3f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameter3f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameter3f(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%f[%d]", v, 3);

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameter4f(CGparameter param, float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameter4f");

  if (!traceCgGL_Native.cgGLGetParameter4f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameter4f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameter4f(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%f[%d]", v, 4);

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameter1d(CGparameter param, double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameter1d");

  if (!traceCgGL_Native.cgGLGetParameter1d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameter1d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameter1d(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%lf[%d]", v, 1);

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameter2d(CGparameter param, double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameter2d");

  if (!traceCgGL_Native.cgGLGetParameter2d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameter2d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameter2d(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%lf[%d]", v, 2);

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameter3d(CGparameter param, double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameter3d");

  if (!traceCgGL_Native.cgGLGetParameter3d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameter3d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameter3d(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%lf[%d]", v, 3);

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameter4d(CGparameter param, double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameter4d");

  if (!traceCgGL_Native.cgGLGetParameter4d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameter4d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameter4d(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%lf[%d]", v, 4);

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameterArray1f(CGparameter param, long offset, long nelements, const float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameterArray1f");

  if (!traceCgGL_Native.cgGLSetParameterArray1f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameterArray1f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);
    traceInputParameter("v", "%f[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 1) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameterArray1f(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameterArray2f(CGparameter param, long offset, long nelements, const float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameterArray2f");

  if (!traceCgGL_Native.cgGLSetParameterArray2f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameterArray2f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);
    traceInputParameter("v", "%f[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 2) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameterArray2f(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameterArray3f(CGparameter param, long offset, long nelements, const float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameterArray3f");

  if (!traceCgGL_Native.cgGLSetParameterArray3f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameterArray3f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);
    traceInputParameter("v", "%f[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 3) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameterArray3f(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameterArray4f(CGparameter param, long offset, long nelements, const float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameterArray4f");

  if (!traceCgGL_Native.cgGLSetParameterArray4f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameterArray4f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);
    traceInputParameter("v", "%f[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 4) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameterArray4f(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameterArray1d(CGparameter param, long offset, long nelements, const double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameterArray1d");

  if (!traceCgGL_Native.cgGLSetParameterArray1d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameterArray1d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);
    traceInputParameter("v", "%lf[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 1) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameterArray1d(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameterArray2d(CGparameter param, long offset, long nelements, const double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameterArray2d");

  if (!traceCgGL_Native.cgGLSetParameterArray2d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameterArray2d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);
    traceInputParameter("v", "%lf[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 2) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameterArray2d(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameterArray3d(CGparameter param, long offset, long nelements, const double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameterArray3d");

  if (!traceCgGL_Native.cgGLSetParameterArray3d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameterArray3d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);
    traceInputParameter("v", "%lf[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 3) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameterArray3d(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameterArray4d(CGparameter param, long offset, long nelements, const double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameterArray4d");

  if (!traceCgGL_Native.cgGLSetParameterArray4d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameterArray4d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);
    traceInputParameter("v", "%lf[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 4) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameterArray4d(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameterArray1f(CGparameter param, long offset, long nelements, float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameterArray1f");

  if (!traceCgGL_Native.cgGLGetParameterArray1f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameterArray1f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameterArray1f(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%f[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 1) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameterArray2f(CGparameter param, long offset, long nelements, float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameterArray2f");

  if (!traceCgGL_Native.cgGLGetParameterArray2f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameterArray2f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameterArray2f(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%f[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 2) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameterArray3f(CGparameter param, long offset, long nelements, float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameterArray3f");

  if (!traceCgGL_Native.cgGLGetParameterArray3f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameterArray3f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameterArray3f(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%f[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 3) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameterArray4f(CGparameter param, long offset, long nelements, float *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameterArray4f");

  if (!traceCgGL_Native.cgGLGetParameterArray4f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameterArray4f");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameterArray4f(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%f[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 4) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameterArray1d(CGparameter param, long offset, long nelements, double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameterArray1d");

  if (!traceCgGL_Native.cgGLGetParameterArray1d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameterArray1d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameterArray1d(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%lf[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 1) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameterArray2d(CGparameter param, long offset, long nelements, double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameterArray2d");

  if (!traceCgGL_Native.cgGLGetParameterArray2d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameterArray2d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameterArray2d(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%lf[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 2) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameterArray3d(CGparameter param, long offset, long nelements, double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameterArray3d");

  if (!traceCgGL_Native.cgGLGetParameterArray3d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameterArray3d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameterArray3d(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%lf[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 3) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetParameterArray4d(CGparameter param, long offset, long nelements, double *v)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetParameterArray4d");

  if (!traceCgGL_Native.cgGLGetParameterArray4d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetParameterArray4d");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetParameterArray4d(param, offset, nelements, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("v", "%lf[%ld]", v, (traceCgGL_helperCgGetParameterArraySize ? traceCgGL_helperCgGetParameterArraySize(param, offset, nelements, 4) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetParameterPointer(CGparameter param, GLint fsize, GLenum type, GLsizei stride, const GLvoid *pointer)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetParameterPointer");

  if (!traceCgGL_Native.cgGLSetParameterPointer)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetParameterPointer");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("fsize", "%d", fsize);
    traceInputParameter("type", "%u", type);
    traceInputParameter("stride", "%d", stride);
    traceInputParameter("pointer", "%p", pointer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetParameterPointer(param, fsize, type, stride, pointer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLEnableClientState(CGparameter param)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLEnableClientState");

  if (!traceCgGL_Native.cgGLEnableClientState)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLEnableClientState");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLEnableClientState(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLDisableClientState(CGparameter param)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLDisableClientState");

  if (!traceCgGL_Native.cgGLDisableClientState)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLDisableClientState");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLDisableClientState(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetMatrixParameterdr(CGparameter param, const double *matrix)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetMatrixParameterdr");

  if (!traceCgGL_Native.cgGLSetMatrixParameterdr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetMatrixParameterdr");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("matrix", "%lf[%ld]", matrix, (traceCgGL_helperCgGetMatrixParameterSize ? traceCgGL_helperCgGetMatrixParameterSize(param) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetMatrixParameterdr(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetMatrixParameterfr(CGparameter param, const float *matrix)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetMatrixParameterfr");

  if (!traceCgGL_Native.cgGLSetMatrixParameterfr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetMatrixParameterfr");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("matrix", "%f[%ld]", matrix, (traceCgGL_helperCgGetMatrixParameterSize ? traceCgGL_helperCgGetMatrixParameterSize(param) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetMatrixParameterfr(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetMatrixParameterdc(CGparameter param, const double *matrix)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetMatrixParameterdc");

  if (!traceCgGL_Native.cgGLSetMatrixParameterdc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetMatrixParameterdc");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("matrix", "%lf[%ld]", matrix, (traceCgGL_helperCgGetMatrixParameterSize ? traceCgGL_helperCgGetMatrixParameterSize(param) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetMatrixParameterdc(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetMatrixParameterfc(CGparameter param, const float *matrix)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetMatrixParameterfc");

  if (!traceCgGL_Native.cgGLSetMatrixParameterfc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetMatrixParameterfc");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("matrix", "%f[%ld]", matrix, (traceCgGL_helperCgGetMatrixParameterSize ? traceCgGL_helperCgGetMatrixParameterSize(param) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetMatrixParameterfc(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetMatrixParameterdr(CGparameter param, double *matrix)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetMatrixParameterdr");

  if (!traceCgGL_Native.cgGLGetMatrixParameterdr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetMatrixParameterdr");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetMatrixParameterdr(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("matrix", "%lf[%ld]", matrix, (traceCgGL_helperCgGetMatrixParameterSize ? traceCgGL_helperCgGetMatrixParameterSize(param) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetMatrixParameterfr(CGparameter param, float *matrix)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetMatrixParameterfr");

  if (!traceCgGL_Native.cgGLGetMatrixParameterfr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetMatrixParameterfr");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetMatrixParameterfr(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("matrix", "%f[%ld]", matrix, (traceCgGL_helperCgGetMatrixParameterSize ? traceCgGL_helperCgGetMatrixParameterSize(param) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetMatrixParameterdc(CGparameter param, double *matrix)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetMatrixParameterdc");

  if (!traceCgGL_Native.cgGLGetMatrixParameterdc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetMatrixParameterdc");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetMatrixParameterdc(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("matrix", "%lf[%ld]", matrix, (traceCgGL_helperCgGetMatrixParameterSize ? traceCgGL_helperCgGetMatrixParameterSize(param) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetMatrixParameterfc(CGparameter param, float *matrix)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetMatrixParameterfc");

  if (!traceCgGL_Native.cgGLGetMatrixParameterfc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetMatrixParameterfc");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetMatrixParameterfc(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("matrix", "%f[%ld]", matrix, (traceCgGL_helperCgGetMatrixParameterSize ? traceCgGL_helperCgGetMatrixParameterSize(param) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetStateMatrixParameter(CGparameter param, CGGLenum matrix, CGGLenum transform)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetStateMatrixParameter");

  if (!traceCgGL_Native.cgGLSetStateMatrixParameter)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetStateMatrixParameter");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("matrix", "%lu", matrix);
    traceInputParameter("transform", "%lu", transform);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetStateMatrixParameter(param, matrix, transform);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetMatrixParameterArrayfc(CGparameter param, long offset, long nelements, const float *matrices)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetMatrixParameterArrayfc");

  if (!traceCgGL_Native.cgGLSetMatrixParameterArrayfc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetMatrixParameterArrayfc");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);
    traceInputParameter("matrices", "%f[%ld]", matrices, (traceCgGL_helperCgGetMatrixParameterArraySize ? traceCgGL_helperCgGetMatrixParameterArraySize(param, offset, nelements) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetMatrixParameterArrayfc(param, offset, nelements, matrices);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetMatrixParameterArrayfr(CGparameter param, long offset, long nelements, const float *matrices)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetMatrixParameterArrayfr");

  if (!traceCgGL_Native.cgGLSetMatrixParameterArrayfr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetMatrixParameterArrayfr");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);
    traceInputParameter("matrices", "%f[%ld]", matrices, (traceCgGL_helperCgGetMatrixParameterArraySize ? traceCgGL_helperCgGetMatrixParameterArraySize(param, offset, nelements) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetMatrixParameterArrayfr(param, offset, nelements, matrices);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetMatrixParameterArraydc(CGparameter param, long offset, long nelements, const double *matrices)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetMatrixParameterArraydc");

  if (!traceCgGL_Native.cgGLSetMatrixParameterArraydc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetMatrixParameterArraydc");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);
    traceInputParameter("matrices", "%lf[%ld]", matrices, (traceCgGL_helperCgGetMatrixParameterArraySize ? traceCgGL_helperCgGetMatrixParameterArraySize(param, offset, nelements) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetMatrixParameterArraydc(param, offset, nelements, matrices);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetMatrixParameterArraydr(CGparameter param, long offset, long nelements, const double *matrices)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetMatrixParameterArraydr");

  if (!traceCgGL_Native.cgGLSetMatrixParameterArraydr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetMatrixParameterArraydr");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);
    traceInputParameter("matrices", "%lf[%ld]", matrices, (traceCgGL_helperCgGetMatrixParameterArraySize ? traceCgGL_helperCgGetMatrixParameterArraySize(param, offset, nelements) : 0));

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetMatrixParameterArraydr(param, offset, nelements, matrices);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetMatrixParameterArrayfc(CGparameter param, long offset, long nelements, float *matrices)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetMatrixParameterArrayfc");

  if (!traceCgGL_Native.cgGLGetMatrixParameterArrayfc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetMatrixParameterArrayfc");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetMatrixParameterArrayfc(param, offset, nelements, matrices);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("matrices", "%f[%ld]", matrices, (traceCgGL_helperCgGetMatrixParameterArraySize ? traceCgGL_helperCgGetMatrixParameterArraySize(param, offset, nelements) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetMatrixParameterArrayfr(CGparameter param, long offset, long nelements, float *matrices)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetMatrixParameterArrayfr");

  if (!traceCgGL_Native.cgGLGetMatrixParameterArrayfr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetMatrixParameterArrayfr");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetMatrixParameterArrayfr(param, offset, nelements, matrices);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("matrices", "%f[%ld]", matrices, (traceCgGL_helperCgGetMatrixParameterArraySize ? traceCgGL_helperCgGetMatrixParameterArraySize(param, offset, nelements) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetMatrixParameterArraydc(CGparameter param, long offset, long nelements, double *matrices)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetMatrixParameterArraydc");

  if (!traceCgGL_Native.cgGLGetMatrixParameterArraydc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetMatrixParameterArraydc");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetMatrixParameterArraydc(param, offset, nelements, matrices);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("matrices", "%lf[%ld]", matrices, (traceCgGL_helperCgGetMatrixParameterArraySize ? traceCgGL_helperCgGetMatrixParameterArraySize(param, offset, nelements) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLGetMatrixParameterArraydr(CGparameter param, long offset, long nelements, double *matrices)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetMatrixParameterArraydr");

  if (!traceCgGL_Native.cgGLGetMatrixParameterArraydr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetMatrixParameterArraydr");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("offset", "%ld", offset);
    traceInputParameter("nelements", "%ld", nelements);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLGetMatrixParameterArraydr(param, offset, nelements, matrices);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceOutputParameter("matrices", "%lf[%ld]", matrices, (traceCgGL_helperCgGetMatrixParameterArraySize ? traceCgGL_helperCgGetMatrixParameterArraySize(param, offset, nelements) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetTextureParameter(CGparameter param, GLuint texobj)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetTextureParameter");

  if (!traceCgGL_Native.cgGLSetTextureParameter)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetTextureParameter");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("texobj", "%u", texobj);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetTextureParameter(param, texobj);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT GLuint
cgGLGetTextureParameter(CGparameter param)
{
  GLuint ret = 0;
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetTextureParameter");

  if (!traceCgGL_Native.cgGLGetTextureParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetTextureParameter");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCgGL_Native.cgGLGetTextureParameter(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceReturn("%u", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgGLEnableTextureParameter(CGparameter param)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLEnableTextureParameter");

  if (!traceCgGL_Native.cgGLEnableTextureParameter)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLEnableTextureParameter");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLEnableTextureParameter(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLDisableTextureParameter(CGparameter param)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLDisableTextureParameter");

  if (!traceCgGL_Native.cgGLDisableTextureParameter)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLDisableTextureParameter");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLDisableTextureParameter(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT GLenum
cgGLGetTextureEnum(CGparameter param)
{
  GLenum ret = 0;
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetTextureEnum");

  if (!traceCgGL_Native.cgGLGetTextureEnum)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetTextureEnum");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCgGL_Native.cgGLGetTextureEnum(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceReturn("%u", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgGLSetManageTextureParameters(CGcontext ctx, CGbool flag)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetManageTextureParameters");

  if (!traceCgGL_Native.cgGLSetManageTextureParameters)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetManageTextureParameters");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("ctx", "%zu", (size_t) ctx);
    traceInputParameter("flag", "%d", flag);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetManageTextureParameters(ctx, flag);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGbool
cgGLGetManageTextureParameters(CGcontext ctx)
{
  CGbool ret = CG_FALSE;
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetManageTextureParameters");

  if (!traceCgGL_Native.cgGLGetManageTextureParameters)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetManageTextureParameters");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("ctx", "%zu", (size_t) ctx);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCgGL_Native.cgGLGetManageTextureParameters(ctx);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgGLSetupSampler(CGparameter param, GLuint texobj)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetupSampler");

  if (!traceCgGL_Native.cgGLSetupSampler)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetupSampler");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("param", "%zu", (size_t) param);
    traceInputParameter("texobj", "%u", texobj);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetupSampler(param, texobj);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLRegisterStates(CGcontext ctx)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLRegisterStates");

  if (!traceCgGL_Native.cgGLRegisterStates)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLRegisterStates");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("ctx", "%zu", (size_t) ctx);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLRegisterStates(ctx);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLEnableProgramProfiles(CGprogram program)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLEnableProgramProfiles");

  if (!traceCgGL_Native.cgGLEnableProgramProfiles)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLEnableProgramProfiles");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLEnableProgramProfiles(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLDisableProgramProfiles(CGprogram program)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLDisableProgramProfiles");

  if (!traceCgGL_Native.cgGLDisableProgramProfiles)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLDisableProgramProfiles");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLDisableProgramProfiles(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGLSetDebugMode(CGbool debug)
{
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLSetDebugMode");

  if (!traceCgGL_Native.cgGLSetDebugMode)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLSetDebugMode");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("debug", "%d", debug);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCgGL_Native.cgGLSetDebugMode(debug);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGbuffer
cgGLCreateBuffer(CGcontext context, int size, const void *data, GLenum bufferUsage)
{
  CGbuffer ret = 0;
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLCreateBuffer");

  if (!traceCgGL_Native.cgGLCreateBuffer)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLCreateBuffer");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("context", "%zu", (size_t) context);
    traceInputParameter("size", "%d", size);
    traceInputParameter("data", "%c[%ld]", data, (traceCgGL_helperCgCreateBufferSize ? traceCgGL_helperCgCreateBufferSize(size) : 0));
    traceInputParameter("bufferUsage", "%u", bufferUsage);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCgGL_Native.cgGLCreateBuffer(context, size, data, bufferUsage);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT GLuint
cgGLGetBufferObject(CGbuffer buffer)
{
  GLuint ret = 0;
  int traceThis;

  if (!traceCgGL_initialized)
    traceCgGL_init();

  traceThis = traceEnabled("cgGLGetBufferObject");

  if (!traceCgGL_Native.cgGLGetBufferObject)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGLGetBufferObject");
    traceBegin();

    /* Encode input parameters. */

    traceInputParameter("buffer", "%zu", (size_t) buffer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCgGL_Native.cgGLGetBufferObject(buffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    traceReturn("%u", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}
