/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_SERVICEAFFECTSBIOSATTRIBUTEACCESS_H_
#define OPENDRIM_SERVICEAFFECTSBIOSATTRIBUTEACCESS_H_

#include "BIOS_Common.h"

#include "OpenDRIM_ServiceAffectsBIOSAttribute.h"
#include "assocOpenDRIM_ServiceAffectsBIOSAttribute.h"

int BIOS_OpenDRIM_ServiceAffectsBIOSAttribute_load(const CMPIBroker* broker, string& errorMessage);

int BIOS_OpenDRIM_ServiceAffectsBIOSAttribute_unload(string& errorMessage);

int BIOS_OpenDRIM_ServiceAffectsBIOSAttribute_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_ServiceAffectsBIOSAttribute>& instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_ServiceAffectsBIOSAttribute_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_ServiceAffectsBIOSAttribute& instance, const char** properties, string& errorMessage);

int BIOS_OpenDRIM_ServiceAffectsBIOSAttribute_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ServiceAffectsBIOSAttribute& newInstance, const OpenDRIM_ServiceAffectsBIOSAttribute& oldInstance, const char** properties, string& errorMessage);

int BIOS_OpenDRIM_ServiceAffectsBIOSAttribute_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ServiceAffectsBIOSAttribute& instance, string& errorMessage);

int BIOS_OpenDRIM_ServiceAffectsBIOSAttribute_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_ServiceAffectsBIOSAttribute& instance, string& errorMessage);

int BIOS_OpenDRIM_ServiceAffectsBIOSAttribute_associatorAffectedElementToAffectingElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectedElement_instance, const char** properties, vector<Instance>& AffectingElement_associatedInstances, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_ServiceAffectsBIOSAttribute_associatorAffectingElementToAffectedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectingElement_instance, const char** properties, vector<Instance>& AffectedElement_associatedInstances, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_ServiceAffectsBIOSAttribute_referenceAffectedElementToAffectingElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectedElement_instance, const vector<Instance>& AffectingElement_instances, vector<OpenDRIM_ServiceAffectsBIOSAttribute>& OpenDRIM_ServiceAffectsBIOSAttribute_instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_ServiceAffectsBIOSAttribute_referenceAffectingElementToAffectedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& AffectingElement_instance, const vector<Instance>& AffectedElement_instances, vector<OpenDRIM_ServiceAffectsBIOSAttribute>& OpenDRIM_ServiceAffectsBIOSAttribute_instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_ServiceAffectsBIOSAttribute_populate(OpenDRIM_ServiceAffectsBIOSAttribute& instance, string& errorMessage);

#endif /*OPENDRIM_SERVICEAFFECTSBIOSATTRIBUTEACCESS_H_*/
