/*###############################################################################
# Linux Management Providers (LMP), Power Supply provider package
# Copyright (C) 2009 Shakhrom RUSTAMOV, TUIT <shahrombek@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#include "cmpiOpenDRIM_PowerSupplyRedundancySet.h"

CMPIObjectPath* PowerSupply_OpenDRIM_PowerSupplyRedundancySet_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_PowerSupplyRedundancySet& instance) {
	_E_;
	Objectpath op(broker, OpenDRIM_PowerSupplyRedundancySet_classnames[0], OpenDRIM_PowerSupplyRedundancySet_NAMESPACE);

	if (!instance.InstanceID_isNULL)
		op.addKey("InstanceID", instance.InstanceID);

	_L_;
	return op.getHdl();
}

CMPIInstance* PowerSupply_OpenDRIM_PowerSupplyRedundancySet_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_PowerSupplyRedundancySet& instance) {
	_E_;
	Objectpath op(broker, PowerSupply_OpenDRIM_PowerSupplyRedundancySet_toCMPIObjectPath(broker, instance));
	Instance ci(broker, op);

	if (!instance.Caption_isNULL)
		ci.setProperty("Caption", instance.Caption);

	if (!instance.Description_isNULL)
		ci.setProperty("Description", instance.Description);

	if (!instance.ElementName_isNULL)
		ci.setProperty("ElementName", instance.ElementName);

	if (!instance.RedundancyStatus_isNULL)
		ci.setProperty("RedundancyStatus", instance.RedundancyStatus);

	if (!instance.TypeOfSet_isNULL)
		ci.setProperty("TypeOfSet", instance.TypeOfSet);

	if (!instance.MinNumberNeeded_isNULL)
		ci.setProperty("MinNumberNeeded", instance.MinNumberNeeded);

	if (!instance.MaxNumberSupported_isNULL)
		ci.setProperty("MaxNumberSupported", instance.MaxNumberSupported);

	if (!instance.VendorIdentifyingInfo_isNULL)
		ci.setProperty("VendorIdentifyingInfo", instance.VendorIdentifyingInfo);

	if (!instance.OtherTypeOfSet_isNULL)
		ci.setProperty("OtherTypeOfSet", instance.OtherTypeOfSet);

	if (!instance.LoadBalanceAlgorithm_isNULL)
		ci.setProperty("LoadBalanceAlgorithm", instance.LoadBalanceAlgorithm);

	if (!instance.OtherLoadBalanceAlgorithm_isNULL)
		ci.setProperty("OtherLoadBalanceAlgorithm", instance.OtherLoadBalanceAlgorithm);

	_L_;
	return ci.getHdl();
}

void PowerSupply_OpenDRIM_PowerSupplyRedundancySet_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_PowerSupplyRedundancySet& instance) {
	_E_;
	Objectpath op(broker, (CMPIObjectPath*) ref);

	if (op.getKey("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	_L_;
}

void PowerSupply_OpenDRIM_PowerSupplyRedundancySet_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_PowerSupplyRedundancySet& instance) {
	_E_;
	Instance inst(broker, (CMPIInstance*) ci);

	if (inst.getProperty("Caption", instance.Caption) == OK)
		instance.Caption_isNULL = false;

	if (inst.getProperty("Description", instance.Description) == OK)
		instance.Description_isNULL = false;

	if (inst.getProperty("ElementName", instance.ElementName) == OK)
		instance.ElementName_isNULL = false;

	if (inst.getProperty("InstanceID", instance.InstanceID) == OK)
		instance.InstanceID_isNULL = false;

	if (inst.getProperty("RedundancyStatus", instance.RedundancyStatus) == OK)
		instance.RedundancyStatus_isNULL = false;

	if (inst.getProperty("TypeOfSet", instance.TypeOfSet) == OK)
		instance.TypeOfSet_isNULL = false;

	if (inst.getProperty("MinNumberNeeded", instance.MinNumberNeeded) == OK)
		instance.MinNumberNeeded_isNULL = false;

	if (inst.getProperty("MaxNumberSupported", instance.MaxNumberSupported) == OK)
		instance.MaxNumberSupported_isNULL = false;

	if (inst.getProperty("VendorIdentifyingInfo", instance.VendorIdentifyingInfo) == OK)
		instance.VendorIdentifyingInfo_isNULL = false;

	if (inst.getProperty("OtherTypeOfSet", instance.OtherTypeOfSet) == OK)
		instance.OtherTypeOfSet_isNULL = false;

	if (inst.getProperty("LoadBalanceAlgorithm", instance.LoadBalanceAlgorithm) == OK)
		instance.LoadBalanceAlgorithm_isNULL = false;

	if (inst.getProperty("OtherLoadBalanceAlgorithm", instance.OtherLoadBalanceAlgorithm) == OK)
		instance.OtherLoadBalanceAlgorithm_isNULL = false;

	_L_;
}

void PowerSupply_OpenDRIM_PowerSupplyRedundancySet_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_PowerSupplyRedundancySet_Failover_In& args) {
	_E_;
	CMPIStatus rc;
	CMPIData data;

	Objectpath FailoverFrom;
	data = in->ft->getArg(in, "FailoverFrom", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, FailoverFrom);	
		args.setFailoverFrom(FailoverFrom);
	}			

	Objectpath FailoverTo;
	data = in->ft->getArg(in, "FailoverTo", &rc);
	if (rc.rc == OK) {
		CT_ToC(broker, data, FailoverTo);	
		args.setFailoverTo(FailoverTo);
	}			

	_L_;
}

