/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#include "OpenDRIM_SSHSettingDataAccess.h"

const string InstanceID = "OpenDRIM:SSHSettingData";

int SSH_OpenDRIM_SSHSettingData_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSettingData_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSettingData_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_SSHSettingData>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	if (!CF_isExist("/usr/sbin/sshd"))
		return OK;
	
	OpenDRIM_SSHSettingData instance;
	instance.setInstanceID(InstanceID);
	
	if (discriminant == "ei")
		CF_assert(SSH_OpenDRIM_SSHSettingData_populate(instance, errorMessage));
	
	result.push_back(instance);
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSettingData_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_SSHSettingData& instance, const char** properties, string& errorMessage) {
	_E_;
	if (instance.InstanceID != InstanceID ||
			!CF_isExist("/usr/sbin/sshd"))
	{
		errorMessage = "Invalid path";
		return NOT_FOUND;
	}
	
	CF_assert(SSH_OpenDRIM_SSHSettingData_populate(instance, errorMessage));
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHSettingData_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHSettingData& newInstance, const OpenDRIM_SSHSettingData& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_SSHSettingData_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHSettingData& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_SSHSettingData_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_SSHSettingData& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int SSH_OpenDRIM_SSHSettingData_populate(OpenDRIM_SSHSettingData& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] InstanceID [KEY]
	 * [X] ElementName
	 * [X] EnabledSSHVersions
	 * [X] SSHVersion
	 * [X] EnabledEncryptionAlgorithm
	 * [X] EncryptionAlgorithm
	 * [X] IdleTimeout
	 * [X] KeepAlive
	 * [X] ForwardX11
	 * [X] Compression
	 * + Conditional:
	 * [X] OtherEnabledSSHVersion
	 * [X] OtherSSHVersion
	 * [X] OtherEnabledEncryptionAlgorithm
	 * [X] OtherEncryptionAlgorithm
	 */

	instance.setElementName("SSH Service Settings");
	vector<unsigned short> enabledSSHVersions;
	string enabled_ssh_versions;
	CF_getConfigItem("Protocol", enabled_ssh_versions, errorMessage);

	if(enabled_ssh_versions == "1")
	{
		enabledSSHVersions.push_back(SSHV_SSHv1);
		instance.setEnabledSSHVersions(enabledSSHVersions);
		instance.setSSHVersion(SSHV_SSHv1);
	}
	else if (enabled_ssh_versions == "2")
	{
		enabledSSHVersions.push_back(SSHV_SSHv2);
		instance.setEnabledSSHVersions(enabledSSHVersions);
		instance.setSSHVersion(SSHV_SSHv2);
	}
	else if (enabled_ssh_versions == "1,2"||enabled_ssh_versions == "2,1"||enabled_ssh_versions == "")
	{
		enabledSSHVersions.push_back(SSHV_SSHv1);
		enabledSSHVersions.push_back(SSHV_SSHv2);
		instance.setEnabledSSHVersions(enabledSSHVersions);
		instance.setSSHVersion(SSHV_OTHER);
		
		vector<string> otherSSHVersion;
		otherSSHVersion.push_back("ssh1");
		otherSSHVersion.push_back("ssh2");
		instance.setOtherSSHVersion(otherSSHVersion);
	}
	else
	{
		enabledSSHVersions.push_back(SSHV_UNKNOWN);
		instance.setEnabledSSHVersions(enabledSSHVersions);
		instance.setSSHVersion(SSHV_UNKNOWN);
	}

	vector<unsigned short> enabledEncryptionAlgorithms;
	
	enabledEncryptionAlgorithms.push_back(OTHER);
	enabledEncryptionAlgorithms.push_back(DES3);
	enabledEncryptionAlgorithms.push_back(RC4);
	instance.setEnabledEncryptionAlgorithms(enabledEncryptionAlgorithms);
	
	vector<string> otherEnabledEncryptionAlgorithm;
	otherEnabledEncryptionAlgorithm.push_back("AES");
	otherEnabledEncryptionAlgorithm.push_back("BLOWFISH");
	otherEnabledEncryptionAlgorithm.push_back("CAST");
	instance.setOtherEnabledEncryptionAlgorithm(otherEnabledEncryptionAlgorithm);

	string encryptionAlgorithm;
	CF_getConfigItem("Ciphers", encryptionAlgorithm, errorMessage);

	instance.setEncryptionAlgorithm(OTHER);

	if (encryptionAlgorithm.size() != 0)
		instance.setOtherEncryptionAlgorithm(encryptionAlgorithm);
	else
	{
		string otherEncryptionAlgorithm = "aes128-cbc,3des-cbc,blowfish-cbc,cast128-cbc,arcfour128,arcfour256,arcfour,aes192-cbc,aes256-cbc,aes128-ctr,aes192-ctr,aes256-ctr";
		instance.setOtherEncryptionAlgorithm(otherEncryptionAlgorithm);
	}

	instance.setIdleTimeout(0);

	string config_str;
	CF_getConfigItem("KeepAlive",config_str, errorMessage);

	instance.setKeepAlive(!CF_startsWithNoCase(config_str, "no"));

	CF_getConfigItem("X11Forwarding", config_str, errorMessage);
	
	instance.setForwardX11(CF_startsWithNoCase(config_str, "yes"));

	CF_getConfigItem("Compression", config_str, errorMessage);

	instance.setCompression(!CF_startsWithNoCase(config_str, "no"));

	_L_;
	return OK;
}

